package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import com.sd.api.maps.DelDrawInMap
import com.sd.api.maps.DrawInMap
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.R
import com.sd.demo.databinding.ActivityControlBinding
import com.sd.demo.databinding.ActivityTmarkerBinding
import com.sd.demo.ui.TMarkerActivity

/**UI控件展示****/
class ControlActivity : AppCompatActivity() {

    private lateinit var binding: ActivityControlBinding

    var mapReadView: MapReadyView? = null

    private var show = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        enableEdgeToEdge()
        binding = ActivityControlBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@ControlActivity.mapReadView = mapReadyView
            }
        })
        binding.bt1.setOnClickListener {
            show=!show
            //显示指南针
            binding.mapMultiView.setCompassView(show)
        }
        binding.bt2.setOnClickListener {
            show=!show
            //显示比例尺
            binding.mapMultiView.setScaleControlsEnabled(show)
        }
        binding.bt3.setOnClickListener {
            show=!show
            //显示我的定位按钮
            binding.mapMultiView.setMyLocationButtonEnabled(show)
        }

    }
}