package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.MethodAdv
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityChangeMapCenterBinding

/***改变地图中心点**/
class ChangeMapCenterAct : AppCompatActivity() {

    private lateinit var binding: ActivityChangeMapCenterBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityChangeMapCenterBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@ChangeMapCenterAct.mapReadView = mapReadyView
            }
        })

        //获取接口功能实例
//        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.bt1.setOnClickListener {
            //改变地图中心点，第二个参数是纬度,第三个参数是经度
            MethodAdv.setMapCenter(binding.et1.text.toString().toDouble(),  binding.et2.text.toString().toDouble())
        }
        //改变缩放级别
        binding.bt2.setOnClickListener {
            var zoom = binding.et3.text.toString().toFloat()
            //改变缩放级别
            MethodAdv.setMapZoom(zoom)
        }
//        //设置地图边界范围
//        binding.bt3.setOnClickListener {
//            MSMethodAdv.setMapBoundArea(mapReadView)
//        }

    }


}