package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import com.amap.api.maps.AMap
import com.amap.api.maps.CameraUpdateFactory
import com.amap.api.maps.model.LatLng
import com.amap.api.maps.model.TileOverlayOptions
import com.sd.demo.HeritageScopeTileProvider
import com.sd.demo.LayerManage
import com.sd.demo.databinding.ActivityAmapWmsBinding


class AMapWmsActivity : AppCompatActivity() {
    lateinit var binding: ActivityAmapWmsBinding

    private var layerManage: LayerManage? = null

    private var aMap: AMap? = null

    //    var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp"
//    var url = "http://192.168.59.216:8080/smartmap/gwc/demo/yizhuang_avp?gridSet=EPSG:4326&format=image/png"
    var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        enableEdgeToEdge()
        binding = ActivityAmapWmsBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.mapView.onCreate(savedInstanceState)

        aMap = binding.mapView.map

        val tileProvider = HeritageScopeTileProvider(url)
        aMap!!.addTileOverlay(TileOverlayOptions().tileProvider(tileProvider).zIndex(1f))

        val latLng = LatLng(39.80913878, 116.50166926) //中心点坐标
        aMap!!.moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 16.0f))
//        layerManage = LayerManage(this, aMap)
//        layerManage?.addTileOverlay(url)
    }


    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        //在activity执行onSaveInstanceState时执行mapView.onSaveInstanceState (outState)，保存地图当前的状态
        binding.mapView.onSaveInstanceState(outState)
    }


    override fun onResume() {
        super.onResume()
        //在activity执行onResume时执行mapView.onResume ()，重新绘制加载地图
        binding.mapView.onResume()
    }

    override fun onPause() {
        super.onPause()
        //在activity执行onPause时执行mapView.onPause ()，暂停地图的绘制
        binding.mapView.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
        //在activity执行onDestroy时执行mapView.onDestroy()，销毁地图
        binding.mapView.onDestroy()
    }


}