package com.sd.demo

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.OnSdkInitCb
import com.sd.demo.adapter.DemoListAdapter
import com.sd.demo.databinding.ActivityMainBinding
import com.sd.demo.ui.CalculateDistanceActivity
import com.sd.demo.ui.ChangeMapCenterAct
import com.sd.demo.ui.ControlActivity
import com.sd.demo.ui.DisplayMapActivity
import com.sd.demo.ui.GestureDemo
import com.sd.demo.ui.OnLineMapActivity
import com.sd.demo.ui.PartRoadActivity
import com.sd.demo.ui.TCircelActivity
import com.sd.demo.ui.TDriveRouteActivity
import com.sd.demo.ui.TGpsActivity
import com.sd.demo.ui.THighMapActivity
import com.sd.demo.ui.TLayersActivity
import com.sd.demo.ui.TLineActivity
import com.sd.demo.ui.TMarkerActivity
import com.sd.demo.ui.TPoiSearchActivity
import com.sd.demo.ui.TPolygonActivity
import com.sd.demo.ui.TReGeocodeActivity
import com.sd.demo.ui.WmsActivity


/**
 * Main activity
 *
 * @constructor Create empty Main activity
 */
class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private var demoListAdapter = DemoListAdapter()


    /**
     * Demo details
     *
     * @property title
     * @property activityClass
     * @constructor Create empty Demo details
     */
    class DemoDetails(
        var title: String,
        var activityClass: Class<out Activity>?
    )

    private var demos = listOf(
        DemoDetails("展示地图", DisplayMapActivity::class.java),
        DemoDetails("切换地图图层", TLayersActivity::class.java),
//        DemoDetails("显示定位蓝点", ShowMyLocLandian::class.java),
        DemoDetails("手势控制", GestureDemo::class.java),
        DemoDetails("控件交互", ControlActivity::class.java),
        DemoDetails("改变地图中心点,缩放级别", ChangeMapCenterAct::class.java),
        DemoDetails("绘制Marker点", TMarkerActivity::class.java),
        DemoDetails("绘制一条线(实线、虚线)", TLineActivity::class.java),
        DemoDetails("绘制圆形", TCircelActivity::class.java),
        DemoDetails("绘制一个面", TPolygonActivity::class.java),
        DemoDetails("Poi检索（关键字，范围）", TPoiSearchActivity::class.java),
        DemoDetails("逆地理编码", TReGeocodeActivity::class.java),
        DemoDetails("两点间距离计算", CalculateDistanceActivity::class.java),
        DemoDetails("定位，获取我的位置", TGpsActivity::class.java),
//        DemoDetails("加载wms", AMapWmsActivity::class.java),
        DemoDetails("加载wms", WmsActivity::class.java),

        DemoDetails("驾车路线规划(导航)", TDriveRouteActivity::class.java),
        DemoDetails("测试业务类相关", null),
        DemoDetails("局部地图", PartRoadActivity::class.java),
        DemoDetails("高精地图", THighMapActivity::class.java),
        DemoDetails("在线地图", OnLineMapActivity::class.java),

//        DemoDetails("业务相关", null),
//        DemoDetails("在线地图显示小车", ShowCarOnlineActivity::class.java),

//        DemoDetails("测试高德加载WMS", AMapWmsActivity::class.java),

    )


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        initMap()

        binding.demoList.adapter = demoListAdapter
        demoListAdapter.submitList(demos)

        demoListAdapter.setOnItemClickListener { adapter, view, position ->
            val demo = adapter.getItem(position) as DemoDetails
            if (demo.activityClass != null) {
                startActivity(Intent(this, demo.activityClass))
            }
        }

//        binding.sp.onItemSelectedListener=object :AdapterView.OnItemSelectedListener{
//            override fun onItemSelected(
//                parent: AdapterView<*>?,
//                view: View?,
//                position: Int,
//                id: Long
//            ) {
//                var str=parent?.adapter?.getItem(position)
//                println("-------sp str = ${str}")
//                if (str?.equals("四维")==true){
//
//                }else if (str?.equals("高德")==true){
//
//                }
//            }
//
//            override fun onNothingSelected(parent: AdapterView<*>?) {
//
//            }
//        }

    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        println("----------MainActivity.onNewIntent")

    }


    /**
     * Init map
     *
     * @param type MINE=四维 AMAP=高德
     */
    fun initMap(type: MAP_TYPE = MAP_TYPE.MINE) {
        var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp"
//        var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?"
//        var url = "http://192.168.59.216:8080/smartmap/yizhuang/wms?service=WMS&version=1.1.0&request=GetMap&layers=yizhuang:yizhuang_avp&bbox=116.49796295166,39.8062019348145,116.505592346191,39.8120422363281&width=256&height=256&srs=EPSG:3857&styles=&format=image/png"
//        MSDKInitializer.setWmsUrl(url)
        MSDKInitializer.initialize(this, type, object : OnSdkInitCb {
            override fun onInitSuccess() {
                println("--------onMapInitSuccess")
            }

            override fun onInitFailed(msg: String) {
                println("--------onInitFailed $msg")
            }
        })
    }


}