/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap;

import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.amap.api.col.3nsl.np;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLMapRender
implements GLSurfaceView.Renderer {
    public static final int NORMAL_TICK_COUNT = 2;
    public static final int ANIMATION_TICK_COUNT = 10;
    public static final int LONG_TICK_COUNT = 6;
    public static final int LONG_LONG_TICK_COUNT = 30;
    static final int RENDER_FPS_MAX = 60;
    public static final int RENDER_FPS_NAVI = 10;
    public static final int RENDER_FPS_NORMAL = 15;
    public static final int RENDER_FPS_ANIMATION = 30;
    public static final int RENDER_FPS_GESTURE_ACTION = 40;
    static final long RENDER_TIMMER_DIFF_MIN = 16L;
    private static final int MAP_RENDER_MSG_SURFACE_RENDER = 10;
    private static final int MAP_RENDER_MSG_RUNNABLE_ONGLTHREAD = 100;
    public IAMap mGLMapView;
    static final String TAG = "render";
    private int mTargetFrameDurationMillis = 66;
    private float mTargetRenderFPS = 15.0f;
    private volatile boolean mIsRendPause = false;
    public volatile boolean mSurfacedestoryed = false;
    private HandlerThread mGLRenderThread = null;
    private Handler mGLRenderHandler = null;
    private long mLastFrameTime = System.currentTimeMillis();
    private boolean mIsTrafficMode = false;
    private volatile AtomicLong mDrawFrameTickCount = new AtomicLong(6L);

    public GLMapRender(IAMap iAMap) {
        this.mGLMapView = iAMap;
    }

    public void setTrafficMode(boolean bl2) {
        this.mIsTrafficMode = bl2;
    }

    public void resetTickCount(int n2) {
        long l2 = this.mDrawFrameTickCount.get();
        if (!this.mIsRendPause && this.mGLRenderThread != null && this.mGLRenderHandler != null && this.mGLRenderThread.isAlive()) {
            if (l2 <= 0L) {
                this.mDrawFrameTickCount.set(n2);
                this.mGLRenderHandler.removeMessages(10);
                this.mGLRenderHandler.sendEmptyMessage(10);
                return;
            }
            if (l2 < (long)n2) {
                this.mDrawFrameTickCount.set(n2);
                return;
            }
        } else if (l2 < (long)n2) {
            this.mDrawFrameTickCount.set(n2);
        }
    }

    public boolean isRenderPause() {
        return this.mIsRendPause;
    }

    public void setRenderFps(float f2) {
        if (this.mTargetRenderFPS != f2 && f2 > 0.0f) {
            this.mTargetFrameDurationMillis = (int)(1.0f / f2 * 1000.0f);
            this.mTargetRenderFPS = f2;
        }
    }

    public void sendToRenderEvent(Runnable runnable) {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.post(runnable);
        }
    }

    public void renderPause() {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.removeMessages(10);
        }
        this.mIsRendPause = true;
    }

    public void renderResume() {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.removeMessages(10);
        }
        this.mIsRendPause = false;
        this.mDrawFrameTickCount.set(-1L);
        this.resetTickCount(30);
    }

    public void onAttachedToWindow() {
        if (this.mGLRenderThread == null) {
            this.mGLRenderThread = new HandlerThread(" AMapGlRenderThread");
            this.mGLRenderThread.start();
            GLMapRender gLMapRender = this;
            this.mGLRenderHandler = new Handler(gLMapRender.mGLRenderThread.getLooper()){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 10: {
                            if (GLMapRender.this.mIsRendPause || GLMapRender.this.mGLMapView == null || GLMapRender.this.mGLMapView.getRenderMode() != 0) break;
                            GLMapRender.this.mGLMapView.requestRender();
                            return;
                        }
                        case 100: {
                            ((Runnable)message.obj).run();
                        }
                    }
                }
            };
        }
    }

    public void onDetachedFromWindow() {
        if (this.mGLRenderThread != null) {
            this.mGLRenderThread.quit();
            this.mGLRenderThread = null;
            this.mGLRenderHandler = null;
        }
    }

    private void drawSingleFrame(GL10 gL10) {
        try {
            this.mGLMapView.drawFrame(gL10);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void onDrawFrame(GL10 gL10) {
        if (this.mGLMapView == null) {
            return;
        }
        try {
            this.mLastFrameTime = System.currentTimeMillis();
            this.drawSingleFrame(gL10);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.mLastFrameTime;
            this.mLastFrameTime = l2;
            long l4 = this.mDrawFrameTickCount.get();
            if (this.mGLMapView.getRenderMode() == 0 && this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
                long l5;
                this.mDrawFrameTickCount.set(--l4);
                if (l4 <= 0L) {
                    if (l4 > -5L) {
                        l5 = 60L;
                    } else if (l4 > -7L) {
                        l5 = 100L;
                    } else if (l4 > -9L) {
                        l5 = 250L;
                    } else {
                        l5 = this.mIsTrafficMode ? 10000L : 500L;
                        this.mDrawFrameTickCount.set(-9L);
                    }
                } else {
                    l5 = Math.max(16L, (long)this.mTargetFrameDurationMillis - l3);
                }
                if (l5 > 0L && this.mGLRenderHandler != null) {
                    this.mGLRenderHandler.removeMessages(10);
                    this.mGLRenderHandler.sendEmptyMessageDelayed(10, l5);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            np.c(throwable, "GLMapRender", "onDrawFrame");
            return;
        }
    }

    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        if (this.mSurfacedestoryed) {
            this.onSurfaceCreated(gL10, null);
        }
        this.mGLMapView.changeSurface(gL10, n2, n3);
        this.resetTickCount(30);
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.mIsRendPause = false;
        this.mSurfacedestoryed = false;
        this.mGLMapView.createSurface(gL10, eGLConfig);
    }

    public void onSurfaceDestory() {
        this.mIsRendPause = true;
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null) {
            this.mGLRenderHandler.removeCallbacksAndMessages(null);
        }
        int n2 = this.mGLMapView.getNativeEngineID();
        this.mGLMapView.destroySurface(n2);
        this.mSurfacedestoryed = true;
    }
}

