/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import android.graphics.Matrix;
import android.util.Log;
import android.util.Xml;
import com.autonavi.ae.svg.CSSParser;
import com.autonavi.ae.svg.IntegerParser;
import com.autonavi.ae.svg.NumberParser;
import com.autonavi.ae.svg.PreserveAspectRatio;
import com.autonavi.ae.svg.SVG;
import com.autonavi.ae.svg.SVGParseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class SVGParser {
    private static final String TAG = "SVGParser";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String FEATURE_STRING_PREFIX = "http://www.w3.org/TR/SVG11/feature#";
    private static final String XML_STYLESHEET_PROCESSING_INSTRUCTION = "xml-stylesheet";
    public static final String XML_STYLESHEET_ATTR_TYPE = "type";
    public static final String XML_STYLESHEET_ATTR_ALTERNATE = "alternate";
    public static final String XML_STYLESHEET_ATTR_HREF = "href";
    public static final String XML_STYLESHEET_ATTR_MEDIA = "media";
    public static final String XML_STYLESHEET_ATTR_MEDIA_ALL = "all";
    public static final String XML_STYLESHEET_ATTR_ALTERNATE_NO = "no";
    public static final int ENTITY_WATCH_BUFFER_SIZE = 4096;
    private SVG svgDocument = null;
    private SVG.SvgContainer currentElement = null;
    private boolean ignoring = false;
    private int ignoreDepth;
    private boolean inMetadataElement = false;
    private SVGElem metadataTag = null;
    private StringBuilder metadataElementContents = null;
    private boolean inStyleElement = false;
    private StringBuilder styleElementContents = null;
    private static final String NONE = "none";
    private static final String CURRENTCOLOR = "currentColor";
    private static final String VALID_DISPLAY_VALUES = "|inline|block|list-item|run-in|compact|marker|table|inline-table|table-row-group|table-header-group|table-footer-group|table-row|table-column-group|table-column|table-cell|table-caption|none|";
    private static final String VALID_VISIBILITY_VALUES = "|visible|hidden|collapse|";

    SVGParser() {
    }

    SVG parse(InputStream inputStream, boolean bl2) throws SVGParseException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(3);
            int n2 = inputStream.read() + (inputStream.read() << 8);
            inputStream.reset();
            if (n2 == 35615) {
                inputStream = new BufferedInputStream(new GZIPInputStream(inputStream));
            }
        }
        catch (IOException iOException) {}
        try {
            inputStream.mark(4096);
            this.parseUsingXmlPullParser(inputStream, bl2);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)"Exception thrown closing input stream");
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Exception thrown closing input stream");
        }
        return this.svgDocument;
    }

    private void parseUsingXmlPullParser(InputStream inputStream, boolean bl2) throws SVGParseException {
        try {
            XmlPullParser xmlPullParser = Xml.newPullParser();
            XPPAttributesWrapper xPPAttributesWrapper = new XPPAttributesWrapper(xmlPullParser);
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", false);
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput(inputStream, null);
            int n2 = xmlPullParser.getEventType();
            while (n2 != 1) {
                switch (n2) {
                    case 0: {
                        this.startDocument();
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        String string2 = xmlPullParser.getName();
                        if (xmlPullParser.getPrefix() != null) {
                            string2 = xmlPullParser.getPrefix() + ':' + string2;
                        }
                        this.startElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), string2, xPPAttributesWrapper);
                        break;
                    }
                    case 3: {
                        String string3 = xmlPullParser.getName();
                        if (xmlPullParser.getPrefix() != null) {
                            string3 = xmlPullParser.getPrefix() + ':' + string3;
                        }
                        this.endElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), string3);
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[2];
                        Object object = xmlPullParser.getTextCharacters(nArray);
                        this.text((char[])object, nArray[0], nArray[1]);
                        break;
                    }
                    case 5: {
                        this.text(xmlPullParser.getText());
                        break;
                    }
                    case 8: {
                        new StringBuilder("PROC INSTR: ").append(xmlPullParser.getText());
                        TextScanner textScanner = new TextScanner(xmlPullParser.getText());
                        Object object = textScanner.nextToken();
                        this.handleProcessingInstruction((String)object, this.parseProcessingInstructionAttributes(textScanner));
                        break;
                    }
                    case 10: {
                        if (!bl2 || this.svgDocument.getRootElement() != null || !xmlPullParser.getText().contains("<!ENTITY ")) break;
                        try {
                            inputStream.reset();
                            this.parseUsingSAX(inputStream);
                            return;
                        }
                        catch (IOException iOException) {
                            return;
                        }
                    }
                }
                n2 = xmlPullParser.nextToken();
            }
            this.endDocument();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new SVGParseException("XML parser problem", (Exception)((Object)xmlPullParserException));
        }
        catch (IOException iOException) {
            throw new SVGParseException("Stream error", iOException);
        }
    }

    private void parseUsingSAX(InputStream inputStream) throws SVGParseException {
        try {
            Object object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((SAXParserFactory)object).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            object = ((SAXParserFactory)object).newSAXParser().getXMLReader();
            SAXHandler sAXHandler = new SAXHandler();
            object.setContentHandler(sAXHandler);
            object.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
            object.parse(new InputSource(inputStream));
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SVGParseException("XML parser problem", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new SVGParseException("SVG parse error", sAXException);
        }
        catch (IOException iOException) {
            throw new SVGParseException("Stream error", iOException);
        }
    }

    private void startDocument() {
        this.svgDocument = new SVG();
    }

    private void startElement(String object, String string2, String string3, Attributes attributes) throws SVGParseException {
        if (this.ignoring) {
            ++this.ignoreDepth;
            return;
        }
        if (SVG_NAMESPACE.equals(object) || "".equals(object)) {
            object = SVGElem.fromString(string2.length() > 0 ? string2 : string3);
            switch (1.$SwitchMap$com$autonavi$ae$svg$SVGParser$SVGElem[((Enum)object).ordinal()]) {
                case 1: {
                    this.svg(attributes);
                    return;
                }
                case 2: 
                case 3: {
                    this.g(attributes);
                    return;
                }
                case 4: {
                    this.defs(attributes);
                    return;
                }
                case 5: {
                    this.use(attributes);
                    return;
                }
                case 6: {
                    this.path(attributes);
                    return;
                }
                case 7: {
                    this.rect(attributes);
                    return;
                }
                case 8: {
                    this.circle(attributes);
                    return;
                }
                case 9: {
                    this.ellipse(attributes);
                    return;
                }
                case 10: {
                    this.line(attributes);
                    return;
                }
                case 11: {
                    this.polyline(attributes);
                    return;
                }
                case 12: {
                    this.polygon(attributes);
                    return;
                }
                case 13: {
                    this.text(attributes);
                    return;
                }
                case 14: {
                    this.tspan(attributes);
                    return;
                }
                case 15: {
                    this.tref(attributes);
                    return;
                }
                case 16: {
                    this.zwitch(attributes);
                    return;
                }
                case 17: {
                    this.symbol(attributes);
                    return;
                }
                case 18: {
                    this.marker(attributes);
                    return;
                }
                case 19: {
                    this.linearGradient(attributes);
                    return;
                }
                case 20: {
                    this.radialGradient(attributes);
                    return;
                }
                case 21: {
                    this.stop(attributes);
                    return;
                }
                case 22: 
                case 23: {
                    this.inMetadataElement = true;
                    this.metadataTag = object;
                    return;
                }
                case 24: {
                    this.clipPath(attributes);
                    return;
                }
                case 25: {
                    this.textPath(attributes);
                    return;
                }
                case 26: {
                    this.pattern(attributes);
                    return;
                }
                case 27: {
                    this.image(attributes);
                    return;
                }
                case 28: {
                    this.view(attributes);
                    return;
                }
                case 29: {
                    this.mask(attributes);
                    return;
                }
                case 30: {
                    this.style(attributes);
                    return;
                }
                case 31: {
                    this.solidColor(attributes);
                    return;
                }
            }
            this.ignoring = true;
            this.ignoreDepth = 1;
        }
    }

    private void text(String string2) throws SVGParseException {
        if (!this.ignoring) {
            if (this.inMetadataElement) {
                if (this.metadataElementContents == null) {
                    this.metadataElementContents = new StringBuilder(string2.length());
                }
                this.metadataElementContents.append(string2);
                return;
            }
            if (this.inStyleElement) {
                if (this.styleElementContents == null) {
                    this.styleElementContents = new StringBuilder(string2.length());
                }
                this.styleElementContents.append(string2);
                return;
            }
            if (this.currentElement instanceof SVG.TextContainer) {
                this.appendToTextContainer(string2);
            }
        }
    }

    private void text(char[] cArray, int n2, int n3) throws SVGParseException {
        if (!this.ignoring) {
            if (this.inMetadataElement) {
                if (this.metadataElementContents == null) {
                    this.metadataElementContents = new StringBuilder(n3);
                }
                this.metadataElementContents.append(cArray, n2, n3);
                return;
            }
            if (this.inStyleElement) {
                if (this.styleElementContents == null) {
                    this.styleElementContents = new StringBuilder(n3);
                }
                this.styleElementContents.append(cArray, n2, n3);
                return;
            }
            if (this.currentElement instanceof SVG.TextContainer) {
                this.appendToTextContainer(new String(cArray, n2, n3));
            }
        }
    }

    private void appendToTextContainer(String string2) throws SVGParseException {
        SVG.SvgObject svgObject = (SVG.SvgConditionalContainer)this.currentElement;
        int n2 = svgObject.children.size();
        svgObject = n2 == 0 ? null : svgObject.children.get(n2 - 1);
        if (svgObject instanceof SVG.TextSequence) {
            ((SVG.TextSequence)svgObject).text = ((SVG.TextSequence)svgObject).text + string2;
            return;
        }
        this.currentElement.addChild(new SVG.TextSequence(string2));
    }

    private void endElement(String string2, String string3, String string4) throws SVGParseException {
        if (this.ignoring && --this.ignoreDepth == 0) {
            this.ignoring = false;
            return;
        }
        if (SVG_NAMESPACE.equals(string2) || "".equals(string2)) {
            string2 = string3.length() > 0 ? string3 : string4;
            switch (SVGElem.fromString(string2)) {
                case svg: 
                case g: 
                case defs: 
                case use: 
                case text: 
                case tspan: 
                case SWITCH: 
                case symbol: 
                case marker: 
                case linearGradient: 
                case radialGradient: 
                case stop: 
                case clipPath: 
                case textPath: 
                case pattern: 
                case image: 
                case view: 
                case mask: 
                case solidColor: {
                    this.currentElement = ((SVG.SvgObject)((Object)this.currentElement)).parent;
                }
                default: {
                    return;
                }
                case title: 
                case desc: {
                    this.inMetadataElement = false;
                    if (this.metadataElementContents != null) {
                        if (this.metadataTag == SVGElem.title) {
                            this.svgDocument.setTitle(this.metadataElementContents.toString());
                        } else if (this.metadataTag == SVGElem.desc) {
                            this.svgDocument.setDesc(this.metadataElementContents.toString());
                        }
                        this.metadataElementContents.setLength(0);
                    }
                    return;
                }
                case style: 
            }
            if (this.styleElementContents != null) {
                this.inStyleElement = false;
                SVGParser sVGParser = this;
                sVGParser.parseCSSStyleSheet(sVGParser.styleElementContents.toString());
                this.styleElementContents.setLength(0);
                return;
            }
        }
    }

    private void endDocument() {
    }

    private void handleProcessingInstruction(String string2, Map<String, String> object) {
        if (string2.equals(XML_STYLESHEET_PROCESSING_INSTRUCTION) && SVG.getFileResolver() != null) {
            if (object.get(XML_STYLESHEET_ATTR_TYPE) != null && !"text/css".equals(object.get(XML_STYLESHEET_ATTR_TYPE))) {
                return;
            }
            if (object.get(XML_STYLESHEET_ATTR_ALTERNATE) != null && !XML_STYLESHEET_ATTR_ALTERNATE_NO.equals(object.get(XML_STYLESHEET_ATTR_ALTERNATE))) {
                return;
            }
            string2 = object.get(XML_STYLESHEET_ATTR_HREF);
            if (string2 != null) {
                string2 = SVG.getFileResolver().resolveCSSStyleSheet(string2);
                if (string2 == null) {
                    return;
                }
                if ((object = object.get(XML_STYLESHEET_ATTR_MEDIA)) != null && !XML_STYLESHEET_ATTR_MEDIA_ALL.equals(((String)object).trim())) {
                    string2 = "@media " + (String)object + " { " + string2 + "}";
                }
                this.parseCSSStyleSheet(string2);
            }
        }
    }

    private Map<String, String> parseProcessingInstructionAttributes(TextScanner textScanner) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        textScanner.skipWhitespace();
        String string2 = textScanner.nextToken('=');
        while (string2 != null) {
            textScanner.consume('=');
            String string3 = textScanner.nextQuotedString();
            hashMap.put(string2, string3);
            textScanner.skipWhitespace();
            string2 = textScanner.nextToken('=');
        }
        return hashMap;
    }

    private void dumpNode(SVG.SvgObject object, String string2) {
        new StringBuilder().append(string2).append(object);
        if (object instanceof SVG.SvgConditionalContainer) {
            string2 = string2 + "  ";
            for (SVG.SvgObject svgObject : ((SVG.SvgConditionalContainer)object).children) {
                this.dumpNode(svgObject, string2);
            }
        }
    }

    private void debug(String string2, Object ... objectArray) {
    }

    private void svg(Attributes attributes) throws SVGParseException {
        this.debug("<svg>", new Object[0]);
        SVG.Svg svg = new SVG.Svg();
        new SVG.Svg().document = this.svgDocument;
        svg.parent = this.currentElement;
        this.parseAttributesCore(svg, attributes);
        this.parseAttributesStyle(svg, attributes);
        this.parseAttributesConditional(svg, attributes);
        this.parseAttributesViewBox(svg, attributes);
        this.parseAttributesSVG(svg, attributes);
        if (this.currentElement == null) {
            this.svgDocument.setRootElement(svg);
        } else {
            this.currentElement.addChild(svg);
        }
        this.currentElement = svg;
    }

    private void parseAttributesSVG(SVG.Svg svg, Attributes attributes) throws SVGParseException {
        block7: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    svg.x = SVGParser.parseLength(string2);
                    continue block7;
                }
                case y: {
                    svg.y = SVGParser.parseLength(string2);
                    continue block7;
                }
                case width: {
                    svg.width = SVGParser.parseLength(string2);
                    if (!svg.width.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <svg> element. width cannot be negative");
                }
                case height: {
                    svg.height = SVGParser.parseLength(string2);
                    if (!svg.height.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <svg> element. height cannot be negative");
                }
                case version: {
                    svg.version = string2;
                }
            }
        }
    }

    private void g(Attributes attributes) throws SVGParseException {
        this.debug("<g>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Group group = new SVG.Group();
        new SVG.Group().document = this.svgDocument;
        group.parent = this.currentElement;
        this.parseAttributesCore(group, attributes);
        this.parseAttributesStyle(group, attributes);
        this.parseAttributesTransform(group, attributes);
        this.parseAttributesConditional(group, attributes);
        this.currentElement.addChild(group);
        this.currentElement = group;
    }

    private void defs(Attributes attributes) throws SVGParseException {
        this.debug("<defs>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Defs defs = new SVG.Defs();
        new SVG.Defs().document = this.svgDocument;
        defs.parent = this.currentElement;
        this.parseAttributesCore(defs, attributes);
        this.parseAttributesStyle(defs, attributes);
        this.parseAttributesTransform(defs, attributes);
        this.currentElement.addChild(defs);
        this.currentElement = defs;
    }

    private void use(Attributes attributes) throws SVGParseException {
        this.debug("<use>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Use use = new SVG.Use();
        new SVG.Use().document = this.svgDocument;
        use.parent = this.currentElement;
        this.parseAttributesCore(use, attributes);
        this.parseAttributesStyle(use, attributes);
        this.parseAttributesTransform(use, attributes);
        this.parseAttributesConditional(use, attributes);
        this.parseAttributesUse(use, attributes);
        this.currentElement.addChild(use);
        this.currentElement = use;
    }

    private void parseAttributesUse(SVG.Use use, Attributes attributes) throws SVGParseException {
        block7: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    use.x = SVGParser.parseLength(string2);
                    continue block7;
                }
                case y: {
                    use.y = SVGParser.parseLength(string2);
                    continue block7;
                }
                case width: {
                    use.width = SVGParser.parseLength(string2);
                    if (!use.width.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    use.height = SVGParser.parseLength(string2);
                    if (use.height.isNegative()) {
                        throw new SVGParseException("Invalid <use> element. height cannot be negative");
                    }
                }
                default: {
                    continue block7;
                }
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block7;
                    use.href = string2;
                }
            }
        }
    }

    private void image(Attributes attributes) throws SVGParseException {
        this.debug("<image>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Image image = new SVG.Image();
        new SVG.Image().document = this.svgDocument;
        image.parent = this.currentElement;
        this.parseAttributesCore(image, attributes);
        this.parseAttributesStyle(image, attributes);
        this.parseAttributesTransform(image, attributes);
        this.parseAttributesConditional(image, attributes);
        this.parseAttributesImage(image, attributes);
        this.currentElement.addChild(image);
        this.currentElement = image;
    }

    private void parseAttributesImage(SVG.Image image, Attributes attributes) throws SVGParseException {
        block8: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    image.x = SVGParser.parseLength(string2);
                    continue block8;
                }
                case y: {
                    image.y = SVGParser.parseLength(string2);
                    continue block8;
                }
                case width: {
                    image.width = SVGParser.parseLength(string2);
                    if (!image.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    image.height = SVGParser.parseLength(string2);
                    if (image.height.isNegative()) {
                        throw new SVGParseException("Invalid <use> element. height cannot be negative");
                    }
                }
                default: {
                    continue block8;
                }
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block8;
                    image.href = string2;
                    continue block8;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(image, string2);
                }
            }
        }
    }

    private void path(Attributes attributes) throws SVGParseException {
        this.debug("<path>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Path path = new SVG.Path();
        new SVG.Path().document = this.svgDocument;
        path.parent = this.currentElement;
        this.parseAttributesCore(path, attributes);
        this.parseAttributesStyle(path, attributes);
        this.parseAttributesTransform(path, attributes);
        this.parseAttributesConditional(path, attributes);
        this.parseAttributesPath(path, attributes);
        this.currentElement.addChild(path);
    }

    private void parseAttributesPath(SVG.Path path, Attributes attributes) throws SVGParseException {
        block4: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case d: {
                    path.d = SVGParser.parsePath(string2);
                    continue block4;
                }
                case pathLength: {
                    path.pathLength = Float.valueOf(SVGParser.parseFloat(string2));
                    if (!(path.pathLength.floatValue() < 0.0f)) continue block4;
                    throw new SVGParseException("Invalid <path> element. pathLength cannot be negative");
                }
            }
        }
    }

    private void rect(Attributes attributes) throws SVGParseException {
        this.debug("<rect>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Rect rect = new SVG.Rect();
        new SVG.Rect().document = this.svgDocument;
        rect.parent = this.currentElement;
        this.parseAttributesCore(rect, attributes);
        this.parseAttributesStyle(rect, attributes);
        this.parseAttributesTransform(rect, attributes);
        this.parseAttributesConditional(rect, attributes);
        this.parseAttributesRect(rect, attributes);
        this.currentElement.addChild(rect);
    }

    private void parseAttributesRect(SVG.Rect rect, Attributes attributes) throws SVGParseException {
        block8: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    rect.x = SVGParser.parseLength(string2);
                    continue block8;
                }
                case y: {
                    rect.y = SVGParser.parseLength(string2);
                    continue block8;
                }
                case width: {
                    rect.width = SVGParser.parseLength(string2);
                    if (!rect.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. width cannot be negative");
                }
                case height: {
                    rect.height = SVGParser.parseLength(string2);
                    if (rect.height.isNegative()) {
                        throw new SVGParseException("Invalid <rect> element. height cannot be negative");
                    }
                }
                default: {
                    continue block8;
                }
                case rx: {
                    rect.rx = SVGParser.parseLength(string2);
                    if (!rect.rx.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. rx cannot be negative");
                }
                case ry: {
                    rect.ry = SVGParser.parseLength(string2);
                    if (!rect.ry.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. ry cannot be negative");
                }
            }
        }
    }

    private void circle(Attributes attributes) throws SVGParseException {
        this.debug("<circle>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Circle circle = new SVG.Circle();
        new SVG.Circle().document = this.svgDocument;
        circle.parent = this.currentElement;
        this.parseAttributesCore(circle, attributes);
        this.parseAttributesStyle(circle, attributes);
        this.parseAttributesTransform(circle, attributes);
        this.parseAttributesConditional(circle, attributes);
        this.parseAttributesCircle(circle, attributes);
        this.currentElement.addChild(circle);
    }

    private void parseAttributesCircle(SVG.Circle circle, Attributes attributes) throws SVGParseException {
        block5: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case cx: {
                    circle.cx = SVGParser.parseLength(string2);
                    continue block5;
                }
                case cy: {
                    circle.cy = SVGParser.parseLength(string2);
                    continue block5;
                }
                case r: {
                    circle.r = SVGParser.parseLength(string2);
                    if (!circle.r.isNegative()) continue block5;
                    throw new SVGParseException("Invalid <circle> element. r cannot be negative");
                }
            }
        }
    }

    private void ellipse(Attributes attributes) throws SVGParseException {
        this.debug("<ellipse>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Ellipse ellipse = new SVG.Ellipse();
        new SVG.Ellipse().document = this.svgDocument;
        ellipse.parent = this.currentElement;
        this.parseAttributesCore(ellipse, attributes);
        this.parseAttributesStyle(ellipse, attributes);
        this.parseAttributesTransform(ellipse, attributes);
        this.parseAttributesConditional(ellipse, attributes);
        this.parseAttributesEllipse(ellipse, attributes);
        this.currentElement.addChild(ellipse);
    }

    private void parseAttributesEllipse(SVG.Ellipse ellipse, Attributes attributes) throws SVGParseException {
        block6: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case rx: {
                    ellipse.rx = SVGParser.parseLength(string2);
                    if (!ellipse.rx.isNegative()) continue block6;
                    throw new SVGParseException("Invalid <ellipse> element. rx cannot be negative");
                }
                case ry: {
                    ellipse.ry = SVGParser.parseLength(string2);
                    if (!ellipse.ry.isNegative()) continue block6;
                    throw new SVGParseException("Invalid <ellipse> element. ry cannot be negative");
                }
                case cx: {
                    ellipse.cx = SVGParser.parseLength(string2);
                    continue block6;
                }
                case cy: {
                    ellipse.cy = SVGParser.parseLength(string2);
                }
            }
        }
    }

    private void line(Attributes attributes) throws SVGParseException {
        this.debug("<line>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Line line = new SVG.Line();
        new SVG.Line().document = this.svgDocument;
        line.parent = this.currentElement;
        this.parseAttributesCore(line, attributes);
        this.parseAttributesStyle(line, attributes);
        this.parseAttributesTransform(line, attributes);
        this.parseAttributesConditional(line, attributes);
        this.parseAttributesLine(line, attributes);
        this.currentElement.addChild(line);
    }

    private void parseAttributesLine(SVG.Line line, Attributes attributes) throws SVGParseException {
        block6: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x1: {
                    line.x1 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case y1: {
                    line.y1 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case x2: {
                    line.x2 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case y2: {
                    line.y2 = SVGParser.parseLength(string2);
                }
            }
        }
    }

    private void polyline(Attributes attributes) throws SVGParseException {
        this.debug("<polyline>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.PolyLine polyLine = new SVG.PolyLine();
        new SVG.PolyLine().document = this.svgDocument;
        polyLine.parent = this.currentElement;
        this.parseAttributesCore(polyLine, attributes);
        this.parseAttributesStyle(polyLine, attributes);
        this.parseAttributesTransform(polyLine, attributes);
        this.parseAttributesConditional(polyLine, attributes);
        this.parseAttributesPolyLine(polyLine, attributes, "polyline");
        this.currentElement.addChild(polyLine);
    }

    private void parseAttributesPolyLine(SVG.PolyLine polyLine, Attributes attributes, String string2) throws SVGParseException {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            float f2;
            if (SVGAttr.fromString(attributes.getLocalName(i2)) != SVGAttr.points) continue;
            Object object = new TextScanner(attributes.getValue(i2));
            ArrayList<Float> arrayList = new ArrayList<Float>();
            ((TextScanner)object).skipWhitespace();
            while (!((TextScanner)object).empty()) {
                float f3 = ((TextScanner)object).nextFloat();
                if (Float.isNaN(f3)) {
                    throw new SVGParseException("Invalid <" + string2 + "> points attribute. Non-coordinate content found in list.");
                }
                ((TextScanner)object).skipCommaWhitespace();
                f2 = ((TextScanner)object).nextFloat();
                if (Float.isNaN(f2)) {
                    throw new SVGParseException("Invalid <" + string2 + "> points attribute. There should be an even number of coordinates.");
                }
                ((TextScanner)object).skipCommaWhitespace();
                arrayList.add(Float.valueOf(f3));
                arrayList.add(Float.valueOf(f2));
            }
            polyLine.points = new float[arrayList.size()];
            int n2 = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                f2 = ((Float)object.next()).floatValue();
                polyLine.points[n2++] = f2;
            }
        }
    }

    private void polygon(Attributes attributes) throws SVGParseException {
        this.debug("<polygon>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Polygon polygon = new SVG.Polygon();
        new SVG.Polygon().document = this.svgDocument;
        polygon.parent = this.currentElement;
        this.parseAttributesCore(polygon, attributes);
        this.parseAttributesStyle(polygon, attributes);
        this.parseAttributesTransform(polygon, attributes);
        this.parseAttributesConditional(polygon, attributes);
        this.parseAttributesPolyLine(polygon, attributes, "polygon");
        this.currentElement.addChild(polygon);
    }

    private void text(Attributes attributes) throws SVGParseException {
        this.debug("<text>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Text text = new SVG.Text();
        new SVG.Text().document = this.svgDocument;
        text.parent = this.currentElement;
        this.parseAttributesCore(text, attributes);
        this.parseAttributesStyle(text, attributes);
        this.parseAttributesTransform(text, attributes);
        this.parseAttributesConditional(text, attributes);
        this.parseAttributesTextPosition(text, attributes);
        this.currentElement.addChild(text);
        this.currentElement = text;
    }

    private void parseAttributesTextPosition(SVG.TextPositionedContainer textPositionedContainer, Attributes attributes) throws SVGParseException {
        block6: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    textPositionedContainer.x = SVGParser.parseLengthList(string2);
                    continue block6;
                }
                case y: {
                    textPositionedContainer.y = SVGParser.parseLengthList(string2);
                    continue block6;
                }
                case dx: {
                    textPositionedContainer.dx = SVGParser.parseLengthList(string2);
                    continue block6;
                }
                case dy: {
                    textPositionedContainer.dy = SVGParser.parseLengthList(string2);
                }
            }
        }
    }

    private void tspan(Attributes attributes) throws SVGParseException {
        this.debug("<tspan>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SVGParseException("Invalid document. <tspan> elements are only valid inside <text> or other <tspan> elements.");
        }
        SVG.TSpan tSpan = new SVG.TSpan();
        new SVG.TSpan().document = this.svgDocument;
        tSpan.parent = this.currentElement;
        this.parseAttributesCore(tSpan, attributes);
        this.parseAttributesStyle(tSpan, attributes);
        this.parseAttributesConditional(tSpan, attributes);
        this.parseAttributesTextPosition(tSpan, attributes);
        this.currentElement.addChild(tSpan);
        this.currentElement = tSpan;
        if (tSpan.parent instanceof SVG.TextRoot) {
            SVG.TSpan tSpan2 = tSpan;
            tSpan2.setTextRoot((SVG.TextRoot)((Object)tSpan2.parent));
            return;
        }
        SVG.TSpan tSpan3 = tSpan;
        tSpan3.setTextRoot(((SVG.TextChild)((Object)tSpan3.parent)).getTextRoot());
    }

    private void tref(Attributes attributes) throws SVGParseException {
        this.debug("<tref>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SVGParseException("Invalid document. <tref> elements are only valid inside <text> or <tspan> elements.");
        }
        SVG.TRef tRef = new SVG.TRef();
        new SVG.TRef().document = this.svgDocument;
        tRef.parent = this.currentElement;
        this.parseAttributesCore(tRef, attributes);
        this.parseAttributesStyle(tRef, attributes);
        this.parseAttributesConditional(tRef, attributes);
        this.parseAttributesTRef(tRef, attributes);
        this.currentElement.addChild(tRef);
        if (tRef.parent instanceof SVG.TextRoot) {
            SVG.TRef tRef2 = tRef;
            tRef2.setTextRoot((SVG.TextRoot)((Object)tRef2.parent));
            return;
        }
        SVG.TRef tRef3 = tRef;
        tRef3.setTextRoot(((SVG.TextChild)((Object)tRef3.parent)).getTextRoot());
    }

    private void parseAttributesTRef(SVG.TRef tRef, Attributes attributes) {
        block3: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block3;
                    tRef.href = string2;
                }
            }
        }
    }

    private void zwitch(Attributes attributes) throws SVGParseException {
        this.debug("<switch>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Switch switch_ = new SVG.Switch();
        new SVG.Switch().document = this.svgDocument;
        switch_.parent = this.currentElement;
        this.parseAttributesCore(switch_, attributes);
        this.parseAttributesStyle(switch_, attributes);
        this.parseAttributesTransform(switch_, attributes);
        this.parseAttributesConditional(switch_, attributes);
        this.currentElement.addChild(switch_);
        this.currentElement = switch_;
    }

    private void parseAttributesConditional(SVG.SvgConditional svgConditional, Attributes attributes) throws SVGParseException {
        block7: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            HashSet<String> hashSet = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case requiredFeatures: {
                    svgConditional.setRequiredFeatures(SVGParser.parseRequiredFeatures((String)((Object)hashSet)));
                    continue block7;
                }
                case requiredExtensions: {
                    svgConditional.setRequiredExtensions((String)((Object)hashSet));
                    continue block7;
                }
                case systemLanguage: {
                    svgConditional.setSystemLanguage(SVGParser.parseSystemLanguage((String)((Object)hashSet)));
                    continue block7;
                }
                case requiredFormats: {
                    svgConditional.setRequiredFormats(SVGParser.parseRequiredFormats((String)((Object)hashSet)));
                    continue block7;
                }
                case requiredFonts: {
                    hashSet = SVGParser.parseFontFamily((String)((Object)hashSet));
                    hashSet = hashSet != null ? new HashSet<String>(hashSet) : new HashSet(0);
                    svgConditional.setRequiredFonts(hashSet);
                }
            }
        }
    }

    private void symbol(Attributes attributes) throws SVGParseException {
        this.debug("<symbol>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Symbol symbol = new SVG.Symbol();
        new SVG.Symbol().document = this.svgDocument;
        symbol.parent = this.currentElement;
        this.parseAttributesCore(symbol, attributes);
        this.parseAttributesStyle(symbol, attributes);
        this.parseAttributesConditional(symbol, attributes);
        this.parseAttributesViewBox(symbol, attributes);
        this.currentElement.addChild(symbol);
        this.currentElement = symbol;
    }

    private void marker(Attributes attributes) throws SVGParseException {
        this.debug("<marker>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Marker marker = new SVG.Marker();
        new SVG.Marker().document = this.svgDocument;
        marker.parent = this.currentElement;
        this.parseAttributesCore(marker, attributes);
        this.parseAttributesStyle(marker, attributes);
        this.parseAttributesConditional(marker, attributes);
        this.parseAttributesViewBox(marker, attributes);
        this.parseAttributesMarker(marker, attributes);
        this.currentElement.addChild(marker);
        this.currentElement = marker;
    }

    private void parseAttributesMarker(SVG.Marker marker, Attributes attributes) throws SVGParseException {
        block8: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case refX: {
                    marker.refX = SVGParser.parseLength(string2);
                    continue block8;
                }
                case refY: {
                    marker.refY = SVGParser.parseLength(string2);
                    continue block8;
                }
                case markerWidth: {
                    marker.markerWidth = SVGParser.parseLength(string2);
                    if (!marker.markerWidth.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <marker> element. markerWidth cannot be negative");
                }
                case markerHeight: {
                    marker.markerHeight = SVGParser.parseLength(string2);
                    if (!marker.markerHeight.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <marker> element. markerHeight cannot be negative");
                }
                case markerUnits: {
                    if ("strokeWidth".equals(string2)) {
                        marker.markerUnitsAreUser = false;
                        continue block8;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute markerUnits");
                    }
                    marker.markerUnitsAreUser = true;
                    continue block8;
                }
                case orient: {
                    marker.orient = "auto".equals(string2) ? Float.valueOf(Float.NaN) : Float.valueOf(SVGParser.parseFloat(string2));
                }
            }
        }
    }

    private void linearGradient(Attributes attributes) throws SVGParseException {
        this.debug("<linearGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgLinearGradient svgLinearGradient = new SVG.SvgLinearGradient();
        new SVG.SvgLinearGradient().document = this.svgDocument;
        svgLinearGradient.parent = this.currentElement;
        this.parseAttributesCore(svgLinearGradient, attributes);
        this.parseAttributesStyle(svgLinearGradient, attributes);
        this.parseAttributesGradient(svgLinearGradient, attributes);
        this.parseAttributesLinearGradient(svgLinearGradient, attributes);
        this.currentElement.addChild(svgLinearGradient);
        this.currentElement = svgLinearGradient;
    }

    private void parseAttributesGradient(SVG.GradientElement gradientElement, Attributes attributes) throws SVGParseException {
        block8: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block8;
                    gradientElement.href = string2;
                    continue block8;
                }
                case gradientUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        gradientElement.gradientUnitsAreUser = Boolean.FALSE;
                        continue block8;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute gradientUnits");
                    }
                    gradientElement.gradientUnitsAreUser = Boolean.TRUE;
                    continue block8;
                }
                case gradientTransform: {
                    gradientElement.gradientTransform = this.parseTransformList(string2);
                    continue block8;
                }
                case spreadMethod: {
                    try {
                        gradientElement.spreadMethod = SVG.GradientSpread.valueOf(string2);
                        continue block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SVGParseException("Invalid spreadMethod attribute. \"" + string2 + "\" is not a valid value.");
                    }
                }
            }
        }
    }

    private void parseAttributesLinearGradient(SVG.SvgLinearGradient svgLinearGradient, Attributes attributes) throws SVGParseException {
        block6: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x1: {
                    svgLinearGradient.x1 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case y1: {
                    svgLinearGradient.y1 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case x2: {
                    svgLinearGradient.x2 = SVGParser.parseLength(string2);
                    continue block6;
                }
                case y2: {
                    svgLinearGradient.y2 = SVGParser.parseLength(string2);
                }
            }
        }
    }

    private void radialGradient(Attributes attributes) throws SVGParseException {
        this.debug("<radialGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgRadialGradient svgRadialGradient = new SVG.SvgRadialGradient();
        new SVG.SvgRadialGradient().document = this.svgDocument;
        svgRadialGradient.parent = this.currentElement;
        this.parseAttributesCore(svgRadialGradient, attributes);
        this.parseAttributesStyle(svgRadialGradient, attributes);
        this.parseAttributesGradient(svgRadialGradient, attributes);
        this.parseAttributesRadialGradient(svgRadialGradient, attributes);
        this.currentElement.addChild(svgRadialGradient);
        this.currentElement = svgRadialGradient;
    }

    private void parseAttributesRadialGradient(SVG.SvgRadialGradient svgRadialGradient, Attributes attributes) throws SVGParseException {
        block7: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case cx: {
                    svgRadialGradient.cx = SVGParser.parseLength(string2);
                    continue block7;
                }
                case cy: {
                    svgRadialGradient.cy = SVGParser.parseLength(string2);
                    continue block7;
                }
                case r: {
                    svgRadialGradient.r = SVGParser.parseLength(string2);
                    if (!svgRadialGradient.r.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <radialGradient> element. r cannot be negative");
                }
                case fx: {
                    svgRadialGradient.fx = SVGParser.parseLength(string2);
                    continue block7;
                }
                case fy: {
                    svgRadialGradient.fy = SVGParser.parseLength(string2);
                }
            }
        }
    }

    private void stop(Attributes attributes) throws SVGParseException {
        this.debug("<stop>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.GradientElement)) {
            throw new SVGParseException("Invalid document. <stop> elements are only valid inside <linearGradient> or <radialGradient> elements.");
        }
        SVG.Stop stop = new SVG.Stop();
        new SVG.Stop().document = this.svgDocument;
        stop.parent = this.currentElement;
        this.parseAttributesCore(stop, attributes);
        this.parseAttributesStyle(stop, attributes);
        this.parseAttributesStop(stop, attributes);
        this.currentElement.addChild(stop);
        this.currentElement = stop;
    }

    private void parseAttributesStop(SVG.Stop stop, Attributes attributes) throws SVGParseException {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case offset: {
                    stop.offset = this.parseGradientOffset(string2);
                }
            }
        }
    }

    private Float parseGradientOffset(String string2) throws SVGParseException {
        if (string2.length() == 0) {
            throw new SVGParseException("Invalid offset value in <stop> (empty string)");
        }
        int n2 = string2.length();
        boolean bl2 = false;
        String string3 = string2;
        if (string3.charAt(string3.length() - 1) == '%') {
            --n2;
            bl2 = true;
        }
        try {
            float f2 = SVGParser.parseFloat(string2, 0, n2);
            if (bl2) {
                f2 /= 100.0f;
            }
            return Float.valueOf(f2 < 0.0f ? 0.0f : (f2 > 100.0f ? 100.0f : f2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SVGParseException("Invalid offset value in <stop>: ".concat(String.valueOf(string2)), numberFormatException);
        }
    }

    private void solidColor(Attributes attributes) throws SVGParseException {
        this.debug("<solidColor>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SolidColor solidColor = new SVG.SolidColor();
        new SVG.SolidColor().document = this.svgDocument;
        solidColor.parent = this.currentElement;
        this.parseAttributesCore(solidColor, attributes);
        this.parseAttributesStyle(solidColor, attributes);
        this.currentElement.addChild(solidColor);
        this.currentElement = solidColor;
    }

    private void clipPath(Attributes attributes) throws SVGParseException {
        this.debug("<clipPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.ClipPath clipPath = new SVG.ClipPath();
        new SVG.ClipPath().document = this.svgDocument;
        clipPath.parent = this.currentElement;
        this.parseAttributesCore(clipPath, attributes);
        this.parseAttributesStyle(clipPath, attributes);
        this.parseAttributesTransform(clipPath, attributes);
        this.parseAttributesConditional(clipPath, attributes);
        this.parseAttributesClipPath(clipPath, attributes);
        this.currentElement.addChild(clipPath);
        this.currentElement = clipPath;
    }

    private void parseAttributesClipPath(SVG.ClipPath clipPath, Attributes attributes) throws SVGParseException {
        block3: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case clipPathUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        clipPath.clipPathUnitsAreUser = Boolean.FALSE;
                        continue block3;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute clipPathUnits");
                    }
                    clipPath.clipPathUnitsAreUser = Boolean.TRUE;
                }
            }
        }
    }

    private void textPath(Attributes attributes) throws SVGParseException {
        this.debug("<textPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.TextPath textPath = new SVG.TextPath();
        new SVG.TextPath().document = this.svgDocument;
        textPath.parent = this.currentElement;
        this.parseAttributesCore(textPath, attributes);
        this.parseAttributesStyle(textPath, attributes);
        this.parseAttributesConditional(textPath, attributes);
        this.parseAttributesTextPath(textPath, attributes);
        this.currentElement.addChild(textPath);
        this.currentElement = textPath;
        if (textPath.parent instanceof SVG.TextRoot) {
            SVG.TextPath textPath2 = textPath;
            textPath2.setTextRoot((SVG.TextRoot)((Object)textPath2.parent));
            return;
        }
        SVG.TextPath textPath3 = textPath;
        textPath3.setTextRoot(((SVG.TextChild)((Object)textPath3.parent)).getTextRoot());
    }

    private void parseAttributesTextPath(SVG.TextPath textPath, Attributes attributes) throws SVGParseException {
        block4: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block4;
                    textPath.href = string2;
                    continue block4;
                }
                case startOffset: {
                    textPath.startOffset = SVGParser.parseLength(string2);
                }
            }
        }
    }

    private void pattern(Attributes attributes) throws SVGParseException {
        this.debug("<pattern>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Pattern pattern = new SVG.Pattern();
        new SVG.Pattern().document = this.svgDocument;
        pattern.parent = this.currentElement;
        this.parseAttributesCore(pattern, attributes);
        this.parseAttributesStyle(pattern, attributes);
        this.parseAttributesConditional(pattern, attributes);
        this.parseAttributesViewBox(pattern, attributes);
        this.parseAttributesPattern(pattern, attributes);
        this.currentElement.addChild(pattern);
        this.currentElement = pattern;
    }

    private void parseAttributesPattern(SVG.Pattern pattern, Attributes attributes) throws SVGParseException {
        block10: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    pattern.x = SVGParser.parseLength(string2);
                    continue block10;
                }
                case y: {
                    pattern.y = SVGParser.parseLength(string2);
                    continue block10;
                }
                case width: {
                    pattern.width = SVGParser.parseLength(string2);
                    if (!pattern.width.isNegative()) continue block10;
                    throw new SVGParseException("Invalid <pattern> element. width cannot be negative");
                }
                case height: {
                    pattern.height = SVGParser.parseLength(string2);
                    if (!pattern.height.isNegative()) continue block10;
                    throw new SVGParseException("Invalid <pattern> element. height cannot be negative");
                }
                case href: {
                    if (!"".equals(attributes.getURI(i2)) && !XLINK_NAMESPACE.equals(attributes.getURI(i2))) continue block10;
                    pattern.href = string2;
                    continue block10;
                }
                case patternUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        pattern.patternUnitsAreUser = Boolean.FALSE;
                        continue block10;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute patternUnits");
                    }
                    pattern.patternUnitsAreUser = Boolean.TRUE;
                    continue block10;
                }
                case patternContentUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        pattern.patternContentUnitsAreUser = Boolean.FALSE;
                        continue block10;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute patternContentUnits");
                    }
                    pattern.patternContentUnitsAreUser = Boolean.TRUE;
                    continue block10;
                }
                case patternTransform: {
                    pattern.patternTransform = this.parseTransformList(string2);
                }
            }
        }
    }

    private void view(Attributes attributes) throws SVGParseException {
        this.debug("<view>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.View view = new SVG.View();
        new SVG.View().document = this.svgDocument;
        view.parent = this.currentElement;
        this.parseAttributesCore(view, attributes);
        this.parseAttributesConditional(view, attributes);
        this.parseAttributesViewBox(view, attributes);
        this.currentElement.addChild(view);
        this.currentElement = view;
    }

    private void mask(Attributes attributes) throws SVGParseException {
        this.debug("<mask>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Mask mask = new SVG.Mask();
        new SVG.Mask().document = this.svgDocument;
        mask.parent = this.currentElement;
        this.parseAttributesCore(mask, attributes);
        this.parseAttributesStyle(mask, attributes);
        this.parseAttributesConditional(mask, attributes);
        this.parseAttributesMask(mask, attributes);
        this.currentElement.addChild(mask);
        this.currentElement = mask;
    }

    private void parseAttributesMask(SVG.Mask mask, Attributes attributes) throws SVGParseException {
        block8: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case x: {
                    mask.x = SVGParser.parseLength(string2);
                    continue block8;
                }
                case y: {
                    mask.y = SVGParser.parseLength(string2);
                    continue block8;
                }
                case width: {
                    mask.width = SVGParser.parseLength(string2);
                    if (!mask.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <mask> element. width cannot be negative");
                }
                case height: {
                    mask.height = SVGParser.parseLength(string2);
                    if (!mask.height.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <mask> element. height cannot be negative");
                }
                case maskUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        mask.maskUnitsAreUser = Boolean.FALSE;
                        continue block8;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute maskUnits");
                    }
                    mask.maskUnitsAreUser = Boolean.TRUE;
                    continue block8;
                }
                case maskContentUnits: {
                    if ("objectBoundingBox".equals(string2)) {
                        mask.maskContentUnitsAreUser = Boolean.FALSE;
                        continue block8;
                    }
                    if (!"userSpaceOnUse".equals(string2)) {
                        throw new SVGParseException("Invalid value for attribute maskContentUnits");
                    }
                    mask.maskContentUnitsAreUser = Boolean.TRUE;
                }
            }
        }
    }

    private void parseAttributesCore(SVG.SvgElementBase svgElementBase, Attributes object) throws SVGParseException {
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            String string2 = object.getQName(i2);
            if (string2.equals("id") || string2.equals("xml:id")) {
                svgElementBase.id = object.getValue(i2).trim();
                return;
            }
            if (!string2.equals("xml:space")) continue;
            if ("default".equals(object = object.getValue(i2).trim())) {
                svgElementBase.spacePreserve = Boolean.FALSE;
                return;
            }
            if (!"preserve".equals(object)) {
                throw new SVGParseException("Invalid value for \"xml:space\" attribute: ".concat(String.valueOf(object)));
            }
            svgElementBase.spacePreserve = Boolean.TRUE;
            return;
        }
    }

    private void parseAttributesStyle(SVG.SvgElementBase svgElementBase, Attributes attributes) throws SVGParseException {
        block4: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            if (string2.length() == 0) continue;
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case style: {
                    SVGParser.parseStyle(svgElementBase, string2);
                    continue block4;
                }
                case CLASS: {
                    svgElementBase.classNames = CSSParser.parseClassAttribute(string2);
                    continue block4;
                }
                default: {
                    if (svgElementBase.baseStyle == null) {
                        svgElementBase.baseStyle = new SVG.Style();
                    }
                    SVGParser.processStyleProperty(svgElementBase.baseStyle, attributes.getLocalName(i2), attributes.getValue(i2).trim());
                }
            }
        }
    }

    private static void parseStyle(SVG.SvgElementBase svgElementBase, String object) {
        object = new TextScanner(((String)object).replaceAll("/\\*.*?\\*/", ""));
        while (true) {
            String string2 = ((TextScanner)object).nextToken(':');
            ((TextScanner)object).skipWhitespace();
            if (!((TextScanner)object).consume(':')) break;
            ((TextScanner)object).skipWhitespace();
            String string3 = ((TextScanner)object).nextTokenWithWhitespace(';');
            if (string3 == null) break;
            ((TextScanner)object).skipWhitespace();
            if (!((TextScanner)object).empty() && !((TextScanner)object).consume(';')) continue;
            if (svgElementBase.style == null) {
                svgElementBase.style = new SVG.Style();
            }
            SVGParser.processStyleProperty(svgElementBase.style, string2, string3);
            ((TextScanner)object).skipWhitespace();
        }
    }

    static void processStyleProperty(SVG.Style style2, String string2, String string3) {
        if (string3.length() != 0 && !string3.equals("inherit")) {
            switch (SVGAttr.fromString(string2)) {
                case fill: {
                    style2.fill = SVGParser.parsePaintSpecifier(string3);
                    if (style2.fill == null) break;
                    style2.specifiedFlags |= 1L;
                    return;
                }
                case fill_rule: {
                    style2.fillRule = SVGParser.parseFillRule(string3);
                    if (style2.fillRule == null) break;
                    style2.specifiedFlags |= 2L;
                    return;
                }
                case fill_opacity: {
                    style2.fillOpacity = SVGParser.parseOpacity(string3);
                    if (style2.fillOpacity == null) break;
                    style2.specifiedFlags |= 4L;
                    return;
                }
                case stroke: {
                    style2.stroke = SVGParser.parsePaintSpecifier(string3);
                    if (style2.stroke == null) break;
                    style2.specifiedFlags |= 8L;
                    return;
                }
                case stroke_opacity: {
                    style2.strokeOpacity = SVGParser.parseOpacity(string3);
                    if (style2.strokeOpacity == null) break;
                    style2.specifiedFlags |= 0x10L;
                    return;
                }
                case stroke_width: {
                    try {
                        style2.strokeWidth = SVGParser.parseLength(string3);
                        style2.specifiedFlags |= 0x20L;
                        return;
                    }
                    catch (SVGParseException sVGParseException) {
                        return;
                    }
                }
                case stroke_linecap: {
                    style2.strokeLineCap = SVGParser.parseStrokeLineCap(string3);
                    if (style2.strokeLineCap == null) break;
                    style2.specifiedFlags |= 0x40L;
                    return;
                }
                case stroke_linejoin: {
                    style2.strokeLineJoin = SVGParser.parseStrokeLineJoin(string3);
                    if (style2.strokeLineJoin == null) break;
                    style2.specifiedFlags |= 0x80L;
                    return;
                }
                case stroke_miterlimit: {
                    try {
                        style2.strokeMiterLimit = Float.valueOf(SVGParser.parseFloat(string3));
                        style2.specifiedFlags |= 0x100L;
                        return;
                    }
                    catch (SVGParseException sVGParseException) {
                        return;
                    }
                }
                case stroke_dasharray: {
                    if (NONE.equals(string3)) {
                        style2.strokeDashArray = null;
                        style2.specifiedFlags |= 0x200L;
                        return;
                    }
                    style2.strokeDashArray = SVGParser.parseStrokeDashArray(string3);
                    if (style2.strokeDashArray == null) break;
                    style2.specifiedFlags |= 0x200L;
                    return;
                }
                case stroke_dashoffset: {
                    try {
                        style2.strokeDashOffset = SVGParser.parseLength(string3);
                        style2.specifiedFlags |= 0x400L;
                        return;
                    }
                    catch (SVGParseException sVGParseException) {
                        return;
                    }
                }
                case opacity: {
                    style2.opacity = SVGParser.parseOpacity(string3);
                    style2.specifiedFlags |= 0x800L;
                    return;
                }
                case color: {
                    try {
                        style2.color = SVGParser.parseColour(string3);
                        style2.specifiedFlags |= 0x1000L;
                        return;
                    }
                    catch (SVGParseException sVGParseException) {
                        return;
                    }
                }
                case font: {
                    SVGParser.parseFont(style2, string3);
                    return;
                }
                case font_family: {
                    style2.fontFamily = SVGParser.parseFontFamily(string3);
                    if (style2.fontFamily == null) break;
                    style2.specifiedFlags |= 0x2000L;
                    return;
                }
                case font_size: {
                    style2.fontSize = SVGParser.parseFontSize(string3);
                    if (style2.fontSize == null) break;
                    style2.specifiedFlags |= 0x4000L;
                    return;
                }
                case font_weight: {
                    style2.fontWeight = SVGParser.parseFontWeight(string3);
                    if (style2.fontWeight == null) break;
                    style2.specifiedFlags |= 0x8000L;
                    return;
                }
                case font_style: {
                    style2.fontStyle = SVGParser.parseFontStyle(string3);
                    if (style2.fontStyle == null) break;
                    style2.specifiedFlags |= 0x10000L;
                    return;
                }
                case text_decoration: {
                    style2.textDecoration = SVGParser.parseTextDecoration(string3);
                    if (style2.textDecoration == null) break;
                    style2.specifiedFlags |= 0x20000L;
                    return;
                }
                case direction: {
                    style2.direction = SVGParser.parseTextDirection(string3);
                    if (style2.direction == null) break;
                    style2.specifiedFlags |= 0x1000000000L;
                    return;
                }
                case text_anchor: {
                    style2.textAnchor = SVGParser.parseTextAnchor(string3);
                    if (style2.textAnchor == null) break;
                    style2.specifiedFlags |= 0x40000L;
                    return;
                }
                case overflow: {
                    style2.overflow = SVGParser.parseOverflow(string3);
                    if (style2.overflow == null) break;
                    style2.specifiedFlags |= 0x80000L;
                    return;
                }
                case marker: {
                    style2.markerMid = style2.markerStart = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.markerEnd = style2.markerStart;
                    style2.specifiedFlags |= 0xE00000L;
                    return;
                }
                case marker_start: {
                    style2.markerStart = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.specifiedFlags |= 0x200000L;
                    return;
                }
                case marker_mid: {
                    style2.markerMid = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.specifiedFlags |= 0x400000L;
                    return;
                }
                case marker_end: {
                    style2.markerEnd = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.specifiedFlags |= 0x800000L;
                    return;
                }
                case display: {
                    if (string3.indexOf(124) >= 0 || !VALID_DISPLAY_VALUES.contains("|" + string3 + '|')) break;
                    style2.display = !string3.equals(NONE);
                    style2.specifiedFlags |= 0x1000000L;
                    return;
                }
                case visibility: {
                    if (string3.indexOf(124) >= 0 || !VALID_VISIBILITY_VALUES.contains("|" + string3 + '|')) break;
                    style2.visibility = string3.equals("visible");
                    style2.specifiedFlags |= 0x2000000L;
                    return;
                }
                case stop_color: {
                    if (string3.equals(CURRENTCOLOR)) {
                        style2.stopColor = SVG.CurrentColor.getInstance();
                    } else {
                        try {
                            style2.stopColor = SVGParser.parseColour(string3);
                        }
                        catch (SVGParseException sVGParseException) {
                            sVGParseException.getMessage();
                            return;
                        }
                    }
                    style2.specifiedFlags |= 0x4000000L;
                    return;
                }
                case stop_opacity: {
                    style2.stopOpacity = SVGParser.parseOpacity(string3);
                    style2.specifiedFlags |= 0x8000000L;
                    return;
                }
                case clip: {
                    style2.clip = SVGParser.parseClip(string3);
                    if (style2.clip == null) break;
                    style2.specifiedFlags |= 0x100000L;
                    return;
                }
                case clip_path: {
                    style2.clipPath = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.specifiedFlags |= 0x10000000L;
                    return;
                }
                case clip_rule: {
                    style2.clipRule = SVGParser.parseFillRule(string3);
                    style2.specifiedFlags |= 0x20000000L;
                    return;
                }
                case mask: {
                    style2.mask = SVGParser.parseFunctionalIRI(string3, string2);
                    style2.specifiedFlags |= 0x40000000L;
                    return;
                }
                case solid_color: {
                    if (string3.equals(CURRENTCOLOR)) {
                        style2.solidColor = SVG.CurrentColor.getInstance();
                    } else {
                        try {
                            style2.solidColor = SVGParser.parseColour(string3);
                        }
                        catch (SVGParseException sVGParseException) {
                            sVGParseException.getMessage();
                            return;
                        }
                    }
                    style2.specifiedFlags |= 0x80000000L;
                    return;
                }
                case solid_opacity: {
                    style2.solidOpacity = SVGParser.parseOpacity(string3);
                    style2.specifiedFlags |= 0x100000000L;
                    return;
                }
                case viewport_fill: {
                    if (string3.equals(CURRENTCOLOR)) {
                        style2.viewportFill = SVG.CurrentColor.getInstance();
                    } else {
                        try {
                            style2.viewportFill = SVGParser.parseColour(string3);
                        }
                        catch (SVGParseException sVGParseException) {
                            sVGParseException.getMessage();
                            return;
                        }
                    }
                    style2.specifiedFlags |= 0x200000000L;
                    return;
                }
                case viewport_fill_opacity: {
                    style2.viewportFillOpacity = SVGParser.parseOpacity(string3);
                    style2.specifiedFlags |= 0x400000000L;
                    return;
                }
                case vector_effect: {
                    style2.vectorEffect = SVGParser.parseVectorEffect(string3);
                    if (style2.vectorEffect == null) break;
                    style2.specifiedFlags |= 0x800000000L;
                    return;
                }
                case image_rendering: {
                    style2.imageRendering = SVGParser.parseRenderQuality(string3);
                    if (style2.imageRendering == null) break;
                    style2.specifiedFlags |= 0x2000000000L;
                }
            }
        }
    }

    private void parseAttributesViewBox(SVG.SvgViewBoxContainer svgViewBoxContainer, Attributes attributes) throws SVGParseException {
        block4: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(svgViewBoxContainer, string2);
                    continue block4;
                }
                case viewBox: {
                    svgViewBoxContainer.viewBox = SVGParser.parseViewBox(string2);
                }
            }
        }
    }

    private void parseAttributesTransform(SVG.HasTransform hasTransform, Attributes attributes) throws SVGParseException {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (SVGAttr.fromString(attributes.getLocalName(i2)) != SVGAttr.transform) continue;
            hasTransform.setTransform(this.parseTransformList(attributes.getValue(i2)));
        }
    }

    private Matrix parseTransformList(String string2) throws SVGParseException {
        Matrix matrix = new Matrix();
        TextScanner textScanner = new TextScanner(string2);
        textScanner.skipWhitespace();
        while (!textScanner.empty()) {
            String string3 = textScanner.nextFunction();
            if (string3 == null) {
                throw new SVGParseException("Bad transform function encountered in transform list: ".concat(String.valueOf(string2)));
            }
            int n2 = -1;
            switch (string3.hashCode()) {
                case -1081239615: {
                    if (!string3.equals("matrix")) break;
                    n2 = 0;
                    break;
                }
                case -925180581: {
                    if (!string3.equals("rotate")) break;
                    n2 = 3;
                    break;
                }
                case 109250890: {
                    if (!string3.equals("scale")) break;
                    n2 = 2;
                    break;
                }
                case 109493390: {
                    if (!string3.equals("skewX")) break;
                    n2 = 4;
                    break;
                }
                case 109493391: {
                    if (!string3.equals("skewY")) break;
                    n2 = 5;
                    break;
                }
                case 1052832078: {
                    if (!string3.equals("translate")) break;
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    textScanner.skipCommaWhitespace();
                    float f3 = textScanner.nextFloat();
                    textScanner.skipCommaWhitespace();
                    float f4 = textScanner.nextFloat();
                    textScanner.skipCommaWhitespace();
                    float f5 = textScanner.nextFloat();
                    textScanner.skipCommaWhitespace();
                    float f6 = textScanner.nextFloat();
                    textScanner.skipCommaWhitespace();
                    float f7 = textScanner.nextFloat();
                    textScanner.skipWhitespace();
                    if (Float.isNaN(f7) || !textScanner.consume(')')) {
                        throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                    }
                    Matrix matrix2 = new Matrix();
                    matrix2.setValues(new float[]{f2, f4, f6, f3, f5, f7, 0.0f, 0.0f, 1.0f});
                    matrix.preConcat(matrix2);
                    break;
                }
                case 1: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    float f8 = textScanner.possibleNextFloat();
                    textScanner.skipWhitespace();
                    if (Float.isNaN(f2) || !textScanner.consume(')')) {
                        throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                    }
                    if (Float.isNaN(f8)) {
                        matrix.preTranslate(f2, 0.0f);
                        break;
                    }
                    matrix.preTranslate(f2, f8);
                    break;
                }
                case 2: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    float f9 = textScanner.possibleNextFloat();
                    textScanner.skipWhitespace();
                    if (!Float.isNaN(f2) && textScanner.consume(')')) {
                        if (Float.isNaN(f9)) {
                            float f10 = f2;
                            matrix.preScale(f10, f10);
                            break;
                        }
                        matrix.preScale(f2, f9);
                        break;
                    }
                    throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                }
                case 3: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    float f11 = textScanner.possibleNextFloat();
                    float f4 = textScanner.possibleNextFloat();
                    textScanner.skipWhitespace();
                    if (Float.isNaN(f2) || !textScanner.consume(')')) {
                        throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                    }
                    if (Float.isNaN(f11)) {
                        matrix.preRotate(f2);
                        break;
                    }
                    if (Float.isNaN(f4)) {
                        throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                    }
                    matrix.preRotate(f2, f11, f4);
                    break;
                }
                case 4: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    textScanner.skipWhitespace();
                    if (!Float.isNaN(f2) && textScanner.consume(')')) {
                        matrix.preSkew((float)Math.tan(Math.toRadians(f2)), 0.0f);
                        break;
                    }
                    throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                }
                case 5: {
                    textScanner.skipWhitespace();
                    float f2 = textScanner.nextFloat();
                    textScanner.skipWhitespace();
                    if (Float.isNaN(f2) || !textScanner.consume(')')) {
                        throw new SVGParseException("Invalid transform list: ".concat(String.valueOf(string2)));
                    }
                    matrix.preSkew(0.0f, (float)Math.tan(Math.toRadians(f2)));
                    break;
                }
                default: {
                    throw new SVGParseException("Invalid transform list fn: " + string3 + ")");
                }
            }
            if (textScanner.empty()) break;
            textScanner.skipCommaWhitespace();
        }
        return matrix;
    }

    static SVG.Length parseLength(String string2) throws SVGParseException {
        if (string2.length() == 0) {
            throw new SVGParseException("Invalid length value (empty string)");
        }
        int n2 = string2.length();
        SVG.Unit unit = SVG.Unit.px;
        char c2 = string2.charAt(n2 - 1);
        if (c2 == '%') {
            --n2;
            unit = SVG.Unit.percent;
        } else if (n2 > 2 && Character.isLetter(c2) && Character.isLetter(string2.charAt(n2 - 2))) {
            String string3 = string2.substring(n2 -= 2);
            try {
                unit = SVG.Unit.valueOf(string3.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SVGParseException("Invalid length unit specifier: ".concat(String.valueOf(string2)));
            }
        }
        try {
            float f2 = SVGParser.parseFloat(string2, 0, n2);
            return new SVG.Length(f2, unit);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SVGParseException("Invalid length value: ".concat(String.valueOf(string2)), numberFormatException);
        }
    }

    private static List<SVG.Length> parseLengthList(String object) throws SVGParseException {
        if (((String)object).length() == 0) {
            throw new SVGParseException("Invalid length list (empty string)");
        }
        ArrayList<SVG.Length> arrayList = new ArrayList<SVG.Length>(1);
        object = new TextScanner((String)object);
        ((TextScanner)object).skipWhitespace();
        while (!((TextScanner)object).empty()) {
            float f2 = ((TextScanner)object).nextFloat();
            if (Float.isNaN(f2)) {
                throw new SVGParseException("Invalid length list value: " + ((TextScanner)object).ahead());
            }
            SVG.Unit unit = ((TextScanner)object).nextUnit();
            if (unit == null) {
                unit = SVG.Unit.px;
            }
            arrayList.add(new SVG.Length(f2, unit));
            ((TextScanner)object).skipCommaWhitespace();
        }
        return arrayList;
    }

    private static float parseFloat(String string2) throws SVGParseException {
        int n2 = string2.length();
        if (n2 == 0) {
            throw new SVGParseException("Invalid float value (empty string)");
        }
        return SVGParser.parseFloat(string2, 0, n2);
    }

    private static float parseFloat(String string2, int n2, int n3) throws SVGParseException {
        float f2 = new NumberParser().parseNumber(string2, n2, n3);
        if (!Float.isNaN(f2)) {
            return f2;
        }
        throw new SVGParseException("Invalid float value: ".concat(String.valueOf(string2)));
    }

    private static Float parseOpacity(String string2) {
        try {
            float f2;
            float f3 = SVGParser.parseFloat(string2);
            return Float.valueOf(f2 < 0.0f ? 0.0f : (f3 > 1.0f ? 1.0f : f3));
        }
        catch (SVGParseException sVGParseException) {
            return null;
        }
    }

    private static SVG.Box parseViewBox(String object) throws SVGParseException {
        object = new TextScanner((String)object);
        ((TextScanner)object).skipWhitespace();
        float f2 = ((TextScanner)object).nextFloat();
        ((TextScanner)object).skipCommaWhitespace();
        float f3 = ((TextScanner)object).nextFloat();
        ((TextScanner)object).skipCommaWhitespace();
        float f4 = ((TextScanner)object).nextFloat();
        ((TextScanner)object).skipCommaWhitespace();
        float f5 = ((TextScanner)object).nextFloat();
        if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4) || Float.isNaN(f5))) {
            if (f4 < 0.0f) {
                throw new SVGParseException("Invalid viewBox. width cannot be negative");
            }
            if (f5 < 0.0f) {
                throw new SVGParseException("Invalid viewBox. height cannot be negative");
            }
            return new SVG.Box(f2, f3, f4, f5);
        }
        throw new SVGParseException("Invalid viewBox definition - should have four numbers");
    }

    private static void parsePreserveAspectRatio(SVG.SvgPreserveAspectRatioContainer svgPreserveAspectRatioContainer, String string2) throws SVGParseException {
        svgPreserveAspectRatioContainer.preserveAspectRatio = SVGParser.parsePreserveAspectRatio(string2);
    }

    static PreserveAspectRatio parsePreserveAspectRatio(String string2) throws SVGParseException {
        Object object = new TextScanner(string2);
        ((TextScanner)object).skipWhitespace();
        Object object2 = ((TextScanner)object).nextToken();
        if ("defer".equals(object2)) {
            ((TextScanner)object).skipWhitespace();
            object2 = ((TextScanner)object).nextToken();
        }
        object2 = AspectRatioKeywords.get(object2);
        PreserveAspectRatio.Scale scale = null;
        ((TextScanner)object).skipWhitespace();
        if (!((TextScanner)object).empty()) {
            object = ((TextScanner)object).nextToken();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                case 3347527: {
                    if (!((String)object).equals("meet")) break;
                    n2 = 0;
                    break;
                }
                case 109526418: {
                    if (!((String)object).equals("slice")) break;
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    scale = PreserveAspectRatio.Scale.meet;
                    break;
                }
                case 1: {
                    scale = PreserveAspectRatio.Scale.slice;
                    break;
                }
                default: {
                    throw new SVGParseException("Invalid preserveAspectRatio definition: ".concat(String.valueOf(string2)));
                }
            }
        }
        return new PreserveAspectRatio((PreserveAspectRatio.Alignment)((Object)object2), scale);
    }

    private static SVG.SvgPaint parsePaintSpecifier(String string2) {
        if (string2.startsWith("url(")) {
            int n2 = string2.indexOf(")");
            if (n2 != -1) {
                String string3 = string2.substring(4, n2).trim();
                SVG.SvgPaint svgPaint = null;
                if ((string2 = string2.substring(n2 + 1).trim()).length() > 0) {
                    svgPaint = SVGParser.parseColourSpecifer(string2);
                }
                return new SVG.PaintReference(string3, svgPaint);
            }
            String string4 = string2.substring(4).trim();
            return new SVG.PaintReference(string4, null);
        }
        return SVGParser.parseColourSpecifer(string2);
    }

    private static SVG.SvgPaint parseColourSpecifer(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case 3387192: {
                if (!string2.equals(NONE)) break;
                n2 = 0;
                break;
            }
            case 1442907498: {
                if (!string2.equals(CURRENTCOLOR)) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Colour.TRANSPARENT;
            }
            case 1: {
                return SVG.CurrentColor.getInstance();
            }
        }
        try {
            return SVGParser.parseColour(string2);
        }
        catch (SVGParseException sVGParseException) {
            return null;
        }
    }

    private static SVG.Colour parseColour(String string2) throws SVGParseException {
        float f2;
        float f3;
        if (string2.charAt(0) == '#') {
            IntegerParser integerParser = IntegerParser.parseHex(string2, 1, string2.length());
            if (integerParser == null) {
                throw new SVGParseException("Bad hex colour value: ".concat(String.valueOf(string2)));
            }
            switch (integerParser.getEndPos()) {
                case 4: {
                    int n2 = integerParser.value();
                    int n3 = n2 & 0xF00;
                    int n4 = n2 & 0xF0;
                    int n5 = n2 & 0xF;
                    return new SVG.Colour(0xFF000000 | n3 << 12 | n3 << 8 | n4 << 8 | n4 << 4 | n5 << 4 | n5);
                }
                case 5: {
                    int n6 = integerParser.value();
                    int n7 = n6 & 0xF000;
                    int n8 = n6 & 0xF00;
                    int n9 = n6 & 0xF0;
                    int n10 = n6 & 0xF;
                    return new SVG.Colour(n10 << 28 | n10 << 24 | n7 << 8 | n7 << 4 | n8 << 4 | n8 | n9 | n9 >> 4);
                }
                default: {
                    throw new SVGParseException("Bad hex colour value: ".concat(String.valueOf(string2)));
                }
                case 7: {
                    return new SVG.Colour(0xFF000000 | integerParser.value());
                }
                case 9: 
            }
            return new SVG.Colour(integerParser.value() << 24 | integerParser.value() >>> 8);
        }
        String string3 = string2.toLowerCase(Locale.US);
        boolean bl2 = string3.startsWith("rgba(");
        if (!bl2 && !string3.startsWith("rgb(")) {
            float f4;
            boolean bl3 = string3.startsWith("hsla(");
            if (!bl3 && !string3.startsWith("hsl(")) {
                return SVGParser.parseColourKeyword(string3);
            }
            TextScanner textScanner = new TextScanner(string2.substring(bl3 ? 5 : 4));
            textScanner.skipWhitespace();
            float f5 = textScanner.nextFloat();
            float f6 = textScanner.checkedNextFloat(f5);
            if (!Float.isNaN(f6)) {
                textScanner.consume('%');
            }
            if (!Float.isNaN(f4 = textScanner.checkedNextFloat(f6))) {
                textScanner.consume('%');
            }
            if (bl3) {
                f4 = textScanner.checkedNextFloat(f4);
                textScanner.skipWhitespace();
                if (!Float.isNaN(f4) && textScanner.consume(')')) {
                    return new SVG.Colour(SVGParser.clamp255(f4 * 256.0f) << 24 | SVGParser.hslToRgb(f5, f6, f4));
                }
                throw new SVGParseException("Bad hsla() colour value: ".concat(String.valueOf(string2)));
            }
            textScanner.skipWhitespace();
            if (!Float.isNaN(f4) && textScanner.consume(')')) {
                return new SVG.Colour(0xFF000000 | SVGParser.hslToRgb(f5, f6, f4));
            }
            throw new SVGParseException("Bad hsl() colour value: ".concat(String.valueOf(string2)));
        }
        TextScanner textScanner = new TextScanner(string2.substring(bl2 ? 5 : 4));
        textScanner.skipWhitespace();
        float f7 = textScanner.nextFloat();
        if (!Float.isNaN(f7) && textScanner.consume('%')) {
            f7 = f7 * 256.0f / 100.0f;
        }
        if (!Float.isNaN(f3 = textScanner.checkedNextFloat(f7)) && textScanner.consume('%')) {
            f3 = f3 * 256.0f / 100.0f;
        }
        if (!Float.isNaN(f2 = textScanner.checkedNextFloat(f3)) && textScanner.consume('%')) {
            f2 = f2 * 256.0f / 100.0f;
        }
        if (bl2) {
            float f8 = textScanner.checkedNextFloat(f2);
            textScanner.skipWhitespace();
            if (!Float.isNaN(f8) && textScanner.consume(')')) {
                return new SVG.Colour(SVGParser.clamp255(f8 * 256.0f) << 24 | SVGParser.clamp255(f7) << 16 | SVGParser.clamp255(f3) << 8 | SVGParser.clamp255(f2));
            }
            throw new SVGParseException("Bad rgba() colour value: ".concat(String.valueOf(string2)));
        }
        textScanner.skipWhitespace();
        if (!Float.isNaN(f2) && textScanner.consume(')')) {
            return new SVG.Colour(0xFF000000 | SVGParser.clamp255(f7) << 16 | SVGParser.clamp255(f3) << 8 | SVGParser.clamp255(f2));
        }
        throw new SVGParseException("Bad rgb() colour value: ".concat(String.valueOf(string2)));
    }

    private static int clamp255(float f2) {
        if (f2 < 0.0f) {
            return 0;
        }
        if (f2 > 255.0f) {
            return 255;
        }
        return Math.round(f2);
    }

    private static int hslToRgb(float f2, float f3, float f4) {
        f2 = (f2 >= 0.0f ? f2 % 360.0f : f2 % 360.0f + 360.0f) / 60.0f;
        f3 /= 100.0f;
        float f5 = f3 < 0.0f ? 0.0f : (f3 = f3 > 1.0f ? 1.0f : f3);
        f4 = f4 < 0.0f ? 0.0f : (f4 > 1.0f ? 1.0f : (f4 /= 100.0f));
        f3 = f4 <= 0.5f ? f4 * (f3 + 1.0f) : f4 + f3 - f4 * f3;
        f4 = f4 * 2.0f - f3;
        float f6 = SVGParser.hueToRgb(f4, f3, f2 + 2.0f);
        float f7 = SVGParser.hueToRgb(f4, f3, f2);
        f2 = SVGParser.hueToRgb(f4, f3, f2 - 2.0f);
        return SVGParser.clamp255(f6 * 256.0f) << 16 | SVGParser.clamp255(f7 * 256.0f) << 8 | SVGParser.clamp255(f2 * 256.0f);
    }

    private static float hueToRgb(float f2, float f3, float f4) {
        if (f4 < 0.0f) {
            f4 += 6.0f;
        }
        if (f4 >= 6.0f) {
            f4 -= 6.0f;
        }
        if (f4 < 1.0f) {
            return (f3 - f2) * f4 + f2;
        }
        if (f4 < 3.0f) {
            return f3;
        }
        if (f4 < 4.0f) {
            return (f3 - f2) * (4.0f - f4) + f2;
        }
        return f2;
    }

    private static SVG.Colour parseColourKeyword(String string2) throws SVGParseException {
        Integer n2 = ColourKeywords.get(string2);
        if (n2 == null) {
            throw new SVGParseException("Invalid colour keyword: ".concat(String.valueOf(string2)));
        }
        return new SVG.Colour(n2);
    }

    private static void parseFont(SVG.Style style2, String object) {
        Integer n2 = null;
        SVG.Style.FontStyle fontStyle = null;
        Object object2 = null;
        if ("|caption|icon|menu|message-box|small-caption|status-bar|".contains("|" + (String)object + '|')) {
            String string2;
            object = new TextScanner((String)object);
            while (true) {
                string2 = ((TextScanner)object).nextToken('/');
                ((TextScanner)object).skipWhitespace();
                if (string2 == null) {
                    return;
                }
                if (n2 != null && fontStyle != null) break;
                if (string2.equals("normal") || n2 == null && (n2 = FontWeightKeywords.get(string2)) != null || fontStyle == null && (fontStyle = SVGParser.parseFontStyle(string2)) != null) continue;
                if (object2 != null || !string2.equals("small-caps")) break;
                object2 = string2;
            }
            object2 = SVGParser.parseFontSize(string2);
            if (((TextScanner)object).consume('/')) {
                ((TextScanner)object).skipWhitespace();
                string2 = ((TextScanner)object).nextToken();
                if (string2 != null) {
                    try {
                        SVGParser.parseLength(string2);
                    }
                    catch (SVGParseException sVGParseException) {
                        return;
                    }
                }
                ((TextScanner)object).skipWhitespace();
            }
            style2.fontFamily = SVGParser.parseFontFamily(((TextScanner)object).restOfText());
            style2.fontSize = object2;
            style2.fontWeight = n2 == null ? 400 : n2;
            style2.fontStyle = fontStyle == null ? SVG.Style.FontStyle.Normal : fontStyle;
            style2.specifiedFlags |= 0x1E000L;
        }
    }

    private static List<String> parseFontFamily(String object) {
        ArrayList<String> arrayList = null;
        object = new TextScanner((String)object);
        do {
            String string2;
            if ((string2 = ((TextScanner)object).nextQuotedString()) == null) {
                string2 = ((TextScanner)object).nextTokenWithWhitespace(',');
            }
            if (string2 == null) break;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
            ((TextScanner)object).skipCommaWhitespace();
        } while (!((TextScanner)object).empty());
        return arrayList;
    }

    private static SVG.Length parseFontSize(String string2) {
        try {
            SVG.Length length = FontSizeKeywords.get(string2);
            if (length == null) {
                length = SVGParser.parseLength(string2);
            }
            return length;
        }
        catch (SVGParseException sVGParseException) {
            return null;
        }
    }

    private static Integer parseFontWeight(String string2) {
        return FontWeightKeywords.get(string2);
    }

    private static SVG.Style.FontStyle parseFontStyle(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1657669071: {
                if (!string2.equals("oblique")) break;
                n2 = 2;
                break;
            }
            case -1178781136: {
                if (!string2.equals("italic")) break;
                n2 = 0;
                break;
            }
            case -1039745817: {
                if (!string2.equals("normal")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.FontStyle.Italic;
            }
            case 1: {
                return SVG.Style.FontStyle.Normal;
            }
            case 2: {
                return SVG.Style.FontStyle.Oblique;
            }
        }
        return null;
    }

    private static SVG.Style.TextDecoration parseTextDecoration(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1171789332: {
                if (!string2.equals("line-through")) break;
                n2 = 3;
                break;
            }
            case -1026963764: {
                if (!string2.equals("underline")) break;
                n2 = 1;
                break;
            }
            case 3387192: {
                if (!string2.equals(NONE)) break;
                n2 = 0;
                break;
            }
            case 93826908: {
                if (!string2.equals("blink")) break;
                n2 = 4;
                break;
            }
            case 529818312: {
                if (!string2.equals("overline")) break;
                n2 = 2;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.TextDecoration.None;
            }
            case 1: {
                return SVG.Style.TextDecoration.Underline;
            }
            case 2: {
                return SVG.Style.TextDecoration.Overline;
            }
            case 3: {
                return SVG.Style.TextDecoration.LineThrough;
            }
            case 4: {
                return SVG.Style.TextDecoration.Blink;
            }
        }
        return null;
    }

    private static SVG.Style.TextDirection parseTextDirection(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case 107498: {
                if (!string2.equals("ltr")) break;
                n2 = 0;
                break;
            }
            case 113258: {
                if (!string2.equals("rtl")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.TextDirection.LTR;
            }
            case 1: {
                return SVG.Style.TextDirection.RTL;
            }
        }
        return null;
    }

    private static SVG.Style.FillRule parseFillRule(String string2) {
        if ("nonzero".equals(string2)) {
            return SVG.Style.FillRule.NonZero;
        }
        if ("evenodd".equals(string2)) {
            return SVG.Style.FillRule.EvenOdd;
        }
        return null;
    }

    private static SVG.Style.LineCap parseStrokeLineCap(String string2) {
        if ("butt".equals(string2)) {
            return SVG.Style.LineCap.Butt;
        }
        if ("round".equals(string2)) {
            return SVG.Style.LineCap.Round;
        }
        if ("square".equals(string2)) {
            return SVG.Style.LineCap.Square;
        }
        return null;
    }

    private static SVG.Style.LineJoin parseStrokeLineJoin(String string2) {
        if ("miter".equals(string2)) {
            return SVG.Style.LineJoin.Miter;
        }
        if ("round".equals(string2)) {
            return SVG.Style.LineJoin.Round;
        }
        if ("bevel".equals(string2)) {
            return SVG.Style.LineJoin.Bevel;
        }
        return null;
    }

    private static SVG.Length[] parseStrokeDashArray(String object) {
        object = new TextScanner((String)object);
        ((TextScanner)object).skipWhitespace();
        if (((TextScanner)object).empty()) {
            return null;
        }
        SVG.Length length = ((TextScanner)object).nextLength();
        if (length == null) {
            return null;
        }
        if (length.isNegative()) {
            return null;
        }
        float f2 = length.floatValue();
        ArrayList<SVG.Length> arrayList = new ArrayList<SVG.Length>();
        arrayList.add(length);
        while (!((TextScanner)object).empty()) {
            ((TextScanner)object).skipCommaWhitespace();
            length = ((TextScanner)object).nextLength();
            if (length == null) {
                return null;
            }
            if (length.isNegative()) {
                return null;
            }
            arrayList.add(length);
            f2 += length.floatValue();
        }
        if (f2 == 0.0f) {
            return null;
        }
        ArrayList<SVG.Length> arrayList2 = arrayList;
        return arrayList2.toArray(new SVG.Length[arrayList2.size()]);
    }

    private static SVG.Style.TextAnchor parseTextAnchor(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1074341483: {
                if (!string2.equals("middle")) break;
                n2 = 1;
                break;
            }
            case 100571: {
                if (!string2.equals("end")) break;
                n2 = 2;
                break;
            }
            case 109757538: {
                if (!string2.equals("start")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.TextAnchor.Start;
            }
            case 1: {
                return SVG.Style.TextAnchor.Middle;
            }
            case 2: {
                return SVG.Style.TextAnchor.End;
            }
        }
        return null;
    }

    private static Boolean parseOverflow(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1217487446: {
                if (!string2.equals("hidden")) break;
                n2 = 2;
                break;
            }
            case -907680051: {
                if (!string2.equals("scroll")) break;
                n2 = 3;
                break;
            }
            case 3005871: {
                if (!string2.equals("auto")) break;
                n2 = 1;
                break;
            }
            case 466743410: {
                if (!string2.equals("visible")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            case 0: 
            case 1: {
                return Boolean.TRUE;
            }
            case 2: 
            case 3: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static SVG.CSSClipRect parseClip(String object) {
        if ("auto".equals(object)) {
            return null;
        }
        if (!((String)object).startsWith("rect(")) {
            return null;
        }
        object = new TextScanner(((String)object).substring(5));
        ((TextScanner)object).skipWhitespace();
        SVG.Length length = SVGParser.parseLengthOrAuto((TextScanner)object);
        ((TextScanner)object).skipCommaWhitespace();
        SVG.Length length2 = SVGParser.parseLengthOrAuto((TextScanner)object);
        ((TextScanner)object).skipCommaWhitespace();
        SVG.Length length3 = SVGParser.parseLengthOrAuto((TextScanner)object);
        ((TextScanner)object).skipCommaWhitespace();
        SVG.Length length4 = SVGParser.parseLengthOrAuto((TextScanner)object);
        ((TextScanner)object).skipWhitespace();
        if (!((TextScanner)object).consume(')') && !((TextScanner)object).empty()) {
            return null;
        }
        return new SVG.CSSClipRect(length, length2, length3, length4);
    }

    private static SVG.Length parseLengthOrAuto(TextScanner textScanner) {
        if (textScanner.consume("auto")) {
            return new SVG.Length(0.0f);
        }
        return textScanner.nextLength();
    }

    private static SVG.Style.VectorEffect parseVectorEffect(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case 3387192: {
                if (!string2.equals(NONE)) break;
                n2 = 0;
                break;
            }
            case 1629199934: {
                if (!string2.equals("non-scaling-stroke")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.VectorEffect.None;
            }
            case 1: {
                return SVG.Style.VectorEffect.NonScalingStroke;
            }
        }
        return null;
    }

    private static SVG.Style.RenderQuality parseRenderQuality(String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -933002398: {
                if (!string2.equals("optimizeQuality")) break;
                n2 = 1;
                break;
            }
            case 3005871: {
                if (!string2.equals("auto")) break;
                n2 = 0;
                break;
            }
            case 362741610: {
                if (!string2.equals("optimizeSpeed")) break;
                n2 = 2;
            }
        }
        switch (n2) {
            case 0: {
                return SVG.Style.RenderQuality.auto;
            }
            case 1: {
                return SVG.Style.RenderQuality.optimizeQuality;
            }
            case 2: {
                return SVG.Style.RenderQuality.optimizeSpeed;
            }
        }
        return null;
    }

    private static SVG.PathDefinition parsePath(String object) {
        object = new TextScanner((String)object);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        SVG.PathDefinition pathDefinition = new SVG.PathDefinition();
        if (((TextScanner)object).empty()) {
            return pathDefinition;
        }
        int n2 = ((TextScanner)object).nextChar();
        if (n2 != 77 && n2 != 109) {
            return pathDefinition;
        }
        while (true) {
            ((TextScanner)object).skipWhitespace();
            switch (n2) {
                case 65: 
                case 97: {
                    f6 = ((TextScanner)object).nextFloat();
                    f7 = ((TextScanner)object).checkedNextFloat(f6);
                    float f8 = ((TextScanner)object).checkedNextFloat(f7);
                    Boolean bl2 = ((TextScanner)object).checkedNextFlag(Float.valueOf(f8));
                    Boolean bl3 = ((TextScanner)object).checkedNextFlag(bl2);
                    float f9 = ((TextScanner)object).checkedNextFloat(bl3);
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (!(Float.isNaN(f10) || f6 < 0.0f || f7 < 0.0f)) {
                        if (n2 == 97) {
                            f9 += f2;
                            f10 += f3;
                        }
                        pathDefinition.arcTo(f6, f7, f8, bl2, bl3, f9, f10);
                        f6 = f9;
                        f2 = f9;
                        f7 = f10;
                        f3 = f10;
                        break;
                    }
                    Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                    return pathDefinition;
                }
                default: {
                    return pathDefinition;
                }
                case 67: 
                case 99: {
                    f6 = ((TextScanner)object).nextFloat();
                    f7 = ((TextScanner)object).checkedNextFloat(f6);
                    float f8 = ((TextScanner)object).checkedNextFloat(f7);
                    float f11 = ((TextScanner)object).checkedNextFloat(f8);
                    float f9 = ((TextScanner)object).checkedNextFloat(f11);
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 99) {
                        f9 += f2;
                        f10 += f3;
                        f6 += f2;
                        f7 += f3;
                        f8 += f2;
                        f11 += f3;
                    }
                    pathDefinition.cubicTo(f6, f7, f8, f11, f9, f10);
                    f6 = f8;
                    f7 = f11;
                    f2 = f9;
                    f3 = f10;
                    break;
                }
                case 72: 
                case 104: {
                    float f9 = ((TextScanner)object).nextFloat();
                    if (Float.isNaN(f9)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 104) {
                        f9 += f2;
                    }
                    pathDefinition.lineTo(f9, f3);
                    f6 = f9;
                    f2 = f9;
                    break;
                }
                case 76: 
                case 108: {
                    float f9 = ((TextScanner)object).nextFloat();
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 108) {
                        f9 += f2;
                        f10 += f3;
                    }
                    pathDefinition.lineTo(f9, f10);
                    f6 = f9;
                    f2 = f9;
                    f7 = f10;
                    f3 = f10;
                    break;
                }
                case 77: 
                case 109: {
                    float f9 = ((TextScanner)object).nextFloat();
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 109 && !pathDefinition.isEmpty()) {
                        f9 += f2;
                        f10 += f3;
                    }
                    pathDefinition.moveTo(f9, f10);
                    f6 = f9;
                    f4 = f9;
                    f2 = f9;
                    f7 = f10;
                    f5 = f10;
                    f3 = f10;
                    n2 = n2 == 109 ? 108 : 76;
                    break;
                }
                case 81: 
                case 113: {
                    f6 = ((TextScanner)object).nextFloat();
                    f7 = ((TextScanner)object).checkedNextFloat(f6);
                    float f9 = ((TextScanner)object).checkedNextFloat(f7);
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 113) {
                        f9 += f2;
                        f10 += f3;
                        f6 += f2;
                        f7 += f3;
                    }
                    pathDefinition.quadTo(f6, f7, f9, f10);
                    f2 = f9;
                    f3 = f10;
                    break;
                }
                case 83: 
                case 115: {
                    f6 = 2.0f * f2 - f6;
                    f7 = 2.0f * f3 - f7;
                    float f8 = ((TextScanner)object).nextFloat();
                    float f12 = ((TextScanner)object).checkedNextFloat(f8);
                    float f9 = ((TextScanner)object).checkedNextFloat(f12);
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 115) {
                        f9 += f2;
                        f10 += f3;
                        f8 += f2;
                        f12 += f3;
                    }
                    pathDefinition.cubicTo(f6, f7, f8, f12, f9, f10);
                    f6 = f8;
                    f7 = f12;
                    f2 = f9;
                    f3 = f10;
                    break;
                }
                case 84: 
                case 116: {
                    f6 = 2.0f * f2 - f6;
                    f7 = 2.0f * f3 - f7;
                    float f9 = ((TextScanner)object).nextFloat();
                    float f10 = ((TextScanner)object).checkedNextFloat(f9);
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 116) {
                        f9 += f2;
                        f10 += f3;
                    }
                    pathDefinition.quadTo(f6, f7, f9, f10);
                    f2 = f9;
                    f3 = f10;
                    break;
                }
                case 86: 
                case 118: {
                    float f10 = ((TextScanner)object).nextFloat();
                    if (Float.isNaN(f10)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)n2 + " path segment"));
                        return pathDefinition;
                    }
                    if (n2 == 118) {
                        f10 += f3;
                    }
                    pathDefinition.lineTo(f2, f10);
                    f7 = f10;
                    f3 = f10;
                    break;
                }
                case 90: 
                case 122: {
                    pathDefinition.close();
                    f6 = f4;
                    f2 = f4;
                    f7 = f5;
                    f3 = f5;
                }
            }
            ((TextScanner)object).skipCommaWhitespace();
            if (((TextScanner)object).empty()) {
                return pathDefinition;
            }
            if (!((TextScanner)object).hasLetter()) continue;
            n2 = ((TextScanner)object).nextChar();
        }
    }

    private static Set<String> parseRequiredFeatures(String object) {
        object = new TextScanner((String)object);
        HashSet<String> hashSet = new HashSet<String>();
        while (!((TextScanner)object).empty()) {
            String string2 = ((TextScanner)object).nextToken();
            if (string2.startsWith(FEATURE_STRING_PREFIX)) {
                hashSet.add(string2.substring(35));
            } else {
                hashSet.add("UNSUPPORTED");
            }
            ((TextScanner)object).skipWhitespace();
        }
        return hashSet;
    }

    private static Set<String> parseSystemLanguage(String object) {
        object = new TextScanner((String)object);
        HashSet<String> hashSet = new HashSet<String>();
        while (!((TextScanner)object).empty()) {
            String string2 = ((TextScanner)object).nextToken();
            int n2 = string2.indexOf(45);
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            string2 = new Locale(string2, "", "").getLanguage();
            hashSet.add(string2);
            ((TextScanner)object).skipWhitespace();
        }
        return hashSet;
    }

    private static Set<String> parseRequiredFormats(String object) {
        object = new TextScanner((String)object);
        HashSet<String> hashSet = new HashSet<String>();
        while (!((TextScanner)object).empty()) {
            String string2 = ((TextScanner)object).nextToken();
            hashSet.add(string2);
            ((TextScanner)object).skipWhitespace();
        }
        return hashSet;
    }

    private static String parseFunctionalIRI(String string2, String string3) {
        if (string2.equals(NONE)) {
            return null;
        }
        if (!string2.startsWith("url(")) {
            return null;
        }
        if (string2.endsWith(")")) {
            return string2.substring(4, string2.length() - 1).trim();
        }
        return string2.substring(4).trim();
    }

    private void style(Attributes attributes) throws SVGParseException {
        this.debug("<style>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        boolean bl2 = true;
        String string2 = XML_STYLESHEET_ATTR_MEDIA_ALL;
        block4: for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string3 = attributes.getValue(i2).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i2))) {
                case type: {
                    bl2 = string3.equals("text/css");
                    continue block4;
                }
                case media: {
                    string2 = string3;
                }
            }
        }
        if (bl2 && CSSParser.mediaMatches(string2, CSSParser.MediaType.screen)) {
            this.inStyleElement = true;
            return;
        }
        this.ignoring = true;
        this.ignoreDepth = 1;
    }

    private void parseCSSStyleSheet(String string2) {
        CSSParser cSSParser = new CSSParser(CSSParser.MediaType.screen, CSSParser.Source.Document);
        this.svgDocument.addCSSRules(cSSParser.parse(string2));
    }

    private static enum SVGElem {
        svg,
        a,
        circle,
        clipPath,
        defs,
        desc,
        ellipse,
        g,
        image,
        line,
        linearGradient,
        marker,
        mask,
        path,
        pattern,
        polygon,
        polyline,
        radialGradient,
        rect,
        solidColor,
        stop,
        style,
        SWITCH,
        symbol,
        text,
        textPath,
        title,
        tref,
        tspan,
        use,
        view,
        UNSUPPORTED;

        private static final Map<String, SVGElem> cache;

        public static SVGElem fromString(String object) {
            if ((object = cache.get(object)) != null) {
                return object;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGElem>();
            for (SVGElem sVGElem : SVGElem.values()) {
                if (sVGElem == SWITCH) {
                    cache.put("switch", sVGElem);
                    continue;
                }
                if (sVGElem == UNSUPPORTED) continue;
                String string2 = sVGElem.name();
                cache.put(string2, sVGElem);
            }
        }
    }

    private static enum SVGAttr {
        CLASS,
        clip,
        clip_path,
        clipPathUnits,
        clip_rule,
        color,
        cx,
        cy,
        direction,
        dx,
        dy,
        fx,
        fy,
        d,
        display,
        fill,
        fill_rule,
        fill_opacity,
        font,
        font_family,
        font_size,
        font_weight,
        font_style,
        gradientTransform,
        gradientUnits,
        height,
        href,
        image_rendering,
        marker,
        marker_start,
        marker_mid,
        marker_end,
        markerHeight,
        markerUnits,
        markerWidth,
        mask,
        maskContentUnits,
        maskUnits,
        media,
        offset,
        opacity,
        orient,
        overflow,
        pathLength,
        patternContentUnits,
        patternTransform,
        patternUnits,
        points,
        preserveAspectRatio,
        r,
        refX,
        refY,
        requiredFeatures,
        requiredExtensions,
        requiredFormats,
        requiredFonts,
        rx,
        ry,
        solid_color,
        solid_opacity,
        spreadMethod,
        startOffset,
        stop_color,
        stop_opacity,
        stroke,
        stroke_dasharray,
        stroke_dashoffset,
        stroke_linecap,
        stroke_linejoin,
        stroke_miterlimit,
        stroke_opacity,
        stroke_width,
        style,
        systemLanguage,
        text_anchor,
        text_decoration,
        transform,
        type,
        vector_effect,
        version,
        viewBox,
        width,
        x,
        y,
        x1,
        y1,
        x2,
        y2,
        viewport_fill,
        viewport_fill_opacity,
        visibility,
        UNSUPPORTED;

        private static final Map<String, SVGAttr> cache;

        public static SVGAttr fromString(String object) {
            if ((object = cache.get(object)) != null) {
                return object;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGAttr>();
            for (SVGAttr sVGAttr : SVGAttr.values()) {
                if (sVGAttr == CLASS) {
                    cache.put("class", sVGAttr);
                    continue;
                }
                if (sVGAttr == UNSUPPORTED) continue;
                String string2 = sVGAttr.name().replace('_', '-');
                cache.put(string2, sVGAttr);
            }
        }
    }

    private static class ColourKeywords {
        private static final Map<String, Integer> colourKeywords = new HashMap<String, Integer>(47);

        private ColourKeywords() {
        }

        static Integer get(String string2) {
            return colourKeywords.get(string2);
        }

        static {
            colourKeywords.put("aliceblue", -984833);
            colourKeywords.put("antiquewhite", -332841);
            colourKeywords.put("aqua", -16711681);
            colourKeywords.put("aquamarine", -8388652);
            colourKeywords.put("azure", -983041);
            colourKeywords.put("beige", -657956);
            colourKeywords.put("bisque", -6972);
            colourKeywords.put("black", -16777216);
            colourKeywords.put("blanchedalmond", -5171);
            colourKeywords.put("blue", -16776961);
            colourKeywords.put("blueviolet", -7722014);
            colourKeywords.put("brown", -5952982);
            colourKeywords.put("burlywood", -2180985);
            colourKeywords.put("cadetblue", -10510688);
            colourKeywords.put("chartreuse", -8388864);
            colourKeywords.put("chocolate", -2987746);
            colourKeywords.put("coral", -32944);
            colourKeywords.put("cornflowerblue", -10185235);
            colourKeywords.put("cornsilk", -1828);
            colourKeywords.put("crimson", -2354116);
            colourKeywords.put("cyan", -16711681);
            colourKeywords.put("darkblue", -16777077);
            colourKeywords.put("darkcyan", -16741493);
            colourKeywords.put("darkgoldenrod", -4684277);
            colourKeywords.put("darkgray", -5658199);
            colourKeywords.put("darkgreen", -16751616);
            colourKeywords.put("darkgrey", -5658199);
            colourKeywords.put("darkkhaki", -4343957);
            colourKeywords.put("darkmagenta", -7667573);
            colourKeywords.put("darkolivegreen", -11179217);
            colourKeywords.put("darkorange", -29696);
            colourKeywords.put("darkorchid", -6737204);
            colourKeywords.put("darkred", -7667712);
            colourKeywords.put("darksalmon", -1468806);
            colourKeywords.put("darkseagreen", -7357297);
            colourKeywords.put("darkslateblue", -12042869);
            colourKeywords.put("darkslategray", -13676721);
            colourKeywords.put("darkslategrey", -13676721);
            colourKeywords.put("darkturquoise", -16724271);
            colourKeywords.put("darkviolet", -7077677);
            colourKeywords.put("deeppink", -60269);
            colourKeywords.put("deepskyblue", -16728065);
            colourKeywords.put("dimgray", -9868951);
            colourKeywords.put("dimgrey", -9868951);
            colourKeywords.put("dodgerblue", -14774017);
            colourKeywords.put("firebrick", -5103070);
            colourKeywords.put("floralwhite", -1296);
            colourKeywords.put("forestgreen", -14513374);
            colourKeywords.put("fuchsia", -65281);
            colourKeywords.put("gainsboro", -2302756);
            colourKeywords.put("ghostwhite", -460545);
            colourKeywords.put("gold", -10496);
            colourKeywords.put("goldenrod", -2448096);
            colourKeywords.put("gray", -8355712);
            colourKeywords.put("green", -16744448);
            colourKeywords.put("greenyellow", -5374161);
            colourKeywords.put("grey", -8355712);
            colourKeywords.put("honeydew", -983056);
            colourKeywords.put("hotpink", -38476);
            colourKeywords.put("indianred", -3318692);
            colourKeywords.put("indigo", -11861886);
            colourKeywords.put("ivory", -16);
            colourKeywords.put("khaki", -989556);
            colourKeywords.put("lavender", -1644806);
            colourKeywords.put("lavenderblush", -3851);
            colourKeywords.put("lawngreen", -8586240);
            colourKeywords.put("lemonchiffon", -1331);
            colourKeywords.put("lightblue", -5383962);
            colourKeywords.put("lightcoral", -1015680);
            colourKeywords.put("lightcyan", -2031617);
            colourKeywords.put("lightgoldenrodyellow", -329006);
            colourKeywords.put("lightgray", -2894893);
            colourKeywords.put("lightgreen", -7278960);
            colourKeywords.put("lightgrey", -2894893);
            colourKeywords.put("lightpink", -18751);
            colourKeywords.put("lightsalmon", -24454);
            colourKeywords.put("lightseagreen", -14634326);
            colourKeywords.put("lightskyblue", -7876870);
            colourKeywords.put("lightslategray", -8943463);
            colourKeywords.put("lightslategrey", -8943463);
            colourKeywords.put("lightsteelblue", -5192482);
            colourKeywords.put("lightyellow", -32);
            colourKeywords.put("lime", -16711936);
            colourKeywords.put("limegreen", -13447886);
            colourKeywords.put("linen", -331546);
            colourKeywords.put("magenta", -65281);
            colourKeywords.put("maroon", -8388608);
            colourKeywords.put("mediumaquamarine", -10039894);
            colourKeywords.put("mediumblue", -16777011);
            colourKeywords.put("mediumorchid", -4565549);
            colourKeywords.put("mediumpurple", -7114533);
            colourKeywords.put("mediumseagreen", -12799119);
            colourKeywords.put("mediumslateblue", -8689426);
            colourKeywords.put("mediumspringgreen", -16713062);
            colourKeywords.put("mediumturquoise", -12004916);
            colourKeywords.put("mediumvioletred", -3730043);
            colourKeywords.put("midnightblue", -15132304);
            colourKeywords.put("mintcream", -655366);
            colourKeywords.put("mistyrose", -6943);
            colourKeywords.put("moccasin", -6987);
            colourKeywords.put("navajowhite", -8531);
            colourKeywords.put("navy", -16777088);
            colourKeywords.put("oldlace", -133658);
            colourKeywords.put("olive", -8355840);
            colourKeywords.put("olivedrab", -9728477);
            colourKeywords.put("orange", -23296);
            colourKeywords.put("orangered", -47872);
            colourKeywords.put("orchid", -2461482);
            colourKeywords.put("palegoldenrod", -1120086);
            colourKeywords.put("palegreen", -6751336);
            colourKeywords.put("paleturquoise", -5247250);
            colourKeywords.put("palevioletred", -2396013);
            colourKeywords.put("papayawhip", -4139);
            colourKeywords.put("peachpuff", -9543);
            colourKeywords.put("peru", -3308225);
            colourKeywords.put("pink", -16181);
            colourKeywords.put("plum", -2252579);
            colourKeywords.put("powderblue", -5185306);
            colourKeywords.put("purple", -8388480);
            colourKeywords.put("rebeccapurple", -10079335);
            colourKeywords.put("red", -65536);
            colourKeywords.put("rosybrown", -4419697);
            colourKeywords.put("royalblue", -12490271);
            colourKeywords.put("saddlebrown", -7650029);
            colourKeywords.put("salmon", -360334);
            colourKeywords.put("sandybrown", -744352);
            colourKeywords.put("seagreen", -13726889);
            colourKeywords.put("seashell", -2578);
            colourKeywords.put("sienna", -6270419);
            colourKeywords.put("silver", -4144960);
            colourKeywords.put("skyblue", -7876885);
            colourKeywords.put("slateblue", -9807155);
            colourKeywords.put("slategray", -9404272);
            colourKeywords.put("slategrey", -9404272);
            colourKeywords.put("snow", -1286);
            colourKeywords.put("springgreen", -16711809);
            colourKeywords.put("steelblue", -12156236);
            colourKeywords.put("tan", -2968436);
            colourKeywords.put("teal", -16744320);
            colourKeywords.put("thistle", -2572328);
            colourKeywords.put("tomato", -40121);
            colourKeywords.put("turquoise", -12525360);
            colourKeywords.put("violet", -1146130);
            colourKeywords.put("wheat", -663885);
            colourKeywords.put("white", -1);
            colourKeywords.put("whitesmoke", -657931);
            colourKeywords.put("yellow", -256);
            colourKeywords.put("yellowgreen", -6632142);
            colourKeywords.put("transparent", 0);
        }
    }

    private static class FontSizeKeywords {
        private static final Map<String, SVG.Length> fontSizeKeywords = new HashMap<String, SVG.Length>(9);

        private FontSizeKeywords() {
        }

        static SVG.Length get(String string2) {
            return fontSizeKeywords.get(string2);
        }

        static {
            fontSizeKeywords.put("xx-small", new SVG.Length(0.694f, SVG.Unit.pt));
            fontSizeKeywords.put("x-small", new SVG.Length(0.833f, SVG.Unit.pt));
            fontSizeKeywords.put("small", new SVG.Length(10.0f, SVG.Unit.pt));
            fontSizeKeywords.put("medium", new SVG.Length(12.0f, SVG.Unit.pt));
            fontSizeKeywords.put("large", new SVG.Length(14.4f, SVG.Unit.pt));
            fontSizeKeywords.put("x-large", new SVG.Length(17.3f, SVG.Unit.pt));
            fontSizeKeywords.put("xx-large", new SVG.Length(20.7f, SVG.Unit.pt));
            fontSizeKeywords.put("smaller", new SVG.Length(83.33f, SVG.Unit.percent));
            fontSizeKeywords.put("larger", new SVG.Length(120.0f, SVG.Unit.percent));
        }
    }

    private static class FontWeightKeywords {
        private static final Map<String, Integer> fontWeightKeywords = new HashMap<String, Integer>(13);

        private FontWeightKeywords() {
        }

        static Integer get(String string2) {
            return fontWeightKeywords.get(string2);
        }

        static {
            fontWeightKeywords.put("normal", 400);
            fontWeightKeywords.put("bold", 700);
            fontWeightKeywords.put("bolder", 1);
            fontWeightKeywords.put("lighter", -1);
            fontWeightKeywords.put("100", 100);
            fontWeightKeywords.put("200", 200);
            fontWeightKeywords.put("300", 300);
            fontWeightKeywords.put("400", 400);
            fontWeightKeywords.put("500", 500);
            fontWeightKeywords.put("600", 600);
            fontWeightKeywords.put("700", 700);
            fontWeightKeywords.put("800", 800);
            fontWeightKeywords.put("900", 900);
        }
    }

    private static class AspectRatioKeywords {
        private static final Map<String, PreserveAspectRatio.Alignment> aspectRatioKeywords = new HashMap<String, PreserveAspectRatio.Alignment>(10);

        private AspectRatioKeywords() {
        }

        static PreserveAspectRatio.Alignment get(String string2) {
            return aspectRatioKeywords.get(string2);
        }

        static {
            aspectRatioKeywords.put(SVGParser.NONE, PreserveAspectRatio.Alignment.none);
            aspectRatioKeywords.put("xMinYMin", PreserveAspectRatio.Alignment.xMinYMin);
            aspectRatioKeywords.put("xMidYMin", PreserveAspectRatio.Alignment.xMidYMin);
            aspectRatioKeywords.put("xMaxYMin", PreserveAspectRatio.Alignment.xMaxYMin);
            aspectRatioKeywords.put("xMinYMid", PreserveAspectRatio.Alignment.xMinYMid);
            aspectRatioKeywords.put("xMidYMid", PreserveAspectRatio.Alignment.xMidYMid);
            aspectRatioKeywords.put("xMaxYMid", PreserveAspectRatio.Alignment.xMaxYMid);
            aspectRatioKeywords.put("xMinYMax", PreserveAspectRatio.Alignment.xMinYMax);
            aspectRatioKeywords.put("xMidYMax", PreserveAspectRatio.Alignment.xMidYMax);
            aspectRatioKeywords.put("xMaxYMax", PreserveAspectRatio.Alignment.xMaxYMax);
        }
    }

    private class XPPAttributesWrapper
    implements Attributes {
        private XmlPullParser parser;

        public XPPAttributesWrapper(XmlPullParser xmlPullParser) {
            this.parser = xmlPullParser;
        }

        @Override
        public int getLength() {
            return this.parser.getAttributeCount();
        }

        @Override
        public String getURI(int n2) {
            return this.parser.getAttributeNamespace(n2);
        }

        @Override
        public String getLocalName(int n2) {
            return this.parser.getAttributeName(n2);
        }

        @Override
        public String getQName(int n2) {
            String string2 = this.parser.getAttributeName(n2);
            if (this.parser.getAttributePrefix(n2) != null) {
                string2 = this.parser.getAttributePrefix(n2) + ':' + string2;
            }
            return string2;
        }

        @Override
        public String getValue(int n2) {
            return this.parser.getAttributeValue(n2);
        }

        @Override
        public String getType(int n2) {
            return null;
        }

        @Override
        public int getIndex(String string2, String string3) {
            return -1;
        }

        @Override
        public int getIndex(String string2) {
            return -1;
        }

        @Override
        public String getType(String string2, String string3) {
            return null;
        }

        @Override
        public String getType(String string2) {
            return null;
        }

        @Override
        public String getValue(String string2, String string3) {
            return null;
        }

        @Override
        public String getValue(String string2) {
            return null;
        }
    }

    private class SAXHandler
    extends DefaultHandler2 {
        private SAXHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            SVGParser.this.startDocument();
        }

        @Override
        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            SVGParser.this.startElement(string2, string3, string4, attributes);
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            SVGParser.this.text(new String(cArray, n2, n3));
        }

        @Override
        public void endElement(String string2, String string3, String string4) throws SAXException {
            SVGParser.this.endElement(string2, string3, string4);
        }

        @Override
        public void endDocument() throws SAXException {
            SVGParser.this.endDocument();
        }

        @Override
        public void processingInstruction(String string2, String object) throws SAXException {
            object = new TextScanner((String)object);
            object = SVGParser.this.parseProcessingInstructionAttributes((TextScanner)object);
            SVGParser.this.handleProcessingInstruction(string2, (Map)object);
        }
    }

    static class TextScanner {
        String input;
        int position = 0;
        int inputLength = 0;
        private NumberParser numberParser = new NumberParser();

        TextScanner(String string2) {
            this.input = string2.trim();
            this.inputLength = this.input.length();
        }

        boolean empty() {
            return this.position == this.inputLength;
        }

        boolean isWhitespace(int n2) {
            return n2 == 32 || n2 == 10 || n2 == 13 || n2 == 9;
        }

        void skipWhitespace() {
            while (this.position < this.inputLength) {
                TextScanner textScanner = this;
                if (!textScanner.isWhitespace(textScanner.input.charAt(this.position))) break;
                ++this.position;
            }
        }

        boolean isEOL(int n2) {
            return n2 == 10 || n2 == 13;
        }

        boolean skipCommaWhitespace() {
            this.skipWhitespace();
            if (this.position == this.inputLength) {
                return false;
            }
            if (this.input.charAt(this.position) != ',') {
                return false;
            }
            ++this.position;
            this.skipWhitespace();
            return true;
        }

        float nextFloat() {
            float f2 = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(f2)) {
                this.position = this.numberParser.getEndPos();
            }
            return f2;
        }

        float possibleNextFloat() {
            this.skipCommaWhitespace();
            float f2 = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(f2)) {
                this.position = this.numberParser.getEndPos();
            }
            return f2;
        }

        float checkedNextFloat(float f2) {
            if (Float.isNaN(f2)) {
                return Float.NaN;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        float checkedNextFloat(Boolean bl2) {
            if (bl2 == null) {
                return Float.NaN;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        Integer nextChar() {
            if (this.position == this.inputLength) {
                return null;
            }
            return this.input.charAt(this.position++);
        }

        SVG.Length nextLength() {
            float f2 = this.nextFloat();
            if (Float.isNaN(f2)) {
                return null;
            }
            SVG.Unit unit = this.nextUnit();
            if (unit == null) {
                return new SVG.Length(f2, SVG.Unit.px);
            }
            return new SVG.Length(f2, unit);
        }

        Boolean nextFlag() {
            if (this.position == this.inputLength) {
                return null;
            }
            char c2 = this.input.charAt(this.position);
            if (c2 != '0' && c2 != '1') {
                return null;
            }
            ++this.position;
            return c2 == '1';
        }

        Boolean checkedNextFlag(Object object) {
            if (object == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFlag();
        }

        boolean consume(char c2) {
            c2 = this.position < this.inputLength && this.input.charAt(this.position) == c2 ? (char)'\u0001' : '\u0000';
            if (c2 != '\u0000') {
                ++this.position;
            }
            return c2 != '\u0000';
        }

        boolean consume(String string2) {
            int n2 = string2.length();
            boolean bl2 = this.position <= this.inputLength - n2 && this.input.substring(this.position, this.position + n2).equals(string2);
            if (bl2) {
                this.position += n2;
            }
            return bl2;
        }

        int advanceChar() {
            if (this.position == this.inputLength) {
                return -1;
            }
            ++this.position;
            if (this.position < this.inputLength) {
                return this.input.charAt(this.position);
            }
            return -1;
        }

        String nextToken() {
            return this.nextToken(' ', false);
        }

        String nextToken(char c2) {
            return this.nextToken(c2, false);
        }

        String nextTokenWithWhitespace(char c2) {
            return this.nextToken(c2, true);
        }

        String nextToken(char c2, boolean bl2) {
            if (this.empty()) {
                return null;
            }
            int n2 = this.input.charAt(this.position);
            if ((bl2 || !this.isWhitespace(n2)) && n2 != c2) {
                int n3 = this.position;
                n2 = this.advanceChar();
                while (n2 != -1 && n2 != c2 && (bl2 || !this.isWhitespace(n2))) {
                    n2 = this.advanceChar();
                }
                return this.input.substring(n3, this.position);
            }
            return null;
        }

        String nextWord() {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            int n3 = this.input.charAt(this.position);
            if (n3 >= 65 && n3 <= 90 || n3 >= 97 && n3 <= 122) {
                n3 = this.advanceChar();
                while (n3 >= 65 && n3 <= 90 || n3 >= 97 && n3 <= 122) {
                    n3 = this.advanceChar();
                }
                return this.input.substring(n2, this.position);
            }
            this.position = n2;
            return null;
        }

        String nextFunction() {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            int n3 = this.input.charAt(this.position);
            while (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90) {
                n3 = this.advanceChar();
            }
            int n4 = this.position;
            while (this.isWhitespace(n3)) {
                n3 = this.advanceChar();
            }
            if (n3 == 40) {
                ++this.position;
                return this.input.substring(n2, n4);
            }
            this.position = n2;
            return null;
        }

        String ahead() {
            int n2 = this.position;
            while (!this.empty()) {
                TextScanner textScanner = this;
                if (textScanner.isWhitespace(textScanner.input.charAt(this.position))) break;
                ++this.position;
            }
            String string2 = this.input.substring(n2, this.position);
            this.position = n2;
            return string2;
        }

        SVG.Unit nextUnit() {
            if (this.empty()) {
                return null;
            }
            if (this.input.charAt(this.position) == '%') {
                ++this.position;
                return SVG.Unit.percent;
            }
            if (this.position > this.inputLength - 2) {
                return null;
            }
            try {
                SVG.Unit unit = SVG.Unit.valueOf(this.input.substring(this.position, this.position + 2).toLowerCase(Locale.US));
                this.position += 2;
                return unit;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        boolean hasLetter() {
            if (this.position == this.inputLength) {
                return false;
            }
            char c2 = this.input.charAt(this.position);
            return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
        }

        String nextQuotedString() {
            int n2;
            if (this.empty()) {
                return null;
            }
            int n3 = this.position;
            int n4 = n2 = this.input.charAt(this.position);
            if (n2 != 39 && n2 != 34) {
                return null;
            }
            while ((n2 = this.advanceChar()) != -1 && n2 != n4) {
            }
            if (n2 == -1) {
                this.position = n3;
                return null;
            }
            ++this.position;
            return this.input.substring(n3 + 1, this.position - 1);
        }

        String restOfText() {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            this.position = this.inputLength;
            return this.input.substring(n2);
        }
    }
}

