/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils;

import android.util.Pair;
import com.amap.api.col.3nsl.dz;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.DPoint;
import java.util.ArrayList;
import java.util.List;

public class SpatialRelationUtil {
    public static final int MIN_POLYLINE_POINT_SIZE = 2;
    public static final int A_HALF_CIRCLE_DEGREE = 180;
    public static final int A_CIRCLE_DEGREE = 360;
    public static final int MIN_OFFSET_DEGREE = 50;

    public static Pair<Integer, LatLng> calShortestDistancePoint(List<LatLng> object, LatLng latLng, float f2, double d2) {
        try {
            Pair<Integer, DPoint> pair;
            if (object == null || latLng == null || object.size() == 0) {
                return null;
            }
            ArrayList<DPoint> arrayList = new ArrayList<DPoint>();
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                pair = (Pair<Integer, DPoint>)object.next();
                arrayList.add(DPoint.obtain(pair.latitude, pair.longitude));
                if (pair.equals((Object)latLng)) {
                    return new Pair((Object)n2, (Object)latLng);
                }
                ++n2;
            }
            object = DPoint.obtain(latLng.latitude, latLng.longitude);
            pair = SpatialRelationUtil.calShortestDistancePoint(arrayList, (DPoint)object, f2);
            if (pair != null) {
                object = (DPoint)pair.second;
                LatLng latLng2 = new LatLng(((DPoint)object).x, ((DPoint)object).y);
                if ((double)AMapUtils.calculateLineDistance(latLng2, latLng) < d2) {
                    return new Pair(pair.first, (Object)new LatLng(((DPoint)pair.second).x, ((DPoint)pair.second).y));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Pair<Integer, LatLng> calShortestDistancePoint(List<LatLng> object, LatLng latLng) {
        try {
            Pair<Integer, DPoint> pair;
            if (object == null || latLng == null || object.size() == 0) {
                return null;
            }
            ArrayList<DPoint> arrayList = new ArrayList<DPoint>();
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                pair = (Pair<Integer, DPoint>)object.next();
                arrayList.add(DPoint.obtain(pair.latitude, pair.longitude));
                if (pair.equals((Object)latLng)) {
                    return new Pair((Object)n2, (Object)latLng);
                }
                ++n2;
            }
            object = DPoint.obtain(latLng.latitude, latLng.longitude);
            pair = SpatialRelationUtil.calShortestDistancePoint(arrayList, (DPoint)object);
            if (pair != null) {
                return new Pair(pair.first, (Object)new LatLng(((DPoint)pair.second).x, ((DPoint)pair.second).y));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Pair<Integer, DPoint> calShortestDistancePoint(List<DPoint> list, DPoint dPoint) {
        return SpatialRelationUtil.calShortestDistancePoint(list, dPoint, -1.0f);
    }

    public static Pair<Integer, DPoint> calShortestDistancePoint(List<DPoint> list, DPoint dPoint, float f2) {
        if (list == null || dPoint == null || list.size() == 0) {
            return null;
        }
        if (list.size() < 2) {
            return null;
        }
        Pair pair = null;
        DPoint dPoint2 = dPoint;
        Pair<Double, DPoint> pair2 = list.get(0);
        double d2 = 0.0;
        int n2 = list.size();
        for (int i2 = 1; i2 <= n2 - 1; ++i2) {
            DPoint dPoint3 = list.get(i2);
            if (i2 == n2 - 1 && dPoint3.equals(dPoint)) {
                return new Pair((Object)i2, (Object)dPoint);
            }
            if (SpatialRelationUtil.checkRotateIsMatch((DPoint)pair2, dPoint3, f2)) {
                if (pair2.equals((Object)dPoint)) {
                    return new Pair((Object)(i2 - 1), (Object)dPoint);
                }
                pair2 = SpatialRelationUtil.pointToSegDist(dPoint2.x, dPoint2.y, pair2.x, pair2.y, dPoint3.x, dPoint3.y);
                if (pair == null) {
                    d2 = (Double)pair2.first;
                    pair = new Pair((Object)(i2 - 1), pair2.second);
                } else if (d2 > (Double)pair2.first) {
                    d2 = (Double)pair2.first;
                    pair = new Pair((Object)(i2 - 1), pair2.second);
                }
            }
            pair2 = dPoint3;
        }
        return pair;
    }

    private static boolean checkRotateIsMatch(DPoint dPoint, DPoint dPoint2, float f2) {
        float f3;
        if (f2 == -1.0f) {
            return true;
        }
        if (dPoint == null || dPoint2 == null) {
            return false;
        }
        float f4 = Math.abs(dz.a(dPoint, dPoint2) + 360.0f - f2) % 360.0f;
        if (f3 > 180.0f) {
            f4 = 360.0f - f4;
        }
        return f4 < 50.0f;
    }

    private static Pair<Double, DPoint> pointToSegDist(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = (d6 - d4) * (d2 - d4) + (d7 - d5) * (d3 - d5);
        if (d8 <= 0.0) {
            return new Pair((Object)Math.sqrt((d2 - d4) * (d2 - d4) + (d3 - d5) * (d3 - d5)), (Object)new DPoint(d4, d5));
        }
        double d10 = (d6 - d4) * (d6 - d4) + (d7 - d5) * (d7 - d5);
        if (d9 >= d10) {
            return new Pair((Object)Math.sqrt((d2 - d6) * (d2 - d6) + (d3 - d7) * (d3 - d7)), (Object)new DPoint(d6, d7));
        }
        double d11 = d9 / d10;
        double d12 = d4 + (d6 - d4) * d11;
        double d13 = d5 + (d7 - d5) * d11;
        double d14 = Math.sqrt((d2 - d12) * (d2 - d12) + (d13 - d3) * (d13 - d3));
        return new Pair((Object)d14, (Object)new DPoint(d12, d13));
    }
}

