package com.sd.geelyhmiweb.ui

import android.Manifest
import android.content.Intent
import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import com.permissionx.guolindev.PermissionX
import com.sd.geelyhmiweb.MainActivity
import com.sd.geelyhmiweb.databinding.ActivityLoginBinding
import com.sd.geelyhmiweb.utils.ToastHelper
import com.sd.geelyhmiweb.viewmodels.LoginVM
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class LoginActivity : AppCompatActivity() {
    private lateinit var binding: ActivityLoginBinding

    private val loginVM: LoginVM by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)
        requestPers()
        setLisener()
    }

    private fun login() {
        val userName = binding.etName.text.toString()
        val passWord = binding.etPassword.text.toString()
        loginVM.login(userName, passWord).observe(this) {
            if (it) {
                val intent = Intent(this, MainActivity::class.java)
                intent.putExtra("name", userName)
                startActivity(intent)
            }
        }
    }

    private fun setLisener() {
        binding.btnLogin.setOnClickListener {
            login()
        }
    }


    fun requestPers() {
        var list = listOf(
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_EXTERNAL_STORAGE,
        )
        PermissionX.init(this)
            .permissions(list)
            .onExplainRequestReason { scope, deniedList ->
                scope.showRequestReasonDialog(
                    deniedList,
                    "需要同意以下授权才能正常使用",
                    "好的",
                    "取消"
                )
            }
//            .onForwardToSettings { scope, deniedList ->
//                scope.showForwardToSettingsDialog(deniedList, "您需要手动在‘设置’中允许必要的权限", "OK", "Cancel")
//            }
            .request { allGranted, grantedList, deniedList ->
                if (allGranted) {
//                    ToastHelper.showShort(this, "All permissions are granted")
                } else {
                    ToastHelper.showShort(this, "权限被拒")
                    binding.root.postDelayed({
                        finish()
                    }, 150)
                }
            }

    }


}