package com.sd.geelyhmiweb.net

import com.google.gson.Gson
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody
import okhttp3.RequestBody.Companion.toRequestBody


object RequestBodyUtil {


    /**
     * 将参数封装成requestBody形式上传参数
     * @param param 参数
     * @return RequestBody
     */
    fun toRequestBody(map: Map<String, Any>): RequestBody {
        val gson = Gson()
        var param = gson.toJson(map)
        return param.toRequestBody("application/json;charset=UTF-8".toMediaTypeOrNull())
    }


    fun toRequestBody(any: Any): RequestBody {
        var gson = Gson()
        return gson.toJson(any)
            .toRequestBody("application/json;charset=UTF-8".toMediaTypeOrNull())
    }



}