package com.sd.geelyhmiweb

import android.net.http.SslError
import android.os.Bundle
import android.util.Log
import android.webkit.ConsoleMessage
import android.webkit.SslErrorHandler
import android.webkit.WebChromeClient
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebSettings
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import com.sd.geelyhmiweb.databinding.ActivityMainBinding
import com.sd.geelyhmiweb.viewmodels.MainVM
import dagger.hilt.android.AndroidEntryPoint
import kotlin.getValue

@AndroidEntryPoint
class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private var mainVM: MainVM by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        initWeb()
    }


    fun initWeb() {
        var jsApi = JsApi()
        jsApi.mainVM = mainVM

        binding.dwebview.addJavascriptObject(jsApi, null)
//        DWebView.setWebContentsDebuggingEnabled(true)
        binding.dwebview.settings.run {
//            userAgentString="Mozilla/5.0 (Linux; Android 10; Mobile) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.72 Mobile Safari/537.36"
            javaScriptEnabled = true
            javaScriptCanOpenWindowsAutomatically = true
            loadWithOverviewMode = true
            pluginState = WebSettings.PluginState.ON
            domStorageEnabled = true
            setAllowFileAccess(true)
            setAllowContentAccess(true)
            databaseEnabled = true
            //解决跨域问题
            setAllowFileAccessFromFileURLs(true)
            setAllowUniversalAccessFromFileURLs(true)
        }
        val url = "file:///android_asset/dist/index.html"
//        val url = "http://192.168.60.134:8081/#/index.html"
//        val url = "http://82.156.182.48:8088/3dmap/"
//        val url = "https://10.149.230.104:19443/shudao-navigation3d-app/index"
//        val url = "https://172.29.128.38:13443/shudao-navigation3d-app/index"
        binding.dwebview.loadUrl(url)

        binding.dwebview.webViewClient = object : WebViewClient() {
            override fun shouldInterceptRequest(
                view: WebView?,
                request: WebResourceRequest
            ): WebResourceResponse? {
//                var headers=request.requestHeaders
//                headers.put("Referer", "https://www.tianditu.gov.cn/")
//                headers.put("sec-ch-ua-platform", "")
//                headers.put("","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0")
                return super.shouldInterceptRequest(view, request)
            }


            override fun onReceivedSslError(
                view: WebView?,
                handler: SslErrorHandler?,
                error: SslError?
            ) {
//                super.onReceivedSslError(view, handler, error)
                handler?.proceed()
            }

            override fun onReceivedError(
                view: WebView?,
                request: WebResourceRequest?,
                error: WebResourceError?
            ) {
                super.onReceivedError(view, request, error)
            }

            override fun onReceivedHttpError(
                view: WebView?,
                request: WebResourceRequest?,
                errorResponse: WebResourceResponse?
            ) {
                super.onReceivedHttpError(view, request, errorResponse)
            }
        }

        binding.dwebview.webChromeClient = object : WebChromeClient() {

            override fun onConsoleMessage(message: ConsoleMessage?): Boolean {
                Log.d(
                    "---pxl ",
                    "${message?.message()} -- From line " + "${message?.lineNumber()} of ${message?.sourceId()}"
                )
                return true
            }
        }

    }


}