!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).Cesium={})}(this,(function(exports){"use strict";function defined(e){return null!=e}function DeveloperError(e){let t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}defined(Object.create)&&(DeveloperError.prototype=Object.create(Error.prototype),DeveloperError.prototype.constructor=DeveloperError),DeveloperError.prototype.toString=function(){let e=`${this.name}: ${this.message}`;return defined(this.stack)&&(e+=`\n${this.stack.toString()}`),e},DeveloperError.throwInstantiationError=function(){throw new DeveloperError("This function defines an interface and should not be called directly.")};const Check={};function getUndefinedErrorMessage(e){return`${e} is required, actual value was undefined`}function getFailedTypeErrorMessage(e,t,n){return`Expected ${n} to be typeof ${t}, actual typeof was ${e}`}function defaultValue(e,t){return null!=e?e:t}Check.typeOf={},Check.defined=function(e,t){if(!defined(t))throw new DeveloperError(getUndefinedErrorMessage(e))},Check.typeOf.func=function(e,t){if("function"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"function",e))},Check.typeOf.string=function(e,t){if("string"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"string",e))},Check.typeOf.number=function(e,t){if("number"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"number",e))},Check.typeOf.number.lessThan=function(e,t,n){if(Check.typeOf.number(e,t),t>=n)throw new DeveloperError(`Expected ${e} to be less than ${n}, actual value was ${t}`)},Check.typeOf.number.lessThanOrEquals=function(e,t,n){if(Check.typeOf.number(e,t),t>n)throw new DeveloperError(`Expected ${e} to be less than or equal to ${n}, actual value was ${t}`)},Check.typeOf.number.greaterThan=function(e,t,n){if(Check.typeOf.number(e,t),t<=n)throw new DeveloperError(`Expected ${e} to be greater than ${n}, actual value was ${t}`)},Check.typeOf.number.greaterThanOrEquals=function(e,t,n){if(Check.typeOf.number(e,t),t<n)throw new DeveloperError(`Expected ${e} to be greater than or equal to ${n}, actual value was ${t}`)},Check.typeOf.object=function(e,t){if("object"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"object",e))},Check.typeOf.bool=function(e,t){if("boolean"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"boolean",e))},Check.typeOf.bigint=function(e,t){if("bigint"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"bigint",e))},Check.typeOf.number.equals=function(e,t,n,i){if(Check.typeOf.number(e,n),Check.typeOf.number(t,i),n!==i)throw new DeveloperError(`${e} must be equal to ${t}, the actual values are ${n} and ${i}`)},defaultValue.EMPTY_OBJECT=Object.freeze({});var MersenneTwister=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,e.constructor==Array?this.init_by_array(e,e.length):this.init_seed(e)};MersenneTwister.prototype.init_seed=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},MersenneTwister.prototype.init_by_array=function(e,t){var n,i,r;for(this.init_seed(19650218),n=1,i=0,r=this.N>t?this.N:t;r;r--){var o=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(1664525*((4294901760&o)>>>16)<<16)+1664525*(65535&o))+e[i]+i,this.mt[n]>>>=0,i++,++n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1),i>=t&&(i=0)}for(r=this.N-1;r;r--){o=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(1566083941*((4294901760&o)>>>16)<<16)+1566083941*(65535&o))-n,this.mt[n]>>>=0,++n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1)}this.mt[0]=2147483648},MersenneTwister.prototype.random_int=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_seed(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},MersenneTwister.prototype.random_int31=function(){return this.random_int()>>>1},MersenneTwister.prototype.random_incl=function(){return this.random_int()*(1/4294967295)},MersenneTwister.prototype.random=function(){return this.random_int()*(1/4294967296)},MersenneTwister.prototype.random_excl=function(){return(this.random_int()+.5)*(1/4294967296)},MersenneTwister.prototype.random_long=function(){return(67108864*(this.random_int()>>>5)+(this.random_int()>>>6))*(1/9007199254740992)};var mersenneTwister=MersenneTwister;const CesiumMath={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};CesiumMath.sign=defaultValue(Math.sign,(function(e){return 0===(e=+e)||e!=e?e:e>0?1:-1})),CesiumMath.signNotZero=function(e){return e<0?-1:1},CesiumMath.toSNorm=function(e,t){return t=defaultValue(t,255),Math.round((.5*CesiumMath.clamp(e,-1,1)+.5)*t)},CesiumMath.fromSNorm=function(e,t){return t=defaultValue(t,255),CesiumMath.clamp(e,0,t)/t*2-1},CesiumMath.normalize=function(e,t,n){return 0===(n=Math.max(n-t,0))?0:CesiumMath.clamp((e-t)/n,0,1)},CesiumMath.sinh=defaultValue(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),CesiumMath.cosh=defaultValue(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),CesiumMath.lerp=function(e,t,n){return(1-n)*e+n*t},CesiumMath.PI=Math.PI,CesiumMath.ONE_OVER_PI=1/Math.PI,CesiumMath.PI_OVER_TWO=Math.PI/2,CesiumMath.PI_OVER_THREE=Math.PI/3,CesiumMath.PI_OVER_FOUR=Math.PI/4,CesiumMath.PI_OVER_SIX=Math.PI/6,CesiumMath.THREE_PI_OVER_TWO=3*Math.PI/2,CesiumMath.TWO_PI=2*Math.PI,CesiumMath.ONE_OVER_TWO_PI=1/(2*Math.PI),CesiumMath.RADIANS_PER_DEGREE=Math.PI/180,CesiumMath.DEGREES_PER_RADIAN=180/Math.PI,CesiumMath.RADIANS_PER_ARCSECOND=CesiumMath.RADIANS_PER_DEGREE/3600,CesiumMath.toRadians=function(e){return e*CesiumMath.RADIANS_PER_DEGREE},CesiumMath.toDegrees=function(e){return e*CesiumMath.DEGREES_PER_RADIAN},CesiumMath.convertLongitudeRange=function(e){const t=CesiumMath.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},CesiumMath.clampToLatitudeRange=function(e){return CesiumMath.clamp(e,-1*CesiumMath.PI_OVER_TWO,CesiumMath.PI_OVER_TWO)},CesiumMath.negativePiToPi=function(e){return e>=-CesiumMath.PI&&e<=CesiumMath.PI?e:CesiumMath.zeroToTwoPi(e+CesiumMath.PI)-CesiumMath.PI},CesiumMath.zeroToTwoPi=function(e){if(e>=0&&e<=CesiumMath.TWO_PI)return e;const t=CesiumMath.mod(e,CesiumMath.TWO_PI);return Math.abs(t)<CesiumMath.EPSILON14&&Math.abs(e)>CesiumMath.EPSILON14?CesiumMath.TWO_PI:t},CesiumMath.mod=function(e,t){return CesiumMath.sign(e)===CesiumMath.sign(t)&&Math.abs(e)<Math.abs(t)?e:(e%t+t)%t},CesiumMath.equalsEpsilon=function(e,t,n,i){n=defaultValue(n,0),i=defaultValue(i,n);const r=Math.abs(e-t);return r<=i||r<=n*Math.max(Math.abs(e),Math.abs(t))},CesiumMath.lessThan=function(e,t,n){return e-t<-n},CesiumMath.lessThanOrEquals=function(e,t,n){return e-t<n},CesiumMath.greaterThan=function(e,t,n){return e-t>n},CesiumMath.greaterThanOrEquals=function(e,t,n){return e-t>-n};const factorials=[1];CesiumMath.factorial=function(e){const t=factorials.length;if(e>=t){let n=factorials[t-1];for(let i=t;i<=e;i++){const e=n*i;factorials.push(e),n=e}}return factorials[e]},CesiumMath.incrementWrap=function(e,t,n){return n=defaultValue(n,0),++e>t&&(e=n),e},CesiumMath.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},CesiumMath.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},CesiumMath.previousPowerOfTwo=function(e){return e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,e=((e|=e>>32)>>>0)-(e>>>1)},CesiumMath.clamp=function(e,t,n){return e<t?t:e>n?n:e};let randomNumberGenerator$2=new mersenneTwister;function Cartesian3(e,t,n){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(n,0)}CesiumMath.setRandomNumberSeed=function(e){randomNumberGenerator$2=new mersenneTwister(e)},CesiumMath.nextRandomNumber=function(){return randomNumberGenerator$2.random()},CesiumMath.randomBetween=function(e,t){return CesiumMath.nextRandomNumber()*(t-e)+e},CesiumMath.acosClamped=function(e){return Math.acos(CesiumMath.clamp(e,-1,1))},CesiumMath.asinClamped=function(e){return Math.asin(CesiumMath.clamp(e,-1,1))},CesiumMath.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},CesiumMath.logBase=function(e,t){return Math.log(e)/Math.log(t)},CesiumMath.cbrt=defaultValue(Math.cbrt,(function(e){const t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),CesiumMath.log2=defaultValue(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),CesiumMath.fog=function(e,t){const n=e*t;return 1-Math.exp(-n*n)},CesiumMath.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},CesiumMath.fastApproximateAtan2=function(e,t){let n,i=Math.abs(e);n=Math.abs(t);const r=Math.max(i,n);n=Math.min(i,n);const o=n/r;return i=CesiumMath.fastApproximateAtan(o),i=Math.abs(t)>Math.abs(e)?CesiumMath.PI_OVER_TWO-i:i,i=e<0?CesiumMath.PI-i:i,i=t<0?-i:i,i},Cartesian3.fromSpherical=function(e,t){defined(t)||(t=new Cartesian3);const n=e.clock,i=e.cone,r=defaultValue(e.magnitude,1),o=r*Math.sin(i);return t.x=o*Math.cos(n),t.y=o*Math.sin(n),t.z=r*Math.cos(i),t},Cartesian3.fromElements=function(e,t,n,i){return defined(i)?(i.x=e,i.y=t,i.z=n,i):new Cartesian3(e,t,n)},Cartesian3.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Cartesian3(e.x,e.y,e.z)},Cartesian3.fromCartesian4=Cartesian3.clone,Cartesian3.packedLength=3,Cartesian3.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n]=e.z,t},Cartesian3.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Cartesian3),n.x=e[t++],n.y=e[t++],n.z=e[t],n},Cartesian3.packArray=function(e,t){const n=e.length,i=3*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Cartesian3.pack(e[i],t,3*i);return t},Cartesian3.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/3:t=new Array(n/3);for(let i=0;i<n;i+=3){const n=i/3;t[n]=Cartesian3.unpack(e,i,t[n])}return t},Cartesian3.fromArray=Cartesian3.unpack,Cartesian3.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},Cartesian3.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},Cartesian3.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},Cartesian3.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},Cartesian3.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},Cartesian3.magnitude=function(e){return Math.sqrt(Cartesian3.magnitudeSquared(e))};const distanceScratch$3=new Cartesian3;Cartesian3.distance=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitude(distanceScratch$3)},Cartesian3.distanceSquared=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitudeSquared(distanceScratch$3)},Cartesian3.normalize=function(e,t){const n=Cartesian3.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},Cartesian3.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},Cartesian3.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},Cartesian3.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n},Cartesian3.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},Cartesian3.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},Cartesian3.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},Cartesian3.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},Cartesian3.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},Cartesian3.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};const lerpScratch$3=new Cartesian3;Cartesian3.lerp=function(e,t,n,i){return Cartesian3.multiplyByScalar(t,n,lerpScratch$3),i=Cartesian3.multiplyByScalar(e,1-n,i),Cartesian3.add(lerpScratch$3,i,i)};const angleBetweenScratch$1=new Cartesian3,angleBetweenScratch2$1=new Cartesian3;Cartesian3.angleBetween=function(e,t){Cartesian3.normalize(e,angleBetweenScratch$1),Cartesian3.normalize(t,angleBetweenScratch2$1);const n=Cartesian3.dot(angleBetweenScratch$1,angleBetweenScratch2$1),i=Cartesian3.magnitude(Cartesian3.cross(angleBetweenScratch$1,angleBetweenScratch2$1,angleBetweenScratch$1));return Math.atan2(i,n)};const mostOrthogonalAxisScratch$2=new Cartesian3;Cartesian3.mostOrthogonalAxis=function(e,t){const n=Cartesian3.normalize(e,mostOrthogonalAxisScratch$2);return Cartesian3.abs(n,n),t=n.x<=n.y?n.x<=n.z?Cartesian3.clone(Cartesian3.UNIT_X,t):Cartesian3.clone(Cartesian3.UNIT_Z,t):n.y<=n.z?Cartesian3.clone(Cartesian3.UNIT_Y,t):Cartesian3.clone(Cartesian3.UNIT_Z,t)},Cartesian3.projectVector=function(e,t,n){const i=Cartesian3.dot(e,t)/Cartesian3.dot(t,t);return Cartesian3.multiplyByScalar(t,i,n)},Cartesian3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},Cartesian3.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},Cartesian3.equalsEpsilon=function(e,t,n,i){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,n,i)&&CesiumMath.equalsEpsilon(e.y,t.y,n,i)&&CesiumMath.equalsEpsilon(e.z,t.z,n,i)},Cartesian3.cross=function(e,t,n){const i=e.x,r=e.y,o=e.z,a=t.x,s=t.y,c=t.z,l=r*c-o*s,u=o*a-i*c,d=i*s-r*a;return n.x=l,n.y=u,n.z=d,n},Cartesian3.midpoint=function(e,t,n){return n.x=.5*(e.x+t.x),n.y=.5*(e.y+t.y),n.z=.5*(e.z+t.z),n},Cartesian3.fromDegrees=function(e,t,n,i,r){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartesian3.fromRadians(e,t,n,i,r)};let scratchN=new Cartesian3,scratchK=new Cartesian3;const wgs84RadiiSquared=new Cartesian3(40680631590769,40680631590769,40408299984661.445);Cartesian3.fromRadians=function(e,t,n,i,r){n=defaultValue(n,0);const o=defined(i)?i.radiiSquared:wgs84RadiiSquared,a=Math.cos(t);scratchN.x=a*Math.cos(e),scratchN.y=a*Math.sin(e),scratchN.z=Math.sin(t),scratchN=Cartesian3.normalize(scratchN,scratchN),Cartesian3.multiplyComponents(o,scratchN,scratchK);const s=Math.sqrt(Cartesian3.dot(scratchN,scratchK));return scratchK=Cartesian3.divideByScalar(scratchK,s,scratchK),scratchN=Cartesian3.multiplyByScalar(scratchN,n,scratchN),defined(r)||(r=new Cartesian3),Cartesian3.add(scratchK,scratchN,r)},Cartesian3.fromDegreesArray=function(e,t,n){const i=e.length;defined(n)?n.length=i/2:n=new Array(i/2);for(let r=0;r<i;r+=2){const i=e[r],o=e[r+1],a=r/2;n[a]=Cartesian3.fromDegrees(i,o,0,t,n[a])}return n},Cartesian3.fromRadiansArray=function(e,t,n){const i=e.length;defined(n)?n.length=i/2:n=new Array(i/2);for(let r=0;r<i;r+=2){const i=e[r],o=e[r+1],a=r/2;n[a]=Cartesian3.fromRadians(i,o,0,t,n[a])}return n},Cartesian3.fromDegreesArrayHeights=function(e,t,n){const i=e.length;defined(n)?n.length=i/3:n=new Array(i/3);for(let r=0;r<i;r+=3){const i=e[r],o=e[r+1],a=e[r+2],s=r/3;n[s]=Cartesian3.fromDegrees(i,o,a,t,n[s])}return n},Cartesian3.fromRadiansArrayHeights=function(e,t,n){const i=e.length;defined(n)?n.length=i/3:n=new Array(i/3);for(let r=0;r<i;r+=3){const i=e[r],o=e[r+1],a=e[r+2],s=r/3;n[s]=Cartesian3.fromRadians(i,o,a,t,n[s])}return n},Cartesian3.ZERO=Object.freeze(new Cartesian3(0,0,0)),Cartesian3.ONE=Object.freeze(new Cartesian3(1,1,1)),Cartesian3.UNIT_X=Object.freeze(new Cartesian3(1,0,0)),Cartesian3.UNIT_Y=Object.freeze(new Cartesian3(0,1,0)),Cartesian3.UNIT_Z=Object.freeze(new Cartesian3(0,0,1)),Cartesian3.prototype.clone=function(e){return Cartesian3.clone(this,e)},Cartesian3.prototype.equals=function(e){return Cartesian3.equals(this,e)},Cartesian3.prototype.equalsEpsilon=function(e,t,n){return Cartesian3.equalsEpsilon(this,e,t,n)},Cartesian3.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z})`};const scaleToGeodeticSurfaceIntersection=new Cartesian3,scaleToGeodeticSurfaceGradient=new Cartesian3;function scaleToGeodeticSurface(e,t,n,i,r){const o=e.x,a=e.y,s=e.z,c=t.x,l=t.y,u=t.z,d=o*o*c*c,h=a*a*l*l,p=s*s*u*u,f=d+h+p,m=Math.sqrt(1/f),g=Cartesian3.multiplyByScalar(e,m,scaleToGeodeticSurfaceIntersection);if(f<i)return isFinite(m)?Cartesian3.clone(g,r):void 0;const _=n.x,y=n.y,C=n.z,T=scaleToGeodeticSurfaceGradient;T.x=g.x*_*2,T.y=g.y*y*2,T.z=g.z*C*2;let S,A,v,E,b,x,P,D,w,M,I,R=(1-m)*Cartesian3.magnitude(e)/(.5*Cartesian3.magnitude(T)),O=0;do{R-=O,v=1/(1+R*_),E=1/(1+R*y),b=1/(1+R*C),x=v*v,P=E*E,D=b*b,w=x*v,M=P*E,I=D*b,S=d*x+h*P+p*D-1,A=d*w*_+h*M*y+p*I*C;O=S/(-2*A)}while(Math.abs(S)>CesiumMath.EPSILON12);return defined(r)?(r.x=o*v,r.y=a*E,r.z=s*b,r):new Cartesian3(o*v,a*E,s*b)}function Cartographic(e,t,n){this.longitude=defaultValue(e,0),this.latitude=defaultValue(t,0),this.height=defaultValue(n,0)}Cartographic.fromRadians=function(e,t,n,i){return n=defaultValue(n,0),defined(i)?(i.longitude=e,i.latitude=t,i.height=n,i):new Cartographic(e,t,n)},Cartographic.fromDegrees=function(e,t,n,i){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartographic.fromRadians(e,t,n,i)};const cartesianToCartographicN$1=new Cartesian3,cartesianToCartographicP$1=new Cartesian3,cartesianToCartographicH$1=new Cartesian3,wgs84OneOverRadii=new Cartesian3(1/6378137,1/6378137,1/6356752.314245179),wgs84OneOverRadiiSquared=new Cartesian3(1/40680631590769,1/40680631590769,1/40408299984661.445),wgs84CenterToleranceSquared=CesiumMath.EPSILON1;function initialize$e(e,t,n,i){t=defaultValue(t,0),n=defaultValue(n,0),i=defaultValue(i,0),e._radii=new Cartesian3(t,n,i),e._radiiSquared=new Cartesian3(t*t,n*n,i*i),e._radiiToTheFourth=new Cartesian3(t*t*t*t,n*n*n*n,i*i*i*i),e._oneOverRadii=new Cartesian3(0===t?0:1/t,0===n?0:1/n,0===i?0:1/i),e._oneOverRadiiSquared=new Cartesian3(0===t?0:1/(t*t),0===n?0:1/(n*n),0===i?0:1/(i*i)),e._minimumRadius=Math.min(t,n,i),e._maximumRadius=Math.max(t,n,i),e._centerToleranceSquared=CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function Ellipsoid(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,initialize$e(this,e,t,n)}Cartographic.fromCartesian=function(e,t,n){const i=defined(t)?t.oneOverRadii:wgs84OneOverRadii,r=defined(t)?t.oneOverRadiiSquared:wgs84OneOverRadiiSquared,o=scaleToGeodeticSurface(e,i,r,defined(t)?t._centerToleranceSquared:wgs84CenterToleranceSquared,cartesianToCartographicP$1);if(!defined(o))return;let a=Cartesian3.multiplyComponents(o,r,cartesianToCartographicN$1);a=Cartesian3.normalize(a,a);const s=Cartesian3.subtract(e,o,cartesianToCartographicH$1),c=Math.atan2(a.y,a.x),l=Math.asin(a.z),u=CesiumMath.sign(Cartesian3.dot(s,e))*Cartesian3.magnitude(s);return defined(n)?(n.longitude=c,n.latitude=l,n.height=u,n):new Cartographic(c,l,u)},Cartographic.toCartesian=function(e,t,n){return Cartesian3.fromRadians(e.longitude,e.latitude,e.height,t,n)},Cartographic.clone=function(e,t){if(defined(e))return defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Cartographic(e.longitude,e.latitude,e.height)},Cartographic.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},Cartographic.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},Cartographic.ZERO=Object.freeze(new Cartographic(0,0,0)),Cartographic.prototype.clone=function(e){return Cartographic.clone(this,e)},Cartographic.prototype.equals=function(e){return Cartographic.equals(this,e)},Cartographic.prototype.equalsEpsilon=function(e,t){return Cartographic.equalsEpsilon(this,e,t)},Cartographic.prototype.toString=function(){return`(${this.longitude}, ${this.latitude}, ${this.height})`},Object.defineProperties(Ellipsoid.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),Ellipsoid.clone=function(e,t){if(!defined(e))return;const n=e._radii;return defined(t)?(Cartesian3.clone(n,t._radii),Cartesian3.clone(e._radiiSquared,t._radiiSquared),Cartesian3.clone(e._radiiToTheFourth,t._radiiToTheFourth),Cartesian3.clone(e._oneOverRadii,t._oneOverRadii),Cartesian3.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new Ellipsoid(n.x,n.y,n.z)},Ellipsoid.fromCartesian3=function(e,t){return defined(t)||(t=new Ellipsoid),defined(e)?(initialize$e(t,e.x,e.y,e.z),t):t},Ellipsoid.WGS84=Object.freeze(new Ellipsoid(6378137,6378137,6356752.314245179)),Ellipsoid.UNIT_SPHERE=Object.freeze(new Ellipsoid(1,1,1)),Ellipsoid.MOON=Object.freeze(new Ellipsoid(CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS)),Ellipsoid.prototype.clone=function(e){return Ellipsoid.clone(this,e)},Ellipsoid.packedLength=Cartesian3.packedLength,Ellipsoid.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._radii,t,n),t},Ellipsoid.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t);return Ellipsoid.fromCartesian3(i,n)},Ellipsoid.prototype.geocentricSurfaceNormal=Cartesian3.normalize,Ellipsoid.prototype.geodeticSurfaceNormalCartographic=function(e,t){const n=e.longitude,i=e.latitude,r=Math.cos(i),o=r*Math.cos(n),a=r*Math.sin(n),s=Math.sin(i);return defined(t)||(t=new Cartesian3),t.x=o,t.y=a,t.z=s,Cartesian3.normalize(t,t)},Ellipsoid.prototype.geodeticSurfaceNormal=function(e,t){if(!Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14))return defined(t)||(t=new Cartesian3),t=Cartesian3.multiplyComponents(e,this._oneOverRadiiSquared,t),Cartesian3.normalize(t,t)};const cartographicToCartesianNormal=new Cartesian3,cartographicToCartesianK=new Cartesian3;Ellipsoid.prototype.cartographicToCartesian=function(e,t){const n=cartographicToCartesianNormal,i=cartographicToCartesianK;this.geodeticSurfaceNormalCartographic(e,n),Cartesian3.multiplyComponents(this._radiiSquared,n,i);const r=Math.sqrt(Cartesian3.dot(n,i));return Cartesian3.divideByScalar(i,r,i),Cartesian3.multiplyByScalar(n,e.height,n),defined(t)||(t=new Cartesian3),Cartesian3.add(i,n,t)},Ellipsoid.prototype.cartographicArrayToCartesianArray=function(e,t){const n=e.length;defined(t)?t.length=n:t=new Array(n);for(let i=0;i<n;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};const cartesianToCartographicN=new Cartesian3,cartesianToCartographicP=new Cartesian3,cartesianToCartographicH=new Cartesian3;Ellipsoid.prototype.cartesianToCartographic=function(e,t){const n=this.scaleToGeodeticSurface(e,cartesianToCartographicP);if(!defined(n))return;const i=this.geodeticSurfaceNormal(n,cartesianToCartographicN),r=Cartesian3.subtract(e,n,cartesianToCartographicH),o=Math.atan2(i.y,i.x),a=Math.asin(i.z),s=CesiumMath.sign(Cartesian3.dot(r,e))*Cartesian3.magnitude(r);return defined(t)?(t.longitude=o,t.latitude=a,t.height=s,t):new Cartographic(o,a,s)},Ellipsoid.prototype.cartesianArrayToCartographicArray=function(e,t){const n=e.length;defined(t)?t.length=n:t=new Array(n);for(let i=0;i<n;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},Ellipsoid.prototype.scaleToGeodeticSurface=function(e,t){return scaleToGeodeticSurface(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},Ellipsoid.prototype.scaleToGeocentricSurface=function(e,t){defined(t)||(t=new Cartesian3);const n=e.x,i=e.y,r=e.z,o=this._oneOverRadiiSquared,a=1/Math.sqrt(n*n*o.x+i*i*o.y+r*r*o.z);return Cartesian3.multiplyByScalar(e,a,t)},Ellipsoid.prototype.transformPositionToScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._oneOverRadii,t)},Ellipsoid.prototype.transformPositionFromScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._radii,t)},Ellipsoid.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this._radii,e._radii)},Ellipsoid.prototype.toString=function(){return this._radii.toString()},Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,n){t=defaultValue(t,0);const i=this._squaredXOverSquaredZ;if(defined(n)||(n=new Cartesian3),n.x=0,n.y=0,n.z=e.z*(1-i),!(Math.abs(n.z)>=this._radii.z-t))return n};const abscissas=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],weights=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function gaussLegendreQuadrature(e,t,n){const i=.5*(t+e),r=.5*(t-e);let o=0;for(let e=0;e<5;e++){const t=r*abscissas[e];o+=weights[e]*(n(i+t)+n(i-t))}return o*=r,o}function GeographicProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Ellipsoid.prototype.surfaceArea=function(e){const t=e.west;let n=e.east;const i=e.south,r=e.north;for(;n<t;)n+=CesiumMath.TWO_PI;const o=this._radiiSquared,a=o.x,s=o.y,c=o.z,l=a*s;return gaussLegendreQuadrature(i,r,(function(e){const i=Math.cos(e),r=Math.sin(e);return Math.cos(e)*gaussLegendreQuadrature(t,n,(function(e){const t=Math.cos(e),n=Math.sin(e);return Math.sqrt(l*r*r+c*(s*t*t+a*n*n)*i*i)}))}))},Object.defineProperties(GeographicProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),GeographicProjection.prototype.project=function(e,t){const n=this._semimajorAxis,i=e.longitude*n,r=e.latitude*n,o=e.height;return defined(t)?(t.x=i,t.y=r,t.z=o,t):new Cartesian3(i,r,o)},GeographicProjection.prototype.unproject=function(e,t){const n=this._oneOverSemimajorAxis,i=e.x*n,r=e.y*n,o=e.z;return defined(t)?(t.longitude=i,t.latitude=r,t.height=o,t):new Cartographic(i,r,o)};const Intersect={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};var Intersect$1=Object.freeze(Intersect);function Interval(e,t){this.start=defaultValue(e,0),this.stop=defaultValue(t,0)}function Matrix3(e,t,n,i,r,o,a,s,c){this[0]=defaultValue(e,0),this[1]=defaultValue(i,0),this[2]=defaultValue(a,0),this[3]=defaultValue(t,0),this[4]=defaultValue(r,0),this[5]=defaultValue(s,0),this[6]=defaultValue(n,0),this[7]=defaultValue(o,0),this[8]=defaultValue(c,0)}Matrix3.packedLength=9,Matrix3.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},Matrix3.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Matrix3),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n},Matrix3.packArray=function(e,t){const n=e.length,i=9*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Matrix3.pack(e[i],t,9*i);return t},Matrix3.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/9:t=new Array(n/9);for(let i=0;i<n;i+=9){const n=i/9;t[n]=Matrix3.unpack(e,i,t[n])}return t},Matrix3.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new Matrix3(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},Matrix3.fromArray=Matrix3.unpack,Matrix3.fromColumnMajorArray=function(e,t){return Matrix3.clone(e,t)},Matrix3.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new Matrix3(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},Matrix3.fromQuaternion=function(e,t){const n=e.x*e.x,i=e.x*e.y,r=e.x*e.z,o=e.x*e.w,a=e.y*e.y,s=e.y*e.z,c=e.y*e.w,l=e.z*e.z,u=e.z*e.w,d=e.w*e.w,h=n-a-l+d,p=2*(i-u),f=2*(r+c),m=2*(i+u),g=-n+a-l+d,_=2*(s-o),y=2*(r-c),C=2*(s+o),T=-n-a+l+d;return defined(t)?(t[0]=h,t[1]=m,t[2]=y,t[3]=p,t[4]=g,t[5]=C,t[6]=f,t[7]=_,t[8]=T,t):new Matrix3(h,p,f,m,g,_,y,C,T)},Matrix3.fromHeadingPitchRoll=function(e,t){const n=Math.cos(-e.pitch),i=Math.cos(-e.heading),r=Math.cos(e.roll),o=Math.sin(-e.pitch),a=Math.sin(-e.heading),s=Math.sin(e.roll),c=n*i,l=-r*a+s*o*i,u=s*a+r*o*i,d=n*a,h=r*i+s*o*a,p=-s*i+r*o*a,f=-o,m=s*n,g=r*n;return defined(t)?(t[0]=c,t[1]=d,t[2]=f,t[3]=l,t[4]=h,t[5]=m,t[6]=u,t[7]=p,t[8]=g,t):new Matrix3(c,l,u,d,h,p,f,m,g)},Matrix3.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new Matrix3(e.x,0,0,0,e.y,0,0,0,e.z)},Matrix3.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new Matrix3(e,0,0,0,e,0,0,0,e)},Matrix3.fromCrossProduct=function(e,t){return defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new Matrix3(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},Matrix3.fromRotationX=function(e,t){const n=Math.cos(e),i=Math.sin(e);return defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new Matrix3(1,0,0,0,n,-i,0,i,n)},Matrix3.fromRotationY=function(e,t){const n=Math.cos(e),i=Math.sin(e);return defined(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new Matrix3(n,0,i,0,1,0,-i,0,n)},Matrix3.fromRotationZ=function(e,t){const n=Math.cos(e),i=Math.sin(e);return defined(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(n,-i,0,i,n,0,0,0,1)},Matrix3.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},Matrix3.getElementIndex=function(e,t){return 3*e+t},Matrix3.getColumn=function(e,t,n){const i=3*t,r=e[i],o=e[i+1],a=e[i+2];return n.x=r,n.y=o,n.z=a,n},Matrix3.setColumn=function(e,t,n,i){const r=3*t;return(i=Matrix3.clone(e,i))[r]=n.x,i[r+1]=n.y,i[r+2]=n.z,i},Matrix3.getRow=function(e,t,n){const i=e[t],r=e[t+3],o=e[t+6];return n.x=i,n.y=r,n.z=o,n},Matrix3.setRow=function(e,t,n,i){return(i=Matrix3.clone(e,i))[t]=n.x,i[t+3]=n.y,i[t+6]=n.z,i};const scaleScratch1$2=new Cartesian3;Matrix3.setScale=function(e,t,n){const i=Matrix3.getScale(e,scaleScratch1$2),r=t.x/i.x,o=t.y/i.y,a=t.z/i.z;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*o,n[4]=e[4]*o,n[5]=e[5]*o,n[6]=e[6]*a,n[7]=e[7]*a,n[8]=e[8]*a,n};const scaleScratch2$2=new Cartesian3;Matrix3.setUniformScale=function(e,t,n){const i=Matrix3.getScale(e,scaleScratch2$2),r=t/i.x,o=t/i.y,a=t/i.z;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*o,n[4]=e[4]*o,n[5]=e[5]*o,n[6]=e[6]*a,n[7]=e[7]*a,n[8]=e[8]*a,n};const scratchColumn$2=new Cartesian3;Matrix3.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$2)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[3],e[4],e[5],scratchColumn$2)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[6],e[7],e[8],scratchColumn$2)),t};const scaleScratch3$2=new Cartesian3;Matrix3.getMaximumScale=function(e){return Matrix3.getScale(e,scaleScratch3$2),Cartesian3.maximumComponent(scaleScratch3$2)};const scaleScratch4$2=new Cartesian3;Matrix3.setRotation=function(e,t,n){const i=Matrix3.getScale(e,scaleScratch4$2);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.x,n[3]=t[3]*i.y,n[4]=t[4]*i.y,n[5]=t[5]*i.y,n[6]=t[6]*i.z,n[7]=t[7]*i.z,n[8]=t[8]*i.z,n};const scaleScratch5$2=new Cartesian3;function computeFrobeniusNorm(e){let t=0;for(let n=0;n<9;++n){const i=e[n];t+=i*i}return Math.sqrt(t)}Matrix3.getRotation=function(e,t){const n=Matrix3.getScale(e,scaleScratch5$2);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.x,t[3]=e[3]/n.y,t[4]=e[4]/n.y,t[5]=e[5]/n.y,t[6]=e[6]/n.z,t[7]=e[7]/n.z,t[8]=e[8]/n.z,t},Matrix3.multiply=function(e,t,n){const i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],r=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],o=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],l=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],u=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=i,n[1]=r,n[2]=o,n[3]=a,n[4]=s,n[5]=c,n[6]=l,n[7]=u,n[8]=d,n},Matrix3.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},Matrix3.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},Matrix3.multiplyByVector=function(e,t,n){const i=t.x,r=t.y,o=t.z,a=e[0]*i+e[3]*r+e[6]*o,s=e[1]*i+e[4]*r+e[7]*o,c=e[2]*i+e[5]*r+e[8]*o;return n.x=a,n.y=s,n.z=c,n},Matrix3.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},Matrix3.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},Matrix3.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},Matrix3.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},Matrix3.transpose=function(e,t){const n=e[0],i=e[3],r=e[6],o=e[1],a=e[4],s=e[7],c=e[2],l=e[5],u=e[8];return t[0]=n,t[1]=i,t[2]=r,t[3]=o,t[4]=a,t[5]=s,t[6]=c,t[7]=l,t[8]=u,t};const rowVal=[1,0,0],colVal=[2,2,1];function offDiagonalFrobeniusNorm(e){let t=0;for(let n=0;n<3;++n){const i=e[Matrix3.getElementIndex(colVal[n],rowVal[n])];t+=2*i*i}return Math.sqrt(t)}function shurDecomposition(e,t){const n=CesiumMath.EPSILON15;let i=0,r=1;for(let t=0;t<3;++t){const n=Math.abs(e[Matrix3.getElementIndex(colVal[t],rowVal[t])]);n>i&&(r=t,i=n)}let o=1,a=0;const s=rowVal[r],c=colVal[r];if(Math.abs(e[Matrix3.getElementIndex(c,s)])>n){const t=(e[Matrix3.getElementIndex(c,c)]-e[Matrix3.getElementIndex(s,s)])/2/e[Matrix3.getElementIndex(c,s)];let n;n=t<0?-1/(-t+Math.sqrt(1+t*t)):1/(t+Math.sqrt(1+t*t)),o=1/Math.sqrt(1+n*n),a=n*o}return(t=Matrix3.clone(Matrix3.IDENTITY,t))[Matrix3.getElementIndex(s,s)]=t[Matrix3.getElementIndex(c,c)]=o,t[Matrix3.getElementIndex(c,s)]=a,t[Matrix3.getElementIndex(s,c)]=-a,t}const jMatrix=new Matrix3,jMatrixTranspose=new Matrix3;Matrix3.computeEigenDecomposition=function(e,t){const n=CesiumMath.EPSILON20;let i=0,r=0;defined(t)||(t={});const o=t.unitary=Matrix3.clone(Matrix3.IDENTITY,t.unitary),a=t.diagonal=Matrix3.clone(e,t.diagonal),s=n*computeFrobeniusNorm(a);for(;r<10&&offDiagonalFrobeniusNorm(a)>s;)shurDecomposition(a,jMatrix),Matrix3.transpose(jMatrix,jMatrixTranspose),Matrix3.multiply(a,jMatrix,a),Matrix3.multiply(jMatrixTranspose,a,a),Matrix3.multiply(o,jMatrix,o),++i>2&&(++r,i=0);return t},Matrix3.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},Matrix3.determinant=function(e){const t=e[0],n=e[3],i=e[6],r=e[1],o=e[4],a=e[7],s=e[2],c=e[5],l=e[8];return t*(o*l-c*a)+r*(c*i-n*l)+s*(n*a-o*i)},Matrix3.inverse=function(e,t){const n=e[0],i=e[1],r=e[2],o=e[3],a=e[4],s=e[5],c=e[6],l=e[7],u=e[8],d=Matrix3.determinant(e);t[0]=a*u-l*s,t[1]=l*r-i*u,t[2]=i*s-a*r,t[3]=c*s-o*u,t[4]=n*u-c*r,t[5]=o*r-n*s,t[6]=o*l-c*a,t[7]=c*i-n*l,t[8]=n*a-o*i;const h=1/d;return Matrix3.multiplyByScalar(t,h,t)};const scratchTransposeMatrix$1=new Matrix3;function Cartesian4(e,t,n,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(n,0),this.w=defaultValue(i,0)}Matrix3.inverseTranspose=function(e,t){return Matrix3.inverse(Matrix3.transpose(e,scratchTransposeMatrix$1),t)},Matrix3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},Matrix3.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},Matrix3.IDENTITY=Object.freeze(new Matrix3(1,0,0,0,1,0,0,0,1)),Matrix3.ZERO=Object.freeze(new Matrix3(0,0,0,0,0,0,0,0,0)),Matrix3.COLUMN0ROW0=0,Matrix3.COLUMN0ROW1=1,Matrix3.COLUMN0ROW2=2,Matrix3.COLUMN1ROW0=3,Matrix3.COLUMN1ROW1=4,Matrix3.COLUMN1ROW2=5,Matrix3.COLUMN2ROW0=6,Matrix3.COLUMN2ROW1=7,Matrix3.COLUMN2ROW2=8,Object.defineProperties(Matrix3.prototype,{length:{get:function(){return Matrix3.packedLength}}}),Matrix3.prototype.clone=function(e){return Matrix3.clone(this,e)},Matrix3.prototype.equals=function(e){return Matrix3.equals(this,e)},Matrix3.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},Matrix3.prototype.equalsEpsilon=function(e,t){return Matrix3.equalsEpsilon(this,e,t)},Matrix3.prototype.toString=function(){return`(${this[0]}, ${this[3]}, ${this[6]})\n(${this[1]}, ${this[4]}, ${this[7]})\n(${this[2]}, ${this[5]}, ${this[8]})`},Cartesian4.fromElements=function(e,t,n,i,r){return defined(r)?(r.x=e,r.y=t,r.z=n,r.w=i,r):new Cartesian4(e,t,n,i)},Cartesian4.fromColor=function(e,t){return defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new Cartesian4(e.red,e.green,e.blue,e.alpha)},Cartesian4.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Cartesian4(e.x,e.y,e.z,e.w)},Cartesian4.packedLength=4,Cartesian4.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},Cartesian4.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Cartesian4),n.x=e[t++],n.y=e[t++],n.z=e[t++],n.w=e[t],n},Cartesian4.packArray=function(e,t){const n=e.length,i=4*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Cartesian4.pack(e[i],t,4*i);return t},Cartesian4.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/4:t=new Array(n/4);for(let i=0;i<n;i+=4){const n=i/4;t[n]=Cartesian4.unpack(e,i,t[n])}return t},Cartesian4.fromArray=Cartesian4.unpack,Cartesian4.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},Cartesian4.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},Cartesian4.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},Cartesian4.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},Cartesian4.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Cartesian4.magnitude=function(e){return Math.sqrt(Cartesian4.magnitudeSquared(e))};const distanceScratch$2=new Cartesian4;Cartesian4.distance=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitude(distanceScratch$2)},Cartesian4.distanceSquared=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitudeSquared(distanceScratch$2)},Cartesian4.normalize=function(e,t){const n=Cartesian4.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},Cartesian4.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Cartesian4.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},Cartesian4.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n.w=e.w/t.w,n},Cartesian4.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},Cartesian4.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},Cartesian4.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},Cartesian4.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},Cartesian4.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Cartesian4.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};const lerpScratch$2=new Cartesian4;Cartesian4.lerp=function(e,t,n,i){return Cartesian4.multiplyByScalar(t,n,lerpScratch$2),i=Cartesian4.multiplyByScalar(e,1-n,i),Cartesian4.add(lerpScratch$2,i,i)};const mostOrthogonalAxisScratch$1=new Cartesian4;Cartesian4.mostOrthogonalAxis=function(e,t){const n=Cartesian4.normalize(e,mostOrthogonalAxisScratch$1);return Cartesian4.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?Cartesian4.clone(Cartesian4.UNIT_X,t):Cartesian4.clone(Cartesian4.UNIT_W,t):n.z<=n.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t):n.y<=n.z?n.y<=n.w?Cartesian4.clone(Cartesian4.UNIT_Y,t):Cartesian4.clone(Cartesian4.UNIT_W,t):n.z<=n.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t)},Cartesian4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Cartesian4.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},Cartesian4.equalsEpsilon=function(e,t,n,i){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,n,i)&&CesiumMath.equalsEpsilon(e.y,t.y,n,i)&&CesiumMath.equalsEpsilon(e.z,t.z,n,i)&&CesiumMath.equalsEpsilon(e.w,t.w,n,i)},Cartesian4.ZERO=Object.freeze(new Cartesian4(0,0,0,0)),Cartesian4.ONE=Object.freeze(new Cartesian4(1,1,1,1)),Cartesian4.UNIT_X=Object.freeze(new Cartesian4(1,0,0,0)),Cartesian4.UNIT_Y=Object.freeze(new Cartesian4(0,1,0,0)),Cartesian4.UNIT_Z=Object.freeze(new Cartesian4(0,0,1,0)),Cartesian4.UNIT_W=Object.freeze(new Cartesian4(0,0,0,1)),Cartesian4.prototype.clone=function(e){return Cartesian4.clone(this,e)},Cartesian4.prototype.equals=function(e){return Cartesian4.equals(this,e)},Cartesian4.prototype.equalsEpsilon=function(e,t,n){return Cartesian4.equalsEpsilon(this,e,t,n)},Cartesian4.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z}, ${this.w})`};const scratchF32Array=new Float32Array(1),scratchU8Array=new Uint8Array(scratchF32Array.buffer),testU32=new Uint32Array([287454020]),testU8=new Uint8Array(testU32.buffer),littleEndian=68===testU8[0];function RuntimeError(e){let t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}function Matrix4(e,t,n,i,r,o,a,s,c,l,u,d,h,p,f,m){this[0]=defaultValue(e,0),this[1]=defaultValue(r,0),this[2]=defaultValue(c,0),this[3]=defaultValue(h,0),this[4]=defaultValue(t,0),this[5]=defaultValue(o,0),this[6]=defaultValue(l,0),this[7]=defaultValue(p,0),this[8]=defaultValue(n,0),this[9]=defaultValue(a,0),this[10]=defaultValue(u,0),this[11]=defaultValue(f,0),this[12]=defaultValue(i,0),this[13]=defaultValue(s,0),this[14]=defaultValue(d,0),this[15]=defaultValue(m,0)}Cartesian4.packFloat=function(e,t){return defined(t)||(t=new Cartesian4),scratchF32Array[0]=e,littleEndian?(t.x=scratchU8Array[0],t.y=scratchU8Array[1],t.z=scratchU8Array[2],t.w=scratchU8Array[3]):(t.x=scratchU8Array[3],t.y=scratchU8Array[2],t.z=scratchU8Array[1],t.w=scratchU8Array[0]),t},Cartesian4.unpackFloat=function(e){return littleEndian?(scratchU8Array[0]=e.x,scratchU8Array[1]=e.y,scratchU8Array[2]=e.z,scratchU8Array[3]=e.w):(scratchU8Array[0]=e.w,scratchU8Array[1]=e.z,scratchU8Array[2]=e.y,scratchU8Array[3]=e.x),scratchF32Array[0]},defined(Object.create)&&(RuntimeError.prototype=Object.create(Error.prototype),RuntimeError.prototype.constructor=RuntimeError),RuntimeError.prototype.toString=function(){let e=`${this.name}: ${this.message}`;return defined(this.stack)&&(e+=`\n${this.stack.toString()}`),e},Matrix4.packedLength=16,Matrix4.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15],t},Matrix4.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Matrix4),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n},Matrix4.packArray=function(e,t){const n=e.length,i=16*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Matrix4.pack(e[i],t,16*i);return t},Matrix4.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/16:t=new Array(n/16);for(let i=0;i<n;i+=16){const n=i/16;t[n]=Matrix4.unpack(e,i,t[n])}return t},Matrix4.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Matrix4(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Matrix4.fromArray=Matrix4.unpack,Matrix4.fromColumnMajorArray=function(e,t){return Matrix4.clone(e,t)},Matrix4.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Matrix4(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Matrix4.fromRotationTranslation=function(e,t,n){return t=defaultValue(t,Cartesian3.ZERO),defined(n)?(n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=0,n[4]=e[3],n[5]=e[4],n[6]=e[5],n[7]=0,n[8]=e[6],n[9]=e[7],n[10]=e[8],n[11]=0,n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=1,n):new Matrix4(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Matrix4.fromTranslationQuaternionRotationScale=function(e,t,n,i){defined(i)||(i=new Matrix4);const r=n.x,o=n.y,a=n.z,s=t.x*t.x,c=t.x*t.y,l=t.x*t.z,u=t.x*t.w,d=t.y*t.y,h=t.y*t.z,p=t.y*t.w,f=t.z*t.z,m=t.z*t.w,g=t.w*t.w,_=s-d-f+g,y=2*(c-m),C=2*(l+p),T=2*(c+m),S=-s+d-f+g,A=2*(h-u),v=2*(l-p),E=2*(h+u),b=-s-d+f+g;return i[0]=_*r,i[1]=T*r,i[2]=v*r,i[3]=0,i[4]=y*o,i[5]=S*o,i[6]=E*o,i[7]=0,i[8]=C*a,i[9]=A*a,i[10]=b*a,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},Matrix4.fromTranslationRotationScale=function(e,t){return Matrix4.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Matrix4.fromTranslation=function(e,t){return Matrix4.fromRotationTranslation(Matrix3.IDENTITY,e,t)},Matrix4.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Matrix4.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)},Matrix4.fromRotation=function(e,t){return defined(t)||(t=new Matrix4),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t};const fromCameraF=new Cartesian3,fromCameraR=new Cartesian3,fromCameraU=new Cartesian3;Matrix4.fromCamera=function(e,t){const n=e.position,i=e.direction,r=e.up;Cartesian3.normalize(i,fromCameraF),Cartesian3.normalize(Cartesian3.cross(fromCameraF,r,fromCameraR),fromCameraR),Cartesian3.normalize(Cartesian3.cross(fromCameraR,fromCameraF,fromCameraU),fromCameraU);const o=fromCameraR.x,a=fromCameraR.y,s=fromCameraR.z,c=fromCameraF.x,l=fromCameraF.y,u=fromCameraF.z,d=fromCameraU.x,h=fromCameraU.y,p=fromCameraU.z,f=n.x,m=n.y,g=n.z,_=o*-f+a*-m+s*-g,y=d*-f+h*-m+p*-g,C=c*f+l*m+u*g;return defined(t)?(t[0]=o,t[1]=d,t[2]=-c,t[3]=0,t[4]=a,t[5]=h,t[6]=-l,t[7]=0,t[8]=s,t[9]=p,t[10]=-u,t[11]=0,t[12]=_,t[13]=y,t[14]=C,t[15]=1,t):new Matrix4(o,a,s,_,d,h,p,y,-c,-l,-u,C,0,0,0,1)},Matrix4.computePerspectiveFieldOfView=function(e,t,n,i,r){const o=1/Math.tan(.5*e),a=o/t,s=(i+n)/(n-i),c=2*i*n/(n-i);return r[0]=a,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=o,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=s,r[11]=-1,r[12]=0,r[13]=0,r[14]=c,r[15]=0,r},Matrix4.computeOrthographicOffCenter=function(e,t,n,i,r,o,a){let s=1/(t-e),c=1/(i-n),l=1/(o-r);const u=-(t+e)*s,d=-(i+n)*c,h=-(o+r)*l;return s*=2,c*=2,l*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=c,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=0,a[12]=u,a[13]=d,a[14]=h,a[15]=1,a},Matrix4.computePerspectiveOffCenter=function(e,t,n,i,r,o,a){const s=2*r/(t-e),c=2*r/(i-n),l=(t+e)/(t-e),u=(i+n)/(i-n),d=-(o+r)/(o-r),h=-2*o*r/(o-r);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=c,a[6]=0,a[7]=0,a[8]=l,a[9]=u,a[10]=d,a[11]=-1,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},Matrix4.computeInfinitePerspectiveOffCenter=function(e,t,n,i,r,o){const a=2*r/(t-e),s=2*r/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),u=-2*r;return o[0]=a,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=-1,o[11]=-1,o[12]=0,o[13]=0,o[14]=u,o[15]=0,o},Matrix4.computeViewportTransformation=function(e,t,n,i){defined(i)||(i=new Matrix4),e=defaultValue(e,defaultValue.EMPTY_OBJECT);const r=defaultValue(e.x,0),o=defaultValue(e.y,0),a=defaultValue(e.width,0),s=defaultValue(e.height,0);t=defaultValue(t,0);const c=.5*a,l=.5*s,u=.5*((n=defaultValue(n,1))-t),d=c,h=l,p=u,f=r+c,m=o+l,g=t+u;return i[0]=d,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=h,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=p,i[11]=0,i[12]=f,i[13]=m,i[14]=g,i[15]=1,i},Matrix4.computeView=function(e,t,n,i,r){return r[0]=i.x,r[1]=n.x,r[2]=-t.x,r[3]=0,r[4]=i.y,r[5]=n.y,r[6]=-t.y,r[7]=0,r[8]=i.z,r[9]=n.z,r[10]=-t.z,r[11]=0,r[12]=-Cartesian3.dot(i,e),r[13]=-Cartesian3.dot(n,e),r[14]=Cartesian3.dot(t,e),r[15]=1,r},Matrix4.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Matrix4.getElementIndex=function(e,t){return 4*e+t},Matrix4.getColumn=function(e,t,n){const i=4*t,r=e[i],o=e[i+1],a=e[i+2],s=e[i+3];return n.x=r,n.y=o,n.z=a,n.w=s,n},Matrix4.setColumn=function(e,t,n,i){const r=4*t;return(i=Matrix4.clone(e,i))[r]=n.x,i[r+1]=n.y,i[r+2]=n.z,i[r+3]=n.w,i},Matrix4.getRow=function(e,t,n){const i=e[t],r=e[t+4],o=e[t+8],a=e[t+12];return n.x=i,n.y=r,n.z=o,n.w=a,n},Matrix4.setRow=function(e,t,n,i){return(i=Matrix4.clone(e,i))[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i},Matrix4.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};const scaleScratch1$1=new Cartesian3;Matrix4.setScale=function(e,t,n){const i=Matrix4.getScale(e,scaleScratch1$1),r=t.x/i.x,o=t.y/i.y,a=t.z/i.y;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3],n[4]=e[4]*o,n[5]=e[5]*o,n[6]=e[6]*o,n[7]=e[7],n[8]=e[8]*a,n[9]=e[9]*a,n[10]=e[10]*a,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};const scaleScratch2$1=new Cartesian3;Matrix4.setUniformScale=function(e,t,n){const i=Matrix4.getScale(e,scaleScratch2$1),r=t/i.x,o=t/i.y,a=t/i.z;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3],n[4]=e[4]*o,n[5]=e[5]*o,n[6]=e[6]*o,n[7]=e[7],n[8]=e[8]*a,n[9]=e[9]*a,n[10]=e[10]*a,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};const scratchColumn$1=new Cartesian3;Matrix4.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$1)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[4],e[5],e[6],scratchColumn$1)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[8],e[9],e[10],scratchColumn$1)),t};const scaleScratch3$1=new Cartesian3;Matrix4.getMaximumScale=function(e){return Matrix4.getScale(e,scaleScratch3$1),Cartesian3.maximumComponent(scaleScratch3$1)};const scaleScratch4$1=new Cartesian3;Matrix4.setRotation=function(e,t,n){const i=Matrix4.getScale(e,scaleScratch4$1);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.x,n[3]=e[3],n[4]=t[3]*i.y,n[5]=t[4]*i.y,n[6]=t[5]*i.y,n[7]=e[7],n[8]=t[6]*i.z,n[9]=t[7]*i.z,n[10]=t[8]*i.z,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};const scaleScratch5$1=new Cartesian3;Matrix4.getRotation=function(e,t){const n=Matrix4.getScale(e,scaleScratch5$1);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.x,t[3]=e[4]/n.y,t[4]=e[5]/n.y,t[5]=e[6]/n.y,t[6]=e[8]/n.z,t[7]=e[9]/n.z,t[8]=e[10]/n.z,t},Matrix4.multiply=function(e,t,n){const i=e[0],r=e[1],o=e[2],a=e[3],s=e[4],c=e[5],l=e[6],u=e[7],d=e[8],h=e[9],p=e[10],f=e[11],m=e[12],g=e[13],_=e[14],y=e[15],C=t[0],T=t[1],S=t[2],A=t[3],v=t[4],E=t[5],b=t[6],x=t[7],P=t[8],D=t[9],w=t[10],M=t[11],I=t[12],R=t[13],O=t[14],B=t[15],L=i*C+s*T+d*S+m*A,F=r*C+c*T+h*S+g*A,N=o*C+l*T+p*S+_*A,V=a*C+u*T+f*S+y*A,$=i*v+s*E+d*b+m*x,k=r*v+c*E+h*b+g*x,U=o*v+l*E+p*b+_*x,G=a*v+u*E+f*b+y*x,z=i*P+s*D+d*w+m*M,H=r*P+c*D+h*w+g*M,W=o*P+l*D+p*w+_*M,q=a*P+u*D+f*w+y*M,j=i*I+s*R+d*O+m*B,X=r*I+c*R+h*O+g*B,Y=o*I+l*R+p*O+_*B,K=a*I+u*R+f*O+y*B;return n[0]=L,n[1]=F,n[2]=N,n[3]=V,n[4]=$,n[5]=k,n[6]=U,n[7]=G,n[8]=z,n[9]=H,n[10]=W,n[11]=q,n[12]=j,n[13]=X,n[14]=Y,n[15]=K,n},Matrix4.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},Matrix4.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},Matrix4.multiplyTransformation=function(e,t,n){const i=e[0],r=e[1],o=e[2],a=e[4],s=e[5],c=e[6],l=e[8],u=e[9],d=e[10],h=e[12],p=e[13],f=e[14],m=t[0],g=t[1],_=t[2],y=t[4],C=t[5],T=t[6],S=t[8],A=t[9],v=t[10],E=t[12],b=t[13],x=t[14],P=i*m+a*g+l*_,D=r*m+s*g+u*_,w=o*m+c*g+d*_,M=i*y+a*C+l*T,I=r*y+s*C+u*T,R=o*y+c*C+d*T,O=i*S+a*A+l*v,B=r*S+s*A+u*v,L=o*S+c*A+d*v,F=i*E+a*b+l*x+h,N=r*E+s*b+u*x+p,V=o*E+c*b+d*x+f;return n[0]=P,n[1]=D,n[2]=w,n[3]=0,n[4]=M,n[5]=I,n[6]=R,n[7]=0,n[8]=O,n[9]=B,n[10]=L,n[11]=0,n[12]=F,n[13]=N,n[14]=V,n[15]=1,n},Matrix4.multiplyByMatrix3=function(e,t,n){const i=e[0],r=e[1],o=e[2],a=e[4],s=e[5],c=e[6],l=e[8],u=e[9],d=e[10],h=t[0],p=t[1],f=t[2],m=t[3],g=t[4],_=t[5],y=t[6],C=t[7],T=t[8],S=i*h+a*p+l*f,A=r*h+s*p+u*f,v=o*h+c*p+d*f,E=i*m+a*g+l*_,b=r*m+s*g+u*_,x=o*m+c*g+d*_,P=i*y+a*C+l*T,D=r*y+s*C+u*T,w=o*y+c*C+d*T;return n[0]=S,n[1]=A,n[2]=v,n[3]=0,n[4]=E,n[5]=b,n[6]=x,n[7]=0,n[8]=P,n[9]=D,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},Matrix4.multiplyByTranslation=function(e,t,n){const i=t.x,r=t.y,o=t.z,a=i*e[0]+r*e[4]+o*e[8]+e[12],s=i*e[1]+r*e[5]+o*e[9]+e[13],c=i*e[2]+r*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=a,n[13]=s,n[14]=c,n[15]=e[15],n},Matrix4.multiplyByScale=function(e,t,n){const i=t.x,r=t.y,o=t.z;return 1===i&&1===r&&1===o?Matrix4.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=e[3],n[4]=r*e[4],n[5]=r*e[5],n[6]=r*e[6],n[7]=e[7],n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n)},Matrix4.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3],n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7],n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},Matrix4.multiplyByVector=function(e,t,n){const i=t.x,r=t.y,o=t.z,a=t.w,s=e[0]*i+e[4]*r+e[8]*o+e[12]*a,c=e[1]*i+e[5]*r+e[9]*o+e[13]*a,l=e[2]*i+e[6]*r+e[10]*o+e[14]*a,u=e[3]*i+e[7]*r+e[11]*o+e[15]*a;return n.x=s,n.y=c,n.z=l,n.w=u,n},Matrix4.multiplyByPointAsVector=function(e,t,n){const i=t.x,r=t.y,o=t.z,a=e[0]*i+e[4]*r+e[8]*o,s=e[1]*i+e[5]*r+e[9]*o,c=e[2]*i+e[6]*r+e[10]*o;return n.x=a,n.y=s,n.z=c,n},Matrix4.multiplyByPoint=function(e,t,n){const i=t.x,r=t.y,o=t.z,a=e[0]*i+e[4]*r+e[8]*o+e[12],s=e[1]*i+e[5]*r+e[9]*o+e[13],c=e[2]*i+e[6]*r+e[10]*o+e[14];return n.x=a,n.y=s,n.z=c,n},Matrix4.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},Matrix4.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Matrix4.transpose=function(e,t){const n=e[1],i=e[2],r=e[3],o=e[6],a=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=r,t[13]=a,t[14]=s,t[15]=e[15],t},Matrix4.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Matrix4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Matrix4.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},Matrix4.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Matrix4.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};const scratchInverseRotation=new Matrix3,scratchMatrix3Zero=new Matrix3,scratchBottomRow=new Cartesian4,scratchExpectedBottomRow=new Cartesian4(0,0,0,1);Matrix4.inverse=function(e,t){const n=e[0],i=e[4],r=e[8],o=e[12],a=e[1],s=e[5],c=e[9],l=e[13],u=e[2],d=e[6],h=e[10],p=e[14],f=e[3],m=e[7],g=e[11],_=e[15];let y=h*_,C=p*g,T=d*_,S=p*m,A=d*g,v=h*m,E=u*_,b=p*f,x=u*g,P=h*f,D=u*m,w=d*f;const M=y*s+S*c+A*l-(C*s+T*c+v*l),I=C*a+E*c+P*l-(y*a+b*c+x*l),R=T*a+b*s+D*l-(S*a+E*s+w*l),O=v*a+x*s+w*c-(A*a+P*s+D*c),B=C*i+T*r+v*o-(y*i+S*r+A*o),L=y*n+b*r+x*o-(C*n+E*r+P*o),F=S*n+E*i+w*o-(T*n+b*i+D*o),N=A*n+P*i+D*r-(v*n+x*i+w*r);y=r*l,C=o*c,T=i*l,S=o*s,A=i*c,v=r*s,E=n*l,b=o*a,x=n*c,P=r*a,D=n*s,w=i*a;const V=y*m+S*g+A*_-(C*m+T*g+v*_),$=C*f+E*g+P*_-(y*f+b*g+x*_),k=T*f+b*m+D*_-(S*f+E*m+w*_),U=v*f+x*m+w*g-(A*f+P*m+D*g),G=T*h+v*p+C*d-(A*p+y*d+S*h),z=x*p+y*u+b*h-(E*h+P*p+C*u),H=E*d+w*p+S*u-(D*p+T*u+b*d),W=D*h+A*u+P*d-(x*d+w*h+v*u);let q=n*M+i*I+r*R+o*O;if(Math.abs(q)<CesiumMath.EPSILON21){if(Matrix3.equalsEpsilon(Matrix4.getMatrix3(e,scratchInverseRotation),scratchMatrix3Zero,CesiumMath.EPSILON7)&&Cartesian4.equals(Matrix4.getRow(e,3,scratchBottomRow),scratchExpectedBottomRow))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new RuntimeError("matrix is not invertible because its determinate is zero.")}return q=1/q,t[0]=M*q,t[1]=I*q,t[2]=R*q,t[3]=O*q,t[4]=B*q,t[5]=L*q,t[6]=F*q,t[7]=N*q,t[8]=V*q,t[9]=$*q,t[10]=k*q,t[11]=U*q,t[12]=G*q,t[13]=z*q,t[14]=H*q,t[15]=W*q,t},Matrix4.inverseTransformation=function(e,t){const n=e[0],i=e[1],r=e[2],o=e[4],a=e[5],s=e[6],c=e[8],l=e[9],u=e[10],d=e[12],h=e[13],p=e[14],f=-n*d-i*h-r*p,m=-o*d-a*h-s*p,g=-c*d-l*h-u*p;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=a,t[6]=l,t[7]=0,t[8]=r,t[9]=s,t[10]=u,t[11]=0,t[12]=f,t[13]=m,t[14]=g,t[15]=1,t};const scratchTransposeMatrix=new Matrix4;function Rectangle(e,t,n,i){this.west=defaultValue(e,0),this.south=defaultValue(t,0),this.east=defaultValue(n,0),this.north=defaultValue(i,0)}Matrix4.inverseTranspose=function(e,t){return Matrix4.inverse(Matrix4.transpose(e,scratchTransposeMatrix),t)},Matrix4.IDENTITY=Object.freeze(new Matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Matrix4.ZERO=Object.freeze(new Matrix4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Matrix4.COLUMN0ROW0=0,Matrix4.COLUMN0ROW1=1,Matrix4.COLUMN0ROW2=2,Matrix4.COLUMN0ROW3=3,Matrix4.COLUMN1ROW0=4,Matrix4.COLUMN1ROW1=5,Matrix4.COLUMN1ROW2=6,Matrix4.COLUMN1ROW3=7,Matrix4.COLUMN2ROW0=8,Matrix4.COLUMN2ROW1=9,Matrix4.COLUMN2ROW2=10,Matrix4.COLUMN2ROW3=11,Matrix4.COLUMN3ROW0=12,Matrix4.COLUMN3ROW1=13,Matrix4.COLUMN3ROW2=14,Matrix4.COLUMN3ROW3=15,Object.defineProperties(Matrix4.prototype,{length:{get:function(){return Matrix4.packedLength}}}),Matrix4.prototype.clone=function(e){return Matrix4.clone(this,e)},Matrix4.prototype.equals=function(e){return Matrix4.equals(this,e)},Matrix4.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},Matrix4.prototype.equalsEpsilon=function(e,t){return Matrix4.equalsEpsilon(this,e,t)},Matrix4.prototype.toString=function(){return`(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})\n(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})\n(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})\n(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`},Object.defineProperties(Rectangle.prototype,{width:{get:function(){return Rectangle.computeWidth(this)}},height:{get:function(){return Rectangle.computeHeight(this)}}}),Rectangle.packedLength=4,Rectangle.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},Rectangle.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Rectangle),n.west=e[t++],n.south=e[t++],n.east=e[t++],n.north=e[t],n},Rectangle.computeWidth=function(e){let t=e.east;const n=e.west;return t<n&&(t+=CesiumMath.TWO_PI),t-n},Rectangle.computeHeight=function(e){return e.north-e.south},Rectangle.fromDegrees=function(e,t,n,i,r){return e=CesiumMath.toRadians(defaultValue(e,0)),t=CesiumMath.toRadians(defaultValue(t,0)),n=CesiumMath.toRadians(defaultValue(n,0)),i=CesiumMath.toRadians(defaultValue(i,0)),defined(r)?(r.west=e,r.south=t,r.east=n,r.north=i,r):new Rectangle(e,t,n,i)},Rectangle.fromRadians=function(e,t,n,i,r){return defined(r)?(r.west=defaultValue(e,0),r.south=defaultValue(t,0),r.east=defaultValue(n,0),r.north=defaultValue(i,0),r):new Rectangle(e,t,n,i)},Rectangle.fromCartographicArray=function(e,t){let n=Number.MAX_VALUE,i=-Number.MAX_VALUE,r=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE;for(let t=0,c=e.length;t<c;t++){const c=e[t];n=Math.min(n,c.longitude),i=Math.max(i,c.longitude),a=Math.min(a,c.latitude),s=Math.max(s,c.latitude);const l=c.longitude>=0?c.longitude:c.longitude+CesiumMath.TWO_PI;r=Math.min(r,l),o=Math.max(o,l)}return i-n>o-r&&(n=r,i=o,i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI),n>CesiumMath.PI&&(n-=CesiumMath.TWO_PI)),defined(t)?(t.west=n,t.south=a,t.east=i,t.north=s,t):new Rectangle(n,a,i,s)},Rectangle.fromCartesianArray=function(e,t,n){t=defaultValue(t,Ellipsoid.WGS84);let i=Number.MAX_VALUE,r=-Number.MAX_VALUE,o=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=Number.MAX_VALUE,c=-Number.MAX_VALUE;for(let n=0,l=e.length;n<l;n++){const l=t.cartesianToCartographic(e[n]);i=Math.min(i,l.longitude),r=Math.max(r,l.longitude),s=Math.min(s,l.latitude),c=Math.max(c,l.latitude);const u=l.longitude>=0?l.longitude:l.longitude+CesiumMath.TWO_PI;o=Math.min(o,u),a=Math.max(a,u)}return r-i>a-o&&(i=o,r=a,r>CesiumMath.PI&&(r-=CesiumMath.TWO_PI),i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI)),defined(n)?(n.west=i,n.south=s,n.east=r,n.north=c,n):new Rectangle(i,s,r,c)},Rectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new Rectangle(e.west,e.south,e.east,e.north)},Rectangle.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e.west-t.west)<=n&&Math.abs(e.south-t.south)<=n&&Math.abs(e.east-t.east)<=n&&Math.abs(e.north-t.north)<=n},Rectangle.prototype.clone=function(e){return Rectangle.clone(this,e)},Rectangle.prototype.equals=function(e){return Rectangle.equals(this,e)},Rectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},Rectangle.prototype.equalsEpsilon=function(e,t){return Rectangle.equalsEpsilon(this,e,t)},Rectangle.validate=function(e){},Rectangle.southwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new Cartographic(e.west,e.south)},Rectangle.northwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new Cartographic(e.west,e.north)},Rectangle.northeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new Cartographic(e.east,e.north)},Rectangle.southeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new Cartographic(e.east,e.south)},Rectangle.center=function(e,t){let n=e.east;const i=e.west;n<i&&(n+=CesiumMath.TWO_PI);const r=CesiumMath.negativePiToPi(.5*(i+n)),o=.5*(e.south+e.north);return defined(t)?(t.longitude=r,t.latitude=o,t.height=0,t):new Cartographic(r,o)},Rectangle.intersection=function(e,t,n){let i=e.east,r=e.west,o=t.east,a=t.west;i<r&&o>0?i+=CesiumMath.TWO_PI:o<a&&i>0&&(o+=CesiumMath.TWO_PI),i<r&&a<0?a+=CesiumMath.TWO_PI:o<a&&r<0&&(r+=CesiumMath.TWO_PI);const s=CesiumMath.negativePiToPi(Math.max(r,a)),c=CesiumMath.negativePiToPi(Math.min(i,o));if((e.west<e.east||t.west<t.east)&&c<=s)return;const l=Math.max(e.south,t.south),u=Math.min(e.north,t.north);return l>=u?void 0:defined(n)?(n.west=s,n.south=l,n.east=c,n.north=u,n):new Rectangle(s,l,c,u)},Rectangle.simpleIntersection=function(e,t,n){const i=Math.max(e.west,t.west),r=Math.max(e.south,t.south),o=Math.min(e.east,t.east),a=Math.min(e.north,t.north);if(!(r>=a||i>=o))return defined(n)?(n.west=i,n.south=r,n.east=o,n.north=a,n):new Rectangle(i,r,o,a)},Rectangle.union=function(e,t,n){defined(n)||(n=new Rectangle);let i=e.east,r=e.west,o=t.east,a=t.west;i<r&&o>0?i+=CesiumMath.TWO_PI:o<a&&i>0&&(o+=CesiumMath.TWO_PI),i<r&&a<0?a+=CesiumMath.TWO_PI:o<a&&r<0&&(r+=CesiumMath.TWO_PI);const s=CesiumMath.negativePiToPi(Math.min(r,a)),c=CesiumMath.negativePiToPi(Math.max(i,o));return n.west=s,n.south=Math.min(e.south,t.south),n.east=c,n.north=Math.max(e.north,t.north),n},Rectangle.expand=function(e,t,n){return defined(n)||(n=new Rectangle),n.west=Math.min(e.west,t.longitude),n.south=Math.min(e.south,t.latitude),n.east=Math.max(e.east,t.longitude),n.north=Math.max(e.north,t.latitude),n},Rectangle.contains=function(e,t){let n=t.longitude;const i=t.latitude,r=e.west;let o=e.east;return o<r&&(o+=CesiumMath.TWO_PI,n<0&&(n+=CesiumMath.TWO_PI)),(n>r||CesiumMath.equalsEpsilon(n,r,CesiumMath.EPSILON14))&&(n<o||CesiumMath.equalsEpsilon(n,o,CesiumMath.EPSILON14))&&i>=e.south&&i<=e.north};const subsampleLlaScratch=new Cartographic;function BoundingSphere(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.radius=defaultValue(t,0)}Rectangle.subsample=function(e,t,n,i){t=defaultValue(t,Ellipsoid.WGS84),n=defaultValue(n,0),defined(i)||(i=[]);let r=0;const o=e.north,a=e.south,s=e.east,c=e.west,l=subsampleLlaScratch;l.height=n,l.longitude=c,l.latitude=o,i[r]=t.cartographicToCartesian(l,i[r]),r++,l.longitude=s,i[r]=t.cartographicToCartesian(l,i[r]),r++,l.latitude=a,i[r]=t.cartographicToCartesian(l,i[r]),r++,l.longitude=c,i[r]=t.cartographicToCartesian(l,i[r]),r++,l.latitude=o<0?o:a>0?a:0;for(let n=1;n<8;++n)l.longitude=-Math.PI+n*CesiumMath.PI_OVER_TWO,Rectangle.contains(e,l)&&(i[r]=t.cartographicToCartesian(l,i[r]),r++);return 0===l.latitude&&(l.longitude=c,i[r]=t.cartographicToCartesian(l,i[r]),r++,l.longitude=s,i[r]=t.cartographicToCartesian(l,i[r]),r++),i.length=r,i},Rectangle.subsection=function(e,t,n,i,r,o){if(defined(o)||(o=new Rectangle),e.west<=e.east){const n=e.east-e.west;o.west=e.west+t*n,o.east=e.west+i*n}else{const n=CesiumMath.TWO_PI+e.east-e.west;o.west=CesiumMath.negativePiToPi(e.west+t*n),o.east=CesiumMath.negativePiToPi(e.west+i*n)}const a=e.north-e.south;return o.south=e.south+n*a,o.north=e.south+r*a,1===t&&(o.west=e.east),1===i&&(o.east=e.east),1===n&&(o.south=e.north),1===r&&(o.north=e.north),o},Rectangle.MAX_VALUE=Object.freeze(new Rectangle(-Math.PI,-CesiumMath.PI_OVER_TWO,Math.PI,CesiumMath.PI_OVER_TWO));const fromPointsXMin=new Cartesian3,fromPointsYMin=new Cartesian3,fromPointsZMin=new Cartesian3,fromPointsXMax=new Cartesian3,fromPointsYMax=new Cartesian3,fromPointsZMax=new Cartesian3,fromPointsCurrentPos=new Cartesian3,fromPointsScratch=new Cartesian3,fromPointsRitterCenter=new Cartesian3,fromPointsMinBoxPt=new Cartesian3,fromPointsMaxBoxPt=new Cartesian3,fromPointsNaiveCenterScratch=new Cartesian3,volumeConstant=4/3*CesiumMath.PI;BoundingSphere.fromPoints=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;const n=Cartesian3.clone(e[0],fromPointsCurrentPos),i=Cartesian3.clone(n,fromPointsXMin),r=Cartesian3.clone(n,fromPointsYMin),o=Cartesian3.clone(n,fromPointsZMin),a=Cartesian3.clone(n,fromPointsXMax),s=Cartesian3.clone(n,fromPointsYMax),c=Cartesian3.clone(n,fromPointsZMax),l=e.length;let u;for(u=1;u<l;u++){Cartesian3.clone(e[u],n);const t=n.x,l=n.y,d=n.z;t<i.x&&Cartesian3.clone(n,i),t>a.x&&Cartesian3.clone(n,a),l<r.y&&Cartesian3.clone(n,r),l>s.y&&Cartesian3.clone(n,s),d<o.z&&Cartesian3.clone(n,o),d>c.z&&Cartesian3.clone(n,c)}const d=Cartesian3.magnitudeSquared(Cartesian3.subtract(a,i,fromPointsScratch)),h=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,r,fromPointsScratch)),p=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch));let f=i,m=a,g=d;h>g&&(g=h,f=r,m=s),p>g&&(g=p,f=o,m=c);const _=fromPointsRitterCenter;_.x=.5*(f.x+m.x),_.y=.5*(f.y+m.y),_.z=.5*(f.z+m.z);let y=Cartesian3.magnitudeSquared(Cartesian3.subtract(m,_,fromPointsScratch)),C=Math.sqrt(y);const T=fromPointsMinBoxPt;T.x=i.x,T.y=r.y,T.z=o.z;const S=fromPointsMaxBoxPt;S.x=a.x,S.y=s.y,S.z=c.z;const A=Cartesian3.midpoint(T,S,fromPointsNaiveCenterScratch);let v=0;for(u=0;u<l;u++){Cartesian3.clone(e[u],n);const t=Cartesian3.magnitude(Cartesian3.subtract(n,A,fromPointsScratch));t>v&&(v=t);const i=Cartesian3.magnitudeSquared(Cartesian3.subtract(n,_,fromPointsScratch));if(i>y){const e=Math.sqrt(i);C=.5*(C+e),y=C*C;const t=e-C;_.x=(C*_.x+t*n.x)/e,_.y=(C*_.y+t*n.y)/e,_.z=(C*_.z+t*n.z)/e}}return C<v?(Cartesian3.clone(_,t.center),t.radius=C):(Cartesian3.clone(A,t.center),t.radius=v),t};const defaultProjection$1=new GeographicProjection,fromRectangle2DLowerLeft=new Cartesian3,fromRectangle2DUpperRight=new Cartesian3,fromRectangle2DSouthwest=new Cartographic,fromRectangle2DNortheast=new Cartographic;BoundingSphere.fromRectangle2D=function(e,t,n){return BoundingSphere.fromRectangleWithHeights2D(e,t,0,0,n)},BoundingSphere.fromRectangleWithHeights2D=function(e,t,n,i,r){if(defined(r)||(r=new BoundingSphere),!defined(e))return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;t=defaultValue(t,defaultProjection$1),Rectangle.southwest(e,fromRectangle2DSouthwest),fromRectangle2DSouthwest.height=n,Rectangle.northeast(e,fromRectangle2DNortheast),fromRectangle2DNortheast.height=i;const o=t.project(fromRectangle2DSouthwest,fromRectangle2DLowerLeft),a=t.project(fromRectangle2DNortheast,fromRectangle2DUpperRight),s=a.x-o.x,c=a.y-o.y,l=a.z-o.z;r.radius=.5*Math.sqrt(s*s+c*c+l*l);const u=r.center;return u.x=o.x+.5*s,u.y=o.y+.5*c,u.z=o.z+.5*l,r};const fromRectangle3DScratch=[];BoundingSphere.fromRectangle3D=function(e,t,n,i){if(t=defaultValue(t,Ellipsoid.WGS84),n=defaultValue(n,0),defined(i)||(i=new BoundingSphere),!defined(e))return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;const r=Rectangle.subsample(e,t,n,fromRectangle3DScratch);return BoundingSphere.fromPoints(r,i)},BoundingSphere.fromVertices=function(e,t,n,i){if(defined(i)||(i=new BoundingSphere),!defined(e)||0===e.length)return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;t=defaultValue(t,Cartesian3.ZERO),n=defaultValue(n,3);const r=fromPointsCurrentPos;r.x=e[0]+t.x,r.y=e[1]+t.y,r.z=e[2]+t.z;const o=Cartesian3.clone(r,fromPointsXMin),a=Cartesian3.clone(r,fromPointsYMin),s=Cartesian3.clone(r,fromPointsZMin),c=Cartesian3.clone(r,fromPointsXMax),l=Cartesian3.clone(r,fromPointsYMax),u=Cartesian3.clone(r,fromPointsZMax),d=e.length;let h;for(h=0;h<d;h+=n){const n=e[h]+t.x,i=e[h+1]+t.y,d=e[h+2]+t.z;r.x=n,r.y=i,r.z=d,n<o.x&&Cartesian3.clone(r,o),n>c.x&&Cartesian3.clone(r,c),i<a.y&&Cartesian3.clone(r,a),i>l.y&&Cartesian3.clone(r,l),d<s.z&&Cartesian3.clone(r,s),d>u.z&&Cartesian3.clone(r,u)}const p=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),f=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),m=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch));let g=o,_=c,y=p;f>y&&(y=f,g=a,_=l),m>y&&(y=m,g=s,_=u);const C=fromPointsRitterCenter;C.x=.5*(g.x+_.x),C.y=.5*(g.y+_.y),C.z=.5*(g.z+_.z);let T=Cartesian3.magnitudeSquared(Cartesian3.subtract(_,C,fromPointsScratch)),S=Math.sqrt(T);const A=fromPointsMinBoxPt;A.x=o.x,A.y=a.y,A.z=s.z;const v=fromPointsMaxBoxPt;v.x=c.x,v.y=l.y,v.z=u.z;const E=Cartesian3.midpoint(A,v,fromPointsNaiveCenterScratch);let b=0;for(h=0;h<d;h+=n){r.x=e[h]+t.x,r.y=e[h+1]+t.y,r.z=e[h+2]+t.z;const n=Cartesian3.magnitude(Cartesian3.subtract(r,E,fromPointsScratch));n>b&&(b=n);const i=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,C,fromPointsScratch));if(i>T){const e=Math.sqrt(i);S=.5*(S+e),T=S*S;const t=e-S;C.x=(S*C.x+t*r.x)/e,C.y=(S*C.y+t*r.y)/e,C.z=(S*C.z+t*r.z)/e}}return S<b?(Cartesian3.clone(C,i.center),i.radius=S):(Cartesian3.clone(E,i.center),i.radius=b),i},BoundingSphere.fromEncodedCartesianVertices=function(e,t,n){if(defined(n)||(n=new BoundingSphere),!defined(e)||!defined(t)||e.length!==t.length||0===e.length)return n.center=Cartesian3.clone(Cartesian3.ZERO,n.center),n.radius=0,n;const i=fromPointsCurrentPos;i.x=e[0]+t[0],i.y=e[1]+t[1],i.z=e[2]+t[2];const r=Cartesian3.clone(i,fromPointsXMin),o=Cartesian3.clone(i,fromPointsYMin),a=Cartesian3.clone(i,fromPointsZMin),s=Cartesian3.clone(i,fromPointsXMax),c=Cartesian3.clone(i,fromPointsYMax),l=Cartesian3.clone(i,fromPointsZMax),u=e.length;let d;for(d=0;d<u;d+=3){const n=e[d]+t[d],u=e[d+1]+t[d+1],h=e[d+2]+t[d+2];i.x=n,i.y=u,i.z=h,n<r.x&&Cartesian3.clone(i,r),n>s.x&&Cartesian3.clone(i,s),u<o.y&&Cartesian3.clone(i,o),u>c.y&&Cartesian3.clone(i,c),h<a.z&&Cartesian3.clone(i,a),h>l.z&&Cartesian3.clone(i,l)}const h=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,r,fromPointsScratch)),p=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),f=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch));let m=r,g=s,_=h;p>_&&(_=p,m=o,g=c),f>_&&(_=f,m=a,g=l);const y=fromPointsRitterCenter;y.x=.5*(m.x+g.x),y.y=.5*(m.y+g.y),y.z=.5*(m.z+g.z);let C=Cartesian3.magnitudeSquared(Cartesian3.subtract(g,y,fromPointsScratch)),T=Math.sqrt(C);const S=fromPointsMinBoxPt;S.x=r.x,S.y=o.y,S.z=a.z;const A=fromPointsMaxBoxPt;A.x=s.x,A.y=c.y,A.z=l.z;const v=Cartesian3.midpoint(S,A,fromPointsNaiveCenterScratch);let E=0;for(d=0;d<u;d+=3){i.x=e[d]+t[d],i.y=e[d+1]+t[d+1],i.z=e[d+2]+t[d+2];const n=Cartesian3.magnitude(Cartesian3.subtract(i,v,fromPointsScratch));n>E&&(E=n);const r=Cartesian3.magnitudeSquared(Cartesian3.subtract(i,y,fromPointsScratch));if(r>C){const e=Math.sqrt(r);T=.5*(T+e),C=T*T;const t=e-T;y.x=(T*y.x+t*i.x)/e,y.y=(T*y.y+t*i.y)/e,y.z=(T*y.z+t*i.z)/e}}return T<E?(Cartesian3.clone(y,n.center),n.radius=T):(Cartesian3.clone(v,n.center),n.radius=E),n},BoundingSphere.fromCornerPoints=function(e,t,n){defined(n)||(n=new BoundingSphere);const i=Cartesian3.midpoint(e,t,n.center);return n.radius=Cartesian3.distance(i,t),n},BoundingSphere.fromEllipsoid=function(e,t){return defined(t)||(t=new BoundingSphere),Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};const fromBoundingSpheresScratch=new Cartesian3;BoundingSphere.fromBoundingSpheres=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;const n=e.length;if(1===n)return BoundingSphere.clone(e[0],t);if(2===n)return BoundingSphere.union(e[0],e[1],t);const i=[];let r;for(r=0;r<n;r++)i.push(e[r].center);const o=(t=BoundingSphere.fromPoints(i,t)).center;let a=t.radius;for(r=0;r<n;r++){const t=e[r];a=Math.max(a,Cartesian3.distance(o,t.center,fromBoundingSpheresScratch)+t.radius)}return t.radius=a,t};const fromOrientedBoundingBoxScratchU=new Cartesian3,fromOrientedBoundingBoxScratchV=new Cartesian3,fromOrientedBoundingBoxScratchW=new Cartesian3;BoundingSphere.fromOrientedBoundingBox=function(e,t){defined(t)||(t=new BoundingSphere);const n=e.halfAxes,i=Matrix3.getColumn(n,0,fromOrientedBoundingBoxScratchU),r=Matrix3.getColumn(n,1,fromOrientedBoundingBoxScratchV),o=Matrix3.getColumn(n,2,fromOrientedBoundingBoxScratchW);return Cartesian3.add(i,r,i),Cartesian3.add(i,o,i),t.center=Cartesian3.clone(e.center,t.center),t.radius=Cartesian3.magnitude(i),t};const scratchFromTransformationCenter=new Cartesian3,scratchFromTransformationScale=new Cartesian3;BoundingSphere.fromTransformation=function(e,t){defined(t)||(t=new BoundingSphere);const n=Matrix4.getTranslation(e,scratchFromTransformationCenter),i=Matrix4.getScale(e,scratchFromTransformationScale),r=.5*Cartesian3.magnitude(i);return t.center=Cartesian3.clone(n,t.center),t.radius=r,t},BoundingSphere.clone=function(e,t){if(defined(e))return defined(t)?(t.center=Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new BoundingSphere(e.center,e.radius)},BoundingSphere.packedLength=4,BoundingSphere.pack=function(e,t,n){n=defaultValue(n,0);const i=e.center;return t[n++]=i.x,t[n++]=i.y,t[n++]=i.z,t[n]=e.radius,t},BoundingSphere.unpack=function(e,t,n){t=defaultValue(t,0),defined(n)||(n=new BoundingSphere);const i=n.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],n.radius=e[t],n};const unionScratch=new Cartesian3,unionScratchCenter=new Cartesian3;BoundingSphere.union=function(e,t,n){defined(n)||(n=new BoundingSphere);const i=e.center,r=e.radius,o=t.center,a=t.radius,s=Cartesian3.subtract(o,i,unionScratch),c=Cartesian3.magnitude(s);if(r>=c+a)return e.clone(n),n;if(a>=c+r)return t.clone(n),n;const l=.5*(r+c+a),u=Cartesian3.multiplyByScalar(s,(-r+l)/c,unionScratchCenter);return Cartesian3.add(u,i,u),Cartesian3.clone(u,n.center),n.radius=l,n};const expandScratch=new Cartesian3;BoundingSphere.expand=function(e,t,n){n=BoundingSphere.clone(e,n);const i=Cartesian3.magnitude(Cartesian3.subtract(t,n.center,expandScratch));return i>n.radius&&(n.radius=i),n},BoundingSphere.intersectPlane=function(e,t){const n=e.center,i=e.radius,r=t.normal,o=Cartesian3.dot(r,n)+t.distance;return o<-i?Intersect$1.OUTSIDE:o<i?Intersect$1.INTERSECTING:Intersect$1.INSIDE},BoundingSphere.transform=function(e,t,n){return defined(n)||(n=new BoundingSphere),n.center=Matrix4.multiplyByPoint(t,e.center,n.center),n.radius=Matrix4.getMaximumScale(t)*e.radius,n};const distanceSquaredToScratch=new Cartesian3;BoundingSphere.distanceSquaredTo=function(e,t){const n=Cartesian3.subtract(e.center,t,distanceSquaredToScratch),i=Cartesian3.magnitude(n)-e.radius;return i<=0?0:i*i},BoundingSphere.transformWithoutScale=function(e,t,n){return defined(n)||(n=new BoundingSphere),n.center=Matrix4.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};const scratchCartesian3$d=new Cartesian3;BoundingSphere.computePlaneDistances=function(e,t,n,i){defined(i)||(i=new Interval);const r=Cartesian3.subtract(e.center,t,scratchCartesian3$d),o=Cartesian3.dot(n,r);return i.start=o-e.radius,i.stop=o+e.radius,i};const projectTo2DNormalScratch=new Cartesian3,projectTo2DEastScratch=new Cartesian3,projectTo2DNorthScratch=new Cartesian3,projectTo2DWestScratch=new Cartesian3,projectTo2DSouthScratch=new Cartesian3,projectTo2DCartographicScratch=new Cartographic,projectTo2DPositionsScratch=new Array(8);for(let e=0;e<8;++e)projectTo2DPositionsScratch[e]=new Cartesian3;const projectTo2DProjection=new GeographicProjection;BoundingSphere.projectTo2D=function(e,t,n){const i=(t=defaultValue(t,projectTo2DProjection)).ellipsoid;let r=e.center;const o=e.radius;let a;a=Cartesian3.equals(r,Cartesian3.ZERO)?Cartesian3.clone(Cartesian3.UNIT_X,projectTo2DNormalScratch):i.geodeticSurfaceNormal(r,projectTo2DNormalScratch);const s=Cartesian3.cross(Cartesian3.UNIT_Z,a,projectTo2DEastScratch);Cartesian3.normalize(s,s);const c=Cartesian3.cross(a,s,projectTo2DNorthScratch);Cartesian3.normalize(c,c),Cartesian3.multiplyByScalar(a,o,a),Cartesian3.multiplyByScalar(c,o,c),Cartesian3.multiplyByScalar(s,o,s);const l=Cartesian3.negate(c,projectTo2DSouthScratch),u=Cartesian3.negate(s,projectTo2DWestScratch),d=projectTo2DPositionsScratch;let h=d[0];Cartesian3.add(a,c,h),Cartesian3.add(h,s,h),h=d[1],Cartesian3.add(a,c,h),Cartesian3.add(h,u,h),h=d[2],Cartesian3.add(a,l,h),Cartesian3.add(h,u,h),h=d[3],Cartesian3.add(a,l,h),Cartesian3.add(h,s,h),Cartesian3.negate(a,a),h=d[4],Cartesian3.add(a,c,h),Cartesian3.add(h,s,h),h=d[5],Cartesian3.add(a,c,h),Cartesian3.add(h,u,h),h=d[6],Cartesian3.add(a,l,h),Cartesian3.add(h,u,h),h=d[7],Cartesian3.add(a,l,h),Cartesian3.add(h,s,h);const p=d.length;for(let e=0;e<p;++e){const n=d[e];Cartesian3.add(r,n,n);const o=i.cartesianToCartographic(n,projectTo2DCartographicScratch);t.project(o,n)}r=(n=BoundingSphere.fromPoints(d,n)).center;const f=r.x,m=r.y,g=r.z;return r.x=g,r.y=f,r.z=m,n},BoundingSphere.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},BoundingSphere.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},BoundingSphere.prototype.intersectPlane=function(e){return BoundingSphere.intersectPlane(this,e)},BoundingSphere.prototype.distanceSquaredTo=function(e){return BoundingSphere.distanceSquaredTo(this,e)},BoundingSphere.prototype.computePlaneDistances=function(e,t,n){return BoundingSphere.computePlaneDistances(this,e,t,n)},BoundingSphere.prototype.isOccluded=function(e){return BoundingSphere.isOccluded(this,e)},BoundingSphere.prototype.equals=function(e){return BoundingSphere.equals(this,e)},BoundingSphere.prototype.clone=function(e){return BoundingSphere.clone(this,e)},BoundingSphere.prototype.volume=function(){const e=this.radius;return volumeConstant*e*e*e};var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function createCommonjsModule(e,t,n){return e(n={path:t,exports:{},require:function(e,t){return commonjsRequire(e,null==t?n.path:t)}},n.exports),n.exports}function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}var punycode=createCommonjsModule((function(e,t){!function(n){var i=t&&!t.nodeType&&t,r=e&&!e.nodeType&&e,o="object"==typeof commonjsGlobal&&commonjsGlobal;o.global!==o&&o.window!==o&&o.self!==o||(n=o);var a,s,c=2147483647,l=36,u=/^xn--/,d=/[^\x20-\x7E]/,h=/[\x2E\u3002\uFF0E\uFF61]/g,p={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},f=Math.floor,m=String.fromCharCode;function g(e){throw new RangeError(p[e])}function _(e,t){for(var n=e.length,i=[];n--;)i[n]=t(e[n]);return i}function y(e,t){var n=e.split("@"),i="";return n.length>1&&(i=n[0]+"@",e=n[1]),i+_((e=e.replace(h,".")).split("."),t).join(".")}function C(e){for(var t,n,i=[],r=0,o=e.length;r<o;)(t=e.charCodeAt(r++))>=55296&&t<=56319&&r<o?56320==(64512&(n=e.charCodeAt(r++)))?i.push(((1023&t)<<10)+(1023&n)+65536):(i.push(t),r--):i.push(t);return i}function T(e){return _(e,(function(e){var t="";return e>65535&&(t+=m((e-=65536)>>>10&1023|55296),e=56320|1023&e),t+=m(e)})).join("")}function S(e,t){return e+22+75*(e<26)-((0!=t)<<5)}function A(e,t,n){var i=0;for(e=n?f(e/700):e>>1,e+=f(e/t);e>455;i+=l)e=f(e/35);return f(i+36*e/(e+38))}function v(e){var t,n,i,r,o,a,s,u,d,h,p,m=[],_=e.length,y=0,C=128,S=72;for((n=e.lastIndexOf("-"))<0&&(n=0),i=0;i<n;++i)e.charCodeAt(i)>=128&&g("not-basic"),m.push(e.charCodeAt(i));for(r=n>0?n+1:0;r<_;){for(o=y,a=1,s=l;r>=_&&g("invalid-input"),((u=(p=e.charCodeAt(r++))-48<10?p-22:p-65<26?p-65:p-97<26?p-97:l)>=l||u>f((c-y)/a))&&g("overflow"),y+=u*a,!(u<(d=s<=S?1:s>=S+26?26:s-S));s+=l)a>f(c/(h=l-d))&&g("overflow"),a*=h;S=A(y-o,t=m.length+1,0==o),f(y/t)>c-C&&g("overflow"),C+=f(y/t),y%=t,m.splice(y++,0,C)}return T(m)}function E(e){var t,n,i,r,o,a,s,u,d,h,p,_,y,T,v,E=[];for(_=(e=C(e)).length,t=128,n=0,o=72,a=0;a<_;++a)(p=e[a])<128&&E.push(m(p));for(i=r=E.length,r&&E.push("-");i<_;){for(s=c,a=0;a<_;++a)(p=e[a])>=t&&p<s&&(s=p);for(s-t>f((c-n)/(y=i+1))&&g("overflow"),n+=(s-t)*y,t=s,a=0;a<_;++a)if((p=e[a])<t&&++n>c&&g("overflow"),p==t){for(u=n,d=l;!(u<(h=d<=o?1:d>=o+26?26:d-o));d+=l)v=u-h,T=l-h,E.push(m(S(h+v%T,0))),u=f(v/T);E.push(m(S(u,0))),o=A(n,y,i==r),n=0,++i}++n,++t}return E.join("")}if(a={version:"1.3.2",ucs2:{decode:C,encode:T},decode:v,encode:E,toASCII:function(e){return y(e,(function(e){return d.test(e)?"xn--"+E(e):e}))},toUnicode:function(e){return y(e,(function(e){return u.test(e)?v(e.slice(4).toLowerCase()):e}))}},i&&r)if(e.exports==i)r.exports=a;else for(s in a)a.hasOwnProperty(s)&&(i[s]=a[s]);else n.punycode=a}(commonjsGlobal)})),IPv6=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   * IPv6 Support
   *
   * Version: 1.19.8
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,n;t=commonjsGlobal,n=function(e){var t=e&&e.IPv6;return{best:function(e){var t,n,i=e.toLowerCase().split(":"),r=i.length,o=8;for(""===i[0]&&""===i[1]&&""===i[2]?(i.shift(),i.shift()):""===i[0]&&""===i[1]?i.shift():""===i[r-1]&&""===i[r-2]&&i.pop(),-1!==i[(r=i.length)-1].indexOf(".")&&(o=7),t=0;t<r&&""!==i[t];t++);if(t<o)for(i.splice(t,1,"0000");i.length<o;)i.splice(t,0,"0000");for(var a=0;a<o;a++){n=i[a].split("");for(var s=0;s<3&&"0"===n[0]&&n.length>1;s++)n.splice(0,1);i[a]=n.join("")}var c=-1,l=0,u=0,d=-1,h=!1;for(a=0;a<o;a++)h?"0"===i[a]?u+=1:(h=!1,u>l&&(c=d,l=u)):"0"===i[a]&&(h=!0,d=a,u=1);u>l&&(c=d,l=u),l>1&&i.splice(c,l,""),r=i.length;var p="";for(""===i[0]&&(p=":"),a=0;a<r&&(p+=i[a],a!==r-1);a++)p+=":";return""===i[r-1]&&(p+=":"),p},noConflict:function(){return e.IPv6===this&&(e.IPv6=t),this}}},e.exports?e.exports=n():t.IPv6=n(t)})),SecondLevelDomains=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   * Second Level Domain (SLD) Support
   *
   * Version: 1.19.8
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,n;t=commonjsGlobal,n=function(e){var t=e&&e.SecondLevelDomains,n={list:{ac:" com gov mil net org ",ae:" ac co gov mil name net org pro sch ",af:" com edu gov net org ",al:" com edu gov mil net org ",ao:" co ed gv it og pb ",ar:" com edu gob gov int mil net org tur ",at:" ac co gv or ",au:" asn com csiro edu gov id net org ",ba:" co com edu gov mil net org rs unbi unmo unsa untz unze ",bb:" biz co com edu gov info net org store tv ",bh:" biz cc com edu gov info net org ",bn:" com edu gov net org ",bo:" com edu gob gov int mil net org tv ",br:" adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",bs:" com edu gov net org ",bz:" du et om ov rg ",ca:" ab bc mb nb nf nl ns nt nu on pe qc sk yk ",ck:" biz co edu gen gov info net org ",cn:" ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",co:" com edu gov mil net nom org ",cr:" ac c co ed fi go or sa ",cy:" ac biz com ekloges gov ltd name net org parliament press pro tm ",do:" art com edu gob gov mil net org sld web ",dz:" art asso com edu gov net org pol ",ec:" com edu fin gov info med mil net org pro ",eg:" com edu eun gov mil name net org sci ",er:" com edu gov ind mil net org rochest w ",es:" com edu gob nom org ",et:" biz com edu gov info name net org ",fj:" ac biz com info mil name net org pro ",fk:" ac co gov net nom org ",fr:" asso com f gouv nom prd presse tm ",gg:" co net org ",gh:" com edu gov mil org ",gn:" ac com gov net org ",gr:" com edu gov mil net org ",gt:" com edu gob ind mil net org ",gu:" com edu gov net org ",hk:" com edu gov idv net org ",hu:" 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",id:" ac co go mil net or sch web ",il:" ac co gov idf k12 muni net org ",in:" ac co edu ernet firm gen gov i ind mil net nic org res ",iq:" com edu gov i mil net org ",ir:" ac co dnssec gov i id net org sch ",it:" edu gov ",je:" co net org ",jo:" com edu gov mil name net org sch ",jp:" ac ad co ed go gr lg ne or ",ke:" ac co go info me mobi ne or sc ",kh:" com edu gov mil net org per ",ki:" biz com de edu gov info mob net org tel ",km:" asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",kn:" edu gov net org ",kr:" ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",kw:" com edu gov net org ",ky:" com edu gov net org ",kz:" com edu gov mil net org ",lb:" com edu gov net org ",lk:" assn com edu gov grp hotel int ltd net ngo org sch soc web ",lr:" com edu gov net org ",lv:" asn com conf edu gov id mil net org ",ly:" com edu gov id med net org plc sch ",ma:" ac co gov m net org press ",mc:" asso tm ",me:" ac co edu gov its net org priv ",mg:" com edu gov mil nom org prd tm ",mk:" com edu gov inf name net org pro ",ml:" com edu gov net org presse ",mn:" edu gov org ",mo:" com edu gov net org ",mt:" com edu gov net org ",mv:" aero biz com coop edu gov info int mil museum name net org pro ",mw:" ac co com coop edu gov int museum net org ",mx:" com edu gob net org ",my:" com edu gov mil name net org sch ",nf:" arts com firm info net other per rec store web ",ng:" biz com edu gov mil mobi name net org sch ",ni:" ac co com edu gob mil net nom org ",np:" com edu gov mil net org ",nr:" biz com edu gov info net org ",om:" ac biz co com edu gov med mil museum net org pro sch ",pe:" com edu gob mil net nom org sld ",ph:" com edu gov i mil net ngo org ",pk:" biz com edu fam gob gok gon gop gos gov net org web ",pl:" art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",pr:" ac biz com edu est gov info isla name net org pro prof ",ps:" com edu gov net org plo sec ",pw:" belau co ed go ne or ",ro:" arts com firm info nom nt org rec store tm www ",rs:" ac co edu gov in org ",sb:" com edu gov net org ",sc:" com edu gov net org ",sh:" co com edu gov net nom org ",sl:" com edu gov net org ",st:" co com consulado edu embaixada gov mil net org principe saotome store ",sv:" com edu gob org red ",sz:" ac co org ",tr:" av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",tt:" aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",tw:" club com ebiz edu game gov idv mil net org ",mu:" ac co com gov net or org ",mz:" ac co edu gov org ",na:" co com ",nz:" ac co cri geek gen govt health iwi maori mil net org parliament school ",pa:" abo ac com edu gob ing med net nom org sld ",pt:" com edu gov int net nome org publ ",py:" com edu gov mil net org ",qa:" com edu gov mil net org ",re:" asso com nom ",ru:" ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",rw:" ac co com edu gouv gov int mil net ",sa:" com edu gov med net org pub sch ",sd:" com edu gov info med net org tv ",se:" a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",sg:" com edu gov idn net org per ",sn:" art com edu gouv org perso univ ",sy:" com edu gov mil net news org ",th:" ac co go in mi net or ",tj:" ac biz co com edu go gov info int mil name net nic org test web ",tn:" agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",tz:" ac co go ne or ",ua:" biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",ug:" ac co go ne or org sc ",uk:" ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",us:" dni fed isa kids nsn ",uy:" com edu gub mil net org ",ve:" co com edu gob info mil net org web ",vi:" co com k12 net org ",vn:" ac biz com edu gov health info int name net org pro ",ye:" co com gov ltd me net org plc ",yu:" ac co edu gov org ",za:" ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",zm:" ac co com edu gov net org sch ",com:"ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",net:"gb jp se uk ",org:"ae",de:"com "},has:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;var i=e.lastIndexOf(".",t-1);if(i<=0||i>=t-1)return!1;var r=n.list[e.slice(t+1)];return!!r&&r.indexOf(" "+e.slice(i+1,t)+" ")>=0},is:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;if(e.lastIndexOf(".",t-1)>=0)return!1;var i=n.list[e.slice(t+1)];return!!i&&i.indexOf(" "+e.slice(0,t)+" ")>=0},get:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return null;var i=e.lastIndexOf(".",t-1);if(i<=0||i>=t-1)return null;var r=n.list[e.slice(t+1)];return r?r.indexOf(" "+e.slice(i+1,t)+" ")<0?null:e.slice(i+1):null},noConflict:function(){return e.SecondLevelDomains===this&&(e.SecondLevelDomains=t),this}};return n},e.exports?e.exports=n():t.SecondLevelDomains=n(t)})),URI=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   *
   * Version: 1.19.8
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,n;t=commonjsGlobal,n=function(e,t,n,i){var r=i&&i.URI;function o(e,t){var n=arguments.length>=1,i=arguments.length>=2;if(!(this instanceof o))return n?i?new o(e,t):new o(e):new o;if(void 0===e){if(n)throw new TypeError("undefined is not a valid argument for URI");e="undefined"!=typeof location?location.href+"":""}if(null===e&&n)throw new TypeError("null is not a valid argument for URI");return this.href(e),void 0!==t?this.absoluteTo(t):this}o.version="1.19.8";var a=o.prototype,s=Object.prototype.hasOwnProperty;function c(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function l(e){return void 0===e?"Undefined":String(Object.prototype.toString.call(e)).slice(8,-1)}function u(e){return"Array"===l(e)}function d(e,t){var n,i,r={};if("RegExp"===l(t))r=null;else if(u(t))for(n=0,i=t.length;n<i;n++)r[t[n]]=!0;else r[t]=!0;for(n=0,i=e.length;n<i;n++)(r&&void 0!==r[e[n]]||!r&&t.test(e[n]))&&(e.splice(n,1),i--,n--);return e}function h(e,t){var n,i;if(u(t)){for(n=0,i=t.length;n<i;n++)if(!h(e,t[n]))return!1;return!0}var r=l(t);for(n=0,i=e.length;n<i;n++)if("RegExp"===r){if("string"==typeof e[n]&&e[n].match(t))return!0}else if(e[n]===t)return!0;return!1}function p(e,t){if(!u(e)||!u(t))return!1;if(e.length!==t.length)return!1;e.sort(),t.sort();for(var n=0,i=e.length;n<i;n++)if(e[n]!==t[n])return!1;return!0}function f(e){return e.replace(/^\/+|\/+$/g,"")}function m(e){return escape(e)}function g(e){return encodeURIComponent(e).replace(/[!'()*]/g,m).replace(/\*/g,"%2A")}o._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:o.preventInvalidHostname,duplicateQueryParameters:o.duplicateQueryParameters,escapeQuerySpace:o.escapeQuerySpace}},o.preventInvalidHostname=!1,o.duplicateQueryParameters=!1,o.escapeQuerySpace=!0,o.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,o.idn_expression=/[^a-z0-9\._-]/i,o.punycode_expression=/(xn--)/i,o.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,o.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,o.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi,o.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g},o.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},o.hostProtocols=["http","https"],o.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/,o.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},o.getDomAttribute=function(e){if(e&&e.nodeName){var t=e.nodeName.toLowerCase();if("input"!==t||"image"===e.type)return o.domAttributes[t]}},o.encode=g,o.decode=decodeURIComponent,o.iso8859=function(){o.encode=escape,o.decode=unescape},o.unicode=function(){o.encode=g,o.decode=decodeURIComponent},o.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},o.encodeQuery=function(e,t){var n=o.encode(e+"");return void 0===t&&(t=o.escapeQuerySpace),t?n.replace(/%20/g,"+"):n},o.decodeQuery=function(e,t){e+="",void 0===t&&(t=o.escapeQuerySpace);try{return o.decode(t?e.replace(/\+/g,"%20"):e)}catch(t){return e}};var _,y={encode:"encode",decode:"decode"},C=function(e,t){return function(n){try{return o[t](n+"").replace(o.characters[e][t].expression,(function(n){return o.characters[e][t].map[n]}))}catch(e){return n}}};for(_ in y)o[_+"PathSegment"]=C("pathname",y[_]),o[_+"UrnPathSegment"]=C("urnpath",y[_]);var T=function(e,t,n){return function(i){var r;r=n?function(e){return o[t](o[n](e))}:o[t];for(var a=(i+"").split(e),s=0,c=a.length;s<c;s++)a[s]=r(a[s]);return a.join(e)}};function S(e){return function(t,n){return void 0===t?this._parts[e]||"":(this._parts[e]=t||null,this.build(!n),this)}}function A(e,t){return function(n,i){return void 0===n?this._parts[e]||"":(null!==n&&(n+="").charAt(0)===t&&(n=n.substring(1)),this._parts[e]=n,this.build(!i),this)}}o.decodePath=T("/","decodePathSegment"),o.decodeUrnPath=T(":","decodeUrnPathSegment"),o.recodePath=T("/","encodePathSegment","decode"),o.recodeUrnPath=T(":","encodeUrnPathSegment","decode"),o.encodeReserved=C("reserved","encode"),o.parse=function(e,t){var n;return t||(t={preventInvalidHostname:o.preventInvalidHostname}),(n=e.indexOf("#"))>-1&&(t.fragment=e.substring(n+1)||null,e=e.substring(0,n)),(n=e.indexOf("?"))>-1&&(t.query=e.substring(n+1)||null,e=e.substring(0,n)),"//"===(e=e.replace(/^(https?|ftp|wss?)?:[/\\]*/i,"$1://")).substring(0,2)?(t.protocol=null,e=e.substring(2),e=o.parseAuthority(e,t)):(n=e.indexOf(":"))>-1&&(t.protocol=e.substring(0,n)||null,t.protocol&&!t.protocol.match(o.protocol_expression)?t.protocol=void 0:"//"===e.substring(n+1,n+3).replace(/\\/g,"/")?(e=e.substring(n+3),e=o.parseAuthority(e,t)):(e=e.substring(n+1),t.urn=!0)),t.path=e,t},o.parseHost=function(e,t){e||(e="");var n,i,r=(e=e.replace(/\\/g,"/")).indexOf("/");if(-1===r&&(r=e.length),"["===e.charAt(0))n=e.indexOf("]"),t.hostname=e.substring(1,n)||null,t.port=e.substring(n+2,r)||null,"/"===t.port&&(t.port=null);else{var a=e.indexOf(":"),s=e.indexOf("/"),c=e.indexOf(":",a+1);-1!==c&&(-1===s||c<s)?(t.hostname=e.substring(0,r)||null,t.port=null):(i=e.substring(0,r).split(":"),t.hostname=i[0]||null,t.port=i[1]||null)}return t.hostname&&"/"!==e.substring(r).charAt(0)&&(r++,e="/"+e),t.preventInvalidHostname&&o.ensureValidHostname(t.hostname,t.protocol),t.port&&o.ensureValidPort(t.port),e.substring(r)||"/"},o.parseAuthority=function(e,t){return e=o.parseUserinfo(e,t),o.parseHost(e,t)},o.parseUserinfo=function(e,t){var n=e;-1!==e.indexOf("\\")&&(e=e.replace(/\\/g,"/"));var i,r=e.indexOf("/"),a=e.lastIndexOf("@",r>-1?r:e.length-1);return a>-1&&(-1===r||a<r)?(i=e.substring(0,a).split(":"),t.username=i[0]?o.decode(i[0]):null,i.shift(),t.password=i[0]?o.decode(i.join(":")):null,e=n.substring(a+1)):(t.username=null,t.password=null),e},o.parseQuery=function(e,t){if(!e)return{};if(!(e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"")))return{};for(var n,i,r,a={},c=e.split("&"),l=c.length,u=0;u<l;u++)n=c[u].split("="),i=o.decodeQuery(n.shift(),t),r=n.length?o.decodeQuery(n.join("="),t):null,"__proto__"!==i&&(s.call(a,i)?("string"!=typeof a[i]&&null!==a[i]||(a[i]=[a[i]]),a[i].push(r)):a[i]=r);return a},o.build=function(e){var t="",n=!1;return e.protocol&&(t+=e.protocol+":"),e.urn||!t&&!e.hostname||(t+="//",n=!0),t+=o.buildAuthority(e)||"","string"==typeof e.path&&("/"!==e.path.charAt(0)&&n&&(t+="/"),t+=e.path),"string"==typeof e.query&&e.query&&(t+="?"+e.query),"string"==typeof e.fragment&&e.fragment&&(t+="#"+e.fragment),t},o.buildHost=function(e){var t="";return e.hostname?(o.ip6_expression.test(e.hostname)?t+="["+e.hostname+"]":t+=e.hostname,e.port&&(t+=":"+e.port),t):""},o.buildAuthority=function(e){return o.buildUserinfo(e)+o.buildHost(e)},o.buildUserinfo=function(e){var t="";return e.username&&(t+=o.encode(e.username)),e.password&&(t+=":"+o.encode(e.password)),t&&(t+="@"),t},o.buildQuery=function(e,t,n){var i,r,a,c,l="";for(r in e)if("__proto__"!==r&&s.call(e,r))if(u(e[r]))for(i={},a=0,c=e[r].length;a<c;a++)void 0!==e[r][a]&&void 0===i[e[r][a]+""]&&(l+="&"+o.buildQueryParameter(r,e[r][a],n),!0!==t&&(i[e[r][a]+""]=!0));else void 0!==e[r]&&(l+="&"+o.buildQueryParameter(r,e[r],n));return l.substring(1)},o.buildQueryParameter=function(e,t,n){return o.encodeQuery(e,n)+(null!==t?"="+o.encodeQuery(t,n):"")},o.addQuery=function(e,t,n){if("object"==typeof t)for(var i in t)s.call(t,i)&&o.addQuery(e,i,t[i]);else{if("string"!=typeof t)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");if(void 0===e[t])return void(e[t]=n);"string"==typeof e[t]&&(e[t]=[e[t]]),u(n)||(n=[n]),e[t]=(e[t]||[]).concat(n)}},o.setQuery=function(e,t,n){if("object"==typeof t)for(var i in t)s.call(t,i)&&o.setQuery(e,i,t[i]);else{if("string"!=typeof t)throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");e[t]=void 0===n?null:n}},o.removeQuery=function(e,t,n){var i,r,a;if(u(t))for(i=0,r=t.length;i<r;i++)e[t[i]]=void 0;else if("RegExp"===l(t))for(a in e)t.test(a)&&(e[a]=void 0);else if("object"==typeof t)for(a in t)s.call(t,a)&&o.removeQuery(e,a,t[a]);else{if("string"!=typeof t)throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");void 0!==n?"RegExp"===l(n)?!u(e[t])&&n.test(e[t])?e[t]=void 0:e[t]=d(e[t],n):e[t]!==String(n)||u(n)&&1!==n.length?u(e[t])&&(e[t]=d(e[t],n)):e[t]=void 0:e[t]=void 0}},o.hasQuery=function(e,t,n,i){switch(l(t)){case"String":break;case"RegExp":for(var r in e)if(s.call(e,r)&&t.test(r)&&(void 0===n||o.hasQuery(e,r,n)))return!0;return!1;case"Object":for(var a in t)if(s.call(t,a)&&!o.hasQuery(e,a,t[a]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(l(n)){case"Undefined":return t in e;case"Boolean":return n===Boolean(u(e[t])?e[t].length:e[t]);case"Function":return!!n(e[t],t,e);case"Array":return!!u(e[t])&&(i?h:p)(e[t],n);case"RegExp":return u(e[t])?!!i&&h(e[t],n):Boolean(e[t]&&e[t].match(n));case"Number":n=String(n);case"String":return u(e[t])?!!i&&h(e[t],n):e[t]===n;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},o.joinPaths=function(){for(var e=[],t=[],n=0,i=0;i<arguments.length;i++){var r=new o(arguments[i]);e.push(r);for(var a=r.segment(),s=0;s<a.length;s++)"string"==typeof a[s]&&t.push(a[s]),a[s]&&n++}if(!t.length||!n)return new o("");var c=new o("").segment(t);return""!==e[0].path()&&"/"!==e[0].path().slice(0,1)||c.path("/"+c.path()),c.normalize()},o.commonPath=function(e,t){var n,i=Math.min(e.length,t.length);for(n=0;n<i;n++)if(e.charAt(n)!==t.charAt(n)){n--;break}return n<1?e.charAt(0)===t.charAt(0)&&"/"===e.charAt(0)?"/":"":("/"===e.charAt(n)&&"/"===t.charAt(n)||(n=e.substring(0,n).lastIndexOf("/")),e.substring(0,n+1))},o.withinString=function(e,t,n){n||(n={});var i=n.start||o.findUri.start,r=n.end||o.findUri.end,a=n.trim||o.findUri.trim,s=n.parens||o.findUri.parens,c=/[a-z0-9-]=["']?$/i;for(i.lastIndex=0;;){var l=i.exec(e);if(!l)break;var u=l.index;if(n.ignoreHtml){var d=e.slice(Math.max(u-3,0),u);if(d&&c.test(d))continue}for(var h=u+e.slice(u).search(r),p=e.slice(u,h),f=-1;;){var m=s.exec(p);if(!m)break;var g=m.index+m[0].length;f=Math.max(f,g)}if(!((p=f>-1?p.slice(0,f)+p.slice(f).replace(a,""):p.replace(a,"")).length<=l[0].length||n.ignore&&n.ignore.test(p))){var _=t(p,u,h=u+p.length,e);void 0!==_?(_=String(_),e=e.slice(0,u)+_+e.slice(h),i.lastIndex=u+_.length):i.lastIndex=h}}return i.lastIndex=0,e},o.ensureValidHostname=function(t,n){var i=!!t,r=!1;if(!!n&&(r=h(o.hostProtocols,n)),r&&!i)throw new TypeError("Hostname cannot be empty, if protocol is "+n);if(t&&t.match(o.invalid_hostname_characters)){if(!e)throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(e.toASCII(t).match(o.invalid_hostname_characters))throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_]')}},o.ensureValidPort=function(e){if(e){var t=Number(e);if(!(/^[0-9]+$/.test(t)&&t>0&&t<65536))throw new TypeError('Port "'+e+'" is not a valid port')}},o.noConflict=function(e){if(e){var t={URI:this.noConflict()};return i.URITemplate&&"function"==typeof i.URITemplate.noConflict&&(t.URITemplate=i.URITemplate.noConflict()),i.IPv6&&"function"==typeof i.IPv6.noConflict&&(t.IPv6=i.IPv6.noConflict()),i.SecondLevelDomains&&"function"==typeof i.SecondLevelDomains.noConflict&&(t.SecondLevelDomains=i.SecondLevelDomains.noConflict()),t}return i.URI===this&&(i.URI=r),this},a.build=function(e){return!0===e?this._deferred_build=!0:(void 0===e||this._deferred_build)&&(this._string=o.build(this._parts),this._deferred_build=!1),this},a.clone=function(){return new o(this)},a.valueOf=a.toString=function(){return this.build(!1)._string},a.protocol=S("protocol"),a.username=S("username"),a.password=S("password"),a.hostname=S("hostname"),a.port=S("port"),a.query=A("query","?"),a.fragment=A("fragment","#"),a.search=function(e,t){var n=this.query(e,t);return"string"==typeof n&&n.length?"?"+n:n},a.hash=function(e,t){var n=this.fragment(e,t);return"string"==typeof n&&n.length?"#"+n:n},a.pathname=function(e,t){if(void 0===e||!0===e){var n=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?o.decodeUrnPath:o.decodePath)(n):n}return this._parts.urn?this._parts.path=e?o.recodeUrnPath(e):"":this._parts.path=e?o.recodePath(e):"/",this.build(!t),this},a.path=a.pathname,a.href=function(e,t){var n;if(void 0===e)return this.toString();this._string="",this._parts=o._parts();var i=e instanceof o,r="object"==typeof e&&(e.hostname||e.path||e.pathname);if(e.nodeName&&(e=e[o.getDomAttribute(e)]||"",r=!1),!i&&r&&void 0!==e.pathname&&(e=e.toString()),"string"==typeof e||e instanceof String)this._parts=o.parse(String(e),this._parts);else{if(!i&&!r)throw new TypeError("invalid input");var a=i?e._parts:e;for(n in a)"query"!==n&&s.call(this._parts,n)&&(this._parts[n]=a[n]);a.query&&this.query(a.query,!1)}return this.build(!t),this},a.is=function(e){var t=!1,i=!1,r=!1,a=!1,s=!1,c=!1,l=!1,u=!this._parts.urn;switch(this._parts.hostname&&(u=!1,i=o.ip4_expression.test(this._parts.hostname),r=o.ip6_expression.test(this._parts.hostname),s=(a=!(t=i||r))&&n&&n.has(this._parts.hostname),c=a&&o.idn_expression.test(this._parts.hostname),l=a&&o.punycode_expression.test(this._parts.hostname)),e.toLowerCase()){case"relative":return u;case"absolute":return!u;case"domain":case"name":return a;case"sld":return s;case"ip":return t;case"ip4":case"ipv4":case"inet4":return i;case"ip6":case"ipv6":case"inet6":return r;case"idn":return c;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return l}return null};var v=a.protocol,E=a.port,b=a.hostname;a.protocol=function(e,t){if(e&&!(e=e.replace(/:(\/\/)?$/,"")).match(o.protocol_expression))throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]");return v.call(this,e,t)},a.scheme=a.protocol,a.port=function(e,t){return this._parts.urn?void 0===e?"":this:(void 0!==e&&(0===e&&(e=null),e&&(":"===(e+="").charAt(0)&&(e=e.substring(1)),o.ensureValidPort(e))),E.call(this,e,t))},a.hostname=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0!==e){var n={preventInvalidHostname:this._parts.preventInvalidHostname};if("/"!==o.parseHost(e,n))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');e=n.hostname,this._parts.preventInvalidHostname&&o.ensureValidHostname(e,this._parts.protocol)}return b.call(this,e,t)},a.origin=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){var n=this.protocol();return this.authority()?(n?n+"://":"")+this.authority():""}var i=o(e);return this.protocol(i.protocol()).authority(i.authority()).build(!t),this},a.host=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?o.buildHost(this._parts):"";if("/"!==o.parseHost(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},a.authority=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?o.buildAuthority(this._parts):"";if("/"!==o.parseAuthority(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},a.userinfo=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){var n=o.buildUserinfo(this._parts);return n?n.substring(0,n.length-1):n}return"@"!==e[e.length-1]&&(e+="@"),o.parseUserinfo(e,this._parts),this.build(!t),this},a.resource=function(e,t){var n;return void 0===e?this.path()+this.search()+this.hash():(n=o.parse(e),this._parts.path=n.path,this._parts.query=n.query,this._parts.fragment=n.fragment,this.build(!t),this)},a.subdomain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var n=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,n)||""}var i=this._parts.hostname.length-this.domain().length,r=this._parts.hostname.substring(0,i),a=new RegExp("^"+c(r));if(e&&"."!==e.charAt(e.length-1)&&(e+="."),-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");return e&&o.ensureValidHostname(e,this._parts.protocol),this._parts.hostname=this._parts.hostname.replace(a,e),this.build(!t),this},a.domain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var n=this._parts.hostname.match(/\./g);if(n&&n.length<2)return this._parts.hostname;var i=this._parts.hostname.length-this.tld(t).length-1;return i=this._parts.hostname.lastIndexOf(".",i-1)+1,this._parts.hostname.substring(i)||""}if(!e)throw new TypeError("cannot set domain empty");if(-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");if(o.ensureValidHostname(e,this._parts.protocol),!this._parts.hostname||this.is("IP"))this._parts.hostname=e;else{var r=new RegExp(c(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(r,e)}return this.build(!t),this},a.tld=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.lastIndexOf("."),r=this._parts.hostname.substring(i+1);return!0!==t&&n&&n.list[r.toLowerCase()]&&n.get(this._parts.hostname)||r}var o;if(!e)throw new TypeError("cannot set TLD empty");if(e.match(/[^a-zA-Z0-9-]/)){if(!n||!n.is(e))throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]');o=new RegExp(c(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(o,e)}else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");o=new RegExp(c(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(o,e)}return this.build(!t),this},a.directory=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var n=this._parts.path.length-this.filename().length-1,i=this._parts.path.substring(0,n)||(this._parts.hostname?"/":"");return e?o.decodePath(i):i}var r=this._parts.path.length-this.filename().length,a=this._parts.path.substring(0,r),s=new RegExp("^"+c(a));return this.is("relative")||(e||(e="/"),"/"!==e.charAt(0)&&(e="/"+e)),e&&"/"!==e.charAt(e.length-1)&&(e+="/"),e=o.recodePath(e),this._parts.path=this._parts.path.replace(s,e),this.build(!t),this},a.filename=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("string"!=typeof e){if(!this._parts.path||"/"===this._parts.path)return"";var n=this._parts.path.lastIndexOf("/"),i=this._parts.path.substring(n+1);return e?o.decodePathSegment(i):i}var r=!1;"/"===e.charAt(0)&&(e=e.substring(1)),e.match(/\.?\//)&&(r=!0);var a=new RegExp(c(this.filename())+"$");return e=o.recodePath(e),this._parts.path=this._parts.path.replace(a,e),r?this.normalizePath(t):this.build(!t),this},a.suffix=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path||"/"===this._parts.path)return"";var n,i,r=this.filename(),a=r.lastIndexOf(".");return-1===a?"":(n=r.substring(a+1),i=/^[a-z0-9%]+$/i.test(n)?n:"",e?o.decodePathSegment(i):i)}"."===e.charAt(0)&&(e=e.substring(1));var s,l=this.suffix();if(l)s=e?new RegExp(c(l)+"$"):new RegExp(c("."+l)+"$");else{if(!e)return this;this._parts.path+="."+o.recodePath(e)}return s&&(e=o.recodePath(e),this._parts.path=this._parts.path.replace(s,e)),this.build(!t),this},a.segment=function(e,t,n){var i=this._parts.urn?":":"/",r=this.path(),o="/"===r.substring(0,1),a=r.split(i);if(void 0!==e&&"number"!=typeof e&&(n=t,t=e,e=void 0),void 0!==e&&"number"!=typeof e)throw new Error('Bad segment "'+e+'", must be 0-based integer');if(o&&a.shift(),e<0&&(e=Math.max(a.length+e,0)),void 0===t)return void 0===e?a:a[e];if(null===e||void 0===a[e])if(u(t)){a=[];for(var s=0,c=t.length;s<c;s++)(t[s].length||a.length&&a[a.length-1].length)&&(a.length&&!a[a.length-1].length&&a.pop(),a.push(f(t[s])))}else(t||"string"==typeof t)&&(t=f(t),""===a[a.length-1]?a[a.length-1]=t:a.push(t));else t?a[e]=f(t):a.splice(e,1);return o&&a.unshift(""),this.path(a.join(i),n)},a.segmentCoded=function(e,t,n){var i,r,a;if("number"!=typeof e&&(n=t,t=e,e=void 0),void 0===t){if(u(i=this.segment(e,t,n)))for(r=0,a=i.length;r<a;r++)i[r]=o.decode(i[r]);else i=void 0!==i?o.decode(i):void 0;return i}if(u(t))for(r=0,a=t.length;r<a;r++)t[r]=o.encode(t[r]);else t="string"==typeof t||t instanceof String?o.encode(t):t;return this.segment(e,t,n)};var x=a.query;return a.query=function(e,t){if(!0===e)return o.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("function"==typeof e){var n=o.parseQuery(this._parts.query,this._parts.escapeQuerySpace),i=e.call(this,n);return this._parts.query=o.buildQuery(i||n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this}return void 0!==e&&"string"!=typeof e?(this._parts.query=o.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this):x.call(this,e,t)},a.setQuery=function(e,t,n){var i=o.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"==typeof e||e instanceof String)i[e]=void 0!==t?t:null;else{if("object"!=typeof e)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");for(var r in e)s.call(e,r)&&(i[r]=e[r])}return this._parts.query=o.buildQuery(i,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(n=t),this.build(!n),this},a.addQuery=function(e,t,n){var i=o.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return o.addQuery(i,e,void 0===t?null:t),this._parts.query=o.buildQuery(i,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(n=t),this.build(!n),this},a.removeQuery=function(e,t,n){var i=o.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return o.removeQuery(i,e,t),this._parts.query=o.buildQuery(i,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(n=t),this.build(!n),this},a.hasQuery=function(e,t,n){var i=o.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return o.hasQuery(i,e,t,n)},a.setSearch=a.setQuery,a.addSearch=a.addQuery,a.removeSearch=a.removeQuery,a.hasSearch=a.hasQuery,a.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},a.normalizeProtocol=function(e){return"string"==typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!e)),this},a.normalizeHostname=function(n){return this._parts.hostname&&(this.is("IDN")&&e?this._parts.hostname=e.toASCII(this._parts.hostname):this.is("IPv6")&&t&&(this._parts.hostname=t.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!n)),this},a.normalizePort=function(e){return"string"==typeof this._parts.protocol&&this._parts.port===o.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!e)),this},a.normalizePath=function(e){var t,n=this._parts.path;if(!n)return this;if(this._parts.urn)return this._parts.path=o.recodeUrnPath(this._parts.path),this.build(!e),this;if("/"===this._parts.path)return this;var i,r,a="";for("/"!==(n=o.recodePath(n)).charAt(0)&&(t=!0,n="/"+n),"/.."!==n.slice(-3)&&"/."!==n.slice(-2)||(n+="/"),n=n.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),t&&(a=n.substring(1).match(/^(\.\.\/)+/)||"")&&(a=a[0]);-1!==(i=n.search(/\/\.\.(\/|$)/));)0!==i?(-1===(r=n.substring(0,i).lastIndexOf("/"))&&(r=i),n=n.substring(0,r)+n.substring(i+3)):n=n.substring(3);return t&&this.is("relative")&&(n=a+n.substring(1)),this._parts.path=n,this.build(!e),this},a.normalizePathname=a.normalizePath,a.normalizeQuery=function(e){return"string"==typeof this._parts.query&&(this._parts.query.length?this.query(o.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!e)),this},a.normalizeFragment=function(e){return this._parts.fragment||(this._parts.fragment=null,this.build(!e)),this},a.normalizeSearch=a.normalizeQuery,a.normalizeHash=a.normalizeFragment,a.iso8859=function(){var e=o.encode,t=o.decode;o.encode=escape,o.decode=decodeURIComponent;try{this.normalize()}finally{o.encode=e,o.decode=t}return this},a.unicode=function(){var e=o.encode,t=o.decode;o.encode=g,o.decode=unescape;try{this.normalize()}finally{o.encode=e,o.decode=t}return this},a.readable=function(){var t=this.clone();t.username("").password("").normalize();var n="";if(t._parts.protocol&&(n+=t._parts.protocol+"://"),t._parts.hostname&&(t.is("punycode")&&e?(n+=e.toUnicode(t._parts.hostname),t._parts.port&&(n+=":"+t._parts.port)):n+=t.host()),t._parts.hostname&&t._parts.path&&"/"!==t._parts.path.charAt(0)&&(n+="/"),n+=t.path(!0),t._parts.query){for(var i="",r=0,a=t._parts.query.split("&"),s=a.length;r<s;r++){var c=(a[r]||"").split("=");i+="&"+o.decodeQuery(c[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),void 0!==c[1]&&(i+="="+o.decodeQuery(c[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}n+="?"+i.substring(1)}return n+=o.decodeQuery(t.hash(),!0)},a.absoluteTo=function(e){var t,n,i,r=this.clone(),a=["protocol","username","password","hostname","port"];if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e instanceof o||(e=new o(e)),r._parts.protocol)return r;if(r._parts.protocol=e._parts.protocol,this._parts.hostname)return r;for(n=0;i=a[n];n++)r._parts[i]=e._parts[i];return r._parts.path?(".."===r._parts.path.substring(-2)&&(r._parts.path+="/"),"/"!==r.path().charAt(0)&&(t=(t=e.directory())||(0===e.path().indexOf("/")?"/":""),r._parts.path=(t?t+"/":"")+r._parts.path,r.normalizePath())):(r._parts.path=e._parts.path,r._parts.query||(r._parts.query=e._parts.query)),r.build(),r},a.relativeTo=function(e){var t,n,i,r,a,s=this.clone().normalize();if(s._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e=new o(e).normalize(),t=s._parts,n=e._parts,r=s.path(),a=e.path(),"/"!==r.charAt(0))throw new Error("URI is already relative");if("/"!==a.charAt(0))throw new Error("Cannot calculate a URI relative to another relative URI");if(t.protocol===n.protocol&&(t.protocol=null),t.username!==n.username||t.password!==n.password)return s.build();if(null!==t.protocol||null!==t.username||null!==t.password)return s.build();if(t.hostname!==n.hostname||t.port!==n.port)return s.build();if(t.hostname=null,t.port=null,r===a)return t.path="",s.build();if(!(i=o.commonPath(r,a)))return s.build();var c=n.path.substring(i.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return t.path=c+t.path.substring(i.length)||"./",s.build()},a.equals=function(e){var t,n,i,r,a,c=this.clone(),l=new o(e),d={};if(c.normalize(),l.normalize(),c.toString()===l.toString())return!0;if(i=c.query(),r=l.query(),c.query(""),l.query(""),c.toString()!==l.toString())return!1;if(i.length!==r.length)return!1;for(a in t=o.parseQuery(i,this._parts.escapeQuerySpace),n=o.parseQuery(r,this._parts.escapeQuerySpace),t)if(s.call(t,a)){if(u(t[a])){if(!p(t[a],n[a]))return!1}else if(t[a]!==n[a])return!1;d[a]=!0}for(a in n)if(s.call(n,a)&&!d[a])return!1;return!0},a.preventInvalidHostname=function(e){return this._parts.preventInvalidHostname=!!e,this},a.duplicateQueryParameters=function(e){return this._parts.duplicateQueryParameters=!!e,this},a.escapeQuerySpace=function(e){return this._parts.escapeQuerySpace=!!e,this},o},e.exports?e.exports=n(punycode,IPv6,SecondLevelDomains):t.URI=n(t.punycode,t.IPv6,t.SecondLevelDomains,t)}));function getAbsoluteUri(e,t){let n;return"undefined"!=typeof document&&(n=document),getAbsoluteUri._implementation(e,t,n)}getAbsoluteUri._implementation=function(e,t,n){if(!defined(t)){if(void 0===n)return e;t=defaultValue(n.baseURI,n.location.href)}const i=new URI(e);return""!==i.scheme()?i.toString():i.absoluteTo(t).toString()};var when=createCommonjsModule((function(e,t){
/** @license MIT License (c) copyright B Cavalier & J Hann */
var n;n=function(){var e,t,n;function i(e,t,n,i){return r(e).then(t,n,i)}function r(e){var t,n;return e instanceof o?t=e:c(e)?(n=s(),e.then((function(e){n.resolve(e)}),(function(e){n.reject(e)}),(function(e){n.progress(e)})),t=n.promise):t=function(e){var t=new o((function(t){try{return r(t?t(e):e)}catch(e){return a(e)}}));return t}(e),t}function o(e){this.then=e}function a(e){var t=new o((function(t,n){try{return n?r(n(e)):a(e)}catch(e){return a(e)}}));return t}function s(){var e,t,i,c,l,u;return e=new o(d),t=[],i=[],c=function(e,n,r){var o,a;return o=s(),a="function"==typeof r?function(e){try{o.progress(r(e))}catch(e){o.progress(e)}}:function(e){o.progress(e)},t.push((function(t){t.then(e,n).then(o.resolve,o.reject,a)})),i.push(a),o.promise},l=function(e){return h(i,e),e},u=function(e){return e=r(e),c=e.then,u=r,l=f,h(t,e),i=t=n,e},{then:d,resolve:p,reject:m,progress:g,promise:e,resolver:{resolve:p,reject:m,progress:g}};function d(e,t,n){return c(e,t,n)}function p(e){return u(e)}function m(e){return u(a(e))}function g(e){return l(e)}}function c(e){return e&&"function"==typeof e.then}function l(e,t,n,r,o){return p(2,arguments),i(e,(function(e){var a,c,l,u,d,h,p,m,g,_;if(g=e.length>>>0,a=Math.max(0,Math.min(t,g)),l=[],c=g-a+1,u=[],d=s(),a)for(m=d.progress,p=function(e){u.push(e),--c||(h=p=f,d.reject(u))},h=function(e){l.push(e),--a||(h=p=f,d.resolve(l))},_=0;_<g;++_)_ in e&&i(e[_],C,y,m);else d.resolve(l);return d.then(n,r,o);function y(e){p(e)}function C(e){h(e)}}))}function u(e,t,n,i){return p(1,arguments),d(e,m).then(t,n,i)}function d(e,t){return i(e,(function(e){var n,r,o,a,c,l;if(o=r=e.length>>>0,n=[],l=s(),o)for(a=function(e,r){i(e,t).then((function(e){n[r]=e,--o||l.resolve(n)}),l.reject)},c=0;c<r;c++)c in e?a(e[c],c):--o;else l.resolve(n);return l.promise}))}function h(e,t){for(var n,i=0;n=e[i++];)n(t)}function p(e,t){for(var n,i=t.length;i>e;)if(null!=(n=t[--i])&&"function"!=typeof n)throw new Error("arg "+i+" must be a function")}function f(){}function m(e){return e}return i.defer=s,i.resolve=r,i.reject=function(e){return i(e,a)},i.join=function(){return d(arguments,m)},i.all=u,i.map=d,i.reduce=function(n,r){var o=t.call(arguments,1);return i(n,(function(t){var n;return n=t.length,o[0]=function(e,t,o){return i(e,(function(e){return i(t,(function(t){return r(e,t,o,n)}))}))},e.apply(t,o)}))},i.any=function(e,t,n,i){return l(e,1,(function(e){return t?t(e[0]):e[0]}),n,i)},i.some=l,i.chain=function(e,t,n){var r=arguments.length>2;return i(e,(function(e){return e=r?n:e,t.resolve(e),e}),(function(e){return t.reject(e),a(e)}),t.progress)},i.isPromise=c,o.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(n,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return u(t,(function(t){return e.apply(n,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,n,i,r,o;if(o=0,r=(t=Object(this)).length>>>0,(n=arguments).length<=1)for(;;){if(o in t){i=t[o++];break}if(++o>=r)throw new TypeError}else i=n[1];for(;o<r;++o)o in t&&(i=e(i,t[o],o,t));return i},i},e.exports=n()}));function appendForwardSlash(e){return 0!==e.length&&"/"===e[e.length-1]||(e=`${e}/`),e}function clone$1(e,t){if(null===e||"object"!=typeof e)return e;t=defaultValue(t,!1);const n=new e.constructor;for(const i in e)if(e.hasOwnProperty(i)){let r=e[i];t&&(r=clone$1(r,t)),n[i]=r}return n}function combine$2(e,t,n){n=defaultValue(n,!1);const i={},r=defined(e),o=defined(t);let a,s,c;if(r)for(a in e)e.hasOwnProperty(a)&&(s=e[a],o&&n&&"object"==typeof s&&t.hasOwnProperty(a)?(c=t[a],i[a]="object"==typeof c?combine$2(s,c,n):s):i[a]=s);if(o)for(a in t)t.hasOwnProperty(a)&&!i.hasOwnProperty(a)&&(c=t[a],i[a]=c);return i}function getBaseUri(e,t){let n="";const i=e.lastIndexOf("/");return-1!==i&&(n=e.substring(0,i+1)),t?(0!==(e=new URI(e)).query().length&&(n+=`?${e.query()}`),0!==e.fragment().length&&(n+=`#${e.fragment()}`),n):n}function getExtensionFromUri(e){const t=new URI(e);t.normalize();let n=t.path(),i=n.lastIndexOf("/");return-1!==i&&(n=n.substr(i+1)),i=n.lastIndexOf("."),n=-1===i?"":n.substr(i+1),n}const context2DsByWidthAndHeight={};function getImagePixels(e,t,n){defined(t)||(t=e.width),defined(n)||(n=e.height);let i=context2DsByWidthAndHeight[t];defined(i)||(i={},context2DsByWidthAndHeight[t]=i);let r=i[n];if(!defined(r)){const e=document.createElement("canvas");e.width=t,e.height=n,r=e.getContext("2d"),r.globalCompositeOperation="copy",i[n]=r}return r.drawImage(e,0,0,t,n),r.getImageData(0,0,t,n).data}const blobUriRegex=/^blob:/i;function isBlobUri(e){return blobUriRegex.test(e)}let a$2;function isCrossOriginUrl(e){defined(a$2)||(a$2=document.createElement("a")),a$2.href=window.location.href;const t=a$2.host,n=a$2.protocol;return a$2.href=e,a$2.href=a$2.href,n!==a$2.protocol||t!==a$2.host}const dataUriRegex$2=/^data:/i;function isDataUri(e){return dataUriRegex$2.test(e)}function loadAndExecuteScript(e){const t=when.defer(),n=document.createElement("script");n.async=!0,n.src=e;const i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),t.resolve()},n.onerror=function(e){t.reject(e)},i.appendChild(n),t.promise}function objectToQuery(e){let t="";for(const n in e)if(e.hasOwnProperty(n)){const i=e[n],r=`${encodeURIComponent(n)}=`;if(Array.isArray(i))for(let e=0,n=i.length;e<n;++e)t+=`${r+encodeURIComponent(i[e])}&`;else t+=`${r+encodeURIComponent(i)}&`}return t=t.slice(0,-1),t}function queryToObject(e){const t={};if(""===e)return t;const n=e.replace(/\+/g,"%20").split(/[&;]/);for(let e=0,i=n.length;e<i;++e){const i=n[e].split("="),r=decodeURIComponent(i[0]);let o=i[1];o=defined(o)?decodeURIComponent(o):"";const a=t[r];"string"==typeof a?t[r]=[a,o]:Array.isArray(a)?a.push(o):t[r]=o}return t}const RequestState={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};var RequestState$1=Object.freeze(RequestState);const RequestType={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3};var RequestType$1=Object.freeze(RequestType);function Request(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.throttleByServer,!1),n=defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=defaultValue(e.priority,0),this.throttle=n,this.throttleByServer=t,this.type=defaultValue(e.type,RequestType$1.OTHER),this.serverKey=void 0,this.state=RequestState$1.UNISSUED,this.deferred=void 0,this.cancelled=!1}function parseResponseHeaders(e){const t={};if(!e)return t;const n=e.split("\r\n");for(let e=0;e<n.length;++e){const i=n[e],r=i.indexOf(": ");if(r>0){const e=i.substring(0,r),n=i.substring(r+2);t[e]=n}}return t}function RequestErrorEvent(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=parseResponseHeaders(this.responseHeaders))}function Event(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function compareNumber(e,t){return t-e}function Heap(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function swap$3(e,t,n){const i=e[t];e[t]=e[n],e[n]=i}function sortRequests(e,t){return e.priority-t.priority}Request.prototype.cancel=function(){this.cancelled=!0},Request.prototype.clone=function(e){return defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Request(this)},RequestErrorEvent.prototype.toString=function(){let e="Request has failed.";return defined(this.statusCode)&&(e+=` Status Code: ${this.statusCode}`),e},Object.defineProperties(Event.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Event.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);const n=this;return function(){n.removeEventListener(e,t)}},Event.prototype.removeEventListener=function(e,t){const n=this._listeners,i=this._scopes;let r=-1;for(let o=0;o<n.length;o++)if(n[o]===e&&i[o]===t){r=o;break}return-1!==r&&(this._insideRaiseEvent?(this._toRemove.push(r),n[r]=void 0,i[r]=void 0):(n.splice(r,1),i.splice(r,1)),!0)},Event.prototype.raiseEvent=function(){let e;this._insideRaiseEvent=!0;const t=this._listeners,n=this._scopes;let i=t.length;for(e=0;e<i;e++){defined(t[e])&&t[e].apply(n[e],arguments)}const r=this._toRemove;if(i=r.length,i>0){for(r.sort(compareNumber),e=0;e<i;e++){const i=r[e];t.splice(i,1),n.splice(i,1)}r.length=0}this._insideRaiseEvent=!1},Object.defineProperties(Heap.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){const t=this._length;if(e<t){const n=this._array;for(let i=e;i<t;++i)n[i]=void 0;this._length=e,n.length=e}this._maximumLength=e}},comparator:{get:function(){return this._comparator}}}),Heap.prototype.reserve=function(e){e=defaultValue(e,this._length),this._array.length=e},Heap.prototype.heapify=function(e){e=defaultValue(e,0);const t=this._length,n=this._comparator,i=this._array;let r=-1,o=!0;for(;o;){const a=2*(e+1),s=a-1;r=s<t&&n(i[s],i[e])<0?s:e,a<t&&n(i[a],i[r])<0&&(r=a),r!==e?(swap$3(i,r,e),e=r):o=!1}},Heap.prototype.resort=function(){const e=this._length;for(let t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},Heap.prototype.insert=function(e){const t=this._array,n=this._comparator,i=this._maximumLength;let r,o=this._length++;for(o<t.length?t[o]=e:t.push(e);0!==o;){const e=Math.floor((o-1)/2);if(!(n(t[o],t[e])<0))break;swap$3(t,o,e),o=e}return defined(i)&&this._length>i&&(r=t[i],this._length=i),r},Heap.prototype.pop=function(e){if(e=defaultValue(e,0),0===this._length)return;const t=this._array,n=t[e];return swap$3(t,e,--this._length),this.heapify(e),t[this._length]=void 0,n};const statistics={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0};let priorityHeapLength=20;const requestHeap=new Heap({comparator:sortRequests});requestHeap.maximumLength=priorityHeapLength,requestHeap.reserve(priorityHeapLength);const activeRequests=[];let numberOfActiveRequestsByServer={};const pageUri="undefined"!=typeof document?new URI(document.location.href):new URI,requestCompletedEvent=new Event;function RequestScheduler(){}function updatePriority(e){defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function issueRequest(e){return e.state===RequestState$1.UNISSUED&&(e.state=RequestState$1.ISSUED,e.deferred=when.defer()),e.deferred.promise}function getRequestReceivedFunction(e){return function(t){if(e.state===RequestState$1.CANCELLED)return;const n=e.deferred;--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.deferred=void 0,n.resolve(t)}}function getRequestFailedFunction(e){return function(t){e.state!==RequestState$1.CANCELLED&&(++statistics.numberOfFailedRequests,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],requestCompletedEvent.raiseEvent(t),e.state=RequestState$1.FAILED,e.deferred.reject(t))}}function startRequest(e){const t=issueRequest(e);return e.state=RequestState$1.ACTIVE,activeRequests.push(e),++statistics.numberOfActiveRequests,++statistics.numberOfActiveRequestsEver,++numberOfActiveRequestsByServer[e.serverKey],e.requestFunction().then(getRequestReceivedFunction(e)).otherwise(getRequestFailedFunction(e)),t}function cancelRequest(e){const t=e.state===RequestState$1.ACTIVE;if(e.state=RequestState$1.CANCELLED,++statistics.numberOfCancelledRequests,defined(e.deferred)){const t=e.deferred;e.deferred=void 0,t.reject()}t&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],++statistics.numberOfCancelledActiveRequests),defined(e.cancelFunction)&&e.cancelFunction()}function updateStatistics(){RequestScheduler.debugShowStatistics&&(0===statistics.numberOfActiveRequests&&statistics.lastNumberOfActiveRequests>0&&(statistics.numberOfAttemptedRequests>0&&(console.log(`Number of attempted requests: ${statistics.numberOfAttemptedRequests}`),statistics.numberOfAttemptedRequests=0),statistics.numberOfCancelledRequests>0&&(console.log(`Number of cancelled requests: ${statistics.numberOfCancelledRequests}`),statistics.numberOfCancelledRequests=0),statistics.numberOfCancelledActiveRequests>0&&(console.log(`Number of cancelled active requests: ${statistics.numberOfCancelledActiveRequests}`),statistics.numberOfCancelledActiveRequests=0),statistics.numberOfFailedRequests>0&&(console.log(`Number of failed requests: ${statistics.numberOfFailedRequests}`),statistics.numberOfFailedRequests=0)),statistics.lastNumberOfActiveRequests=statistics.numberOfActiveRequests)}RequestScheduler.maximumRequests=50,RequestScheduler.maximumRequestsPerServer=6,RequestScheduler.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},RequestScheduler.throttleRequests=!0,RequestScheduler.debugShowStatistics=!1,RequestScheduler.requestCompletedEvent=requestCompletedEvent,Object.defineProperties(RequestScheduler,{statistics:{get:function(){return statistics}},priorityHeapLength:{get:function(){return priorityHeapLength},set:function(e){if(e<priorityHeapLength)for(;requestHeap.length>e;){cancelRequest(requestHeap.pop())}priorityHeapLength=e,requestHeap.maximumLength=e,requestHeap.reserve(e)}}}),RequestScheduler.serverHasOpenSlots=function(e,t){t=defaultValue(t,1);const n=defaultValue(RequestScheduler.requestsByServer[e],RequestScheduler.maximumRequestsPerServer);return numberOfActiveRequestsByServer[e]+t<=n},RequestScheduler.heapHasOpenSlots=function(e){return requestHeap.length+e<=priorityHeapLength},RequestScheduler.update=function(){let e,t,n=0;const i=activeRequests.length;for(e=0;e<i;++e)t=activeRequests[e],t.cancelled&&cancelRequest(t),t.state===RequestState$1.ACTIVE?n>0&&(activeRequests[e-n]=t):++n;activeRequests.length-=n;const r=requestHeap.internalArray,o=requestHeap.length;for(e=0;e<o;++e)updatePriority(r[e]);requestHeap.resort();const a=Math.max(RequestScheduler.maximumRequests-activeRequests.length,0);let s=0;for(;s<a&&requestHeap.length>0;)t=requestHeap.pop(),t.cancelled?cancelRequest(t):!t.throttleByServer||RequestScheduler.serverHasOpenSlots(t.serverKey)?(startRequest(t),++s):cancelRequest(t);updateStatistics()},RequestScheduler.getServerKey=function(e){let t=new URI(e);""===t.scheme()&&(t=new URI(e).absoluteTo(pageUri),t.normalize());let n=t.authority();/:/.test(n)||(n=`${n}:${"https"===t.scheme()?"443":"80"}`);return defined(numberOfActiveRequestsByServer[n])||(numberOfActiveRequestsByServer[n]=0),n},RequestScheduler.request=function(e){if(isDataUri(e.url)||isBlobUri(e.url))return requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.requestFunction();if(++statistics.numberOfAttemptedRequests,defined(e.serverKey)||(e.serverKey=RequestScheduler.getServerKey(e.url)),RequestScheduler.throttleRequests&&e.throttleByServer&&!RequestScheduler.serverHasOpenSlots(e.serverKey))return;if(!RequestScheduler.throttleRequests||!e.throttle)return startRequest(e);if(activeRequests.length>=RequestScheduler.maximumRequests)return;updatePriority(e);const t=requestHeap.insert(e);if(defined(t)){if(t===e)return;cancelRequest(t)}return issueRequest(e)},RequestScheduler.clearForSpecs=function(){for(;requestHeap.length>0;){cancelRequest(requestHeap.pop())}const e=activeRequests.length;for(let t=0;t<e;++t)cancelRequest(activeRequests[t]);activeRequests.length=0,numberOfActiveRequestsByServer={},statistics.numberOfAttemptedRequests=0,statistics.numberOfActiveRequests=0,statistics.numberOfCancelledRequests=0,statistics.numberOfCancelledActiveRequests=0,statistics.numberOfFailedRequests=0,statistics.numberOfActiveRequestsEver=0,statistics.lastNumberOfActiveRequests=0},RequestScheduler.numberOfActiveRequestsByServer=function(e){return numberOfActiveRequestsByServer[e]},RequestScheduler.requestHeap=requestHeap;const TrustedServers={};let _servers={};function getAuthority(e){const t=new URI(e);t.normalize();let n=t.authority();if(0!==n.length){if(t.authority(n),-1!==n.indexOf("@")){const e=n.split("@");n=e[1]}if(-1===n.indexOf(":")){let e=t.scheme();if(0===e.length&&(e=window.location.protocol,e=e.substring(0,e.length-1)),"http"===e)n+=":80";else{if("https"!==e)return;n+=":443"}}return n}}TrustedServers.add=function(e,t){const n=`${e.toLowerCase()}:${t}`;defined(_servers[n])||(_servers[n]=!0)},TrustedServers.remove=function(e,t){const n=`${e.toLowerCase()}:${t}`;defined(_servers[n])&&delete _servers[n]},TrustedServers.contains=function(e){const t=getAuthority(e);return!(!defined(t)||!defined(_servers[t]))},TrustedServers.clear=function(){_servers={}};const xhrBlobSupported=function(){try{const e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function parseQuery(e,t,n,i){const r=e.query();if(0===r.length)return{};let o;if(-1===r.indexOf("=")){const e={};e[r]=void 0,o=e}else o=queryToObject(r);t._queryParameters=n?combineQueryParameters(o,t._queryParameters,i):o,e.search("")}function stringifyQuery(e,t){const n=t._queryParameters,i=Object.keys(n);1!==i.length||defined(n[i[0]])?e.search(objectToQuery(n)):e.search(i[0])}function defaultClone(e,t){return defined(e)?defined(e.clone)?e.clone():clone$1(e):t}function checkAndResetRequest(e){if(e.state===RequestState$1.ISSUED||e.state===RequestState$1.ACTIVE)throw new RuntimeError("The Resource is already being fetched.");e.state=RequestState$1.UNISSUED,e.deferred=void 0}function combineQueryParameters(e,t,n){if(!n)return combine$2(e,t);const i=clone$1(e,!0);for(const e in t)if(t.hasOwnProperty(e)){let n=i[e];const r=t[e];defined(n)?(Array.isArray(n)||(n=i[e]=[n]),i[e]=n.concat(r)):i[e]=Array.isArray(r)?r.slice():r}return i}function Resource(e){"string"==typeof(e=defaultValue(e,defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=defaultClone(e.templateValues,{}),this._queryParameters=defaultClone(e.queryParameters,{}),this.headers=defaultClone(e.headers,{}),this.request=defaultValue(e.request,new Request),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=defaultValue(e.retryAttempts,0),this._retryCount=0;const t=new URI(e.url);parseQuery(t,this,!0,!0),t.fragment(""),this._url=t.toString()}let supportsImageBitmapOptionsPromise;function fetchImage(e){const t=e.resource,n=e.flipY,i=e.skipColorSpaceConversion,r=e.preferImageBitmap,o=t.request;o.url=t.url,o.requestFunction=function(){let e=!1;t.isDataUri||t.isBlobUri||(e=t.isCrossOriginUrl);const a=when.defer();return Resource._Implementations.createImage(o,e,a,n,i,r),a.promise};const a=RequestScheduler.request(o);if(defined(a))return a.otherwise((function(e){return o.state!==RequestState$1.FAILED?when.reject(e):t.retryOnError(e).then((function(a){return a?(o.state=RequestState$1.UNISSUED,o.deferred=void 0,fetchImage({resource:t,flipY:n,skipColorSpaceConversion:i,preferImageBitmap:r})):when.reject(e)}))}))}function fetchJsonp(e,t,n){const i={};i[t]=n,e.setQueryParameters(i);const r=e.request;r.url=e.url,r.requestFunction=function(){const t=when.defer();return window[n]=function(e){t.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},Resource._Implementations.loadAndExecuteScript(e.url,n,t),t.promise};const o=RequestScheduler.request(r);if(defined(o))return o.otherwise((function(i){return r.state!==RequestState$1.FAILED?when.reject(i):e.retryOnError(i).then((function(o){return o?(r.state=RequestState$1.UNISSUED,r.deferred=void 0,fetchJsonp(e,t,n)):when.reject(i)}))}))}Resource.createIfNeeded=function(e){return e instanceof Resource?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new Resource({url:e})},Resource.supportsImageBitmapOptions=function(){if(defined(supportsImageBitmapOptionsPromise))return supportsImageBitmapOptionsPromise;if("function"!=typeof createImageBitmap)return supportsImageBitmapOptionsPromise=when.resolve(!1),supportsImageBitmapOptionsPromise;return supportsImageBitmapOptionsPromise=Resource.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC"}).then((function(e){return when.all([createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none",colorSpaceConversion:"none"}),createImageBitmap(e)])})).then((function(e){const t=getImagePixels(e[0]),n=getImagePixels(e[1]);return t[1]!==n[1]})).otherwise((function(){return!1})),supportsImageBitmapOptionsPromise},Object.defineProperties(Resource,{isBlobSupported:{get:function(){return xhrBlobSupported}}}),Object.defineProperties(Resource.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){const t=new URI(e);parseQuery(t,this,!1),t.fragment(""),this._url=t.toString()}},extension:{get:function(){return getExtensionFromUri(this._url)}},isDataUri:{get:function(){return isDataUri(this._url)}},isBlobUri:{get:function(){return isBlobUri(this._url)}},isCrossOriginUrl:{get:function(){return isCrossOriginUrl(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),Resource.prototype.toString=function(){return this.getUrlComponent(!0,!0)},Resource.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;const n=new URI(this._url);e&&stringifyQuery(n,this);let i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}");const r=this._templateValues;return i=i.replace(/{(.*?)}/g,(function(e,t){const n=r[t];return defined(n)?encodeURIComponent(n):e})),t&&defined(this.proxy)&&(i=this.proxy.getURL(i)),i},Resource.prototype.setQueryParameters=function(e,t){this._queryParameters=t?combineQueryParameters(this._queryParameters,e,!1):combineQueryParameters(e,this._queryParameters,!1)},Resource.prototype.appendQueryParameters=function(e){this._queryParameters=combineQueryParameters(e,this._queryParameters,!0)},Resource.prototype.setTemplateValues=function(e,t){this._templateValues=t?combine$2(this._templateValues,e):combine$2(e,this._templateValues)},Resource.prototype.getDerivedResource=function(e){const t=this.clone();if(t._retryCount=0,defined(e.url)){const n=new URI(e.url);parseQuery(n,t,!0,defaultValue(e.preserveQueryParameters,!1)),n.fragment(""),""!==n.scheme()?t._url=n.toString():t._url=n.absoluteTo(new URI(getAbsoluteUri(this._url))).toString()}return defined(e.queryParameters)&&(t._queryParameters=combine$2(e.queryParameters,t._queryParameters)),defined(e.templateValues)&&(t._templateValues=combine$2(e.templateValues,t.templateValues)),defined(e.headers)&&(t.headers=combine$2(e.headers,t.headers)),defined(e.proxy)&&(t.proxy=e.proxy),defined(e.request)&&(t.request=e.request),defined(e.retryCallback)&&(t.retryCallback=e.retryCallback),defined(e.retryAttempts)&&(t.retryAttempts=e.retryAttempts),t},Resource.prototype.retryOnError=function(e){const t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return when(!1);const n=this;return when(t(this,e)).then((function(e){return++n._retryCount,e}))},Resource.prototype.clone=function(e){return defined(e)||(e=new Resource({url:this._url})),e._url=this._url,e._queryParameters=clone$1(this._queryParameters),e._templateValues=clone$1(this._templateValues),e.headers=clone$1(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},Resource.prototype.getBaseUri=function(e){return getBaseUri(this.getUrlComponent(e),e)},Resource.prototype.appendForwardSlash=function(){this._url=appendForwardSlash(this._url)},Resource.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},Resource.fetchArrayBuffer=function(e){return new Resource(e).fetchArrayBuffer()},Resource.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},Resource.fetchBlob=function(e){return new Resource(e).fetchBlob()},Resource.prototype.fetchImage=function(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.preferImageBitmap,!1),n=defaultValue(e.preferBlob,!1),i=defaultValue(e.flipY,!1),r=defaultValue(e.skipColorSpaceConversion,!1);if(checkAndResetRequest(this.request),!xhrBlobSupported||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return fetchImage({resource:this,flipY:i,skipColorSpaceConversion:r,preferImageBitmap:t});const o=this.fetchBlob();if(!defined(o))return;let a,s,c,l;return Resource.supportsImageBitmapOptions().then((function(e){return a=e,s=a&&t,o})).then((function(e){if(!defined(e))return;if(l=e,s)return Resource.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1,skipColorSpaceConversion:r});const t=window.URL.createObjectURL(e);return c=new Resource({url:t}),fetchImage({resource:c,flipY:i,skipColorSpaceConversion:r,preferImageBitmap:!1})})).then((function(e){if(defined(e))return e.blob=l,s||window.URL.revokeObjectURL(c.url),e})).otherwise((function(e){return defined(c)&&window.URL.revokeObjectURL(c.url),e.blob=l,when.reject(e)}))},Resource.fetchImage=function(e){return new Resource(e).fetchImage({flipY:e.flipY,skipColorSpaceConversion:e.skipColorSpaceConversion,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},Resource.prototype.fetchText=function(){return this.fetch({responseType:"text"})},Resource.fetchText=function(e){return new Resource(e).fetchText()},Resource.prototype.fetchJson=function(){const e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(defined(e))return e.then((function(e){if(defined(e))return JSON.parse(e)}))},Resource.fetchJson=function(e){return new Resource(e).fetchJson()},Resource.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},Resource.fetchXML=function(e){return new Resource(e).fetchXML()},Resource.prototype.fetchJsonp=function(e){let t;e=defaultValue(e,"callback"),checkAndResetRequest(this.request);do{t=`loadJsonp${CesiumMath.nextRandomNumber().toString().substring(2,8)}`}while(defined(window[t]));return fetchJsonp(this,e,t)},Resource.fetchJsonp=function(e){return new Resource(e).fetchJsonp(e.callbackParameterName)},Resource.prototype._makeRequest=function(e){const t=this;checkAndResetRequest(t.request);const n=t.request;n.url=t.url,n.requestFunction=function(){const i=e.responseType,r=combine$2(e.headers,t.headers),o=e.overrideMimeType,a=e.method,s=e.data,c=when.defer(),l=Resource._Implementations.loadWithXhr(t.url,i,a,s,r,c,o);return defined(l)&&defined(l.abort)&&(n.cancelFunction=function(){l.abort()}),c.promise};const i=RequestScheduler.request(n);if(defined(i))return i.then((function(e){return n.cancelFunction=void 0,e})).otherwise((function(i){return n.cancelFunction=void 0,n.state!==RequestState$1.FAILED?when.reject(i):t.retryOnError(i).then((function(r){return r?(n.state=RequestState$1.UNISSUED,n.deferred=void 0,t.fetch(e)):when.reject(i)}))}))};const dataUriRegex$1=/^data:(.*?)(;base64)?,(.*)$/;function decodeDataUriText(e,t){const n=decodeURIComponent(t);return e?atob(n):n}function decodeDataUriArrayBuffer(e,t){const n=decodeDataUriText(e,t),i=new ArrayBuffer(n.length),r=new Uint8Array(i);for(let e=0;e<n.length;e++)r[e]=n.charCodeAt(e);return i}function decodeDataUri(e,t){t=defaultValue(t,"");const n=e[1],i=!!e[2],r=e[3];let o,a;switch(t){case"":case"text":return decodeDataUriText(i,r);case"arraybuffer":return decodeDataUriArrayBuffer(i,r);case"blob":return o=decodeDataUriArrayBuffer(i,r),new Blob([o],{type:n});case"document":return a=new DOMParser,a.parseFromString(decodeDataUriText(i,r),n);case"json":return JSON.parse(decodeDataUriText(i,r))}}function loadImageElement(e,t,n){const i=new Image;i.onload=function(){n.resolve(i)},i.onerror=function(e){n.reject(e)},t&&(TrustedServers.contains(e)?i.crossOrigin="use-credentials":i.crossOrigin=""),i.src=e}function decodeResponse(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function loadWithHttpRequest(e,t,n,i,r,o,a){const s=require("url").parse(e),c="https:"===s.protocol?require("https"):require("http"),l=require("zlib"),u={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:n,headers:r};c.request(u).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)return void o.reject(new RequestErrorEvent(e.statusCode,e,e.headers));const n=[];e.on("data",(function(e){n.push(e)})),e.on("end",(function(){const i=Buffer.concat(n);"gzip"===e.headers["content-encoding"]?l.gunzip(i,(function(e,n){e?o.reject(new RuntimeError("Error decompressing response.")):o.resolve(decodeResponse(n,t))})):o.resolve(decodeResponse(i,t))}))})).on("error",(function(e){o.reject(new RequestErrorEvent)})).end()}Resource.prototype.fetch=function(e){return(e=defaultClone(e,{})).method="GET",this._makeRequest(e)},Resource.fetch=function(e){return new Resource(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.delete=function(e){return(e=defaultClone(e,{})).method="DELETE",this._makeRequest(e)},Resource.delete=function(e){return new Resource(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},Resource.prototype.head=function(e){return(e=defaultClone(e,{})).method="HEAD",this._makeRequest(e)},Resource.head=function(e){return new Resource(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.options=function(e){return(e=defaultClone(e,{})).method="OPTIONS",this._makeRequest(e)},Resource.options=function(e){return new Resource(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.post=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="POST",t.data=e,this._makeRequest(t)},Resource.post=function(e){return new Resource(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.put=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PUT",t.data=e,this._makeRequest(t)},Resource.put=function(e){return new Resource(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.patch=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},Resource.patch=function(e){return new Resource(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource._Implementations={},Resource._Implementations.createImage=function(e,t,n,i,r,o){const a=e.url;Resource.supportsImageBitmapOptions().then((function(s){if(!s||!o)return void loadImageElement(a,t,n);const c=when.defer(),l=Resource._Implementations.loadWithXhr(a,"blob","GET",void 0,void 0,c,void 0,void 0,void 0);return defined(l)&&defined(l.abort)&&(e.cancelFunction=function(){l.abort()}),c.promise.then((function(e){if(defined(e))return Resource.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1,skipColorSpaceConversion:r});n.reject(new RuntimeError(`Successfully retrieved ${a} but it contained no content.`))})).then(n.resolve)})).otherwise(n.reject)},Resource.createImageBitmapFromBlob=function(e,t){return Check.defined("options",t),Check.typeOf.bool("options.flipY",t.flipY),Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),Check.typeOf.bool("options.skipColorSpaceConversion",t.skipColorSpaceConversion),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none",colorSpaceConversion:t.skipColorSpaceConversion?"none":"default"})};const noXMLHttpRequest="undefined"==typeof XMLHttpRequest;Resource._Implementations.loadWithXhr=function(e,t,n,i,r,o,a){const s=dataUriRegex$1.exec(e);if(null!==s)return void o.resolve(decodeDataUri(s,t));if(noXMLHttpRequest)return void loadWithHttpRequest(e,t,n,i,r,o);const c=new XMLHttpRequest;if(TrustedServers.contains(e)&&(c.withCredentials=!0),c.open(n,e,!0),defined(a)&&defined(c.overrideMimeType)&&c.overrideMimeType(a),defined(r))for(const e in r)r.hasOwnProperty(e)&&c.setRequestHeader(e,r[e]);defined(t)&&(c.responseType=t);let l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void o.reject(new RequestErrorEvent(c.status,c.response,c.getAllResponseHeaders()));const e=c.response,i=c.responseType;if("HEAD"===n||"OPTIONS"===n){const e=c.getAllResponseHeaders().trim().split(/[\r\n]+/),t={};return e.forEach((function(e){const n=e.split(": "),i=n.shift();t[i]=n.join(": ")})),void o.resolve(t)}if(204===c.status)o.resolve();else if(!defined(e)||defined(t)&&i!==t)if("json"===t&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===i||"document"===i)&&defined(c.responseXML)&&c.responseXML.hasChildNodes()?o.resolve(c.responseXML):""!==i&&"text"!==i||!defined(c.responseText)?o.reject(new RuntimeError("Invalid XMLHttpRequest response type.")):o.resolve(c.responseText);else o.resolve(e)},c.onerror=function(e){o.reject(new RequestErrorEvent)},c.send(i),c},Resource._Implementations.loadAndExecuteScript=function(e,t,n){return loadAndExecuteScript(e).otherwise(n.reject)},Resource._DefaultImplementations={},Resource._DefaultImplementations.createImage=Resource._Implementations.createImage,Resource._DefaultImplementations.loadWithXhr=Resource._Implementations.loadWithXhr,Resource._DefaultImplementations.loadAndExecuteScript=Resource._Implementations.loadAndExecuteScript,Resource.DEFAULT=Object.freeze(new Resource({url:"undefined"==typeof document?"":document.location.href.split("?")[0]}));const cesiumScriptRegex=/((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/;function getBaseUrlFromCesiumScript(){const e=document.getElementsByTagName("script");for(let t=0,n=e.length;t<n;++t){const n=e[t].getAttribute("src"),i=cesiumScriptRegex.exec(n);if(null!==i)return i[1]}}let a$1,baseResource,implementation$2;function tryMakeAbsolute(e){return"undefined"==typeof document?e:(defined(a$1)||(a$1=document.createElement("a")),a$1.href=e,a$1.href=a$1.href,a$1.href)}function getCesiumBaseUrl(){if(defined(baseResource))return baseResource;let e;return e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?getAbsoluteUri("..",buildModuleUrl("Core/buildModuleUrl.js")):getBaseUrlFromCesiumScript(),baseResource=new Resource({url:tryMakeAbsolute(e)}),baseResource.appendForwardSlash(),baseResource}function buildModuleUrlFromRequireToUrl(e){return tryMakeAbsolute(require.toUrl(`../${e}`))}function buildModuleUrlFromBaseUrl(e){return getCesiumBaseUrl().getDerivedResource({url:e}).url}function buildModuleUrl(e){defined(implementation$2)||(implementation$2="object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?buildModuleUrlFromRequireToUrl:buildModuleUrlFromBaseUrl);return implementation$2(e)}function Cartesian2(e,t){this.x=defaultValue(e,0),this.y=defaultValue(t,0)}buildModuleUrl._cesiumScriptRegex=cesiumScriptRegex,buildModuleUrl._buildModuleUrlFromBaseUrl=buildModuleUrlFromBaseUrl,buildModuleUrl._clearBaseResource=function(){baseResource=void 0},buildModuleUrl.setBaseUrl=function(e){baseResource=Resource.DEFAULT.getDerivedResource({url:e})},buildModuleUrl.getCesiumBaseUrl=getCesiumBaseUrl,Cartesian2.fromElements=function(e,t,n){return defined(n)?(n.x=e,n.y=t,n):new Cartesian2(e,t)},Cartesian2.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t):new Cartesian2(e.x,e.y)},Cartesian2.fromCartesian3=Cartesian2.clone,Cartesian2.fromCartesian4=Cartesian2.clone,Cartesian2.packedLength=2,Cartesian2.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.x,t[n]=e.y,t},Cartesian2.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Cartesian2),n.x=e[t++],n.y=e[t],n},Cartesian2.packArray=function(e,t){const n=e.length,i=2*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Cartesian2.pack(e[i],t,2*i);return t},Cartesian2.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/2:t=new Array(n/2);for(let i=0;i<n;i+=2){const n=i/2;t[n]=Cartesian2.unpack(e,i,t[n])}return t},Cartesian2.fromArray=Cartesian2.unpack,Cartesian2.maximumComponent=function(e){return Math.max(e.x,e.y)},Cartesian2.minimumComponent=function(e){return Math.min(e.x,e.y)},Cartesian2.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},Cartesian2.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},Cartesian2.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},Cartesian2.magnitude=function(e){return Math.sqrt(Cartesian2.magnitudeSquared(e))};const distanceScratch$1=new Cartesian2;Cartesian2.distance=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitude(distanceScratch$1)},Cartesian2.distanceSquared=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitudeSquared(distanceScratch$1)},Cartesian2.normalize=function(e,t){const n=Cartesian2.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},Cartesian2.dot=function(e,t){return e.x*t.x+e.y*t.y},Cartesian2.cross=function(e,t){return e.x*t.y-e.y*t.x},Cartesian2.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},Cartesian2.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n},Cartesian2.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},Cartesian2.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},Cartesian2.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},Cartesian2.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},Cartesian2.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},Cartesian2.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};const lerpScratch$1=new Cartesian2;Cartesian2.lerp=function(e,t,n,i){return Cartesian2.multiplyByScalar(t,n,lerpScratch$1),i=Cartesian2.multiplyByScalar(e,1-n,i),Cartesian2.add(lerpScratch$1,i,i)};const angleBetweenScratch=new Cartesian2,angleBetweenScratch2=new Cartesian2;Cartesian2.angleBetween=function(e,t){return Cartesian2.normalize(e,angleBetweenScratch),Cartesian2.normalize(t,angleBetweenScratch2),CesiumMath.acosClamped(Cartesian2.dot(angleBetweenScratch,angleBetweenScratch2))};const mostOrthogonalAxisScratch=new Cartesian2;function GeographicTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._rectangle=defaultValue(e.rectangle,Rectangle.MAX_VALUE),this._projection=new GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1)}Cartesian2.mostOrthogonalAxis=function(e,t){const n=Cartesian2.normalize(e,mostOrthogonalAxisScratch);return Cartesian2.abs(n,n),t=n.x<=n.y?Cartesian2.clone(Cartesian2.UNIT_X,t):Cartesian2.clone(Cartesian2.UNIT_Y,t)},Cartesian2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y},Cartesian2.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},Cartesian2.equalsEpsilon=function(e,t,n,i){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,n,i)&&CesiumMath.equalsEpsilon(e.y,t.y,n,i)},Cartesian2.ZERO=Object.freeze(new Cartesian2(0,0)),Cartesian2.ONE=Object.freeze(new Cartesian2(1,1)),Cartesian2.UNIT_X=Object.freeze(new Cartesian2(1,0)),Cartesian2.UNIT_Y=Object.freeze(new Cartesian2(0,1)),Cartesian2.prototype.clone=function(e){return Cartesian2.clone(this,e)},Cartesian2.prototype.equals=function(e){return Cartesian2.equals(this,e)},Cartesian2.prototype.equalsEpsilon=function(e,t,n){return Cartesian2.equalsEpsilon(this,e,t,n)},Cartesian2.prototype.toString=function(){return`(${this.x}, ${this.y})`},Object.defineProperties(GeographicTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},GeographicTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){const n=CesiumMath.toDegrees(e.west),i=CesiumMath.toDegrees(e.south),r=CesiumMath.toDegrees(e.east),o=CesiumMath.toDegrees(e.north);return defined(t)?(t.west=n,t.south=i,t.east=r,t.north=o,t):new Rectangle(n,i,r,o)},GeographicTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,n,i){const r=this.tileXYToRectangle(e,t,n,i);return r.west=CesiumMath.toDegrees(r.west),r.south=CesiumMath.toDegrees(r.south),r.east=CesiumMath.toDegrees(r.east),r.north=CesiumMath.toDegrees(r.north),r},GeographicTilingScheme.prototype.tileXYToRectangle=function(e,t,n,i){const r=this._rectangle,o=this.getNumberOfXTilesAtLevel(n),a=this.getNumberOfYTilesAtLevel(n),s=r.width/o,c=e*s+r.west,l=(e+1)*s+r.west,u=r.height/a,d=r.north-t*u,h=r.north-(t+1)*u;return defined(i)||(i=new Rectangle(c,h,l,d)),i.west=c,i.south=h,i.east=l,i.north=d,i},GeographicTilingScheme.prototype.positionToTileXY=function(e,t,n){const i=this._rectangle;if(!Rectangle.contains(i,e))return;const r=this.getNumberOfXTilesAtLevel(t),o=this.getNumberOfYTilesAtLevel(t),a=i.width/r,s=i.height/o;let c=e.longitude;i.east<i.west&&(c+=CesiumMath.TWO_PI);let l=(c-i.west)/a|0;l>=r&&(l=r-1);let u=(i.north-e.latitude)/s|0;return u>=o&&(u=o-1),defined(n)?(n.x=l,n.y=u,n):new Cartesian2(l,u)};const scratchDiagonalCartesianNE=new Cartesian3,scratchDiagonalCartesianSW=new Cartesian3,scratchDiagonalCartographic=new Cartographic,scratchCenterCartesian=new Cartesian3,scratchSurfaceCartesian=new Cartesian3,scratchBoundingSphere$4=new BoundingSphere,tilingScheme=new GeographicTilingScheme,scratchCorners=[new Cartographic,new Cartographic,new Cartographic,new Cartographic],scratchTileXY=new Cartesian2,ApproximateTerrainHeights={};function getTileXYLevel(e){Cartographic.fromRadians(e.east,e.north,0,scratchCorners[0]),Cartographic.fromRadians(e.west,e.north,0,scratchCorners[1]),Cartographic.fromRadians(e.east,e.south,0,scratchCorners[2]),Cartographic.fromRadians(e.west,e.south,0,scratchCorners[3]);let t=0,n=0,i=0,r=0;const o=ApproximateTerrainHeights._terrainHeightsMaxLevel;let a;for(a=0;a<=o;++a){let e=!1;for(let t=0;t<4;++t){const n=scratchCorners[t];if(tilingScheme.positionToTileXY(n,a,scratchTileXY),0===t)i=scratchTileXY.x,r=scratchTileXY.y;else if(i!==scratchTileXY.x||r!==scratchTileXY.y){e=!0;break}}if(e)break;t=i,n=r}if(0!==a)return{x:t,y:n,level:a>o?o:a-1}}
/*! @license DOMPurify 2.3.6 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.3.6/LICENSE */
function _toConsumableArray(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t];return n}return Array.from(e)}ApproximateTerrainHeights.initialize=function(){let e=ApproximateTerrainHeights._initPromise;return defined(e)||(e=Resource.fetchJson(buildModuleUrl("Assets/approximateTerrainHeights.json")).then((function(e){ApproximateTerrainHeights._terrainHeights=e})),ApproximateTerrainHeights._initPromise=e),e},ApproximateTerrainHeights.getMinimumMaximumHeights=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);const n=getTileXYLevel(e);let i=ApproximateTerrainHeights._defaultMinTerrainHeight,r=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(n)){const o=`${n.level}-${n.x}-${n.y}`,a=ApproximateTerrainHeights._terrainHeights[o];defined(a)&&(i=a[0],r=a[1]),t.cartographicToCartesian(Rectangle.northeast(e,scratchDiagonalCartographic),scratchDiagonalCartesianNE),t.cartographicToCartesian(Rectangle.southwest(e,scratchDiagonalCartographic),scratchDiagonalCartesianSW),Cartesian3.midpoint(scratchDiagonalCartesianSW,scratchDiagonalCartesianNE,scratchCenterCartesian);const s=t.scaleToGeodeticSurface(scratchCenterCartesian,scratchSurfaceCartesian);if(defined(s)){const e=Cartesian3.distance(scratchCenterCartesian,s);i=Math.min(i,-e)}else i=ApproximateTerrainHeights._defaultMinTerrainHeight}return i=Math.max(ApproximateTerrainHeights._defaultMinTerrainHeight,i),{minimumTerrainHeight:i,maximumTerrainHeight:r}},ApproximateTerrainHeights.getBoundingSphere=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);const n=getTileXYLevel(e);let i=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(n)){const e=`${n.level}-${n.x}-${n.y}`,t=ApproximateTerrainHeights._terrainHeights[e];defined(t)&&(i=t[1])}const r=BoundingSphere.fromRectangle3D(e,t,0);return BoundingSphere.fromRectangle3D(e,t,i,scratchBoundingSphere$4),BoundingSphere.union(r,scratchBoundingSphere$4,r)},ApproximateTerrainHeights._terrainHeightsMaxLevel=6,ApproximateTerrainHeights._defaultMaxTerrainHeight=9e3,ApproximateTerrainHeights._defaultMinTerrainHeight=-1e5,ApproximateTerrainHeights._terrainHeights=void 0,ApproximateTerrainHeights._initPromise=void 0,Object.defineProperties(ApproximateTerrainHeights,{initialized:{get:function(){return defined(ApproximateTerrainHeights._terrainHeights)}}});var hasOwnProperty=Object.hasOwnProperty,setPrototypeOf=Object.setPrototypeOf,isFrozen=Object.isFrozen,getPrototypeOf=Object.getPrototypeOf,getOwnPropertyDescriptor=Object.getOwnPropertyDescriptor,freeze=Object.freeze,seal=Object.seal,create=Object.create,_ref="undefined"!=typeof Reflect&&Reflect,apply=_ref.apply,construct=_ref.construct;apply||(apply=function(e,t,n){return e.apply(t,n)}),freeze||(freeze=function(e){return e}),seal||(seal=function(e){return e}),construct||(construct=function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(_toConsumableArray(t))))});var arrayForEach=unapply(Array.prototype.forEach),arrayPop=unapply(Array.prototype.pop),arrayPush=unapply(Array.prototype.push),stringToLowerCase=unapply(String.prototype.toLowerCase),stringMatch=unapply(String.prototype.match),stringReplace=unapply(String.prototype.replace),stringIndexOf=unapply(String.prototype.indexOf),stringTrim=unapply(String.prototype.trim),regExpTest=unapply(RegExp.prototype.test),typeErrorCreate=unconstruct(TypeError);function unapply(e){return function(t){for(var n=arguments.length,i=Array(n>1?n-1:0),r=1;r<n;r++)i[r-1]=arguments[r];return apply(e,t,i)}}function unconstruct(e){return function(){for(var t=arguments.length,n=Array(t),i=0;i<t;i++)n[i]=arguments[i];return construct(e,n)}}function addToSet(e,t){setPrototypeOf&&setPrototypeOf(e,null);for(var n=t.length;n--;){var i=t[n];if("string"==typeof i){var r=stringToLowerCase(i);r!==i&&(isFrozen(t)||(t[n]=r),i=r)}e[i]=!0}return e}function clone(e){var t=create(null),n=void 0;for(n in e)apply(hasOwnProperty,e,[n])&&(t[n]=e[n]);return t}function lookupGetter(e,t){for(;null!==e;){var n=getOwnPropertyDescriptor(e,t);if(n){if(n.get)return unapply(n.get);if("function"==typeof n.value)return unapply(n.value)}e=getPrototypeOf(e)}return function(e){return console.warn("fallback value for",e),null}}var html=freeze(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),svg=freeze(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),svgFilters=freeze(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),svgDisallowed=freeze(["animate","color-profile","cursor","discard","fedropshadow","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),mathMl=freeze(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),mathMlDisallowed=freeze(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),text=freeze(["#text"]),html$1=freeze(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),svg$1=freeze(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),mathMl$1=freeze(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),xml=freeze(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),MUSTACHE_EXPR=seal(/\{\{[\s\S]*|[\s\S]*\}\}/gm),ERB_EXPR=seal(/<%[\s\S]*|[\s\S]*%>/gm),DATA_ATTR=seal(/^data-[\-\w.\u00B7-\uFFFF]/),ARIA_ATTR=seal(/^aria-[\-\w]+$/),IS_ALLOWED_URI=seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),IS_SCRIPT_OR_DATA=seal(/^(?:\w+script|data):/i),ATTR_WHITESPACE=seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),DOCTYPE_NAME=seal(/^html$/i),_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function _toConsumableArray$1(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t];return n}return Array.from(e)}var getGlobal=function(){return"undefined"==typeof window?null:window},_createTrustedTypesPolicy=function(e,t){if("object"!==(void 0===e?"undefined":_typeof(e))||"function"!=typeof e.createPolicy)return null;var n=null,i="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(i)&&(n=t.currentScript.getAttribute(i));var r="dompurify"+(n?"#"+n:"");try{return e.createPolicy(r,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+r+" could not be created."),null}};function createDOMPurify(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:getGlobal(),t=function(e){return createDOMPurify(e)};if(t.version="2.3.6",t.removed=[],!e||!e.document||9!==e.document.nodeType)return t.isSupported=!1,t;var n=e.document,i=e.document,r=e.DocumentFragment,o=e.HTMLTemplateElement,a=e.Node,s=e.Element,c=e.NodeFilter,l=e.NamedNodeMap,u=void 0===l?e.NamedNodeMap||e.MozNamedAttrMap:l,d=e.HTMLFormElement,h=e.DOMParser,p=e.trustedTypes,f=s.prototype,m=lookupGetter(f,"cloneNode"),g=lookupGetter(f,"nextSibling"),_=lookupGetter(f,"childNodes"),y=lookupGetter(f,"parentNode");if("function"==typeof o){var C=i.createElement("template");C.content&&C.content.ownerDocument&&(i=C.content.ownerDocument)}var T=_createTrustedTypesPolicy(p,n),S=T?T.createHTML(""):"",A=i,v=A.implementation,E=A.createNodeIterator,b=A.createDocumentFragment,x=A.getElementsByTagName,P=n.importNode,D={};try{D=clone(i).documentMode?i.documentMode:{}}catch(e){}var w={};t.isSupported="function"==typeof y&&v&&void 0!==v.createHTMLDocument&&9!==D;var M=MUSTACHE_EXPR,I=ERB_EXPR,R=DATA_ATTR,O=ARIA_ATTR,B=IS_SCRIPT_OR_DATA,L=ATTR_WHITESPACE,F=IS_ALLOWED_URI,N=null,V=addToSet({},[].concat(_toConsumableArray$1(html),_toConsumableArray$1(svg),_toConsumableArray$1(svgFilters),_toConsumableArray$1(mathMl),_toConsumableArray$1(text))),$=null,k=addToSet({},[].concat(_toConsumableArray$1(html$1),_toConsumableArray$1(svg$1),_toConsumableArray$1(mathMl$1),_toConsumableArray$1(xml))),U=Object.seal(Object.create(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),G=null,z=null,H=!0,W=!0,q=!1,j=!1,X=!1,Y=!1,K=!1,J=!1,Q=!1,Z=!1,ee=!0,te=!0,ne=!1,ie={},re=null,oe=addToSet({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),ae=null,se=addToSet({},["audio","video","img","source","image","track"]),ce=null,le=addToSet({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),ue="http://www.w3.org/1998/Math/MathML",de="http://www.w3.org/2000/svg",he="http://www.w3.org/1999/xhtml",pe=he,fe=!1,me=void 0,ge=["application/xhtml+xml","text/html"],_e="text/html",ye=void 0,Ce=null,Te=i.createElement("form"),Se=function(e){return e instanceof RegExp||e instanceof Function},Ae=function(e){Ce&&Ce===e||(e&&"object"===(void 0===e?"undefined":_typeof(e))||(e={}),e=clone(e),N="ALLOWED_TAGS"in e?addToSet({},e.ALLOWED_TAGS):V,$="ALLOWED_ATTR"in e?addToSet({},e.ALLOWED_ATTR):k,ce="ADD_URI_SAFE_ATTR"in e?addToSet(clone(le),e.ADD_URI_SAFE_ATTR):le,ae="ADD_DATA_URI_TAGS"in e?addToSet(clone(se),e.ADD_DATA_URI_TAGS):se,re="FORBID_CONTENTS"in e?addToSet({},e.FORBID_CONTENTS):oe,G="FORBID_TAGS"in e?addToSet({},e.FORBID_TAGS):{},z="FORBID_ATTR"in e?addToSet({},e.FORBID_ATTR):{},ie="USE_PROFILES"in e&&e.USE_PROFILES,H=!1!==e.ALLOW_ARIA_ATTR,W=!1!==e.ALLOW_DATA_ATTR,q=e.ALLOW_UNKNOWN_PROTOCOLS||!1,j=e.SAFE_FOR_TEMPLATES||!1,X=e.WHOLE_DOCUMENT||!1,J=e.RETURN_DOM||!1,Q=e.RETURN_DOM_FRAGMENT||!1,Z=e.RETURN_TRUSTED_TYPE||!1,K=e.FORCE_BODY||!1,ee=!1!==e.SANITIZE_DOM,te=!1!==e.KEEP_CONTENT,ne=e.IN_PLACE||!1,F=e.ALLOWED_URI_REGEXP||F,pe=e.NAMESPACE||he,e.CUSTOM_ELEMENT_HANDLING&&Se(e.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(U.tagNameCheck=e.CUSTOM_ELEMENT_HANDLING.tagNameCheck),e.CUSTOM_ELEMENT_HANDLING&&Se(e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(U.attributeNameCheck=e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),e.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(U.allowCustomizedBuiltInElements=e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),me=me=-1===ge.indexOf(e.PARSER_MEDIA_TYPE)?_e:e.PARSER_MEDIA_TYPE,ye="application/xhtml+xml"===me?function(e){return e}:stringToLowerCase,j&&(W=!1),Q&&(J=!0),ie&&(N=addToSet({},[].concat(_toConsumableArray$1(text))),$=[],!0===ie.html&&(addToSet(N,html),addToSet($,html$1)),!0===ie.svg&&(addToSet(N,svg),addToSet($,svg$1),addToSet($,xml)),!0===ie.svgFilters&&(addToSet(N,svgFilters),addToSet($,svg$1),addToSet($,xml)),!0===ie.mathMl&&(addToSet(N,mathMl),addToSet($,mathMl$1),addToSet($,xml))),e.ADD_TAGS&&(N===V&&(N=clone(N)),addToSet(N,e.ADD_TAGS)),e.ADD_ATTR&&($===k&&($=clone($)),addToSet($,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&addToSet(ce,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&(re===oe&&(re=clone(re)),addToSet(re,e.FORBID_CONTENTS)),te&&(N["#text"]=!0),X&&addToSet(N,["html","head","body"]),N.table&&(addToSet(N,["tbody"]),delete G.tbody),freeze&&freeze(e),Ce=e)},ve=addToSet({},["mi","mo","mn","ms","mtext"]),Ee=addToSet({},["foreignobject","desc","title","annotation-xml"]),be=addToSet({},svg);addToSet(be,svgFilters),addToSet(be,svgDisallowed);var xe=addToSet({},mathMl);addToSet(xe,mathMlDisallowed);var Pe=function(e){var t=y(e);t&&t.tagName||(t={namespaceURI:he,tagName:"template"});var n=stringToLowerCase(e.tagName),i=stringToLowerCase(t.tagName);if(e.namespaceURI===de)return t.namespaceURI===he?"svg"===n:t.namespaceURI===ue?"svg"===n&&("annotation-xml"===i||ve[i]):Boolean(be[n]);if(e.namespaceURI===ue)return t.namespaceURI===he?"math"===n:t.namespaceURI===de?"math"===n&&Ee[i]:Boolean(xe[n]);if(e.namespaceURI===he){if(t.namespaceURI===de&&!Ee[i])return!1;if(t.namespaceURI===ue&&!ve[i])return!1;var r=addToSet({},["title","style","font","a","script"]);return!xe[n]&&(r[n]||!be[n])}return!1},De=function(e){arrayPush(t.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=S}catch(t){e.remove()}}},we=function(e,n){try{arrayPush(t.removed,{attribute:n.getAttributeNode(e),from:n})}catch(e){arrayPush(t.removed,{attribute:null,from:n})}if(n.removeAttribute(e),"is"===e&&!$[e])if(J||Q)try{De(n)}catch(e){}else try{n.setAttribute(e,"")}catch(e){}},Me=function(e){var t=void 0,n=void 0;if(K)e="<remove></remove>"+e;else{var r=stringMatch(e,/^[\r\n\t ]+/);n=r&&r[0]}"application/xhtml+xml"===me&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");var o=T?T.createHTML(e):e;if(pe===he)try{t=(new h).parseFromString(o,me)}catch(e){}if(!t||!t.documentElement){t=v.createDocument(pe,"template",null);try{t.documentElement.innerHTML=fe?"":o}catch(e){}}var a=t.body||t.documentElement;return e&&n&&a.insertBefore(i.createTextNode(n),a.childNodes[0]||null),pe===he?x.call(t,X?"html":"body")[0]:X?t.documentElement:a},Ie=function(e){return E.call(e.ownerDocument||e,e,c.SHOW_ELEMENT|c.SHOW_COMMENT|c.SHOW_TEXT,null,!1)},Re=function(e){return e instanceof d&&("string"!=typeof e.nodeName||"string"!=typeof e.textContent||"function"!=typeof e.removeChild||!(e.attributes instanceof u)||"function"!=typeof e.removeAttribute||"function"!=typeof e.setAttribute||"string"!=typeof e.namespaceURI||"function"!=typeof e.insertBefore)},Oe=function(e){return"object"===(void 0===a?"undefined":_typeof(a))?e instanceof a:e&&"object"===(void 0===e?"undefined":_typeof(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},Be=function(e,n,i){w[e]&&arrayForEach(w[e],(function(e){e.call(t,n,i,Ce)}))},Le=function(e){var n=void 0;if(Be("beforeSanitizeElements",e,null),Re(e))return De(e),!0;if(stringMatch(e.nodeName,/[\u0080-\uFFFF]/))return De(e),!0;var i=ye(e.nodeName);if(Be("uponSanitizeElement",e,{tagName:i,allowedTags:N}),!Oe(e.firstElementChild)&&(!Oe(e.content)||!Oe(e.content.firstElementChild))&&regExpTest(/<[/\w]/g,e.innerHTML)&&regExpTest(/<[/\w]/g,e.textContent))return De(e),!0;if("select"===i&&regExpTest(/<template/i,e.innerHTML))return De(e),!0;if(!N[i]||G[i]){if(!G[i]&&Ne(i)){if(U.tagNameCheck instanceof RegExp&&regExpTest(U.tagNameCheck,i))return!1;if(U.tagNameCheck instanceof Function&&U.tagNameCheck(i))return!1}if(te&&!re[i]){var r=y(e)||e.parentNode,o=_(e)||e.childNodes;if(o&&r)for(var a=o.length-1;a>=0;--a)r.insertBefore(m(o[a],!0),g(e))}return De(e),!0}return e instanceof s&&!Pe(e)?(De(e),!0):"noscript"!==i&&"noembed"!==i||!regExpTest(/<\/no(script|embed)/i,e.innerHTML)?(j&&3===e.nodeType&&(n=e.textContent,n=stringReplace(n,M," "),n=stringReplace(n,I," "),e.textContent!==n&&(arrayPush(t.removed,{element:e.cloneNode()}),e.textContent=n)),Be("afterSanitizeElements",e,null),!1):(De(e),!0)},Fe=function(e,t,n){if(ee&&("id"===t||"name"===t)&&(n in i||n in Te))return!1;if(W&&!z[t]&&regExpTest(R,t));else if(H&&regExpTest(O,t));else if(!$[t]||z[t]){if(!(Ne(e)&&(U.tagNameCheck instanceof RegExp&&regExpTest(U.tagNameCheck,e)||U.tagNameCheck instanceof Function&&U.tagNameCheck(e))&&(U.attributeNameCheck instanceof RegExp&&regExpTest(U.attributeNameCheck,t)||U.attributeNameCheck instanceof Function&&U.attributeNameCheck(t))||"is"===t&&U.allowCustomizedBuiltInElements&&(U.tagNameCheck instanceof RegExp&&regExpTest(U.tagNameCheck,n)||U.tagNameCheck instanceof Function&&U.tagNameCheck(n))))return!1}else if(ce[t]);else if(regExpTest(F,stringReplace(n,L,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==stringIndexOf(n,"data:")||!ae[e]){if(q&&!regExpTest(B,stringReplace(n,L,"")));else if(n)return!1}else;return!0},Ne=function(e){return e.indexOf("-")>0},Ve=function(e){var n=void 0,i=void 0,r=void 0,o=void 0;Be("beforeSanitizeAttributes",e,null);var a=e.attributes;if(a){var s={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:$};for(o=a.length;o--;){var c=n=a[o],l=c.name,u=c.namespaceURI;if(i=stringTrim(n.value),r=ye(l),s.attrName=r,s.attrValue=i,s.keepAttr=!0,s.forceKeepAttr=void 0,Be("uponSanitizeAttribute",e,s),i=s.attrValue,!s.forceKeepAttr&&(we(l,e),s.keepAttr))if(regExpTest(/\/>/i,i))we(l,e);else{j&&(i=stringReplace(i,M," "),i=stringReplace(i,I," "));var d=ye(e.nodeName);if(Fe(d,r,i))try{u?e.setAttributeNS(u,l,i):e.setAttribute(l,i),arrayPop(t.removed)}catch(e){}}}Be("afterSanitizeAttributes",e,null)}},$e=function e(t){var n=void 0,i=Ie(t);for(Be("beforeSanitizeShadowDOM",t,null);n=i.nextNode();)Be("uponSanitizeShadowNode",n,null),Le(n)||(n.content instanceof r&&e(n.content),Ve(n));Be("afterSanitizeShadowDOM",t,null)};return t.sanitize=function(i,o){var s=void 0,c=void 0,l=void 0,u=void 0,d=void 0;if((fe=!i)&&(i="\x3c!--\x3e"),"string"!=typeof i&&!Oe(i)){if("function"!=typeof i.toString)throw typeErrorCreate("toString is not a function");if("string"!=typeof(i=i.toString()))throw typeErrorCreate("dirty is not a string, aborting")}if(!t.isSupported){if("object"===_typeof(e.toStaticHTML)||"function"==typeof e.toStaticHTML){if("string"==typeof i)return e.toStaticHTML(i);if(Oe(i))return e.toStaticHTML(i.outerHTML)}return i}if(Y||Ae(o),t.removed=[],"string"==typeof i&&(ne=!1),ne){if(i.nodeName){var h=ye(i.nodeName);if(!N[h]||G[h])throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place")}}else if(i instanceof a)1===(c=(s=Me("\x3c!----\x3e")).ownerDocument.importNode(i,!0)).nodeType&&"BODY"===c.nodeName||"HTML"===c.nodeName?s=c:s.appendChild(c);else{if(!J&&!j&&!X&&-1===i.indexOf("<"))return T&&Z?T.createHTML(i):i;if(!(s=Me(i)))return J?null:Z?S:""}s&&K&&De(s.firstChild);for(var p=Ie(ne?i:s);l=p.nextNode();)3===l.nodeType&&l===u||Le(l)||(l.content instanceof r&&$e(l.content),Ve(l),u=l);if(u=null,ne)return i;if(J){if(Q)for(d=b.call(s.ownerDocument);s.firstChild;)d.appendChild(s.firstChild);else d=s;return $.shadowroot&&(d=P.call(n,d,!0)),d}var f=X?s.outerHTML:s.innerHTML;return X&&N["!doctype"]&&s.ownerDocument&&s.ownerDocument.doctype&&s.ownerDocument.doctype.name&&regExpTest(DOCTYPE_NAME,s.ownerDocument.doctype.name)&&(f="<!DOCTYPE "+s.ownerDocument.doctype.name+">\n"+f),j&&(f=stringReplace(f,M," "),f=stringReplace(f,I," ")),T&&Z?T.createHTML(f):f},t.setConfig=function(e){Ae(e),Y=!0},t.clearConfig=function(){Ce=null,Y=!1},t.isValidAttribute=function(e,t,n){Ce||Ae({});var i=ye(e),r=ye(t);return Fe(i,r,n)},t.addHook=function(e,t){"function"==typeof t&&(w[e]=w[e]||[],arrayPush(w[e],t))},t.removeHook=function(e){w[e]&&arrayPop(w[e])},t.removeHooks=function(e){w[e]&&(w[e]=[])},t.removeAllHooks=function(){w={}},t}var purify=createDOMPurify();let nextCreditId=0;const creditToId={};function Credit(e,t){let n;const i=e;defined(creditToId[i])?n=creditToId[i]:(n=nextCreditId++,creditToId[i]=n),t=defaultValue(t,!1),this._id=n,this._html=e,this._showOnScreen=t,this._element=void 0}Object.defineProperties(Credit.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen},set:function(e){this._showOnScreen=e}},element:{get:function(){if(!defined(this._element)){const e=purify.sanitize(this._html),t=document.createElement("div");t._creditId=this._id,t.style.display="inline",t.innerHTML=e;const n=t.querySelectorAll("a");for(let e=0;e<n.length;e++)n[e].setAttribute("target","_blank");this._element=t}return this._element}}}),Credit.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._id===t._id&&e._showOnScreen===t._showOnScreen},Credit.prototype.equals=function(e){return Credit.equals(this,e)},Credit.getIonCredit=function(e){const t=defined(e.collapsible)&&!e.collapsible,n=new Credit(e.html,t);return n._isIon=-1!==n.html.indexOf("ion-credit.png"),n},Credit.clone=function(e){if(defined(e))return new Credit(e.html,e.showOnScreen)};const HeightmapEncoding={NONE:0,LERC:1};var HeightmapEncoding$1=Object.freeze(HeightmapEncoding);function AxisAlignedBoundingBox(e,t,n){this.minimum=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.maximum=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),n=defined(n)?Cartesian3.clone(n):Cartesian3.midpoint(this.minimum,this.maximum,new Cartesian3),this.center=n}AxisAlignedBoundingBox.fromCorners=function(e,t,n){return defined(n)||(n=new AxisAlignedBoundingBox),n.minimum=Cartesian3.clone(e,n.minimum),n.maximum=Cartesian3.clone(t,n.maximum),n.center=Cartesian3.midpoint(e,t,n.center),n},AxisAlignedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new AxisAlignedBoundingBox),!defined(e)||0===e.length)return t.minimum=Cartesian3.clone(Cartesian3.ZERO,t.minimum),t.maximum=Cartesian3.clone(Cartesian3.ZERO,t.maximum),t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t;let n=e[0].x,i=e[0].y,r=e[0].z,o=e[0].x,a=e[0].y,s=e[0].z;const c=e.length;for(let t=1;t<c;t++){const c=e[t],l=c.x,u=c.y,d=c.z;n=Math.min(l,n),o=Math.max(l,o),i=Math.min(u,i),a=Math.max(u,a),r=Math.min(d,r),s=Math.max(d,s)}const l=t.minimum;l.x=n,l.y=i,l.z=r;const u=t.maximum;return u.x=o,u.y=a,u.z=s,t.center=Cartesian3.midpoint(l,u,t.center),t},AxisAlignedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(t.minimum=Cartesian3.clone(e.minimum,t.minimum),t.maximum=Cartesian3.clone(e.maximum,t.maximum),t.center=Cartesian3.clone(e.center,t.center),t):new AxisAlignedBoundingBox(e.minimum,e.maximum,e.center)},AxisAlignedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Cartesian3.equals(e.minimum,t.minimum)&&Cartesian3.equals(e.maximum,t.maximum)};let intersectScratch=new Cartesian3;function EllipsoidalOccluder(e,t){this._ellipsoid=e,this._cameraPosition=new Cartesian3,this._cameraPositionInScaledSpace=new Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,defined(t)&&(this.cameraPosition=t)}AxisAlignedBoundingBox.intersectPlane=function(e,t){intersectScratch=Cartesian3.subtract(e.maximum,e.minimum,intersectScratch);const n=Cartesian3.multiplyByScalar(intersectScratch,.5,intersectScratch),i=t.normal,r=n.x*Math.abs(i.x)+n.y*Math.abs(i.y)+n.z*Math.abs(i.z),o=Cartesian3.dot(e.center,i)+t.distance;return o-r>0?Intersect$1.INSIDE:o+r<0?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},AxisAlignedBoundingBox.prototype.clone=function(e){return AxisAlignedBoundingBox.clone(this,e)},AxisAlignedBoundingBox.prototype.intersectPlane=function(e){return AxisAlignedBoundingBox.intersectPlane(this,e)},AxisAlignedBoundingBox.prototype.equals=function(e){return AxisAlignedBoundingBox.equals(this,e)},Object.defineProperties(EllipsoidalOccluder.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){const t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=Cartesian3.magnitudeSquared(t)-1;Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=n}}});const scratchCartesian$9=new Cartesian3;EllipsoidalOccluder.prototype.isPointVisible=function(e){return isScaledSpacePointVisible(this._ellipsoid.transformPositionToScaledSpace(e,scratchCartesian$9),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},EllipsoidalOccluder.prototype.isScaledSpacePointVisible=function(e){return isScaledSpacePointVisible(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};const scratchCameraPositionInScaledSpaceShrunk=new Cartesian3;EllipsoidalOccluder.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){const n=this._ellipsoid;let i,r;return defined(t)&&t<0&&n.minimumRadius>-t?(r=scratchCameraPositionInScaledSpaceShrunk,r.x=this._cameraPosition.x/(n.radii.x+t),r.y=this._cameraPosition.y/(n.radii.y+t),r.z=this._cameraPosition.z/(n.radii.z+t),i=r.x*r.x+r.y*r.y+r.z*r.z-1):(r=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared),isScaledSpacePointVisible(e,r,i)},EllipsoidalOccluder.prototype.computeHorizonCullingPoint=function(e,t,n){return computeHorizonCullingPointFromPositions(this._ellipsoid,e,t,n)};const scratchEllipsoidShrunk=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE);EllipsoidalOccluder.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,n,i){return computeHorizonCullingPointFromPositions(getPossiblyShrunkEllipsoid(this._ellipsoid,n,scratchEllipsoidShrunk),e,t,i)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices=function(e,t,n,i,r){return computeHorizonCullingPointFromVertices(this._ellipsoid,e,t,n,i,r)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,n,i,r,o){return computeHorizonCullingPointFromVertices(getPossiblyShrunkEllipsoid(this._ellipsoid,r,scratchEllipsoidShrunk),e,t,n,i,o)};const subsampleScratch=[];EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle=function(e,t,n){const i=Rectangle.subsample(e,t,0,subsampleScratch),r=BoundingSphere.fromPoints(i);if(!(Cartesian3.magnitude(r.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(r.center,i,n)};const scratchEllipsoidShrunkRadii=new Cartesian3;function getPossiblyShrunkEllipsoid(e,t,n){if(defined(t)&&t<0&&e.minimumRadius>-t){const i=Cartesian3.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,scratchEllipsoidShrunkRadii);e=Ellipsoid.fromCartesian3(i,n)}return e}function computeHorizonCullingPointFromPositions(e,t,n,i){defined(i)||(i=new Cartesian3);const r=computeScaledSpaceDirectionToPoint(e,t);let o=0;for(let t=0,i=n.length;t<i;++t){const i=computeMagnitude(e,n[t],r);if(i<0)return;o=Math.max(o,i)}return magnitudeToPoint(r,o,i)}const positionScratch$c=new Cartesian3;function computeHorizonCullingPointFromVertices(e,t,n,i,r,o){defined(o)||(o=new Cartesian3),i=defaultValue(i,3),r=defaultValue(r,Cartesian3.ZERO);const a=computeScaledSpaceDirectionToPoint(e,t);let s=0;for(let t=0,o=n.length;t<o;t+=i){positionScratch$c.x=n[t]+r.x,positionScratch$c.y=n[t+1]+r.y,positionScratch$c.z=n[t+2]+r.z;const i=computeMagnitude(e,positionScratch$c,a);if(i<0)return;s=Math.max(s,i)}return magnitudeToPoint(a,s,o)}function isScaledSpacePointVisible(e,t,n){const i=t,r=n,o=Cartesian3.subtract(e,i,scratchCartesian$9),a=-Cartesian3.dot(o,i);return!(r<0?a>0:a>r&&a*a/Cartesian3.magnitudeSquared(o)>r)}const scaledSpaceScratch=new Cartesian3,directionScratch=new Cartesian3;function computeMagnitude(e,t,n){const i=e.transformPositionToScaledSpace(t,scaledSpaceScratch);let r=Cartesian3.magnitudeSquared(i),o=Math.sqrt(r);const a=Cartesian3.divideByScalar(i,o,directionScratch);r=Math.max(1,r),o=Math.max(1,o);const s=1/o;return 1/(Cartesian3.dot(a,n)*s-Cartesian3.magnitude(Cartesian3.cross(a,n,a))*(Math.sqrt(r-1)*s))}function magnitudeToPoint(e,t,n){if(!(t<=0||t===1/0||t!=t))return Cartesian3.multiplyByScalar(e,t,n)}const directionToPointScratch=new Cartesian3;function computeScaledSpaceDirectionToPoint(e,t){return Cartesian3.equals(t,Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,directionToPointScratch),Cartesian3.normalize(directionToPointScratch,directionToPointScratch))}const QuadraticRealPolynomial={};function addWithCancellationCheck$1(e,t,n){const i=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}QuadraticRealPolynomial.computeDiscriminant=function(e,t,n){return t*t-4*e*n},QuadraticRealPolynomial.computeRealRoots=function(e,t,n){let i;if(0===e)return 0===t?[]:[-n/t];if(0===t){if(0===n)return[0,0];const t=Math.abs(n),r=Math.abs(e);if(t<r&&t/r<CesiumMath.EPSILON14)return[0,0];if(t>r&&r/t<CesiumMath.EPSILON14)return[];if(i=-n/e,i<0)return[];const o=Math.sqrt(i);return[-o,o]}if(0===n)return i=-t/e,i<0?[i,0]:[0,i];const r=addWithCancellationCheck$1(t*t,-(4*e*n),CesiumMath.EPSILON14);if(r<0)return[];const o=-.5*addWithCancellationCheck$1(t,CesiumMath.sign(t)*Math.sqrt(r),CesiumMath.EPSILON14);return t>0?[o/e,n/o]:[n/o,o/e]};const CubicRealPolynomial={};function computeRealRoots(e,t,n,i){const r=e,o=t/3,a=n/3,s=i,c=r*a,l=o*s,u=o*o,d=a*a,h=r*a-u,p=r*s-o*a,f=o*s-d,m=4*h*f-p*p;let g,_;if(m<0){let e,t,n;u*l>=c*d?(e=r,t=h,n=-2*o*h+r*p):(e=s,t=f,n=-s*p+2*a*f);const i=-(n<0?-1:1)*Math.abs(e)*Math.sqrt(-m);_=-n+i;const y=_/2,C=y<0?-Math.pow(-y,1/3):Math.pow(y,1/3),T=_===i?-C:-t/C;return g=t<=0?C+T:-n/(C*C+T*T+t),u*l>=c*d?[(g-o)/r]:[-s/(g+a)]}const y=h,C=-2*o*h+r*p,T=f,S=-s*p+2*a*f,A=Math.sqrt(m),v=Math.sqrt(3)/2;let E=Math.abs(Math.atan2(r*A,-C)/3);g=2*Math.sqrt(-y);let b=Math.cos(E);_=g*b;let x=g*(-b/2-v*Math.sin(E));const P=_+x>2*o?_-o:x-o,D=r,w=P/D;E=Math.abs(Math.atan2(s*A,-S)/3),g=2*Math.sqrt(-T),b=Math.cos(E),_=g*b,x=g*(-b/2-v*Math.sin(E));const M=-s,I=_+x<2*a?_+a:x+a,R=M/I,O=-P*I-D*M,B=(a*O-o*(P*M))/(-o*O+a*(D*I));return w<=B?w<=R?B<=R?[w,B,R]:[w,R,B]:[R,w,B]:w<=R?[B,w,R]:B<=R?[B,R,w]:[R,B,w]}CubicRealPolynomial.computeDiscriminant=function(e,t,n,i){const r=t*t,o=n*n;return 18*e*t*n*i+r*o-27*(e*e)*(i*i)-4*(e*o*n+r*t*i)},CubicRealPolynomial.computeRealRoots=function(e,t,n,i){let r,o;if(0===e)return QuadraticRealPolynomial.computeRealRoots(t,n,i);if(0===t){if(0===n){if(0===i)return[0,0,0];o=-i/e;const t=o<0?-Math.pow(-o,1/3):Math.pow(o,1/3);return[t,t,t]}return 0===i?(r=QuadraticRealPolynomial.computeRealRoots(e,0,n),0===r.Length?[0]:[r[0],0,r[1]]):computeRealRoots(e,0,n,i)}return 0===n?0===i?(o=-t/e,o<0?[o,0,0]:[0,0,o]):computeRealRoots(e,t,0,i):0===i?(r=QuadraticRealPolynomial.computeRealRoots(e,t,n),0===r.length?[0]:r[1]<=0?[r[0],r[1],0]:r[0]>=0?[0,r[0],r[1]]:[r[0],0,r[1]]):computeRealRoots(e,t,n,i)};const QuarticRealPolynomial={};function original(e,t,n,i){const r=e*e,o=t-3*r/8,a=n-t*e/2+r*e/8,s=i-n*e/4+t*r/16-3*r*r/256,c=CubicRealPolynomial.computeRealRoots(1,2*o,o*o-4*s,-a*a);if(c.length>0){const t=-e/4,n=c[c.length-1];if(Math.abs(n)<CesiumMath.EPSILON14){const e=QuadraticRealPolynomial.computeRealRoots(1,o,s);if(2===e.length){const n=e[0],i=e[1];let r;if(n>=0&&i>=0){const e=Math.sqrt(n),r=Math.sqrt(i);return[t-r,t-e,t+e,t+r]}if(n>=0&&i<0)return r=Math.sqrt(n),[t-r,t+r];if(n<0&&i>=0)return r=Math.sqrt(i),[t-r,t+r]}return[]}if(n>0){const e=Math.sqrt(n),i=(o+n-a/e)/2,r=(o+n+a/e)/2,s=QuadraticRealPolynomial.computeRealRoots(1,e,i),c=QuadraticRealPolynomial.computeRealRoots(1,-e,r);return 0!==s.length?(s[0]+=t,s[1]+=t,0!==c.length?(c[0]+=t,c[1]+=t,s[1]<=c[0]?[s[0],s[1],c[0],c[1]]:c[1]<=s[0]?[c[0],c[1],s[0],s[1]]:s[0]>=c[0]&&s[1]<=c[1]?[c[0],s[0],s[1],c[1]]:c[0]>=s[0]&&c[1]<=s[1]?[s[0],c[0],c[1],s[1]]:s[0]>c[0]&&s[0]<c[1]?[c[0],s[0],c[1],s[1]]:[s[0],c[0],s[1],c[1]]):s):0!==c.length?(c[0]+=t,c[1]+=t,c):[]}}return[]}function neumark(e,t,n,i){const r=e*e,o=-2*t,a=n*e+t*t-4*i,s=r*i-n*t*e+n*n,c=CubicRealPolynomial.computeRealRoots(1,o,a,s);if(c.length>0){const o=c[0],a=t-o,s=a*a,l=e/2,u=a/2,d=s-4*i,h=s+4*Math.abs(i),p=r-4*o,f=r+4*Math.abs(o);let m,g,_,y,C,T;if(o<0||d*f<p*h){const t=Math.sqrt(p);m=t/2,g=0===t?0:(e*u-n)/t}else{const t=Math.sqrt(d);m=0===t?0:(e*u-n)/t,g=t/2}0===l&&0===m?(_=0,y=0):CesiumMath.sign(l)===CesiumMath.sign(m)?(_=l+m,y=o/_):(y=l-m,_=o/y),0===u&&0===g?(C=0,T=0):CesiumMath.sign(u)===CesiumMath.sign(g)?(C=u+g,T=i/C):(T=u-g,C=i/T);const S=QuadraticRealPolynomial.computeRealRoots(1,_,C),A=QuadraticRealPolynomial.computeRealRoots(1,y,T);if(0!==S.length)return 0!==A.length?S[1]<=A[0]?[S[0],S[1],A[0],A[1]]:A[1]<=S[0]?[A[0],A[1],S[0],S[1]]:S[0]>=A[0]&&S[1]<=A[1]?[A[0],S[0],S[1],A[1]]:A[0]>=S[0]&&A[1]<=S[1]?[S[0],A[0],A[1],S[1]]:S[0]>A[0]&&S[0]<A[1]?[A[0],S[0],A[1],S[1]]:[S[0],A[0],S[1],A[1]]:S;if(0!==A.length)return A}return[]}function Ray(e,t){t=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),Cartesian3.equals(t,Cartesian3.ZERO)||Cartesian3.normalize(t,t),this.origin=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.direction=t}QuarticRealPolynomial.computeDiscriminant=function(e,t,n,i,r){const o=e*e,a=t*t,s=a*t,c=n*n,l=c*n,u=i*i,d=u*i,h=r*r;return a*c*u-4*s*d-4*e*l*u+18*e*t*n*d-27*o*u*u+256*(o*e)*(h*r)+r*(18*s*n*i-4*a*l+16*e*c*c-80*e*t*c*i-6*e*a*u+144*o*n*u)+h*(144*e*a*n-27*a*a-128*o*c-192*o*t*i)},QuarticRealPolynomial.computeRealRoots=function(e,t,n,i,r){if(Math.abs(e)<CesiumMath.EPSILON15)return CubicRealPolynomial.computeRealRoots(t,n,i,r);const o=t/e,a=n/e,s=i/e,c=r/e;let l=o<0?1:0;switch(l+=a<0?l+1:l,l+=s<0?l+1:l,l+=c<0?l+1:l,l){case 0:case 3:case 4:case 6:case 7:case 9:case 10:case 12:case 13:case 14:case 15:return original(o,a,s,c);case 1:case 2:case 5:case 8:case 11:return neumark(o,a,s,c);default:return}},Ray.clone=function(e,t){if(defined(e))return defined(t)?(t.origin=Cartesian3.clone(e.origin),t.direction=Cartesian3.clone(e.direction),t):new Ray(e.origin,e.direction)},Ray.getPoint=function(e,t,n){return defined(n)||(n=new Cartesian3),n=Cartesian3.multiplyByScalar(e.direction,t,n),Cartesian3.add(e.origin,n,n)};const IntersectionTests={rayPlane:function(e,t,n){defined(n)||(n=new Cartesian3);const i=e.origin,r=e.direction,o=t.normal,a=Cartesian3.dot(o,r);if(Math.abs(a)<CesiumMath.EPSILON15)return;const s=(-t.distance-Cartesian3.dot(o,i))/a;return s<0?void 0:(n=Cartesian3.multiplyByScalar(r,s,n),Cartesian3.add(i,n,n))}},scratchEdge0=new Cartesian3,scratchEdge1=new Cartesian3,scratchPVec=new Cartesian3,scratchTVec=new Cartesian3,scratchQVec=new Cartesian3;IntersectionTests.rayTriangleParametric=function(e,t,n,i,r){r=defaultValue(r,!1);const o=e.origin,a=e.direction,s=Cartesian3.subtract(n,t,scratchEdge0),c=Cartesian3.subtract(i,t,scratchEdge1),l=Cartesian3.cross(a,c,scratchPVec),u=Cartesian3.dot(s,l);let d,h,p,f,m;if(r){if(u<CesiumMath.EPSILON6)return;if(d=Cartesian3.subtract(o,t,scratchTVec),p=Cartesian3.dot(d,l),p<0||p>u)return;if(h=Cartesian3.cross(d,s,scratchQVec),f=Cartesian3.dot(a,h),f<0||p+f>u)return;m=Cartesian3.dot(c,h)/u}else{if(Math.abs(u)<CesiumMath.EPSILON6)return;const e=1/u;if(d=Cartesian3.subtract(o,t,scratchTVec),p=Cartesian3.dot(d,l)*e,p<0||p>1)return;if(h=Cartesian3.cross(d,s,scratchQVec),f=Cartesian3.dot(a,h)*e,f<0||p+f>1)return;m=Cartesian3.dot(c,h)*e}return m},IntersectionTests.rayTriangle=function(e,t,n,i,r,o){const a=IntersectionTests.rayTriangleParametric(e,t,n,i,r);if(defined(a)&&!(a<0))return defined(o)||(o=new Cartesian3),Cartesian3.multiplyByScalar(e.direction,a,o),Cartesian3.add(e.origin,o,o)};const scratchLineSegmentTriangleRay=new Ray;function solveQuadratic(e,t,n,i){const r=t*t-4*e*n;if(r<0)return;if(r>0){const n=1/(2*e),o=Math.sqrt(r),a=(-t+o)*n,s=(-t-o)*n;return a<s?(i.root0=a,i.root1=s):(i.root0=s,i.root1=a),i}const o=-t/(2*e);return 0!==o?(i.root0=i.root1=o,i):void 0}IntersectionTests.lineSegmentTriangle=function(e,t,n,i,r,o,a){const s=scratchLineSegmentTriangleRay;Cartesian3.clone(e,s.origin),Cartesian3.subtract(t,e,s.direction),Cartesian3.normalize(s.direction,s.direction);const c=IntersectionTests.rayTriangleParametric(s,n,i,r,o);if(!(!defined(c)||c<0||c>Cartesian3.distance(e,t)))return defined(a)||(a=new Cartesian3),Cartesian3.multiplyByScalar(s.direction,c,a),Cartesian3.add(s.origin,a,a)};const raySphereRoots={root0:0,root1:0};function raySphere(e,t,n){defined(n)||(n=new Interval);const i=e.origin,r=e.direction,o=t.center,a=t.radius*t.radius,s=Cartesian3.subtract(i,o,scratchPVec),c=solveQuadratic(Cartesian3.dot(r,r),2*Cartesian3.dot(r,s),Cartesian3.magnitudeSquared(s)-a,raySphereRoots);if(defined(c))return n.start=c.root0,n.stop=c.root1,n}IntersectionTests.raySphere=function(e,t,n){if(defined(n=raySphere(e,t,n))&&!(n.stop<0))return n.start=Math.max(n.start,0),n};const scratchLineSegmentRay=new Ray;IntersectionTests.lineSegmentSphere=function(e,t,n,i){const r=scratchLineSegmentRay;Cartesian3.clone(e,r.origin);const o=Cartesian3.subtract(t,e,r.direction),a=Cartesian3.magnitude(o);if(Cartesian3.normalize(o,o),!(!defined(i=raySphere(r,n,i))||i.stop<0||i.start>a))return i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,a),i};const scratchQ=new Cartesian3,scratchW$1=new Cartesian3;function addWithCancellationCheck(e,t,n){const i=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}function quadraticVectorExpression(e,t,n,i,r){const o=i*i,a=r*r,s=(e[Matrix3.COLUMN1ROW1]-e[Matrix3.COLUMN2ROW2])*a,c=r*(i*addWithCancellationCheck(e[Matrix3.COLUMN1ROW0],e[Matrix3.COLUMN0ROW1],CesiumMath.EPSILON15)+t.y),l=e[Matrix3.COLUMN0ROW0]*o+e[Matrix3.COLUMN2ROW2]*a+i*t.x+n,u=a*addWithCancellationCheck(e[Matrix3.COLUMN2ROW1],e[Matrix3.COLUMN1ROW2],CesiumMath.EPSILON15),d=r*(i*addWithCancellationCheck(e[Matrix3.COLUMN2ROW0],e[Matrix3.COLUMN0ROW2])+t.z);let h;const p=[];if(0===d&&0===u){if(h=QuadraticRealPolynomial.computeRealRoots(s,c,l),0===h.length)return p;const e=h[0],t=Math.sqrt(Math.max(1-e*e,0));if(p.push(new Cartesian3(i,r*e,r*-t)),p.push(new Cartesian3(i,r*e,r*t)),2===h.length){const e=h[1],t=Math.sqrt(Math.max(1-e*e,0));p.push(new Cartesian3(i,r*e,r*-t)),p.push(new Cartesian3(i,r*e,r*t))}return p}const f=d*d,m=u*u,g=d*u,_=s*s+m,y=2*(c*s+g),C=2*l*s+c*c-m+f,T=2*(l*c-g),S=l*l-f;if(0===_&&0===y&&0===C&&0===T)return p;h=QuarticRealPolynomial.computeRealRoots(_,y,C,T,S);const A=h.length;if(0===A)return p;for(let e=0;e<A;++e){const t=h[e],n=t*t,o=Math.max(1-n,0),a=Math.sqrt(o);let f;f=CesiumMath.sign(s)===CesiumMath.sign(l)?addWithCancellationCheck(s*n+l,c*t,CesiumMath.EPSILON12):CesiumMath.sign(l)===CesiumMath.sign(c*t)?addWithCancellationCheck(s*n,c*t+l,CesiumMath.EPSILON12):addWithCancellationCheck(s*n+c*t,l,CesiumMath.EPSILON12);const m=f*addWithCancellationCheck(u*t,d,CesiumMath.EPSILON15);m<0?p.push(new Cartesian3(i,r*t,r*a)):m>0?p.push(new Cartesian3(i,r*t,r*-a)):0!==a?(p.push(new Cartesian3(i,r*t,r*-a)),p.push(new Cartesian3(i,r*t,r*a)),++e):p.push(new Cartesian3(i,r*t,r*a))}return p}IntersectionTests.rayEllipsoid=function(e,t){const n=t.oneOverRadii,i=Cartesian3.multiplyComponents(n,e.origin,scratchQ),r=Cartesian3.multiplyComponents(n,e.direction,scratchW$1),o=Cartesian3.magnitudeSquared(i),a=Cartesian3.dot(i,r);let s,c,l,u,d;if(o>1){if(a>=0)return;const e=a*a;if(s=o-1,c=Cartesian3.magnitudeSquared(r),l=c*s,e<l)return;if(e>l){u=a*a-l,d=-a+Math.sqrt(u);const e=d/c,t=s/d;return e<t?new Interval(e,t):{start:t,stop:e}}const t=Math.sqrt(s/c);return new Interval(t,t)}return o<1?(s=o-1,c=Cartesian3.magnitudeSquared(r),l=c*s,u=a*a-l,d=-a+Math.sqrt(u),new Interval(0,d/c)):a<0?(c=Cartesian3.magnitudeSquared(r),new Interval(0,-a/c)):void 0};const firstAxisScratch=new Cartesian3,secondAxisScratch=new Cartesian3,thirdAxisScratch=new Cartesian3,referenceScratch=new Cartesian3,bCart=new Cartesian3,bScratch=new Matrix3,btScratch=new Matrix3,diScratch=new Matrix3,dScratch$1=new Matrix3,cScratch=new Matrix3,tempMatrix=new Matrix3,aScratch=new Matrix3,sScratch$1=new Cartesian3,closestScratch=new Cartesian3,surfPointScratch=new Cartographic;IntersectionTests.grazingAltitudeLocation=function(e,t){const n=e.origin,i=e.direction;if(!Cartesian3.equals(n,Cartesian3.ZERO)){const e=t.geodeticSurfaceNormal(n,firstAxisScratch);if(Cartesian3.dot(i,e)>=0)return n}const r=defined(this.rayEllipsoid(e,t)),o=t.transformPositionToScaledSpace(i,firstAxisScratch),a=Cartesian3.normalize(o,o),s=Cartesian3.mostOrthogonalAxis(o,referenceScratch),c=Cartesian3.normalize(Cartesian3.cross(s,a,secondAxisScratch),secondAxisScratch),l=Cartesian3.normalize(Cartesian3.cross(a,c,thirdAxisScratch),thirdAxisScratch),u=bScratch;u[0]=a.x,u[1]=a.y,u[2]=a.z,u[3]=c.x,u[4]=c.y,u[5]=c.z,u[6]=l.x,u[7]=l.y,u[8]=l.z;const d=Matrix3.transpose(u,btScratch),h=Matrix3.fromScale(t.radii,diScratch),p=Matrix3.fromScale(t.oneOverRadii,dScratch$1),f=cScratch;f[0]=0,f[1]=-i.z,f[2]=i.y,f[3]=i.z,f[4]=0,f[5]=-i.x,f[6]=-i.y,f[7]=i.x,f[8]=0;const m=Matrix3.multiply(Matrix3.multiply(d,p,tempMatrix),f,tempMatrix),g=Matrix3.multiply(Matrix3.multiply(m,h,aScratch),u,aScratch),_=Matrix3.multiplyByVector(m,n,bCart),y=quadraticVectorExpression(g,Cartesian3.negate(_,firstAxisScratch),0,0,1);let C,T;const S=y.length;if(S>0){let e=Cartesian3.clone(Cartesian3.ZERO,closestScratch),o=Number.NEGATIVE_INFINITY;for(let t=0;t<S;++t){C=Matrix3.multiplyByVector(h,Matrix3.multiplyByVector(u,y[t],sScratch$1),sScratch$1);const r=Cartesian3.normalize(Cartesian3.subtract(C,n,referenceScratch),referenceScratch),a=Cartesian3.dot(r,i);a>o&&(o=a,e=Cartesian3.clone(C,e))}const a=t.cartesianToCartographic(e,surfPointScratch);return o=CesiumMath.clamp(o,0,1),T=Cartesian3.magnitude(Cartesian3.subtract(e,n,referenceScratch))*Math.sqrt(1-o*o),T=r?-T:T,a.height=T,t.cartographicToCartesian(a,new Cartesian3)}};const lineSegmentPlaneDifference=new Cartesian3;function Plane(e,t){this.normal=Cartesian3.clone(e),this.distance=t}IntersectionTests.lineSegmentPlane=function(e,t,n,i){defined(i)||(i=new Cartesian3);const r=Cartesian3.subtract(t,e,lineSegmentPlaneDifference),o=n.normal,a=Cartesian3.dot(o,r);if(Math.abs(a)<CesiumMath.EPSILON6)return;const s=Cartesian3.dot(o,e),c=-(n.distance+s)/a;return c<0||c>1?void 0:(Cartesian3.multiplyByScalar(r,c,i),Cartesian3.add(e,i,i),i)},IntersectionTests.trianglePlaneIntersection=function(e,t,n,i){const r=i.normal,o=i.distance,a=Cartesian3.dot(r,e)+o<0,s=Cartesian3.dot(r,t)+o<0,c=Cartesian3.dot(r,n)+o<0;let l,u,d=0;if(d+=a?1:0,d+=s?1:0,d+=c?1:0,1!==d&&2!==d||(l=new Cartesian3,u=new Cartesian3),1===d){if(a)return IntersectionTests.lineSegmentPlane(e,t,i,l),IntersectionTests.lineSegmentPlane(e,n,i,u),{positions:[e,t,n,l,u],indices:[0,3,4,1,2,4,1,4,3]};if(s)return IntersectionTests.lineSegmentPlane(t,n,i,l),IntersectionTests.lineSegmentPlane(t,e,i,u),{positions:[e,t,n,l,u],indices:[1,3,4,2,0,4,2,4,3]};if(c)return IntersectionTests.lineSegmentPlane(n,e,i,l),IntersectionTests.lineSegmentPlane(n,t,i,u),{positions:[e,t,n,l,u],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!a)return IntersectionTests.lineSegmentPlane(t,e,i,l),IntersectionTests.lineSegmentPlane(n,e,i,u),{positions:[e,t,n,l,u],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return IntersectionTests.lineSegmentPlane(n,t,i,l),IntersectionTests.lineSegmentPlane(e,t,i,u),{positions:[e,t,n,l,u],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return IntersectionTests.lineSegmentPlane(e,n,i,l),IntersectionTests.lineSegmentPlane(t,n,i,u),{positions:[e,t,n,l,u],indices:[0,1,4,0,4,3,2,3,4]}}},Plane.fromPointNormal=function(e,t,n){const i=-Cartesian3.dot(t,e);return defined(n)?(Cartesian3.clone(t,n.normal),n.distance=i,n):new Plane(t,i)};const scratchNormal$7=new Cartesian3;Plane.fromCartesian4=function(e,t){const n=Cartesian3.fromCartesian4(e,scratchNormal$7),i=e.w;return defined(t)?(Cartesian3.clone(n,t.normal),t.distance=i,t):new Plane(n,i)},Plane.getPointDistance=function(e,t){return Cartesian3.dot(e.normal,t)+e.distance};const scratchCartesian$8=new Cartesian3;Plane.projectPointOntoPlane=function(e,t,n){defined(n)||(n=new Cartesian3);const i=Plane.getPointDistance(e,t),r=Cartesian3.multiplyByScalar(e.normal,i,scratchCartesian$8);return Cartesian3.subtract(t,r,n)};const scratchInverseTranspose=new Matrix4,scratchPlaneCartesian4=new Cartesian4,scratchTransformNormal=new Cartesian3;function binarySearch(e,t,n){let i,r,o=0,a=e.length-1;for(;o<=a;)if(i=~~((o+a)/2),r=n(e[i],t),r<0)o=i+1;else{if(!(r>0))return i;a=i-1}return~(a+1)}function EarthOrientationParametersSample(e,t,n,i,r){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=i,this.ut1MinusUtc=r}function GregorianDate(e,t,n,i,r,o,a,s){this.year=e,this.month=t,this.day=n,this.hour=i,this.minute=r,this.second=o,this.millisecond=a,this.isLeapSecond=s}function isLeapYear(e){return e%4==0&&e%100!=0||e%400==0}function LeapSecond(e,t){this.julianDate=e,this.offset=t}Plane.transform=function(e,t,n){const i=e.normal,r=e.distance,o=Matrix4.inverseTranspose(t,scratchInverseTranspose);let a=Cartesian4.fromElements(i.x,i.y,i.z,r,scratchPlaneCartesian4);a=Matrix4.multiplyByVector(o,a,a);const s=Cartesian3.fromCartesian4(a,scratchTransformNormal);return a=Cartesian4.divideByScalar(a,Cartesian3.magnitude(s),a),Plane.fromCartesian4(a,n)},Plane.clone=function(e,t){return defined(t)?(Cartesian3.clone(e.normal,t.normal),t.distance=e.distance,t):new Plane(e.normal,e.distance)},Plane.equals=function(e,t){return e.distance===t.distance&&Cartesian3.equals(e.normal,t.normal)},Plane.ORIGIN_XY_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Z,0)),Plane.ORIGIN_YZ_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_X,0)),Plane.ORIGIN_ZX_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Y,0));const TimeConstants={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};var TimeConstants$1=Object.freeze(TimeConstants);const TimeStandard={UTC:0,TAI:1};var TimeStandard$1=Object.freeze(TimeStandard);const gregorianDateScratch=new GregorianDate,daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31],daysInLeapFeburary=29;function compareLeapSecondDates$1(e,t){return JulianDate.compare(e.julianDate,t.julianDate)}const binarySearchScratchLeapSecond=new LeapSecond;function convertUtcToTai(e){binarySearchScratchLeapSecond.julianDate=e;const t=JulianDate.leapSeconds;let n=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1);n<0&&(n=~n),n>=t.length&&(n=t.length-1);let i=t[n].offset;if(n>0){JulianDate.secondsDifference(t[n].julianDate,e)>i&&(n--,i=t[n].offset)}JulianDate.addSeconds(e,i,e)}function convertTaiToUtc(e,t){binarySearchScratchLeapSecond.julianDate=e;const n=JulianDate.leapSeconds;let i=binarySearch(n,binarySearchScratchLeapSecond,compareLeapSecondDates$1);if(i<0&&(i=~i),0===i)return JulianDate.addSeconds(e,-n[0].offset,t);if(i>=n.length)return JulianDate.addSeconds(e,-n[i-1].offset,t);const r=JulianDate.secondsDifference(n[i].julianDate,e);return 0===r?JulianDate.addSeconds(e,-n[i].offset,t):r<=1?void 0:JulianDate.addSeconds(e,-n[--i].offset,t)}function setComponents(e,t,n){const i=t/TimeConstants$1.SECONDS_PER_DAY|0;return e+=i,(t-=TimeConstants$1.SECONDS_PER_DAY*i)<0&&(e--,t+=TimeConstants$1.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function computeJulianDateComponents(e,t,n,i,r,o,a){const s=(t-14)/12|0,c=e+4800+s;let l=(1461*c/4|0)+(367*(t-2-12*s)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;(i-=12)<0&&(i+=24);const u=o+(i*TimeConstants$1.SECONDS_PER_HOUR+r*TimeConstants$1.SECONDS_PER_MINUTE+a*TimeConstants$1.SECONDS_PER_MILLISECOND);return u>=43200&&(l-=1),[l,u]}const matchCalendarYear=/^(\d{4})$/,matchCalendarMonth=/^(\d{4})-(\d{2})$/,matchOrdinalDate=/^(\d{4})-?(\d{3})$/,matchWeekDate=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,matchCalendarDate=/^(\d{4})-?(\d{2})-?(\d{2})$/,utcOffset=/([Z+\-])?(\d{2})?:?(\d{2})?$/,matchHours=/^(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutes=/^(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutesSeconds=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source;function JulianDate(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=defaultValue(e,0),t=defaultValue(t,0),n=defaultValue(n,TimeStandard$1.UTC);const i=0|e;setComponents(i,t+=(e-i)*TimeConstants$1.SECONDS_PER_DAY,this),n===TimeStandard$1.UTC&&convertUtcToTai(this)}JulianDate.fromGregorianDate=function(e,t){const n=computeJulianDateComponents(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return defined(t)?(setComponents(n[0],n[1],t),convertUtcToTai(t),t):new JulianDate(n[0],n[1],TimeStandard$1.UTC)},JulianDate.fromDate=function(e,t){const n=computeJulianDateComponents(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return defined(t)?(setComponents(n[0],n[1],t),convertUtcToTai(t),t):new JulianDate(n[0],n[1],TimeStandard$1.UTC)},JulianDate.fromIso8601=function(e,t){let n,i=(e=e.replace(",",".")).split("T"),r=1,o=1,a=0,s=0,c=0,l=0;const u=i[0],d=i[1];let h,p,f;if(i=u.match(matchCalendarDate),null!==i)n=+i[1],r=+i[2],o=+i[3];else if(i=u.match(matchCalendarMonth),null!==i)n=+i[1],r=+i[2];else if(i=u.match(matchCalendarYear),null!==i)n=+i[1];else{let e;if(i=u.match(matchOrdinalDate),null!==i)n=+i[1],e=+i[2],p=isLeapYear(n);else if(i=u.match(matchWeekDate),null!==i){n=+i[1];e=7*+i[2]+(+i[3]||0)-new Date(Date.UTC(n,0,4)).getUTCDay()-3}h=new Date(Date.UTC(n,0,1)),h.setUTCDate(e),r=h.getUTCMonth()+1,o=h.getUTCDate()}if(p=isLeapYear(n),defined(d)){i=d.match(matchHoursMinutesSeconds),null!==i?(a=+i[1],s=+i[2],c=+i[3],l=1e3*+(i[4]||0),f=5):(i=d.match(matchHoursMinutes),null!==i?(a=+i[1],s=+i[2],c=60*+(i[3]||0),f=4):(i=d.match(matchHours),null!==i&&(a=+i[1],s=60*+(i[2]||0),f=3)));const e=i[f],t=+i[f+1],u=+(i[f+2]||0);switch(e){case"+":a-=t,s-=u;break;case"-":a+=t,s+=u;break;case"Z":break;default:s+=new Date(Date.UTC(n,r-1,o,a,s)).getTimezoneOffset()}}const m=60===c;for(m&&c--;s>=60;)s-=60,a++;for(;a>=24;)a-=24,o++;for(h=p&&2===r?daysInLeapFeburary:daysInMonth[r-1];o>h;)o-=h,r++,r>12&&(r-=12,n++),h=p&&2===r?daysInLeapFeburary:daysInMonth[r-1];for(;s<0;)s+=60,a--;for(;a<0;)a+=24,o--;for(;o<1;)r--,r<1&&(r+=12,n--),h=p&&2===r?daysInLeapFeburary:daysInMonth[r-1],o+=h;const g=computeJulianDateComponents(n,r,o,a,s,c,l);return defined(t)?(setComponents(g[0],g[1],t),convertUtcToTai(t)):t=new JulianDate(g[0],g[1],TimeStandard$1.UTC),m&&JulianDate.addSeconds(t,1,t),t},JulianDate.now=function(e){return JulianDate.fromDate(new Date,e)};const toGregorianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI);function EarthOrientationParameters(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=defaultValue(e.addNewLeapSeconds,!0),defined(e.data))onDataReady(this,e.data);else if(defined(e.url)){const t=Resource.createIfNeeded(e.url),n=this;this._downloadPromise=t.fetchJson().then((function(e){onDataReady(n,e)})).otherwise((function(){n._dataError=`An error occurred while retrieving the EOP data from the URL ${t.url}.`}))}else onDataReady(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function compareLeapSecondDates(e,t){return JulianDate.compare(e.julianDate,t)}function onDataReady(e,t){if(!defined(t.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!defined(t.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");const n=t.columnNames.indexOf("modifiedJulianDateUtc"),i=t.columnNames.indexOf("xPoleWanderRadians"),r=t.columnNames.indexOf("yPoleWanderRadians"),o=t.columnNames.indexOf("ut1MinusUtcSeconds"),a=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),s=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),c=t.columnNames.indexOf("taiMinusUtcSeconds");if(n<0||i<0||r<0||o<0||a<0||s<0||c<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");const l=e._samples=t.samples,u=e._dates=[];let d;e._dateColumn=n,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=r,e._ut1MinusUtcSecondsColumn=o,e._xCelestialPoleOffsetRadiansColumn=a,e._yCelestialPoleOffsetRadiansColumn=s,e._taiMinusUtcSecondsColumn=c,e._columnCount=t.columnNames.length,e._lastIndex=void 0;const h=e._addNewLeapSeconds;for(let t=0,i=l.length;t<i;t+=e._columnCount){const e=l[t+n],i=l[t+c],r=new JulianDate(e+TimeConstants$1.MODIFIED_JULIAN_DATE_DIFFERENCE,i,TimeStandard$1.TAI);if(u.push(r),h){if(i!==d&&defined(d)){const e=JulianDate.leapSeconds,t=binarySearch(e,r,compareLeapSecondDates);if(t<0){const n=new LeapSecond(r,i);e.splice(~t,0,n)}}d=i}}}function fillResultFromIndex(e,t,n,i,r){const o=n*i;r.xPoleWander=t[o+e._xPoleWanderRadiansColumn],r.yPoleWander=t[o+e._yPoleWanderRadiansColumn],r.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],r.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],r.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function linearInterp(e,t,n){return t+e*(n-t)}function interpolate(e,t,n,i,r,o,a){const s=e._columnCount;if(o>t.length-1)return a.xPoleWander=0,a.yPoleWander=0,a.xPoleOffset=0,a.yPoleOffset=0,a.ut1MinusUtc=0,a;const c=t[r],l=t[o];if(c.equals(l)||i.equals(c))return fillResultFromIndex(e,n,r,s,a),a;if(i.equals(l))return fillResultFromIndex(e,n,o,s,a),a;const u=JulianDate.secondsDifference(i,c)/JulianDate.secondsDifference(l,c),d=r*s,h=o*s;let p=n[d+e._ut1MinusUtcSecondsColumn],f=n[h+e._ut1MinusUtcSecondsColumn];const m=f-p;if(m>.5||m<-.5){const t=n[d+e._taiMinusUtcSecondsColumn],r=n[h+e._taiMinusUtcSecondsColumn];t!==r&&(l.equals(i)?p=f:f-=r-t)}return a.xPoleWander=linearInterp(u,n[d+e._xPoleWanderRadiansColumn],n[h+e._xPoleWanderRadiansColumn]),a.yPoleWander=linearInterp(u,n[d+e._yPoleWanderRadiansColumn],n[h+e._yPoleWanderRadiansColumn]),a.xPoleOffset=linearInterp(u,n[d+e._xCelestialPoleOffsetRadiansColumn],n[h+e._xCelestialPoleOffsetRadiansColumn]),a.yPoleOffset=linearInterp(u,n[d+e._yCelestialPoleOffsetRadiansColumn],n[h+e._yCelestialPoleOffsetRadiansColumn]),a.ut1MinusUtc=linearInterp(u,p,f),a}function HeadingPitchRoll(e,t,n){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.roll=defaultValue(n,0)}function Iau2006XysSample(e,t,n){this.x=e,this.y=t,this.s=n}function Iau2006XysData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=Resource.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new JulianDate(this._sampleZeroJulianEphemerisDate,0,TimeStandard$1.TAI),this._stepSizeDays=defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];const t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),r=Math.pow(this._stepSizeDays,t);for(let e=0;e<=t;++e){n[e]=r,i[e]=e*this._stepSizeDays;for(let i=0;i<=t;++i)i!==e&&(n[e]*=e-i);n[e]=1/n[e]}this._work=new Array(t+1),this._coef=new Array(t+1)}JulianDate.toGregorianDate=function(e,t){let n=!1,i=convertTaiToUtc(e,toGregorianDateScratch);defined(i)||(JulianDate.addSeconds(e,-1,toGregorianDateScratch),i=convertTaiToUtc(toGregorianDateScratch,toGregorianDateScratch),n=!0);let r=i.dayNumber;const o=i.secondsOfDay;o>=43200&&(r+=1);let a=r+68569|0;const s=4*a/146097|0;a=a-((146097*s+3)/4|0)|0;const c=4e3*(a+1)/1461001|0;a=a-(1461*c/4|0)+31|0;const l=80*a/2447|0,u=a-(2447*l/80|0)|0;a=l/11|0;const d=l+2-12*a|0,h=100*(s-49)+c+a|0;let p=o/TimeConstants$1.SECONDS_PER_HOUR|0,f=o-p*TimeConstants$1.SECONDS_PER_HOUR;const m=f/TimeConstants$1.SECONDS_PER_MINUTE|0;f-=m*TimeConstants$1.SECONDS_PER_MINUTE;let g=0|f;const _=(f-g)/TimeConstants$1.SECONDS_PER_MILLISECOND;return p+=12,p>23&&(p-=24),n&&(g+=1),defined(t)?(t.year=h,t.month=d,t.day=u,t.hour=p,t.minute=m,t.second=g,t.millisecond=_,t.isLeapSecond=n,t):new GregorianDate(h,d,u,p,m,g,_,n)},JulianDate.toDate=function(e){const t=JulianDate.toGregorianDate(e,gregorianDateScratch);let n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},JulianDate.toIso8601=function(e,t){const n=JulianDate.toGregorianDate(e,gregorianDateScratch);let i=n.year,r=n.month,o=n.day,a=n.hour;const s=n.minute,c=n.second,l=n.millisecond;let u;return 1e4===i&&1===r&&1===o&&0===a&&0===s&&0===c&&0===l&&(i=9999,r=12,o=31,a=24),defined(t)||0===l?defined(t)&&0!==t?(u=(.01*l).toFixed(t).replace(".","").slice(0,t),`${i.toString().padStart(4,"0")}-${r.toString().padStart(2,"0")}-${o.toString().padStart(2,"0")}T${a.toString().padStart(2,"0")}:${s.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}.${u}Z`):`${i.toString().padStart(4,"0")}-${r.toString().padStart(2,"0")}-${o.toString().padStart(2,"0")}T${a.toString().padStart(2,"0")}:${s.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}Z`:(u=(.01*l).toString().replace(".",""),`${i.toString().padStart(4,"0")}-${r.toString().padStart(2,"0")}-${o.toString().padStart(2,"0")}T${a.toString().padStart(2,"0")}:${s.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}.${u}Z`)},JulianDate.clone=function(e,t){if(defined(e))return defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new JulianDate(e.dayNumber,e.secondsOfDay,TimeStandard$1.TAI)},JulianDate.compare=function(e,t){const n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},JulianDate.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},JulianDate.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(JulianDate.secondsDifference(e,t))<=n},JulianDate.totalDays=function(e){return e.dayNumber+e.secondsOfDay/TimeConstants$1.SECONDS_PER_DAY},JulianDate.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*TimeConstants$1.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},JulianDate.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY},JulianDate.computeTaiMinusUtc=function(e){binarySearchScratchLeapSecond.julianDate=e;const t=JulianDate.leapSeconds;let n=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1);return n<0&&(n=~n,--n,n<0&&(n=0)),t[n].offset},JulianDate.addSeconds=function(e,t,n){return setComponents(e.dayNumber,e.secondsOfDay+t,n)},JulianDate.addMinutes=function(e,t,n){const i=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_MINUTE;return setComponents(e.dayNumber,i,n)},JulianDate.addHours=function(e,t,n){const i=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_HOUR;return setComponents(e.dayNumber,i,n)},JulianDate.addDays=function(e,t,n){return setComponents(e.dayNumber+t,e.secondsOfDay,n)},JulianDate.lessThan=function(e,t){return JulianDate.compare(e,t)<0},JulianDate.lessThanOrEquals=function(e,t){return JulianDate.compare(e,t)<=0},JulianDate.greaterThan=function(e,t){return JulianDate.compare(e,t)>0},JulianDate.greaterThanOrEquals=function(e,t){return JulianDate.compare(e,t)>=0},JulianDate.prototype.clone=function(e){return JulianDate.clone(this,e)},JulianDate.prototype.equals=function(e){return JulianDate.equals(this,e)},JulianDate.prototype.equalsEpsilon=function(e,t){return JulianDate.equalsEpsilon(this,e,t)},JulianDate.prototype.toString=function(){return JulianDate.toIso8601(this)},JulianDate.leapSeconds=[new LeapSecond(new JulianDate(2441317,43210,TimeStandard$1.TAI),10),new LeapSecond(new JulianDate(2441499,43211,TimeStandard$1.TAI),11),new LeapSecond(new JulianDate(2441683,43212,TimeStandard$1.TAI),12),new LeapSecond(new JulianDate(2442048,43213,TimeStandard$1.TAI),13),new LeapSecond(new JulianDate(2442413,43214,TimeStandard$1.TAI),14),new LeapSecond(new JulianDate(2442778,43215,TimeStandard$1.TAI),15),new LeapSecond(new JulianDate(2443144,43216,TimeStandard$1.TAI),16),new LeapSecond(new JulianDate(2443509,43217,TimeStandard$1.TAI),17),new LeapSecond(new JulianDate(2443874,43218,TimeStandard$1.TAI),18),new LeapSecond(new JulianDate(2444239,43219,TimeStandard$1.TAI),19),new LeapSecond(new JulianDate(2444786,43220,TimeStandard$1.TAI),20),new LeapSecond(new JulianDate(2445151,43221,TimeStandard$1.TAI),21),new LeapSecond(new JulianDate(2445516,43222,TimeStandard$1.TAI),22),new LeapSecond(new JulianDate(2446247,43223,TimeStandard$1.TAI),23),new LeapSecond(new JulianDate(2447161,43224,TimeStandard$1.TAI),24),new LeapSecond(new JulianDate(2447892,43225,TimeStandard$1.TAI),25),new LeapSecond(new JulianDate(2448257,43226,TimeStandard$1.TAI),26),new LeapSecond(new JulianDate(2448804,43227,TimeStandard$1.TAI),27),new LeapSecond(new JulianDate(2449169,43228,TimeStandard$1.TAI),28),new LeapSecond(new JulianDate(2449534,43229,TimeStandard$1.TAI),29),new LeapSecond(new JulianDate(2450083,43230,TimeStandard$1.TAI),30),new LeapSecond(new JulianDate(2450630,43231,TimeStandard$1.TAI),31),new LeapSecond(new JulianDate(2451179,43232,TimeStandard$1.TAI),32),new LeapSecond(new JulianDate(2453736,43233,TimeStandard$1.TAI),33),new LeapSecond(new JulianDate(2454832,43234,TimeStandard$1.TAI),34),new LeapSecond(new JulianDate(2456109,43235,TimeStandard$1.TAI),35),new LeapSecond(new JulianDate(2457204,43236,TimeStandard$1.TAI),36),new LeapSecond(new JulianDate(2457754,43237,TimeStandard$1.TAI),37)],EarthOrientationParameters.NONE=Object.freeze({getPromiseToLoad:function(){return when.resolve()},compute:function(e,t){return defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new EarthOrientationParametersSample(0,0,0,0,0),t}}),EarthOrientationParameters.prototype.getPromiseToLoad=function(){return when(this._downloadPromise)},EarthOrientationParameters.prototype.compute=function(e,t){if(!defined(this._samples)){if(defined(this._dataError))throw new RuntimeError(this._dataError);return}if(defined(t)||(t=new EarthOrientationParametersSample(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;const n=this._dates,i=this._lastIndex;let r=0,o=0;if(defined(i)){const a=n[i],s=n[i+1],c=JulianDate.lessThanOrEquals(a,e),l=!defined(s),u=l||JulianDate.greaterThanOrEquals(s,e);if(c&&u)return r=i,!l&&s.equals(e)&&++r,o=r+1,interpolate(this,n,this._samples,e,r,o,t),t}let a=binarySearch(n,e,JulianDate.compare,this._dateColumn);return a>=0?(a<n.length-1&&n[a+1].equals(e)&&++a,r=a,o=a):(o=~a,r=o-1,r<0&&(r=0)),this._lastIndex=r,interpolate(this,n,this._samples,e,r,o,t),t},HeadingPitchRoll.fromQuaternion=function(e,t){defined(t)||(t=new HeadingPitchRoll);const n=2*(e.w*e.y-e.z*e.x),i=1-2*(e.x*e.x+e.y*e.y),r=2*(e.w*e.x+e.y*e.z),o=1-2*(e.y*e.y+e.z*e.z),a=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(a,o),t.roll=Math.atan2(r,i),t.pitch=-CesiumMath.asinClamped(n),t},HeadingPitchRoll.fromDegrees=function(e,t,n,i){return defined(i)||(i=new HeadingPitchRoll),i.heading=e*CesiumMath.RADIANS_PER_DEGREE,i.pitch=t*CesiumMath.RADIANS_PER_DEGREE,i.roll=n*CesiumMath.RADIANS_PER_DEGREE,i},HeadingPitchRoll.clone=function(e,t){if(defined(e))return defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new HeadingPitchRoll(e.heading,e.pitch,e.roll)},HeadingPitchRoll.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},HeadingPitchRoll.equalsEpsilon=function(e,t,n,i){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.heading,t.heading,n,i)&&CesiumMath.equalsEpsilon(e.pitch,t.pitch,n,i)&&CesiumMath.equalsEpsilon(e.roll,t.roll,n,i)},HeadingPitchRoll.prototype.clone=function(e){return HeadingPitchRoll.clone(this,e)},HeadingPitchRoll.prototype.equals=function(e){return HeadingPitchRoll.equals(this,e)},HeadingPitchRoll.prototype.equalsEpsilon=function(e,t,n){return HeadingPitchRoll.equalsEpsilon(this,e,t,n)},HeadingPitchRoll.prototype.toString=function(){return`(${this.heading}, ${this.pitch}, ${this.roll})`};const julianDateScratch$1=new JulianDate(0,0,TimeStandard$1.TAI);function getDaysSinceEpoch(e,t,n){const i=julianDateScratch$1;return i.dayNumber=t,i.secondsOfDay=n,JulianDate.daysDifference(i,e._sampleZeroDateTT)}function requestXysChunk(e,t){if(e._chunkDownloadsInProgress[t])return e._chunkDownloadsInProgress[t];const n=when.defer();let i;e._chunkDownloadsInProgress[t]=n;const r=e._xysFileUrlTemplate;return i=defined(r)?r.getDerivedResource({templateValues:{0:t}}):new Resource({url:buildModuleUrl(`Assets/IAU2006_XYS/IAU2006_XYS_${t}.json`)}),when(i.fetchJson(),(function(i){e._chunkDownloadsInProgress[t]=!1;const r=e._samples,o=i.samples,a=t*e._samplesPerXysFile*3;for(let e=0,t=o.length;e<t;++e)r[a+e]=o[e];n.resolve()})),n.promise}let _supportsFullscreen;Iau2006XysData.prototype.preload=function(e,t,n,i){const r=getDaysSinceEpoch(this,e,t),o=getDaysSinceEpoch(this,n,i);let a=r/this._stepSizeDays-this._interpolationOrder/2|0;a<0&&(a=0);let s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);const c=a/this._samplesPerXysFile|0,l=s/this._samplesPerXysFile|0,u=[];for(let e=c;e<=l;++e)u.push(requestXysChunk(this,e));return when.all(u)},Iau2006XysData.prototype.computeXysRadians=function(e,t,n){const i=getDaysSinceEpoch(this,e,t);if(i<0)return;const r=i/this._stepSizeDays|0;if(r>=this._totalSamples)return;const o=this._interpolationOrder;let a=r-(o/2|0);a<0&&(a=0);let s=a+o;s>=this._totalSamples&&(s=this._totalSamples-1,a=s-o,a<0&&(a=0));let c=!1;const l=this._samples;if(defined(l[3*a])||(requestXysChunk(this,a/this._samplesPerXysFile|0),c=!0),defined(l[3*s])||(requestXysChunk(this,s/this._samplesPerXysFile|0),c=!0),c)return;defined(n)?(n.x=0,n.y=0,n.s=0):n=new Iau2006XysSample(0,0,0);const u=i-a*this._stepSizeDays,d=this._work,h=this._denominators,p=this._coef,f=this._xTable;let m,g;for(m=0;m<=o;++m)d[m]=u-f[m];for(m=0;m<=o;++m){for(p[m]=1,g=0;g<=o;++g)g!==m&&(p[m]*=d[g]);p[m]*=h[m];let e=3*(a+m);n.x+=p[m]*l[e++],n.y+=p[m]*l[e++],n.s+=p[m]*l[e]}return n};const _names={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Fullscreen={};let theNavigator,isChromeResult,chromeVersionResult,isSafariResult,safariVersionResult,isWebkitResult,webkitVersionResult,isInternetExplorerResult,internetExplorerVersionResult,isEdgeResult,edgeVersionResult,isFirefoxResult,firefoxVersionResult,isWindowsResult,hasPointerEvents,imageRenderingValueResult,supportsImageRenderingPixelatedResult;function extractVersion(e){const t=e.split(".");for(let e=0,n=t.length;e<n;++e)t[e]=parseInt(t[e],10);return t}function isChrome(){if(!defined(isChromeResult)&&(isChromeResult=!1,!isEdge())){const e=/ Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isChromeResult=!0,chromeVersionResult=extractVersion(e[1]))}return isChromeResult}function chromeVersion(){return isChrome()&&chromeVersionResult}function isSafari(){if(!defined(isSafariResult)&&(isSafariResult=!1,!isChrome()&&!isEdge()&&/ Safari\/[\.0-9]+/.test(theNavigator.userAgent))){const e=/ Version\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isSafariResult=!0,safariVersionResult=extractVersion(e[1]))}return isSafariResult}function safariVersion(){return isSafari()&&safariVersionResult}function isWebkit(){if(!defined(isWebkitResult)){isWebkitResult=!1;const e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);null!==e&&(isWebkitResult=!0,webkitVersionResult=extractVersion(e[1]),webkitVersionResult.isNightly=!!e[2])}return isWebkitResult}function webkitVersion(){return isWebkit()&&webkitVersionResult}function isInternetExplorer(){if(!defined(isInternetExplorerResult)){let e;isInternetExplorerResult=!1,"Microsoft Internet Explorer"===theNavigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent),null!==e&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1]))):"Netscape"===theNavigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent),null!==e&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])))}return isInternetExplorerResult}function internetExplorerVersion(){return isInternetExplorer()&&internetExplorerVersionResult}function isEdge(){if(!defined(isEdgeResult)){isEdgeResult=!1;const e=/ Edge\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isEdgeResult=!0,edgeVersionResult=extractVersion(e[1]))}return isEdgeResult}function edgeVersion(){return isEdge()&&edgeVersionResult}function isFirefox(){if(!defined(isFirefoxResult)){isFirefoxResult=!1;const e=/Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isFirefoxResult=!0,firefoxVersionResult=extractVersion(e[1]))}return isFirefoxResult}function isWindows(){return defined(isWindowsResult)||(isWindowsResult=/Windows/i.test(theNavigator.appVersion)),isWindowsResult}function firefoxVersion(){return isFirefox()&&firefoxVersionResult}function supportsPointerEvents(){return defined(hasPointerEvents)||(hasPointerEvents=!isFirefox()&&"undefined"!=typeof PointerEvent&&(!defined(theNavigator.pointerEnabled)||theNavigator.pointerEnabled)),hasPointerEvents}function supportsImageRenderingPixelated(){if(!defined(supportsImageRenderingPixelatedResult)){const e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");const t=e.style.imageRendering;supportsImageRenderingPixelatedResult=defined(t)&&""!==t,supportsImageRenderingPixelatedResult&&(imageRenderingValueResult=t)}return supportsImageRenderingPixelatedResult}function imageRenderingValue(){return supportsImageRenderingPixelated()?imageRenderingValueResult:void 0}function supportsWebP(){return supportsWebP._result}Object.defineProperties(Fullscreen,{element:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenElement]}},changeEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenchange}},errorEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenerror}},enabled:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenEnabled]}},fullscreen:{get:function(){if(Fullscreen.supportsFullscreen())return null!==Fullscreen.element}}}),Fullscreen.supportsFullscreen=function(){if(defined(_supportsFullscreen))return _supportsFullscreen;_supportsFullscreen=!1;const e=document.body;if("function"==typeof e.requestFullscreen)return _names.requestFullscreen="requestFullscreen",_names.exitFullscreen="exitFullscreen",_names.fullscreenEnabled="fullscreenEnabled",_names.fullscreenElement="fullscreenElement",_names.fullscreenchange="fullscreenchange",_names.fullscreenerror="fullscreenerror",_supportsFullscreen=!0,_supportsFullscreen;const t=["webkit","moz","o","ms","khtml"];let n;for(let i=0,r=t.length;i<r;++i){const r=t[i];n=`${r}RequestFullscreen`,"function"==typeof e[n]?(_names.requestFullscreen=n,_supportsFullscreen=!0):(n=`${r}RequestFullScreen`,"function"==typeof e[n]&&(_names.requestFullscreen=n,_supportsFullscreen=!0)),n=`${r}ExitFullscreen`,"function"==typeof document[n]?_names.exitFullscreen=n:(n=`${r}CancelFullScreen`,"function"==typeof document[n]&&(_names.exitFullscreen=n)),n=`${r}FullscreenEnabled`,void 0!==document[n]?_names.fullscreenEnabled=n:(n=`${r}FullScreenEnabled`,void 0!==document[n]&&(_names.fullscreenEnabled=n)),n=`${r}FullscreenElement`,void 0!==document[n]?_names.fullscreenElement=n:(n=`${r}FullScreenElement`,void 0!==document[n]&&(_names.fullscreenElement=n)),n=`${r}fullscreenchange`,void 0!==document[`on${n}`]&&("ms"===r&&(n="MSFullscreenChange"),_names.fullscreenchange=n),n=`${r}fullscreenerror`,void 0!==document[`on${n}`]&&("ms"===r&&(n="MSFullscreenError"),_names.fullscreenerror=n)}return _supportsFullscreen},Fullscreen.requestFullscreen=function(e,t){Fullscreen.supportsFullscreen()&&e[_names.requestFullscreen]({vrDisplay:t})},Fullscreen.exitFullscreen=function(){Fullscreen.supportsFullscreen()&&document[_names.exitFullscreen]()},Fullscreen._names=_names,theNavigator="undefined"!=typeof navigator?navigator:{},supportsWebP._promise=void 0,supportsWebP._result=void 0,supportsWebP.initialize=function(){if(defined(supportsWebP._promise))return supportsWebP._promise;const e=when.defer();if(supportsWebP._promise=e.promise,isEdge())return supportsWebP._result=!1,e.resolve(supportsWebP._result),e.promise;const t=new Image;return t.onload=function(){supportsWebP._result=t.width>0&&t.height>0,e.resolve(supportsWebP._result)},t.onerror=function(){supportsWebP._result=!1,e.resolve(supportsWebP._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},Object.defineProperties(supportsWebP,{initialized:{get:function(){return defined(supportsWebP._result)}}});const typedArrayTypes=[];"undefined"!=typeof ArrayBuffer&&(typedArrayTypes.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof BigInt64Array&&typedArrayTypes.push(BigInt64Array),"undefined"!=typeof BigUint64Array&&typedArrayTypes.push(BigUint64Array));const FeatureDetection={isChrome:isChrome,chromeVersion:chromeVersion,isSafari:isSafari,safariVersion:safariVersion,isWebkit:isWebkit,webkitVersion:webkitVersion,isInternetExplorer:isInternetExplorer,internetExplorerVersion:internetExplorerVersion,isEdge:isEdge,edgeVersion:edgeVersion,isFirefox:isFirefox,firefoxVersion:firefoxVersion,isWindows:isWindows,hardwareConcurrency:defaultValue(theNavigator.hardwareConcurrency,3),supportsPointerEvents:supportsPointerEvents,supportsImageRenderingPixelated:supportsImageRenderingPixelated,supportsWebP:supportsWebP,imageRenderingValue:imageRenderingValue,typedArrayTypes:typedArrayTypes};function Quaternion(e,t,n,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(n,0),this.w=defaultValue(i,0)}FeatureDetection.supportsBasis=function(e){return FeatureDetection.supportsWebAssembly()&&e.context.supportsBasis},FeatureDetection.supportsFullscreen=function(){return Fullscreen.supportsFullscreen()},FeatureDetection.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},FeatureDetection.supportsBigInt64Array=function(){return"undefined"!=typeof BigInt64Array},FeatureDetection.supportsBigUint64Array=function(){return"undefined"!=typeof BigUint64Array},FeatureDetection.supportsBigInt=function(){return"undefined"!=typeof BigInt},FeatureDetection.supportsWebWorkers=function(){return"undefined"!=typeof Worker},FeatureDetection.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!FeatureDetection.isEdge()};let fromAxisAngleScratch=new Cartesian3;Quaternion.fromAxisAngle=function(e,t,n){const i=t/2,r=Math.sin(i);fromAxisAngleScratch=Cartesian3.normalize(e,fromAxisAngleScratch);const o=fromAxisAngleScratch.x*r,a=fromAxisAngleScratch.y*r,s=fromAxisAngleScratch.z*r,c=Math.cos(i);return defined(n)?(n.x=o,n.y=a,n.z=s,n.w=c,n):new Quaternion(o,a,s,c)};const fromRotationMatrixNext=[1,2,0],fromRotationMatrixQuat=new Array(3);Quaternion.fromRotationMatrix=function(e,t){let n,i,r,o,a;const s=e[Matrix3.COLUMN0ROW0],c=e[Matrix3.COLUMN1ROW1],l=e[Matrix3.COLUMN2ROW2],u=s+c+l;if(u>0)n=Math.sqrt(u+1),a=.5*n,n=.5/n,i=(e[Matrix3.COLUMN1ROW2]-e[Matrix3.COLUMN2ROW1])*n,r=(e[Matrix3.COLUMN2ROW0]-e[Matrix3.COLUMN0ROW2])*n,o=(e[Matrix3.COLUMN0ROW1]-e[Matrix3.COLUMN1ROW0])*n;else{const t=fromRotationMatrixNext;let u=0;c>s&&(u=1),l>s&&l>c&&(u=2);const d=t[u],h=t[d];n=Math.sqrt(e[Matrix3.getElementIndex(u,u)]-e[Matrix3.getElementIndex(d,d)]-e[Matrix3.getElementIndex(h,h)]+1);const p=fromRotationMatrixQuat;p[u]=.5*n,n=.5/n,a=(e[Matrix3.getElementIndex(h,d)]-e[Matrix3.getElementIndex(d,h)])*n,p[d]=(e[Matrix3.getElementIndex(d,u)]+e[Matrix3.getElementIndex(u,d)])*n,p[h]=(e[Matrix3.getElementIndex(h,u)]+e[Matrix3.getElementIndex(u,h)])*n,i=-p[0],r=-p[1],o=-p[2]}return defined(t)?(t.x=i,t.y=r,t.z=o,t.w=a,t):new Quaternion(i,r,o,a)};const scratchHPRQuaternion$1=new Quaternion;let scratchHeadingQuaternion=new Quaternion,scratchPitchQuaternion=new Quaternion,scratchRollQuaternion=new Quaternion;Quaternion.fromHeadingPitchRoll=function(e,t){return scratchRollQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_X,e.roll,scratchHPRQuaternion$1),scratchPitchQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Y,-e.pitch,t),t=Quaternion.multiply(scratchPitchQuaternion,scratchRollQuaternion,scratchPitchQuaternion),scratchHeadingQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-e.heading,scratchHPRQuaternion$1),Quaternion.multiply(scratchHeadingQuaternion,t,t)};const sampledQuaternionAxis=new Cartesian3,sampledQuaternionRotation=new Cartesian3,sampledQuaternionTempQuaternion=new Quaternion,sampledQuaternionQuaternion0=new Quaternion,sampledQuaternionQuaternion0Conjugate=new Quaternion;Quaternion.packedLength=4,Quaternion.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},Quaternion.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Quaternion),n.x=e[t],n.y=e[t+1],n.z=e[t+2],n.w=e[t+3],n},Quaternion.packedInterpolationLength=3,Quaternion.convertPackedArrayForInterpolation=function(e,t,n,i){Quaternion.unpack(e,4*n,sampledQuaternionQuaternion0Conjugate),Quaternion.conjugate(sampledQuaternionQuaternion0Conjugate,sampledQuaternionQuaternion0Conjugate);for(let r=0,o=n-t+1;r<o;r++){const n=3*r;Quaternion.unpack(e,4*(t+r),sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0Conjugate,sampledQuaternionTempQuaternion),sampledQuaternionTempQuaternion.w<0&&Quaternion.negate(sampledQuaternionTempQuaternion,sampledQuaternionTempQuaternion),Quaternion.computeAxis(sampledQuaternionTempQuaternion,sampledQuaternionAxis);const o=Quaternion.computeAngle(sampledQuaternionTempQuaternion);defined(i)||(i=[]),i[n]=sampledQuaternionAxis.x*o,i[n+1]=sampledQuaternionAxis.y*o,i[n+2]=sampledQuaternionAxis.z*o}},Quaternion.unpackInterpolationResult=function(e,t,n,i,r){defined(r)||(r=new Quaternion),Cartesian3.fromArray(e,0,sampledQuaternionRotation);const o=Cartesian3.magnitude(sampledQuaternionRotation);return Quaternion.unpack(t,4*i,sampledQuaternionQuaternion0),0===o?Quaternion.clone(Quaternion.IDENTITY,sampledQuaternionTempQuaternion):Quaternion.fromAxisAngle(sampledQuaternionRotation,o,sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0,r)},Quaternion.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Quaternion(e.x,e.y,e.z,e.w)},Quaternion.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},Quaternion.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Quaternion.magnitude=function(e){return Math.sqrt(Quaternion.magnitudeSquared(e))},Quaternion.normalize=function(e,t){const n=1/Quaternion.magnitude(e),i=e.x*n,r=e.y*n,o=e.z*n,a=e.w*n;return t.x=i,t.y=r,t.z=o,t.w=a,t},Quaternion.inverse=function(e,t){const n=Quaternion.magnitudeSquared(e);return t=Quaternion.conjugate(e,t),Quaternion.multiplyByScalar(t,1/n,t)},Quaternion.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},Quaternion.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},Quaternion.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Quaternion.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Quaternion.multiply=function(e,t,n){const i=e.x,r=e.y,o=e.z,a=e.w,s=t.x,c=t.y,l=t.z,u=t.w,d=a*s+i*u+r*l-o*c,h=a*c-i*l+r*u+o*s,p=a*l+i*c-r*s+o*u,f=a*u-i*s-r*c-o*l;return n.x=d,n.y=h,n.z=p,n.w=f,n},Quaternion.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},Quaternion.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},Quaternion.computeAxis=function(e,t){const n=e.w;if(Math.abs(n-1)<CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;const i=1/Math.sqrt(1-n*n);return t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t},Quaternion.computeAngle=function(e){return Math.abs(e.w-1)<CesiumMath.EPSILON6?0:2*Math.acos(e.w)};let lerpScratch=new Quaternion;Quaternion.lerp=function(e,t,n,i){return lerpScratch=Quaternion.multiplyByScalar(t,n,lerpScratch),i=Quaternion.multiplyByScalar(e,1-n,i),Quaternion.add(lerpScratch,i,i)};let slerpEndNegated=new Quaternion,slerpScaledP=new Quaternion,slerpScaledR=new Quaternion;Quaternion.slerp=function(e,t,n,i){let r=Quaternion.dot(e,t),o=t;if(r<0&&(r=-r,o=slerpEndNegated=Quaternion.negate(t,slerpEndNegated)),1-r<CesiumMath.EPSILON6)return Quaternion.lerp(e,o,n,i);const a=Math.acos(r);return slerpScaledP=Quaternion.multiplyByScalar(e,Math.sin((1-n)*a),slerpScaledP),slerpScaledR=Quaternion.multiplyByScalar(o,Math.sin(n*a),slerpScaledR),i=Quaternion.add(slerpScaledP,slerpScaledR,i),Quaternion.multiplyByScalar(i,1/Math.sin(a),i)},Quaternion.log=function(e,t){const n=CesiumMath.acosClamped(e.w);let i=0;return 0!==n&&(i=n/Math.sin(n)),Cartesian3.multiplyByScalar(e,i,t)},Quaternion.exp=function(e,t){const n=Cartesian3.magnitude(e);let i=0;return 0!==n&&(i=Math.sin(n)/n),t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t.w=Math.cos(n),t};const squadScratchCartesian0=new Cartesian3,squadScratchCartesian1=new Cartesian3,squadScratchQuaternion0=new Quaternion,squadScratchQuaternion1=new Quaternion;Quaternion.computeInnerQuadrangle=function(e,t,n,i){const r=Quaternion.conjugate(t,squadScratchQuaternion0);Quaternion.multiply(r,n,squadScratchQuaternion1);const o=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian0);Quaternion.multiply(r,e,squadScratchQuaternion1);const a=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian1);return Cartesian3.add(o,a,o),Cartesian3.multiplyByScalar(o,.25,o),Cartesian3.negate(o,o),Quaternion.exp(o,squadScratchQuaternion0),Quaternion.multiply(t,squadScratchQuaternion0,i)},Quaternion.squad=function(e,t,n,i,r,o){const a=Quaternion.slerp(e,t,r,squadScratchQuaternion0),s=Quaternion.slerp(n,i,r,squadScratchQuaternion1);return Quaternion.slerp(a,s,2*r*(1-r),o)};const fastSlerpScratchQuaternion=new Quaternion,opmu=1.9011074535173003,u=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],v=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bT=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bD=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[];for(let e=0;e<7;++e){const t=e+1,n=2*t+1;u[e]=1/(t*n),v[e]=t/n}u[7]=opmu/136,v[7]=8*opmu/17,Quaternion.fastSlerp=function(e,t,n,i){let r,o=Quaternion.dot(e,t);o>=0?r=1:(r=-1,o=-o);const a=o-1,s=1-n,c=n*n,l=s*s;for(let e=7;e>=0;--e)bT[e]=(u[e]*c-v[e])*a,bD[e]=(u[e]*l-v[e])*a;const d=r*n*(1+bT[0]*(1+bT[1]*(1+bT[2]*(1+bT[3]*(1+bT[4]*(1+bT[5]*(1+bT[6]*(1+bT[7])))))))),h=s*(1+bD[0]*(1+bD[1]*(1+bD[2]*(1+bD[3]*(1+bD[4]*(1+bD[5]*(1+bD[6]*(1+bD[7])))))))),p=Quaternion.multiplyByScalar(e,h,fastSlerpScratchQuaternion);return Quaternion.multiplyByScalar(t,d,i),Quaternion.add(p,i,i)},Quaternion.fastSquad=function(e,t,n,i,r,o){const a=Quaternion.fastSlerp(e,t,r,squadScratchQuaternion0),s=Quaternion.fastSlerp(n,i,r,squadScratchQuaternion1);return Quaternion.fastSlerp(a,s,2*r*(1-r),o)},Quaternion.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Quaternion.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},Quaternion.ZERO=Object.freeze(new Quaternion(0,0,0,0)),Quaternion.IDENTITY=Object.freeze(new Quaternion(0,0,0,1)),Quaternion.prototype.clone=function(e){return Quaternion.clone(this,e)},Quaternion.prototype.equals=function(e){return Quaternion.equals(this,e)},Quaternion.prototype.equalsEpsilon=function(e,t){return Quaternion.equalsEpsilon(this,e,t)},Quaternion.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z}, ${this.w})`};const Transforms={},vectorProductLocalFrame={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},degeneratePositionLocalFrame={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},localFrameToFixedFrameCache={},scratchCalculateCartesian={east:new Cartesian3,north:new Cartesian3,up:new Cartesian3,west:new Cartesian3,south:new Cartesian3,down:new Cartesian3};let scratchFirstCartesian=new Cartesian3,scratchSecondCartesian=new Cartesian3,scratchThirdCartesian=new Cartesian3;Transforms.localFrameToFixedFrameGenerator=function(e,t){if(!vectorProductLocalFrame.hasOwnProperty(e)||!vectorProductLocalFrame[e].hasOwnProperty(t))throw new DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");const n=vectorProductLocalFrame[e][t];let i;const r=e+t;return defined(localFrameToFixedFrameCache[r])?i=localFrameToFixedFrameCache[r]:(i=function(i,r,o){if(defined(o)||(o=new Matrix4),Cartesian3.equalsEpsilon(i,Cartesian3.ZERO,CesiumMath.EPSILON14))Cartesian3.unpack(degeneratePositionLocalFrame[e],0,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[t],0,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchThirdCartesian);else if(CesiumMath.equalsEpsilon(i.x,0,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(i.y,0,CesiumMath.EPSILON14)){const r=CesiumMath.sign(i.z);Cartesian3.unpack(degeneratePositionLocalFrame[e],0,scratchFirstCartesian),"east"!==e&&"west"!==e&&Cartesian3.multiplyByScalar(scratchFirstCartesian,r,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[t],0,scratchSecondCartesian),"east"!==t&&"west"!==t&&Cartesian3.multiplyByScalar(scratchSecondCartesian,r,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchThirdCartesian),"east"!==n&&"west"!==n&&Cartesian3.multiplyByScalar(scratchThirdCartesian,r,scratchThirdCartesian)}else{(r=defaultValue(r,Ellipsoid.WGS84)).geodeticSurfaceNormal(i,scratchCalculateCartesian.up);const o=scratchCalculateCartesian.up,a=scratchCalculateCartesian.east;a.x=-i.y,a.y=i.x,a.z=0,Cartesian3.normalize(a,scratchCalculateCartesian.east),Cartesian3.cross(o,a,scratchCalculateCartesian.north),Cartesian3.multiplyByScalar(scratchCalculateCartesian.up,-1,scratchCalculateCartesian.down),Cartesian3.multiplyByScalar(scratchCalculateCartesian.east,-1,scratchCalculateCartesian.west),Cartesian3.multiplyByScalar(scratchCalculateCartesian.north,-1,scratchCalculateCartesian.south),scratchFirstCartesian=scratchCalculateCartesian[e],scratchSecondCartesian=scratchCalculateCartesian[t],scratchThirdCartesian=scratchCalculateCartesian[n]}return o[0]=scratchFirstCartesian.x,o[1]=scratchFirstCartesian.y,o[2]=scratchFirstCartesian.z,o[3]=0,o[4]=scratchSecondCartesian.x,o[5]=scratchSecondCartesian.y,o[6]=scratchSecondCartesian.z,o[7]=0,o[8]=scratchThirdCartesian.x,o[9]=scratchThirdCartesian.y,o[10]=scratchThirdCartesian.z,o[11]=0,o[12]=i.x,o[13]=i.y,o[14]=i.z,o[15]=1,o},localFrameToFixedFrameCache[r]=i),i},Transforms.eastNorthUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("east","north"),Transforms.northEastDownToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","east"),Transforms.northUpEastToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","up"),Transforms.northWestUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","west");const scratchHPRQuaternion=new Quaternion,scratchScale$5=new Cartesian3(1,1,1),scratchHPRMatrix4=new Matrix4;Transforms.headingPitchRollToFixedFrame=function(e,t,n,i,r){i=defaultValue(i,Transforms.eastNorthUpToFixedFrame);const o=Quaternion.fromHeadingPitchRoll(t,scratchHPRQuaternion),a=Matrix4.fromTranslationQuaternionRotationScale(Cartesian3.ZERO,o,scratchScale$5,scratchHPRMatrix4);return r=i(e,n,r),Matrix4.multiply(r,a,r)};const scratchENUMatrix4=new Matrix4,scratchHPRMatrix3=new Matrix3;Transforms.headingPitchRollQuaternion=function(e,t,n,i,r){const o=Transforms.headingPitchRollToFixedFrame(e,t,n,i,scratchENUMatrix4),a=Matrix4.getMatrix3(o,scratchHPRMatrix3);return Quaternion.fromRotationMatrix(a,r)};const noScale=new Cartesian3(1,1,1),hprCenterScratch=new Cartesian3,ffScratch=new Matrix4,hprTransformScratch=new Matrix4,hprRotationScratch=new Matrix3,hprQuaternionScratch=new Quaternion;Transforms.fixedFrameToHeadingPitchRoll=function(e,t,n,i){t=defaultValue(t,Ellipsoid.WGS84),n=defaultValue(n,Transforms.eastNorthUpToFixedFrame),defined(i)||(i=new HeadingPitchRoll);const r=Matrix4.getTranslation(e,hprCenterScratch);if(Cartesian3.equals(r,Cartesian3.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;let o=Matrix4.inverseTransformation(n(r,t,ffScratch),ffScratch),a=Matrix4.setScale(e,noScale,hprTransformScratch);a=Matrix4.setTranslation(a,Cartesian3.ZERO,a),o=Matrix4.multiply(o,a,o);let s=Quaternion.fromRotationMatrix(Matrix4.getMatrix3(o,hprRotationScratch),hprQuaternionScratch);return s=Quaternion.normalize(s,s),HeadingPitchRoll.fromQuaternion(s,i)};const gmstConstant0=24110.54841,gmstConstant1=8640184.812866,gmstConstant2=.093104,gmstConstant3=-62e-7,rateCoef=11772758384668e-32,wgs84WRPrecessing=72921158553e-15,twoPiOverSecondsInDay=CesiumMath.TWO_PI/86400;let dateInUtc=new JulianDate;Transforms.computeTemeToPseudoFixedMatrix=function(e,t){dateInUtc=JulianDate.addSeconds(e,-JulianDate.computeTaiMinusUtc(e),dateInUtc);const n=dateInUtc.dayNumber,i=dateInUtc.secondsOfDay;let r;const o=n-2451545;r=i>=43200?(o+.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY:(o-.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY;const a=(gmstConstant0+r*(gmstConstant1+r*(gmstConstant2+r*gmstConstant3)))*twoPiOverSecondsInDay%CesiumMath.TWO_PI+(wgs84WRPrecessing+rateCoef*(n-2451545.5))*((i+.5*TimeConstants$1.SECONDS_PER_DAY)%TimeConstants$1.SECONDS_PER_DAY),s=Math.cos(a),c=Math.sin(a);return defined(t)?(t[0]=s,t[1]=-c,t[2]=0,t[3]=c,t[4]=s,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(s,c,0,-c,s,0,0,0,1)},Transforms.iau2006XysData=new Iau2006XysData,Transforms.earthOrientationParameters=EarthOrientationParameters.NONE;const ttMinusTai=32.184,j2000ttDays=2451545;Transforms.preloadIcrfFixed=function(e){const t=e.start.dayNumber,n=e.start.secondsOfDay+ttMinusTai,i=e.stop.dayNumber,r=e.stop.secondsOfDay+ttMinusTai,o=Transforms.iau2006XysData.preload(t,n,i,r),a=Transforms.earthOrientationParameters.getPromiseToLoad();return when.all([o,a])},Transforms.computeIcrfToFixedMatrix=function(e,t){defined(t)||(t=new Matrix3);const n=Transforms.computeFixedToIcrfMatrix(e,t);if(defined(n))return Matrix3.transpose(n,t)};const xysScratch=new Iau2006XysSample(0,0,0),eopScratch=new EarthOrientationParametersSample(0,0,0,0,0,0),rotation1Scratch=new Matrix3,rotation2Scratch=new Matrix3;Transforms.computeFixedToIcrfMatrix=function(e,t){defined(t)||(t=new Matrix3);const n=Transforms.earthOrientationParameters.compute(e,eopScratch);if(!defined(n))return;const i=e.dayNumber,r=e.secondsOfDay+ttMinusTai,o=Transforms.iau2006XysData.computeXysRadians(i,r,xysScratch);if(!defined(o))return;const a=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-a*a-s*s)),l=rotation1Scratch;l[0]=1-c*a*a,l[3]=-c*a*s,l[6]=a,l[1]=-c*a*s,l[4]=1-c*s*s,l[7]=s,l[2]=-a,l[5]=-s,l[8]=1-c*(a*a+s*s);const u=Matrix3.fromRotationZ(-o.s,rotation2Scratch),d=Matrix3.multiply(l,u,rotation1Scratch),h=e.dayNumber-2451545,p=(e.secondsOfDay-JulianDate.computeTaiMinusUtc(e)+n.ut1MinusUtc)/TimeConstants$1.SECONDS_PER_DAY;let f=.779057273264+p+.00273781191135448*(h+p);f=f%1*CesiumMath.TWO_PI;const m=Matrix3.fromRotationZ(f,rotation2Scratch),g=Matrix3.multiply(d,m,rotation1Scratch),_=Math.cos(n.xPoleWander),y=Math.cos(n.yPoleWander),C=Math.sin(n.xPoleWander),T=Math.sin(n.yPoleWander);let S=i-j2000ttDays+r/TimeConstants$1.SECONDS_PER_DAY;S/=36525;const A=-47e-6*S*CesiumMath.RADIANS_PER_DEGREE/3600,v=Math.cos(A),E=Math.sin(A),b=rotation2Scratch;return b[0]=_*v,b[1]=_*E,b[2]=C,b[3]=-y*E+T*C*v,b[4]=y*v+T*C*E,b[5]=-T*_,b[6]=-T*E-y*C*v,b[7]=T*v-y*C*E,b[8]=y*_,Matrix3.multiply(g,b,t)};const pointToWindowCoordinatesTemp=new Cartesian4;Transforms.pointToWindowCoordinates=function(e,t,n,i){return(i=Transforms.pointToGLWindowCoordinates(e,t,n,i)).y=2*t[5]-i.y,i},Transforms.pointToGLWindowCoordinates=function(e,t,n,i){defined(i)||(i=new Cartesian2);const r=pointToWindowCoordinatesTemp;return Matrix4.multiplyByVector(e,Cartesian4.fromElements(n.x,n.y,n.z,1,r),r),Cartesian4.multiplyByScalar(r,1/r.w,r),Matrix4.multiplyByVector(t,r,r),Cartesian2.fromCartesian4(r,i)};const normalScratch$5=new Cartesian3,rightScratch$1=new Cartesian3,upScratch=new Cartesian3;Transforms.rotationMatrixFromPositionVelocity=function(e,t,n,i){const r=defaultValue(n,Ellipsoid.WGS84).geodeticSurfaceNormal(e,normalScratch$5);let o=Cartesian3.cross(t,r,rightScratch$1);Cartesian3.equalsEpsilon(o,Cartesian3.ZERO,CesiumMath.EPSILON6)&&(o=Cartesian3.clone(Cartesian3.UNIT_X,o));const a=Cartesian3.cross(o,t,upScratch);return Cartesian3.normalize(a,a),Cartesian3.cross(t,a,o),Cartesian3.negate(o,o),Cartesian3.normalize(o,o),defined(i)||(i=new Matrix3),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=o.x,i[4]=o.y,i[5]=o.z,i[6]=a.x,i[7]=a.y,i[8]=a.z,i};const swizzleMatrix=new Matrix4(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),scratchCartographic$h=new Cartographic,scratchCartesian3Projection$1=new Cartesian3,scratchCenter$8=new Cartesian3,scratchRotation$2=new Matrix3,scratchFromENU=new Matrix4,scratchToENU=new Matrix4;Transforms.basisTo2D=function(e,t,n){const i=Matrix4.getTranslation(t,scratchCenter$8),r=e.ellipsoid,o=r.cartesianToCartographic(i,scratchCartographic$h),a=e.project(o,scratchCartesian3Projection$1);Cartesian3.fromElements(a.z,a.x,a.y,a);const s=Transforms.eastNorthUpToFixedFrame(i,r,scratchFromENU),c=Matrix4.inverseTransformation(s,scratchToENU),l=Matrix4.getMatrix3(t,scratchRotation$2),u=Matrix4.multiplyByMatrix3(c,l,n);return Matrix4.multiply(swizzleMatrix,u,n),Matrix4.setTranslation(n,a,n),n},Transforms.wgs84To2DModelMatrix=function(e,t,n){const i=e.ellipsoid,r=Transforms.eastNorthUpToFixedFrame(t,i,scratchFromENU),o=Matrix4.inverseTransformation(r,scratchToENU),a=i.cartesianToCartographic(t,scratchCartographic$h),s=e.project(a,scratchCartesian3Projection$1);Cartesian3.fromElements(s.z,s.x,s.y,s);const c=Matrix4.fromTranslation(s,scratchFromENU);return Matrix4.multiply(swizzleMatrix,o,n),Matrix4.multiply(c,n,n),n};const scratchCart4=new Cartesian4;function EllipsoidTangentPlane(e,t){e=(t=defaultValue(t,Ellipsoid.WGS84)).scaleToGeodeticSurface(e);const n=Transforms.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(n,0,scratchCart4)),this._yAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(n,1,scratchCart4));const i=Cartesian3.fromCartesian4(Matrix4.getColumn(n,2,scratchCart4));this._plane=Plane.fromPointNormal(e,i)}Object.defineProperties(EllipsoidTangentPlane.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});const tmp=new AxisAlignedBoundingBox;EllipsoidTangentPlane.fromPoints=function(e,t){return new EllipsoidTangentPlane(AxisAlignedBoundingBox.fromPoints(e,tmp).center,t)};const scratchProjectPointOntoPlaneRay=new Ray,scratchProjectPointOntoPlaneCartesian3=new Cartesian3;EllipsoidTangentPlane.prototype.projectPointOntoPlane=function(e,t){const n=scratchProjectPointOntoPlaneRay;n.origin=e,Cartesian3.normalize(e,n.direction);let i=IntersectionTests.rayPlane(n,this._plane,scratchProjectPointOntoPlaneCartesian3);if(defined(i)||(Cartesian3.negate(n.direction,n.direction),i=IntersectionTests.rayPlane(n,this._plane,scratchProjectPointOntoPlaneCartesian3)),defined(i)){const e=Cartesian3.subtract(i,this._origin,i),n=Cartesian3.dot(this._xAxis,e),r=Cartesian3.dot(this._yAxis,e);return defined(t)?(t.x=n,t.y=r,t):new Cartesian2(n,r)}},EllipsoidTangentPlane.prototype.projectPointsOntoPlane=function(e,t){defined(t)||(t=[]);let n=0;const i=e.length;for(let r=0;r<i;r++){const i=this.projectPointOntoPlane(e[r],t[n]);defined(i)&&(t[n]=i,n++)}return t.length=n,t},EllipsoidTangentPlane.prototype.projectPointToNearestOnPlane=function(e,t){defined(t)||(t=new Cartesian2);const n=scratchProjectPointOntoPlaneRay;n.origin=e,Cartesian3.clone(this._plane.normal,n.direction);let i=IntersectionTests.rayPlane(n,this._plane,scratchProjectPointOntoPlaneCartesian3);defined(i)||(Cartesian3.negate(n.direction,n.direction),i=IntersectionTests.rayPlane(n,this._plane,scratchProjectPointOntoPlaneCartesian3));const r=Cartesian3.subtract(i,this._origin,i),o=Cartesian3.dot(this._xAxis,r),a=Cartesian3.dot(this._yAxis,r);return t.x=o,t.y=a,t},EllipsoidTangentPlane.prototype.projectPointsToNearestOnPlane=function(e,t){defined(t)||(t=[]);const n=e.length;t.length=n;for(let i=0;i<n;i++)t[i]=this.projectPointToNearestOnPlane(e[i],t[i]);return t};const projectPointsOntoEllipsoidScratch=new Cartesian3;function OrientedBoundingBox(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.halfAxes=Matrix3.clone(defaultValue(t,Matrix3.ZERO))}EllipsoidTangentPlane.prototype.projectPointOntoEllipsoid=function(e,t){defined(t)||(t=new Cartesian3);const n=this._ellipsoid,i=this._origin,r=this._xAxis,o=this._yAxis,a=projectPointsOntoEllipsoidScratch;return Cartesian3.multiplyByScalar(r,e.x,a),t=Cartesian3.add(i,a,t),Cartesian3.multiplyByScalar(o,e.y,a),Cartesian3.add(t,a,t),n.scaleToGeocentricSurface(t,t),t},EllipsoidTangentPlane.prototype.projectPointsOntoEllipsoid=function(e,t){const n=e.length;defined(t)?t.length=n:t=new Array(n);for(let i=0;i<n;++i)t[i]=this.projectPointOntoEllipsoid(e[i],t[i]);return t},OrientedBoundingBox.packedLength=Cartesian3.packedLength+Matrix3.packedLength,OrientedBoundingBox.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e.center,t,n),Matrix3.pack(e.halfAxes,t,n+Cartesian3.packedLength),t},OrientedBoundingBox.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new OrientedBoundingBox),Cartesian3.unpack(e,t,n.center),Matrix3.unpack(e,t+Cartesian3.packedLength,n.halfAxes),n};const scratchCartesian1$8=new Cartesian3,scratchCartesian2$b=new Cartesian3,scratchCartesian3$c=new Cartesian3,scratchCartesian4$6=new Cartesian3,scratchCartesian5$2=new Cartesian3,scratchCartesian6$1=new Cartesian3,scratchCovarianceResult=new Matrix3,scratchEigenResult={unitary:new Matrix3,diagonal:new Matrix3};OrientedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new OrientedBoundingBox),!defined(e)||0===e.length)return t.halfAxes=Matrix3.ZERO,t.center=Cartesian3.ZERO,t;let n;const i=e.length,r=Cartesian3.clone(e[0],scratchCartesian1$8);for(n=1;n<i;n++)Cartesian3.add(r,e[n],r);const o=1/i;Cartesian3.multiplyByScalar(r,o,r);let a,s=0,c=0,l=0,u=0,d=0,h=0;for(n=0;n<i;n++)a=Cartesian3.subtract(e[n],r,scratchCartesian2$b),s+=a.x*a.x,c+=a.x*a.y,l+=a.x*a.z,u+=a.y*a.y,d+=a.y*a.z,h+=a.z*a.z;s*=o,c*=o,l*=o,u*=o,d*=o,h*=o;const p=scratchCovarianceResult;p[0]=s,p[1]=c,p[2]=l,p[3]=c,p[4]=u,p[5]=d,p[6]=l,p[7]=d,p[8]=h;const f=Matrix3.computeEigenDecomposition(p,scratchEigenResult),m=Matrix3.clone(f.unitary,t.halfAxes);let g=Matrix3.getColumn(m,0,scratchCartesian4$6),_=Matrix3.getColumn(m,1,scratchCartesian5$2),y=Matrix3.getColumn(m,2,scratchCartesian6$1),C=-Number.MAX_VALUE,T=-Number.MAX_VALUE,S=-Number.MAX_VALUE,A=Number.MAX_VALUE,v=Number.MAX_VALUE,E=Number.MAX_VALUE;for(n=0;n<i;n++)a=e[n],C=Math.max(Cartesian3.dot(g,a),C),T=Math.max(Cartesian3.dot(_,a),T),S=Math.max(Cartesian3.dot(y,a),S),A=Math.min(Cartesian3.dot(g,a),A),v=Math.min(Cartesian3.dot(_,a),v),E=Math.min(Cartesian3.dot(y,a),E);g=Cartesian3.multiplyByScalar(g,.5*(A+C),g),_=Cartesian3.multiplyByScalar(_,.5*(v+T),_),y=Cartesian3.multiplyByScalar(y,.5*(E+S),y);const b=Cartesian3.add(g,_,t.center);Cartesian3.add(b,y,b);const x=scratchCartesian3$c;return x.x=C-A,x.y=T-v,x.z=S-E,Cartesian3.multiplyByScalar(x,.5,x),Matrix3.multiplyByScale(t.halfAxes,x,t.halfAxes),t};const scratchOffset=new Cartesian3,scratchScale$4=new Cartesian3;function fromPlaneExtents(e,t,n,i,r,o,a,s,c,l,u){defined(u)||(u=new OrientedBoundingBox);const d=u.halfAxes;Matrix3.setColumn(d,0,t,d),Matrix3.setColumn(d,1,n,d),Matrix3.setColumn(d,2,i,d);let h=scratchOffset;h.x=(r+o)/2,h.y=(a+s)/2,h.z=(c+l)/2;const p=scratchScale$4;p.x=(o-r)/2,p.y=(s-a)/2,p.z=(l-c)/2;const f=u.center;return h=Matrix3.multiplyByVector(d,h,h),Cartesian3.add(e,h,f),Matrix3.multiplyByScale(d,p,d),u}const scratchRectangleCenterCartographic=new Cartographic,scratchRectangleCenter=new Cartesian3,scratchPerimeterCartographicNC=new Cartographic,scratchPerimeterCartographicNW=new Cartographic,scratchPerimeterCartographicCW=new Cartographic,scratchPerimeterCartographicSW=new Cartographic,scratchPerimeterCartographicSC=new Cartographic,scratchPerimeterCartesianNC=new Cartesian3,scratchPerimeterCartesianNW=new Cartesian3,scratchPerimeterCartesianCW=new Cartesian3,scratchPerimeterCartesianSW=new Cartesian3,scratchPerimeterCartesianSC=new Cartesian3,scratchPerimeterProjectedNC=new Cartesian2,scratchPerimeterProjectedNW=new Cartesian2,scratchPerimeterProjectedCW=new Cartesian2,scratchPerimeterProjectedSW=new Cartesian2,scratchPerimeterProjectedSC=new Cartesian2,scratchPlaneOrigin=new Cartesian3,scratchPlaneNormal$1=new Cartesian3,scratchPlaneXAxis=new Cartesian3,scratchHorizonCartesian=new Cartesian3,scratchHorizonProjected=new Cartesian2,scratchMaxY=new Cartesian3,scratchMinY=new Cartesian3,scratchZ=new Cartesian3,scratchPlane$2=new Plane(Cartesian3.UNIT_X,0);OrientedBoundingBox.fromRectangle=function(e,t,n,i,r){let o,a,s,c,l,u,d;if(t=defaultValue(t,0),n=defaultValue(n,0),i=defaultValue(i,Ellipsoid.WGS84),e.width<=CesiumMath.PI){const h=Rectangle.center(e,scratchRectangleCenterCartographic),p=new EllipsoidTangentPlane(i.cartographicToCartesian(h,scratchRectangleCenter),i);d=p.plane;const f=h.longitude,m=e.south<0&&e.north>0?0:h.latitude,g=Cartographic.fromRadians(f,e.north,n,scratchPerimeterCartographicNC),_=Cartographic.fromRadians(e.west,e.north,n,scratchPerimeterCartographicNW),y=Cartographic.fromRadians(e.west,m,n,scratchPerimeterCartographicCW),C=Cartographic.fromRadians(e.west,e.south,n,scratchPerimeterCartographicSW),T=Cartographic.fromRadians(f,e.south,n,scratchPerimeterCartographicSC),S=i.cartographicToCartesian(g,scratchPerimeterCartesianNC);let A=i.cartographicToCartesian(_,scratchPerimeterCartesianNW);const v=i.cartographicToCartesian(y,scratchPerimeterCartesianCW);let E=i.cartographicToCartesian(C,scratchPerimeterCartesianSW);const b=i.cartographicToCartesian(T,scratchPerimeterCartesianSC),x=p.projectPointToNearestOnPlane(S,scratchPerimeterProjectedNC),P=p.projectPointToNearestOnPlane(A,scratchPerimeterProjectedNW),D=p.projectPointToNearestOnPlane(v,scratchPerimeterProjectedCW),w=p.projectPointToNearestOnPlane(E,scratchPerimeterProjectedSW),M=p.projectPointToNearestOnPlane(b,scratchPerimeterProjectedSC);return o=Math.min(P.x,D.x,w.x),a=-o,c=Math.max(P.y,x.y),s=Math.min(w.y,M.y),_.height=C.height=t,A=i.cartographicToCartesian(_,scratchPerimeterCartesianNW),E=i.cartographicToCartesian(C,scratchPerimeterCartesianSW),l=Math.min(Plane.getPointDistance(d,A),Plane.getPointDistance(d,E)),u=n,fromPlaneExtents(p.origin,p.xAxis,p.yAxis,p.zAxis,o,a,s,c,l,u,r)}const h=e.south>0,p=e.north<0,f=h?e.south:p?e.north:0,m=Rectangle.center(e,scratchRectangleCenterCartographic).longitude,g=Cartesian3.fromRadians(m,f,n,i,scratchPlaneOrigin);g.z=0;const _=Math.abs(g.x)<CesiumMath.EPSILON10&&Math.abs(g.y)<CesiumMath.EPSILON10?Cartesian3.UNIT_X:Cartesian3.normalize(g,scratchPlaneNormal$1),y=Cartesian3.UNIT_Z,C=Cartesian3.cross(_,y,scratchPlaneXAxis);d=Plane.fromPointNormal(g,_,scratchPlane$2);const T=Cartesian3.fromRadians(m+CesiumMath.PI_OVER_TWO,f,n,i,scratchHorizonCartesian);a=Cartesian3.dot(Plane.projectPointOntoPlane(d,T,scratchHorizonProjected),C),o=-a,c=Cartesian3.fromRadians(0,e.north,p?t:n,i,scratchMaxY).z,s=Cartesian3.fromRadians(0,e.south,h?t:n,i,scratchMinY).z;const S=Cartesian3.fromRadians(e.east,f,n,i,scratchZ);return l=Plane.getPointDistance(d,S),u=0,fromPlaneExtents(g,C,y,_,o,a,s,c,l,u,r)},OrientedBoundingBox.fromTransformation=function(e,t){return defined(t)||(t=new OrientedBoundingBox),t.center=Matrix4.getTranslation(e,t.center),t.halfAxes=Matrix4.getMatrix3(e,t.halfAxes),t.halfAxes=Matrix3.multiplyByScalar(t.halfAxes,.5,t.halfAxes),t},OrientedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(Cartesian3.clone(e.center,t.center),Matrix3.clone(e.halfAxes,t.halfAxes),t):new OrientedBoundingBox(e.center,e.halfAxes)},OrientedBoundingBox.intersectPlane=function(e,t){const n=e.center,i=t.normal,r=e.halfAxes,o=i.x,a=i.y,s=i.z,c=Math.abs(o*r[Matrix3.COLUMN0ROW0]+a*r[Matrix3.COLUMN0ROW1]+s*r[Matrix3.COLUMN0ROW2])+Math.abs(o*r[Matrix3.COLUMN1ROW0]+a*r[Matrix3.COLUMN1ROW1]+s*r[Matrix3.COLUMN1ROW2])+Math.abs(o*r[Matrix3.COLUMN2ROW0]+a*r[Matrix3.COLUMN2ROW1]+s*r[Matrix3.COLUMN2ROW2]),l=Cartesian3.dot(i,n)+t.distance;return l<=-c?Intersect$1.OUTSIDE:l>=c?Intersect$1.INSIDE:Intersect$1.INTERSECTING};const scratchCartesianU=new Cartesian3,scratchCartesianV=new Cartesian3,scratchCartesianW=new Cartesian3,scratchValidAxis2=new Cartesian3,scratchValidAxis3=new Cartesian3,scratchPPrime=new Cartesian3;OrientedBoundingBox.distanceSquaredTo=function(e,t){const n=Cartesian3.subtract(t,e.center,scratchOffset),i=e.halfAxes;let r=Matrix3.getColumn(i,0,scratchCartesianU),o=Matrix3.getColumn(i,1,scratchCartesianV),a=Matrix3.getColumn(i,2,scratchCartesianW);const s=Cartesian3.magnitude(r),c=Cartesian3.magnitude(o),l=Cartesian3.magnitude(a);let u=!0,d=!0,h=!0;s>0?Cartesian3.divideByScalar(r,s,r):u=!1,c>0?Cartesian3.divideByScalar(o,c,o):d=!1,l>0?Cartesian3.divideByScalar(a,l,a):h=!1;const p=!u+!d+!h;let f,m,g;if(1===p){let e=r;f=o,m=a,d?h||(e=a,m=r):(e=o,f=r),g=Cartesian3.cross(f,m,scratchValidAxis3),e===r?r=g:e===o?o=g:e===a&&(a=g)}else if(2===p){f=r,d?f=o:h&&(f=a);let e=Cartesian3.UNIT_Y;e.equalsEpsilon(f,CesiumMath.EPSILON3)&&(e=Cartesian3.UNIT_X),m=Cartesian3.cross(f,e,scratchValidAxis2),Cartesian3.normalize(m,m),g=Cartesian3.cross(f,m,scratchValidAxis3),Cartesian3.normalize(g,g),f===r?(o=m,a=g):f===o?(a=m,r=g):f===a&&(r=m,o=g)}else 3===p&&(r=Cartesian3.UNIT_X,o=Cartesian3.UNIT_Y,a=Cartesian3.UNIT_Z);const _=scratchPPrime;_.x=Cartesian3.dot(n,r),_.y=Cartesian3.dot(n,o),_.z=Cartesian3.dot(n,a);let y,C=0;return _.x<-s?(y=_.x+s,C+=y*y):_.x>s&&(y=_.x-s,C+=y*y),_.y<-c?(y=_.y+c,C+=y*y):_.y>c&&(y=_.y-c,C+=y*y),_.z<-l?(y=_.z+l,C+=y*y):_.z>l&&(y=_.z-l,C+=y*y),C};const scratchCorner=new Cartesian3,scratchToCenter$1=new Cartesian3;OrientedBoundingBox.computePlaneDistances=function(e,t,n,i){defined(i)||(i=new Interval);let r=Number.POSITIVE_INFINITY,o=Number.NEGATIVE_INFINITY;const a=e.center,s=e.halfAxes,c=Matrix3.getColumn(s,0,scratchCartesianU),l=Matrix3.getColumn(s,1,scratchCartesianV),u=Matrix3.getColumn(s,2,scratchCartesianW),d=Cartesian3.add(c,l,scratchCorner);Cartesian3.add(d,u,d),Cartesian3.add(d,a,d);const h=Cartesian3.subtract(d,t,scratchToCenter$1);let p=Cartesian3.dot(n,h);return r=Math.min(p,r),o=Math.max(p,o),Cartesian3.add(a,c,d),Cartesian3.add(d,l,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.add(a,c,d),Cartesian3.subtract(d,l,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.add(a,c,d),Cartesian3.subtract(d,l,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.subtract(a,c,d),Cartesian3.add(d,l,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.subtract(a,c,d),Cartesian3.add(d,l,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.subtract(a,c,d),Cartesian3.subtract(d,l,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),Cartesian3.subtract(a,c,d),Cartesian3.subtract(d,l,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(n,h),r=Math.min(p,r),o=Math.max(p,o),i.start=r,i.stop=o,i};const scratchXAxis$1=new Cartesian3,scratchYAxis$1=new Cartesian3,scratchZAxis$1=new Cartesian3;OrientedBoundingBox.computeCorners=function(e,t){defined(t)||(t=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3]);const n=e.center,i=e.halfAxes,r=Matrix3.getColumn(i,0,scratchXAxis$1),o=Matrix3.getColumn(i,1,scratchYAxis$1),a=Matrix3.getColumn(i,2,scratchZAxis$1);return Cartesian3.clone(n,t[0]),Cartesian3.subtract(t[0],r,t[0]),Cartesian3.subtract(t[0],o,t[0]),Cartesian3.subtract(t[0],a,t[0]),Cartesian3.clone(n,t[1]),Cartesian3.subtract(t[1],r,t[1]),Cartesian3.subtract(t[1],o,t[1]),Cartesian3.add(t[1],a,t[1]),Cartesian3.clone(n,t[2]),Cartesian3.subtract(t[2],r,t[2]),Cartesian3.add(t[2],o,t[2]),Cartesian3.subtract(t[2],a,t[2]),Cartesian3.clone(n,t[3]),Cartesian3.subtract(t[3],r,t[3]),Cartesian3.add(t[3],o,t[3]),Cartesian3.add(t[3],a,t[3]),Cartesian3.clone(n,t[4]),Cartesian3.add(t[4],r,t[4]),Cartesian3.subtract(t[4],o,t[4]),Cartesian3.subtract(t[4],a,t[4]),Cartesian3.clone(n,t[5]),Cartesian3.add(t[5],r,t[5]),Cartesian3.subtract(t[5],o,t[5]),Cartesian3.add(t[5],a,t[5]),Cartesian3.clone(n,t[6]),Cartesian3.add(t[6],r,t[6]),Cartesian3.add(t[6],o,t[6]),Cartesian3.subtract(t[6],a,t[6]),Cartesian3.clone(n,t[7]),Cartesian3.add(t[7],r,t[7]),Cartesian3.add(t[7],o,t[7]),Cartesian3.add(t[7],a,t[7]),t};const scratchRotationScale$1=new Matrix3;OrientedBoundingBox.computeTransformation=function(e,t){defined(t)||(t=new Matrix4);const n=e.center,i=Matrix3.multiplyByUniformScale(e.halfAxes,2,scratchRotationScale$1);return Matrix4.fromRotationTranslation(i,n,t)};const scratchBoundingSphere$3=new BoundingSphere;OrientedBoundingBox.isOccluded=function(e,t){const n=BoundingSphere.fromOrientedBoundingBox(e,scratchBoundingSphere$3);return!t.isBoundingSphereVisible(n)},OrientedBoundingBox.prototype.intersectPlane=function(e){return OrientedBoundingBox.intersectPlane(this,e)},OrientedBoundingBox.prototype.distanceSquaredTo=function(e){return OrientedBoundingBox.distanceSquaredTo(this,e)},OrientedBoundingBox.prototype.computePlaneDistances=function(e,t,n){return OrientedBoundingBox.computePlaneDistances(this,e,t,n)},OrientedBoundingBox.prototype.computeCorners=function(e){return OrientedBoundingBox.computeCorners(this,e)},OrientedBoundingBox.prototype.computeTransformation=function(e){return OrientedBoundingBox.computeTransformation(this,e)},OrientedBoundingBox.prototype.isOccluded=function(e){return OrientedBoundingBox.isOccluded(this,e)},OrientedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Matrix3.equals(e.halfAxes,t.halfAxes)},OrientedBoundingBox.prototype.clone=function(e){return OrientedBoundingBox.clone(this,e)},OrientedBoundingBox.prototype.equals=function(e){return OrientedBoundingBox.equals(this,e)};const WebGLConstants={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGBA_ASTC_4x4_WEBGL:37808,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGBA_BPTC_UNORM:36492,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};var WebGLConstants$1=Object.freeze(WebGLConstants);const ComponentDatatype={BYTE:WebGLConstants$1.BYTE,UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,SHORT:WebGLConstants$1.SHORT,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,INT:WebGLConstants$1.INT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,DOUBLE:WebGLConstants$1.DOUBLE,getSizeInBytes:function(e){switch(e){case ComponentDatatype.BYTE:return Int8Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case ComponentDatatype.SHORT:return Int16Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case ComponentDatatype.INT:return Int32Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case ComponentDatatype.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case ComponentDatatype.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},fromTypedArray:function(e){return e instanceof Int8Array?ComponentDatatype.BYTE:e instanceof Uint8Array?ComponentDatatype.UNSIGNED_BYTE:e instanceof Int16Array?ComponentDatatype.SHORT:e instanceof Uint16Array?ComponentDatatype.UNSIGNED_SHORT:e instanceof Int32Array?ComponentDatatype.INT:e instanceof Uint32Array?ComponentDatatype.UNSIGNED_INT:e instanceof Float32Array?ComponentDatatype.FLOAT:e instanceof Float64Array?ComponentDatatype.DOUBLE:void 0},validate:function(e){return defined(e)&&(e===ComponentDatatype.BYTE||e===ComponentDatatype.UNSIGNED_BYTE||e===ComponentDatatype.SHORT||e===ComponentDatatype.UNSIGNED_SHORT||e===ComponentDatatype.INT||e===ComponentDatatype.UNSIGNED_INT||e===ComponentDatatype.FLOAT||e===ComponentDatatype.DOUBLE)},createTypedArray:function(e,t){switch(e){case ComponentDatatype.BYTE:return new Int8Array(t);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t);case ComponentDatatype.SHORT:return new Int16Array(t);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t);case ComponentDatatype.INT:return new Int32Array(t);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t);case ComponentDatatype.FLOAT:return new Float32Array(t);case ComponentDatatype.DOUBLE:return new Float64Array(t)}},createArrayBufferView:function(e,t,n,i){switch(n=defaultValue(n,0),i=defaultValue(i,(t.byteLength-n)/ComponentDatatype.getSizeInBytes(e)),e){case ComponentDatatype.BYTE:return new Int8Array(t,n,i);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t,n,i);case ComponentDatatype.SHORT:return new Int16Array(t,n,i);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t,n,i);case ComponentDatatype.INT:return new Int32Array(t,n,i);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t,n,i);case ComponentDatatype.FLOAT:return new Float32Array(t,n,i);case ComponentDatatype.DOUBLE:return new Float64Array(t,n,i)}},fromName:function(e){switch(e){case"BYTE":return ComponentDatatype.BYTE;case"UNSIGNED_BYTE":return ComponentDatatype.UNSIGNED_BYTE;case"SHORT":return ComponentDatatype.SHORT;case"UNSIGNED_SHORT":return ComponentDatatype.UNSIGNED_SHORT;case"INT":return ComponentDatatype.INT;case"UNSIGNED_INT":return ComponentDatatype.UNSIGNED_INT;case"FLOAT":return ComponentDatatype.FLOAT;case"DOUBLE":return ComponentDatatype.DOUBLE}}};var ComponentDatatype$1=Object.freeze(ComponentDatatype);function Matrix2(e,t,n,i){this[0]=defaultValue(e,0),this[1]=defaultValue(n,0),this[2]=defaultValue(t,0),this[3]=defaultValue(i,0)}Matrix2.packedLength=4,Matrix2.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t},Matrix2.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Matrix2),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n},Matrix2.packArray=function(e,t){const n=e.length,i=4*n;defined(t)?(Array.isArray(t)||t.length===i)&&t.length!==i&&(t.length=i):t=new Array(i);for(let i=0;i<n;++i)Matrix2.pack(e[i],t,4*i);return t},Matrix2.unpackArray=function(e,t){const n=e.length;defined(t)?t.length=n/4:t=new Array(n/4);for(let i=0;i<n;i+=4){const n=i/4;t[n]=Matrix2.unpack(e,i,t[n])}return t},Matrix2.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Matrix2(e[0],e[2],e[1],e[3])},Matrix2.fromArray=Matrix2.unpack,Matrix2.fromColumnMajorArray=function(e,t){return Matrix2.clone(e,t)},Matrix2.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Matrix2(e[0],e[1],e[2],e[3])},Matrix2.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Matrix2(e.x,0,0,e.y)},Matrix2.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Matrix2(e,0,0,e)},Matrix2.fromRotation=function(e,t){const n=Math.cos(e),i=Math.sin(e);return defined(t)?(t[0]=n,t[1]=i,t[2]=-i,t[3]=n,t):new Matrix2(n,-i,i,n)},Matrix2.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},Matrix2.getElementIndex=function(e,t){return 2*e+t},Matrix2.getColumn=function(e,t,n){const i=2*t,r=e[i],o=e[i+1];return n.x=r,n.y=o,n},Matrix2.setColumn=function(e,t,n,i){const r=2*t;return(i=Matrix2.clone(e,i))[r]=n.x,i[r+1]=n.y,i},Matrix2.getRow=function(e,t,n){const i=e[t],r=e[t+2];return n.x=i,n.y=r,n},Matrix2.setRow=function(e,t,n,i){return(i=Matrix2.clone(e,i))[t]=n.x,i[t+2]=n.y,i};const scaleScratch1=new Cartesian2;Matrix2.setScale=function(e,t,n){const i=Matrix2.getScale(e,scaleScratch1),r=t.x/i.x,o=t.y/i.y;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*o,n[3]=e[3]*o,n};const scaleScratch2=new Cartesian2;Matrix2.setUniformScale=function(e,t,n){const i=Matrix2.getScale(e,scaleScratch2),r=t/i.x,o=t/i.y;return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*o,n[3]=e[3]*o,n};const scratchColumn=new Cartesian2;Matrix2.getScale=function(e,t){return t.x=Cartesian2.magnitude(Cartesian2.fromElements(e[0],e[1],scratchColumn)),t.y=Cartesian2.magnitude(Cartesian2.fromElements(e[2],e[3],scratchColumn)),t};const scaleScratch3=new Cartesian2;Matrix2.getMaximumScale=function(e){return Matrix2.getScale(e,scaleScratch3),Cartesian2.maximumComponent(scaleScratch3)};const scaleScratch4=new Cartesian2;Matrix2.setRotation=function(e,t,n){const i=Matrix2.getScale(e,scaleScratch4);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.y,n[3]=t[3]*i.y,n};const scaleScratch5=new Cartesian2;Matrix2.getRotation=function(e,t){const n=Matrix2.getScale(e,scaleScratch5);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.y,t[3]=e[3]/n.y,t},Matrix2.multiply=function(e,t,n){const i=e[0]*t[0]+e[2]*t[1],r=e[0]*t[2]+e[2]*t[3],o=e[1]*t[0]+e[3]*t[1],a=e[1]*t[2]+e[3]*t[3];return n[0]=i,n[1]=o,n[2]=r,n[3]=a,n},Matrix2.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n},Matrix2.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n},Matrix2.multiplyByVector=function(e,t,n){const i=e[0]*t.x+e[2]*t.y,r=e[1]*t.x+e[3]*t.y;return n.x=i,n.y=r,n},Matrix2.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n},Matrix2.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.y,n[3]=e[3]*t.y,n},Matrix2.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n},Matrix2.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Matrix2.transpose=function(e,t){const n=e[0],i=e[2],r=e[1],o=e[3];return t[0]=n,t[1]=i,t[2]=r,t[3]=o,t},Matrix2.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},Matrix2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Matrix2.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]},Matrix2.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},Matrix2.IDENTITY=Object.freeze(new Matrix2(1,0,0,1)),Matrix2.ZERO=Object.freeze(new Matrix2(0,0,0,0)),Matrix2.COLUMN0ROW0=0,Matrix2.COLUMN0ROW1=1,Matrix2.COLUMN1ROW0=2,Matrix2.COLUMN1ROW1=3,Object.defineProperties(Matrix2.prototype,{length:{get:function(){return Matrix2.packedLength}}}),Matrix2.prototype.clone=function(e){return Matrix2.clone(this,e)},Matrix2.prototype.equals=function(e){return Matrix2.equals(this,e)},Matrix2.prototype.equalsEpsilon=function(e,t){return Matrix2.equalsEpsilon(this,e,t)},Matrix2.prototype.toString=function(){return`(${this[0]}, ${this[2]})\n(${this[1]}, ${this[3]})`};const AttributeType={SCALAR:"SCALAR",VEC2:"VEC2",VEC3:"VEC3",VEC4:"VEC4",MAT2:"MAT2",MAT3:"MAT3",MAT4:"MAT4",getMathType:function(e){switch(e){case AttributeType.SCALAR:return Number;case AttributeType.VEC2:return Cartesian2;case AttributeType.VEC3:return Cartesian3;case AttributeType.VEC4:return Cartesian4;case AttributeType.MAT2:return Matrix2;case AttributeType.MAT3:return Matrix3;case AttributeType.MAT4:return Matrix4}},getNumberOfComponents:function(e){switch(e){case AttributeType.SCALAR:return 1;case AttributeType.VEC2:return 2;case AttributeType.VEC3:return 3;case AttributeType.VEC4:case AttributeType.MAT2:return 4;case AttributeType.MAT3:return 9;case AttributeType.MAT4:return 16}},getGlslType:function(e){switch(e){case AttributeType.SCALAR:return"float";case AttributeType.VEC2:return"vec2";case AttributeType.VEC3:return"vec3";case AttributeType.VEC4:return"vec4";case AttributeType.MAT2:return"mat2";case AttributeType.MAT3:return"mat3";case AttributeType.MAT4:return"mat4"}}};var AttributeType$1=Object.freeze(AttributeType);const RIGHT_SHIFT=1/256,LEFT_SHIFT=256,AttributeCompression={octEncodeInRange:function(e,t,n){if(n.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),n.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){const e=n.x,t=n.y;n.x=(1-Math.abs(t))*CesiumMath.signNotZero(e),n.y=(1-Math.abs(e))*CesiumMath.signNotZero(t)}return n.x=CesiumMath.toSNorm(n.x,t),n.y=CesiumMath.toSNorm(n.y,t),n},octEncode:function(e,t){return AttributeCompression.octEncodeInRange(e,255,t)}},octEncodeScratch=new Cartesian2,uint8ForceArray=new Uint8Array(1);function forceUint8(e){return uint8ForceArray[0]=e,uint8ForceArray[0]}AttributeCompression.octEncodeToCartesian4=function(e,t){return AttributeCompression.octEncodeInRange(e,65535,octEncodeScratch),t.x=forceUint8(octEncodeScratch.x*RIGHT_SHIFT),t.y=forceUint8(octEncodeScratch.x),t.z=forceUint8(octEncodeScratch.y*RIGHT_SHIFT),t.w=forceUint8(octEncodeScratch.y),t},AttributeCompression.octDecodeInRange=function(e,t,n,i){if(i.x=CesiumMath.fromSNorm(e,n),i.y=CesiumMath.fromSNorm(t,n),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){const e=i.x;i.x=(1-Math.abs(i.y))*CesiumMath.signNotZero(e),i.y=(1-Math.abs(e))*CesiumMath.signNotZero(i.y)}return Cartesian3.normalize(i,i)},AttributeCompression.octDecode=function(e,t,n){return AttributeCompression.octDecodeInRange(e,t,255,n)},AttributeCompression.octDecodeFromCartesian4=function(e,t){const n=e.x,i=e.y,r=e.z,o=e.w,a=n*LEFT_SHIFT+i,s=r*LEFT_SHIFT+o;return AttributeCompression.octDecodeInRange(a,s,65535,t)},AttributeCompression.octPackFloat=function(e){return 256*e.x+e.y};const scratchEncodeCart2=new Cartesian2;function zigZagDecode(e){return e>>1^-(1&e)}AttributeCompression.octEncodeFloat=function(e){return AttributeCompression.octEncode(e,scratchEncodeCart2),AttributeCompression.octPackFloat(scratchEncodeCart2)},AttributeCompression.octDecodeFloat=function(e,t){const n=e/256,i=Math.floor(n),r=256*(n-i);return AttributeCompression.octDecode(i,r,t)},AttributeCompression.octPack=function(e,t,n,i){const r=AttributeCompression.octEncodeFloat(e),o=AttributeCompression.octEncodeFloat(t),a=AttributeCompression.octEncode(n,scratchEncodeCart2);return i.x=65536*a.x+r,i.y=65536*a.y+o,i},AttributeCompression.octUnpack=function(e,t,n,i){let r=e.x/65536;const o=Math.floor(r),a=65536*(r-o);r=e.y/65536;const s=Math.floor(r),c=65536*(r-s);AttributeCompression.octDecodeFloat(a,t),AttributeCompression.octDecodeFloat(c,n),AttributeCompression.octDecode(o,s,i)},AttributeCompression.compressTextureCoordinates=function(e){return 4096*(4095*e.x|0)+(4095*e.y|0)},AttributeCompression.decompressTextureCoordinates=function(e,t){const n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-4096*i)/4095,t},AttributeCompression.zigZagDeltaDecode=function(e,t,n){const i=e.length;let r=0,o=0,a=0;for(let s=0;s<i;++s)r+=zigZagDecode(e[s]),o+=zigZagDecode(t[s]),e[s]=r,t[s]=o,defined(n)&&(a+=zigZagDecode(n[s]),n[s]=a)},AttributeCompression.dequantize=function(e,t,n,i){const r=AttributeType$1.getNumberOfComponents(n);let o;switch(t){case ComponentDatatype$1.BYTE:o=127;break;case ComponentDatatype$1.UNSIGNED_BYTE:o=255;break;case ComponentDatatype$1.SHORT:o=32767;break;case ComponentDatatype$1.UNSIGNED_SHORT:o=65535;break;case ComponentDatatype$1.INT:o=2147483647;break;case ComponentDatatype$1.UNSIGNED_INT:o=4294967295}const a=new Float32Array(i*r);for(let t=0;t<i;t++)for(let n=0;n<r;n++){const i=t*r+n;a[i]=Math.max(e[i]/o,-1)}return a},AttributeCompression.decodeRGB565=function(e,t){const n=e.length;defined(t)||(t=new Float32Array(3*n));const i=1/31;for(let r=0;r<n;r++){const n=e[r],o=n>>11,a=n>>5&63,s=31&n,c=3*r;t[c]=o*i,t[c+1]=.015873015873015872*a,t[c+2]=s*i}return t};const TerrainExaggeration={getHeight:function(e,t,n){return(e-n)*t+n}},scratchCartographic$g=new Cartesian3;TerrainExaggeration.getPosition=function(e,t,n,i,r){const o=t.cartesianToCartographic(e,scratchCartographic$g),a=TerrainExaggeration.getHeight(o.height,n,i);return Cartesian3.fromRadians(o.longitude,o.latitude,a,t,r)};const TerrainQuantization={NONE:0,BITS12:1};var TerrainQuantization$1=Object.freeze(TerrainQuantization);const cartesian3Scratch$3=new Cartesian3,cartesian3DimScratch=new Cartesian3,cartesian2Scratch=new Cartesian2,matrix4Scratch$1=new Matrix4,matrix4Scratch2=new Matrix4,SHIFT_LEFT_12=Math.pow(2,12);function TerrainEncoding(e,t,n,i,r,o,a,s,c,l){let u,d,h=TerrainQuantization$1.NONE;if(defined(t)&&defined(n)&&defined(i)&&defined(r)){const e=t.minimum,o=t.maximum,a=Cartesian3.subtract(o,e,cartesian3DimScratch),s=i-n;h=Math.max(Cartesian3.maximumComponent(a),s)<SHIFT_LEFT_12-1?TerrainQuantization$1.BITS12:TerrainQuantization$1.NONE,u=Matrix4.inverseTransformation(r,new Matrix4);const c=Cartesian3.negate(e,cartesian3Scratch$3);Matrix4.multiply(Matrix4.fromTranslation(c,matrix4Scratch$1),u,u);const l=cartesian3Scratch$3;l.x=1/a.x,l.y=1/a.y,l.z=1/a.z,Matrix4.multiply(Matrix4.fromScale(l,matrix4Scratch$1),u,u),d=Matrix4.clone(r),Matrix4.setTranslation(d,Cartesian3.ZERO,d),r=Matrix4.clone(r,new Matrix4);const p=Matrix4.fromTranslation(e,matrix4Scratch$1),f=Matrix4.fromScale(a,matrix4Scratch2),m=Matrix4.multiply(p,f,matrix4Scratch$1);Matrix4.multiply(r,m,r),Matrix4.multiply(d,m,d)}this.quantization=h,this.minimumHeight=n,this.maximumHeight=i,this.center=Cartesian3.clone(e),this.toScaledENU=u,this.fromScaledENU=r,this.matrix=d,this.hasVertexNormals=o,this.hasWebMercatorT=defaultValue(a,!1),this.hasGeodeticSurfaceNormals=defaultValue(s,!1),this.exaggeration=defaultValue(c,1),this.exaggerationRelativeHeight=defaultValue(l,0),this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}TerrainEncoding.prototype.encode=function(e,t,n,i,r,o,a,s){const c=i.x,l=i.y;if(this.quantization===TerrainQuantization$1.BITS12){(n=Matrix4.multiplyByPoint(this.toScaledENU,n,cartesian3Scratch$3)).x=CesiumMath.clamp(n.x,0,1),n.y=CesiumMath.clamp(n.y,0,1),n.z=CesiumMath.clamp(n.z,0,1);const i=this.maximumHeight-this.minimumHeight,o=CesiumMath.clamp((r-this.minimumHeight)/i,0,1);Cartesian2.fromElements(n.x,n.y,cartesian2Scratch);const s=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(n.z,o,cartesian2Scratch);const u=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(c,l,cartesian2Scratch);const d=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);if(e[t++]=s,e[t++]=u,e[t++]=d,this.hasWebMercatorT){Cartesian2.fromElements(a,0,cartesian2Scratch);const n=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);e[t++]=n}}else Cartesian3.subtract(n,this.center,cartesian3Scratch$3),e[t++]=cartesian3Scratch$3.x,e[t++]=cartesian3Scratch$3.y,e[t++]=cartesian3Scratch$3.z,e[t++]=r,e[t++]=c,e[t++]=l,this.hasWebMercatorT&&(e[t++]=a);return this.hasVertexNormals&&(e[t++]=AttributeCompression.octPackFloat(o)),this.hasGeodeticSurfaceNormals&&(e[t++]=s.x,e[t++]=s.y,e[t++]=s.z),t};const scratchPosition$d=new Cartesian3,scratchGeodeticSurfaceNormal=new Cartesian3;TerrainEncoding.prototype.addGeodeticSurfaceNormals=function(e,t,n){if(this.hasGeodeticSurfaceNormals)return;const i=this.stride,r=e.length/i;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();const o=this.stride;for(let a=0;a<r;a++){for(let n=0;n<i;n++){const r=a*i+n;t[a*o+n]=e[r]}const r=this.decodePosition(t,a,scratchPosition$d),s=n.geodeticSurfaceNormal(r,scratchGeodeticSurfaceNormal),c=a*o+this._offsetGeodeticSurfaceNormal;t[c]=s.x,t[c+1]=s.y,t[c+2]=s.z}},TerrainEncoding.prototype.removeGeodeticSurfaceNormals=function(e,t){if(!this.hasGeodeticSurfaceNormals)return;const n=this.stride,i=e.length/n;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();const r=this.stride;for(let o=0;o<i;o++)for(let i=0;i<r;i++){const a=o*n+i;t[o*r+i]=e[a]}},TerrainEncoding.prototype.decodePosition=function(e,t,n){if(defined(n)||(n=new Cartesian3),t*=this.stride,this.quantization===TerrainQuantization$1.BITS12){const i=AttributeCompression.decompressTextureCoordinates(e[t],cartesian2Scratch);n.x=i.x,n.y=i.y;const r=AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch);return n.z=r.x,Matrix4.multiplyByPoint(this.fromScaledENU,n,n)}return n.x=e[t],n.y=e[t+1],n.z=e[t+2],Cartesian3.add(n,this.center,n)},TerrainEncoding.prototype.getExaggeratedPosition=function(e,t,n){n=this.decodePosition(e,t,n);const i=this.exaggeration,r=this.exaggerationRelativeHeight;if(1!==i&&this.hasGeodeticSurfaceNormals){const o=this.decodeGeodeticSurfaceNormal(e,t,scratchGeodeticSurfaceNormal),a=this.decodeHeight(e,t),s=TerrainExaggeration.getHeight(a,i,r)-a;n.x+=o.x*s,n.y+=o.y*s,n.z+=o.z*s}return n},TerrainEncoding.prototype.decodeTextureCoordinates=function(e,t,n){return defined(n)||(n=new Cartesian2),t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+2],n):Cartesian2.fromElements(e[t+4],e[t+5],n)},TerrainEncoding.prototype.decodeHeight=function(e,t){if(t*=this.stride,this.quantization===TerrainQuantization$1.BITS12){return AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight}return e[t+3]},TerrainEncoding.prototype.decodeWebMercatorT=function(e,t){return t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+3],cartesian2Scratch).x:e[t+6]},TerrainEncoding.prototype.getOctEncodedNormal=function(e,t,n){const i=e[t=t*this.stride+this._offsetVertexNormal]/256,r=Math.floor(i),o=256*(i-r);return Cartesian2.fromElements(r,o,n)},TerrainEncoding.prototype.decodeGeodeticSurfaceNormal=function(e,t,n){return t=t*this.stride+this._offsetGeodeticSurfaceNormal,n.x=e[t],n.y=e[t+1],n.z=e[t+2],n},TerrainEncoding.prototype._calculateStrideAndOffsets=function(){let e=0;if(this.quantization===TerrainQuantization$1.BITS12)e+=3;else e+=6;this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};const attributesIndicesNone={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},attributesIndicesBits12={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};function WebMercatorProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}TerrainEncoding.prototype.getAttributes=function(e){const t=ComponentDatatype$1.FLOAT,n=ComponentDatatype$1.getSizeInBytes(t),i=this.stride*n;let r=0;const o=[];function a(a,s){o.push({index:a,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:s,offsetInBytes:r,strideInBytes:i}),r+=s*n}if(this.quantization===TerrainQuantization$1.NONE){a(attributesIndicesNone.position3DAndHeight,4);let e=2;e+=this.hasWebMercatorT?1:0,e+=this.hasVertexNormals?1:0,a(attributesIndicesNone.textureCoordAndEncodedNormals,e),this.hasGeodeticSurfaceNormals&&a(attributesIndicesNone.geodeticSurfaceNormal,3)}else{const e=this.hasWebMercatorT||this.hasVertexNormals,t=this.hasWebMercatorT&&this.hasVertexNormals;a(attributesIndicesBits12.compressed0,e?4:3),t&&a(attributesIndicesBits12.compressed1,1),this.hasGeodeticSurfaceNormals&&a(attributesIndicesBits12.geodeticSurfaceNormal,3)}return o},TerrainEncoding.prototype.getAttributeLocations=function(){return this.quantization===TerrainQuantization$1.NONE?attributesIndicesNone:attributesIndicesBits12},TerrainEncoding.clone=function(e,t){if(defined(e))return defined(t)||(t=new TerrainEncoding),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=Cartesian3.clone(e.center),t.toScaledENU=Matrix4.clone(e.toScaledENU),t.fromScaledENU=Matrix4.clone(e.fromScaledENU),t.matrix=Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t},Object.defineProperties(WebMercatorProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),WebMercatorProjection.mercatorAngleToGeodeticLatitude=function(e){return CesiumMath.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},WebMercatorProjection.geodeticLatitudeToMercatorAngle=function(e){e>WebMercatorProjection.MaximumLatitude?e=WebMercatorProjection.MaximumLatitude:e<-WebMercatorProjection.MaximumLatitude&&(e=-WebMercatorProjection.MaximumLatitude);const t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},WebMercatorProjection.MaximumLatitude=WebMercatorProjection.mercatorAngleToGeodeticLatitude(Math.PI),WebMercatorProjection.prototype.project=function(e,t){const n=this._semimajorAxis,i=e.longitude*n,r=WebMercatorProjection.geodeticLatitudeToMercatorAngle(e.latitude)*n,o=e.height;return defined(t)?(t.x=i,t.y=r,t.z=o,t):new Cartesian3(i,r,o)},WebMercatorProjection.prototype.unproject=function(e,t){const n=this._oneOverSemimajorAxis,i=e.x*n,r=WebMercatorProjection.mercatorAngleToGeodeticLatitude(e.y*n),o=e.z;return defined(t)?(t.longitude=i,t.latitude=r,t.height=o,t):new Cartographic(i,r,o)};const HeightmapTessellator={};HeightmapTessellator.DEFAULT_STRUCTURE=Object.freeze({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});const cartesian3Scratch$2=new Cartesian3,matrix4Scratch=new Matrix4,minimumScratch=new Cartesian3,maximumScratch=new Cartesian3;function returnTrue(){return!0}function destroyObject(e,t){function n(){}for(const t in e)"function"==typeof e[t]&&(e[t]=n);e.isDestroyed=returnTrue}function canTransferArrayBuffer(){if(!defined(TaskProcessor._canTransferArrayBuffer)){const e=new Worker(getWorkerUrl("Workers/transferTypedArrayTest.js"));e.postMessage=defaultValue(e.webkitPostMessage,e.postMessage);const t=99,n=new Int8Array([t]);try{e.postMessage({array:n},[n.buffer])}catch(e){return TaskProcessor._canTransferArrayBuffer=!1,TaskProcessor._canTransferArrayBuffer}const i=when.defer();e.onmessage=function(n){const r=n.data.array,o=defined(r)&&r[0]===t;i.resolve(o),e.terminate(),TaskProcessor._canTransferArrayBuffer=o},TaskProcessor._canTransferArrayBuffer=i.promise}return TaskProcessor._canTransferArrayBuffer}HeightmapTessellator.computeVertices=function(e){const t=Math.cos,n=Math.sin,i=Math.sqrt,r=Math.atan,o=Math.exp,a=CesiumMath.PI_OVER_TWO,s=CesiumMath.toRadians,c=e.heightmap,l=e.width,u=e.height,d=e.skirtHeight,h=d>0,p=defaultValue(e.isGeographic,!0),f=defaultValue(e.ellipsoid,Ellipsoid.WGS84),m=1/f.maximumRadius,g=Rectangle.clone(e.nativeRectangle),_=Rectangle.clone(e.rectangle);let y,C,T,S;defined(_)?(y=_.west,C=_.south,T=_.east,S=_.north):p?(y=s(g.west),C=s(g.south),T=s(g.east),S=s(g.north)):(y=g.west*m,C=a-2*r(o(-g.south*m)),T=g.east*m,S=a-2*r(o(-g.north*m)));let A=e.relativeToCenter;const v=defined(A);A=v?A:Cartesian3.ZERO;const E=defaultValue(e.includeWebMercatorT,!1),b=defaultValue(e.exaggeration,1),x=defaultValue(e.exaggerationRelativeHeight,0),P=1!==b,D=defaultValue(e.structure,HeightmapTessellator.DEFAULT_STRUCTURE),w=defaultValue(D.heightScale,HeightmapTessellator.DEFAULT_STRUCTURE.heightScale),M=defaultValue(D.heightOffset,HeightmapTessellator.DEFAULT_STRUCTURE.heightOffset),I=defaultValue(D.elementsPerHeight,HeightmapTessellator.DEFAULT_STRUCTURE.elementsPerHeight),R=defaultValue(D.stride,HeightmapTessellator.DEFAULT_STRUCTURE.stride),O=defaultValue(D.elementMultiplier,HeightmapTessellator.DEFAULT_STRUCTURE.elementMultiplier),B=defaultValue(D.isBigEndian,HeightmapTessellator.DEFAULT_STRUCTURE.isBigEndian);let L=Rectangle.computeWidth(g),F=Rectangle.computeHeight(g);const N=L/(l-1),V=F/(u-1);p||(L*=m,F*=m);const $=f.radiiSquared,k=$.x,U=$.y,G=$.z;let z=65536,H=-65536;const W=Transforms.eastNorthUpToFixedFrame(A,f),q=Matrix4.inverseTransformation(W,matrix4Scratch);let j,X;E&&(j=WebMercatorProjection.geodeticLatitudeToMercatorAngle(C),X=1/(WebMercatorProjection.geodeticLatitudeToMercatorAngle(S)-j));const Y=minimumScratch;Y.x=Number.POSITIVE_INFINITY,Y.y=Number.POSITIVE_INFINITY,Y.z=Number.POSITIVE_INFINITY;const K=maximumScratch;K.x=Number.NEGATIVE_INFINITY,K.y=Number.NEGATIVE_INFINITY,K.z=Number.NEGATIVE_INFINITY;let J=Number.POSITIVE_INFINITY;const Q=l*u,Z=Q+(d>0?2*l+2*u:0),ee=new Array(Z),te=new Array(Z),ne=new Array(Z),ie=E?new Array(Z):[],re=P?new Array(Z):[];let oe=0,ae=u,se=0,ce=l;h&&(--oe,++ae,--se,++ce);const le=1e-5;for(let e=oe;e<ae;++e){let h=e;h<0&&(h=0),h>=u&&(h=u-1);let _=g.north-V*h;_=p?s(_):a-2*r(o(-_*m));let A=(_-C)/(S-C);A=CesiumMath.clamp(A,0,1);const v=e===oe,b=e===ae-1;d>0&&(v?_+=le*F:b&&(_-=le*F));const x=t(_),D=n(_),$=G*D;let W;E&&(W=(WebMercatorProjection.geodeticLatitudeToMercatorAngle(_)-j)*X);for(let e=se;e<ce;++e){let r=e;r<0&&(r=0),r>=l&&(r=l-1);const o=h*(l*R)+r*R;let a;if(1===I)a=c[o];else{let e;if(a=0,B)for(e=0;e<I;++e)a=a*O+c[o+e];else for(e=I-1;e>=0;--e)a=a*O+c[o+e]}a=a*w+M,H=Math.max(H,a),z=Math.min(z,a);let _=g.west+N*r;p?_=s(_):_*=m;let C=(_-y)/(T-y);C=CesiumMath.clamp(C,0,1);let S=h*l+r;if(d>0){const t=e===se,n=e===ce-1,i=v||b||t||n;if((v||b)&&(t||n))continue;i&&(a-=d,t?(S=Q+(u-h-1),_-=le*L):b?S=Q+u+(l-r-1):n?(S=Q+u+l+h,_+=le*L):v&&(S=Q+u+l+u+r))}const F=x*t(_),V=x*n(_),G=k*F,j=U*V,X=1/i(G*F+j*V+$*D),Z=G*X,oe=j*X,ae=$*X,ue=new Cartesian3;ue.x=Z+F*a,ue.y=oe+V*a,ue.z=ae+D*a,Matrix4.multiplyByPoint(q,ue,cartesian3Scratch$2),Cartesian3.minimumByComponent(cartesian3Scratch$2,Y,Y),Cartesian3.maximumByComponent(cartesian3Scratch$2,K,K),J=Math.min(J,a),ee[S]=ue,ne[S]=new Cartesian2(C,A),te[S]=a,E&&(ie[S]=W),P&&(re[S]=f.geodeticSurfaceNormal(ue))}}const ue=BoundingSphere.fromPoints(ee);let de,he;if(defined(_)&&(de=OrientedBoundingBox.fromRectangle(_,z,H,f)),v){he=new EllipsoidalOccluder(f).computeHorizonCullingPointPossiblyUnderEllipsoid(A,ee,z)}const pe=new TerrainEncoding(A,new AxisAlignedBoundingBox(Y,K,A),J,H,W,!1,E,P,b,x),fe=new Float32Array(Z*pe.stride);let me=0;for(let e=0;e<Z;++e)me=pe.encode(fe,me,ee[e],ne[e],te[e],void 0,ie[e],re[e]);return{vertices:fe,maximumHeight:H,minimumHeight:z,encoding:pe,boundingSphere3D:ue,orientedBoundingBox:de,occludeePointInScaledSpace:he}};const taskCompletedEvent=new Event;function completeTask(e,t){--e._activeTasks;const n=t.id;if(!defined(n))return;const i=e._deferreds,r=i[n];if(defined(t.error)){let e=t.error;"RuntimeError"===e.name?(e=new RuntimeError(t.error.message),e.stack=t.error.stack):"DeveloperError"===e.name&&(e=new DeveloperError(t.error.message),e.stack=t.error.stack),taskCompletedEvent.raiseEvent(e),r.reject(e)}else taskCompletedEvent.raiseEvent(),r.resolve(t.result);delete i[n]}function getWorkerUrl(e){let t=buildModuleUrl(e);if(isCrossOriginUrl(t)){const e=`importScripts("${t}");`;let n;try{n=new Blob([e],{type:"application/javascript"})}catch(t){const i=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder);i.append(e),n=i.getBlob("application/javascript")}t=(window.URL||window.webkitURL).createObjectURL(n)}return t}let bootstrapperUrlResult;function getBootstrapperUrl(){return defined(bootstrapperUrlResult)||(bootstrapperUrlResult=getWorkerUrl("Workers/cesiumWorkerBootstrapper.js")),bootstrapperUrlResult}function createWorker(e){const t=new Worker(getBootstrapperUrl());t.postMessage=defaultValue(t.webkitPostMessage,t.postMessage);const n={loaderConfig:{paths:{Workers:buildModuleUrl("Workers")},baseUrl:buildModuleUrl.getCesiumBaseUrl().url},workerModule:e._workerPath};return t.postMessage(n),t.onmessage=function(t){completeTask(e,t.data)},t}function getWebAssemblyLoaderConfig(e,t){const n={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(!FeatureDetection.supportsWebAssembly()){if(!defined(t.fallbackModulePath))throw new RuntimeError(`This browser does not support Web Assembly, and no backup module was provided for ${e._workerPath}`);return n.modulePath=buildModuleUrl(t.fallbackModulePath),when.resolve(n)}return n.modulePath=buildModuleUrl(t.modulePath),n.wasmBinaryFile=buildModuleUrl(t.wasmBinaryFile),Resource.fetchArrayBuffer({url:n.wasmBinaryFile}).then((function(e){return n.wasmBinary=e,n}))}function TaskProcessor(e,t){const n=new URI(e);this._workerPath=0!==n.scheme().length&&0===n.fragment().length?e:TaskProcessor._workerModulePrefix+e,this._maximumActiveTasks=defaultValue(t,Number.POSITIVE_INFINITY),this._activeTasks=0,this._deferreds={},this._nextID=0}const emptyTransferableObjectArray=[];function TerrainData(){DeveloperError.throwInstantiationError()}function TerrainMesh(e,t,n,i,r,o,a,s,c,l,u,d,h,p,f,m){this.center=e,this.vertices=t,this.stride=defaultValue(l,6),this.indices=n,this.indexCountWithoutSkirts=i,this.vertexCountWithoutSkirts=r,this.minimumHeight=o,this.maximumHeight=a,this.boundingSphere3D=s,this.occludeePointInScaledSpace=c,this.orientedBoundingBox=u,this.encoding=d,this.westIndicesSouthToNorth=h,this.southIndicesEastToWest=p,this.eastIndicesNorthToSouth=f,this.northIndicesWestToEast=m}TaskProcessor.prototype.scheduleTask=function(e,t){if(defined(this._worker)||(this._worker=createWorker(this)),this._activeTasks>=this._maximumActiveTasks)return;++this._activeTasks;const n=this;return when(canTransferArrayBuffer(),(function(i){defined(t)?i||(t.length=0):t=emptyTransferableObjectArray;const r=n._nextID++,o=when.defer();return n._deferreds[r]=o,n._worker.postMessage({id:r,parameters:e,canTransferArrayBuffer:i},t),o.promise}))},TaskProcessor.prototype.initWebAssemblyModule=function(e){defined(this._worker)||(this._worker=createWorker(this));const t=when.defer(),n=this,i=this._worker;return getWebAssemblyLoaderConfig(this,e).then((function(e){return when(canTransferArrayBuffer(),(function(r){let o;const a=e.wasmBinary;defined(a)&&r&&(o=[a]),i.onmessage=function(e){i.onmessage=function(e){completeTask(n,e.data)},t.resolve(e.data)},i.postMessage({webAssemblyConfig:e},o)}))})),t},TaskProcessor.prototype.isDestroyed=function(){return!1},TaskProcessor.prototype.destroy=function(){return defined(this._worker)&&this._worker.terminate(),destroyObject(this)},TaskProcessor.taskCompletedEvent=taskCompletedEvent,TaskProcessor._defaultWorkerModulePrefix="Workers/",TaskProcessor._workerModulePrefix=TaskProcessor._defaultWorkerModulePrefix,TaskProcessor._canTransferArrayBuffer=void 0,Object.defineProperties(TerrainData.prototype,{credits:{get:DeveloperError.throwInstantiationError},waterMask:{get:DeveloperError.throwInstantiationError}}),TerrainData.prototype.interpolateHeight=DeveloperError.throwInstantiationError,TerrainData.prototype.isChildAvailable=DeveloperError.throwInstantiationError,TerrainData.prototype.createMesh=DeveloperError.throwInstantiationError,TerrainData.prototype.upsample=DeveloperError.throwInstantiationError,TerrainData.prototype.wasCreatedByUpsampling=DeveloperError.throwInstantiationError,TerrainData.maximumAsynchronousTasks=5;const IndexDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case IndexDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},fromSizeInBytes:function(e){switch(e){case 2:return IndexDatatype.UNSIGNED_SHORT;case 4:return IndexDatatype.UNSIGNED_INT;case 1:return IndexDatatype.UNSIGNED_BYTE}},validate:function(e){return defined(e)&&(e===IndexDatatype.UNSIGNED_BYTE||e===IndexDatatype.UNSIGNED_SHORT||e===IndexDatatype.UNSIGNED_INT)},createTypedArray:function(e,t){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},createTypedArrayFromArrayBuffer:function(e,t,n,i){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,i):new Uint16Array(t,n,i)}};var IndexDatatype$1=Object.freeze(IndexDatatype);function TerrainProvider(){DeveloperError.throwInstantiationError()}Object.defineProperties(TerrainProvider.prototype,{errorEvent:{get:DeveloperError.throwInstantiationError},credit:{get:DeveloperError.throwInstantiationError},tilingScheme:{get:DeveloperError.throwInstantiationError},ready:{get:DeveloperError.throwInstantiationError},readyPromise:{get:DeveloperError.throwInstantiationError},hasWaterMask:{get:DeveloperError.throwInstantiationError},hasVertexNormals:{get:DeveloperError.throwInstantiationError},availability:{get:DeveloperError.throwInstantiationError}});const regularGridIndicesCache=[];TerrainProvider.getRegularGridIndices=function(e,t){let n=regularGridIndicesCache[e];defined(n)||(regularGridIndicesCache[e]=n=[]);let i=n[t];return defined(i)||(i=e*t<CesiumMath.SIXTY_FOUR_KILOBYTES?n[t]=new Uint16Array((e-1)*(t-1)*6):n[t]=new Uint32Array((e-1)*(t-1)*6),addRegularGridIndices(e,t,i,0)),i};const regularGridAndEdgeIndicesCache=[];TerrainProvider.getRegularGridIndicesAndEdgeIndices=function(e,t){let n=regularGridAndEdgeIndicesCache[e];defined(n)||(regularGridAndEdgeIndicesCache[e]=n=[]);let i=n[t];if(!defined(i)){const r=TerrainProvider.getRegularGridIndices(e,t),o=getEdgeIndices(e,t),a=o.westIndicesSouthToNorth,s=o.southIndicesEastToWest,c=o.eastIndicesNorthToSouth,l=o.northIndicesWestToEast;i=n[t]={indices:r,westIndicesSouthToNorth:a,southIndicesEastToWest:s,eastIndicesNorthToSouth:c,northIndicesWestToEast:l}}return i};const regularGridAndSkirtAndEdgeIndicesCache=[];function getEdgeIndices(e,t){const n=new Array(t),i=new Array(e),r=new Array(t),o=new Array(e);let a;for(a=0;a<e;++a)o[a]=a,i[a]=e*t-1-a;for(a=0;a<t;++a)r[a]=(a+1)*e-1,n[a]=(t-a-1)*e;return{westIndicesSouthToNorth:n,southIndicesEastToWest:i,eastIndicesNorthToSouth:r,northIndicesWestToEast:o}}function addRegularGridIndices(e,t,n,i){let r=0;for(let o=0;o<t-1;++o){for(let t=0;t<e-1;++t){const t=r,o=t+e,a=o+1,s=t+1;n[i++]=t,n[i++]=o,n[i++]=s,n[i++]=s,n[i++]=o,n[i++]=a,++r}++r}}function addSkirtIndices(e,t,n,i){let r=e[0];const o=e.length;for(let a=1;a<o;++a){const o=e[a];n[i++]=r,n[i++]=o,n[i++]=t,n[i++]=t,n[i++]=o,n[i++]=t+1,r=o,++t}return i}function HeightmapTerrainData(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=defaultValue(e.childTileMask,15),this._encoding=defaultValue(e.encoding,HeightmapEncoding$1.NONE);const t=HeightmapTessellator.DEFAULT_STRUCTURE;let n=e.structure;defined(n)?n!==t&&(n.heightScale=defaultValue(n.heightScale,t.heightScale),n.heightOffset=defaultValue(n.heightOffset,t.heightOffset),n.elementsPerHeight=defaultValue(n.elementsPerHeight,t.elementsPerHeight),n.stride=defaultValue(n.stride,t.stride),n.elementMultiplier=defaultValue(n.elementMultiplier,t.elementMultiplier),n.isBigEndian=defaultValue(n.isBigEndian,t.isBigEndian)):n=t,this._structure=n,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===HeightmapEncoding$1.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices=function(e,t){let n=regularGridAndSkirtAndEdgeIndicesCache[e];defined(n)||(regularGridAndSkirtAndEdgeIndicesCache[e]=n=[]);let i=n[t];if(!defined(i)){const r=e*t,o=(e-1)*(t-1)*6,a=2*e+2*t,s=r+a,c=o+6*Math.max(0,a-4),l=getEdgeIndices(e,t),u=l.westIndicesSouthToNorth,d=l.southIndicesEastToWest,h=l.eastIndicesNorthToSouth,p=l.northIndicesWestToEast,f=IndexDatatype$1.createTypedArray(s,c);addRegularGridIndices(e,t,f,0),TerrainProvider.addSkirtIndices(u,d,h,p,r,f,o),i=n[t]={indices:f,westIndicesSouthToNorth:u,southIndicesEastToWest:d,eastIndicesNorthToSouth:h,northIndicesWestToEast:p,indexCountWithoutSkirts:o}}return i},TerrainProvider.addSkirtIndices=function(e,t,n,i,r,o,a){let s=r;a=addSkirtIndices(e,s,o,a),s+=e.length,a=addSkirtIndices(t,s,o,a),s+=t.length,a=addSkirtIndices(n,s,o,a),s+=n.length,addSkirtIndices(i,s,o,a)},TerrainProvider.heightmapTerrainQuality=.25,TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,n){return 2*e.maximumRadius*Math.PI*TerrainProvider.heightmapTerrainQuality/(t*n)},TerrainProvider.prototype.requestTileGeometry=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getLevelMaximumGeometricError=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getTileDataAvailable=DeveloperError.throwInstantiationError,TerrainProvider.prototype.loadTileDataAvailability=DeveloperError.throwInstantiationError,Object.defineProperties(HeightmapTerrainData.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});const createMeshTaskName$2="createVerticesFromHeightmap",createMeshTaskProcessorNoThrottle$2=new TaskProcessor(createMeshTaskName$2),createMeshTaskProcessorThrottle$2=new TaskProcessor(createMeshTaskName$2,TerrainData.maximumAsynchronousTasks);function interpolateHeight$2(e,t,n,i,r,o,a,s,c,l){const u=(c-o.west)*(a-1)/(o.east-o.west),d=(l-o.south)*(s-1)/(o.north-o.south);let h=0|u,p=h+1;p>=a&&(p=a-1,h=a-2);let f=0|d,m=f+1;m>=s&&(m=s-1,f=s-2);const g=d-f;f=s-1-f,m=s-1-m;return triangleInterpolateHeight(u-h,g,getHeight(e,t,n,i,r,f*a+h),getHeight(e,t,n,i,r,f*a+p),getHeight(e,t,n,i,r,m*a+h),getHeight(e,t,n,i,r,m*a+p))}function interpolateMeshHeight$2(e,t,n,i,r,o,a,s,c){const l=(s-r.west)*(o-1)/(r.east-r.west),u=(c-r.south)*(a-1)/(r.north-r.south);let d=0|l,h=d+1;h>=o&&(h=o-1,d=o-2);let p=0|u,f=p+1;f>=a&&(f=a-1,p=a-2);const m=u-p;p=a-1-p,f=a-1-f;return triangleInterpolateHeight(l-d,m,(t.decodeHeight(e,p*o+d)-n)/i,(t.decodeHeight(e,p*o+h)-n)/i,(t.decodeHeight(e,f*o+d)-n)/i,(t.decodeHeight(e,f*o+h)-n)/i)}function triangleInterpolateHeight(e,t,n,i,r,o){return t<e?n+e*(i-n)+t*(o-i):n+e*(o-r)+t*(r-n)}function getHeight(e,t,n,i,r,o){o*=i;let a,s=0;if(r)for(a=0;a<t;++a)s=s*n+e[o+a];else for(a=t-1;a>=0;--a)s=s*n+e[o+a];return s}function setHeight(e,t,n,i,r,o,a,s){let c;if(a*=r,o)for(c=0;c<t-1;++c)e[a+c]=s/i|0,s-=e[a+c]*i,i/=n;else for(c=t-1;c>0;--c)e[a+c]=s/i|0,s-=e[a+c]*i,i/=n;e[a+c]=s}function TileAvailability(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}HeightmapTerrainData.prototype.createMesh=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,n=e.x,i=e.y,r=e.level,o=defaultValue(e.exaggeration,1),a=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),c=t.ellipsoid,l=t.tileXYToNativeRectangle(n,i,r),u=t.tileXYToRectangle(n,i,r),d=c.cartographicToCartesian(Rectangle.center(u)),h=this._structure,p=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(c,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*p,1e3);const f=(s?createMeshTaskProcessorThrottle$2:createMeshTaskProcessorNoThrottle$2).scheduleTask({heightmap:this._buffer,structure:h,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:l,rectangle:u,relativeToCenter:d,ellipsoid:c,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:o,exaggerationRelativeHeight:a,encoding:this._encoding});if(!defined(f))return;const m=this;return when(f,(function(e){let t;t=m._skirtHeight>0?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(e.gridWidth,e.gridHeight):TerrainProvider.getRegularGridIndicesAndEdgeIndices(e.gridWidth,e.gridHeight);const n=e.gridWidth*e.gridHeight;return m._mesh=new TerrainMesh(d,new Float32Array(e.vertices),t.indices,t.indexCountWithoutSkirts,n,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),t.westIndicesSouthToNorth,t.southIndicesEastToWest,t.eastIndicesNorthToSouth,t.northIndicesWestToEast),m._buffer=void 0,m._mesh}))},HeightmapTerrainData.prototype._createMeshSync=function(e){const t=e.tilingScheme,n=e.x,i=e.y,r=e.level,o=defaultValue(e.exaggeration,1),a=defaultValue(e.exaggerationRelativeHeight,0),s=t.ellipsoid,c=t.tileXYToNativeRectangle(n,i,r),l=t.tileXYToRectangle(n,i,r),u=s.cartographicToCartesian(Rectangle.center(l)),d=this._structure,h=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(s,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*h,1e3);const p=HeightmapTessellator.computeVertices({heightmap:this._buffer,structure:d,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:c,rectangle:l,relativeToCenter:u,ellipsoid:s,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:o,exaggerationRelativeHeight:a});let f;this._buffer=void 0,f=this._skirtHeight>0?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(this._width,this._height):TerrainProvider.getRegularGridIndicesAndEdgeIndices(this._width,this._height);const m=p.gridWidth*p.gridHeight;return this._mesh=new TerrainMesh(u,p.vertices,f.indices,f.indexCountWithoutSkirts,m,p.minimumHeight,p.maximumHeight,p.boundingSphere3D,p.occludeePointInScaledSpace,p.encoding.stride,p.orientedBoundingBox,p.encoding,f.westIndicesSouthToNorth,f.southIndicesEastToWest,f.eastIndicesNorthToSouth,f.northIndicesWestToEast),this._mesh},HeightmapTerrainData.prototype.interpolateHeight=function(e,t,n){const i=this._width,r=this._height,o=this._structure,a=o.stride,s=o.elementsPerHeight,c=o.elementMultiplier,l=o.isBigEndian,u=o.heightOffset,d=o.heightScale,h=defined(this._mesh),p=this._encoding===HeightmapEncoding$1.LERC;if(!h&&p)return;let f;if(h){f=interpolateMeshHeight$2(this._mesh.vertices,this._mesh.encoding,u,d,e,i,r,t,n)}else f=interpolateHeight$2(this._buffer,s,c,a,l,e,i,r,t,n),f=f*d+u;return f},HeightmapTerrainData.prototype.upsample=function(e,t,n,i,r,o,a){const s=this._mesh;if(!defined(s))return;const c=this._width,l=this._height,u=this._structure,d=u.stride,h=new this._bufferType(c*l*d),p=s.vertices,f=s.encoding,m=e.tileXYToRectangle(t,n,i),g=e.tileXYToRectangle(r,o,a),_=u.heightOffset,y=u.heightScale,C=u.elementsPerHeight,T=u.elementMultiplier,S=u.isBigEndian,A=Math.pow(T,C-1);for(let e=0;e<l;++e){const t=CesiumMath.lerp(g.north,g.south,e/(l-1));for(let n=0;n<c;++n){let i=interpolateMeshHeight$2(p,f,_,y,m,c,l,CesiumMath.lerp(g.west,g.east,n/(c-1)),t);i=i<u.lowestEncodedHeight?u.lowestEncodedHeight:i,i=i>u.highestEncodedHeight?u.highestEncodedHeight:i,setHeight(h,C,T,A,d,S,e*c+n,i)}}return new HeightmapTerrainData({buffer:h,width:c,height:l,childTileMask:0,structure:this._structure,createdByUpsampling:!0})},HeightmapTerrainData.prototype.isChildAvailable=function(e,t,n,i){let r=2;return n!==2*e&&++r,i!==2*t&&(r-=2),0!=(this._childTileMask&1<<r)},HeightmapTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};const rectangleScratch$6=new Rectangle;function findNode$1(e,t,n,i){const r=i.length;for(let o=0;o<r;++o){const r=i[o];if(r.x===t&&r.y===n&&r.level===e)return!0}return!1}TileAvailability.prototype.addAvailableTileRange=function(e,t,n,i,r){const o=this._tilingScheme,a=this._rootNodes;if(0===e)for(let s=n;s<=r;++s)for(let n=t;n<=i;++n)findNode$1(e,n,s,a)||a.push(new QuadtreeNode(o,void 0,0,n,s));o.tileXYToRectangle(t,n,e,rectangleScratch$6);const s=rectangleScratch$6.west,c=rectangleScratch$6.north;o.tileXYToRectangle(i,r,e,rectangleScratch$6);const l=rectangleScratch$6.east,u=new RectangleWithLevel(e,s,rectangleScratch$6.south,l,c);for(let e=0;e<a.length;++e){const t=a[e];rectanglesOverlap(t.extent,u)&&putRectangleInQuadtree(this._maximumLevel,t,u)}},TileAvailability.prototype.computeMaximumLevelAtPosition=function(e){let t;for(let n=0;n<this._rootNodes.length;++n){const i=this._rootNodes[n];if(rectangleContainsPosition(i.extent,e)){t=i;break}}return defined(t)?findMaxLevelFromNode(void 0,t,e):-1};const rectanglesScratch=[],remainingToCoverByLevelScratch=[],westScratch$1=new Rectangle,eastScratch=new Rectangle;TileAvailability.prototype.computeBestAvailableLevelOverRectangle=function(e){const t=rectanglesScratch;t.length=0,e.east<e.west?(t.push(Rectangle.fromRadians(-Math.PI,e.south,e.east,e.north,westScratch$1)),t.push(Rectangle.fromRadians(e.west,e.south,Math.PI,e.north,eastScratch))):t.push(e);const n=remainingToCoverByLevelScratch;let i;for(n.length=0,i=0;i<this._rootNodes.length;++i)updateCoverageWithNode(n,this._rootNodes[i],t);for(i=n.length-1;i>=0;--i)if(defined(n[i])&&0===n[i].length)return i;return 0};const cartographicScratch$4=new Cartographic;function QuadtreeNode(e,t,n,i,r){this.tilingScheme=e,this.parent=t,this.level=n,this.x=i,this.y=r,this.extent=e.tileXYToRectangle(i,r,n),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}function RectangleWithLevel(e,t,n,i,r){this.level=e,this.west=t,this.south=n,this.east=i,this.north=r}function rectanglesOverlap(e,t){const n=Math.max(e.west,t.west),i=Math.max(e.south,t.south),r=Math.min(e.east,t.east);return i<Math.min(e.north,t.north)&&n<r}function putRectangleInQuadtree(e,t,n){for(;t.level<e;)if(rectangleFullyContainsRectangle(t.nw.extent,n))t=t.nw;else if(rectangleFullyContainsRectangle(t.ne.extent,n))t=t.ne;else if(rectangleFullyContainsRectangle(t.sw.extent,n))t=t.sw;else{if(!rectangleFullyContainsRectangle(t.se.extent,n))break;t=t.se}if(0===t.rectangles.length||t.rectangles[t.rectangles.length-1].level<=n.level)t.rectangles.push(n);else{let e=binarySearch(t.rectangles,n.level,rectangleLevelComparator);e<0&&(e=~e),t.rectangles.splice(e,0,n)}}function rectangleLevelComparator(e,t){return e.level-t}function rectangleFullyContainsRectangle(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function rectangleContainsPosition(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function findMaxLevelFromNode(e,t,n){let i=0,r=!1;for(;!r;){const e=t._nw&&rectangleContainsPosition(t._nw.extent,n),o=t._ne&&rectangleContainsPosition(t._ne.extent,n),a=t._sw&&rectangleContainsPosition(t._sw.extent,n),s=t._se&&rectangleContainsPosition(t._se.extent,n);if(e+o+a+s>1){e&&(i=Math.max(i,findMaxLevelFromNode(t,t._nw,n))),o&&(i=Math.max(i,findMaxLevelFromNode(t,t._ne,n))),a&&(i=Math.max(i,findMaxLevelFromNode(t,t._sw,n))),s&&(i=Math.max(i,findMaxLevelFromNode(t,t._se,n)));break}e?t=t._nw:o?t=t._ne:a?t=t._sw:s?t=t._se:r=!0}for(;t!==e;){const e=t.rectangles;for(let t=e.length-1;t>=0&&e[t].level>i;--t){const r=e[t];rectangleContainsPosition(r,n)&&(i=r.level)}t=t.parent}return i}function updateCoverageWithNode(e,t,n){if(!t)return;let i,r=!1;for(i=0;i<n.length;++i)r=r||rectanglesOverlap(t.extent,n[i]);if(!r)return;const o=t.rectangles;for(i=0;i<o.length;++i){const t=o[i];e[t.level]||(e[t.level]=n),e[t.level]=subtractRectangle(e[t.level],t)}updateCoverageWithNode(e,t._nw,n),updateCoverageWithNode(e,t._ne,n),updateCoverageWithNode(e,t._sw,n),updateCoverageWithNode(e,t._se,n)}function subtractRectangle(e,t){const n=[];for(let i=0;i<e.length;++i){const r=e[i];rectanglesOverlap(r,t)?(r.west<t.west&&n.push(new Rectangle(r.west,r.south,t.west,r.north)),r.east>t.east&&n.push(new Rectangle(t.east,r.south,r.east,r.north)),r.south<t.south&&n.push(new Rectangle(Math.max(t.west,r.west),r.south,Math.min(t.east,r.east),t.south)),r.north>t.north&&n.push(new Rectangle(Math.max(t.west,r.west),t.north,Math.min(t.east,r.east),r.north))):n.push(r)}return n}function formatError(e){let t;const n=e.name,i=e.message;t=defined(n)&&defined(i)?`${n}: ${i}`:e.toString();const r=e.stack;return defined(r)&&(t+=`\n${r}`),t}function TileProviderError(e,t,n,i,r,o,a){this.provider=e,this.message=t,this.x=n,this.y=i,this.level=r,this.timesRetried=defaultValue(o,0),this.retry=!1,this.error=a}function WebMercatorTilingScheme(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1),this._projection=new WebMercatorProjection(this._ellipsoid),defined(e.rectangleSouthwestInMeters)&&defined(e.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters;else{const e=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new Cartesian2(-e,-e),this._rectangleNortheastInMeters=new Cartesian2(e,e)}const t=this._projection.unproject(this._rectangleSouthwestInMeters),n=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new Rectangle(t.longitude,t.latitude,n.longitude,n.latitude)}TileAvailability.prototype.isTileAvailable=function(e,t,n){const i=this._tilingScheme.tileXYToRectangle(t,n,e,rectangleScratch$6);return Rectangle.center(i,cartographicScratch$4),this.computeMaximumLevelAtPosition(cartographicScratch$4)>=e},TileAvailability.prototype.computeChildMaskForTile=function(e,t,n){const i=e+1;if(i>=this._maximumLevel)return 0;let r=0;return r|=this.isTileAvailable(i,2*t,2*n+1)?1:0,r|=this.isTileAvailable(i,2*t+1,2*n+1)?2:0,r|=this.isTileAvailable(i,2*t,2*n)?4:0,r|=this.isTileAvailable(i,2*t+1,2*n)?8:0,r},Object.defineProperties(QuadtreeNode.prototype,{nw:{get:function(){return this._nw||(this._nw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y+1)),this._sw}},se:{get:function(){return this._se||(this._se=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y+1)),this._se}}}),TileProviderError.handleError=function(e,t,n,i,r,o,a,s,c){let l=e;return defined(e)?(l.provider=t,l.message=i,l.x=r,l.y=o,l.level=a,l.retry=!1,l.error=c,++l.timesRetried):l=new TileProviderError(t,i,r,o,a,0,c),n.numberOfListeners>0?n.raiseEvent(l):console.log(`An error occurred in "${t.constructor.name}": ${formatError(i)}`),l.retry&&defined(s)&&s(),l},TileProviderError.handleSuccess=function(e){defined(e)&&(e.timesRetried=-1)},Object.defineProperties(WebMercatorTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),WebMercatorTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},WebMercatorTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},WebMercatorTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){const n=this._projection,i=n.project(Rectangle.southwest(e)),r=n.project(Rectangle.northeast(e));return defined(t)?(t.west=i.x,t.south=i.y,t.east=r.x,t.north=r.y,t):new Rectangle(i.x,i.y,r.x,r.y)},WebMercatorTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,n,i){const r=this.getNumberOfXTilesAtLevel(n),o=this.getNumberOfYTilesAtLevel(n),a=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/r,s=this._rectangleSouthwestInMeters.x+e*a,c=this._rectangleSouthwestInMeters.x+(e+1)*a,l=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/o,u=this._rectangleNortheastInMeters.y-t*l,d=this._rectangleNortheastInMeters.y-(t+1)*l;return defined(i)?(i.west=s,i.south=d,i.east=c,i.north=u,i):new Rectangle(s,d,c,u)},WebMercatorTilingScheme.prototype.tileXYToRectangle=function(e,t,n,i){const r=this.tileXYToNativeRectangle(e,t,n,i),o=this._projection,a=o.unproject(new Cartesian2(r.west,r.south)),s=o.unproject(new Cartesian2(r.east,r.north));return r.west=a.longitude,r.south=a.latitude,r.east=s.longitude,r.north=s.latitude,r},WebMercatorTilingScheme.prototype.positionToTileXY=function(e,t,n){const i=this._rectangle;if(!Rectangle.contains(i,e))return;const r=this.getNumberOfXTilesAtLevel(t),o=this.getNumberOfYTilesAtLevel(t),a=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/r,s=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/o,c=this._projection.project(e);let l=(c.x-this._rectangleSouthwestInMeters.x)/a|0;l>=r&&(l=r-1);let u=(this._rectangleNortheastInMeters.y-c.y)/s|0;return u>=o&&(u=o-1),defined(n)?(n.x=l,n.y=u,n):new Cartesian2(l,u)};const ALL_CHILDREN=15;function ArcGISTiledElevationTerrainProvider(e){this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._ready=!1,this._width=void 0,this._height=void 0,this._encoding=void 0;const t=e.token;this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailablityLoaded=void 0,this._availableCache={};const n=this,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._readyPromise=when(e.url).then((function(e){let i=Resource.createIfNeeded(e);i.appendForwardSlash(),defined(t)&&(i=i.getDerivedResource({queryParameters:{token:t}})),n._resource=i;return i.getDerivedResource({queryParameters:{f:"pjson"}}).fetchJson()})).then((function(e){const t=e.copyrightText;defined(t)&&(n._credit=new Credit(t));const r=e.spatialReference,o=defaultValue(r.latestWkid,r.wkid),a=e.extent,s={ellipsoid:i};if(4326===o)s.rectangle=Rectangle.fromDegrees(a.xmin,a.ymin,a.xmax,a.ymax),n._tilingScheme=new GeographicTilingScheme(s);else{if(3857!==o)return when.reject(new RuntimeError("Invalid spatial reference"));s.rectangleSouthwestInMeters=new Cartesian2(a.xmin,a.ymin),s.rectangleNortheastInMeters=new Cartesian2(a.xmax,a.ymax),n._tilingScheme=new WebMercatorTilingScheme(s)}const c=e.tileInfo;if(!defined(c))return when.reject(new RuntimeError("tileInfo is required"));n._width=c.rows+1,n._height=c.cols+1,n._encoding="LERC"===c.format?HeightmapEncoding$1.LERC:HeightmapEncoding$1.NONE,n._lodCount=c.lods.length-1;return(n._hasAvailability=-1!==e.capabilities.indexOf("Tilemap"))&&(n._tilesAvailable=new TileAvailability(n._tilingScheme,n._lodCount),n._tilesAvailable.addAvailableTileRange(0,0,0,n._tilingScheme.getNumberOfXTilesAtLevel(0),n._tilingScheme.getNumberOfYTilesAtLevel(0)),n._tilesAvailablityLoaded=new TileAvailability(n._tilingScheme,n._lodCount)),n._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(n._tilingScheme.ellipsoid,n._width,n._tilingScheme.getNumberOfXTilesAtLevel(0)),e.bandCount>1&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),n._terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:e.minValues[0],highestEncodedHeight:e.maxValues[0]},n._ready=!0,!0})).otherwise((function(e){const t=`An error occurred while accessing ${n._resource.url}.`;return TileProviderError.handleError(void 0,n,n._errorEvent,t),when.reject(e)})),this._errorEvent=new Event}function isTileAvailable(e,t,n,i){if(!e._hasAvailability)return;const r=e._tilesAvailablityLoaded,o=e._tilesAvailable;return!(t>e._lodCount)&&(!!o.isTileAvailable(t,n,i)||!r.isTileAvailable(t,n,i)&&void 0)}function findRange(e,t,n,i){const r=t-1,o=n-1,a=i[e.y*t+e.x],s=[],c={startX:e.x,startY:e.y,endX:0,endY:0},l=new Cartesian2(e.x+1,e.y+1);let u=!1,d=!1;for(;!u||!d;){let n=l.x;const h=d?l.y+1:l.y;if(!u){for(let n=e.y;n<h;++n)if(i[n*t+l.x]!==a){u=!0;break}u?(s.push(new Cartesian2(l.x,e.y)),--l.x,--n,c.endX=l.x):l.x===r?(c.endX=l.x,u=!0):++l.x}if(!d){const r=l.y*t;for(let t=e.x;t<=n;++t)if(i[r+t]!==a){d=!0;break}d?(s.push(new Cartesian2(e.x,l.y)),--l.y,c.endY=l.y):l.y===o?(c.endY=l.y,d=!0):++l.y}}return{endingIndices:s,range:c,value:a}}function computeAvailability(e,t,n,i,r){const o=[];if(r.every((function(e){return e===r[0]})))return 1===r[0]&&o.push({startX:e,startY:t,endX:e+n-1,endY:t+i-1}),o;let a=[new Cartesian2(0,0)];for(;a.length>0;){const s=findRange(a.pop(),n,i,r);if(1===s.value){const n=s.range;n.startX+=e,n.endX+=e,n.startY+=t,n.endY+=t,o.push(n)}const c=s.endingIndices;c.length>0&&(a=a.concat(c))}return o}function requestAvailability(e,t,n,i){if(!e._hasAvailability)return{};const r=128*Math.floor(n/128),o=128*Math.floor(i/128),a=Math.min(1<<t,128),s=`tilemap/${t}/${o}/${r}/${a}/${a}`,c=e._availableCache;if(defined(c[s]))return c[s];const l=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN});let u=e._resource.getDerivedResource({url:s,request:l}).fetchJson();return defined(u)?(u=u.then((function(s){const c=computeAvailability(r,o,a,a,s.data);e._tilesAvailablityLoaded.addAvailableTileRange(t,r,o,r+a,o+a);const l=e._tilesAvailable;for(let e=0;e<c.length;++e){const n=c[e];l.addAvailableTileRange(t,n.startX,n.startY,n.endX,n.endY)}return isTileAvailable(e,t,n,i)})),c[s]={promise:u,request:l},u=u.always((function(e){return delete c[s],e})),{promise:u,request:l}):{}}Object.defineProperties(ArcGISTiledElevationTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){return this._tilesAvailable}}}),ArcGISTiledElevationTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){const r=this._resource.getDerivedResource({url:`tile/${n}/${t}/${e}`,request:i}),o=this._hasAvailability;let a,s=when.resolve(!0);if(o&&!defined(isTileAvailable(this,n+1,2*e,2*t))){const i=requestAvailability(this,n+1,2*e,2*t);s=i.promise,a=i.request}const c=r.fetchArrayBuffer();if(!defined(c)||!defined(s))return;const l=this,u=this._tilesAvailable;return when.join(c,s).then((function(i){return new HeightmapTerrainData({buffer:i[0],width:l._width,height:l._height,childTileMask:o?u.computeChildMaskForTile(n,e,t):ALL_CHILDREN,structure:l._terrainDataStructure,encoding:l._encoding})})).otherwise((function(e){return defined(a)&&a.state===RequestState$1.CANCELLED?(i.cancel(),i.deferred.promise.always((function(){return i.state=RequestState$1.CANCELLED,when.reject(e)}))):when.reject(e)}))},ArcGISTiledElevationTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},ArcGISTiledElevationTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){if(!this._hasAvailability)return;const i=isTileAvailable(this,n,e,t);if(defined(i))return i;requestAvailability(this,n,e,t)},ArcGISTiledElevationTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){};const ArcType={NONE:0,GEODESIC:1,RHUMB:2};var ArcType$1=Object.freeze(ArcType);function AssociativeArray(){this._array=[],this._hash={}}Object.defineProperties(AssociativeArray.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),AssociativeArray.prototype.contains=function(e){return defined(this._hash[e])},AssociativeArray.prototype.set=function(e,t){t!==this._hash[e]&&(this.remove(e),this._hash[e]=t,this._array.push(t))},AssociativeArray.prototype.get=function(e){return this._hash[e]},AssociativeArray.prototype.remove=function(e){const t=this._hash[e],n=defined(t);if(n){const n=this._array;n.splice(n.indexOf(t),1),delete this._hash[e]}return n},AssociativeArray.prototype.removeAll=function(){const e=this._array;e.length>0&&(this._hash={},e.length=0)};const url="https://dev.virtualearth.net/REST/v1/Locations";function BingMapsGeocoderService(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).key;this._key=t;const n={key:t};defined(e.culture)&&(n.culture=e.culture),this._resource=new Resource({url:url,queryParameters:n})}function BoundingRectangle(e,t,n,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.width=defaultValue(n,0),this.height=defaultValue(i,0)}Object.defineProperties(BingMapsGeocoderService.prototype,{url:{get:function(){return url}},key:{get:function(){return this._key}}}),BingMapsGeocoderService.prototype.geocode=function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then((function(e){if(0===e.resourceSets.length)return[];return e.resourceSets[0].resources.map((function(e){const t=e.bbox,n=t[0],i=t[1],r=t[2],o=t[3];return{displayName:e.name,destination:Rectangle.fromDegrees(i,n,o,r)}}))}))},BoundingRectangle.packedLength=4,BoundingRectangle.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.width,t[n]=e.height,t},BoundingRectangle.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new BoundingRectangle),n.x=e[t++],n.y=e[t++],n.width=e[t++],n.height=e[t],n},BoundingRectangle.fromPoints=function(e,t){if(defined(t)||(t=new BoundingRectangle),!defined(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;const n=e.length;let i=e[0].x,r=e[0].y,o=e[0].x,a=e[0].y;for(let t=1;t<n;t++){const n=e[t],s=n.x,c=n.y;i=Math.min(s,i),o=Math.max(s,o),r=Math.min(c,r),a=Math.max(c,a)}return t.x=i,t.y=r,t.width=o-i,t.height=a-r,t};const defaultProjection=new GeographicProjection,fromRectangleLowerLeft=new Cartographic,fromRectangleUpperRight=new Cartographic;function arrayFill(e,t,n,i){if("function"==typeof e.fill)return e.fill(t,n,i);const r=e.length>>>0,o=defaultValue(n,0);let a=o<0?Math.max(r+o,0):Math.min(o,r);const s=defaultValue(i,r),c=s<0?Math.max(r+s,0):Math.min(s,r);for(;a<c;)e[a]=t,a++;return e}BoundingRectangle.fromRectangle=function(e,t,n){if(defined(n)||(n=new BoundingRectangle),!defined(e))return n.x=0,n.y=0,n.width=0,n.height=0,n;const i=(t=defaultValue(t,defaultProjection)).project(Rectangle.southwest(e,fromRectangleLowerLeft)),r=t.project(Rectangle.northeast(e,fromRectangleUpperRight));return Cartesian2.subtract(r,i,r),n.x=i.x,n.y=i.y,n.width=r.x,n.height=r.y,n},BoundingRectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new BoundingRectangle(e.x,e.y,e.width,e.height)},BoundingRectangle.union=function(e,t,n){defined(n)||(n=new BoundingRectangle);const i=Math.min(e.x,t.x),r=Math.min(e.y,t.y),o=Math.max(e.x+e.width,t.x+t.width),a=Math.max(e.y+e.height,t.y+t.height);return n.x=i,n.y=r,n.width=o-i,n.height=a-r,n},BoundingRectangle.expand=function(e,t,n){n=BoundingRectangle.clone(e,n);const i=t.x-n.x,r=t.y-n.y;return i>n.width?n.width=i:i<0&&(n.width-=i,n.x=t.x),r>n.height?n.height=r:r<0&&(n.height-=r,n.y=t.y),n},BoundingRectangle.intersect=function(e,t){const n=e.x,i=e.y,r=t.x,o=t.y;return n>r+t.width||n+e.width<r||i+e.height<o||i>o+t.height?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},BoundingRectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},BoundingRectangle.prototype.clone=function(e){return BoundingRectangle.clone(this,e)},BoundingRectangle.prototype.intersect=function(e){return BoundingRectangle.intersect(this,e)},BoundingRectangle.prototype.equals=function(e){return BoundingRectangle.equals(this,e)};const GeometryType={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};var GeometryType$1=Object.freeze(GeometryType);const PrimitiveType={POINTS:WebGLConstants$1.POINTS,LINES:WebGLConstants$1.LINES,LINE_LOOP:WebGLConstants$1.LINE_LOOP,LINE_STRIP:WebGLConstants$1.LINE_STRIP,TRIANGLES:WebGLConstants$1.TRIANGLES,TRIANGLE_STRIP:WebGLConstants$1.TRIANGLE_STRIP,TRIANGLE_FAN:WebGLConstants$1.TRIANGLE_FAN,validate:function(e){return e===PrimitiveType.POINTS||e===PrimitiveType.LINES||e===PrimitiveType.LINE_LOOP||e===PrimitiveType.LINE_STRIP||e===PrimitiveType.TRIANGLES||e===PrimitiveType.TRIANGLE_STRIP||e===PrimitiveType.TRIANGLE_FAN}};var PrimitiveType$1=Object.freeze(PrimitiveType);function Geometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=defaultValue(e.geometryType,GeometryType$1.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}Geometry.computeNumberOfVertices=function(e){let t=-1;for(const n in e.attributes)if(e.attributes.hasOwnProperty(n)&&defined(e.attributes[n])&&defined(e.attributes[n].values)){const i=e.attributes[n];t=i.values.length/i.componentsPerAttribute}return t};const rectangleCenterScratch$3=new Cartographic,enuCenterScratch=new Cartesian3,fixedFrameToEnuScratch=new Matrix4,boundingRectanglePointsCartographicScratch=[new Cartographic,new Cartographic,new Cartographic],boundingRectanglePointsEnuScratch=[new Cartesian2,new Cartesian2,new Cartesian2],points2DScratch$2=[new Cartesian2,new Cartesian2,new Cartesian2],pointEnuScratch=new Cartesian3,enuRotationScratch=new Quaternion,enuRotationMatrixScratch=new Matrix4,rotation2DScratch$1=new Matrix2;function GeometryAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.values=e.values}function GeometryAttributes(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}Geometry._textureCoordinateRotationPoints=function(e,t,n,i){let r;const o=Rectangle.center(i,rectangleCenterScratch$3),a=Cartographic.toCartesian(o,n,enuCenterScratch),s=Transforms.eastNorthUpToFixedFrame(a,n,fixedFrameToEnuScratch),c=Matrix4.inverse(s,fixedFrameToEnuScratch),l=boundingRectanglePointsEnuScratch,u=boundingRectanglePointsCartographicScratch;u[0].longitude=i.west,u[0].latitude=i.south,u[1].longitude=i.west,u[1].latitude=i.north,u[2].longitude=i.east,u[2].latitude=i.south;let d=pointEnuScratch;for(r=0;r<3;r++)Cartographic.toCartesian(u[r],n,d),d=Matrix4.multiplyByPointAsVector(c,d,d),l[r].x=d.x,l[r].y=d.y;const h=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-t,enuRotationScratch),p=Matrix3.fromQuaternion(h,enuRotationMatrixScratch),f=e.length;let m=Number.POSITIVE_INFINITY,g=Number.POSITIVE_INFINITY,_=Number.NEGATIVE_INFINITY,y=Number.NEGATIVE_INFINITY;for(r=0;r<f;r++)d=Matrix4.multiplyByPointAsVector(c,e[r],d),d=Matrix3.multiplyByVector(p,d,d),m=Math.min(m,d.x),g=Math.min(g,d.y),_=Math.max(_,d.x),y=Math.max(y,d.y);const C=Matrix2.fromRotation(t,rotation2DScratch$1),T=points2DScratch$2;T[0].x=m,T[0].y=g,T[1].x=m,T[1].y=y,T[2].x=_,T[2].y=g;const S=l[0],A=l[2].x-S.x,v=l[1].y-S.y;for(r=0;r<3;r++){const e=T[r];Matrix2.multiplyByVector(C,e,e),e.x=(e.x-S.x)/A,e.y=(e.y-S.y)/v}const E=T[0],b=T[1],x=T[2],P=new Array(6);return Cartesian2.pack(E,P),Cartesian2.pack(b,P,2),Cartesian2.pack(x,P,4),P};const GeometryOffsetAttribute={NONE:0,TOP:1,ALL:2};var GeometryOffsetAttribute$1=Object.freeze(GeometryOffsetAttribute);function VertexFormat(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=defaultValue(e.position,!1),this.normal=defaultValue(e.normal,!1),this.st=defaultValue(e.st,!1),this.bitangent=defaultValue(e.bitangent,!1),this.tangent=defaultValue(e.tangent,!1),this.color=defaultValue(e.color,!1)}VertexFormat.POSITION_ONLY=Object.freeze(new VertexFormat({position:!0})),VertexFormat.POSITION_AND_NORMAL=Object.freeze(new VertexFormat({position:!0,normal:!0})),VertexFormat.POSITION_NORMAL_AND_ST=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0})),VertexFormat.POSITION_AND_ST=Object.freeze(new VertexFormat({position:!0,st:!0})),VertexFormat.POSITION_AND_COLOR=Object.freeze(new VertexFormat({position:!0,color:!0})),VertexFormat.ALL=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),VertexFormat.DEFAULT=VertexFormat.POSITION_NORMAL_AND_ST,VertexFormat.packedLength=6,VertexFormat.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.position?1:0,t[n++]=e.normal?1:0,t[n++]=e.st?1:0,t[n++]=e.tangent?1:0,t[n++]=e.bitangent?1:0,t[n]=e.color?1:0,t},VertexFormat.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new VertexFormat),n.position=1===e[t++],n.normal=1===e[t++],n.st=1===e[t++],n.tangent=1===e[t++],n.bitangent=1===e[t++],n.color=1===e[t],n},VertexFormat.clone=function(e,t){if(defined(e))return defined(t)||(t=new VertexFormat),t.position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};const diffScratch$1=new Cartesian3;function BoxGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,n=e.maximum,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._minimum=Cartesian3.clone(t),this._maximum=Cartesian3.clone(n),this._vertexFormat=i,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}BoxGeometry.fromDimensions=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,n=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxGeometry({minimum:Cartesian3.negate(n,new Cartesian3),maximum:n,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},BoxGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxGeometry({minimum:e.minimum,maximum:e.maximum})},BoxGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+1,BoxGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._minimum,t,n),Cartesian3.pack(e._maximum,t,n+Cartesian3.packedLength),VertexFormat.pack(e._vertexFormat,t,n+2*Cartesian3.packedLength),t[n+2*Cartesian3.packedLength+VertexFormat.packedLength]=defaultValue(e._offsetAttribute,-1),t};const scratchMin$4=new Cartesian3,scratchMax$4=new Cartesian3,scratchVertexFormat$c=new VertexFormat,scratchOptions$n={minimum:scratchMin$4,maximum:scratchMax$4,vertexFormat:scratchVertexFormat$c,offsetAttribute:void 0};let unitBoxGeometry;BoxGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchMin$4),r=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$4),o=VertexFormat.unpack(e,t+2*Cartesian3.packedLength,scratchVertexFormat$c),a=e[t+2*Cartesian3.packedLength+VertexFormat.packedLength];return defined(n)?(n._minimum=Cartesian3.clone(i,n._minimum),n._maximum=Cartesian3.clone(r,n._maximum),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._offsetAttribute=-1===a?void 0:a,n):(scratchOptions$n.offsetAttribute=-1===a?void 0:a,new BoxGeometry(scratchOptions$n))},BoxGeometry.createGeometry=function(e){const t=e._minimum,n=e._maximum,i=e._vertexFormat;if(Cartesian3.equals(t,n))return;const r=new GeometryAttributes;let o,a;if(i.position&&(i.st||i.normal||i.tangent||i.bitangent)){if(i.position&&(a=new Float64Array(72),a[0]=t.x,a[1]=t.y,a[2]=n.z,a[3]=n.x,a[4]=t.y,a[5]=n.z,a[6]=n.x,a[7]=n.y,a[8]=n.z,a[9]=t.x,a[10]=n.y,a[11]=n.z,a[12]=t.x,a[13]=t.y,a[14]=t.z,a[15]=n.x,a[16]=t.y,a[17]=t.z,a[18]=n.x,a[19]=n.y,a[20]=t.z,a[21]=t.x,a[22]=n.y,a[23]=t.z,a[24]=n.x,a[25]=t.y,a[26]=t.z,a[27]=n.x,a[28]=n.y,a[29]=t.z,a[30]=n.x,a[31]=n.y,a[32]=n.z,a[33]=n.x,a[34]=t.y,a[35]=n.z,a[36]=t.x,a[37]=t.y,a[38]=t.z,a[39]=t.x,a[40]=n.y,a[41]=t.z,a[42]=t.x,a[43]=n.y,a[44]=n.z,a[45]=t.x,a[46]=t.y,a[47]=n.z,a[48]=t.x,a[49]=n.y,a[50]=t.z,a[51]=n.x,a[52]=n.y,a[53]=t.z,a[54]=n.x,a[55]=n.y,a[56]=n.z,a[57]=t.x,a[58]=n.y,a[59]=n.z,a[60]=t.x,a[61]=t.y,a[62]=t.z,a[63]=n.x,a[64]=t.y,a[65]=t.z,a[66]=n.x,a[67]=t.y,a[68]=n.z,a[69]=t.x,a[70]=t.y,a[71]=n.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})),i.normal){const e=new Float32Array(72);e[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=1,e[9]=0,e[10]=0,e[11]=1,e[12]=0,e[13]=0,e[14]=-1,e[15]=0,e[16]=0,e[17]=-1,e[18]=0,e[19]=0,e[20]=-1,e[21]=0,e[22]=0,e[23]=-1,e[24]=1,e[25]=0,e[26]=0,e[27]=1,e[28]=0,e[29]=0,e[30]=1,e[31]=0,e[32]=0,e[33]=1,e[34]=0,e[35]=0,e[36]=-1,e[37]=0,e[38]=0,e[39]=-1,e[40]=0,e[41]=0,e[42]=-1,e[43]=0,e[44]=0,e[45]=-1,e[46]=0,e[47]=0,e[48]=0,e[49]=1,e[50]=0,e[51]=0,e[52]=1,e[53]=0,e[54]=0,e[55]=1,e[56]=0,e[57]=0,e[58]=1,e[59]=0,e[60]=0,e[61]=-1,e[62]=0,e[63]=0,e[64]=-1,e[65]=0,e[66]=0,e[67]=-1,e[68]=0,e[69]=0,e[70]=-1,e[71]=0,r.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}if(i.st){const e=new Float32Array(48);e[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=1,e[5]=1,e[6]=0,e[7]=1,e[8]=1,e[9]=0,e[10]=0,e[11]=0,e[12]=0,e[13]=1,e[14]=1,e[15]=1,e[16]=0,e[17]=0,e[18]=1,e[19]=0,e[20]=1,e[21]=1,e[22]=0,e[23]=1,e[24]=1,e[25]=0,e[26]=0,e[27]=0,e[28]=0,e[29]=1,e[30]=1,e[31]=1,e[32]=1,e[33]=0,e[34]=0,e[35]=0,e[36]=0,e[37]=1,e[38]=1,e[39]=1,e[40]=0,e[41]=0,e[42]=1,e[43]=0,e[44]=1,e[45]=1,e[46]=0,e[47]=1,r.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:e})}if(i.tangent){const e=new Float32Array(72);e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0,e[6]=1,e[7]=0,e[8]=0,e[9]=1,e[10]=0,e[11]=0,e[12]=-1,e[13]=0,e[14]=0,e[15]=-1,e[16]=0,e[17]=0,e[18]=-1,e[19]=0,e[20]=0,e[21]=-1,e[22]=0,e[23]=0,e[24]=0,e[25]=1,e[26]=0,e[27]=0,e[28]=1,e[29]=0,e[30]=0,e[31]=1,e[32]=0,e[33]=0,e[34]=1,e[35]=0,e[36]=0,e[37]=-1,e[38]=0,e[39]=0,e[40]=-1,e[41]=0,e[42]=0,e[43]=-1,e[44]=0,e[45]=0,e[46]=-1,e[47]=0,e[48]=-1,e[49]=0,e[50]=0,e[51]=-1,e[52]=0,e[53]=0,e[54]=-1,e[55]=0,e[56]=0,e[57]=-1,e[58]=0,e[59]=0,e[60]=1,e[61]=0,e[62]=0,e[63]=1,e[64]=0,e[65]=0,e[66]=1,e[67]=0,e[68]=0,e[69]=1,e[70]=0,e[71]=0,r.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}if(i.bitangent){const e=new Float32Array(72);e[0]=0,e[1]=1,e[2]=0,e[3]=0,e[4]=1,e[5]=0,e[6]=0,e[7]=1,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=1,e[14]=0,e[15]=0,e[16]=1,e[17]=0,e[18]=0,e[19]=1,e[20]=0,e[21]=0,e[22]=1,e[23]=0,e[24]=0,e[25]=0,e[26]=1,e[27]=0,e[28]=0,e[29]=1,e[30]=0,e[31]=0,e[32]=1,e[33]=0,e[34]=0,e[35]=1,e[36]=0,e[37]=0,e[38]=1,e[39]=0,e[40]=0,e[41]=1,e[42]=0,e[43]=0,e[44]=1,e[45]=0,e[46]=0,e[47]=1,e[48]=0,e[49]=0,e[50]=1,e[51]=0,e[52]=0,e[53]=1,e[54]=0,e[55]=0,e[56]=1,e[57]=0,e[58]=0,e[59]=1,e[60]=0,e[61]=0,e[62]=1,e[63]=0,e[64]=0,e[65]=1,e[66]=0,e[67]=0,e[68]=1,e[69]=0,e[70]=0,e[71]=1,r.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}o=new Uint16Array(36),o[0]=0,o[1]=1,o[2]=2,o[3]=0,o[4]=2,o[5]=3,o[6]=6,o[7]=5,o[8]=4,o[9]=7,o[10]=6,o[11]=4,o[12]=8,o[13]=9,o[14]=10,o[15]=8,o[16]=10,o[17]=11,o[18]=14,o[19]=13,o[20]=12,o[21]=15,o[22]=14,o[23]=12,o[24]=18,o[25]=17,o[26]=16,o[27]=19,o[28]=18,o[29]=16,o[30]=20,o[31]=21,o[32]=22,o[33]=20,o[34]=22,o[35]=23}else a=new Float64Array(24),a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=n.x,a[4]=t.y,a[5]=t.z,a[6]=n.x,a[7]=n.y,a[8]=t.z,a[9]=t.x,a[10]=n.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=n.z,a[15]=n.x,a[16]=t.y,a[17]=n.z,a[18]=n.x,a[19]=n.y,a[20]=n.z,a[21]=t.x,a[22]=n.y,a[23]=n.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),o=new Uint16Array(36),o[0]=4,o[1]=5,o[2]=6,o[3]=4,o[4]=6,o[5]=7,o[6]=1,o[7]=0,o[8]=3,o[9]=1,o[10]=3,o[11]=2,o[12]=1,o[13]=6,o[14]=5,o[15]=1,o[16]=2,o[17]=6,o[18]=2,o[19]=3,o[20]=7,o[21]=2,o[22]=7,o[23]=6,o[24]=3,o[25]=0,o[26]=4,o[27]=3,o[28]=4,o[29]=7,o[30]=0,o[31]=1,o[32]=5,o[33]=0,o[34]=5,o[35]=4;const s=Cartesian3.subtract(n,t,diffScratch$1),c=.5*Cartesian3.magnitude(s);if(defined(e._offsetAttribute)){const t=a.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:r,indices:o,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,c),offsetAttribute:e._offsetAttribute})},BoxGeometry.getUnitBox=function(){return defined(unitBoxGeometry)||(unitBoxGeometry=BoxGeometry.createGeometry(BoxGeometry.fromDimensions({dimensions:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitBoxGeometry};const diffScratch=new Cartesian3;function BoxOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,n=e.maximum;this._min=Cartesian3.clone(t),this._max=Cartesian3.clone(n),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}BoxOutlineGeometry.fromDimensions=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,n=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxOutlineGeometry({minimum:Cartesian3.negate(n,new Cartesian3),maximum:n,offsetAttribute:e.offsetAttribute})},BoxOutlineGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxOutlineGeometry({minimum:e.minimum,maximum:e.maximum})},BoxOutlineGeometry.packedLength=2*Cartesian3.packedLength+1,BoxOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._min,t,n),Cartesian3.pack(e._max,t,n+Cartesian3.packedLength),t[n+2*Cartesian3.packedLength]=defaultValue(e._offsetAttribute,-1),t};const scratchMin$3=new Cartesian3,scratchMax$3=new Cartesian3,scratchOptions$m={minimum:scratchMin$3,maximum:scratchMax$3,offsetAttribute:void 0};function CartographicGeocoderService(){}function Spline(){this.times=void 0,this.points=void 0,DeveloperError.throwInstantiationError()}function LinearSpline(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,n=e.times;this._times=n,this._points=t,this._lastTimeIndex=0}BoxOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchMin$3),r=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$3),o=e[t+2*Cartesian3.packedLength];return defined(n)?(n._min=Cartesian3.clone(i,n._min),n._max=Cartesian3.clone(r,n._max),n._offsetAttribute=-1===o?void 0:o,n):(scratchOptions$m.offsetAttribute=-1===o?void 0:o,new BoxOutlineGeometry(scratchOptions$m))},BoxOutlineGeometry.createGeometry=function(e){const t=e._min,n=e._max;if(Cartesian3.equals(t,n))return;const i=new GeometryAttributes,r=new Uint16Array(24),o=new Float64Array(24);o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=n.x,o[4]=t.y,o[5]=t.z,o[6]=n.x,o[7]=n.y,o[8]=t.z,o[9]=t.x,o[10]=n.y,o[11]=t.z,o[12]=t.x,o[13]=t.y,o[14]=n.z,o[15]=n.x,o[16]=t.y,o[17]=n.z,o[18]=n.x,o[19]=n.y,o[20]=n.z,o[21]=t.x,o[22]=n.y,o[23]=n.z,i.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o}),r[0]=4,r[1]=5,r[2]=5,r[3]=6,r[4]=6,r[5]=7,r[6]=7,r[7]=4,r[8]=0,r[9]=1,r[10]=1,r[11]=2,r[12]=2,r[13]=3,r[14]=3,r[15]=0,r[16]=0,r[17]=4,r[18]=1,r[19]=5,r[20]=2,r[21]=6,r[22]=3,r[23]=7;const a=Cartesian3.subtract(n,t,diffScratch),s=.5*Cartesian3.magnitude(a);if(defined(e._offsetAttribute)){const t=o.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),i.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:i,indices:r,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,s),offsetAttribute:e._offsetAttribute})},CartographicGeocoderService.prototype.geocode=function(e){const t=e.match(/[^\s,\n]+/g);if(2===t.length||3===t.length){let n=+t[0],i=+t[1];const r=3===t.length?+t[2]:300;if(isNaN(n)&&isNaN(i)){const e=/^(\d+.?\d*)([nsew])/i;for(let r=0;r<t.length;++r){const o=t[r].match(e);e.test(t[r])&&3===o.length&&(/^[ns]/i.test(o[2])?i=/^[n]/i.test(o[2])?+o[1]:-o[1]:/^[ew]/i.test(o[2])&&(n=/^[e]/i.test(o[2])?+o[1]:-o[1]))}}if(!isNaN(n)&&!isNaN(i)&&!isNaN(r)){const t={displayName:e,destination:Cartesian3.fromDegrees(n,i,r)};return when.resolve([t])}}return when.resolve([])},Spline.prototype.evaluate=DeveloperError.throwInstantiationError,Spline.prototype.findTimeInterval=function(e,t){const n=this.times,i=n.length;if(e>=n[t=defaultValue(t,0)]){if(t+1<i&&e<n[t+1])return t;if(t+2<i&&e<n[t+2])return t+1}else if(t-1>=0&&e>=n[t-1])return t-1;let r;if(e>n[t])for(r=t;r<i-1&&!(e>=n[r]&&e<n[r+1]);++r);else for(r=t-1;r>=0&&!(e>=n[r]&&e<n[r+1]);--r);return r===i-1&&(r=i-2),r},Spline.prototype.wrapTime=function(e){const t=this.times,n=t[t.length-1],i=t[0],r=n-i;let o;return e<i&&(o=Math.floor((i-e)/r)+1,e+=o*r),e>n&&(o=Math.floor((e-n)/r)+1,e-=o*r),e},Spline.prototype.clampTime=function(e){const t=this.times;return CesiumMath.clamp(e,t[0],t[t.length-1])},Object.defineProperties(LinearSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),LinearSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,LinearSpline.prototype.wrapTime=Spline.prototype.wrapTime,LinearSpline.prototype.clampTime=Spline.prototype.clampTime,LinearSpline.prototype.evaluate=function(e,t){const n=this.points,i=this.times,r=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),o=(e-i[r])/(i[r+1]-i[r]);return defined(t)||(t=new Cartesian3),Cartesian3.lerp(n[r],n[r+1],o,t)};const TridiagonalSystemSolver={solve:function(e,t,n,i){const r=new Array(n.length),o=new Array(i.length),a=new Array(i.length);let s,c;for(s=0;s<o.length;s++)o[s]=new Cartesian3,a[s]=new Cartesian3;for(r[0]=n[0]/t[0],o[0]=Cartesian3.multiplyByScalar(i[0],1/t[0],o[0]),s=1;s<r.length;++s)c=1/(t[s]-r[s-1]*e[s-1]),r[s]=n[s]*c,o[s]=Cartesian3.subtract(i[s],Cartesian3.multiplyByScalar(o[s-1],e[s-1],o[s]),o[s]),o[s]=Cartesian3.multiplyByScalar(o[s],c,o[s]);for(c=1/(t[s]-r[s-1]*e[s-1]),o[s]=Cartesian3.subtract(i[s],Cartesian3.multiplyByScalar(o[s-1],e[s-1],o[s]),o[s]),o[s]=Cartesian3.multiplyByScalar(o[s],c,o[s]),a[a.length-1]=o[o.length-1],s=a.length-2;s>=0;--s)a[s]=Cartesian3.subtract(o[s],Cartesian3.multiplyByScalar(a[s+1],r[s],a[s]),a[s]);return a}},scratchLower=[],scratchDiagonal=[],scratchUpper=[],scratchRight$3=[];function generateClamped(e,t,n){const i=scratchLower,r=scratchUpper,o=scratchDiagonal,a=scratchRight$3;let s;i.length=r.length=e.length-1,o.length=a.length=e.length,i[0]=o[0]=1,r[0]=0;let c=a[0];for(defined(c)||(c=a[0]=new Cartesian3),Cartesian3.clone(t,c),s=1;s<i.length-1;++s)i[s]=r[s]=1,o[s]=4,c=a[s],defined(c)||(c=a[s]=new Cartesian3),Cartesian3.subtract(e[s+1],e[s-1],c),Cartesian3.multiplyByScalar(c,3,c);return i[s]=0,r[s]=1,o[s]=4,c=a[s],defined(c)||(c=a[s]=new Cartesian3),Cartesian3.subtract(e[s+1],e[s-1],c),Cartesian3.multiplyByScalar(c,3,c),o[s+1]=1,c=a[s+1],defined(c)||(c=a[s+1]=new Cartesian3),Cartesian3.clone(n,c),TridiagonalSystemSolver.solve(i,o,r,a)}function generateNatural(e){const t=scratchLower,n=scratchUpper,i=scratchDiagonal,r=scratchRight$3;let o;t.length=n.length=e.length-1,i.length=r.length=e.length,t[0]=n[0]=1,i[0]=2;let a=r[0];for(defined(a)||(a=r[0]=new Cartesian3),Cartesian3.subtract(e[1],e[0],a),Cartesian3.multiplyByScalar(a,3,a),o=1;o<t.length;++o)t[o]=n[o]=1,i[o]=4,a=r[o],defined(a)||(a=r[o]=new Cartesian3),Cartesian3.subtract(e[o+1],e[o-1],a),Cartesian3.multiplyByScalar(a,3,a);return i[o]=2,a=r[o],defined(a)||(a=r[o]=new Cartesian3),Cartesian3.subtract(e[o],e[o-1],a),Cartesian3.multiplyByScalar(a,3,a),TridiagonalSystemSolver.solve(t,i,n,r)}function HermiteSpline(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,n=e.times,i=e.inTangents,r=e.outTangents;this._times=n,this._points=t,this._inTangents=i,this._outTangents=r,this._lastTimeIndex=0}Object.defineProperties(HermiteSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),HermiteSpline.createC1=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,n=e.points,i=e.tangents,r=i.slice(0,i.length-1);return new HermiteSpline({times:t,points:n,inTangents:i.slice(1,i.length),outTangents:r})},HermiteSpline.createNaturalCubic=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,n=e.points;if(n.length<3)return new LinearSpline({points:n,times:t});const i=generateNatural(n),r=i.slice(0,i.length-1);return new HermiteSpline({times:t,points:n,inTangents:i.slice(1,i.length),outTangents:r})},HermiteSpline.createClampedCubic=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,n=e.points,i=e.firstTangent,r=e.lastTangent;if(n.length<3)return new LinearSpline({points:n,times:t});const o=generateClamped(n,i,r),a=o.slice(0,o.length-1);return new HermiteSpline({times:t,points:n,inTangents:o.slice(1,o.length),outTangents:a})},HermiteSpline.hermiteCoefficientMatrix=new Matrix4(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),HermiteSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval;const scratchTimeVec$1=new Cartesian4,scratchTemp=new Cartesian3;HermiteSpline.prototype.wrapTime=Spline.prototype.wrapTime,HermiteSpline.prototype.clampTime=Spline.prototype.clampTime,HermiteSpline.prototype.evaluate=function(e,t){defined(t)||(t=new Cartesian3);const n=this.points,i=this.times,r=this.inTangents,o=this.outTangents,a=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),s=(e-i[a])/(i[a+1]-i[a]),c=scratchTimeVec$1;c.z=s,c.y=s*s,c.x=c.y*s,c.w=1;const l=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,c,c);return t=Cartesian3.multiplyByScalar(n[a],l.x,t),Cartesian3.multiplyByScalar(n[a+1],l.y,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(o[a],l.z,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(r[a],l.w,scratchTemp),Cartesian3.add(t,scratchTemp,t)};const scratchTimeVec=new Cartesian4,scratchTemp0=new Cartesian3,scratchTemp1=new Cartesian3;function createEvaluateFunction$1(e){const t=e.points,n=e.times;if(t.length<3){const e=n[0],i=1/(n[1]-e),r=t[0],o=t[1];return function(t,n){defined(n)||(n=new Cartesian3);const a=(t-e)*i;return Cartesian3.lerp(r,o,a,n)}}return function(i,r){defined(r)||(r=new Cartesian3);const o=e._lastTimeIndex=e.findTimeInterval(i,e._lastTimeIndex),a=(i-n[o])/(n[o+1]-n[o]),s=scratchTimeVec;let c,l,u,d,h;return s.z=a,s.y=a*a,s.x=s.y*a,s.w=1,0===o?(c=t[0],l=t[1],u=e.firstTangent,d=Cartesian3.subtract(t[2],c,scratchTemp0),Cartesian3.multiplyByScalar(d,.5,d),h=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,s,s)):o===t.length-2?(c=t[o],l=t[o+1],d=e.lastTangent,u=Cartesian3.subtract(l,t[o-1],scratchTemp0),Cartesian3.multiplyByScalar(u,.5,u),h=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,s,s)):(c=t[o-1],l=t[o],u=t[o+1],d=t[o+2],h=Matrix4.multiplyByVector(CatmullRomSpline.catmullRomCoefficientMatrix,s,s)),r=Cartesian3.multiplyByScalar(c,h.x,r),Cartesian3.multiplyByScalar(l,h.y,scratchTemp1),Cartesian3.add(r,scratchTemp1,r),Cartesian3.multiplyByScalar(u,h.z,scratchTemp1),Cartesian3.add(r,scratchTemp1,r),Cartesian3.multiplyByScalar(d,h.w,scratchTemp1),Cartesian3.add(r,scratchTemp1,r)}}const firstTangentScratch=new Cartesian3,lastTangentScratch=new Cartesian3;function CatmullRomSpline(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,n=e.times;let i=e.firstTangent,r=e.lastTangent;if(t.length>2&&(defined(i)||(i=firstTangentScratch,Cartesian3.multiplyByScalar(t[1],2,i),Cartesian3.subtract(i,t[2],i),Cartesian3.subtract(i,t[0],i),Cartesian3.multiplyByScalar(i,.5,i)),!defined(r))){const e=t.length-1;r=lastTangentScratch,Cartesian3.multiplyByScalar(t[e-1],2,r),Cartesian3.subtract(t[e],r,r),Cartesian3.add(r,t[e-2],r),Cartesian3.multiplyByScalar(r,.5,r)}this._times=n,this._points=t,this._firstTangent=Cartesian3.clone(i),this._lastTangent=Cartesian3.clone(r),this._evaluateFunction=createEvaluateFunction$1(this),this._lastTimeIndex=0}function getStringFromTypedArray(e,t,n){return t=defaultValue(t,0),n=defaultValue(n,e.byteLength-t),e=e.subarray(t,t+n),getStringFromTypedArray.decode(e)}function inRange(e,t,n){return t<=e&&e<=n}function utf8Handler(e){let t=0,n=0,i=0,r=128,o=191;const a=[],s=e.length;for(let c=0;c<s;++c){const s=e[c];if(0===i){if(inRange(s,0,127)){a.push(s);continue}if(inRange(s,194,223)){i=1,t=31&s;continue}if(inRange(s,224,239)){224===s&&(r=160),237===s&&(o=159),i=2,t=15&s;continue}if(inRange(s,240,244)){240===s&&(r=144),244===s&&(o=143),i=3,t=7&s;continue}throw new RuntimeError("String decoding failed.")}inRange(s,r,o)?(r=128,o=191,t=t<<6|63&s,++n,n===i&&(a.push(t),t=i=n=0)):(t=i=n=0,r=128,o=191,--c)}return a}function getJsonFromTypedArray(e,t,n){return JSON.parse(getStringFromTypedArray(e,t,n))}Object.defineProperties(CatmullRomSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),CatmullRomSpline.catmullRomCoefficientMatrix=new Matrix4(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),CatmullRomSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,CatmullRomSpline.prototype.wrapTime=Spline.prototype.wrapTime,CatmullRomSpline.prototype.clampTime=Spline.prototype.clampTime,CatmullRomSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},getStringFromTypedArray.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)},getStringFromTypedArray.decodeWithFromCharCode=function(e){let t="";const n=utf8Handler(e),i=n.length;for(let e=0;e<i;++e){let i=n[e];i<=65535?t+=String.fromCharCode(i):(i-=65536,t+=String.fromCharCode(55296+(i>>10),56320+(1023&i)))}return t},"undefined"!=typeof TextDecoder?getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithTextDecoder:getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithFromCharCode;const Intersections2D={};function QuantizedMeshTerrainData(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;const t=this._quantizedVertices.length/3,n=this._uValues=this._quantizedVertices.subarray(0,t),i=this._vValues=this._quantizedVertices.subarray(t,2*t);function r(e,t){return i[e]-i[t]}function o(e,t){return n[e]-n[t]}this._heightValues=this._quantizedVertices.subarray(2*t,3*t),this._westIndices=sortIndicesIfNecessary(e.westIndices,r,t),this._southIndices=sortIndicesIfNecessary(e.southIndices,o,t),this._eastIndices=sortIndicesIfNecessary(e.eastIndices,r,t),this._northIndices=sortIndicesIfNecessary(e.northIndices,o,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=defaultValue(e.childTileMask,15),this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Intersections2D.clipTriangleAtAxisAlignedThreshold=function(e,t,n,i,r,o){let a,s,c;defined(o)?o.length=0:o=[],t?(a=n<e,s=i<e,c=r<e):(a=n>e,s=i>e,c=r>e);const l=a+s+c;let u,d,h,p,f,m;return 1===l?a?(u=(e-n)/(i-n),d=(e-n)/(r-n),o.push(1),o.push(2),1!==d&&(o.push(-1),o.push(0),o.push(2),o.push(d)),1!==u&&(o.push(-1),o.push(0),o.push(1),o.push(u))):s?(h=(e-i)/(r-i),p=(e-i)/(n-i),o.push(2),o.push(0),1!==p&&(o.push(-1),o.push(1),o.push(0),o.push(p)),1!==h&&(o.push(-1),o.push(1),o.push(2),o.push(h))):c&&(f=(e-r)/(n-r),m=(e-r)/(i-r),o.push(0),o.push(1),1!==m&&(o.push(-1),o.push(2),o.push(1),o.push(m)),1!==f&&(o.push(-1),o.push(2),o.push(0),o.push(f))):2===l?a||n===e?s||i===e?c||r===e||(d=(e-n)/(r-n),h=(e-i)/(r-i),o.push(2),o.push(-1),o.push(0),o.push(2),o.push(d),o.push(-1),o.push(1),o.push(2),o.push(h)):(m=(e-r)/(i-r),u=(e-n)/(i-n),o.push(1),o.push(-1),o.push(2),o.push(1),o.push(m),o.push(-1),o.push(0),o.push(1),o.push(u)):(p=(e-i)/(n-i),f=(e-r)/(n-r),o.push(0),o.push(-1),o.push(1),o.push(0),o.push(p),o.push(-1),o.push(2),o.push(0),o.push(f)):3!==l&&(o.push(0),o.push(1),o.push(2)),o},Intersections2D.computeBarycentricCoordinates=function(e,t,n,i,r,o,a,s,c){const l=n-a,u=a-r,d=o-s,h=i-s,p=1/(d*l+u*h),f=t-s,m=e-a,g=(d*m+u*f)*p,_=(-h*m+l*f)*p,y=1-g-_;return defined(c)?(c.x=g,c.y=_,c.z=y,c):new Cartesian3(g,_,y)},Intersections2D.computeLineSegmentLineSegmentIntersection=function(e,t,n,i,r,o,a,s,c){const l=(s-o)*(n-e)-(a-r)*(i-t);if(0===l)return;const u=((a-r)*(t-o)-(s-o)*(e-r))/l,d=((n-e)*(t-o)-(i-t)*(e-r))/l;return u>=0&&u<=1&&d>=0&&d<=1?(defined(c)||(c=new Cartesian2),c.x=e+u*(n-e),c.y=t+u*(i-t),c):void 0},Object.defineProperties(QuantizedMeshTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return defined(this._mesh)}}});const arrayScratch$1=[];function sortIndicesIfNecessary(e,t,n){arrayScratch$1.length=e.length;let i=!1;for(let n=0,r=e.length;n<r;++n)arrayScratch$1[n]=e[n],i=i||n>0&&t(e[n-1],e[n])>0;return i?(arrayScratch$1.sort(t),IndexDatatype$1.createTypedArray(n,arrayScratch$1)):e}const createMeshTaskName$1="createVerticesFromQuantizedTerrainMesh",createMeshTaskProcessorNoThrottle$1=new TaskProcessor(createMeshTaskName$1),createMeshTaskProcessorThrottle$1=new TaskProcessor(createMeshTaskName$1,TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.createMesh=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,n=e.x,i=e.y,r=e.level,o=defaultValue(e.exaggeration,1),a=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),c=t.ellipsoid,l=t.tileXYToRectangle(n,i,r),u=(s?createMeshTaskProcessorThrottle$1:createMeshTaskProcessorNoThrottle$1).scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:l,relativeToCenter:this._boundingSphere.center,ellipsoid:c,exaggeration:o,exaggerationRelativeHeight:a});if(!defined(u))return;const d=this;return when(u,(function(e){const t=d._quantizedVertices.length/3,n=t+d._westIndices.length+d._southIndices.length+d._eastIndices.length+d._northIndices.length,i=IndexDatatype$1.createTypedArray(n,e.indices),r=new Float32Array(e.vertices),o=e.center,a=e.minimumHeight,s=e.maximumHeight,c=d._boundingSphere,l=d._orientedBoundingBox,u=defaultValue(Cartesian3.clone(e.occludeePointInScaledSpace),d._horizonOcclusionPoint),h=e.vertexStride,p=TerrainEncoding.clone(e.encoding);return d._mesh=new TerrainMesh(o,r,i,e.indexCountWithoutSkirts,t,a,s,c,u,h,l,p,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),d._quantizedVertices=void 0,d._encodedNormals=void 0,d._indices=void 0,d._uValues=void 0,d._vValues=void 0,d._heightValues=void 0,d._westIndices=void 0,d._southIndices=void 0,d._eastIndices=void 0,d._northIndices=void 0,d._mesh}))};const upsampleTaskProcessor$1=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.upsample=function(e,t,n,i,r,o,a){const s=this._mesh;if(!defined(this._mesh))return;const c=2*t!==r,l=2*n===o,u=e.ellipsoid,d=e.tileXYToRectangle(r,o,a),h=upsampleTaskProcessor$1.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:c,isNorthChild:l,childRectangle:d,ellipsoid:u});if(!defined(h))return;let p=Math.min(this._westSkirtHeight,this._eastSkirtHeight);p=Math.min(p,this._southSkirtHeight),p=Math.min(p,this._northSkirtHeight);const f=c?.5*p:this._westSkirtHeight,m=l?.5*p:this._southSkirtHeight,g=c?this._eastSkirtHeight:.5*p,_=l?this._northSkirtHeight:.5*p,y=this._credits;return when(h).then((function(e){const t=new Uint16Array(e.vertices),n=IndexDatatype$1.createTypedArray(t.length/3,e.indices);let i;return defined(e.encodedNormals)&&(i=new Uint8Array(e.encodedNormals)),new QuantizedMeshTerrainData({quantizedVertices:t,indices:n,encodedNormals:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:f,southSkirtHeight:m,eastSkirtHeight:g,northSkirtHeight:_,childTileMask:0,credits:y,createdByUpsampling:!0})}))};const maxShort$1=32767,barycentricCoordinateScratch$1=new Cartesian3;function pointInBoundingBox(e,t,n,i,r,o,a,s){const c=Math.min(n,r,a),l=Math.max(n,r,a),u=Math.min(i,o,s),d=Math.max(i,o,s);return e>=c&&e<=l&&t>=u&&t<=d}QuantizedMeshTerrainData.prototype.interpolateHeight=function(e,t,n){let i=CesiumMath.clamp((t-e.west)/e.width,0,1);i*=maxShort$1;let r=CesiumMath.clamp((n-e.south)/e.height,0,1);return r*=maxShort$1,defined(this._mesh)?interpolateMeshHeight$1(this,i,r):interpolateHeight$1(this,i,r)};const texCoordScratch0$1=new Cartesian2,texCoordScratch1$1=new Cartesian2,texCoordScratch2$1=new Cartesian2;function interpolateMeshHeight$1(e,t,n){const i=e._mesh,r=i.vertices,o=i.encoding,a=i.indices;for(let e=0,i=a.length;e<i;e+=3){const i=a[e],s=a[e+1],c=a[e+2],l=o.decodeTextureCoordinates(r,i,texCoordScratch0$1),u=o.decodeTextureCoordinates(r,s,texCoordScratch1$1),d=o.decodeTextureCoordinates(r,c,texCoordScratch2$1);if(pointInBoundingBox(t,n,l.x,l.y,u.x,u.y,d.x,d.y)){const e=Intersections2D.computeBarycentricCoordinates(t,n,l.x,l.y,u.x,u.y,d.x,d.y,barycentricCoordinateScratch$1);if(e.x>=-1e-15&&e.y>=-1e-15&&e.z>=-1e-15){const t=o.decodeHeight(r,i),n=o.decodeHeight(r,s),a=o.decodeHeight(r,c);return e.x*t+e.y*n+e.z*a}}}}function interpolateHeight$1(e,t,n){const i=e._uValues,r=e._vValues,o=e._heightValues,a=e._indices;for(let s=0,c=a.length;s<c;s+=3){const c=a[s],l=a[s+1],u=a[s+2],d=i[c],h=i[l],p=i[u],f=r[c],m=r[l],g=r[u];if(pointInBoundingBox(t,n,d,f,h,m,p,g)){const i=Intersections2D.computeBarycentricCoordinates(t,n,d,f,h,m,p,g,barycentricCoordinateScratch$1);if(i.x>=-1e-15&&i.y>=-1e-15&&i.z>=-1e-15){const t=i.x*o[c]+i.y*o[l]+i.z*o[u];return CesiumMath.lerp(e._minimumHeight,e._maximumHeight,t/maxShort$1)}}}}function LayerInformation(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityPromiseCache={}}function CesiumTerrainProvider(e){this._heightmapWidth=65,this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._ellipsoid=e.ellipsoid,this._requestVertexNormals=defaultValue(e.requestVertexNormals,!1),this._requestWaterMask=defaultValue(e.requestWaterMask,!1),this._requestMetadata=defaultValue(e.requestMetadata,!0),this._errorEvent=new Event;let t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._availability=void 0;const n=when.defer();this._ready=!1,this._readyPromise=n,this._tileCredits=void 0;const i=this;let r,o,a;const s=this._layers=[];let c="";const l=[];let u=0;function d(e){let t;if(!e.format)return t="The tile format is not specified in the layer.json file.",void(a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m));if(!e.tiles||0===e.tiles.length)return t="The layer.json file does not specify any tile URL templates.",void(a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m));let n=!1,p=!1,f=!1,g=!0,_=!1;if("heightmap-1.0"===e.format)_=!0,defined(i._heightmapStructure)||(i._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:65535}),p=!0,i._requestWaterMask=!0;else if(0!==e.format.indexOf("quantized-mesh-1."))return t=`The tile format "${e.format}" is invalid or not supported.`,void(a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m));const y=e.tiles,C=e.maxzoom;if(u=Math.max(u,C),e.projection&&"EPSG:4326"!==e.projection){if("EPSG:3857"!==e.projection)return t=`The projection "${e.projection}" is invalid or not supported.`,void(a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m));i._tilingScheme=new WebMercatorTilingScheme({numberOfLevelZeroTilesX:1,numberOfLevelZeroTilesY:1,ellipsoid:i._ellipsoid})}else i._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:i._ellipsoid});if(i._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(i._tilingScheme.ellipsoid,i._heightmapWidth,i._tilingScheme.getNumberOfXTilesAtLevel(0)),e.scheme&&"tms"!==e.scheme&&"slippyMap"!==e.scheme)return t=`The scheme "${e.scheme}" is invalid or not supported.`,void(a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m));let T;i._scheme=e.scheme,defined(e.extensions)&&-1!==e.extensions.indexOf("octvertexnormals")?n=!0:defined(e.extensions)&&-1!==e.extensions.indexOf("vertexnormals")&&(n=!0,g=!1),defined(e.extensions)&&-1!==e.extensions.indexOf("watermask")&&(p=!0),defined(e.extensions)&&-1!==e.extensions.indexOf("metadata")&&(f=!0);const S=e.metadataAvailability,A=e.available;let v;if(defined(A)&&!defined(S)){v=new TileAvailability(i._tilingScheme,A.length);for(let e=0;e<A.length;++e){const t=A[e],n=i._tilingScheme.getNumberOfYTilesAtLevel(e);defined(l[e])||(l[e]=[]);for(let i=0;i<t.length;++i){const r=t[i],o=n-r.endY-1,a=n-r.startY-1;l[e].push([r.startX,o,r.endX,a]),v.addAvailableTileRange(e,r.startX,o,r.endX,a)}}}else defined(S)&&(T=new TileAvailability(i._tilingScheme,C),v=new TileAvailability(i._tilingScheme,C),l[0]=[[0,0,1,0]],v.addAvailableTileRange(0,0,0,1,0));i._hasWaterMask=i._hasWaterMask||p,i._hasVertexNormals=i._hasVertexNormals||n,i._hasMetadata=i._hasMetadata||f,defined(e.attribution)&&(c.length>0&&(c+=" "),c+=e.attribution),s.push(new LayerInformation({resource:r,version:e.version,isHeightmap:_,tileUrlTemplates:y,availability:v,hasVertexNormals:n,hasWaterMask:p,hasMetadata:f,availabilityLevels:S,availabilityTilesLoaded:T,littleEndianExtensionSize:g}));const E=e.parentUrl;if(defined(E)){if(!defined(v))return console.log("A layer.json can't have a parentUrl if it does't have an available array."),when.resolve();r=r.getDerivedResource({url:E}),r.appendForwardSlash(),o=r.getDerivedResource({url:"layer.json"});const e=o.fetchJson();return when(e,d,h)}return when.resolve()}function h(e){const t=`An error occurred while accessing ${o.url}.`;a=TileProviderError.handleError(a,i,i._errorEvent,t,void 0,void 0,void 0,m)}function p(e){d(e).then((function(){if(defined(a))return;const e=l.length;if(e>0){const t=i._availability=new TileAvailability(i._tilingScheme,u);for(let n=0;n<e;++n){const e=l[n];for(let i=0;i<e.length;++i){const r=e[i];t.addAvailableTileRange(n,r[0],r[1],r[2],r[3])}}}if(c.length>0){const e=new Credit(c);defined(i._tileCredits)?i._tileCredits.push(e):i._tileCredits=[e]}i._ready=!0,i._readyPromise.resolve(!0)}))}function f(e){defined(e)&&404===e.statusCode?p({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]}):h()}function m(){when(o.fetchJson()).then(p).otherwise(f)}when(e.url).then((function(e){const t=Resource.createIfNeeded(e);t.appendForwardSlash(),r=t,o=r.getDerivedResource({url:"layer.json"}),i._tileCredits=t.credits,m()})).otherwise((function(e){n.reject(e)}))}QuantizedMeshTerrainData.prototype.isChildAvailable=function(e,t,n,i){let r=2;return n!==2*e&&++r,i!==2*t&&(r-=2),0!=(this._childTileMask&1<<r)},QuantizedMeshTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};const QuantizedMeshExtensionIds={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function getRequestHeader(e){if(!defined(e)||0===e.length)return{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"};return{Accept:`application/vnd.quantized-mesh;extensions=${e.join("-")},application/octet-stream;q=0.9,*/*;q=0.01`}}function createHeightmapTerrainData(e,t,n,i,r){const o=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new HeightmapTerrainData({buffer:o,childTileMask:new Uint8Array(t,o.byteLength,1)[0],waterMask:new Uint8Array(t,o.byteLength+1,t.byteLength-o.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function createQuantizedMeshTerrainData(e,t,n,i,r,o){const a=o.littleEndianExtensionSize;let s=0;const c=3*Float64Array.BYTES_PER_ELEMENT,l=4*Float64Array.BYTES_PER_ELEMENT,u=3*Uint16Array.BYTES_PER_ELEMENT;let d=Uint16Array.BYTES_PER_ELEMENT,h=3*d;const p=new DataView(t),f=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=c;const m=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;const g=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;const _=new BoundingSphere(new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),p.getFloat64(s+c,!0));s+=l;const y=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=c;const C=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const T=new Uint16Array(t,s,3*C);s+=C*u,C>65536&&(d=Uint32Array.BYTES_PER_ELEMENT,h=3*d);const S=T.subarray(0,C),A=T.subarray(C,2*C),v=T.subarray(2*C,3*C);AttributeCompression.zigZagDeltaDecode(S,A,v),s%d!=0&&(s+=d-s%d);const E=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const b=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,3*E);s+=E*h;let x=0;const P=b.length;for(let e=0;e<P;++e){const t=b[e];b[e]=x-t,0===t&&++x}const D=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const w=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,D);s+=D*d;const M=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const I=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,M);s+=M*d;const R=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const O=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,R);s+=R*d;const B=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;const L=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,B);let F,N;for(s+=B*d;s<p.byteLength;){const c=p.getUint8(s,!0);s+=Uint8Array.BYTES_PER_ELEMENT;const l=p.getUint32(s,a);if(s+=Uint32Array.BYTES_PER_ELEMENT,c===QuantizedMeshExtensionIds.OCT_VERTEX_NORMALS&&e._requestVertexNormals)F=new Uint8Array(t,s,2*C);else if(c===QuantizedMeshExtensionIds.WATER_MASK&&e._requestWaterMask)N=new Uint8Array(t,s,l);else if(c===QuantizedMeshExtensionIds.METADATA&&e._requestMetadata){const a=p.getUint32(s,!0);if(a>0){const i=getJsonFromTypedArray(new Uint8Array(t),s+Uint32Array.BYTES_PER_ELEMENT,a).available;if(defined(i))for(let t=0;t<i.length;++t){const r=n+t+1,a=i[t],s=e._tilingScheme.getNumberOfYTilesAtLevel(r);for(let t=0;t<a.length;++t){const n=a[t],i=s-n.endY-1,c=s-n.startY-1;e.availability.addAvailableTileRange(r,n.startX,i,n.endX,c),o.availability.addAvailableTileRange(r,n.startX,i,n.endX,c)}}}o.availabilityTilesLoaded.addAvailableTileRange(n,i,r,i,r)}s+=l}const V=5*e.getLevelMaximumGeometricError(n),$=e._tilingScheme.tileXYToRectangle(i,r,n);return new QuantizedMeshTerrainData({center:f,minimumHeight:m,maximumHeight:g,boundingSphere:_,orientedBoundingBox:OrientedBoundingBox.fromRectangle($,m,g,e._tilingScheme.ellipsoid),horizonOcclusionPoint:y,quantizedVertices:T,encodedNormals:F,indices:b,westIndices:w,southIndices:I,eastIndices:O,northIndices:L,westSkirtHeight:V,southSkirtHeight:V,eastSkirtHeight:V,northSkirtHeight:V,childTileMask:e.availability.computeChildMaskForTile(n,i,r),waterMask:N,credits:e._tileCredits})}function requestTileGeometry$1(e,t,n,i,r,o){if(!defined(r))return when.reject(new RuntimeError("Terrain tile doesn't exist"));const a=r.tileUrlTemplates;if(0===a.length)return;let s;if(e._scheme&&"tms"!==e._scheme)s=n;else{s=e._tilingScheme.getNumberOfYTilesAtLevel(i)-n-1}const c=[];let l,u;e._requestVertexNormals&&r.hasVertexNormals&&c.push(r.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),e._requestWaterMask&&r.hasWaterMask&&c.push("watermask"),e._requestMetadata&&r.hasMetadata&&c.push("metadata");const d=a[(t+s+i)%a.length],h=r.resource;defined(h._ionEndpoint)&&!defined(h._ionEndpoint.externalType)?(0!==c.length&&(u={extensions:c.join("-")}),l=getRequestHeader(void 0)):l=getRequestHeader(c);const p=h.getDerivedResource({url:d,templateValues:{version:r.version,z:i,x:t,y:s},queryParameters:u,headers:l,request:o}).fetchArrayBuffer();return defined(p)?p.then((function(o){return defined(e._heightmapStructure)?createHeightmapTerrainData(e,o):createQuantizedMeshTerrainData(e,o,i,t,n,r)})):void 0}function getAvailabilityTile(e,t,n,i){if(0===i)return;const r=e.availabilityLevels,o=i%r==0?i-r:(i/r|0)*r,a=1<<i-o;return{level:o,x:t/a|0,y:n/a|0}}function checkLayer(e,t,n,i,r,o){if(!defined(r.availabilityLevels))return{result:!1};let a;const s=function(){delete r.availabilityPromiseCache[a]},c=r.availabilityTilesLoaded,l=r.availability;let u=getAvailabilityTile(r,t,n,i);for(;defined(u);){if(l.isTileAvailable(u.level,u.x,u.y)&&!c.isTileAvailable(u.level,u.x,u.y)){let t;if(!o&&(a=`${u.level}-${u.x}-${u.y}`,t=r.availabilityPromiseCache[a],!defined(t))){const n=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN});t=requestTileGeometry$1(e,u.x,u.y,u.level,r,n),defined(t)&&(r.availabilityPromiseCache[a]=t,t.then(s))}return{result:!0,promise:t}}u=getAvailabilityTile(r,u.x,u.y,u.level)}return{result:!1}}CesiumTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){const r=this._layers;let o;const a=r.length;if(1===a)o=r[0];else for(let i=0;i<a;++i){const a=r[i];if(!defined(a.availability)||a.availability.isTileAvailable(n,e,t)){o=a;break}}return requestTileGeometry$1(this,e,t,n,o,i)},Object.defineProperties(CesiumTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}}),CesiumTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CesiumTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){if(!defined(this._availability))return;if(n>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(n,e,t))return!0;if(!this._hasMetadata)return!1;const i=this._layers,r=i.length;for(let o=0;o<r;++o){if(checkLayer(this,e,t,n,i[o],0===o).result)return}return!1},CesiumTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){if(!defined(this._availability)||n>this._availability._maximumLevel||this._availability.isTileAvailable(n,e,t)||!this._hasMetadata)return;const i=this._layers,r=i.length;for(let o=0;o<r;++o){const r=checkLayer(this,e,t,n,i[o],0===o);if(defined(r.promise))return r.promise}},CesiumTerrainProvider._getAvailabilityTile=getAvailabilityTile;const EllipseGeometryLibrary={},rotAxis=new Cartesian3,tempVec=new Cartesian3,unitQuat=new Quaternion,rotMtx=new Matrix3;function pointOnEllipsoid(e,t,n,i,r,o,a,s,c,l){const u=e+t;Cartesian3.multiplyByScalar(i,Math.cos(u),rotAxis),Cartesian3.multiplyByScalar(n,Math.sin(u),tempVec),Cartesian3.add(rotAxis,tempVec,rotAxis);let d=Math.cos(e);d*=d;let h=Math.sin(e);h*=h;const p=o/Math.sqrt(a*d+r*h)/s;return Quaternion.fromAxisAngle(rotAxis,p,unitQuat),Matrix3.fromQuaternion(unitQuat,rotMtx),Matrix3.multiplyByVector(rotMtx,c,l),Cartesian3.normalize(l,l),Cartesian3.multiplyByScalar(l,s,l),l}const scratchCartesian1$7=new Cartesian3,scratchCartesian2$a=new Cartesian3,scratchCartesian3$b=new Cartesian3,scratchNormal$6=new Cartesian3;EllipseGeometryLibrary.raisePositionsToHeight=function(e,t,n){const i=t.ellipsoid,r=t.height,o=t.extrudedHeight,a=n?e.length/3*2:e.length/3,s=new Float64Array(3*a),c=e.length,l=n?c:0;for(let t=0;t<c;t+=3){const a=t+1,c=t+2,u=Cartesian3.fromArray(e,t,scratchCartesian1$7);i.scaleToGeodeticSurface(u,u);const d=Cartesian3.clone(u,scratchCartesian2$a),h=i.geodeticSurfaceNormal(u,scratchNormal$6),p=Cartesian3.multiplyByScalar(h,r,scratchCartesian3$b);Cartesian3.add(u,p,u),n&&(Cartesian3.multiplyByScalar(h,o,p),Cartesian3.add(d,p,d),s[t+l]=d.x,s[a+l]=d.y,s[c+l]=d.z),s[t]=u.x,s[a]=u.y,s[c]=u.z}return s};const unitPosScratch=new Cartesian3,eastVecScratch=new Cartesian3,northVecScratch=new Cartesian3;function GeometryInstance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=Matrix4.clone(defaultValue(e.modelMatrix,Matrix4.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=defaultValue(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}EllipseGeometryLibrary.computeEllipsePositions=function(e,t,n){const i=e.semiMinorAxis,r=e.semiMajorAxis,o=e.rotation,a=e.center,s=8*e.granularity,c=i*i,l=r*r,u=r*i,d=Cartesian3.magnitude(a),h=Cartesian3.normalize(a,unitPosScratch);let p=Cartesian3.cross(Cartesian3.UNIT_Z,a,eastVecScratch);p=Cartesian3.normalize(p,p);const f=Cartesian3.cross(h,p,northVecScratch);let m=1+Math.ceil(CesiumMath.PI_OVER_TWO/s);const g=CesiumMath.PI_OVER_TWO/(m-1);let _=CesiumMath.PI_OVER_TWO-m*g;_<0&&(m-=Math.ceil(Math.abs(_)/g));const y=t?new Array(3*(m*(m+2)*2)):void 0;let C=0,T=scratchCartesian1$7,S=scratchCartesian2$a;const A=4*m*3;let v=A-1,E=0;const b=n?new Array(A):void 0;let x,P,D,w,M;for(_=CesiumMath.PI_OVER_TWO,T=pointOnEllipsoid(_,o,f,p,c,u,l,d,h,T),t&&(y[C++]=T.x,y[C++]=T.y,y[C++]=T.z),n&&(b[v--]=T.z,b[v--]=T.y,b[v--]=T.x),_=CesiumMath.PI_OVER_TWO-g,x=1;x<m+1;++x){if(T=pointOnEllipsoid(_,o,f,p,c,u,l,d,h,T),S=pointOnEllipsoid(Math.PI-_,o,f,p,c,u,l,d,h,S),t){for(y[C++]=T.x,y[C++]=T.y,y[C++]=T.z,D=2*x+2,P=1;P<D-1;++P)w=P/(D-1),M=Cartesian3.lerp(T,S,w,scratchCartesian3$b),y[C++]=M.x,y[C++]=M.y,y[C++]=M.z;y[C++]=S.x,y[C++]=S.y,y[C++]=S.z}n&&(b[v--]=T.z,b[v--]=T.y,b[v--]=T.x,b[E++]=S.x,b[E++]=S.y,b[E++]=S.z),_=CesiumMath.PI_OVER_TWO-(x+1)*g}for(x=m;x>1;--x){if(_=CesiumMath.PI_OVER_TWO-(x-1)*g,T=pointOnEllipsoid(-_,o,f,p,c,u,l,d,h,T),S=pointOnEllipsoid(_+Math.PI,o,f,p,c,u,l,d,h,S),t){for(y[C++]=T.x,y[C++]=T.y,y[C++]=T.z,D=2*(x-1)+2,P=1;P<D-1;++P)w=P/(D-1),M=Cartesian3.lerp(T,S,w,scratchCartesian3$b),y[C++]=M.x,y[C++]=M.y,y[C++]=M.z;y[C++]=S.x,y[C++]=S.y,y[C++]=S.z}n&&(b[v--]=T.z,b[v--]=T.y,b[v--]=T.x,b[E++]=S.x,b[E++]=S.y,b[E++]=S.z)}_=CesiumMath.PI_OVER_TWO,T=pointOnEllipsoid(-_,o,f,p,c,u,l,d,h,T);const I={};return t&&(y[C++]=T.x,y[C++]=T.y,y[C++]=T.z,I.positions=y,I.numPts=m),n&&(b[v--]=T.z,b[v--]=T.y,b[v--]=T.x,I.outerPositions=b),I};const scratchCartesian1$6=new Cartesian3,scratchCartesian2$9=new Cartesian3,scratchCartesian3$a=new Cartesian3;function barycentricCoordinates(e,t,n,i,r){let o,a,s,c,l,u,d,h;if(defined(r)||(r=new Cartesian3),defined(t.z)){if(Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,r);if(Cartesian3.equalsEpsilon(e,n,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,r);if(Cartesian3.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,r);o=Cartesian3.subtract(n,t,scratchCartesian1$6),a=Cartesian3.subtract(i,t,scratchCartesian2$9),s=Cartesian3.subtract(e,t,scratchCartesian3$a),c=Cartesian3.dot(o,o),l=Cartesian3.dot(o,a),u=Cartesian3.dot(o,s),d=Cartesian3.dot(a,a),h=Cartesian3.dot(a,s)}else{if(Cartesian2.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,r);if(Cartesian2.equalsEpsilon(e,n,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,r);if(Cartesian2.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,r);o=Cartesian2.subtract(n,t,scratchCartesian1$6),a=Cartesian2.subtract(i,t,scratchCartesian2$9),s=Cartesian2.subtract(e,t,scratchCartesian3$a),c=Cartesian2.dot(o,o),l=Cartesian2.dot(o,a),u=Cartesian2.dot(o,s),d=Cartesian2.dot(a,a),h=Cartesian2.dot(a,s)}r.y=d*u-l*h,r.z=c*h-l*u;const p=c*d-l*l;if(0!==p)return r.y/=p,r.z/=p,r.x=1-r.y-r.z,r}function EncodedCartesian3(){this.high=Cartesian3.clone(Cartesian3.ZERO),this.low=Cartesian3.clone(Cartesian3.ZERO)}EncodedCartesian3.encode=function(e,t){let n;return defined(t)||(t={high:0,low:0}),e>=0?(n=65536*Math.floor(e/65536),t.high=n,t.low=e-n):(n=65536*Math.floor(-e/65536),t.high=-n,t.low=e+n),t};const scratchEncode={high:0,low:0};EncodedCartesian3.fromCartesian=function(e,t){defined(t)||(t=new EncodedCartesian3);const n=t.high,i=t.low;return EncodedCartesian3.encode(e.x,scratchEncode),n.x=scratchEncode.high,i.x=scratchEncode.low,EncodedCartesian3.encode(e.y,scratchEncode),n.y=scratchEncode.high,i.y=scratchEncode.low,EncodedCartesian3.encode(e.z,scratchEncode),n.z=scratchEncode.high,i.z=scratchEncode.low,t};const encodedP=new EncodedCartesian3;EncodedCartesian3.writeElements=function(e,t,n){EncodedCartesian3.fromCartesian(e,encodedP);const i=encodedP.high,r=encodedP.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=r.x,t[n+4]=r.y,t[n+5]=r.z};const Tipsify={calculateACMR:function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices;let n=e.maximumIndex;const i=defaultValue(e.cacheSize,24),r=t.length;if(!defined(n)){n=0;let e=0,i=t[e];for(;e<r;)i>n&&(n=i),++e,i=t[e]}const o=[];for(let e=0;e<n+1;e++)o[e]=0;let a=i+1;for(let e=0;e<r;++e)a-o[t[e]]>i&&(o[t[e]]=a,++a);return(a-i+1)/(r/3)}};Tipsify.tipsify=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,n=e.maximumIndex,i=defaultValue(e.cacheSize,24);let r;function o(e,t,n,i,o,a,s){let c,l=-1,u=-1,d=0;for(;d<n.length;){const e=n[d];i[e].numLiveTriangles&&(c=0,o-i[e].timeStamp+2*i[e].numLiveTriangles<=t&&(c=o-i[e].timeStamp),(c>u||-1===u)&&(u=c,l=e)),++d}return-1===l?function(e,t,n,i){for(;t.length>=1;){const n=t[t.length-1];if(t.splice(t.length-1,1),e[n].numLiveTriangles>0)return n}for(;r<i;){if(e[r].numLiveTriangles>0)return++r,r-1;++r}return-1}(i,a,0,s):l}const a=t.length;let s=0,c=0,l=t[c];const u=a;if(defined(n))s=n+1;else{for(;c<u;)l>s&&(s=l),++c,l=t[c];if(-1===s)return 0;++s}const d=[];let h;for(h=0;h<s;h++)d[h]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};c=0;let p=0;for(;c<u;)d[t[c]].vertexTriangles.push(p),++d[t[c]].numLiveTriangles,d[t[c+1]].vertexTriangles.push(p),++d[t[c+1]].numLiveTriangles,d[t[c+2]].vertexTriangles.push(p),++d[t[c+2]].numLiveTriangles,++p,c+=3;let f=0,m=i+1;r=1;let g=[];const _=[];let y,C,T=0;const S=[],A=a/3,v=[];for(h=0;h<A;h++)v[h]=!1;let E,b;for(;-1!==f;){g=[],C=d[f],b=C.vertexTriangles.length;for(let e=0;e<b;++e)if(p=C.vertexTriangles[e],!v[p]){v[p]=!0,c=p+p+p;for(let e=0;e<3;++e)E=t[c],g.push(E),_.push(E),S[T]=E,++T,y=d[E],--y.numLiveTriangles,m-y.timeStamp>i&&(y.timeStamp=m,++m),++c}f=o(0,i,g,d,m,_,s)}return S};const GeometryPipeline={};function addTriangle(e,t,n,i,r){e[t++]=n,e[t++]=i,e[t++]=i,e[t++]=r,e[t++]=r,e[t]=n}function trianglesToLines(e){const t=e.length,n=t/3*6,i=IndexDatatype$1.createTypedArray(t,n);let r=0;for(let n=0;n<t;n+=3,r+=6)addTriangle(i,r,e[n],e[n+1],e[n+2]);return i}function triangleStripToLines(e){const t=e.length;if(t>=3){const n=6*(t-2),i=IndexDatatype$1.createTypedArray(t,n);addTriangle(i,0,e[0],e[1],e[2]);let r=6;for(let n=3;n<t;++n,r+=6)addTriangle(i,r,e[n-1],e[n],e[n-2]);return i}return new Uint16Array}function triangleFanToLines(e){if(e.length>0){const t=e.length-1,n=6*(t-1),i=IndexDatatype$1.createTypedArray(t,n),r=e[0];let o=0;for(let n=1;n<t;++n,o+=6)addTriangle(i,o,r,e[n],e[n+1]);return i}return new Uint16Array}function copyAttributesDescriptions(e){const t={};for(const n in e)if(e.hasOwnProperty(n)&&defined(e[n])&&defined(e[n].values)){const i=e[n];t[n]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function copyVertex(e,t,n){for(const i in t)if(t.hasOwnProperty(i)&&defined(t[i])&&defined(t[i].values)){const r=t[i];for(let t=0;t<r.componentsPerAttribute;++t)e[i].values.push(r.values[n*r.componentsPerAttribute+t])}}GeometryPipeline.toWireframe=function(e){const t=e.indices;if(defined(t)){switch(e.primitiveType){case PrimitiveType$1.TRIANGLES:e.indices=trianglesToLines(t);break;case PrimitiveType$1.TRIANGLE_STRIP:e.indices=triangleStripToLines(t);break;case PrimitiveType$1.TRIANGLE_FAN:e.indices=triangleFanToLines(t)}e.primitiveType=PrimitiveType$1.LINES}return e},GeometryPipeline.createLineSegmentsForVectors=function(e,t,n){t=defaultValue(t,"normal"),n=defaultValue(n,1e4);const i=e.attributes.position.values,r=e.attributes[t].values,o=i.length,a=new Float64Array(2*o);let s,c=0;for(let e=0;e<o;e+=3)a[c++]=i[e],a[c++]=i[e+1],a[c++]=i[e+2],a[c++]=i[e]+r[e]*n,a[c++]=i[e+1]+r[e+1]*n,a[c++]=i[e+2]+r[e+2]*n;const l=e.boundingSphere;return defined(l)&&(s=new BoundingSphere(l.center,l.radius+n)),new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})},primitiveType:PrimitiveType$1.LINES,boundingSphere:s})},GeometryPipeline.createAttributeLocations=function(e){const t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={};let r,o=0;const a=t.length;for(r=0;r<a;++r){const e=t[r];defined(n[e])&&(i[e]=o++)}for(const e in n)n.hasOwnProperty(e)&&!defined(i[e])&&(i[e]=o++);return i},GeometryPipeline.reorderForPreVertexCache=function(e){const t=Geometry.computeNumberOfVertices(e),n=e.indices;if(defined(n)){const i=new Int32Array(t);for(let e=0;e<t;e++)i[e]=-1;const r=n,o=r.length,a=IndexDatatype$1.createTypedArray(t,o);let s,c=0,l=0,u=0;for(;c<o;)s=i[r[c]],-1!==s?a[l]=s:(s=r[c],i[s]=u,a[l]=u,++u),++c,++l;e.indices=a;const d=e.attributes;for(const e in d)if(d.hasOwnProperty(e)&&defined(d[e])&&defined(d[e].values)){const n=d[e],r=n.values;let o=0;const a=n.componentsPerAttribute,s=ComponentDatatype$1.createTypedArray(n.componentDatatype,u*a);for(;o<t;){const e=i[o];if(-1!==e)for(let t=0;t<a;t++)s[a*e+t]=r[a*o+t];++o}n.values=s}}return e},GeometryPipeline.reorderForPostVertexCache=function(e,t){const n=e.indices;if(e.primitiveType===PrimitiveType$1.TRIANGLES&&defined(n)){const i=n.length;let r=0;for(let e=0;e<i;e++)n[e]>r&&(r=n[e]);e.indices=Tipsify.tipsify({indices:n,maximumIndex:r,cacheSize:t})}return e},GeometryPipeline.fitToUnsignedShortIndices=function(e){const t=[],n=Geometry.computeNumberOfVertices(e);if(defined(e.indices)&&n>=CesiumMath.SIXTY_FOUR_KILOBYTES){let n=[],i=[],r=0,o=copyAttributesDescriptions(e.attributes);const a=e.indices,s=a.length;let c;e.primitiveType===PrimitiveType$1.TRIANGLES?c=3:e.primitiveType===PrimitiveType$1.LINES?c=2:e.primitiveType===PrimitiveType$1.POINTS&&(c=1);for(let l=0;l<s;l+=c){for(let t=0;t<c;++t){const s=a[l+t];let c=n[s];defined(c)||(c=r++,n[s]=c,copyVertex(o,e.attributes,s)),i.push(c)}r+c>=CesiumMath.SIXTY_FOUR_KILOBYTES&&(t.push(new Geometry({attributes:o,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],i=[],r=0,o=copyAttributesDescriptions(e.attributes))}0!==i.length&&t.push(new Geometry({attributes:o,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};const scratchProjectTo2DCartesian3=new Cartesian3,scratchProjectTo2DCartographic=new Cartographic;GeometryPipeline.projectTo2D=function(e,t,n,i,r){const o=e.attributes[t],a=(r=defined(r)?r:new GeographicProjection).ellipsoid,s=o.values,c=new Float64Array(s.length);let l=0;for(let e=0;e<s.length;e+=3){const t=Cartesian3.fromArray(s,e,scratchProjectTo2DCartesian3),n=a.cartesianToCartographic(t,scratchProjectTo2DCartographic),i=r.project(n,scratchProjectTo2DCartesian3);c[l++]=i.x,c[l++]=i.y,c[l++]=i.z}return e.attributes[n]=o,e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c}),delete e.attributes[t],e};const encodedResult={high:0,low:0};GeometryPipeline.encodeAttribute=function(e,t,n,i){const r=e.attributes[t],o=r.values,a=o.length,s=new Float32Array(a),c=new Float32Array(a);for(let e=0;e<a;++e)EncodedCartesian3.encode(o[e],encodedResult),s[e]=encodedResult.high,c[e]=encodedResult.low;const l=r.componentsPerAttribute;return e.attributes[n]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:l,values:s}),e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:l,values:c}),delete e.attributes[t],e};let scratchCartesian3$9=new Cartesian3;function transformPoint(e,t){if(defined(t)){const n=t.values,i=n.length;for(let t=0;t<i;t+=3)Cartesian3.unpack(n,t,scratchCartesian3$9),Matrix4.multiplyByPoint(e,scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,n,t)}}function transformVector(e,t){if(defined(t)){const n=t.values,i=n.length;for(let t=0;t<i;t+=3)Cartesian3.unpack(n,t,scratchCartesian3$9),Matrix3.multiplyByVector(e,scratchCartesian3$9,scratchCartesian3$9),scratchCartesian3$9=Cartesian3.normalize(scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,n,t)}}const inverseTranspose=new Matrix4,normalMatrix=new Matrix3;function findAttributesInAllGeometries(e,t){const n=e.length,i={},r=e[0][t].attributes;let o;for(o in r)if(r.hasOwnProperty(o)&&defined(r[o])&&defined(r[o].values)){const a=r[o];let s=a.values.length,c=!0;for(let i=1;i<n;++i){const n=e[i][t].attributes[o];if(!defined(n)||a.componentDatatype!==n.componentDatatype||a.componentsPerAttribute!==n.componentsPerAttribute||a.normalize!==n.normalize){c=!1;break}s+=n.values.length}c&&(i[o]=new GeometryAttribute({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:ComponentDatatype$1.createTypedArray(a.componentDatatype,s)}))}return i}GeometryPipeline.transformToWorldCoordinates=function(e){const t=e.modelMatrix;if(Matrix4.equals(t,Matrix4.IDENTITY))return e;const n=e.geometry.attributes;transformPoint(t,n.position),transformPoint(t,n.prevPosition),transformPoint(t,n.nextPosition),(defined(n.normal)||defined(n.tangent)||defined(n.bitangent))&&(Matrix4.inverse(t,inverseTranspose),Matrix4.transpose(inverseTranspose,inverseTranspose),Matrix4.getMatrix3(inverseTranspose,normalMatrix),transformVector(normalMatrix,n.normal),transformVector(normalMatrix,n.tangent),transformVector(normalMatrix,n.bitangent));const i=e.geometry.boundingSphere;return defined(i)&&(e.geometry.boundingSphere=BoundingSphere.transform(i,t,i)),e.modelMatrix=Matrix4.clone(Matrix4.IDENTITY),e};const tempScratch$1=new Cartesian3;function combineGeometries(e,t){const n=e.length;let i,r,o,a;e[0].modelMatrix;const s=defined(e[0][t].indices),c=e[0][t].primitiveType,l=findAttributesInAllGeometries(e,t);let u,d,h,p;for(i in l)if(l.hasOwnProperty(i))for(u=l[i].values,a=0,r=0;r<n;++r)for(d=e[r][t].attributes[i].values,h=d.length,o=0;o<h;++o)u[a++]=d[o];if(s){let i=0;for(r=0;r<n;++r)i+=e[r][t].indices.length;const o=Geometry.computeNumberOfVertices(new Geometry({attributes:l,primitiveType:PrimitiveType$1.POINTS})),s=IndexDatatype$1.createTypedArray(o,i);let c=0,u=0;for(r=0;r<n;++r){const n=e[r][t].indices,i=n.length;for(a=0;a<i;++a)s[c++]=u+n[a];u+=Geometry.computeNumberOfVertices(e[r][t])}p=s}let f,m=new Cartesian3,g=0;for(r=0;r<n;++r){if(f=e[r][t].boundingSphere,!defined(f)){m=void 0;break}Cartesian3.add(f.center,m,m)}if(defined(m))for(Cartesian3.divideByScalar(m,n,m),r=0;r<n;++r){f=e[r][t].boundingSphere;const n=Cartesian3.magnitude(Cartesian3.subtract(f.center,m,tempScratch$1))+f.radius;n>g&&(g=n)}return new Geometry({attributes:l,indices:p,primitiveType:c,boundingSphere:defined(m)?new BoundingSphere(m,g):void 0})}GeometryPipeline.combineInstances=function(e){const t=[],n=[],i=e.length;for(let r=0;r<i;++r){const i=e[r];defined(i.geometry)?t.push(i):defined(i.westHemisphereGeometry)&&defined(i.eastHemisphereGeometry)&&n.push(i)}const r=[];return t.length>0&&r.push(combineGeometries(t,"geometry")),n.length>0&&(r.push(combineGeometries(n,"westHemisphereGeometry")),r.push(combineGeometries(n,"eastHemisphereGeometry"))),r};const normal=new Cartesian3,v0=new Cartesian3,v1$1=new Cartesian3,v2$1=new Cartesian3;GeometryPipeline.computeNormal=function(e){const t=e.indices,n=e.attributes,i=n.position.values,r=n.position.values.length/3,o=t.length,a=new Array(r),s=new Array(o/3),c=new Array(o);let l;for(l=0;l<r;l++)a[l]={indexOffset:0,count:0,currentCount:0};let u=0;for(l=0;l<o;l+=3){const e=t[l],n=t[l+1],r=t[l+2],o=3*e,c=3*n,d=3*r;v0.x=i[o],v0.y=i[o+1],v0.z=i[o+2],v1$1.x=i[c],v1$1.y=i[c+1],v1$1.z=i[c+2],v2$1.x=i[d],v2$1.y=i[d+1],v2$1.z=i[d+2],a[e].count++,a[n].count++,a[r].count++,Cartesian3.subtract(v1$1,v0,v1$1),Cartesian3.subtract(v2$1,v0,v2$1),s[u]=Cartesian3.cross(v1$1,v2$1,new Cartesian3),u++}let d,h=0;for(l=0;l<r;l++)a[l].indexOffset+=h,h+=a[l].count;for(u=0,l=0;l<o;l+=3){d=a[t[l]];let e=d.indexOffset+d.currentCount;c[e]=u,d.currentCount++,d=a[t[l+1]],e=d.indexOffset+d.currentCount,c[e]=u,d.currentCount++,d=a[t[l+2]],e=d.indexOffset+d.currentCount,c[e]=u,d.currentCount++,u++}const p=new Float32Array(3*r);for(l=0;l<r;l++){const e=3*l;if(d=a[l],Cartesian3.clone(Cartesian3.ZERO,normal),d.count>0){for(u=0;u<d.count;u++)Cartesian3.add(normal,s[c[d.indexOffset+u]],normal);Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&Cartesian3.clone(s[c[d.indexOffset]],normal)}Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&(normal.z=1),Cartesian3.normalize(normal,normal),p[e]=normal.x,p[e+1]=normal.y,p[e+2]=normal.z}return e.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p}),e};const normalScratch$4=new Cartesian3,normalScale=new Cartesian3,tScratch=new Cartesian3;GeometryPipeline.computeTangentAndBitangent=function(e){e.attributes;const t=e.indices,n=e.attributes.position.values,i=e.attributes.normal.values,r=e.attributes.st.values,o=e.attributes.position.values.length/3,a=t.length,s=new Array(3*o);let c,l,u,d;for(c=0;c<s.length;c++)s[c]=0;for(c=0;c<a;c+=3){const e=t[c],i=t[c+1],o=t[c+2];l=3*e,u=3*i,d=3*o;const a=2*e,h=2*i,p=2*o,f=n[l],m=n[l+1],g=n[l+2],_=r[a],y=r[a+1],C=r[h+1]-y,T=r[p+1]-y,S=1/((r[h]-_)*T-(r[p]-_)*C),A=(T*(n[u]-f)-C*(n[d]-f))*S,v=(T*(n[u+1]-m)-C*(n[d+1]-m))*S,E=(T*(n[u+2]-g)-C*(n[d+2]-g))*S;s[l]+=A,s[l+1]+=v,s[l+2]+=E,s[u]+=A,s[u+1]+=v,s[u+2]+=E,s[d]+=A,s[d+1]+=v,s[d+2]+=E}const h=new Float32Array(3*o),p=new Float32Array(3*o);for(c=0;c<o;c++){l=3*c,u=l+1,d=l+2;const e=Cartesian3.fromArray(i,l,normalScratch$4),t=Cartesian3.fromArray(s,l,tScratch),n=Cartesian3.dot(e,t);Cartesian3.multiplyByScalar(e,n,normalScale),Cartesian3.normalize(Cartesian3.subtract(t,normalScale,t),t),h[l]=t.x,h[u]=t.y,h[d]=t.z,Cartesian3.normalize(Cartesian3.cross(e,t,t),t),p[l]=t.x,p[u]=t.y,p[d]=t.z}return e.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h}),e.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p}),e};const scratchCartesian2$8=new Cartesian2,toEncode1=new Cartesian3,toEncode2=new Cartesian3,toEncode3=new Cartesian3;let encodeResult2=new Cartesian2;function indexTriangles(e){if(defined(e.indices))return e;const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,t);for(let e=0;e<t;++e)n[e]=e;return e.indices=n,e}function indexTriangleFan(e){const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,3*(t-2));n[0]=1,n[1]=0,n[2]=2;let i=3;for(let e=3;e<t;++e)n[i++]=e-1,n[i++]=0,n[i++]=e;return e.indices=n,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexTriangleStrip(e){const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,3*(t-2));n[0]=0,n[1]=1,n[2]=2,t>3&&(n[3]=0,n[4]=2,n[5]=3);let i=6;for(let e=3;e<t-1;e+=2)n[i++]=e,n[i++]=e-1,n[i++]=e+1,e+2<t&&(n[i++]=e,n[i++]=e+1,n[i++]=e+2);return e.indices=n,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexLines(e){if(defined(e.indices))return e;const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,t);for(let e=0;e<t;++e)n[e]=e;return e.indices=n,e}function indexLineStrip(e){const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,2*(t-1));n[0]=0,n[1]=1;let i=2;for(let e=2;e<t;++e)n[i++]=e-1,n[i++]=e;return e.indices=n,e.primitiveType=PrimitiveType$1.LINES,e}function indexLineLoop(e){const t=Geometry.computeNumberOfVertices(e),n=IndexDatatype$1.createTypedArray(t,2*t);n[0]=0,n[1]=1;let i=2;for(let e=2;e<t;++e)n[i++]=e-1,n[i++]=e;return n[i++]=t-1,n[i]=0,e.indices=n,e.primitiveType=PrimitiveType$1.LINES,e}function indexPrimitive(e){switch(e.primitiveType){case PrimitiveType$1.TRIANGLE_FAN:return indexTriangleFan(e);case PrimitiveType$1.TRIANGLE_STRIP:return indexTriangleStrip(e);case PrimitiveType$1.TRIANGLES:return indexTriangles(e);case PrimitiveType$1.LINE_STRIP:return indexLineStrip(e);case PrimitiveType$1.LINE_LOOP:return indexLineLoop(e);case PrimitiveType$1.LINES:return indexLines(e)}return e}function offsetPointFromXZPlane(e,t){Math.abs(e.y)<CesiumMath.EPSILON6&&(e.y=t?-CesiumMath.EPSILON6:CesiumMath.EPSILON6)}function offsetTriangleFromXZPlane(e,t,n){if(0!==e.y&&0!==t.y&&0!==n.y)return offsetPointFromXZPlane(e,e.y<0),offsetPointFromXZPlane(t,t.y<0),void offsetPointFromXZPlane(n,n.y<0);const i=Math.abs(e.y),r=Math.abs(t.y),o=Math.abs(n.y);let a;a=i>r?i>o?CesiumMath.sign(e.y):CesiumMath.sign(n.y):r>o?CesiumMath.sign(t.y):CesiumMath.sign(n.y);const s=a<0;offsetPointFromXZPlane(e,s),offsetPointFromXZPlane(t,s),offsetPointFromXZPlane(n,s)}GeometryPipeline.compressVertices=function(e){const t=e.attributes.extrudeDirection;let n,i;if(defined(t)){const r=t.values;i=r.length/3;const o=new Float32Array(2*i);let a=0;for(n=0;n<i;++n)Cartesian3.fromArray(r,3*n,toEncode1),Cartesian3.equals(toEncode1,Cartesian3.ZERO)?a+=2:(encodeResult2=AttributeCompression.octEncodeInRange(toEncode1,65535,encodeResult2),o[a++]=encodeResult2.x,o[a++]=encodeResult2.y);return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:o}),delete e.attributes.extrudeDirection,e}const r=e.attributes.normal,o=e.attributes.st,a=defined(r),s=defined(o);if(!a&&!s)return e;const c=e.attributes.tangent,l=e.attributes.bitangent,u=defined(c),d=defined(l);let h,p,f,m;a&&(h=r.values),s&&(p=o.values),u&&(f=c.values),d&&(m=l.values);i=(a?h.length:p.length)/(a?3:2);let g=i,_=s&&a?2:1;_+=u||d?1:0,g*=_;const y=new Float32Array(g);let C=0;for(n=0;n<i;++n){s&&(Cartesian2.fromArray(p,2*n,scratchCartesian2$8),y[C++]=AttributeCompression.compressTextureCoordinates(scratchCartesian2$8));const e=3*n;a&&defined(f)&&defined(m)?(Cartesian3.fromArray(h,e,toEncode1),Cartesian3.fromArray(f,e,toEncode2),Cartesian3.fromArray(m,e,toEncode3),AttributeCompression.octPack(toEncode1,toEncode2,toEncode3,scratchCartesian2$8),y[C++]=scratchCartesian2$8.x,y[C++]=scratchCartesian2$8.y):(a&&(Cartesian3.fromArray(h,e,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),u&&(Cartesian3.fromArray(f,e,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),d&&(Cartesian3.fromArray(m,e,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)))}return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:_,values:y}),a&&delete e.attributes.normal,s&&delete e.attributes.st,d&&delete e.attributes.bitangent,u&&delete e.attributes.tangent,e};const c3$1=new Cartesian3;function getXZIntersectionOffsetPoints(e,t,n,i){Cartesian3.add(e,Cartesian3.multiplyByScalar(Cartesian3.subtract(t,e,c3$1),e.y/(e.y-t.y),c3$1),n),Cartesian3.clone(n,i),offsetPointFromXZPlane(n,!0),offsetPointFromXZPlane(i,!1)}const u1=new Cartesian3,u2=new Cartesian3,q1=new Cartesian3,q2=new Cartesian3,splitTriangleResult={positions:new Array(7),indices:new Array(9)};function splitTriangle(e,t,n){if(e.x>=0||t.x>=0||n.x>=0)return;offsetTriangleFromXZPlane(e,t,n);const i=e.y<0,r=t.y<0,o=n.y<0;let a=0;a+=i?1:0,a+=r?1:0,a+=o?1:0;const s=splitTriangleResult.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,i?(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,n,u2,q2),s[0]=0,s[3]=1,s[4]=2,s[6]=1):r?(getXZIntersectionOffsetPoints(t,n,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(getXZIntersectionOffsetPoints(n,e,u1,q1),getXZIntersectionOffsetPoints(n,t,u2,q2),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,i?r?o||(getXZIntersectionOffsetPoints(n,e,u1,q1),getXZIntersectionOffsetPoints(n,t,u2,q2),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(getXZIntersectionOffsetPoints(t,n,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,n,u2,q2),s[0]=1,s[1]=2,s[3]=1,s[6]=0));const c=splitTriangleResult.positions;return c[0]=e,c[1]=t,c[2]=n,c.length=3,1!==a&&2!==a||(c[3]=u1,c[4]=u2,c[5]=q1,c[6]=q2,c.length=7),splitTriangleResult}function updateGeometryAfterSplit(e,t){const n=e.attributes;if(0===n.position.values.length)return;for(const e in n)if(n.hasOwnProperty(e)&&defined(n[e])&&defined(n[e].values)){const t=n[e];t.values=ComponentDatatype$1.createTypedArray(t.componentDatatype,t.values)}const i=Geometry.computeNumberOfVertices(e);return e.indices=IndexDatatype$1.createTypedArray(i,e.indices),t&&(e.boundingSphere=BoundingSphere.fromVertices(n.position.values)),e}function copyGeometryForSplit(e){const t=e.attributes,n={};for(const e in t)if(t.hasOwnProperty(e)&&defined(t[e])&&defined(t[e].values)){const i=t[e];n[e]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new Geometry({attributes:n,indices:[],primitiveType:e.primitiveType})}function updateInstanceAfterSplit(e,t,n){const i=defined(e.geometry.boundingSphere);t=updateGeometryAfterSplit(t,i),defined(n=updateGeometryAfterSplit(n,i))&&!defined(t)?e.geometry=n:!defined(n)&&defined(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=n,e.geometry=void 0)}function generateBarycentricInterpolateFunction(e,t){const n=new e,i=new e,r=new e;return function(o,a,s,c,l,u,d,h){const p=e.fromArray(l,o*t,n),f=e.fromArray(l,a*t,i),m=e.fromArray(l,s*t,r);e.multiplyByScalar(p,c.x,p),e.multiplyByScalar(f,c.y,f),e.multiplyByScalar(m,c.z,m);const g=e.add(p,f,p);e.add(g,m,g),h&&e.normalize(g,g),e.pack(g,u,d*t)}}const interpolateAndPackCartesian4=generateBarycentricInterpolateFunction(Cartesian4,4),interpolateAndPackCartesian3=generateBarycentricInterpolateFunction(Cartesian3,3),interpolateAndPackCartesian2=generateBarycentricInterpolateFunction(Cartesian2,2),interpolateAndPackBoolean=function(e,t,n,i,r,o,a){const s=r[e]*i.x,c=r[t]*i.y,l=r[n]*i.z;o[a]=s+c+l>CesiumMath.EPSILON6?1:0},p0Scratch=new Cartesian3,p1Scratch$2=new Cartesian3,p2Scratch$2=new Cartesian3,barycentricScratch=new Cartesian3;function computeTriangleAttributes(e,t,n,i,r,o,a,s,c,l,u,d,h,p,f,m){if(!(defined(o)||defined(a)||defined(s)||defined(c)||defined(l)||0!==p))return;const g=barycentricCoordinates(i,Cartesian3.fromArray(r,3*e,p0Scratch),Cartesian3.fromArray(r,3*t,p1Scratch$2),Cartesian3.fromArray(r,3*n,p2Scratch$2),barycentricScratch);if(defined(g)){if(defined(o)&&interpolateAndPackCartesian3(e,t,n,g,o,d.normal.values,m,!0),defined(l)){const i=Cartesian3.fromArray(l,3*e,p0Scratch),r=Cartesian3.fromArray(l,3*t,p1Scratch$2),o=Cartesian3.fromArray(l,3*n,p2Scratch$2);let a;Cartesian3.multiplyByScalar(i,g.x,i),Cartesian3.multiplyByScalar(r,g.y,r),Cartesian3.multiplyByScalar(o,g.z,o),Cartesian3.equals(i,Cartesian3.ZERO)&&Cartesian3.equals(r,Cartesian3.ZERO)&&Cartesian3.equals(o,Cartesian3.ZERO)?(a=p0Scratch,a.x=0,a.y=0,a.z=0):(a=Cartesian3.add(i,r,i),Cartesian3.add(a,o,a),Cartesian3.normalize(a,a)),Cartesian3.pack(a,d.extrudeDirection.values,3*m)}if(defined(u)&&interpolateAndPackBoolean(e,t,n,g,u,d.applyOffset.values,m),defined(a)&&interpolateAndPackCartesian3(e,t,n,g,a,d.tangent.values,m,!0),defined(s)&&interpolateAndPackCartesian3(e,t,n,g,s,d.bitangent.values,m,!0),defined(c)&&interpolateAndPackCartesian2(e,t,n,g,c,d.st.values,m),p>0)for(let i=0;i<p;i++){const r=h[i];genericInterpolate(e,t,n,g,m,f[r],d[r])}}}function genericInterpolate(e,t,n,i,r,o,a){const s=o.componentsPerAttribute,c=o.values,l=a.values;switch(s){case 4:interpolateAndPackCartesian4(e,t,n,i,c,l,r,!1);break;case 3:interpolateAndPackCartesian3(e,t,n,i,c,l,r,!1);break;case 2:interpolateAndPackCartesian2(e,t,n,i,c,l,r,!1);break;default:l[r]=c[e]*i.x+c[t]*i.y+c[n]*i.z}}function insertSplitPoint(e,t,n,i,r,o){const a=e.position.values.length/3;if(-1!==r){const s=i[r],c=n[s];return-1===c?(n[s]=a,e.position.values.push(o.x,o.y,o.z),t.push(a),a):(t.push(c),c)}return e.position.values.push(o.x,o.y,o.z),t.push(a),a}const NAMED_ATTRIBUTES={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function splitLongitudeTriangles(e){const t=e.geometry,n=t.attributes,i=n.position.values,r=defined(n.normal)?n.normal.values:void 0,o=defined(n.bitangent)?n.bitangent.values:void 0,a=defined(n.tangent)?n.tangent.values:void 0,s=defined(n.st)?n.st.values:void 0,c=defined(n.extrudeDirection)?n.extrudeDirection.values:void 0,l=defined(n.applyOffset)?n.applyOffset.values:void 0,u=t.indices,d=[];for(const e in n)n.hasOwnProperty(e)&&!NAMED_ATTRIBUTES[e]&&defined(n[e])&&d.push(e);const h=d.length,p=copyGeometryForSplit(t),f=copyGeometryForSplit(t);let m,g,_,y,C;const T=[];T.length=i.length/3;const S=[];for(S.length=i.length/3,C=0;C<T.length;++C)T[C]=-1,S[C]=-1;const A=u.length;for(C=0;C<A;C+=3){const e=u[C],t=u[C+1],A=u[C+2];let v=Cartesian3.fromArray(i,3*e),E=Cartesian3.fromArray(i,3*t),b=Cartesian3.fromArray(i,3*A);const x=splitTriangle(v,E,b);if(defined(x)&&x.positions.length>3){const v=x.positions,E=x.indices,b=E.length;for(let x=0;x<b;++x){const b=E[x],P=v[b];P.y<0?(m=f.attributes,g=f.indices,_=T):(m=p.attributes,g=p.indices,_=S),y=insertSplitPoint(m,g,_,u,b<3?C+b:-1,P),computeTriangleAttributes(e,t,A,P,i,r,a,o,s,c,l,m,d,h,n,y)}}else defined(x)&&(v=x.positions[0],E=x.positions[1],b=x.positions[2]),v.y<0?(m=f.attributes,g=f.indices,_=T):(m=p.attributes,g=p.indices,_=S),y=insertSplitPoint(m,g,_,u,C,v),computeTriangleAttributes(e,t,A,v,i,r,a,o,s,c,l,m,d,h,n,y),y=insertSplitPoint(m,g,_,u,C+1,E),computeTriangleAttributes(e,t,A,E,i,r,a,o,s,c,l,m,d,h,n,y),y=insertSplitPoint(m,g,_,u,C+2,b),computeTriangleAttributes(e,t,A,b,i,r,a,o,s,c,l,m,d,h,n,y)}updateInstanceAfterSplit(e,f,p)}const xzPlane=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),offsetScratch$c=new Cartesian3,offsetPointScratch=new Cartesian3;function computeLineAttributes(e,t,n,i,r,o,a){if(!defined(a))return;const s=Cartesian3.fromArray(i,3*e,p0Scratch);Cartesian3.equalsEpsilon(s,n,CesiumMath.EPSILON10)?o.applyOffset.values[r]=a[e]:o.applyOffset.values[r]=a[t]}function splitLongitudeLines(e){const t=e.geometry,n=t.attributes,i=n.position.values,r=defined(n.applyOffset)?n.applyOffset.values:void 0,o=t.indices,a=copyGeometryForSplit(t),s=copyGeometryForSplit(t);let c;const l=o.length,u=[];u.length=i.length/3;const d=[];for(d.length=i.length/3,c=0;c<u.length;++c)u[c]=-1,d[c]=-1;for(c=0;c<l;c+=2){const e=o[c],t=o[c+1],n=Cartesian3.fromArray(i,3*e,p0Scratch),l=Cartesian3.fromArray(i,3*t,p1Scratch$2);let h;Math.abs(n.y)<CesiumMath.EPSILON6&&(n.y<0?n.y=-CesiumMath.EPSILON6:n.y=CesiumMath.EPSILON6),Math.abs(l.y)<CesiumMath.EPSILON6&&(l.y<0?l.y=-CesiumMath.EPSILON6:l.y=CesiumMath.EPSILON6);let p=a.attributes,f=a.indices,m=d,g=s.attributes,_=s.indices,y=u;const C=IntersectionTests.lineSegmentPlane(n,l,xzPlane,p2Scratch$2);if(defined(C)){const T=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,5*CesiumMath.EPSILON9,offsetScratch$c);n.y<0&&(Cartesian3.negate(T,T),p=s.attributes,f=s.indices,m=u,g=a.attributes,_=a.indices,y=d);const S=Cartesian3.add(C,T,offsetPointScratch);h=insertSplitPoint(p,f,m,o,c,n),computeLineAttributes(e,t,n,i,h,p,r),h=insertSplitPoint(p,f,m,o,-1,S),computeLineAttributes(e,t,S,i,h,p,r),Cartesian3.negate(T,T),Cartesian3.add(C,T,S),h=insertSplitPoint(g,_,y,o,-1,S),computeLineAttributes(e,t,S,i,h,g,r),h=insertSplitPoint(g,_,y,o,c+1,l),computeLineAttributes(e,t,l,i,h,g,r)}else{let p,f,m;n.y<0?(p=s.attributes,f=s.indices,m=u):(p=a.attributes,f=a.indices,m=d),h=insertSplitPoint(p,f,m,o,c,n),computeLineAttributes(e,t,n,i,h,p,r),h=insertSplitPoint(p,f,m,o,c+1,l),computeLineAttributes(e,t,l,i,h,p,r)}}updateInstanceAfterSplit(e,s,a)}const cartesian2Scratch0=new Cartesian2,cartesian2Scratch1=new Cartesian2,cartesian3Scratch0=new Cartesian3,cartesian3Scratch2$1=new Cartesian3,cartesian3Scratch3$1=new Cartesian3,cartesian3Scratch4=new Cartesian3,cartesian3Scratch5=new Cartesian3,cartesian3Scratch6=new Cartesian3,cartesian4Scratch0=new Cartesian4;function updateAdjacencyAfterSplit(e){const t=e.attributes,n=t.position.values,i=t.prevPosition.values,r=t.nextPosition.values,o=n.length;for(let e=0;e<o;e+=3){const t=Cartesian3.unpack(n,e,cartesian3Scratch0);if(t.x>0)continue;const a=Cartesian3.unpack(i,e,cartesian3Scratch2$1);(t.y<0&&a.y>0||t.y>0&&a.y<0)&&(e-3>0?(i[e]=n[e-3],i[e+1]=n[e-2],i[e+2]=n[e-1]):Cartesian3.pack(t,i,e));const s=Cartesian3.unpack(r,e,cartesian3Scratch3$1);(t.y<0&&s.y>0||t.y>0&&s.y<0)&&(e+3<o?(r[e]=n[e+3],r[e+1]=n[e+4],r[e+2]=n[e+5]):Cartesian3.pack(t,r,e))}}const offsetScalar=5*CesiumMath.EPSILON9,coplanarOffset=CesiumMath.EPSILON6;function splitLongitudePolyline(e){const t=e.geometry,n=t.attributes,i=n.position.values,r=n.prevPosition.values,o=n.nextPosition.values,a=n.expandAndWidth.values,s=defined(n.st)?n.st.values:void 0,c=defined(n.color)?n.color.values:void 0,l=copyGeometryForSplit(t),u=copyGeometryForSplit(t);let d,h,p,f=!1;const m=i.length/3;for(d=0;d<m;d+=4){const e=d,t=d+2,n=Cartesian3.fromArray(i,3*e,cartesian3Scratch0),m=Cartesian3.fromArray(i,3*t,cartesian3Scratch2$1);if(Math.abs(n.y)<coplanarOffset)for(n.y=coplanarOffset*(m.y<0?-1:1),i[3*d+1]=n.y,i[3*(d+1)+1]=n.y,h=3*e;h<3*e+12;h+=3)r[h]=i[3*d],r[h+1]=i[3*d+1],r[h+2]=i[3*d+2];if(Math.abs(m.y)<coplanarOffset)for(m.y=coplanarOffset*(n.y<0?-1:1),i[3*(d+2)+1]=m.y,i[3*(d+3)+1]=m.y,h=3*e;h<3*e+12;h+=3)o[h]=i[3*(d+2)],o[h+1]=i[3*(d+2)+1],o[h+2]=i[3*(d+2)+2];let g=l.attributes,_=l.indices,y=u.attributes,C=u.indices;const T=IntersectionTests.lineSegmentPlane(n,m,xzPlane,cartesian3Scratch4);if(defined(T)){f=!0;const i=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,offsetScalar,cartesian3Scratch5);n.y<0&&(Cartesian3.negate(i,i),g=u.attributes,_=u.indices,y=l.attributes,C=l.indices);const S=Cartesian3.add(T,i,cartesian3Scratch6);g.position.values.push(n.x,n.y,n.z,n.x,n.y,n.z),g.position.values.push(S.x,S.y,S.z),g.position.values.push(S.x,S.y,S.z),g.prevPosition.values.push(r[3*e],r[3*e+1],r[3*e+2]),g.prevPosition.values.push(r[3*e+3],r[3*e+4],r[3*e+5]),g.prevPosition.values.push(n.x,n.y,n.z,n.x,n.y,n.z),g.nextPosition.values.push(S.x,S.y,S.z),g.nextPosition.values.push(S.x,S.y,S.z),g.nextPosition.values.push(S.x,S.y,S.z),g.nextPosition.values.push(S.x,S.y,S.z),Cartesian3.negate(i,i),Cartesian3.add(T,i,S),y.position.values.push(S.x,S.y,S.z),y.position.values.push(S.x,S.y,S.z),y.position.values.push(m.x,m.y,m.z,m.x,m.y,m.z),y.prevPosition.values.push(S.x,S.y,S.z),y.prevPosition.values.push(S.x,S.y,S.z),y.prevPosition.values.push(S.x,S.y,S.z),y.prevPosition.values.push(S.x,S.y,S.z),y.nextPosition.values.push(m.x,m.y,m.z,m.x,m.y,m.z),y.nextPosition.values.push(o[3*t],o[3*t+1],o[3*t+2]),y.nextPosition.values.push(o[3*t+3],o[3*t+4],o[3*t+5]);const A=Cartesian2.fromArray(a,2*e,cartesian2Scratch0),v=Math.abs(A.y);g.expandAndWidth.values.push(-1,v,1,v),g.expandAndWidth.values.push(-1,-v,1,-v),y.expandAndWidth.values.push(-1,v,1,v),y.expandAndWidth.values.push(-1,-v,1,-v);let E=Cartesian3.magnitudeSquared(Cartesian3.subtract(T,n,cartesian3Scratch3$1));if(E/=Cartesian3.magnitudeSquared(Cartesian3.subtract(m,n,cartesian3Scratch3$1)),defined(c)){const n=Cartesian4.fromArray(c,4*e,cartesian4Scratch0),i=Cartesian4.fromArray(c,4*t,cartesian4Scratch0),r=CesiumMath.lerp(n.x,i.x,E),o=CesiumMath.lerp(n.y,i.y,E),a=CesiumMath.lerp(n.z,i.z,E),s=CesiumMath.lerp(n.w,i.w,E);for(h=4*e;h<4*e+8;++h)g.color.values.push(c[h]);for(g.color.values.push(r,o,a,s),g.color.values.push(r,o,a,s),y.color.values.push(r,o,a,s),y.color.values.push(r,o,a,s),h=4*t;h<4*t+8;++h)y.color.values.push(c[h])}if(defined(s)){const n=Cartesian2.fromArray(s,2*e,cartesian2Scratch0),i=Cartesian2.fromArray(s,2*(d+3),cartesian2Scratch1),r=CesiumMath.lerp(n.x,i.x,E);for(h=2*e;h<2*e+4;++h)g.st.values.push(s[h]);for(g.st.values.push(r,n.y),g.st.values.push(r,i.y),y.st.values.push(r,n.y),y.st.values.push(r,i.y),h=2*t;h<2*t+4;++h)y.st.values.push(s[h])}p=g.position.values.length/3-4,_.push(p,p+2,p+1),_.push(p+1,p+2,p+3),p=y.position.values.length/3-4,C.push(p,p+2,p+1),C.push(p+1,p+2,p+3)}else{let e,t;for(n.y<0?(e=u.attributes,t=u.indices):(e=l.attributes,t=l.indices),e.position.values.push(n.x,n.y,n.z),e.position.values.push(n.x,n.y,n.z),e.position.values.push(m.x,m.y,m.z),e.position.values.push(m.x,m.y,m.z),h=3*d;h<3*d+12;++h)e.prevPosition.values.push(r[h]),e.nextPosition.values.push(o[h]);for(h=2*d;h<2*d+8;++h)e.expandAndWidth.values.push(a[h]),defined(s)&&e.st.values.push(s[h]);if(defined(c))for(h=4*d;h<4*d+16;++h)e.color.values.push(c[h]);p=e.position.values.length/3-4,t.push(p,p+2,p+1),t.push(p+1,p+2,p+3)}}f&&(updateAdjacencyAfterSplit(u),updateAdjacencyAfterSplit(l)),updateInstanceAfterSplit(e,u,l)}GeometryPipeline.splitLongitude=function(e){const t=e.geometry,n=t.boundingSphere;if(defined(n)){if(n.center.x-n.radius>0||BoundingSphere.intersectPlane(n,Plane.ORIGIN_ZX_PLANE)!==Intersect$1.INTERSECTING)return e}if(t.geometryType!==GeometryType$1.NONE)switch(t.geometryType){case GeometryType$1.POLYLINES:splitLongitudePolyline(e);break;case GeometryType$1.TRIANGLES:splitLongitudeTriangles(e);break;case GeometryType$1.LINES:splitLongitudeLines(e)}else indexPrimitive(t),t.primitiveType===PrimitiveType$1.TRIANGLES?splitLongitudeTriangles(e):t.primitiveType===PrimitiveType$1.LINES&&splitLongitudeLines(e);return e};const scratchCartesian1$5=new Cartesian3,scratchCartesian2$7=new Cartesian3,scratchCartesian3$8=new Cartesian3,scratchCartesian4$5=new Cartesian3,texCoordScratch=new Cartesian2,textureMatrixScratch$1=new Matrix3,tangentMatrixScratch$1=new Matrix3,quaternionScratch$3=new Quaternion,scratchNormal$5=new Cartesian3,scratchTangent$4=new Cartesian3,scratchBitangent$4=new Cartesian3,scratchCartographic$f=new Cartographic,projectedCenterScratch=new Cartesian3,scratchMinTexCoord=new Cartesian2,scratchMaxTexCoord=new Cartesian2;function computeTopBottomAttributes(e,t,n){const i=t.vertexFormat,r=t.center,o=t.semiMajorAxis,a=t.semiMinorAxis,s=t.ellipsoid,c=t.stRotation,l=n?e.length/3*2:e.length/3,u=t.shadowVolume,d=i.st?new Float32Array(2*l):void 0,h=i.normal?new Float32Array(3*l):void 0,p=i.tangent?new Float32Array(3*l):void 0,f=i.bitangent?new Float32Array(3*l):void 0,m=u?new Float32Array(3*l):void 0;let g=0,_=scratchNormal$5,y=scratchTangent$4,C=scratchBitangent$4;const T=new GeographicProjection(s),S=T.project(s.cartesianToCartographic(r,scratchCartographic$f),projectedCenterScratch),A=s.scaleToGeodeticSurface(r,scratchCartesian1$5);s.geodeticSurfaceNormal(A,A);let v=textureMatrixScratch$1,E=tangentMatrixScratch$1;if(0!==c){let e=Quaternion.fromAxisAngle(A,c,quaternionScratch$3);v=Matrix3.fromQuaternion(e,v),e=Quaternion.fromAxisAngle(A,-c,quaternionScratch$3),E=Matrix3.fromQuaternion(e,E)}else v=Matrix3.clone(Matrix3.IDENTITY,v),E=Matrix3.clone(Matrix3.IDENTITY,E);const b=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),x=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord);let P=e.length;const D=n?P:0,w=D/3*2;for(let t=0;t<P;t+=3){const r=t+1,c=t+2,l=Cartesian3.fromArray(e,t,scratchCartesian1$5);if(i.st){const e=Matrix3.multiplyByVector(v,l,scratchCartesian2$7),t=T.project(s.cartesianToCartographic(e,scratchCartographic$f),scratchCartesian3$8);Cartesian3.subtract(t,S,t),texCoordScratch.x=(t.x+o)/(2*o),texCoordScratch.y=(t.y+a)/(2*a),b.x=Math.min(texCoordScratch.x,b.x),b.y=Math.min(texCoordScratch.y,b.y),x.x=Math.max(texCoordScratch.x,x.x),x.y=Math.max(texCoordScratch.y,x.y),n&&(d[g+w]=texCoordScratch.x,d[g+1+w]=texCoordScratch.y),d[g++]=texCoordScratch.x,d[g++]=texCoordScratch.y}(i.normal||i.tangent||i.bitangent||u)&&(_=s.geodeticSurfaceNormal(l,_),u&&(m[t+D]=-_.x,m[r+D]=-_.y,m[c+D]=-_.z),(i.normal||i.tangent||i.bitangent)&&((i.tangent||i.bitangent)&&(y=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,_,y),y),Matrix3.multiplyByVector(E,y,y)),i.normal&&(h[t]=_.x,h[r]=_.y,h[c]=_.z,n&&(h[t+D]=-_.x,h[r+D]=-_.y,h[c+D]=-_.z)),i.tangent&&(p[t]=y.x,p[r]=y.y,p[c]=y.z,n&&(p[t+D]=-y.x,p[r+D]=-y.y,p[c+D]=-y.z)),i.bitangent&&(C=Cartesian3.normalize(Cartesian3.cross(_,y,C),C),f[t]=C.x,f[r]=C.y,f[c]=C.z,n&&(f[t+D]=C.x,f[r+D]=C.y,f[c+D]=C.z))))}if(i.st){P=d.length;for(let e=0;e<P;e+=2)d[e]=(d[e]-b.x)/(x.x-b.x),d[e+1]=(d[e+1]-b.y)/(x.y-b.y)}const M=new GeometryAttributes;if(i.position){const i=EllipseGeometryLibrary.raisePositionsToHeight(e,t,n);M.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i})}if(i.st&&(M.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),i.normal&&(M.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),i.tangent&&(M.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),i.bitangent&&(M.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),u&&(M.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),n&&defined(t.offsetAttribute)){let e=new Uint8Array(l);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)e=arrayFill(e,1,0,l/2);else{e=arrayFill(e,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}M.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}return M}function topIndices(e){const t=new Array(e*(e+1)*12-6);let n,i,r,o,a,s=0;for(n=0,r=1,o=0;o<3;o++)t[s++]=r++,t[s++]=n,t[s++]=r;for(o=2;o<e+1;++o){for(r=o*(o+1)-1,n=(o-1)*o-1,t[s++]=r++,t[s++]=n,t[s++]=r,i=2*o,a=0;a<i-1;++a)t[s++]=r,t[s++]=n++,t[s++]=n,t[s++]=r++,t[s++]=n,t[s++]=r;t[s++]=r++,t[s++]=n,t[s++]=r}for(i=2*e,++r,++n,o=0;o<i-1;++o)t[s++]=r,t[s++]=n++,t[s++]=n,t[s++]=r++,t[s++]=n,t[s++]=r;for(t[s++]=r,t[s++]=n++,t[s++]=n,t[s++]=r++,t[s++]=n++,t[s++]=n,++n,o=e-1;o>1;--o){for(t[s++]=n++,t[s++]=n,t[s++]=r,i=2*o,a=0;a<i-1;++a)t[s++]=r,t[s++]=n++,t[s++]=n,t[s++]=r++,t[s++]=n,t[s++]=r;t[s++]=n++,t[s++]=n++,t[s++]=r++}for(o=0;o<3;o++)t[s++]=n++,t[s++]=n,t[s++]=r;return t}let boundingSphereCenter$1=new Cartesian3;function computeEllipse$1(e){const t=e.center;boundingSphereCenter$1=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter$1),e.height,boundingSphereCenter$1),boundingSphereCenter$1=Cartesian3.add(t,boundingSphereCenter$1,boundingSphereCenter$1);const n=new BoundingSphere(boundingSphereCenter$1,e.semiMajorAxis),i=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!1),r=i.positions,o=i.numPts,a=computeTopBottomAttributes(r,e,!1);let s=topIndices(o);return s=IndexDatatype$1.createTypedArray(r.length/3,s),{boundingSphere:n,attributes:a,indices:s}}function computeWallAttributes(e,t){const n=t.vertexFormat,i=t.center,r=t.semiMajorAxis,o=t.semiMinorAxis,a=t.ellipsoid,s=t.height,c=t.extrudedHeight,l=t.stRotation,u=e.length/3*2,d=new Float64Array(3*u),h=n.st?new Float32Array(2*u):void 0,p=n.normal?new Float32Array(3*u):void 0,f=n.tangent?new Float32Array(3*u):void 0,m=n.bitangent?new Float32Array(3*u):void 0,g=t.shadowVolume,_=g?new Float32Array(3*u):void 0;let y=0,C=scratchNormal$5,T=scratchTangent$4,S=scratchBitangent$4;const A=new GeographicProjection(a),v=A.project(a.cartesianToCartographic(i,scratchCartographic$f),projectedCenterScratch),E=a.scaleToGeodeticSurface(i,scratchCartesian1$5);a.geodeticSurfaceNormal(E,E);const b=Quaternion.fromAxisAngle(E,l,quaternionScratch$3),x=Matrix3.fromQuaternion(b,textureMatrixScratch$1),P=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),D=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord);let w=e.length;const M=w/3*2;for(let t=0;t<w;t+=3){const i=t+1,l=t+2;let u,E=Cartesian3.fromArray(e,t,scratchCartesian1$5);if(n.st){const e=Matrix3.multiplyByVector(x,E,scratchCartesian2$7),t=A.project(a.cartesianToCartographic(e,scratchCartographic$f),scratchCartesian3$8);Cartesian3.subtract(t,v,t),texCoordScratch.x=(t.x+r)/(2*r),texCoordScratch.y=(t.y+o)/(2*o),P.x=Math.min(texCoordScratch.x,P.x),P.y=Math.min(texCoordScratch.y,P.y),D.x=Math.max(texCoordScratch.x,D.x),D.y=Math.max(texCoordScratch.y,D.y),h[y+M]=texCoordScratch.x,h[y+1+M]=texCoordScratch.y,h[y++]=texCoordScratch.x,h[y++]=texCoordScratch.y}E=a.scaleToGeodeticSurface(E,E),u=Cartesian3.clone(E,scratchCartesian2$7),C=a.geodeticSurfaceNormal(E,C),g&&(_[t+w]=-C.x,_[i+w]=-C.y,_[l+w]=-C.z);let b=Cartesian3.multiplyByScalar(C,s,scratchCartesian4$5);if(E=Cartesian3.add(E,b,E),b=Cartesian3.multiplyByScalar(C,c,b),u=Cartesian3.add(u,b,u),n.position&&(d[t+w]=u.x,d[i+w]=u.y,d[l+w]=u.z,d[t]=E.x,d[i]=E.y,d[l]=E.z),n.normal||n.tangent||n.bitangent){S=Cartesian3.clone(C,S);const r=Cartesian3.fromArray(e,(t+3)%w,scratchCartesian4$5);Cartesian3.subtract(r,E,r);const o=Cartesian3.subtract(u,E,scratchCartesian3$8);C=Cartesian3.normalize(Cartesian3.cross(o,r,C),C),n.normal&&(p[t]=C.x,p[i]=C.y,p[l]=C.z,p[t+w]=C.x,p[i+w]=C.y,p[l+w]=C.z),n.tangent&&(T=Cartesian3.normalize(Cartesian3.cross(S,C,T),T),f[t]=T.x,f[i]=T.y,f[l]=T.z,f[t+w]=T.x,f[t+1+w]=T.y,f[t+2+w]=T.z),n.bitangent&&(m[t]=S.x,m[i]=S.y,m[l]=S.z,m[t+w]=S.x,m[i+w]=S.y,m[l+w]=S.z)}}if(n.st){w=h.length;for(let e=0;e<w;e+=2)h[e]=(h[e]-P.x)/(D.x-P.x),h[e+1]=(h[e+1]-P.y)/(D.y-P.y)}const I=new GeometryAttributes;if(n.position&&(I.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})),n.st&&(I.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),n.normal&&(I.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.tangent&&(I.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),n.bitangent&&(I.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),g&&(I.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),defined(t.offsetAttribute)){let e=new Uint8Array(u);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)e=arrayFill(e,1,0,u/2);else{e=arrayFill(e,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}I.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}return I}function computeWallIndices(e){const t=e.length/3,n=IndexDatatype$1.createTypedArray(t,6*t);let i=0;for(let e=0;e<t;e++){const r=e,o=e+t,a=(r+1)%t,s=a+t;n[i++]=r,n[i++]=o,n[i++]=a,n[i++]=a,n[i++]=o,n[i++]=s}return n}const topBoundingSphere$3=new BoundingSphere,bottomBoundingSphere$3=new BoundingSphere;function computeExtrudedEllipse$1(e){const t=e.center,n=e.ellipsoid,i=e.semiMajorAxis;let r=Cartesian3.multiplyByScalar(n.geodeticSurfaceNormal(t,scratchCartesian1$5),e.height,scratchCartesian1$5);topBoundingSphere$3.center=Cartesian3.add(t,r,topBoundingSphere$3.center),topBoundingSphere$3.radius=i,r=Cartesian3.multiplyByScalar(n.geodeticSurfaceNormal(t,r),e.extrudedHeight,r),bottomBoundingSphere$3.center=Cartesian3.add(t,r,bottomBoundingSphere$3.center),bottomBoundingSphere$3.radius=i;const o=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!0),a=o.positions,s=o.numPts,c=o.outerPositions,l=BoundingSphere.union(topBoundingSphere$3,bottomBoundingSphere$3),u=computeTopBottomAttributes(a,e,!0);let d=topIndices(s);const h=d.length;d.length=2*h;const p=a.length/3;for(let e=0;e<h;e+=3)d[e+h]=d[e+2]+p,d[e+1+h]=d[e+1]+p,d[e+2+h]=d[e]+p;const f=new Geometry({attributes:u,indices:IndexDatatype$1.createTypedArray(2*p/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),m=computeWallAttributes(c,e);d=computeWallIndices(c);const g=new Geometry({attributes:m,indices:IndexDatatype$1.createTypedArray(2*c.length/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),_=GeometryPipeline.combineInstances([new GeometryInstance({geometry:f}),new GeometryInstance({geometry:g})]);return{boundingSphere:l,attributes:_[0].attributes,indices:_[0].indices}}function computeRectangle$3(e,t,n,i,r,o,a){const s=EllipseGeometryLibrary.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:n,rotation:i,granularity:r},!1,!0).outerPositions,c=s.length/3,l=new Array(c);for(let e=0;e<c;++e)l[e]=Cartesian3.fromArray(s,3*e);const u=Rectangle.fromCartesianArray(l,o,a);return u.width>CesiumMath.PI&&(u.north=u.north>0?CesiumMath.PI_OVER_TWO-CesiumMath.EPSILON7:u.north,u.south=u.south<0?CesiumMath.EPSILON7-CesiumMath.PI_OVER_TWO:u.south,u.east=CesiumMath.PI,u.west=-CesiumMath.PI),u}function EllipseGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,n=defaultValue(e.ellipsoid,Ellipsoid.WGS84),i=e.semiMajorAxis,r=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,s);this._center=Cartesian3.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=r,this._ellipsoid=Ellipsoid.clone(n),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._height=Math.max(c,s),this._granularity=o,this._vertexFormat=VertexFormat.clone(a),this._extrudedHeight=Math.min(c,s),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}EllipseGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+9,EllipseGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._center,t,n),n+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n++]=e._shadowVolume?1:0,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchCenter$7=new Cartesian3,scratchEllipsoid$e=new Ellipsoid,scratchVertexFormat$b=new VertexFormat,scratchOptions$l={center:scratchCenter$7,ellipsoid:scratchEllipsoid$e,vertexFormat:scratchVertexFormat$b,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function textureCoordinateRotationPoints$2(e){const t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];const n=EllipseGeometryLibrary.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,i=n.length/3,r=new Array(i);for(let e=0;e<i;++e)r[e]=Cartesian3.fromArray(n,3*e);const o=e._ellipsoid,a=e.rectangle;return Geometry._textureCoordinateRotationPoints(r,t,o,a)}function CircleGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,n={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new EllipseGeometry(n),this._workerName="createCircleGeometry"}EllipseGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchCenter$7);t+=Cartesian3.packedLength;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$e);t+=Ellipsoid.packedLength;const o=VertexFormat.unpack(e,t,scratchVertexFormat$b);t+=VertexFormat.packedLength;const a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],f=e[t];return defined(n)?(n._center=Cartesian3.clone(i,n._center),n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._semiMajorAxis=a,n._semiMinorAxis=s,n._rotation=c,n._stRotation=l,n._height=u,n._granularity=d,n._extrudedHeight=h,n._shadowVolume=p,n._offsetAttribute=-1===f?void 0:f,n):(scratchOptions$l.height=u,scratchOptions$l.extrudedHeight=h,scratchOptions$l.granularity=d,scratchOptions$l.stRotation=l,scratchOptions$l.rotation=c,scratchOptions$l.semiMajorAxis=a,scratchOptions$l.semiMinorAxis=s,scratchOptions$l.shadowVolume=p,scratchOptions$l.offsetAttribute=-1===f?void 0:f,new EllipseGeometry(scratchOptions$l))},EllipseGeometry.computeRectangle=function(e,t){const n=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,o=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);return computeRectangle$3(n,r,o,defaultValue(e.rotation,0),a,i,t)},EllipseGeometry.createGeometry=function(e){if(e._semiMajorAxis<=0||e._semiMinorAxis<=0)return;const t=e._height,n=e._extrudedHeight,i=!CesiumMath.equalsEpsilon(t,n,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);const r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};let o;if(i)r.extrudedHeight=n,r.shadowVolume=e._shadowVolume,r.offsetAttribute=e._offsetAttribute,o=computeExtrudedEllipse$1(r);else if(o=computeEllipse$1(r),defined(e._offsetAttribute)){const t=o.attributes.position.values.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:o.attributes,indices:o.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:o.boundingSphere,offsetAttribute:e._offsetAttribute})},EllipseGeometry.createShadowVolume=function(e,t,n){const i=e._granularity,r=e._ellipsoid,o=t(i,r),a=n(i,r);return new EllipseGeometry({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:r,rotation:e._rotation,stRotation:e._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(EllipseGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$3(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$2(this)),this._textureCoordinateRotationPoints}}}),CircleGeometry.packedLength=EllipseGeometry.packedLength,CircleGeometry.pack=function(e,t,n){return EllipseGeometry.pack(e._ellipseGeometry,t,n)};const scratchEllipseGeometry$1=new EllipseGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$k={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new VertexFormat,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};CircleGeometry.unpack=function(e,t,n){const i=EllipseGeometry.unpack(e,t,scratchEllipseGeometry$1);return scratchOptions$k.center=Cartesian3.clone(i._center,scratchOptions$k.center),scratchOptions$k.ellipsoid=Ellipsoid.clone(i._ellipsoid,scratchOptions$k.ellipsoid),scratchOptions$k.height=i._height,scratchOptions$k.extrudedHeight=i._extrudedHeight,scratchOptions$k.granularity=i._granularity,scratchOptions$k.vertexFormat=VertexFormat.clone(i._vertexFormat,scratchOptions$k.vertexFormat),scratchOptions$k.stRotation=i._stRotation,scratchOptions$k.shadowVolume=i._shadowVolume,defined(n)?(scratchOptions$k.semiMajorAxis=i._semiMajorAxis,scratchOptions$k.semiMinorAxis=i._semiMinorAxis,n._ellipseGeometry=new EllipseGeometry(scratchOptions$k),n):(scratchOptions$k.radius=i._semiMajorAxis,new CircleGeometry(scratchOptions$k))},CircleGeometry.createGeometry=function(e){return EllipseGeometry.createGeometry(e._ellipseGeometry)},CircleGeometry.createShadowVolume=function(e,t,n){const i=e._ellipseGeometry._granularity,r=e._ellipseGeometry._ellipsoid,o=t(i,r),a=n(i,r);return new CircleGeometry({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:r,stRotation:e._ellipseGeometry._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CircleGeometry.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});const scratchCartesian1$4=new Cartesian3;let boundingSphereCenter=new Cartesian3;function computeEllipse(e){const t=e.center;boundingSphereCenter=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter),e.height,boundingSphereCenter),boundingSphereCenter=Cartesian3.add(t,boundingSphereCenter,boundingSphereCenter);const n=new BoundingSphere(boundingSphereCenter,e.semiMajorAxis),i=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,r=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(i,e,!1)})}),o=i.length/3,a=IndexDatatype$1.createTypedArray(o,2*o);let s=0;for(let e=0;e<o;++e)a[s++]=e,a[s++]=(e+1)%o;return{boundingSphere:n,attributes:r,indices:a}}const topBoundingSphere$2=new BoundingSphere,bottomBoundingSphere$2=new BoundingSphere;function computeExtrudedEllipse(e){const t=e.center,n=e.ellipsoid,i=e.semiMajorAxis;let r=Cartesian3.multiplyByScalar(n.geodeticSurfaceNormal(t,scratchCartesian1$4),e.height,scratchCartesian1$4);topBoundingSphere$2.center=Cartesian3.add(t,r,topBoundingSphere$2.center),topBoundingSphere$2.radius=i,r=Cartesian3.multiplyByScalar(n.geodeticSurfaceNormal(t,r),e.extrudedHeight,r),bottomBoundingSphere$2.center=Cartesian3.add(t,r,bottomBoundingSphere$2.center),bottomBoundingSphere$2.radius=i;let o=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions;const a=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(o,e,!0)})});o=a.position.values;const s=BoundingSphere.union(topBoundingSphere$2,bottomBoundingSphere$2);let c=o.length/3;if(defined(e.offsetAttribute)){let t=new Uint8Array(c);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)t=arrayFill(t,1,0,c/2);else{t=arrayFill(t,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}a.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}let l=defaultValue(e.numberOfVerticalLines,16);l=CesiumMath.clamp(l,0,c/2);const u=IndexDatatype$1.createTypedArray(c,2*c+2*l);c/=2;let d,h,p=0;for(d=0;d<c;++d)u[p++]=d,u[p++]=(d+1)%c,u[p++]=d+c,u[p++]=(d+1)%c+c;if(l>0){const e=Math.min(l,c);h=Math.round(c/e);const t=Math.min(h*l,c);for(d=0;d<t;d+=h)u[p++]=d,u[p++]=d+c}return{boundingSphere:s,attributes:a,indices:u}}function EllipseOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,n=defaultValue(e.ellipsoid,Ellipsoid.WGS84),i=e.semiMajorAxis,r=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.height,0),s=defaultValue(e.extrudedHeight,a);this._center=Cartesian3.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=r,this._ellipsoid=Ellipsoid.clone(n),this._rotation=defaultValue(e.rotation,0),this._height=Math.max(s,a),this._granularity=o,this._extrudedHeight=Math.min(s,a),this._numberOfVerticalLines=Math.max(defaultValue(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}EllipseOutlineGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+8,EllipseOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._center,t,n),n+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n++]=e._numberOfVerticalLines,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchCenter$6=new Cartesian3,scratchEllipsoid$d=new Ellipsoid,scratchOptions$j={center:scratchCenter$6,ellipsoid:scratchEllipsoid$d,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function CircleOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,n={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new EllipseOutlineGeometry(n),this._workerName="createCircleOutlineGeometry"}EllipseOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchCenter$6);t+=Cartesian3.packedLength;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$d);t+=Ellipsoid.packedLength;const o=e[t++],a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(n)?(n._center=Cartesian3.clone(i,n._center),n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._semiMajorAxis=o,n._semiMinorAxis=a,n._rotation=s,n._height=c,n._granularity=l,n._extrudedHeight=u,n._numberOfVerticalLines=d,n._offsetAttribute=-1===h?void 0:h,n):(scratchOptions$j.height=c,scratchOptions$j.extrudedHeight=u,scratchOptions$j.granularity=l,scratchOptions$j.rotation=s,scratchOptions$j.semiMajorAxis=o,scratchOptions$j.semiMinorAxis=a,scratchOptions$j.numberOfVerticalLines=d,scratchOptions$j.offsetAttribute=-1===h?void 0:h,new EllipseOutlineGeometry(scratchOptions$j))},EllipseOutlineGeometry.createGeometry=function(e){if(e._semiMajorAxis<=0||e._semiMinorAxis<=0)return;const t=e._height,n=e._extrudedHeight,i=!CesiumMath.equalsEpsilon(t,n,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);const r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};let o;if(i)r.extrudedHeight=n,r.offsetAttribute=e._offsetAttribute,o=computeExtrudedEllipse(r);else if(o=computeEllipse(r),defined(e._offsetAttribute)){const t=o.attributes.position.values.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:o.attributes,indices:o.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:o.boundingSphere,offsetAttribute:e._offsetAttribute})},CircleOutlineGeometry.packedLength=EllipseOutlineGeometry.packedLength,CircleOutlineGeometry.pack=function(e,t,n){return EllipseOutlineGeometry.pack(e._ellipseGeometry,t,n)};const scratchEllipseGeometry=new EllipseOutlineGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$i={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};CircleOutlineGeometry.unpack=function(e,t,n){const i=EllipseOutlineGeometry.unpack(e,t,scratchEllipseGeometry);return scratchOptions$i.center=Cartesian3.clone(i._center,scratchOptions$i.center),scratchOptions$i.ellipsoid=Ellipsoid.clone(i._ellipsoid,scratchOptions$i.ellipsoid),scratchOptions$i.height=i._height,scratchOptions$i.extrudedHeight=i._extrudedHeight,scratchOptions$i.granularity=i._granularity,scratchOptions$i.numberOfVerticalLines=i._numberOfVerticalLines,defined(n)?(scratchOptions$i.semiMajorAxis=i._semiMajorAxis,scratchOptions$i.semiMinorAxis=i._semiMinorAxis,n._ellipseGeometry=new EllipseOutlineGeometry(scratchOptions$i),n):(scratchOptions$i.radius=i._semiMajorAxis,new CircleOutlineGeometry(scratchOptions$i))},CircleOutlineGeometry.createGeometry=function(e){return EllipseOutlineGeometry.createGeometry(e._ellipseGeometry)};const ClockRange={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2};var ClockRange$1=Object.freeze(ClockRange);const ClockStep={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2};var ClockStep$1=Object.freeze(ClockStep);let getTimestamp;getTimestamp="undefined"!=typeof performance&&"function"==typeof performance.now&&isFinite(performance.now())?function(){return performance.now()}:function(){return Date.now()};var getTimestamp$1=getTimestamp;function Clock(e){let t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).currentTime,n=e.startTime,i=e.stopTime;t=defined(t)?JulianDate.clone(t):defined(n)?JulianDate.clone(n):defined(i)?JulianDate.addDays(i,-1,new JulianDate):JulianDate.now(),n=defined(n)?JulianDate.clone(n):JulianDate.clone(t),i=defined(i)?JulianDate.clone(i):JulianDate.addDays(n,1,new JulianDate),this.startTime=n,this.stopTime=i,this.clockRange=defaultValue(e.clockRange,ClockRange$1.UNBOUNDED),this.canAnimate=defaultValue(e.canAnimate,!0),this.onTick=new Event,this.onStop=new Event,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=getTimestamp$1(),this.currentTime=t,this.multiplier=defaultValue(e.multiplier,1),this.shouldAnimate=defaultValue(e.shouldAnimate,!1),this.clockStep=defaultValue(e.clockStep,ClockStep$1.SYSTEM_CLOCK_MULTIPLIER)}function hue2rgb(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),6*n<1?e+6*(t-e)*n:2*n<1?t:3*n<2?e+(t-e)*(2/3-n)*6:e}function Color(e,t,n,i){this.red=defaultValue(e,1),this.green=defaultValue(t,1),this.blue=defaultValue(n,1),this.alpha=defaultValue(i,1)}let scratchArrayBuffer,scratchUint32Array,scratchUint8Array;Object.defineProperties(Clock.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){JulianDate.equals(this._currentTime,e)||(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===ClockStep$1.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=JulianDate.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}}),Clock.prototype.tick=function(){const e=getTimestamp$1();let t=JulianDate.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){const n=this._clockStep;if(n===ClockStep$1.SYSTEM_CLOCK)t=JulianDate.now(t);else{const i=this._multiplier;if(n===ClockStep$1.TICK_DEPENDENT)t=JulianDate.addSeconds(t,i,t);else{const n=e-this._lastSystemTime;t=JulianDate.addSeconds(t,i*(n/1e3),t)}const r=this.clockRange,o=this.startTime,a=this.stopTime;if(r===ClockRange$1.CLAMPED)JulianDate.lessThan(t,o)?t=JulianDate.clone(o,t):JulianDate.greaterThan(t,a)&&(t=JulianDate.clone(a,t),this.onStop.raiseEvent(this));else if(r===ClockRange$1.LOOP_STOP)for(JulianDate.lessThan(t,o)&&(t=JulianDate.clone(o,t));JulianDate.greaterThan(t,a);)t=JulianDate.addSeconds(o,JulianDate.secondsDifference(t,a),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},Color.fromCartesian4=function(e,t){return defined(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new Color(e.x,e.y,e.z,e.w)},Color.fromBytes=function(e,t,n,i,r){return e=Color.byteToFloat(defaultValue(e,255)),t=Color.byteToFloat(defaultValue(t,255)),n=Color.byteToFloat(defaultValue(n,255)),i=Color.byteToFloat(defaultValue(i,255)),defined(r)?(r.red=e,r.green=t,r.blue=n,r.alpha=i,r):new Color(e,t,n,i)},Color.fromAlpha=function(e,t,n){return defined(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=t,n):new Color(e.red,e.green,e.blue,t)},FeatureDetection.supportsTypedArrays()&&(scratchArrayBuffer=new ArrayBuffer(4),scratchUint32Array=new Uint32Array(scratchArrayBuffer),scratchUint8Array=new Uint8Array(scratchArrayBuffer)),Color.fromRgba=function(e,t){return scratchUint32Array[0]=e,Color.fromBytes(scratchUint8Array[0],scratchUint8Array[1],scratchUint8Array[2],scratchUint8Array[3],t)},Color.fromHsl=function(e,t,n,i,r){e=defaultValue(e,0)%1,t=defaultValue(t,0),n=defaultValue(n,0),i=defaultValue(i,1);let o=n,a=n,s=n;if(0!==t){let i;i=n<.5?n*(1+t):n+t-n*t;const r=2*n-i;o=hue2rgb(r,i,e+1/3),a=hue2rgb(r,i,e),s=hue2rgb(r,i,e-1/3)}return defined(r)?(r.red=o,r.green=a,r.blue=s,r.alpha=i,r):new Color(o,a,s,i)},Color.fromRandom=function(e,t){let n=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).red;if(!defined(n)){const t=defaultValue(e.minimumRed,0),i=defaultValue(e.maximumRed,1);n=t+CesiumMath.nextRandomNumber()*(i-t)}let i=e.green;if(!defined(i)){const t=defaultValue(e.minimumGreen,0),n=defaultValue(e.maximumGreen,1);i=t+CesiumMath.nextRandomNumber()*(n-t)}let r=e.blue;if(!defined(r)){const t=defaultValue(e.minimumBlue,0),n=defaultValue(e.maximumBlue,1);r=t+CesiumMath.nextRandomNumber()*(n-t)}let o=e.alpha;if(!defined(o)){const t=defaultValue(e.minimumAlpha,0),n=defaultValue(e.maximumAlpha,1);o=t+CesiumMath.nextRandomNumber()*(n-t)}return defined(t)?(t.red=n,t.green=i,t.blue=r,t.alpha=o,t):new Color(n,i,r,o)};const rgbaMatcher=/^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i,rrggbbaaMatcher=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i,rgbParenthesesMatcher=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,hslParenthesesMatcher=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;function ColorGeometryInstanceAttribute(e,t,n,i){e=defaultValue(e,1),t=defaultValue(t,1),n=defaultValue(n,1),i=defaultValue(i,1),this.value=new Uint8Array([Color.floatToByte(e),Color.floatToByte(t),Color.floatToByte(n),Color.floatToByte(i)])}function CompressedTextureBuffer(e,t,n,i,r){this._format=e,this._datatype=t,this._width=n,this._height=i,this._buffer=r}Color.fromCssColorString=function(e,t){defined(t)||(t=new Color);const n=Color[(e=e.replace(/\s/g,"")).toUpperCase()];if(defined(n))return Color.clone(n,t),t;let i=rgbaMatcher.exec(e);return null!==i?(t.red=parseInt(i[1],16)/15,t.green=parseInt(i[2],16)/15,t.blue=parseInt(i[3],16)/15,t.alpha=parseInt(defaultValue(i[4],"f"),16)/15,t):(i=rrggbbaaMatcher.exec(e),null!==i?(t.red=parseInt(i[1],16)/255,t.green=parseInt(i[2],16)/255,t.blue=parseInt(i[3],16)/255,t.alpha=parseInt(defaultValue(i[4],"ff"),16)/255,t):(i=rgbParenthesesMatcher.exec(e),null!==i?(t.red=parseFloat(i[1])/("%"===i[1].substr(-1)?100:255),t.green=parseFloat(i[2])/("%"===i[2].substr(-1)?100:255),t.blue=parseFloat(i[3])/("%"===i[3].substr(-1)?100:255),t.alpha=parseFloat(defaultValue(i[4],"1.0")),t):(i=hslParenthesesMatcher.exec(e),null!==i?Color.fromHsl(parseFloat(i[1])/360,parseFloat(i[2])/100,parseFloat(i[3])/100,parseFloat(defaultValue(i[4],"1.0")),t):t=void 0)))},Color.packedLength=4,Color.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.red,t[n++]=e.green,t[n++]=e.blue,t[n]=e.alpha,t},Color.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new Color),n.red=e[t++],n.green=e[t++],n.blue=e[t++],n.alpha=e[t],n},Color.byteToFloat=function(e){return e/255},Color.floatToByte=function(e){return 1===e?255:256*e|0},Color.clone=function(e,t){if(defined(e))return defined(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new Color(e.red,e.green,e.blue,e.alpha)},Color.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},Color.equalsArray=function(e,t,n){return e.red===t[n]&&e.green===t[n+1]&&e.blue===t[n+2]&&e.alpha===t[n+3]},Color.prototype.clone=function(e){return Color.clone(this,e)},Color.prototype.equals=function(e){return Color.equals(this,e)},Color.prototype.equalsEpsilon=function(e,t){return this===e||defined(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},Color.prototype.toString=function(){return`(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`},Color.prototype.toCssColorString=function(){const e=Color.floatToByte(this.red),t=Color.floatToByte(this.green),n=Color.floatToByte(this.blue);return 1===this.alpha?`rgb(${e},${t},${n})`:`rgba(${e},${t},${n},${this.alpha})`},Color.prototype.toCssHexString=function(){let e=Color.floatToByte(this.red).toString(16);e.length<2&&(e=`0${e}`);let t=Color.floatToByte(this.green).toString(16);t.length<2&&(t=`0${t}`);let n=Color.floatToByte(this.blue).toString(16);if(n.length<2&&(n=`0${n}`),this.alpha<1){let i=Color.floatToByte(this.alpha).toString(16);return i.length<2&&(i=`0${i}`),`#${e}${t}${n}${i}`}return`#${e}${t}${n}`},Color.prototype.toBytes=function(e){const t=Color.floatToByte(this.red),n=Color.floatToByte(this.green),i=Color.floatToByte(this.blue),r=Color.floatToByte(this.alpha);return defined(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=r,e):[t,n,i,r]},Color.prototype.toRgba=function(){return scratchUint8Array[0]=Color.floatToByte(this.red),scratchUint8Array[1]=Color.floatToByte(this.green),scratchUint8Array[2]=Color.floatToByte(this.blue),scratchUint8Array[3]=Color.floatToByte(this.alpha),scratchUint32Array[0]},Color.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},Color.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},Color.prototype.withAlpha=function(e,t){return Color.fromAlpha(this,e,t)},Color.add=function(e,t,n){return n.red=e.red+t.red,n.green=e.green+t.green,n.blue=e.blue+t.blue,n.alpha=e.alpha+t.alpha,n},Color.subtract=function(e,t,n){return n.red=e.red-t.red,n.green=e.green-t.green,n.blue=e.blue-t.blue,n.alpha=e.alpha-t.alpha,n},Color.multiply=function(e,t,n){return n.red=e.red*t.red,n.green=e.green*t.green,n.blue=e.blue*t.blue,n.alpha=e.alpha*t.alpha,n},Color.divide=function(e,t,n){return n.red=e.red/t.red,n.green=e.green/t.green,n.blue=e.blue/t.blue,n.alpha=e.alpha/t.alpha,n},Color.mod=function(e,t,n){return n.red=e.red%t.red,n.green=e.green%t.green,n.blue=e.blue%t.blue,n.alpha=e.alpha%t.alpha,n},Color.lerp=function(e,t,n,i){return i.red=CesiumMath.lerp(e.red,t.red,n),i.green=CesiumMath.lerp(e.green,t.green,n),i.blue=CesiumMath.lerp(e.blue,t.blue,n),i.alpha=CesiumMath.lerp(e.alpha,t.alpha,n),i},Color.multiplyByScalar=function(e,t,n){return n.red=e.red*t,n.green=e.green*t,n.blue=e.blue*t,n.alpha=e.alpha*t,n},Color.divideByScalar=function(e,t,n){return n.red=e.red/t,n.green=e.green/t,n.blue=e.blue/t,n.alpha=e.alpha/t,n},Color.ALICEBLUE=Object.freeze(Color.fromCssColorString("#F0F8FF")),Color.ANTIQUEWHITE=Object.freeze(Color.fromCssColorString("#FAEBD7")),Color.AQUA=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.AQUAMARINE=Object.freeze(Color.fromCssColorString("#7FFFD4")),Color.AZURE=Object.freeze(Color.fromCssColorString("#F0FFFF")),Color.BEIGE=Object.freeze(Color.fromCssColorString("#F5F5DC")),Color.BISQUE=Object.freeze(Color.fromCssColorString("#FFE4C4")),Color.BLACK=Object.freeze(Color.fromCssColorString("#000000")),Color.BLANCHEDALMOND=Object.freeze(Color.fromCssColorString("#FFEBCD")),Color.BLUE=Object.freeze(Color.fromCssColorString("#0000FF")),Color.BLUEVIOLET=Object.freeze(Color.fromCssColorString("#8A2BE2")),Color.BROWN=Object.freeze(Color.fromCssColorString("#A52A2A")),Color.BURLYWOOD=Object.freeze(Color.fromCssColorString("#DEB887")),Color.CADETBLUE=Object.freeze(Color.fromCssColorString("#5F9EA0")),Color.CHARTREUSE=Object.freeze(Color.fromCssColorString("#7FFF00")),Color.CHOCOLATE=Object.freeze(Color.fromCssColorString("#D2691E")),Color.CORAL=Object.freeze(Color.fromCssColorString("#FF7F50")),Color.CORNFLOWERBLUE=Object.freeze(Color.fromCssColorString("#6495ED")),Color.CORNSILK=Object.freeze(Color.fromCssColorString("#FFF8DC")),Color.CRIMSON=Object.freeze(Color.fromCssColorString("#DC143C")),Color.CYAN=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.DARKBLUE=Object.freeze(Color.fromCssColorString("#00008B")),Color.DARKCYAN=Object.freeze(Color.fromCssColorString("#008B8B")),Color.DARKGOLDENROD=Object.freeze(Color.fromCssColorString("#B8860B")),Color.DARKGRAY=Object.freeze(Color.fromCssColorString("#A9A9A9")),Color.DARKGREEN=Object.freeze(Color.fromCssColorString("#006400")),Color.DARKGREY=Color.DARKGRAY,Color.DARKKHAKI=Object.freeze(Color.fromCssColorString("#BDB76B")),Color.DARKMAGENTA=Object.freeze(Color.fromCssColorString("#8B008B")),Color.DARKOLIVEGREEN=Object.freeze(Color.fromCssColorString("#556B2F")),Color.DARKORANGE=Object.freeze(Color.fromCssColorString("#FF8C00")),Color.DARKORCHID=Object.freeze(Color.fromCssColorString("#9932CC")),Color.DARKRED=Object.freeze(Color.fromCssColorString("#8B0000")),Color.DARKSALMON=Object.freeze(Color.fromCssColorString("#E9967A")),Color.DARKSEAGREEN=Object.freeze(Color.fromCssColorString("#8FBC8F")),Color.DARKSLATEBLUE=Object.freeze(Color.fromCssColorString("#483D8B")),Color.DARKSLATEGRAY=Object.freeze(Color.fromCssColorString("#2F4F4F")),Color.DARKSLATEGREY=Color.DARKSLATEGRAY,Color.DARKTURQUOISE=Object.freeze(Color.fromCssColorString("#00CED1")),Color.DARKVIOLET=Object.freeze(Color.fromCssColorString("#9400D3")),Color.DEEPPINK=Object.freeze(Color.fromCssColorString("#FF1493")),Color.DEEPSKYBLUE=Object.freeze(Color.fromCssColorString("#00BFFF")),Color.DIMGRAY=Object.freeze(Color.fromCssColorString("#696969")),Color.DIMGREY=Color.DIMGRAY,Color.DODGERBLUE=Object.freeze(Color.fromCssColorString("#1E90FF")),Color.FIREBRICK=Object.freeze(Color.fromCssColorString("#B22222")),Color.FLORALWHITE=Object.freeze(Color.fromCssColorString("#FFFAF0")),Color.FORESTGREEN=Object.freeze(Color.fromCssColorString("#228B22")),Color.FUCHSIA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.GAINSBORO=Object.freeze(Color.fromCssColorString("#DCDCDC")),Color.GHOSTWHITE=Object.freeze(Color.fromCssColorString("#F8F8FF")),Color.GOLD=Object.freeze(Color.fromCssColorString("#FFD700")),Color.GOLDENROD=Object.freeze(Color.fromCssColorString("#DAA520")),Color.GRAY=Object.freeze(Color.fromCssColorString("#808080")),Color.GREEN=Object.freeze(Color.fromCssColorString("#008000")),Color.GREENYELLOW=Object.freeze(Color.fromCssColorString("#ADFF2F")),Color.GREY=Color.GRAY,Color.HONEYDEW=Object.freeze(Color.fromCssColorString("#F0FFF0")),Color.HOTPINK=Object.freeze(Color.fromCssColorString("#FF69B4")),Color.INDIANRED=Object.freeze(Color.fromCssColorString("#CD5C5C")),Color.INDIGO=Object.freeze(Color.fromCssColorString("#4B0082")),Color.IVORY=Object.freeze(Color.fromCssColorString("#FFFFF0")),Color.KHAKI=Object.freeze(Color.fromCssColorString("#F0E68C")),Color.LAVENDER=Object.freeze(Color.fromCssColorString("#E6E6FA")),Color.LAVENDAR_BLUSH=Object.freeze(Color.fromCssColorString("#FFF0F5")),Color.LAWNGREEN=Object.freeze(Color.fromCssColorString("#7CFC00")),Color.LEMONCHIFFON=Object.freeze(Color.fromCssColorString("#FFFACD")),Color.LIGHTBLUE=Object.freeze(Color.fromCssColorString("#ADD8E6")),Color.LIGHTCORAL=Object.freeze(Color.fromCssColorString("#F08080")),Color.LIGHTCYAN=Object.freeze(Color.fromCssColorString("#E0FFFF")),Color.LIGHTGOLDENRODYELLOW=Object.freeze(Color.fromCssColorString("#FAFAD2")),Color.LIGHTGRAY=Object.freeze(Color.fromCssColorString("#D3D3D3")),Color.LIGHTGREEN=Object.freeze(Color.fromCssColorString("#90EE90")),Color.LIGHTGREY=Color.LIGHTGRAY,Color.LIGHTPINK=Object.freeze(Color.fromCssColorString("#FFB6C1")),Color.LIGHTSEAGREEN=Object.freeze(Color.fromCssColorString("#20B2AA")),Color.LIGHTSKYBLUE=Object.freeze(Color.fromCssColorString("#87CEFA")),Color.LIGHTSLATEGRAY=Object.freeze(Color.fromCssColorString("#778899")),Color.LIGHTSLATEGREY=Color.LIGHTSLATEGRAY,Color.LIGHTSTEELBLUE=Object.freeze(Color.fromCssColorString("#B0C4DE")),Color.LIGHTYELLOW=Object.freeze(Color.fromCssColorString("#FFFFE0")),Color.LIME=Object.freeze(Color.fromCssColorString("#00FF00")),Color.LIMEGREEN=Object.freeze(Color.fromCssColorString("#32CD32")),Color.LINEN=Object.freeze(Color.fromCssColorString("#FAF0E6")),Color.MAGENTA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.MAROON=Object.freeze(Color.fromCssColorString("#800000")),Color.MEDIUMAQUAMARINE=Object.freeze(Color.fromCssColorString("#66CDAA")),Color.MEDIUMBLUE=Object.freeze(Color.fromCssColorString("#0000CD")),Color.MEDIUMORCHID=Object.freeze(Color.fromCssColorString("#BA55D3")),Color.MEDIUMPURPLE=Object.freeze(Color.fromCssColorString("#9370DB")),Color.MEDIUMSEAGREEN=Object.freeze(Color.fromCssColorString("#3CB371")),Color.MEDIUMSLATEBLUE=Object.freeze(Color.fromCssColorString("#7B68EE")),Color.MEDIUMSPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FA9A")),Color.MEDIUMTURQUOISE=Object.freeze(Color.fromCssColorString("#48D1CC")),Color.MEDIUMVIOLETRED=Object.freeze(Color.fromCssColorString("#C71585")),Color.MIDNIGHTBLUE=Object.freeze(Color.fromCssColorString("#191970")),Color.MINTCREAM=Object.freeze(Color.fromCssColorString("#F5FFFA")),Color.MISTYROSE=Object.freeze(Color.fromCssColorString("#FFE4E1")),Color.MOCCASIN=Object.freeze(Color.fromCssColorString("#FFE4B5")),Color.NAVAJOWHITE=Object.freeze(Color.fromCssColorString("#FFDEAD")),Color.NAVY=Object.freeze(Color.fromCssColorString("#000080")),Color.OLDLACE=Object.freeze(Color.fromCssColorString("#FDF5E6")),Color.OLIVE=Object.freeze(Color.fromCssColorString("#808000")),Color.OLIVEDRAB=Object.freeze(Color.fromCssColorString("#6B8E23")),Color.ORANGE=Object.freeze(Color.fromCssColorString("#FFA500")),Color.ORANGERED=Object.freeze(Color.fromCssColorString("#FF4500")),Color.ORCHID=Object.freeze(Color.fromCssColorString("#DA70D6")),Color.PALEGOLDENROD=Object.freeze(Color.fromCssColorString("#EEE8AA")),Color.PALEGREEN=Object.freeze(Color.fromCssColorString("#98FB98")),Color.PALETURQUOISE=Object.freeze(Color.fromCssColorString("#AFEEEE")),Color.PALEVIOLETRED=Object.freeze(Color.fromCssColorString("#DB7093")),Color.PAPAYAWHIP=Object.freeze(Color.fromCssColorString("#FFEFD5")),Color.PEACHPUFF=Object.freeze(Color.fromCssColorString("#FFDAB9")),Color.PERU=Object.freeze(Color.fromCssColorString("#CD853F")),Color.PINK=Object.freeze(Color.fromCssColorString("#FFC0CB")),Color.PLUM=Object.freeze(Color.fromCssColorString("#DDA0DD")),Color.POWDERBLUE=Object.freeze(Color.fromCssColorString("#B0E0E6")),Color.PURPLE=Object.freeze(Color.fromCssColorString("#800080")),Color.RED=Object.freeze(Color.fromCssColorString("#FF0000")),Color.ROSYBROWN=Object.freeze(Color.fromCssColorString("#BC8F8F")),Color.ROYALBLUE=Object.freeze(Color.fromCssColorString("#4169E1")),Color.SADDLEBROWN=Object.freeze(Color.fromCssColorString("#8B4513")),Color.SALMON=Object.freeze(Color.fromCssColorString("#FA8072")),Color.SANDYBROWN=Object.freeze(Color.fromCssColorString("#F4A460")),Color.SEAGREEN=Object.freeze(Color.fromCssColorString("#2E8B57")),Color.SEASHELL=Object.freeze(Color.fromCssColorString("#FFF5EE")),Color.SIENNA=Object.freeze(Color.fromCssColorString("#A0522D")),Color.SILVER=Object.freeze(Color.fromCssColorString("#C0C0C0")),Color.SKYBLUE=Object.freeze(Color.fromCssColorString("#87CEEB")),Color.SLATEBLUE=Object.freeze(Color.fromCssColorString("#6A5ACD")),Color.SLATEGRAY=Object.freeze(Color.fromCssColorString("#708090")),Color.SLATEGREY=Color.SLATEGRAY,Color.SNOW=Object.freeze(Color.fromCssColorString("#FFFAFA")),Color.SPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FF7F")),Color.STEELBLUE=Object.freeze(Color.fromCssColorString("#4682B4")),Color.TAN=Object.freeze(Color.fromCssColorString("#D2B48C")),Color.TEAL=Object.freeze(Color.fromCssColorString("#008080")),Color.THISTLE=Object.freeze(Color.fromCssColorString("#D8BFD8")),Color.TOMATO=Object.freeze(Color.fromCssColorString("#FF6347")),Color.TURQUOISE=Object.freeze(Color.fromCssColorString("#40E0D0")),Color.VIOLET=Object.freeze(Color.fromCssColorString("#EE82EE")),Color.WHEAT=Object.freeze(Color.fromCssColorString("#F5DEB3")),Color.WHITE=Object.freeze(Color.fromCssColorString("#FFFFFF")),Color.WHITESMOKE=Object.freeze(Color.fromCssColorString("#F5F5F5")),Color.YELLOW=Object.freeze(Color.fromCssColorString("#FFFF00")),Color.YELLOWGREEN=Object.freeze(Color.fromCssColorString("#9ACD32")),Color.TRANSPARENT=Object.freeze(new Color(0,0,0,0)),Object.defineProperties(ColorGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),ColorGeometryInstanceAttribute.fromColor=function(e){return new ColorGeometryInstanceAttribute(e.red,e.green,e.blue,e.alpha)},ColorGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?e.toBytes(t):new Uint8Array(e.toBytes())},ColorGeometryInstanceAttribute.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]},Object.defineProperties(CompressedTextureBuffer.prototype,{internalFormat:{get:function(){return this._format}},pixelDatatype:{get:function(){return this._datatype}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),CompressedTextureBuffer.clone=function(e){if(defined(e))return new CompressedTextureBuffer(e._format,e._datatype,e._width,e._height,e._buffer)},CompressedTextureBuffer.prototype.clone=function(){return CompressedTextureBuffer.clone(this)};const removeDuplicatesEpsilon=CesiumMath.EPSILON10;function arrayRemoveDuplicates(e,t,n,i){if(!defined(e))return;n=defaultValue(n,!1);const r=defined(i),o=e.length;if(o<2)return e;let a,s,c,l=e[0],u=0,d=-1;for(a=1;a<o;++a)s=e[a],t(l,s,removeDuplicatesEpsilon)?(defined(c)||(c=e.slice(0,a),u=a-1,d=0),r&&i.push(a)):(defined(c)&&(c.push(s),u=a,r&&(d=i.length)),l=s);return n&&t(e[0],e[o-1],removeDuplicatesEpsilon)&&(r&&(defined(c)?i.splice(d,0,u):i.push(o-1)),defined(c)?c.length-=1:c=e.slice(0,-1)),defined(c)?c:e}const CoplanarPolygonGeometryLibrary={},scratchIntersectionPoint=new Cartesian3,scratchXAxis=new Cartesian3,scratchYAxis=new Cartesian3,scratchZAxis=new Cartesian3,obbScratch=new OrientedBoundingBox;function projectTo2D(e,t,n,i,r){const o=Cartesian3.subtract(e,t,scratchIntersectionPoint),a=Cartesian3.dot(n,o),s=Cartesian3.dot(i,o);return Cartesian2.fromElements(a,s,r)}function calculateM(e,t,n){if(0===e)return t*n;const i=e*e,r=i*i,o=r*i,a=o*i,s=a*i,c=s*i,l=n;return t*((1-i/4-3*r/64-5*o/256-175*a/16384-441*s/65536-4851*c/1048576)*l-(3*i/8+3*r/32+45*o/1024+105*a/4096+2205*s/131072+6237*c/524288)*Math.sin(2*l)+(15*r/256+45*o/1024+525*a/16384+1575*s/65536+155925*c/8388608)*Math.sin(4*l)-(35*o/3072+175*a/12288+3675*s/262144+13475*c/1048576)*Math.sin(6*l)+(315*a/131072+2205*s/524288+43659*c/8388608)*Math.sin(8*l)-(693*s/1310720+6237*c/5242880)*Math.sin(10*l)+1001*c/8388608*Math.sin(12*l))}function calculateInverseM(e,t,n){const i=e/n;if(0===t)return i;const r=i*i,o=r*i,a=o*i,s=t*t,c=s*s,l=c*s,u=l*s,d=u*s,h=d*s,p=Math.sin(2*i),f=Math.cos(2*i),m=Math.sin(4*i),g=Math.cos(4*i),_=Math.sin(6*i),y=Math.cos(6*i),C=Math.sin(8*i),T=Math.cos(8*i),S=Math.sin(10*i);return i+i*s/4+7*i*c/64+15*i*l/256+579*i*u/16384+1515*i*d/65536+16837*i*h/1048576+(3*i*c/16+45*i*l/256-i*(32*r-561)*u/4096-i*(232*r-1677)*d/16384+i*(399985-90560*r+512*a)*h/5242880)*f+(21*i*l/256+483*i*u/4096-i*(224*r-1969)*d/16384-i*(33152*r-112599)*h/1048576)*g+(151*i*u/4096+4681*i*d/65536+1479*i*h/16384-453*o*h/32768)*y+(1097*i*d/65536+42783*i*h/1048576)*T+8011*i*h/1048576*Math.cos(10*i)+(3*s/8+3*c/16+213*l/2048-3*r*l/64+255*u/4096-33*r*u/512+20861*d/524288-33*r*d/512+a*d/1024+28273*h/1048576-471*r*h/8192+9*a*h/4096)*p+(21*c/256+21*l/256+533*u/8192-21*r*u/512+197*d/4096-315*r*d/4096+584039*h/16777216-12517*r*h/131072+7*a*h/2048)*m+(151*l/6144+151*u/4096+5019*d/131072-453*r*d/16384+26965*h/786432-8607*r*h/131072)*_+(1097*u/131072+1097*d/65536+225797*h/10485760-1097*r*h/65536)*C+(8011*d/2621440+8011*h/1048576)*S+293393*h/251658240*Math.sin(12*i)}function calculateSigma(e,t){if(0===e)return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)));const n=e*Math.sin(t);return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)))-e/2*Math.log((1+n)/(1-n))}function calculateHeading(e,t,n,i,r){const o=calculateSigma(e._ellipticity,n),a=calculateSigma(e._ellipticity,r);return Math.atan2(CesiumMath.negativePiToPi(i-t),a-o)}function calculateArcLength(e,t,n,i,r,o,a){const s=e._heading,c=o-i;let l=0;if(CesiumMath.equalsEpsilon(Math.abs(s),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))if(t===n)l=t*Math.cos(r)*CesiumMath.negativePiToPi(c);else{const n=Math.sin(r);l=t*Math.cos(r)*CesiumMath.negativePiToPi(c)/Math.sqrt(1-e._ellipticitySquared*n*n)}else{const n=calculateM(e._ellipticity,t,r);l=(calculateM(e._ellipticity,t,a)-n)/Math.cos(s)}return Math.abs(l)}CoplanarPolygonGeometryLibrary.validOutline=function(e){const t=OrientedBoundingBox.fromPoints(e,obbScratch).halfAxes,n=Matrix3.getColumn(t,0,scratchXAxis),i=Matrix3.getColumn(t,1,scratchYAxis),r=Matrix3.getColumn(t,2,scratchZAxis),o=Cartesian3.magnitude(n),a=Cartesian3.magnitude(i),s=Cartesian3.magnitude(r);return!(0===o&&(0===a||0===s)||0===a&&0===s)},CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments=function(e,t,n,i){const r=OrientedBoundingBox.fromPoints(e,obbScratch),o=r.halfAxes,a=Matrix3.getColumn(o,0,scratchXAxis),s=Matrix3.getColumn(o,1,scratchYAxis),c=Matrix3.getColumn(o,2,scratchZAxis),l=Cartesian3.magnitude(a),u=Cartesian3.magnitude(s),d=Cartesian3.magnitude(c),h=Math.min(l,u,d);if(0===l&&(0===u||0===d)||0===u&&0===d)return!1;let p,f;return h!==u&&h!==d||(p=a),h===l?p=s:h===d&&(f=s),h!==l&&h!==u||(f=c),Cartesian3.normalize(p,n),Cartesian3.normalize(f,i),Cartesian3.clone(r.center,t),!0},CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction=function(e,t,n){return function(i){const r=new Array(i.length);for(let o=0;o<i.length;o++)r[o]=projectTo2D(i[o],e,t,n);return r}},CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction=function(e,t,n){return function(i,r){return projectTo2D(i,e,t,n,r)}};const scratchCart1$1=new Cartesian3,scratchCart2$2=new Cartesian3;function computeProperties$1(e,t,n,i){Cartesian3.normalize(i.cartographicToCartesian(t,scratchCart2$2),scratchCart1$1),Cartesian3.normalize(i.cartographicToCartesian(n,scratchCart2$2),scratchCart2$2);const r=i.maximumRadius,o=i.minimumRadius,a=r*r,s=o*o;e._ellipticitySquared=(a-s)/a,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=Cartographic.clone(t,e._start),e._start.height=0,e._end=Cartographic.clone(n,e._end),e._end.height=0,e._heading=calculateHeading(e,t.longitude,t.latitude,n.longitude,n.latitude),e._distance=calculateArcLength(e,i.maximumRadius,i.minimumRadius,t.longitude,t.latitude,n.longitude,n.latitude)}function interpolateUsingSurfaceDistance(e,t,n,i,r,o){if(0===n)return Cartographic.clone(e,o);const a=r*r;let s,c,l;if(Math.abs(CesiumMath.PI_OVER_TWO-Math.abs(t))>CesiumMath.EPSILON8){c=calculateInverseM(calculateM(r,i,e.latitude)+n*Math.cos(t),r,i);const o=calculateSigma(r,e.latitude),a=calculateSigma(r,c);l=Math.tan(t)*(a-o),s=CesiumMath.negativePiToPi(e.longitude+l)}else{let o;if(c=e.latitude,0===r)o=i*Math.cos(e.latitude);else{const t=Math.sin(e.latitude);o=i*Math.cos(e.latitude)/Math.sqrt(1-a*t*t)}l=n/o,s=t>0?CesiumMath.negativePiToPi(e.longitude+l):CesiumMath.negativePiToPi(e.longitude-l)}return defined(o)?(o.longitude=s,o.latitude=c,o.height=0,o):new Cartographic(s,c,0)}function EllipsoidRhumbLine(e,t,n){const i=defaultValue(n,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,defined(e)&&defined(t)&&computeProperties$1(this,e,t,i)}Object.defineProperties(EllipsoidRhumbLine.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return this._heading}}}),EllipsoidRhumbLine.fromStartHeadingDistance=function(e,t,n,i,r){const o=defaultValue(i,Ellipsoid.WGS84),a=o.maximumRadius,s=o.minimumRadius,c=a*a,l=s*s,u=Math.sqrt((c-l)/c),d=interpolateUsingSurfaceDistance(e,t=CesiumMath.negativePiToPi(t),n,o.maximumRadius,u);return!defined(r)||defined(i)&&!i.equals(r.ellipsoid)?new EllipsoidRhumbLine(e,d,o):(r.setEndPoints(e,d),r)},EllipsoidRhumbLine.prototype.setEndPoints=function(e,t){computeProperties$1(this,e,t,this._ellipsoid)},EllipsoidRhumbLine.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},EllipsoidRhumbLine.prototype.interpolateUsingSurfaceDistance=function(e,t){return interpolateUsingSurfaceDistance(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},EllipsoidRhumbLine.prototype.findIntersectionWithLongitude=function(e,t){const n=this._ellipticity,i=this._heading,r=Math.abs(i),o=this._start;if(e=CesiumMath.negativePiToPi(e),CesiumMath.equalsEpsilon(Math.abs(e),Math.PI,CesiumMath.EPSILON14)&&(e=CesiumMath.sign(o.longitude)*Math.PI),defined(t)||(t=new Cartographic),Math.abs(CesiumMath.PI_OVER_TWO-r)<=CesiumMath.EPSILON8)return t.longitude=e,t.latitude=o.latitude,t.height=0,t;if(CesiumMath.equalsEpsilon(Math.abs(CesiumMath.PI_OVER_TWO-r),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){if(CesiumMath.equalsEpsilon(e,o.longitude,CesiumMath.EPSILON12))return;return t.longitude=e,t.latitude=CesiumMath.PI_OVER_TWO*CesiumMath.sign(CesiumMath.PI_OVER_TWO-i),t.height=0,t}const a=o.latitude,s=n*Math.sin(a),c=Math.tan(.5*(CesiumMath.PI_OVER_TWO+a))*Math.exp((e-o.longitude)/Math.tan(i)),l=(1+s)/(1-s);let u,d=o.latitude;do{u=d;const e=n*Math.sin(u),t=(1+e)/(1-e);d=2*Math.atan(c*Math.pow(t/l,n/2))-CesiumMath.PI_OVER_TWO}while(!CesiumMath.equalsEpsilon(d,u,CesiumMath.EPSILON12));return t.longitude=e,t.latitude=d,t.height=0,t},EllipsoidRhumbLine.prototype.findIntersectionWithLatitude=function(e,t){const n=this._ellipticity,i=this._heading,r=this._start;if(CesiumMath.equalsEpsilon(Math.abs(i),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))return;const o=calculateSigma(n,r.latitude),a=calculateSigma(n,e),s=Math.tan(i)*(a-o),c=CesiumMath.negativePiToPi(r.longitude+s);return defined(t)?(t.longitude=c,t.latitude=e,t.height=0,t):new Cartographic(c,e,0)};var earcut_1=earcut,_default=earcut;function earcut(e,t,n){n=n||2;var i,r,o,a,s,c,l,u=t&&t.length,d=u?t[0]*n:e.length,h=linkedList(e,0,d,n,!0),p=[];if(!h||h.next===h.prev)return p;if(u&&(h=eliminateHoles(e,t,h,n)),e.length>80*n){i=o=e[0],r=a=e[1];for(var f=n;f<d;f+=n)(s=e[f])<i&&(i=s),(c=e[f+1])<r&&(r=c),s>o&&(o=s),c>a&&(a=c);l=0!==(l=Math.max(o-i,a-r))?1/l:0}return earcutLinked(h,p,n,i,r,l),p}function linkedList(e,t,n,i,r){var o,a;if(r===signedArea(e,t,n,i)>0)for(o=t;o<n;o+=i)a=insertNode(o,e[o],e[o+1],a);else for(o=n-i;o>=t;o-=i)a=insertNode(o,e[o],e[o+1],a);return a&&equals(a,a.next)&&(removeNode(a),a=a.next),a}function filterPoints(e,t){if(!e)return e;t||(t=e);var n,i=e;do{if(n=!1,i.steiner||!equals(i,i.next)&&0!==area(i.prev,i,i.next))i=i.next;else{if(removeNode(i),(i=t=i.prev)===i.next)break;n=!0}}while(n||i!==t);return t}function earcutLinked(e,t,n,i,r,o,a){if(e){!a&&o&&indexCurve(e,i,r,o);for(var s,c,l=e;e.prev!==e.next;)if(s=e.prev,c=e.next,o?isEarHashed(e,i,r,o):isEar(e))t.push(s.i/n),t.push(e.i/n),t.push(c.i/n),removeNode(e),e=c.next,l=c.next;else if((e=c)===l){a?1===a?earcutLinked(e=cureLocalIntersections(filterPoints(e),t,n),t,n,i,r,o,2):2===a&&splitEarcut(e,t,n,i,r,o):earcutLinked(filterPoints(e),t,n,i,r,o,1);break}}}function isEar(e){var t=e.prev,n=e,i=e.next;if(area(t,n,i)>=0)return!1;for(var r=e.next.next;r!==e.prev;){if(pointInTriangle(t.x,t.y,n.x,n.y,i.x,i.y,r.x,r.y)&&area(r.prev,r,r.next)>=0)return!1;r=r.next}return!0}function isEarHashed(e,t,n,i){var r=e.prev,o=e,a=e.next;if(area(r,o,a)>=0)return!1;for(var s=r.x<o.x?r.x<a.x?r.x:a.x:o.x<a.x?o.x:a.x,c=r.y<o.y?r.y<a.y?r.y:a.y:o.y<a.y?o.y:a.y,l=r.x>o.x?r.x>a.x?r.x:a.x:o.x>a.x?o.x:a.x,u=r.y>o.y?r.y>a.y?r.y:a.y:o.y>a.y?o.y:a.y,d=zOrder(s,c,t,n,i),h=zOrder(l,u,t,n,i),p=e.prevZ,f=e.nextZ;p&&p.z>=d&&f&&f.z<=h;){if(p!==e.prev&&p!==e.next&&pointInTriangle(r.x,r.y,o.x,o.y,a.x,a.y,p.x,p.y)&&area(p.prev,p,p.next)>=0)return!1;if(p=p.prevZ,f!==e.prev&&f!==e.next&&pointInTriangle(r.x,r.y,o.x,o.y,a.x,a.y,f.x,f.y)&&area(f.prev,f,f.next)>=0)return!1;f=f.nextZ}for(;p&&p.z>=d;){if(p!==e.prev&&p!==e.next&&pointInTriangle(r.x,r.y,o.x,o.y,a.x,a.y,p.x,p.y)&&area(p.prev,p,p.next)>=0)return!1;p=p.prevZ}for(;f&&f.z<=h;){if(f!==e.prev&&f!==e.next&&pointInTriangle(r.x,r.y,o.x,o.y,a.x,a.y,f.x,f.y)&&area(f.prev,f,f.next)>=0)return!1;f=f.nextZ}return!0}function cureLocalIntersections(e,t,n){var i=e;do{var r=i.prev,o=i.next.next;!equals(r,o)&&intersects$1(r,i,i.next,o)&&locallyInside(r,o)&&locallyInside(o,r)&&(t.push(r.i/n),t.push(i.i/n),t.push(o.i/n),removeNode(i),removeNode(i.next),i=e=o),i=i.next}while(i!==e);return filterPoints(i)}function splitEarcut(e,t,n,i,r,o){var a=e;do{for(var s=a.next.next;s!==a.prev;){if(a.i!==s.i&&isValidDiagonal(a,s)){var c=splitPolygon(a,s);return a=filterPoints(a,a.next),c=filterPoints(c,c.next),earcutLinked(a,t,n,i,r,o),void earcutLinked(c,t,n,i,r,o)}s=s.next}a=a.next}while(a!==e)}function eliminateHoles(e,t,n,i){var r,o,a,s=[];for(r=0,o=t.length;r<o;r++)(a=linkedList(e,t[r]*i,r<o-1?t[r+1]*i:e.length,i,!1))===a.next&&(a.steiner=!0),s.push(getLeftmost(a));for(s.sort(compareX),r=0;r<s.length;r++)n=filterPoints(n=eliminateHole(s[r],n),n.next);return n}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){var n=findHoleBridge(e,t);if(!n)return t;var i=splitPolygon(n,e),r=filterPoints(n,n.next);return filterPoints(i,i.next),t===n?r:t}function findHoleBridge(e,t){var n,i=t,r=e.x,o=e.y,a=-1/0;do{if(o<=i.y&&o>=i.next.y&&i.next.y!==i.y){var s=i.x+(o-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(s<=r&&s>a){if(a=s,s===r){if(o===i.y)return i;if(o===i.next.y)return i.next}n=i.x<i.next.x?i:i.next}}i=i.next}while(i!==t);if(!n)return null;if(r===a)return n;var c,l=n,u=n.x,d=n.y,h=1/0;i=n;do{r>=i.x&&i.x>=u&&r!==i.x&&pointInTriangle(o<d?r:a,o,u,d,o<d?a:r,o,i.x,i.y)&&(c=Math.abs(o-i.y)/(r-i.x),locallyInside(i,e)&&(c<h||c===h&&(i.x>n.x||i.x===n.x&&sectorContainsSector(n,i)))&&(n=i,h=c)),i=i.next}while(i!==l);return n}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,n,i){var r=e;do{null===r.z&&(r.z=zOrder(r.x,r.y,t,n,i)),r.prevZ=r.prev,r.nextZ=r.next,r=r.next}while(r!==e);r.prevZ.nextZ=null,r.prevZ=null,sortLinked(r)}function sortLinked(e){var t,n,i,r,o,a,s,c,l=1;do{for(n=e,e=null,o=null,a=0;n;){for(a++,i=n,s=0,t=0;t<l&&(s++,i=i.nextZ);t++);for(c=l;s>0||c>0&&i;)0!==s&&(0===c||!i||n.z<=i.z)?(r=n,n=n.nextZ,s--):(r=i,i=i.nextZ,c--),o?o.nextZ=r:e=r,r.prevZ=o,o=r;n=i}o.nextZ=null,l*=2}while(a>1);return e}function zOrder(e,t,n,i,r){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-n)*r)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-i)*r)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){var t=e,n=e;do{(t.x<n.x||t.x===n.x&&t.y<n.y)&&(n=t),t=t.next}while(t!==e);return n}function pointInTriangle(e,t,n,i,r,o,a,s){return(r-a)*(t-s)-(e-a)*(o-s)>=0&&(e-a)*(i-s)-(n-a)*(t-s)>=0&&(n-a)*(o-s)-(r-a)*(i-s)>=0}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&area(e.prev,e,e.next)>0&&area(t.prev,t,t.next)>0)}function area(e,t,n){return(t.y-e.y)*(n.x-t.x)-(t.x-e.x)*(n.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects$1(e,t,n,i){var r=sign(area(e,t,n)),o=sign(area(e,t,i)),a=sign(area(n,i,e)),s=sign(area(n,i,t));return r!==o&&a!==s||(!(0!==r||!onSegment(e,n,t))||(!(0!==o||!onSegment(e,i,t))||(!(0!==a||!onSegment(n,e,i))||!(0!==s||!onSegment(n,t,i)))))}function onSegment(e,t,n){return t.x<=Math.max(e.x,n.x)&&t.x>=Math.min(e.x,n.x)&&t.y<=Math.max(e.y,n.y)&&t.y>=Math.min(e.y,n.y)}function sign(e){return e>0?1:e<0?-1:0}function intersectsPolygon(e,t){var n=e;do{if(n.i!==e.i&&n.next.i!==e.i&&n.i!==t.i&&n.next.i!==t.i&&intersects$1(n,n.next,e,t))return!0;n=n.next}while(n!==e);return!1}function locallyInside(e,t){return area(e.prev,e,e.next)<0?area(e,t,e.next)>=0&&area(e,e.prev,t)>=0:area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){var n=e,i=!1,r=(e.x+t.x)/2,o=(e.y+t.y)/2;do{n.y>o!=n.next.y>o&&n.next.y!==n.y&&r<(n.next.x-n.x)*(o-n.y)/(n.next.y-n.y)+n.x&&(i=!i),n=n.next}while(n!==e);return i}function splitPolygon(e,t){var n=new Node$5(e.i,e.x,e.y),i=new Node$5(t.i,t.x,t.y),r=e.next,o=t.prev;return e.next=t,t.prev=e,n.next=r,r.prev=n,i.next=n,n.prev=i,o.next=i,i.prev=o,i}function insertNode(e,t,n,i){var r=new Node$5(e,t,n);return i?(r.next=i.next,r.prev=i,i.next.prev=r,i.next=r):(r.prev=r,r.next=r),r}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node$5(e,t,n){this.i=e,this.x=t,this.y=n,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,n,i){for(var r=0,o=t,a=n-i;o<n;o+=i)r+=(e[a]-e[o])*(e[o+1]+e[a+1]),a=o;return r}earcut.deviation=function(e,t,n,i){var r=t&&t.length,o=r?t[0]*n:e.length,a=Math.abs(signedArea(e,0,o,n));if(r)for(var s=0,c=t.length;s<c;s++){var l=t[s]*n,u=s<c-1?t[s+1]*n:e.length;a-=Math.abs(signedArea(e,l,u,n))}var d=0;for(s=0;s<i.length;s+=3){var h=i[s]*n,p=i[s+1]*n,f=i[s+2]*n;d+=Math.abs((e[h]-e[f])*(e[p+1]-e[h+1])-(e[h]-e[p])*(e[f+1]-e[h+1]))}return 0===a&&0===d?0:Math.abs((d-a)/a)},earcut.flatten=function(e){for(var t=e[0][0].length,n={vertices:[],holes:[],dimensions:t},i=0,r=0;r<e.length;r++){for(var o=0;o<e[r].length;o++)for(var a=0;a<t;a++)n.vertices.push(e[r][o][a]);r>0&&(i+=e[r-1].length,n.holes.push(i))}return n},earcut_1.default=_default;const WindingOrder={CLOCKWISE:WebGLConstants$1.CW,COUNTER_CLOCKWISE:WebGLConstants$1.CCW,validate:function(e){return e===WindingOrder.CLOCKWISE||e===WindingOrder.COUNTER_CLOCKWISE}};var WindingOrder$1=Object.freeze(WindingOrder);const scaleToGeodeticHeightN=new Cartesian3,scaleToGeodeticHeightP=new Cartesian3,PolygonPipeline={computeArea2D:function(e){const t=e.length;let n=0;for(let i=t-1,r=0;r<t;i=r++){const t=e[i],o=e[r];n+=t.x*o.y-o.x*t.y}return.5*n},computeWindingOrder2D:function(e){return PolygonPipeline.computeArea2D(e)>0?WindingOrder$1.COUNTER_CLOCKWISE:WindingOrder$1.CLOCKWISE},triangulate:function(e,t){const n=Cartesian2.packArray(e);return earcut_1(n,t,2)}},subdivisionV0Scratch=new Cartesian3,subdivisionV1Scratch=new Cartesian3,subdivisionV2Scratch=new Cartesian3,subdivisionS0Scratch=new Cartesian3,subdivisionS1Scratch=new Cartesian3,subdivisionS2Scratch=new Cartesian3,subdivisionMidScratch=new Cartesian3;PolygonPipeline.computeSubdivision=function(e,t,n,i){i=defaultValue(i,CesiumMath.RADIANS_PER_DEGREE);const r=n.slice(0);let o;const a=t.length,s=new Array(3*a);let c=0;for(o=0;o<a;o++){const e=t[o];s[c++]=e.x,s[c++]=e.y,s[c++]=e.z}const l=[],u={},d=e.maximumRadius,h=CesiumMath.chordLength(i,d),p=h*h;for(;r.length>0;){const e=r.pop(),t=r.pop(),n=r.pop(),i=Cartesian3.fromArray(s,3*n,subdivisionV0Scratch),a=Cartesian3.fromArray(s,3*t,subdivisionV1Scratch),c=Cartesian3.fromArray(s,3*e,subdivisionV2Scratch),h=Cartesian3.multiplyByScalar(Cartesian3.normalize(i,subdivisionS0Scratch),d,subdivisionS0Scratch),f=Cartesian3.multiplyByScalar(Cartesian3.normalize(a,subdivisionS1Scratch),d,subdivisionS1Scratch),m=Cartesian3.multiplyByScalar(Cartesian3.normalize(c,subdivisionS2Scratch),d,subdivisionS2Scratch),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(h,f,subdivisionMidScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(f,m,subdivisionMidScratch)),y=Cartesian3.magnitudeSquared(Cartesian3.subtract(m,h,subdivisionMidScratch)),C=Math.max(g,_,y);let T,S;C>p?g===C?(T=`${Math.min(n,t)} ${Math.max(n,t)}`,o=u[T],defined(o)||(S=Cartesian3.add(i,a,subdivisionMidScratch),Cartesian3.multiplyByScalar(S,.5,S),s.push(S.x,S.y,S.z),o=s.length/3-1,u[T]=o),r.push(n,o,e),r.push(o,t,e)):_===C?(T=`${Math.min(t,e)} ${Math.max(t,e)}`,o=u[T],defined(o)||(S=Cartesian3.add(a,c,subdivisionMidScratch),Cartesian3.multiplyByScalar(S,.5,S),s.push(S.x,S.y,S.z),o=s.length/3-1,u[T]=o),r.push(t,o,n),r.push(o,e,n)):y===C&&(T=`${Math.min(e,n)} ${Math.max(e,n)}`,o=u[T],defined(o)||(S=Cartesian3.add(c,i,subdivisionMidScratch),Cartesian3.multiplyByScalar(S,.5,S),s.push(S.x,S.y,S.z),o=s.length/3-1,u[T]=o),r.push(e,o,t),r.push(o,n,t)):(l.push(n),l.push(t),l.push(e))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:l,primitiveType:PrimitiveType$1.TRIANGLES})};const subdivisionC0Scratch=new Cartographic,subdivisionC1Scratch=new Cartographic,subdivisionC2Scratch=new Cartographic,subdivisionCartographicScratch=new Cartographic;function Queue(){this._array=[],this._offset=0,this._length=0}PolygonPipeline.computeRhumbLineSubdivision=function(e,t,n,i){i=defaultValue(i,CesiumMath.RADIANS_PER_DEGREE);const r=n.slice(0);let o;const a=t.length,s=new Array(3*a);let c=0;for(o=0;o<a;o++){const e=t[o];s[c++]=e.x,s[c++]=e.y,s[c++]=e.z}const l=[],u={},d=e.maximumRadius,h=CesiumMath.chordLength(i,d),p=new EllipsoidRhumbLine(void 0,void 0,e),f=new EllipsoidRhumbLine(void 0,void 0,e),m=new EllipsoidRhumbLine(void 0,void 0,e);for(;r.length>0;){const t=r.pop(),n=r.pop(),i=r.pop(),a=Cartesian3.fromArray(s,3*i,subdivisionV0Scratch),c=Cartesian3.fromArray(s,3*n,subdivisionV1Scratch),d=Cartesian3.fromArray(s,3*t,subdivisionV2Scratch),g=e.cartesianToCartographic(a,subdivisionC0Scratch),_=e.cartesianToCartographic(c,subdivisionC1Scratch),y=e.cartesianToCartographic(d,subdivisionC2Scratch);p.setEndPoints(g,_);const C=p.surfaceDistance;f.setEndPoints(_,y);const T=f.surfaceDistance;m.setEndPoints(y,g);const S=m.surfaceDistance,A=Math.max(C,T,S);let v,E,b,x;A>h?C===A?(v=`${Math.min(i,n)} ${Math.max(i,n)}`,o=u[v],defined(o)||(E=p.interpolateUsingFraction(.5,subdivisionCartographicScratch),b=.5*(g.height+_.height),x=Cartesian3.fromRadians(E.longitude,E.latitude,b,e,subdivisionMidScratch),s.push(x.x,x.y,x.z),o=s.length/3-1,u[v]=o),r.push(i,o,t),r.push(o,n,t)):T===A?(v=`${Math.min(n,t)} ${Math.max(n,t)}`,o=u[v],defined(o)||(E=f.interpolateUsingFraction(.5,subdivisionCartographicScratch),b=.5*(_.height+y.height),x=Cartesian3.fromRadians(E.longitude,E.latitude,b,e,subdivisionMidScratch),s.push(x.x,x.y,x.z),o=s.length/3-1,u[v]=o),r.push(n,o,i),r.push(o,t,i)):S===A&&(v=`${Math.min(t,i)} ${Math.max(t,i)}`,o=u[v],defined(o)||(E=m.interpolateUsingFraction(.5,subdivisionCartographicScratch),b=.5*(y.height+g.height),x=Cartesian3.fromRadians(E.longitude,E.latitude,b,e,subdivisionMidScratch),s.push(x.x,x.y,x.z),o=s.length/3-1,u[v]=o),r.push(t,o,n),r.push(o,i,n)):(l.push(i),l.push(n),l.push(t))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:l,primitiveType:PrimitiveType$1.TRIANGLES})},PolygonPipeline.scaleToGeodeticHeight=function(e,t,n,i){n=defaultValue(n,Ellipsoid.WGS84);let r=scaleToGeodeticHeightN,o=scaleToGeodeticHeightP;if(t=defaultValue(t,0),i=defaultValue(i,!0),defined(e)){const a=e.length;for(let s=0;s<a;s+=3)Cartesian3.fromArray(e,s,o),i&&(o=n.scaleToGeodeticSurface(o,o)),0!==t&&(r=n.geodeticSurfaceNormal(o,r),Cartesian3.multiplyByScalar(r,t,r),Cartesian3.add(o,r,o)),e[s]=o.x,e[s+1]=o.y,e[s+2]=o.z}return e},Object.defineProperties(Queue.prototype,{length:{get:function(){return this._length}}}),Queue.prototype.enqueue=function(e){this._array.push(e),this._length++},Queue.prototype.dequeue=function(){if(0===this._length)return;const e=this._array;let t=this._offset;const n=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,n},Queue.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},Queue.prototype.contains=function(e){return-1!==this._array.indexOf(e)},Queue.prototype.clear=function(){this._array.length=this._offset=this._length=0},Queue.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)};const PolygonGeometryLibrary={computeHierarchyPackedLength:function(e){let t=0;const n=[e];for(;n.length>0;){const e=n.pop();if(!defined(e))continue;t+=2;const i=e.positions,r=e.holes;if(defined(i)&&(t+=i.length*Cartesian3.packedLength),defined(r)){const e=r.length;for(let t=0;t<e;++t)n.push(r[t])}}return t},packPolygonHierarchy:function(e,t,n){const i=[e];for(;i.length>0;){const e=i.pop();if(!defined(e))continue;const r=e.positions,o=e.holes;if(t[n++]=defined(r)?r.length:0,t[n++]=defined(o)?o.length:0,defined(r)){const e=r.length;for(let i=0;i<e;++i,n+=3)Cartesian3.pack(r[i],t,n)}if(defined(o)){const e=o.length;for(let t=0;t<e;++t)i.push(o[t])}}return n},unpackPolygonHierarchy:function(e,t){const n=e[t++],i=e[t++],r=new Array(n),o=i>0?new Array(i):void 0;for(let i=0;i<n;++i,t+=Cartesian3.packedLength)r[i]=Cartesian3.unpack(e,t);for(let n=0;n<i;++n)o[n]=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t),t=o[n].startingIndex,delete o[n].startingIndex;return{positions:r,holes:o,startingIndex:t}}},distanceScratch=new Cartesian3;function getPointAtDistance(e,t,n,i){return Cartesian3.subtract(t,e,distanceScratch),Cartesian3.multiplyByScalar(distanceScratch,n/i,distanceScratch),Cartesian3.add(e,distanceScratch,distanceScratch),[distanceScratch.x,distanceScratch.y,distanceScratch.z]}PolygonGeometryLibrary.subdivideLineCount=function(e,t,n){const i=Cartesian3.distance(e,t)/n,r=Math.max(0,Math.ceil(CesiumMath.log2(i)));return Math.pow(2,r)};const scratchCartographic0$1=new Cartographic,scratchCartographic1$2=new Cartographic,scratchCartographic2$1=new Cartographic,scratchCartesian0=new Cartesian3;PolygonGeometryLibrary.subdivideRhumbLineCount=function(e,t,n,i){const r=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(n,scratchCartographic1$2),e).surfaceDistance/i,o=Math.max(0,Math.ceil(CesiumMath.log2(r)));return Math.pow(2,o)},PolygonGeometryLibrary.subdivideLine=function(e,t,n,i){const r=PolygonGeometryLibrary.subdivideLineCount(e,t,n),o=Cartesian3.distance(e,t),a=o/r;defined(i)||(i=[]);const s=i;s.length=3*r;let c=0;for(let n=0;n<r;n++){const i=getPointAtDistance(e,t,n*a,o);s[c++]=i[0],s[c++]=i[1],s[c++]=i[2]}return s},PolygonGeometryLibrary.subdivideRhumbLine=function(e,t,n,i,r){const o=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(n,scratchCartographic1$2),e),a=o.surfaceDistance/i,s=Math.max(0,Math.ceil(CesiumMath.log2(a))),c=Math.pow(2,s),l=o.surfaceDistance/c;defined(r)||(r=[]);const u=r;u.length=3*c;let d=0;for(let t=0;t<c;t++){const n=o.interpolateUsingSurfaceDistance(t*l,scratchCartographic2$1),i=e.cartographicToCartesian(n,scratchCartesian0);u[d++]=i.x,u[d++]=i.y,u[d++]=i.z}return u};const scaleToGeodeticHeightN1=new Cartesian3,scaleToGeodeticHeightN2=new Cartesian3,scaleToGeodeticHeightP1=new Cartesian3,scaleToGeodeticHeightP2=new Cartesian3;PolygonGeometryLibrary.scaleToGeodeticHeightExtruded=function(e,t,n,i,r){i=defaultValue(i,Ellipsoid.WGS84);const o=scaleToGeodeticHeightN1;let a=scaleToGeodeticHeightN2;const s=scaleToGeodeticHeightP1;let c=scaleToGeodeticHeightP2;if(defined(e)&&defined(e.attributes)&&defined(e.attributes.position)){const l=e.attributes.position.values,u=l.length/2;for(let e=0;e<u;e+=3)Cartesian3.fromArray(l,e,s),i.geodeticSurfaceNormal(s,o),c=i.scaleToGeodeticSurface(s,c),a=Cartesian3.multiplyByScalar(o,n,a),a=Cartesian3.add(c,a,a),l[e+u]=a.x,l[e+1+u]=a.y,l[e+2+u]=a.z,r&&(c=Cartesian3.clone(s,c)),a=Cartesian3.multiplyByScalar(o,t,a),a=Cartesian3.add(c,a,a),l[e]=a.x,l[e+1]=a.y,l[e+2]=a.z}return e},PolygonGeometryLibrary.polygonOutlinesFromHierarchy=function(e,t,n){const i=[],r=new Queue;let o,a,s;for(r.enqueue(e);0!==r.length;){const e=r.dequeue();let c=e.positions;if(t)for(s=c.length,o=0;o<s;o++)n.scaleToGeodeticSurface(c[o],c[o]);if(c=arrayRemoveDuplicates(c,Cartesian3.equalsEpsilon,!0),c.length<3)continue;const l=e.holes?e.holes.length:0;for(o=0;o<l;o++){const c=e.holes[o];let l=c.positions;if(t)for(s=l.length,a=0;a<s;++a)n.scaleToGeodeticSurface(l[a],l[a]);if(l=arrayRemoveDuplicates(l,Cartesian3.equalsEpsilon,!0),l.length<3)continue;i.push(l);let u=0;for(defined(c.holes)&&(u=c.holes.length),a=0;a<u;a++)r.enqueue(c.holes[a])}i.push(c)}return i},PolygonGeometryLibrary.polygonsFromHierarchy=function(e,t,n,i){const r=[],o=[],a=new Queue;for(a.enqueue(e);0!==a.length;){const e=a.dequeue();let s=e.positions;const c=e.holes;let l,u;if(n)for(u=s.length,l=0;l<u;l++)i.scaleToGeodeticSurface(s[l],s[l]);if(s=arrayRemoveDuplicates(s,Cartesian3.equalsEpsilon,!0),s.length<3)continue;let d=t(s);if(!defined(d))continue;const h=[];let p=PolygonPipeline.computeWindingOrder2D(d);p===WindingOrder$1.CLOCKWISE&&(d.reverse(),s=s.slice().reverse());let f=s.slice();const m=defined(c)?c.length:0,g=[];let _;for(l=0;l<m;l++){const e=c[l];let r=e.positions;if(n)for(u=r.length,_=0;_<u;++_)i.scaleToGeodeticSurface(r[_],r[_]);if(r=arrayRemoveDuplicates(r,Cartesian3.equalsEpsilon,!0),r.length<3)continue;const o=t(r);if(!defined(o))continue;p=PolygonPipeline.computeWindingOrder2D(o),p===WindingOrder$1.CLOCKWISE&&(o.reverse(),r=r.slice().reverse()),g.push(r),h.push(f.length),f=f.concat(r),d=d.concat(o);let s=0;for(defined(e.holes)&&(s=e.holes.length),_=0;_<s;_++)a.enqueue(e.holes[_])}r.push({outerRing:s,holes:g}),o.push({positions:f,positions2D:d,holes:h})}return{hierarchy:r,polygons:o}};const computeBoundingRectangleCartesian2=new Cartesian2,computeBoundingRectangleCartesian3=new Cartesian3,computeBoundingRectangleQuaternion=new Quaternion,computeBoundingRectangleMatrix3=new Matrix3;PolygonGeometryLibrary.computeBoundingRectangle=function(e,t,n,i,r){const o=Quaternion.fromAxisAngle(e,i,computeBoundingRectangleQuaternion),a=Matrix3.fromQuaternion(o,computeBoundingRectangleMatrix3);let s=Number.POSITIVE_INFINITY,c=Number.NEGATIVE_INFINITY,l=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY;const d=n.length;for(let e=0;e<d;++e){const i=Cartesian3.clone(n[e],computeBoundingRectangleCartesian3);Matrix3.multiplyByVector(a,i,i);const r=t(i,computeBoundingRectangleCartesian2);defined(r)&&(s=Math.min(s,r.x),c=Math.max(c,r.x),l=Math.min(l,r.y),u=Math.max(u,r.y))}return r.x=s,r.y=l,r.width=c-s,r.height=u-l,r},PolygonGeometryLibrary.createGeometryFromPositions=function(e,t,n,i,r,o){let a=PolygonPipeline.triangulate(t.positions2D,t.holes);a.length<3&&(a=[0,1,2]);const s=t.positions;if(i){const e=s.length,t=new Array(3*e);let n=0;for(let i=0;i<e;i++){const e=s[i];t[n++]=e.x,t[n++]=e.y,t[n++]=e.z}const i=new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t})},indices:a,primitiveType:PrimitiveType$1.TRIANGLES});return r.normal?GeometryPipeline.computeNormal(i):i}return o===ArcType$1.GEODESIC?PolygonPipeline.computeSubdivision(e,s,a,n):o===ArcType$1.RHUMB?PolygonPipeline.computeRhumbLineSubdivision(e,s,a,n):void 0};const computeWallIndicesSubdivided=[],p1Scratch$1=new Cartesian3,p2Scratch$1=new Cartesian3;PolygonGeometryLibrary.computeWallGeometry=function(e,t,n,i,r){let o,a,s,c,l,u=e.length,d=0;if(i)for(a=3*u*2,o=new Array(2*a),s=0;s<u;s++)c=e[s],l=e[(s+1)%u],o[d]=o[d+a]=c.x,++d,o[d]=o[d+a]=c.y,++d,o[d]=o[d+a]=c.z,++d,o[d]=o[d+a]=l.x,++d,o[d]=o[d+a]=l.y,++d,o[d]=o[d+a]=l.z,++d;else{const i=CesiumMath.chordLength(n,t.maximumRadius);let h=0;if(r===ArcType$1.GEODESIC)for(s=0;s<u;s++)h+=PolygonGeometryLibrary.subdivideLineCount(e[s],e[(s+1)%u],i);else if(r===ArcType$1.RHUMB)for(s=0;s<u;s++)h+=PolygonGeometryLibrary.subdivideRhumbLineCount(t,e[s],e[(s+1)%u],i);for(a=3*(h+u),o=new Array(2*a),s=0;s<u;s++){let n;c=e[s],l=e[(s+1)%u],r===ArcType$1.GEODESIC?n=PolygonGeometryLibrary.subdivideLine(c,l,i,computeWallIndicesSubdivided):r===ArcType$1.RHUMB&&(n=PolygonGeometryLibrary.subdivideRhumbLine(t,c,l,i,computeWallIndicesSubdivided));const h=n.length;for(let e=0;e<h;++e,++d)o[d]=n[e],o[d+a]=n[e];o[d]=l.x,o[d+a]=l.x,++d,o[d]=l.y,o[d+a]=l.y,++d,o[d]=l.z,o[d+a]=l.z,++d}}u=o.length;const h=IndexDatatype$1.createTypedArray(u/3,u-6*e.length);let p=0;for(u/=6,s=0;s<u;s++){const e=s,t=e+1,n=e+u,i=n+1;c=Cartesian3.fromArray(o,3*e,p1Scratch$1),l=Cartesian3.fromArray(o,3*t,p2Scratch$1),Cartesian3.equalsEpsilon(c,l,CesiumMath.EPSILON10,CesiumMath.EPSILON10)||(h[p++]=e,h[p++]=n,h[p++]=t,h[p++]=t,h[p++]=n,h[p++]=i)}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})}),indices:h,primitiveType:PrimitiveType$1.TRIANGLES})};const scratchPosition$c=new Cartesian3,scratchBR=new BoundingRectangle,stScratch$1=new Cartesian2,textureCoordinatesOrigin=new Cartesian2,scratchNormal$4=new Cartesian3,scratchTangent$3=new Cartesian3,scratchBitangent$3=new Cartesian3,centerScratch$5=new Cartesian3,axis1Scratch=new Cartesian3,axis2Scratch=new Cartesian3,quaternionScratch$2=new Quaternion,textureMatrixScratch=new Matrix3,tangentRotationScratch=new Matrix3,surfaceNormalScratch=new Cartesian3;function createGeometryFromPolygon(e,t,n,i,r,o,a,s){const c=e.positions;let l=PolygonPipeline.triangulate(e.positions2D,e.holes);l.length<3&&(l=[0,1,2]);const u=IndexDatatype$1.createTypedArray(c.length,l.length);u.set(l);let d=textureMatrixScratch;if(0!==i){let e=Quaternion.fromAxisAngle(o,i,quaternionScratch$2);if(d=Matrix3.fromQuaternion(e,d),t.tangent||t.bitangent){e=Quaternion.fromAxisAngle(o,-i,quaternionScratch$2);const n=Matrix3.fromQuaternion(e,tangentRotationScratch);a=Cartesian3.normalize(Matrix3.multiplyByVector(n,a,a),a),t.bitangent&&(s=Cartesian3.normalize(Cartesian3.cross(o,a,s),s))}}else d=Matrix3.clone(Matrix3.IDENTITY,d);const h=textureCoordinatesOrigin;t.st&&(h.x=n.x,h.y=n.y);const p=c.length,f=3*p,m=new Float64Array(f),g=t.normal?new Float32Array(f):void 0,_=t.tangent?new Float32Array(f):void 0,y=t.bitangent?new Float32Array(f):void 0,C=t.st?new Float32Array(2*p):void 0;let T=0,S=0,A=0,v=0,E=0;for(let e=0;e<p;e++){const i=c[e];if(m[T++]=i.x,m[T++]=i.y,m[T++]=i.z,t.st){const e=r(Matrix3.multiplyByVector(d,i,scratchPosition$c),stScratch$1);Cartesian2.subtract(e,h,e);const t=CesiumMath.clamp(e.x/n.width,0,1),o=CesiumMath.clamp(e.y/n.height,0,1);C[E++]=t,C[E++]=o}t.normal&&(g[S++]=o.x,g[S++]=o.y,g[S++]=o.z),t.tangent&&(_[v++]=a.x,_[v++]=a.y,_[v++]=a.z),t.bitangent&&(y[A++]=s.x,y[A++]=s.y,y[A++]=s.z)}const b=new GeometryAttributes;return t.position&&(b.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:m})),t.normal&&(b.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),t.tangent&&(b.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.bitangent&&(b.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),t.st&&(b.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:C})),new Geometry({attributes:b,indices:u,primitiveType:PrimitiveType$1.TRIANGLES})}function CoplanarPolygonGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=VertexFormat.clone(n),this._polygonHierarchy=t,this._stRotation=defaultValue(e.stRotation,0),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+VertexFormat.packedLength+Ellipsoid.packedLength+2}CoplanarPolygonGeometry.fromPositions=function(e){return new CoplanarPolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid})},CoplanarPolygonGeometry.pack=function(e,t,n){return n=defaultValue(n,0),n=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,n),Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._stRotation,t[n]=e.packedLength,t};const scratchEllipsoid$c=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$a=new VertexFormat,scratchOptions$h={polygonHierarchy:{}};function createGeometryFromPositions$1(e){const t=e.length,n=new Float64Array(3*t),i=IndexDatatype$1.createTypedArray(t,2*t);let r=0,o=0;for(let a=0;a<t;a++){const s=e[a];n[r++]=s.x,n[r++]=s.y,n[r++]=s.z,i[o++]=a,i[o++]=(a+1)%t}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:n})}),indices:i,primitiveType:PrimitiveType$1.LINES})}function CoplanarPolygonOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy;this._polygonHierarchy=t,this._workerName="createCoplanarPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+1}CoplanarPolygonGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$c);t+=Ellipsoid.packedLength;const o=VertexFormat.unpack(e,t,scratchVertexFormat$a);t+=VertexFormat.packedLength;const a=e[t++],s=e[t];return defined(n)||(n=new CoplanarPolygonGeometry(scratchOptions$h)),n._polygonHierarchy=i,n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._stRotation=a,n.packedLength=s,n},CoplanarPolygonGeometry.createGeometry=function(e){const t=e._vertexFormat,n=e._polygonHierarchy,i=e._stRotation;let r=n.positions;if(r=arrayRemoveDuplicates(r,Cartesian3.equalsEpsilon,!0),r.length<3)return;let o=scratchNormal$4,a=scratchTangent$3,s=scratchBitangent$3,c=axis1Scratch;const l=axis2Scratch;if(!CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(r,centerScratch$5,c,l))return;if(o=Cartesian3.cross(c,l,o),o=Cartesian3.normalize(o,o),!Cartesian3.equalsEpsilon(centerScratch$5,Cartesian3.ZERO,CesiumMath.EPSILON6)){const t=e._ellipsoid.geodeticSurfaceNormal(centerScratch$5,surfaceNormalScratch);Cartesian3.dot(o,t)<0&&(o=Cartesian3.negate(o,o),c=Cartesian3.negate(c,c))}const u=CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(centerScratch$5,c,l),d=CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(centerScratch$5,c,l);t.tangent&&(a=Cartesian3.clone(c,a)),t.bitangent&&(s=Cartesian3.clone(l,s));const h=PolygonGeometryLibrary.polygonsFromHierarchy(n,u,!1),p=h.hierarchy,f=h.polygons;if(0===p.length)return;r=p[0].outerRing;const m=BoundingSphere.fromPoints(r),g=PolygonGeometryLibrary.computeBoundingRectangle(o,d,r,i,scratchBR),_=[];for(let e=0;e<f.length;e++){const n=new GeometryInstance({geometry:createGeometryFromPolygon(f[e],t,g,i,d,o,a,s)});_.push(n)}const y=GeometryPipeline.combineInstances(_)[0];y.attributes.position.values=new Float64Array(y.attributes.position.values),y.indices=IndexDatatype$1.createTypedArray(y.attributes.position.values.length/3,y.indices);const C=y.attributes;return t.position||delete C.position,new Geometry({attributes:C,indices:y.indices,primitiveType:y.primitiveType,boundingSphere:m})},CoplanarPolygonOutlineGeometry.fromPositions=function(e){return new CoplanarPolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions}})},CoplanarPolygonOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),t[n=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,n)]=e.packedLength,t};const scratchOptions$g={polygonHierarchy:{}};CoplanarPolygonOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;const r=e[t];return defined(n)||(n=new CoplanarPolygonOutlineGeometry(scratchOptions$g)),n._polygonHierarchy=i,n.packedLength=r,n},CoplanarPolygonOutlineGeometry.createGeometry=function(e){const t=e._polygonHierarchy;let n=t.positions;if(n=arrayRemoveDuplicates(n,Cartesian3.equalsEpsilon,!0),n.length<3)return;if(!CoplanarPolygonGeometryLibrary.validOutline(n))return;const i=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(t,!1);if(0===i.length)return;const r=[];for(let e=0;e<i.length;e++){const t=new GeometryInstance({geometry:createGeometryFromPositions$1(i[e])});r.push(t)}const o=GeometryPipeline.combineInstances(r)[0],a=BoundingSphere.fromPoints(t.positions);return new Geometry({attributes:o.attributes,indices:o.indices,primitiveType:o.primitiveType,boundingSphere:a})};const CornerType={ROUNDED:0,MITERED:1,BEVELED:2};var CornerType$1=Object.freeze(CornerType);function setConstants(e){const t=e._uSquared,n=e._ellipsoid.maximumRadius,i=e._ellipsoid.minimumRadius,r=(n-i)/n,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-r)*Math.tan(e._start.latitude),c=1/Math.sqrt(1+s*s),l=c*s,u=Math.atan2(s,o),d=c*a,h=d*d,p=1-h,f=Math.sqrt(p),m=t/4,g=m*m,_=g*m,y=g*g,C=1+m-3*g/4+5*_/4-175*y/64,T=1-m+15*g/8-35*_/8,S=1-3*m+35*g/4,A=1-5*m,v=C*u-T*Math.sin(2*u)*m/2-S*Math.sin(4*u)*g/16-A*Math.sin(6*u)*_/48-5*Math.sin(8*u)*y/512,E=e._constants;E.a=n,E.b=i,E.f=r,E.cosineHeading=o,E.sineHeading=a,E.tanU=s,E.cosineU=c,E.sineU=l,E.sigma=u,E.sineAlpha=d,E.sineSquaredAlpha=h,E.cosineSquaredAlpha=p,E.cosineAlpha=f,E.u2Over4=m,E.u4Over16=g,E.u6Over64=_,E.u8Over256=y,E.a0=C,E.a1=T,E.a2=S,E.a3=A,E.distanceRatio=v}function computeC(e,t){return e*t*(4+e*(4-3*t))/16}function computeDeltaLambda(e,t,n,i,r,o,a){const s=computeC(e,n);return(1-s)*e*t*(i+s*r*(a+s*o*(2*a*a-1)))}function vincentyInverseFormula(e,t,n,i,r,o,a){const s=(t-n)/t,c=o-i,l=Math.atan((1-s)*Math.tan(r)),u=Math.atan((1-s)*Math.tan(a)),d=Math.cos(l),h=Math.sin(l),p=Math.cos(u),f=Math.sin(u),m=d*p,g=d*f,_=h*f,y=h*p;let C,T,S,A,v,E=c,b=CesiumMath.TWO_PI,x=Math.cos(E),P=Math.sin(E);do{x=Math.cos(E),P=Math.sin(E);const e=g-y*x;let t;S=Math.sqrt(p*p*P*P+e*e),T=_+m*x,C=Math.atan2(S,T),0===S?(t=0,A=1):(t=m*P/S,A=1-t*t),b=E,v=T-2*_/A,isFinite(v)||(v=0),E=c+computeDeltaLambda(s,t,A,C,S,T,v)}while(Math.abs(E-b)>CesiumMath.EPSILON12);const D=A*(t*t-n*n)/(n*n),w=D*(256+D*(D*(74-47*D)-128))/1024,M=v*v,I=n*(1+D*(4096+D*(D*(320-175*D)-768))/16384)*(C-w*S*(v+w*(T*(2*M-1)-w*v*(4*S*S-3)*(4*M-3)/6)/4)),R=Math.atan2(p*P,g-y*x),O=Math.atan2(d*P,g*x-y);e._distance=I,e._startHeading=R,e._endHeading=O,e._uSquared=D}const scratchCart1=new Cartesian3,scratchCart2$1=new Cartesian3;function computeProperties(e,t,n,i){Cartesian3.normalize(i.cartographicToCartesian(t,scratchCart2$1),scratchCart1),Cartesian3.normalize(i.cartographicToCartesian(n,scratchCart2$1),scratchCart2$1),vincentyInverseFormula(e,i.maximumRadius,i.minimumRadius,t.longitude,t.latitude,n.longitude,n.latitude),e._start=Cartographic.clone(t,e._start),e._end=Cartographic.clone(n,e._end),e._start.height=0,e._end.height=0,setConstants(e)}function EllipsoidGeodesic(e,t,n){const i=defaultValue(n,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,defined(e)&&defined(t)&&computeProperties(this,e,t,i)}Object.defineProperties(EllipsoidGeodesic.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),EllipsoidGeodesic.prototype.setEndPoints=function(e,t){computeProperties(this,e,t,this._ellipsoid)},EllipsoidGeodesic.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},EllipsoidGeodesic.prototype.interpolateUsingSurfaceDistance=function(e,t){const n=this._constants,i=n.distanceRatio+e/n.b,r=Math.cos(2*i),o=Math.cos(4*i),a=Math.cos(6*i),s=Math.sin(2*i),c=Math.sin(4*i),l=Math.sin(6*i),u=Math.sin(8*i),d=i*i,h=i*d,p=n.u8Over256,f=n.u2Over4,m=n.u6Over64,g=n.u4Over16;let _=2*h*p*r/3+i*(1-f+7*g/4-15*m/4+579*p/64-(g-15*m/4+187*p/16)*r-(5*m/4-115*p/16)*o-29*p*a/16)+(f/2-g+71*m/32-85*p/16)*s+(5*g/16-5*m/4+383*p/96)*c-d*((m-11*p/2)*s+5*p*c/2)+(29*m/96-29*p/16)*l+539*p*u/1536;const y=Math.asin(Math.sin(_)*n.cosineAlpha),C=Math.atan(n.a/n.b*Math.tan(y));_-=n.sigma;const T=Math.cos(2*n.sigma+_),S=Math.sin(_),A=Math.cos(_),v=n.cosineU*A,E=n.sineU*S,b=Math.atan2(S*n.sineHeading,v-E*n.cosineHeading)-computeDeltaLambda(n.f,n.sineAlpha,n.cosineSquaredAlpha,_,S,A,T);return defined(t)?(t.longitude=this._start.longitude+b,t.latitude=C,t.height=0,t):new Cartographic(this._start.longitude+b,C,0)};const PolylinePipeline={numberOfPoints:function(e,t,n){const i=Cartesian3.distance(e,t);return Math.ceil(i/n)},numberOfPointsRhumbLine:function(e,t,n){const i=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.max(1,Math.ceil(Math.sqrt(i/(n*n))))}},cartoScratch$2=new Cartographic;PolylinePipeline.extractHeights=function(e,t){const n=e.length,i=new Array(n);for(let r=0;r<n;r++){const n=e[r];i[r]=t.cartesianToCartographic(n,cartoScratch$2).height}return i};const wrapLongitudeInversMatrix=new Matrix4,wrapLongitudeOrigin=new Cartesian3,wrapLongitudeXZNormal=new Cartesian3,wrapLongitudeXZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeYZNormal=new Cartesian3,wrapLongitudeYZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeIntersection=new Cartesian3,wrapLongitudeOffset=new Cartesian3,subdivideHeightsScratchArray=[];function subdivideHeights$1(e,t,n){const i=subdivideHeightsScratchArray;let r;if(i.length=e,t===n){for(r=0;r<e;r++)i[r]=t;return i}const o=(n-t)/e;for(r=0;r<e;r++){const e=t+r*o;i[r]=e}return i}const carto1=new Cartographic,carto2=new Cartographic,cartesian=new Cartesian3,scaleFirst=new Cartesian3,scaleLast=new Cartesian3,ellipsoidGeodesic$1=new EllipsoidGeodesic;let ellipsoidRhumb=new EllipsoidRhumbLine;function generateCartesianArc(e,t,n,i,r,o,a,s){const c=i.scaleToGeodeticSurface(e,scaleFirst),l=i.scaleToGeodeticSurface(t,scaleLast),u=PolylinePipeline.numberOfPoints(e,t,n),d=i.cartesianToCartographic(c,carto1),h=i.cartesianToCartographic(l,carto2),p=subdivideHeights$1(u,r,o);ellipsoidGeodesic$1.setEndPoints(d,h);const f=ellipsoidGeodesic$1.surfaceDistance/u;let m=s;d.height=r;let g=i.cartographicToCartesian(d,cartesian);Cartesian3.pack(g,a,m),m+=3;for(let e=1;e<u;e++){const t=ellipsoidGeodesic$1.interpolateUsingSurfaceDistance(e*f,carto2);t.height=p[e],g=i.cartographicToCartesian(t,cartesian),Cartesian3.pack(g,a,m),m+=3}return m}function generateCartesianRhumbArc(e,t,n,i,r,o,a,s){const c=i.cartesianToCartographic(e,carto1),l=i.cartesianToCartographic(t,carto2),u=PolylinePipeline.numberOfPointsRhumbLine(c,l,n);c.height=0,l.height=0;const d=subdivideHeights$1(u,r,o);ellipsoidRhumb.ellipsoid.equals(i)||(ellipsoidRhumb=new EllipsoidRhumbLine(void 0,void 0,i)),ellipsoidRhumb.setEndPoints(c,l);const h=ellipsoidRhumb.surfaceDistance/u;let p=s;c.height=r;let f=i.cartographicToCartesian(c,cartesian);Cartesian3.pack(f,a,p),p+=3;for(let e=1;e<u;e++){const t=ellipsoidRhumb.interpolateUsingSurfaceDistance(e*h,carto2);t.height=d[e],f=i.cartographicToCartesian(t,cartesian),Cartesian3.pack(f,a,p),p+=3}return p}PolylinePipeline.wrapLongitude=function(e,t){const n=[],i=[];if(defined(e)&&e.length>0){t=defaultValue(t,Matrix4.IDENTITY);const r=Matrix4.inverseTransformation(t,wrapLongitudeInversMatrix),o=Matrix4.multiplyByPoint(r,Cartesian3.ZERO,wrapLongitudeOrigin),a=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(r,Cartesian3.UNIT_Y,wrapLongitudeXZNormal),wrapLongitudeXZNormal),s=Plane.fromPointNormal(o,a,wrapLongitudeXZPlane),c=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(r,Cartesian3.UNIT_X,wrapLongitudeYZNormal),wrapLongitudeYZNormal),l=Plane.fromPointNormal(o,c,wrapLongitudeYZPlane);let u=1;n.push(Cartesian3.clone(e[0]));let d=n[0];const h=e.length;for(let t=1;t<h;++t){const r=e[t];if(Plane.getPointDistance(l,d)<0||Plane.getPointDistance(l,r)<0){const e=IntersectionTests.lineSegmentPlane(d,r,s,wrapLongitudeIntersection);if(defined(e)){const t=Cartesian3.multiplyByScalar(a,5e-9,wrapLongitudeOffset);Plane.getPointDistance(s,d)<0&&Cartesian3.negate(t,t),n.push(Cartesian3.add(e,t,new Cartesian3)),i.push(u+1),Cartesian3.negate(t,t),n.push(Cartesian3.add(e,t,new Cartesian3)),u=1}}n.push(Cartesian3.clone(e[t])),u++,d=r}i.push(u)}return{positions:n,lengths:i}},PolylinePipeline.generateArc=function(e){defined(e)||(e={});const t=e.positions,n=t.length,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84);let r=defaultValue(e.height,0);const o=Array.isArray(r);if(n<1)return[];if(1===n){const e=i.scaleToGeodeticSurface(t[0],scaleFirst);if(r=o?r[0]:r,0!==r){const t=i.geodeticSurfaceNormal(e,cartesian);Cartesian3.multiplyByScalar(t,r,t),Cartesian3.add(e,t,e)}return[e.x,e.y,e.z]}let a=e.minDistance;if(!defined(a)){const t=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);a=CesiumMath.chordLength(t,i.maximumRadius)}let s,c=0;for(s=0;s<n-1;s++)c+=PolylinePipeline.numberOfPoints(t[s],t[s+1],a);const l=3*(c+1),u=new Array(l);let d=0;for(s=0;s<n-1;s++){d=generateCartesianArc(t[s],t[s+1],a,i,o?r[s]:r,o?r[s+1]:r,u,d)}subdivideHeightsScratchArray.length=0;const h=t[n-1],p=i.cartesianToCartographic(h,carto1);p.height=o?r[n-1]:r;const f=i.cartographicToCartesian(p,cartesian);return Cartesian3.pack(f,u,l-3),u};const scratchCartographic0=new Cartographic,scratchCartographic1$1=new Cartographic;PolylinePipeline.generateRhumbArc=function(e){defined(e)||(e={});const t=e.positions,n=t.length,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84);let r=defaultValue(e.height,0);const o=Array.isArray(r);if(n<1)return[];if(1===n){const e=i.scaleToGeodeticSurface(t[0],scaleFirst);if(r=o?r[0]:r,0!==r){const t=i.geodeticSurfaceNormal(e,cartesian);Cartesian3.multiplyByScalar(t,r,t),Cartesian3.add(e,t,e)}return[e.x,e.y,e.z]}const a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);let s,c,l=0,u=i.cartesianToCartographic(t[0],scratchCartographic0);for(s=0;s<n-1;s++)c=i.cartesianToCartographic(t[s+1],scratchCartographic1$1),l+=PolylinePipeline.numberOfPointsRhumbLine(u,c,a),u=Cartographic.clone(c,scratchCartographic0);const d=3*(l+1),h=new Array(d);let p=0;for(s=0;s<n-1;s++){p=generateCartesianRhumbArc(t[s],t[s+1],a,i,o?r[s]:r,o?r[s+1]:r,h,p)}subdivideHeightsScratchArray.length=0;const f=t[n-1],m=i.cartesianToCartographic(f,carto1);m.height=o?r[n-1]:r;const g=i.cartographicToCartesian(m,cartesian);return Cartesian3.pack(g,h,d-3),h},PolylinePipeline.generateCartesianArc=function(e){const t=PolylinePipeline.generateArc(e),n=t.length/3,i=new Array(n);for(let e=0;e<n;e++)i[e]=Cartesian3.unpack(t,3*e);return i},PolylinePipeline.generateCartesianRhumbArc=function(e){const t=PolylinePipeline.generateRhumbArc(e),n=t.length/3,i=new Array(n);for(let e=0;e<n;e++)i[e]=Cartesian3.unpack(t,3*e);return i};const warnings={};function oneTimeWarning(e,t){defined(warnings[e])||(warnings[e]=!0,console.warn(defaultValue(t,e)))}oneTimeWarning.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",oneTimeWarning.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",oneTimeWarning.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",oneTimeWarning.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";const scratch2Array=[new Cartesian3,new Cartesian3],scratchCartesian1$3=new Cartesian3,scratchCartesian2$6=new Cartesian3,scratchCartesian3$7=new Cartesian3,scratchCartesian4$4=new Cartesian3,scratchCartesian5$1=new Cartesian3,scratchCartesian6=new Cartesian3,scratchCartesian7=new Cartesian3,scratchCartesian8=new Cartesian3,scratchCartesian9=new Cartesian3,scratch1$2=new Cartesian3,scratch2$2=new Cartesian3,PolylineVolumeGeometryLibrary={};let cartographic=new Cartographic;function scaleToSurface$2(e,t){const n=new Array(e.length);for(let i=0;i<e.length;i++){const r=e[i];cartographic=t.cartesianToCartographic(r,cartographic),n[i]=cartographic.height,e[i]=t.scaleToGeodeticSurface(r,r)}return n}function subdivideHeights(e,t,n,i){const r=e[0],o=e[1],a=Cartesian3.angleBetween(r,o),s=Math.ceil(a/i),c=new Array(s);let l;if(t===n){for(l=0;l<s;l++)c[l]=t;return c.push(n),c}const u=(n-t)/s;for(l=1;l<s;l++){const e=t+l*u;c[l]=e}return c[0]=t,c.push(n),c}const nextScratch=new Cartesian3,prevScratch=new Cartesian3;function computeRotationAngle(e,t,n,i){const r=new EllipsoidTangentPlane(n,i),o=r.projectPointOntoPlane(Cartesian3.add(n,e,nextScratch),nextScratch),a=r.projectPointOntoPlane(Cartesian3.add(n,t,prevScratch),prevScratch),s=Cartesian2.angleBetween(o,a);return a.x*o.y-a.y*o.x>=0?-s:s}const negativeX=new Cartesian3(-1,0,0);let transform$2=new Matrix4;const translation$1=new Matrix4;let rotationZ=new Matrix3;const scaleMatrix=Matrix3.IDENTITY.clone(),westScratch=new Cartesian3,finalPosScratch=new Cartesian4,heightCartesian=new Cartesian3;function addPosition(e,t,n,i,r,o,a,s){let c=westScratch,l=finalPosScratch;transform$2=Transforms.eastNorthUpToFixedFrame(e,r,transform$2),c=Matrix4.multiplyByPointAsVector(transform$2,negativeX,c),c=Cartesian3.normalize(c,c);const u=computeRotationAngle(c,t,e,r);rotationZ=Matrix3.fromRotationZ(u,rotationZ),heightCartesian.z=o,transform$2=Matrix4.multiplyTransformation(transform$2,Matrix4.fromRotationTranslation(rotationZ,heightCartesian,translation$1),transform$2);const d=scaleMatrix;d[0]=a;for(let e=0;e<s;e++)for(let e=0;e<n.length;e+=3)l=Cartesian3.fromArray(n,e,l),l=Matrix3.multiplyByVector(d,l,l),l=Matrix4.multiplyByPoint(transform$2,l,l),i.push(l.x,l.y,l.z);return i}const centerScratch$4=new Cartesian3;function addPositions(e,t,n,i,r,o,a){for(let s=0;s<e.length;s+=3){i=addPosition(Cartesian3.fromArray(e,s,centerScratch$4),t,n,i,r,o[s/3],a,1)}return i}function convertShapeTo3DDuplicate(e,t){const n=e.length,i=new Array(6*n);let r=0;const o=t.x+t.width/2,a=t.y+t.height/2;let s=e[0];i[r++]=s.x-o,i[r++]=0,i[r++]=s.y-a;for(let t=1;t<n;t++){s=e[t];const n=s.x-o,c=s.y-a;i[r++]=n,i[r++]=0,i[r++]=c,i[r++]=n,i[r++]=0,i[r++]=c}return s=e[0],i[r++]=s.x-o,i[r++]=0,i[r++]=s.y-a,i}function convertShapeTo3D(e,t){const n=e.length,i=new Array(3*n);let r=0;const o=t.x+t.width/2,a=t.y+t.height/2;for(let t=0;t<n;t++)i[r++]=e[t].x-o,i[r++]=0,i[r++]=e[t].y-a;return i}const quaterion$1=new Quaternion,startPointScratch=new Cartesian3,rotMatrix$1=new Matrix3;function computeRoundCorner$1(e,t,n,i,r,o,a,s,c,l){const u=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$2),Cartesian3.subtract(n,e,scratch2$2)),d=i===CornerType$1.BEVELED?0:Math.ceil(u/CesiumMath.toRadians(5));let h,p,f;if(h=r?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$2),u/(d+1),quaterion$1),rotMatrix$1):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,u/(d+1),quaterion$1),rotMatrix$1),t=Cartesian3.clone(t,startPointScratch),d>0){const n=l?2:1;for(let i=0;i<d;i++)t=Matrix3.multiplyByVector(h,t,t),p=Cartesian3.subtract(t,e,scratch1$2),p=Cartesian3.normalize(p,p),r||(p=Cartesian3.negate(p,p)),f=o.scaleToGeodeticSurface(t,scratch2$2),a=addPosition(f,p,s,a,o,c,1,n)}else p=Cartesian3.subtract(t,e,scratch1$2),p=Cartesian3.normalize(p,p),r||(p=Cartesian3.negate(p,p)),f=o.scaleToGeodeticSurface(t,scratch2$2),a=addPosition(f,p,s,a,o,c,1,1),n=Cartesian3.clone(n,startPointScratch),p=Cartesian3.subtract(n,e,scratch1$2),p=Cartesian3.normalize(p,p),r||(p=Cartesian3.negate(p,p)),f=o.scaleToGeodeticSurface(n,scratch2$2),a=addPosition(f,p,s,a,o,c,1,1);return a}PolylineVolumeGeometryLibrary.removeDuplicatesFromShape=function(e){const t=e.length,n=[];for(let i=t-1,r=0;r<t;i=r++){const t=e[i],o=e[r];Cartesian2.equals(t,o)||n.push(o)}return n},PolylineVolumeGeometryLibrary.angleIsGreaterThanPi=function(e,t,n,i){const r=new EllipsoidTangentPlane(n,i),o=r.projectPointOntoPlane(Cartesian3.add(n,e,nextScratch),nextScratch),a=r.projectPointOntoPlane(Cartesian3.add(n,t,prevScratch),prevScratch);return a.x*o.y-a.y*o.x>=0};const scratchForwardProjection$1=new Cartesian3,scratchBackwardProjection$1=new Cartesian3;PolylineVolumeGeometryLibrary.computePositions=function(e,t,n,i,r){const o=i._ellipsoid,a=scaleToSurface$2(e,o),s=i._granularity,c=i._cornerType,l=r?convertShapeTo3DDuplicate(t,n):convertShapeTo3D(t,n),u=r?convertShapeTo3D(t,n):void 0,d=n.height/2,h=n.width/2;let p=e.length,f=[],m=r?[]:void 0,g=scratchCartesian1$3,_=scratchCartesian2$6,y=scratchCartesian3$7,C=scratchCartesian4$4,T=scratchCartesian5$1,S=scratchCartesian6,A=scratchCartesian7,v=scratchCartesian8,E=scratchCartesian9,b=e[0],x=e[1];C=o.geodeticSurfaceNormal(b,C),g=Cartesian3.subtract(x,b,g),g=Cartesian3.normalize(g,g),v=Cartesian3.cross(C,g,v),v=Cartesian3.normalize(v,v);let P,D,w=a[0],M=a[1];r&&(m=addPosition(b,v,u,m,o,w+d,1,1)),E=Cartesian3.clone(b,E),b=x,_=Cartesian3.negate(g,_);for(let t=1;t<p-1;t++){const n=r?2:1;if(x=e[t+1],b.equals(x)){oneTimeWarning("Positions are too close and are considered equivalent with rounding error.");continue}g=Cartesian3.subtract(x,b,g),g=Cartesian3.normalize(g,g),y=Cartesian3.add(g,_,y),y=Cartesian3.normalize(y,y),C=o.geodeticSurfaceNormal(b,C);const i=Cartesian3.multiplyByScalar(C,Cartesian3.dot(g,C),scratchForwardProjection$1);Cartesian3.subtract(g,i,i),Cartesian3.normalize(i,i);const u=Cartesian3.multiplyByScalar(C,Cartesian3.dot(_,C),scratchBackwardProjection$1);Cartesian3.subtract(_,u,u),Cartesian3.normalize(u,u);if(!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(i,u)),1,CesiumMath.EPSILON7)){y=Cartesian3.cross(y,C,y),y=Cartesian3.cross(C,y,y),y=Cartesian3.normalize(y,y);const e=1/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(y,_,scratch1$2))),t=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(g,_,b,o);t?(T=Cartesian3.add(b,Cartesian3.multiplyByScalar(y,e*h,y),T),S=Cartesian3.add(T,Cartesian3.multiplyByScalar(v,h,S),S),scratch2Array[0]=Cartesian3.clone(E,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(S,scratch2Array[1]),P=subdivideHeights(scratch2Array,w+d,M+d,s),D=PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:o}),f=addPositions(D,v,l,f,o,P,1),v=Cartesian3.cross(C,g,v),v=Cartesian3.normalize(v,v),A=Cartesian3.add(T,Cartesian3.multiplyByScalar(v,h,A),A),c===CornerType$1.ROUNDED||c===CornerType$1.BEVELED?computeRoundCorner$1(T,S,A,c,t,o,f,l,M+d,r):(y=Cartesian3.negate(y,y),f=addPosition(b,y,l,f,o,M+d,e,n)),E=Cartesian3.clone(A,E)):(T=Cartesian3.add(b,Cartesian3.multiplyByScalar(y,e*h,y),T),S=Cartesian3.add(T,Cartesian3.multiplyByScalar(v,-h,S),S),scratch2Array[0]=Cartesian3.clone(E,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(S,scratch2Array[1]),P=subdivideHeights(scratch2Array,w+d,M+d,s),D=PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:o}),f=addPositions(D,v,l,f,o,P,1),v=Cartesian3.cross(C,g,v),v=Cartesian3.normalize(v,v),A=Cartesian3.add(T,Cartesian3.multiplyByScalar(v,-h,A),A),c===CornerType$1.ROUNDED||c===CornerType$1.BEVELED?computeRoundCorner$1(T,S,A,c,t,o,f,l,M+d,r):f=addPosition(b,y,l,f,o,M+d,e,n),E=Cartesian3.clone(A,E)),_=Cartesian3.negate(g,_)}else f=addPosition(E,v,l,f,o,w+d,1,1),E=b;w=M,M=a[t+1],b=x}scratch2Array[0]=Cartesian3.clone(E,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(b,scratch2Array[1]),P=subdivideHeights(scratch2Array,w+d,M+d,s),D=PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:o}),f=addPositions(D,v,l,f,o,P,1),r&&(m=addPosition(b,v,u,m,o,M+d,1,1)),p=f.length;const I=r?p+m.length:p,R=new Float64Array(I);return R.set(f),r&&R.set(m,p),R};const CorridorGeometryLibrary={},scratch1$1=new Cartesian3,scratch2$1=new Cartesian3,scratch3=new Cartesian3,scratch4=new Cartesian3,scaleArray2=[new Cartesian3,new Cartesian3],cartesian1$2=new Cartesian3,cartesian2$2=new Cartesian3,cartesian3$2=new Cartesian3,cartesian4$1=new Cartesian3,cartesian5$1=new Cartesian3,cartesian6$1=new Cartesian3,cartesian7=new Cartesian3,cartesian8=new Cartesian3,cartesian9=new Cartesian3,cartesian10=new Cartesian3,quaterion=new Quaternion,rotMatrix=new Matrix3;function computeRoundCorner(e,t,n,i,r){const o=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$1),Cartesian3.subtract(n,e,scratch2$1)),a=i===CornerType$1.BEVELED?1:Math.ceil(o/CesiumMath.toRadians(5))+1,s=3*a,c=new Array(s);let l;c[s-3]=n.x,c[s-2]=n.y,c[s-1]=n.z,l=r?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$1),o/a,quaterion),rotMatrix):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,o/a,quaterion),rotMatrix);let u=0;t=Cartesian3.clone(t,scratch1$1);for(let e=0;e<a;e++)t=Matrix3.multiplyByVector(l,t,t),c[u++]=t.x,c[u++]=t.y,c[u++]=t.z;return c}function addEndCaps(e){let t=cartesian1$2,n=cartesian2$2,i=cartesian3$2,r=e[1];n=Cartesian3.fromArray(e[1],r.length-3,n),i=Cartesian3.fromArray(e[0],0,i),t=Cartesian3.midpoint(n,i,t);const o=computeRoundCorner(t,n,i,CornerType$1.ROUNDED,!1),a=e.length-1,s=e[a-1];r=e[a],n=Cartesian3.fromArray(s,s.length-3,n),i=Cartesian3.fromArray(r,0,i),t=Cartesian3.midpoint(n,i,t);return[o,computeRoundCorner(t,n,i,CornerType$1.ROUNDED,!1)]}function computeMiteredCorner(e,t,n,i){let r=scratch1$1;return i||(t=Cartesian3.negate(t,t)),r=Cartesian3.add(e,t,r),[r.x,r.y,r.z,n.x,n.y,n.z]}function addShiftedPositions(e,t,n,i){const r=new Array(e.length),o=new Array(e.length),a=Cartesian3.multiplyByScalar(t,n,scratch1$1),s=Cartesian3.negate(a,scratch2$1);let c=0,l=e.length-1;for(let t=0;t<e.length;t+=3){const n=Cartesian3.fromArray(e,t,scratch3),i=Cartesian3.add(n,s,scratch4);r[c++]=i.x,r[c++]=i.y,r[c++]=i.z;const u=Cartesian3.add(n,a,scratch4);o[l--]=u.z,o[l--]=u.y,o[l--]=u.x}return i.push(r,o),i}CorridorGeometryLibrary.addAttribute=function(e,t,n,i){const r=t.x,o=t.y,a=t.z;defined(n)&&(e[n]=r,e[n+1]=o,e[n+2]=a),defined(i)&&(e[i]=a,e[i-1]=o,e[i-2]=r)};const scratchForwardProjection=new Cartesian3,scratchBackwardProjection=new Cartesian3;CorridorGeometryLibrary.computePositions=function(e){const t=e.granularity,n=e.positions,i=e.ellipsoid,r=e.width/2,o=e.cornerType,a=e.saveAttributes;let s=cartesian1$2,c=cartesian2$2,l=cartesian3$2,u=cartesian4$1,d=cartesian5$1,h=cartesian6$1,p=cartesian7,f=cartesian8,m=cartesian9,g=cartesian10,_=[];const y=a?[]:void 0,C=a?[]:void 0;let T,S=n[0],A=n[1];c=Cartesian3.normalize(Cartesian3.subtract(A,S,c),c),s=i.geodeticSurfaceNormal(S,s),u=Cartesian3.normalize(Cartesian3.cross(s,c,u),u),a&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),p=Cartesian3.clone(S,p),S=A,l=Cartesian3.negate(c,l);const v=[];let E;const b=n.length;for(E=1;E<b-1;E++){s=i.geodeticSurfaceNormal(S,s),A=n[E+1],c=Cartesian3.normalize(Cartesian3.subtract(A,S,c),c),d=Cartesian3.normalize(Cartesian3.add(c,l,d),d);const e=Cartesian3.multiplyByScalar(s,Cartesian3.dot(c,s),scratchForwardProjection);Cartesian3.subtract(c,e,e),Cartesian3.normalize(e,e);const b=Cartesian3.multiplyByScalar(s,Cartesian3.dot(l,s),scratchBackwardProjection);Cartesian3.subtract(l,b,b),Cartesian3.normalize(b,b);if(!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(e,b)),1,CesiumMath.EPSILON7)){d=Cartesian3.cross(d,s,d),d=Cartesian3.cross(s,d,d),d=Cartesian3.normalize(d,d);const e=r/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(d,l,scratch1$1))),n=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(c,l,S,i);d=Cartesian3.multiplyByScalar(d,e,d),n?(f=Cartesian3.add(S,d,f),g=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,r,g),g),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*r,m),m),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),T=PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:i}),_=addShiftedPositions(T,u,r,_),a&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(m,h),u=Cartesian3.normalize(Cartesian3.cross(s,c,u),u),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*r,m),m),p=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,r,p),p),o===CornerType$1.ROUNDED||o===CornerType$1.BEVELED?v.push({leftPositions:computeRoundCorner(f,h,m,o,n)}):v.push({leftPositions:computeMiteredCorner(S,Cartesian3.negate(d,d),m,n)})):(m=Cartesian3.add(S,d,m),g=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,r,g),g),g),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*r,f),f),f),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),T=PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:i}),_=addShiftedPositions(T,u,r,_),a&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(f,h),u=Cartesian3.normalize(Cartesian3.cross(s,c,u),u),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*r,f),f),f),p=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,r,p),p),p),o===CornerType$1.ROUNDED||o===CornerType$1.BEVELED?v.push({rightPositions:computeRoundCorner(m,h,f,o,n)}):v.push({rightPositions:computeMiteredCorner(S,d,f,n)})),l=Cartesian3.negate(c,l)}S=A}let x;return s=i.geodeticSurfaceNormal(S,s),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(S,scaleArray2[1]),T=PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:i}),_=addShiftedPositions(T,u,r,_),a&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),o===CornerType$1.ROUNDED&&(x=addEndCaps(_)),{positions:_,corners:v,lefts:y,normals:C,endPositions:x}};const cartesian1$1=new Cartesian3,cartesian2$1=new Cartesian3,cartesian3$1=new Cartesian3,cartesian4=new Cartesian3,cartesian5=new Cartesian3,cartesian6=new Cartesian3,scratch1=new Cartesian3,scratch2=new Cartesian3;function scaleToSurface$1(e,t){for(let n=0;n<e.length;n++)e[n]=t.scaleToGeodeticSurface(e[n],e[n]);return e}function addNormals(e,t,n,i,r,o){const a=e.normals,s=e.tangents,c=e.bitangents,l=Cartesian3.normalize(Cartesian3.cross(n,t,scratch1),scratch1);o.normal&&CorridorGeometryLibrary.addAttribute(a,t,i,r),o.tangent&&CorridorGeometryLibrary.addAttribute(s,l,i,r),o.bitangent&&CorridorGeometryLibrary.addAttribute(c,n,i,r)}function combine$1(e,t,n){const i=e.positions,r=e.corners,o=e.endPositions,a=e.lefts,s=e.normals,c=new GeometryAttributes;let l,u,d,h=0,p=0,f=0;for(u=0;u<i.length;u+=2)d=i[u].length-3,h+=d,f+=2*d,p+=i[u+1].length-3;for(h+=3,p+=3,u=0;u<r.length;u++){l=r[u];const e=r[u].leftPositions;defined(e)?(d=e.length,h+=d,f+=d):(d=r[u].rightPositions.length,p+=d,f+=d)}const m=defined(o);let g;m&&(g=o[0].length-3,h+=g,p+=g,g/=3,f+=6*g);const _=h+p,y=new Float64Array(_),C={normals:t.normal?new Float32Array(_):void 0,tangents:t.tangent?new Float32Array(_):void 0,bitangents:t.bitangent?new Float32Array(_):void 0};let T,S,A,v,E,b,x=0,P=_-1,D=cartesian1$1,w=cartesian2$1;const M=g/2,I=IndexDatatype$1.createTypedArray(_/3,f);let R=0;if(m){b=cartesian3$1,E=cartesian4;const e=o[0];for(D=Cartesian3.fromArray(s,0,D),w=Cartesian3.fromArray(a,0,w),u=0;u<M;u++)b=Cartesian3.fromArray(e,3*(M-1-u),b),E=Cartesian3.fromArray(e,3*(M+u),E),CorridorGeometryLibrary.addAttribute(y,E,x),CorridorGeometryLibrary.addAttribute(y,b,void 0,P),addNormals(C,D,w,x,P,t),S=x/3,v=S+1,T=(P-2)/3,A=T-1,I[R++]=T,I[R++]=S,I[R++]=A,I[R++]=A,I[R++]=S,I[R++]=v,x+=3,P-=3}let O,B,L=0,F=0,N=i[L++],V=i[L++];for(y.set(N,x),y.set(V,P-V.length+1),w=Cartesian3.fromArray(a,F,w),d=V.length-3,u=0;u<d;u+=3)O=n.geodeticSurfaceNormal(Cartesian3.fromArray(N,u,scratch1),scratch1),B=n.geodeticSurfaceNormal(Cartesian3.fromArray(V,d-u,scratch2),scratch2),D=Cartesian3.normalize(Cartesian3.add(O,B,D),D),addNormals(C,D,w,x,P,t),S=x/3,v=S+1,T=(P-2)/3,A=T-1,I[R++]=T,I[R++]=S,I[R++]=A,I[R++]=A,I[R++]=S,I[R++]=v,x+=3,P-=3;for(O=n.geodeticSurfaceNormal(Cartesian3.fromArray(N,d,scratch1),scratch1),B=n.geodeticSurfaceNormal(Cartesian3.fromArray(V,d,scratch2),scratch2),D=Cartesian3.normalize(Cartesian3.add(O,B,D),D),F+=3,u=0;u<r.length;u++){let e;l=r[u];const o=l.leftPositions,c=l.rightPositions;let h,p,f=cartesian6,m=cartesian3$1,g=cartesian4;if(D=Cartesian3.fromArray(s,F,D),defined(o)){for(addNormals(C,D,w,void 0,P,t),P-=3,h=v,p=A,e=0;e<o.length/3;e++)f=Cartesian3.fromArray(o,3*e,f),I[R++]=h,I[R++]=p-e-1,I[R++]=p-e,CorridorGeometryLibrary.addAttribute(y,f,void 0,P),m=Cartesian3.fromArray(y,3*(p-e-1),m),g=Cartesian3.fromArray(y,3*h,g),w=Cartesian3.normalize(Cartesian3.subtract(m,g,w),w),addNormals(C,D,w,void 0,P,t),P-=3;f=Cartesian3.fromArray(y,3*h,f),m=Cartesian3.subtract(Cartesian3.fromArray(y,3*p,m),f,m),g=Cartesian3.subtract(Cartesian3.fromArray(y,3*(p-e),g),f,g),w=Cartesian3.normalize(Cartesian3.add(m,g,w),w),addNormals(C,D,w,x,void 0,t),x+=3}else{for(addNormals(C,D,w,x,void 0,t),x+=3,h=A,p=v,e=0;e<c.length/3;e++)f=Cartesian3.fromArray(c,3*e,f),I[R++]=h,I[R++]=p+e,I[R++]=p+e+1,CorridorGeometryLibrary.addAttribute(y,f,x),m=Cartesian3.fromArray(y,3*h,m),g=Cartesian3.fromArray(y,3*(p+e),g),w=Cartesian3.normalize(Cartesian3.subtract(m,g,w),w),addNormals(C,D,w,x,void 0,t),x+=3;f=Cartesian3.fromArray(y,3*h,f),m=Cartesian3.subtract(Cartesian3.fromArray(y,3*(p+e),m),f,m),g=Cartesian3.subtract(Cartesian3.fromArray(y,3*p,g),f,g),w=Cartesian3.normalize(Cartesian3.negate(Cartesian3.add(g,m,w),w),w),addNormals(C,D,w,void 0,P,t),P-=3}for(N=i[L++],V=i[L++],N.splice(0,3),V.splice(V.length-3,3),y.set(N,x),y.set(V,P-V.length+1),d=V.length-3,F+=3,w=Cartesian3.fromArray(a,F,w),e=0;e<V.length;e+=3)O=n.geodeticSurfaceNormal(Cartesian3.fromArray(N,e,scratch1),scratch1),B=n.geodeticSurfaceNormal(Cartesian3.fromArray(V,d-e,scratch2),scratch2),D=Cartesian3.normalize(Cartesian3.add(O,B,D),D),addNormals(C,D,w,x,P,t),v=x/3,S=v-1,A=(P-2)/3,T=A+1,I[R++]=T,I[R++]=S,I[R++]=A,I[R++]=A,I[R++]=S,I[R++]=v,x+=3,P-=3;x-=3,P+=3}if(D=Cartesian3.fromArray(s,s.length-3,D),addNormals(C,D,w,x,P,t),m){x+=3,P-=3,b=cartesian3$1,E=cartesian4;const e=o[1];for(u=0;u<M;u++)b=Cartesian3.fromArray(e,3*(g-u-1),b),E=Cartesian3.fromArray(e,3*u,E),CorridorGeometryLibrary.addAttribute(y,b,void 0,P),CorridorGeometryLibrary.addAttribute(y,E,x),addNormals(C,D,w,x,P,t),v=x/3,S=v-1,A=(P-2)/3,T=A+1,I[R++]=T,I[R++]=S,I[R++]=A,I[R++]=A,I[R++]=S,I[R++]=v,x+=3,P-=3}if(c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:y}),t.st){const e=new Float32Array(_/3*2);let t,n,i=0;if(m){h/=3,p/=3;const r=Math.PI/(g+1);let o;n=1/(h-g+1),t=1/(p-g+1);const a=g/2;for(u=a+1;u<g+1;u++)o=CesiumMath.PI_OVER_TWO+r*u,e[i++]=t*(1+Math.cos(o)),e[i++]=.5*(1+Math.sin(o));for(u=1;u<p-g+1;u++)e[i++]=u*t,e[i++]=0;for(u=g;u>a;u--)o=CesiumMath.PI_OVER_TWO-u*r,e[i++]=1-t*(1+Math.cos(o)),e[i++]=.5*(1+Math.sin(o));for(u=a;u>0;u--)o=CesiumMath.PI_OVER_TWO-r*u,e[i++]=1-n*(1+Math.cos(o)),e[i++]=.5*(1+Math.sin(o));for(u=h-g;u>0;u--)e[i++]=u*n,e[i++]=1;for(u=1;u<a+1;u++)o=CesiumMath.PI_OVER_TWO+r*u,e[i++]=n*(1+Math.cos(o)),e[i++]=.5*(1+Math.sin(o))}else{for(h/=3,p/=3,n=1/(h-1),t=1/(p-1),u=0;u<p;u++)e[i++]=u*t,e[i++]=0;for(u=h;u>0;u--)e[i++]=(u-1)*n,e[i++]=1}c.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:e})}return t.normal&&(c.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C.normals})),t.tangent&&(c.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C.tangents})),t.bitangent&&(c.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C.bitangents})),{attributes:c,indices:I}}function extrudedAttributes(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;const n=e.position.values;let i,r;(t.normal||t.bitangent)&&(i=e.normal.values,r=e.bitangent.values);const o=e.position.values.length/18,a=3*o,s=2*o,c=2*a;let l;if(t.normal||t.bitangent||t.tangent){const o=t.normal?new Float32Array(6*a):void 0,s=t.tangent?new Float32Array(6*a):void 0,u=t.bitangent?new Float32Array(6*a):void 0;let d=cartesian1$1,h=cartesian2$1,p=cartesian3$1,f=cartesian4,m=cartesian5,g=cartesian6,_=c;for(l=0;l<a;l+=3){const e=_+c;d=Cartesian3.fromArray(n,l,d),h=Cartesian3.fromArray(n,l+a,h),p=Cartesian3.fromArray(n,(l+3)%a,p),h=Cartesian3.subtract(h,d,h),p=Cartesian3.subtract(p,d,p),f=Cartesian3.normalize(Cartesian3.cross(h,p,f),f),t.normal&&(CorridorGeometryLibrary.addAttribute(o,f,e),CorridorGeometryLibrary.addAttribute(o,f,e+3),CorridorGeometryLibrary.addAttribute(o,f,_),CorridorGeometryLibrary.addAttribute(o,f,_+3)),(t.tangent||t.bitangent)&&(g=Cartesian3.fromArray(i,l,g),t.bitangent&&(CorridorGeometryLibrary.addAttribute(u,g,e),CorridorGeometryLibrary.addAttribute(u,g,e+3),CorridorGeometryLibrary.addAttribute(u,g,_),CorridorGeometryLibrary.addAttribute(u,g,_+3)),t.tangent&&(m=Cartesian3.normalize(Cartesian3.cross(g,f,m),m),CorridorGeometryLibrary.addAttribute(s,m,e),CorridorGeometryLibrary.addAttribute(s,m,e+3),CorridorGeometryLibrary.addAttribute(s,m,_),CorridorGeometryLibrary.addAttribute(s,m,_+3))),_+=6}if(t.normal){for(o.set(i),l=0;l<a;l+=3)o[l+a]=-i[l],o[l+a+1]=-i[l+1],o[l+a+2]=-i[l+2];e.normal.values=o}else e.normal=void 0;if(t.bitangent?(u.set(r),u.set(r,a),e.bitangent.values=u):e.bitangent=void 0,t.tangent){const t=e.tangent.values;s.set(t),s.set(t,a),e.tangent.values=s}}if(t.st){const t=e.st.values,n=new Float32Array(6*s);n.set(t),n.set(t,s);let i=2*s;for(let e=0;e<2;e++){for(n[i++]=t[0],n[i++]=t[1],l=2;l<s;l+=2){const e=t[l],r=t[l+1];n[i++]=e,n[i++]=r,n[i++]=e,n[i++]=r}n[i++]=t[0],n[i++]=t[1]}e.st.values=n}return e}function addWallPositions$1(e,t,n){n[t++]=e[0],n[t++]=e[1],n[t++]=e[2];for(let i=3;i<e.length;i+=3){const r=e[i],o=e[i+1],a=e[i+2];n[t++]=r,n[t++]=o,n[t++]=a,n[t++]=r,n[t++]=o,n[t++]=a}return n[t++]=e[0],n[t++]=e[1],n[t++]=e[2],n}function computePositionsExtruded$1(e,t){const n=new VertexFormat({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),i=e.ellipsoid,r=combine$1(CorridorGeometryLibrary.computePositions(e),n,i),o=e.height,a=e.extrudedHeight;let s=r.attributes;const c=r.indices;let l=s.position.values,u=l.length;const d=new Float64Array(6*u);let h=new Float64Array(u);h.set(l);let p,f=new Float64Array(4*u);l=PolygonPipeline.scaleToGeodeticHeight(l,o,i),f=addWallPositions$1(l,0,f),h=PolygonPipeline.scaleToGeodeticHeight(h,a,i),f=addWallPositions$1(h,2*u,f),d.set(l),d.set(h,u),d.set(f,2*u),s.position.values=d,s=extrudedAttributes(s,t);const m=u/3;if(e.shadowVolume){const e=s.normal.values;u=e.length;let n=new Float32Array(6*u);for(p=0;p<u;p++)e[p]=-e[p];n.set(e,u),n=addWallPositions$1(e,4*u,n),s.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n}),t.normal||(s.normal=void 0)}if(defined(e.offsetAttribute)){let t=new Uint8Array(6*m);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)t=arrayFill(t,1,0,m),t=arrayFill(t,1,2*m,4*m);else{t=arrayFill(t,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}const g=c.length,_=m+m,y=IndexDatatype$1.createTypedArray(d.length/3,2*g+3*_);y.set(c);let C,T,S,A,v=g;for(p=0;p<g;p+=3){const e=c[p],t=c[p+1],n=c[p+2];y[v++]=n+m,y[v++]=t+m,y[v++]=e+m}for(p=0;p<_;p+=2)C=p+_,T=C+_,S=C+1,A=T+1,y[v++]=C,y[v++]=T,y[v++]=S,y[v++]=S,y[v++]=T,y[v++]=A;return{attributes:s,indices:y}}const scratchCartesian1$2=new Cartesian3,scratchCartesian2$5=new Cartesian3,scratchCartographic$e=new Cartographic;function computeOffsetPoints(e,t,n,i,r,o){const a=Cartesian3.subtract(t,e,scratchCartesian1$2);Cartesian3.normalize(a,a);const s=n.geodeticSurfaceNormal(e,scratchCartesian2$5),c=Cartesian3.cross(a,s,scratchCartesian1$2);Cartesian3.multiplyByScalar(c,i,c);let l=r.latitude,u=r.longitude,d=o.latitude,h=o.longitude;Cartesian3.add(e,c,scratchCartesian2$5),n.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e);let p=scratchCartographic$e.latitude,f=scratchCartographic$e.longitude;l=Math.min(l,p),u=Math.min(u,f),d=Math.max(d,p),h=Math.max(h,f),Cartesian3.subtract(e,c,scratchCartesian2$5),n.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e),p=scratchCartographic$e.latitude,f=scratchCartographic$e.longitude,l=Math.min(l,p),u=Math.min(u,f),d=Math.max(d,p),h=Math.max(h,f),r.latitude=l,r.longitude=u,o.latitude=d,o.longitude=h}const scratchCartesianOffset=new Cartesian3,scratchCartesianEnds=new Cartesian3,scratchCartographicMin=new Cartographic,scratchCartographicMax=new Cartographic;function computeRectangle$2(e,t,n,i,r){const o=arrayRemoveDuplicates(e=scaleToSurface$1(e,t),Cartesian3.equalsEpsilon),a=o.length;if(a<2||n<=0)return new Rectangle;const s=.5*n;let c,l;if(scratchCartographicMin.latitude=Number.POSITIVE_INFINITY,scratchCartographicMin.longitude=Number.POSITIVE_INFINITY,scratchCartographicMax.latitude=Number.NEGATIVE_INFINITY,scratchCartographicMax.longitude=Number.NEGATIVE_INFINITY,i===CornerType$1.ROUNDED){const e=o[0];Cartesian3.subtract(e,o[1],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,s,scratchCartesianOffset),Cartesian3.add(e,scratchCartesianOffset,scratchCartesianEnds),t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),c=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,c),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,c),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l)}for(let e=0;e<a-1;++e)computeOffsetPoints(o[e],o[e+1],t,s,scratchCartographicMin,scratchCartographicMax);const u=o[a-1];Cartesian3.subtract(u,o[a-2],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,s,scratchCartesianOffset),Cartesian3.add(u,scratchCartesianOffset,scratchCartesianEnds),computeOffsetPoints(u,scratchCartesianEnds,t,s,scratchCartographicMin,scratchCartographicMax),i===CornerType$1.ROUNDED&&(t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),c=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,c),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,c),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));const d=defined(r)?r:new Rectangle;return d.north=scratchCartographicMax.latitude,d.south=scratchCartographicMin.latitude,d.east=scratchCartographicMax.longitude,d.west=scratchCartographicMin.longitude,d}function CorridorGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.width,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._width=n,this._height=Math.max(i,r),this._extrudedHeight=Math.min(i,r),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7}CorridorGeometry.pack=function(e,t,n){n=defaultValue(n,0);const i=e._positions,r=i.length;t[n++]=r;for(let e=0;e<r;++e,n+=Cartesian3.packedLength)Cartesian3.pack(i[e],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._width,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._cornerType,t[n++]=e._granularity,t[n++]=e._shadowVolume?1:0,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchEllipsoid$b=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$9=new VertexFormat,scratchOptions$f={positions:void 0,ellipsoid:scratchEllipsoid$b,vertexFormat:scratchVertexFormat$9,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};CorridorGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=e[t++],r=new Array(i);for(let n=0;n<i;++n,t+=Cartesian3.packedLength)r[n]=Cartesian3.unpack(e,t);const o=Ellipsoid.unpack(e,t,scratchEllipsoid$b);t+=Ellipsoid.packedLength;const a=VertexFormat.unpack(e,t,scratchVertexFormat$9);t+=VertexFormat.packedLength;const s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t++],h=1===e[t++],p=e[t];return defined(n)?(n._positions=r,n._ellipsoid=Ellipsoid.clone(o,n._ellipsoid),n._vertexFormat=VertexFormat.clone(a,n._vertexFormat),n._width=s,n._height=c,n._extrudedHeight=l,n._cornerType=u,n._granularity=d,n._shadowVolume=h,n._offsetAttribute=-1===p?void 0:p,n):(scratchOptions$f.positions=r,scratchOptions$f.width=s,scratchOptions$f.height=c,scratchOptions$f.extrudedHeight=l,scratchOptions$f.cornerType=u,scratchOptions$f.granularity=d,scratchOptions$f.shadowVolume=h,scratchOptions$f.offsetAttribute=-1===p?void 0:p,new CorridorGeometry(scratchOptions$f))},CorridorGeometry.computeRectangle=function(e,t){const n=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width;return computeRectangle$2(n,defaultValue(e.ellipsoid,Ellipsoid.WGS84),i,defaultValue(e.cornerType,CornerType$1.ROUNDED),t)},CorridorGeometry.createGeometry=function(e){let t=e._positions;const n=e._width,i=e._ellipsoid;t=scaleToSurface$1(t,i);const r=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon);if(r.length<2||n<=0)return;const o=e._height,a=e._extrudedHeight,s=!CesiumMath.equalsEpsilon(o,a,0,CesiumMath.EPSILON2),c=e._vertexFormat,l={ellipsoid:i,positions:r,width:n,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};let u;if(s)l.height=o,l.extrudedHeight=a,l.shadowVolume=e._shadowVolume,l.offsetAttribute=e._offsetAttribute,u=computePositionsExtruded$1(l,c);else{if(u=combine$1(CorridorGeometryLibrary.computePositions(l),c,i),u.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,o,i),defined(e._offsetAttribute)){const t=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,n=u.attributes.position.values.length,i=new Uint8Array(n/3);arrayFill(i,t),u.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}}const d=u.attributes,h=BoundingSphere.fromVertices(d.position.values,void 0,3);return c.position||(u.attributes.position.values=void 0),new Geometry({attributes:d,indices:u.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:h,offsetAttribute:e._offsetAttribute})},CorridorGeometry.createShadowVolume=function(e,t,n){const i=e._granularity,r=e._ellipsoid,o=t(i,r),a=n(i,r);return new CorridorGeometry({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:r,granularity:i,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CorridorGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$2(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});const cartesian1=new Cartesian3,cartesian2=new Cartesian3,cartesian3=new Cartesian3;function scaleToSurface(e,t){for(let n=0;n<e.length;n++)e[n]=t.scaleToGeodeticSurface(e[n],e[n]);return e}function combine(e,t){const n=[],i=e.positions,r=e.corners,o=e.endPositions,a=new GeometryAttributes;let s,c,l,u=0,d=0,h=0;for(c=0;c<i.length;c+=2)l=i[c].length-3,u+=l,h+=l/3*4,d+=i[c+1].length-3;for(u+=3,d+=3,c=0;c<r.length;c++){s=r[c];const e=r[c].leftPositions;defined(e)?(l=e.length,u+=l,h+=l/3*2):(l=r[c].rightPositions.length,d+=l,h+=l/3*2)}const p=defined(o);let f;p&&(f=o[0].length-3,u+=f,d+=f,f/=3,h+=4*f);const m=u+d,g=new Float64Array(m);let _,y,C,T,S,A,v=0,E=m-1;const b=f/2,x=IndexDatatype$1.createTypedArray(m/3,h+4);let P=0;if(x[P++]=v/3,x[P++]=(E-2)/3,p){n.push(v/3),A=cartesian1,S=cartesian2;const e=o[0];for(c=0;c<b;c++)A=Cartesian3.fromArray(e,3*(b-1-c),A),S=Cartesian3.fromArray(e,3*(b+c),S),CorridorGeometryLibrary.addAttribute(g,S,v),CorridorGeometryLibrary.addAttribute(g,A,void 0,E),y=v/3,T=y+1,_=(E-2)/3,C=_-1,x[P++]=_,x[P++]=C,x[P++]=y,x[P++]=T,v+=3,E-=3}let D=0,w=i[D++],M=i[D++];for(g.set(w,v),g.set(M,E-M.length+1),l=M.length-3,n.push(v/3,(E-2)/3),c=0;c<l;c+=3)y=v/3,T=y+1,_=(E-2)/3,C=_-1,x[P++]=_,x[P++]=C,x[P++]=y,x[P++]=T,v+=3,E-=3;for(c=0;c<r.length;c++){let e;s=r[c];const o=s.leftPositions,a=s.rightPositions;let u,d=cartesian3;if(defined(o)){for(E-=3,u=C,n.push(T),e=0;e<o.length/3;e++)d=Cartesian3.fromArray(o,3*e,d),x[P++]=u-e-1,x[P++]=u-e,CorridorGeometryLibrary.addAttribute(g,d,void 0,E),E-=3;n.push(u-Math.floor(o.length/6)),t===CornerType$1.BEVELED&&n.push((E-2)/3+1),v+=3}else{for(v+=3,u=T,n.push(C),e=0;e<a.length/3;e++)d=Cartesian3.fromArray(a,3*e,d),x[P++]=u+e,x[P++]=u+e+1,CorridorGeometryLibrary.addAttribute(g,d,v),v+=3;n.push(u+Math.floor(a.length/6)),t===CornerType$1.BEVELED&&n.push(v/3-1),E-=3}for(w=i[D++],M=i[D++],w.splice(0,3),M.splice(M.length-3,3),g.set(w,v),g.set(M,E-M.length+1),l=M.length-3,e=0;e<M.length;e+=3)T=v/3,y=T-1,C=(E-2)/3,_=C+1,x[P++]=_,x[P++]=C,x[P++]=y,x[P++]=T,v+=3,E-=3;v-=3,E+=3,n.push(v/3,(E-2)/3)}if(p){v+=3,E-=3,A=cartesian1,S=cartesian2;const e=o[1];for(c=0;c<b;c++)A=Cartesian3.fromArray(e,3*(f-c-1),A),S=Cartesian3.fromArray(e,3*c,S),CorridorGeometryLibrary.addAttribute(g,A,void 0,E),CorridorGeometryLibrary.addAttribute(g,S,v),T=v/3,y=T-1,C=(E-2)/3,_=C+1,x[P++]=_,x[P++]=C,x[P++]=y,x[P++]=T,v+=3,E-=3;n.push(v/3)}else n.push(v/3,(E-2)/3);return x[P++]=v/3,x[P++]=(E-2)/3,a.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:g}),{attributes:a,indices:x,wallIndices:n}}function computePositionsExtruded(e){const t=e.ellipsoid,n=combine(CorridorGeometryLibrary.computePositions(e),e.cornerType),i=n.wallIndices,r=e.height,o=e.extrudedHeight,a=n.attributes,s=n.indices;let c=a.position.values,l=c.length,u=new Float64Array(l);u.set(c);const d=new Float64Array(2*l);if(c=PolygonPipeline.scaleToGeodeticHeight(c,r,t),u=PolygonPipeline.scaleToGeodeticHeight(u,o,t),d.set(c),d.set(u,l),a.position.values=d,l/=3,defined(e.offsetAttribute)){let t=new Uint8Array(2*l);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)t=arrayFill(t,1,0,l);else{t=arrayFill(t,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}a.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}let h;const p=s.length,f=IndexDatatype$1.createTypedArray(d.length/3,2*(p+i.length));f.set(s);let m,g,_=p;for(h=0;h<p;h+=2){const e=s[h],t=s[h+1];f[_++]=e+l,f[_++]=t+l}for(h=0;h<i.length;h++)m=i[h],g=m+l,f[_++]=m,f[_++]=g;return{attributes:a,indices:f}}function CorridorOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.width,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._width=n,this._height=Math.max(i,r),this._extrudedHeight=Math.min(i,r),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._offsetAttribute=e.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+6}CorridorOutlineGeometry.pack=function(e,t,n){n=defaultValue(n,0);const i=e._positions,r=i.length;t[n++]=r;for(let e=0;e<r;++e,n+=Cartesian3.packedLength)Cartesian3.pack(i[e],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._width,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._cornerType,t[n++]=e._granularity,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchEllipsoid$a=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$e={positions:void 0,ellipsoid:scratchEllipsoid$a,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};function CullingVolume(e){this.planes=defaultValue(e,[])}CorridorOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=e[t++],r=new Array(i);for(let n=0;n<i;++n,t+=Cartesian3.packedLength)r[n]=Cartesian3.unpack(e,t);const o=Ellipsoid.unpack(e,t,scratchEllipsoid$a);t+=Ellipsoid.packedLength;const a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t];return defined(n)?(n._positions=r,n._ellipsoid=Ellipsoid.clone(o,n._ellipsoid),n._width=a,n._height=s,n._extrudedHeight=c,n._cornerType=l,n._granularity=u,n._offsetAttribute=-1===d?void 0:d,n):(scratchOptions$e.positions=r,scratchOptions$e.width=a,scratchOptions$e.height=s,scratchOptions$e.extrudedHeight=c,scratchOptions$e.cornerType=l,scratchOptions$e.granularity=u,scratchOptions$e.offsetAttribute=-1===d?void 0:d,new CorridorOutlineGeometry(scratchOptions$e))},CorridorOutlineGeometry.createGeometry=function(e){let t=e._positions;const n=e._width,i=e._ellipsoid;t=scaleToSurface(t,i);const r=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon);if(r.length<2||n<=0)return;const o=e._height,a=e._extrudedHeight,s=!CesiumMath.equalsEpsilon(o,a,0,CesiumMath.EPSILON2),c={ellipsoid:i,positions:r,width:n,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};let l;if(s)c.height=o,c.extrudedHeight=a,c.offsetAttribute=e._offsetAttribute,l=computePositionsExtruded(c);else{if(l=combine(CorridorGeometryLibrary.computePositions(c),c.cornerType),l.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(l.attributes.position.values,o,i),defined(e._offsetAttribute)){const t=l.attributes.position.values.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),l.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}}const u=l.attributes,d=BoundingSphere.fromVertices(u.position.values,void 0,3);return new Geometry({attributes:u,indices:l.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:d,offsetAttribute:e._offsetAttribute})};const faces=[new Cartesian3,new Cartesian3,new Cartesian3];Cartesian3.clone(Cartesian3.UNIT_X,faces[0]),Cartesian3.clone(Cartesian3.UNIT_Y,faces[1]),Cartesian3.clone(Cartesian3.UNIT_Z,faces[2]);const scratchPlaneCenter=new Cartesian3,scratchPlaneNormal=new Cartesian3,scratchPlane$1=new Plane(new Cartesian3(1,0,0),0);function CustomHeightmapTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._callback=e.callback,this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._width=e.width,this._height=e.height;const t=Math.max(this._width,this._height);this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,t,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event;let n=e.credit;"string"==typeof n&&(n=new Credit(n)),this._credit=n,this._readyPromise=when.resolve(!0)}CullingVolume.fromBoundingSphere=function(e,t){defined(t)||(t=new CullingVolume);const n=faces.length,i=t.planes;i.length=2*n;const r=e.center,o=e.radius;let a=0;for(let e=0;e<n;++e){const t=faces[e];let n=i[a],s=i[a+1];defined(n)||(n=i[a]=new Cartesian4),defined(s)||(s=i[a+1]=new Cartesian4),Cartesian3.multiplyByScalar(t,-o,scratchPlaneCenter),Cartesian3.add(r,scratchPlaneCenter,scratchPlaneCenter),n.x=t.x,n.y=t.y,n.z=t.z,n.w=-Cartesian3.dot(t,scratchPlaneCenter),Cartesian3.multiplyByScalar(t,o,scratchPlaneCenter),Cartesian3.add(r,scratchPlaneCenter,scratchPlaneCenter),s.x=-t.x,s.y=-t.y,s.z=-t.z,s.w=-Cartesian3.dot(Cartesian3.negate(t,scratchPlaneNormal),scratchPlaneCenter),a+=2}return t},CullingVolume.prototype.computeVisibility=function(e){const t=this.planes;let n=!1;for(let i=0,r=t.length;i<r;++i){const r=e.intersectPlane(Plane.fromCartesian4(t[i],scratchPlane$1));if(r===Intersect$1.OUTSIDE)return Intersect$1.OUTSIDE;r===Intersect$1.INTERSECTING&&(n=!0)}return n?Intersect$1.INTERSECTING:Intersect$1.INSIDE},CullingVolume.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===CullingVolume.MASK_OUTSIDE||t===CullingVolume.MASK_INSIDE)return t;let n=CullingVolume.MASK_INSIDE;const i=this.planes;for(let r=0,o=i.length;r<o;++r){const o=r<31?1<<r:0;if(r<31&&0==(t&o))continue;const a=e.intersectPlane(Plane.fromCartesian4(i[r],scratchPlane$1));if(a===Intersect$1.OUTSIDE)return CullingVolume.MASK_OUTSIDE;a===Intersect$1.INTERSECTING&&(n|=o)}return n},CullingVolume.MASK_OUTSIDE=4294967295,CullingVolume.MASK_INSIDE=0,CullingVolume.MASK_INDETERMINATE=2147483647,Object.defineProperties(CustomHeightmapTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},width:{get:function(){return this._width}},height:{get:function(){return this._height}}}),CustomHeightmapTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){const r=this._callback(e,t,n);if(!defined(r))return;const o=this._width,a=this._height;return when(r).then((function(e){let t=e;return Array.isArray(t)&&(t=new Float64Array(t)),new HeightmapTerrainData({buffer:t,width:o,height:a})}))},CustomHeightmapTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CustomHeightmapTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){},CustomHeightmapTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){};const CylinderGeometryLibrary={computePositions:function(e,t,n,i,r){const o=.5*e,a=-o,s=i+i,c=new Float64Array(3*(r?2*s:s));let l,u=0,d=0;const h=r?3*s:0,p=r?3*(s+i):3*i;for(l=0;l<i;l++){const e=l/i*CesiumMath.TWO_PI,s=Math.cos(e),f=Math.sin(e),m=s*n,g=f*n,_=s*t,y=f*t;c[d+h]=m,c[d+h+1]=g,c[d+h+2]=a,c[d+p]=_,c[d+p+1]=y,c[d+p+2]=o,d+=3,r&&(c[u++]=m,c[u++]=g,c[u++]=a,c[u++]=_,c[u++]=y,c[u++]=o)}return c}},radiusScratch$1=new Cartesian2,normalScratch$3=new Cartesian3,bitangentScratch$1=new Cartesian3,tangentScratch$1=new Cartesian3,positionScratch$b=new Cartesian3;function CylinderGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,n=e.topRadius,i=e.bottomRadius,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),o=defaultValue(e.slices,128);this._length=t,this._topRadius=n,this._bottomRadius=i,this._vertexFormat=VertexFormat.clone(r),this._slices=o,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}CylinderGeometry.packedLength=VertexFormat.packedLength+5,CylinderGeometry.pack=function(e,t,n){return n=defaultValue(n,0),VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._length,t[n++]=e._topRadius,t[n++]=e._bottomRadius,t[n++]=e._slices,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchVertexFormat$8=new VertexFormat,scratchOptions$d={vertexFormat:scratchVertexFormat$8,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0};let unitCylinderGeometry;CylinderGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=VertexFormat.unpack(e,t,scratchVertexFormat$8);t+=VertexFormat.packedLength;const r=e[t++],o=e[t++],a=e[t++],s=e[t++],c=e[t];return defined(n)?(n._vertexFormat=VertexFormat.clone(i,n._vertexFormat),n._length=r,n._topRadius=o,n._bottomRadius=a,n._slices=s,n._offsetAttribute=-1===c?void 0:c,n):(scratchOptions$d.length=r,scratchOptions$d.topRadius=o,scratchOptions$d.bottomRadius=a,scratchOptions$d.slices=s,scratchOptions$d.offsetAttribute=-1===c?void 0:c,new CylinderGeometry(scratchOptions$d))},CylinderGeometry.createGeometry=function(e){let t=e._length;const n=e._topRadius,i=e._bottomRadius,r=e._vertexFormat,o=e._slices;if(t<=0||n<0||i<0||0===n&&0===i)return;const a=o+o,s=o+a,c=a+a,l=CylinderGeometryLibrary.computePositions(t,n,i,o,!0),u=r.st?new Float32Array(2*c):void 0,d=r.normal?new Float32Array(3*c):void 0,h=r.tangent?new Float32Array(3*c):void 0,p=r.bitangent?new Float32Array(3*c):void 0;let f;const m=r.normal||r.tangent||r.bitangent;if(m){const e=r.tangent||r.bitangent;let a=0,s=0,c=0;const l=Math.atan2(i-n,t),u=normalScratch$3;u.z=Math.sin(l);const g=Math.cos(l);let _=tangentScratch$1,y=bitangentScratch$1;for(f=0;f<o;f++){const t=f/o*CesiumMath.TWO_PI,n=g*Math.cos(t),i=g*Math.sin(t);m&&(u.x=n,u.y=i,e&&(_=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,u,_),_)),r.normal&&(d[a++]=u.x,d[a++]=u.y,d[a++]=u.z,d[a++]=u.x,d[a++]=u.y,d[a++]=u.z),r.tangent&&(h[s++]=_.x,h[s++]=_.y,h[s++]=_.z,h[s++]=_.x,h[s++]=_.y,h[s++]=_.z),r.bitangent&&(y=Cartesian3.normalize(Cartesian3.cross(u,_,y),y),p[c++]=y.x,p[c++]=y.y,p[c++]=y.z,p[c++]=y.x,p[c++]=y.y,p[c++]=y.z))}for(f=0;f<o;f++)r.normal&&(d[a++]=0,d[a++]=0,d[a++]=-1),r.tangent&&(h[s++]=1,h[s++]=0,h[s++]=0),r.bitangent&&(p[c++]=0,p[c++]=-1,p[c++]=0);for(f=0;f<o;f++)r.normal&&(d[a++]=0,d[a++]=0,d[a++]=1),r.tangent&&(h[s++]=1,h[s++]=0,h[s++]=0),r.bitangent&&(p[c++]=0,p[c++]=1,p[c++]=0)}const g=12*o-12,_=IndexDatatype$1.createTypedArray(c,g);let y=0,C=0;for(f=0;f<o-1;f++)_[y++]=C,_[y++]=C+2,_[y++]=C+3,_[y++]=C,_[y++]=C+3,_[y++]=C+1,C+=2;for(_[y++]=a-2,_[y++]=0,_[y++]=1,_[y++]=a-2,_[y++]=1,_[y++]=a-1,f=1;f<o-1;f++)_[y++]=a+f+1,_[y++]=a+f,_[y++]=a;for(f=1;f<o-1;f++)_[y++]=s,_[y++]=s+f,_[y++]=s+f+1;let T=0;if(r.st){const e=Math.max(n,i);for(f=0;f<c;f++){const t=Cartesian3.fromArray(l,3*f,positionScratch$b);u[T++]=(t.x+e)/(2*e),u[T++]=(t.y+e)/(2*e)}}const S=new GeometryAttributes;r.position&&(S.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})),r.normal&&(S.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),r.tangent&&(S.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),r.bitangent&&(S.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),r.st&&(S.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:u})),radiusScratch$1.x=.5*t,radiusScratch$1.y=Math.max(i,n);const A=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch$1));if(defined(e._offsetAttribute)){t=l.length;const n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),S.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:S,indices:_,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:A,offsetAttribute:e._offsetAttribute})},CylinderGeometry.getUnitCylinder=function(){return defined(unitCylinderGeometry)||(unitCylinderGeometry=CylinderGeometry.createGeometry(new CylinderGeometry({topRadius:1,bottomRadius:1,length:1,vertexFormat:VertexFormat.POSITION_ONLY}))),unitCylinderGeometry};const radiusScratch=new Cartesian2;function CylinderOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,n=e.topRadius,i=e.bottomRadius,r=defaultValue(e.slices,128),o=Math.max(defaultValue(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=n,this._bottomRadius=i,this._slices=r,this._numberOfVerticalLines=o,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderOutlineGeometry"}CylinderOutlineGeometry.packedLength=6,CylinderOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e._length,t[n++]=e._topRadius,t[n++]=e._bottomRadius,t[n++]=e._slices,t[n++]=e._numberOfVerticalLines,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchOptions$c={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function DefaultProxy(e){this.proxy=e}function DistanceDisplayCondition(e,t){e=defaultValue(e,0),this._near=e,t=defaultValue(t,Number.MAX_VALUE),this._far=t}function DistanceDisplayConditionGeometryInstanceAttribute(e,t){e=defaultValue(e,0),t=defaultValue(t,Number.MAX_VALUE),this.value=new Float32Array([e,t])}function DoubleEndedPriorityQueue(e){this._comparator=e.comparator,this._maximumLength=e.maximumLength,this._array=defined(e.maximumLength)?new Array(e.maximumLength):[],this._length=0}function swap$2(e,t,n){const i=e._array,r=i[t];i[t]=i[n],i[n]=r}function lessThan(e,t,n){return e._comparator(e._array[t],e._array[n])<0}function greaterThan(e,t,n){return e._comparator(e._array[t],e._array[n])>0}function pushUp(e,t){if(0===t)return;const n=Math.floor(CesiumMath.log2(t+1))%2==0,i=Math.floor((t-1)/2),r=lessThan(e,t,i);for(r!==n&&(swap$2(e,t,i),t=i);t>=3;){const n=Math.floor((t-3)/4);if(lessThan(e,t,n)!==r)break;swap$2(e,t,n),t=n}}function pushDown(e,t){const n=e._length,i=Math.floor(CesiumMath.log2(t+1))%2==0;let r;for(;(r=2*t+1)<n;){let o=r;const a=r+1;if(a<n){lessThan(e,a,o)===i&&(o=a);const t=2*r+1,s=Math.max(Math.min(n-t,4),0);for(let n=0;n<s;n++){const r=t+n;lessThan(e,r,o)===i&&(o=r)}}if(lessThan(e,o,t)===i&&(swap$2(e,o,t),o!==r&&o!==a)){const t=Math.floor((o-1)/2);greaterThan(e,o,t)===i&&swap$2(e,o,t)}t=o}}function DoublyLinkedList(){this.head=void 0,this.tail=void 0,this._length=0}function DoublyLinkedListNode(e,t,n){this.item=e,this.previous=t,this.next=n}function remove$2(e,t){defined(t.previous)&&defined(t.next)?(t.previous.next=t.next,t.next.previous=t.previous):defined(t.previous)?(t.previous.next=void 0,e.tail=t.previous):defined(t.next)?(t.next.previous=void 0,e.head=t.next):(e.head=void 0,e.tail=void 0),t.next=void 0,t.previous=void 0}CylinderOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=e[t++],r=e[t++],o=e[t++],a=e[t++],s=e[t++],c=e[t];return defined(n)?(n._length=i,n._topRadius=r,n._bottomRadius=o,n._slices=a,n._numberOfVerticalLines=s,n._offsetAttribute=-1===c?void 0:c,n):(scratchOptions$c.length=i,scratchOptions$c.topRadius=r,scratchOptions$c.bottomRadius=o,scratchOptions$c.slices=a,scratchOptions$c.numberOfVerticalLines=s,scratchOptions$c.offsetAttribute=-1===c?void 0:c,new CylinderOutlineGeometry(scratchOptions$c))},CylinderOutlineGeometry.createGeometry=function(e){let t=e._length;const n=e._topRadius,i=e._bottomRadius,r=e._slices,o=e._numberOfVerticalLines;if(t<=0||n<0||i<0||0===n&&0===i)return;const a=2*r,s=CylinderGeometryLibrary.computePositions(t,n,i,r,!1);let c,l=2*r;if(o>0){const e=Math.min(o,r);c=Math.round(r/e),l+=e}const u=IndexDatatype$1.createTypedArray(a,2*l);let d,h=0;for(d=0;d<r-1;d++)u[h++]=d,u[h++]=d+1,u[h++]=d+r,u[h++]=d+1+r;if(u[h++]=r-1,u[h++]=0,u[h++]=r+r-1,u[h++]=r,o>0)for(d=0;d<r;d+=c)u[h++]=d,u[h++]=d+r;const p=new GeometryAttributes;p.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s}),radiusScratch.x=.5*t,radiusScratch.y=Math.max(i,n);const f=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch));if(defined(e._offsetAttribute)){t=s.length;const n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),p.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:p,indices:u,primitiveType:PrimitiveType$1.LINES,boundingSphere:f,offsetAttribute:e._offsetAttribute})},DefaultProxy.prototype.getURL=function(e){const t=-1===this.proxy.indexOf("?")?"?":"";return this.proxy+t+encodeURIComponent(e)},Object.defineProperties(DistanceDisplayCondition.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}}),DistanceDisplayCondition.packedLength=2,DistanceDisplayCondition.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.near,t[n]=e.far,t},DistanceDisplayCondition.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new DistanceDisplayCondition),n.near=e[t++],n.far=e[t],n},DistanceDisplayCondition.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.far===t.far},DistanceDisplayCondition.clone=function(e,t){if(defined(e))return defined(t)||(t=new DistanceDisplayCondition),t.near=e.near,t.far=e.far,t},DistanceDisplayCondition.prototype.clone=function(e){return DistanceDisplayCondition.clone(this,e)},DistanceDisplayCondition.prototype.equals=function(e){return DistanceDisplayCondition.equals(this,e)},Object.defineProperties(DistanceDisplayConditionGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}}),DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition=function(e){return new DistanceDisplayConditionGeometryInstanceAttribute(e.near,e.far)},DistanceDisplayConditionGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e.near,t[1]=e.far,t):new Float32Array([e.near,e.far])},Object.defineProperties(DoubleEndedPriorityQueue.prototype,{length:{get:function(){return this._length}},maximumLength:{get:function(){return this._maximumLength},set:function(e){if(defined(e)){for(;this._length>e;)this.removeMinimum();this._array.length=e}this._maximumLength=e}},internalArray:{get:function(){return this._array}},comparator:{get:function(){return this._comparator}}}),DoubleEndedPriorityQueue.prototype.clone=function(){const e=this._maximumLength,t=this._comparator,n=this._array,i=this._length,r=new DoubleEndedPriorityQueue({comparator:t,maximumLength:e});r._length=i;for(let e=0;e<i;e++)r._array[e]=n[e];return r},DoubleEndedPriorityQueue.prototype.reset=function(){this._length=0;const e=this._maximumLength;if(defined(e))for(let t=0;t<e;t++)this._array[t]=void 0;else this._array.length=0},DoubleEndedPriorityQueue.prototype.resort=function(){const e=this._length;for(let t=0;t<e;t++)pushUp(this,t)},DoubleEndedPriorityQueue.prototype.insert=function(e){let t;const n=this._maximumLength;if(defined(n)){if(0===n)return;if(this._length===n){const n=this._array[0];if(this._comparator(e,n)<=0)return e;t=this.removeMinimum()}}const i=this._length;return this._array[i]=e,this._length++,pushUp(this,i),t},DoubleEndedPriorityQueue.prototype.removeMinimum=function(){const e=this._length;if(0===e)return;this._length--;const t=this._array[0];return e>=2&&(this._array[0]=this._array[e-1],pushDown(this,0)),this._array[e-1]=void 0,t},DoubleEndedPriorityQueue.prototype.removeMaximum=function(){const e=this._length;if(0===e)return;let t;if(this._length--,e<=2)t=this._array[e-1];else{const n=greaterThan(this,1,2)?1:2;t=this._array[n],this._array[n]=this._array[e-1],e>=4&&pushDown(this,n)}return this._array[e-1]=void 0,t},DoubleEndedPriorityQueue.prototype.getMinimum=function(){if(0!==this._length)return this._array[0]},DoubleEndedPriorityQueue.prototype.getMaximum=function(){const e=this._length;if(0!==e)return e<=2?this._array[e-1]:this._array[greaterThan(this,1,2)?1:2]},Object.defineProperties(DoublyLinkedList.prototype,{length:{get:function(){return this._length}}}),DoublyLinkedList.prototype.add=function(e){const t=new DoublyLinkedListNode(e,this.tail,void 0);return defined(this.tail)?(this.tail.next=t,this.tail=t):(this.head=t,this.tail=t),++this._length,t},DoublyLinkedList.prototype.remove=function(e){defined(e)&&(remove$2(this,e),--this._length)},DoublyLinkedList.prototype.splice=function(e,t){if(e===t)return;remove$2(this,t);const n=e.next;e.next=t,this.tail===e?this.tail=t:n.previous=t,t.next=n,t.previous=e};var Tween$1=createCommonjsModule((function(e,t){var n,i=i||(n=[],{getAll:function(){return n},removeAll:function(){n=[]},add:function(e){n.push(e)},remove:function(e){var t=n.indexOf(e);-1!==t&&n.splice(t,1)},update:function(e,t){if(0===n.length)return!1;var r=0;for(e=void 0!==e?e:i.now();r<n.length;)n[r].update(e)||t?r++:n.splice(r,1);return!0}});"undefined"==typeof window&&"undefined"!=typeof process?i.now=function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?i.now=window.performance.now.bind(window.performance):void 0!==Date.now?i.now=Date.now:i.now=function(){return(new Date).getTime()},i.Tween=function(e){var t,n=e,r={},o={},a={},s=1e3,c=0,l=!1,u=!1,d=0,h=null,p=i.Easing.Linear.None,f=i.Interpolation.Linear,m=[],g=null,_=!1,y=null,C=null,T=null;this.to=function(e,t){return o=e,void 0!==t&&(s=t),this},this.start=function(e){for(var t in i.add(this),u=!0,_=!1,h=void 0!==e?e:i.now(),h+=d,o){if(o[t]instanceof Array){if(0===o[t].length)continue;o[t]=[n[t]].concat(o[t])}void 0!==n[t]&&(r[t]=n[t],r[t]instanceof Array==!1&&(r[t]*=1),a[t]=r[t]||0)}return this},this.stop=function(){return u?(i.remove(this),u=!1,null!==T&&T.call(n,n),this.stopChainedTweens(),this):this},this.end=function(){return this.update(h+s),this},this.stopChainedTweens=function(){for(var e=0,t=m.length;e<t;e++)m[e].stop()},this.delay=function(e){return d=e,this},this.repeat=function(e){return c=e,this},this.repeatDelay=function(e){return t=e,this},this.yoyo=function(e){return l=e,this},this.easing=function(e){return p=e,this},this.interpolation=function(e){return f=e,this},this.chain=function(){return m=arguments,this},this.onStart=function(e){return g=e,this},this.onUpdate=function(e){return y=e,this},this.onComplete=function(e){return C=e,this},this.onStop=function(e){return T=e,this},this.update=function(e){var i,u,T;if(e<h)return!0;for(i in!1===_&&(null!==g&&g.call(n,n),_=!0),T=p(u=(u=(e-h)/s)>1?1:u),o)if(void 0!==r[i]){var S=r[i]||0,A=o[i];A instanceof Array?n[i]=f(A,T):("string"==typeof A&&(A="+"===A.charAt(0)||"-"===A.charAt(0)?S+parseFloat(A):parseFloat(A)),"number"==typeof A&&(n[i]=S+(A-S)*T))}if(null!==y&&y.call(n,T),1===u){if(c>0){for(i in isFinite(c)&&c--,a){if("string"==typeof o[i]&&(a[i]=a[i]+parseFloat(o[i])),l){var v=a[i];a[i]=o[i],o[i]=v}r[i]=a[i]}return h=void 0!==t?e+t:e+d,!0}null!==C&&C.call(n,n);for(var E=0,b=m.length;E<b;E++)m[E].start(h+s);return!1}return!0}},i.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){return 0===e?0:1===e?1:-Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)},Out:function(e){return 0===e?0:1===e?1:Math.pow(2,-10*e)*Math.sin(5*(e-.1)*Math.PI)+1},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?-.5*Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI):.5*Math.pow(2,-10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)+1}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((t+1)*e-t)*.5:.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(e){return 1-i.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*i.Easing.Bounce.In(2*e):.5*i.Easing.Bounce.Out(2*e-1)+.5}}},i.Interpolation={Linear:function(e,t){var n=e.length-1,r=n*t,o=Math.floor(r),a=i.Interpolation.Utils.Linear;return t<0?a(e[0],e[1],r):t>1?a(e[n],e[n-1],n-r):a(e[o],e[o+1>n?n:o+1],r-o)},Bezier:function(e,t){for(var n=0,r=e.length-1,o=Math.pow,a=i.Interpolation.Utils.Bernstein,s=0;s<=r;s++)n+=o(1-t,r-s)*o(t,s)*e[s]*a(r,s);return n},CatmullRom:function(e,t){var n=e.length-1,r=n*t,o=Math.floor(r),a=i.Interpolation.Utils.CatmullRom;return e[0]===e[n]?(t<0&&(o=Math.floor(r=n*(1+t))),a(e[(o-1+n)%n],e[o],e[(o+1)%n],e[(o+2)%n],r-o)):t<0?e[0]-(a(e[0],e[0],e[1],e[1],-r)-e[0]):t>1?e[n]-(a(e[n],e[n],e[n-1],e[n-1],r-n)-e[n]):a(e[o?o-1:0],e[o],e[n<o+1?n:o+1],e[n<o+2?n:o+2],r-o)},Utils:{Linear:function(e,t,n){return(t-e)*n+e},Bernstein:function(e,t){var n=i.Interpolation.Utils.Factorial;return n(e)/n(t)/n(e-t)},Factorial:function(){var e=[1];return function(t){var n=1;if(e[t])return e[t];for(var i=t;i>1;i--)n*=i;return e[t]=n,n}}(),CatmullRom:function(e,t,n,i,r){var o=.5*(n-e),a=.5*(i-t),s=r*r;return(2*t-2*n+o+a)*(r*s)+(-3*t+3*n-2*o-a)*s+o*r+t}}},e.exports=i}));const EasingFunction={LINEAR_NONE:Tween$1.Easing.Linear.None,QUADRATIC_IN:Tween$1.Easing.Quadratic.In,QUADRATIC_OUT:Tween$1.Easing.Quadratic.Out,QUADRATIC_IN_OUT:Tween$1.Easing.Quadratic.InOut,CUBIC_IN:Tween$1.Easing.Cubic.In,CUBIC_OUT:Tween$1.Easing.Cubic.Out,CUBIC_IN_OUT:Tween$1.Easing.Cubic.InOut,QUARTIC_IN:Tween$1.Easing.Quartic.In,QUARTIC_OUT:Tween$1.Easing.Quartic.Out,QUARTIC_IN_OUT:Tween$1.Easing.Quartic.InOut,QUINTIC_IN:Tween$1.Easing.Quintic.In,QUINTIC_OUT:Tween$1.Easing.Quintic.Out,QUINTIC_IN_OUT:Tween$1.Easing.Quintic.InOut,SINUSOIDAL_IN:Tween$1.Easing.Sinusoidal.In,SINUSOIDAL_OUT:Tween$1.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:Tween$1.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:Tween$1.Easing.Exponential.In,EXPONENTIAL_OUT:Tween$1.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:Tween$1.Easing.Exponential.InOut,CIRCULAR_IN:Tween$1.Easing.Circular.In,CIRCULAR_OUT:Tween$1.Easing.Circular.Out,CIRCULAR_IN_OUT:Tween$1.Easing.Circular.InOut,ELASTIC_IN:Tween$1.Easing.Elastic.In,ELASTIC_OUT:Tween$1.Easing.Elastic.Out,ELASTIC_IN_OUT:Tween$1.Easing.Elastic.InOut,BACK_IN:Tween$1.Easing.Back.In,BACK_OUT:Tween$1.Easing.Back.Out,BACK_IN_OUT:Tween$1.Easing.Back.InOut,BOUNCE_IN:Tween$1.Easing.Bounce.In,BOUNCE_OUT:Tween$1.Easing.Bounce.Out,BOUNCE_IN_OUT:Tween$1.Easing.Bounce.InOut};var EasingFunction$1=Object.freeze(EasingFunction);const scratchPosition$b=new Cartesian3,scratchNormal$3=new Cartesian3,scratchTangent$2=new Cartesian3,scratchBitangent$2=new Cartesian3,scratchNormalST=new Cartesian3,defaultRadii$1=new Cartesian3(1,1,1),cos$2=Math.cos,sin$2=Math.sin;function EllipsoidGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.radii,defaultRadii$1),n=defaultValue(e.innerRadii,t),i=defaultValue(e.minimumClock,0),r=defaultValue(e.maximumClock,CesiumMath.TWO_PI),o=defaultValue(e.minimumCone,0),a=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,64)),c=Math.round(defaultValue(e.slicePartitions,64)),l=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(n),this._minimumClock=i,this._maximumClock=r,this._minimumCone=o,this._maximumCone=a,this._stackPartitions=s,this._slicePartitions=c,this._vertexFormat=VertexFormat.clone(l),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}EllipsoidGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+7,EllipsoidGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._radii,t,n),n+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,n),n+=Cartesian3.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._minimumClock,t[n++]=e._maximumClock,t[n++]=e._minimumCone,t[n++]=e._maximumCone,t[n++]=e._stackPartitions,t[n++]=e._slicePartitions,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchRadii$2=new Cartesian3,scratchInnerRadii$1=new Cartesian3,scratchVertexFormat$7=new VertexFormat,scratchOptions$b={radii:scratchRadii$2,innerRadii:scratchInnerRadii$1,vertexFormat:scratchVertexFormat$7,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0};let unitEllipsoidGeometry;EllipsoidGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchRadii$2);t+=Cartesian3.packedLength;const r=Cartesian3.unpack(e,t,scratchInnerRadii$1);t+=Cartesian3.packedLength;const o=VertexFormat.unpack(e,t,scratchVertexFormat$7);t+=VertexFormat.packedLength;const a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(n)?(n._radii=Cartesian3.clone(i,n._radii),n._innerRadii=Cartesian3.clone(r,n._innerRadii),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._minimumClock=a,n._maximumClock=s,n._minimumCone=c,n._maximumCone=l,n._stackPartitions=u,n._slicePartitions=d,n._offsetAttribute=-1===h?void 0:h,n):(scratchOptions$b.minimumClock=a,scratchOptions$b.maximumClock=s,scratchOptions$b.minimumCone=c,scratchOptions$b.maximumCone=l,scratchOptions$b.stackPartitions=u,scratchOptions$b.slicePartitions=d,scratchOptions$b.offsetAttribute=-1===h?void 0:h,new EllipsoidGeometry(scratchOptions$b))},EllipsoidGeometry.createGeometry=function(e){const t=e._radii;if(t.x<=0||t.y<=0||t.z<=0)return;const n=e._innerRadii;if(n.x<=0||n.y<=0||n.z<=0)return;const i=e._minimumClock,r=e._maximumClock,o=e._minimumCone,a=e._maximumCone,s=e._vertexFormat;let c,l,u=e._slicePartitions+1,d=e._stackPartitions+1;u=Math.round(u*Math.abs(r-i)/CesiumMath.TWO_PI),d=Math.round(d*Math.abs(a-o)/CesiumMath.PI),u<2&&(u=2),d<2&&(d=2);let h=0;const p=[o],f=[i];for(c=0;c<d;c++)p.push(o+c*(a-o)/(d-1));for(p.push(a),l=0;l<u;l++)f.push(i+l*(r-i)/(u-1));f.push(r);const m=p.length,g=f.length;let _=0,y=1;const C=n.x!==t.x||n.y!==t.y||n.z!==t.z;let T=!1,S=!1,A=!1;C&&(y=2,o>0&&(T=!0,_+=u-1),a<Math.PI&&(S=!0,_+=u-1),(r-i)%CesiumMath.TWO_PI?(A=!0,_+=2*(d-1)+1):_+=1);const v=g*m*y,E=new Float64Array(3*v),b=arrayFill(new Array(v),!1),x=arrayFill(new Array(v),!1),P=u*d*y,D=6*(P+_+1-(u+d)*y),w=IndexDatatype$1.createTypedArray(P,D),M=s.normal?new Float32Array(3*v):void 0,I=s.tangent?new Float32Array(3*v):void 0,R=s.bitangent?new Float32Array(3*v):void 0,O=s.st?new Float32Array(2*v):void 0,B=new Array(m),L=new Array(m);for(c=0;c<m;c++)B[c]=sin$2(p[c]),L[c]=cos$2(p[c]);const F=new Array(g),N=new Array(g);for(l=0;l<g;l++)N[l]=cos$2(f[l]),F[l]=sin$2(f[l]);for(c=0;c<m;c++)for(l=0;l<g;l++)E[h++]=t.x*B[c]*N[l],E[h++]=t.y*B[c]*F[l],E[h++]=t.z*L[c];let V,$,k,U,G=v/2;if(C)for(c=0;c<m;c++)for(l=0;l<g;l++)E[h++]=n.x*B[c]*N[l],E[h++]=n.y*B[c]*F[l],E[h++]=n.z*L[c],b[G]=!0,c>0&&c!==m-1&&0!==l&&l!==g-1&&(x[G]=!0),G++;for(h=0,c=1;c<m-2;c++)for(V=c*g,$=(c+1)*g,l=1;l<g-2;l++)w[h++]=$+l,w[h++]=$+l+1,w[h++]=V+l+1,w[h++]=$+l,w[h++]=V+l+1,w[h++]=V+l;if(C){const e=m*g;for(c=1;c<m-2;c++)for(V=e+c*g,$=e+(c+1)*g,l=1;l<g-2;l++)w[h++]=$+l,w[h++]=V+l,w[h++]=V+l+1,w[h++]=$+l,w[h++]=V+l+1,w[h++]=$+l+1}if(C){if(T)for(U=m*g,c=1;c<g-2;c++)w[h++]=c,w[h++]=c+1,w[h++]=U+c+1,w[h++]=c,w[h++]=U+c+1,w[h++]=U+c;if(S)for(k=m*g-g,U=m*g*y-g,c=1;c<g-2;c++)w[h++]=k+c+1,w[h++]=k+c,w[h++]=U+c,w[h++]=k+c+1,w[h++]=U+c,w[h++]=U+c+1}if(A){for(c=1;c<m-2;c++)U=g*m+g*c,k=g*c,w[h++]=U,w[h++]=k+g,w[h++]=k,w[h++]=U,w[h++]=U+g,w[h++]=k+g;for(c=1;c<m-2;c++)U=g*m+g*(c+1)-1,k=g*(c+1)-1,w[h++]=k+g,w[h++]=U,w[h++]=k,w[h++]=k+g,w[h++]=U+g,w[h++]=U}const z=new GeometryAttributes;s.position&&(z.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:E}));let H=0,W=0,q=0,j=0;const X=v/2;let Y;const K=Ellipsoid.fromCartesian3(t),J=Ellipsoid.fromCartesian3(n);if(s.st||s.normal||s.tangent||s.bitangent){for(c=0;c<v;c++){Y=b[c]?J:K;const e=Cartesian3.fromArray(E,3*c,scratchPosition$b),t=Y.geodeticSurfaceNormal(e,scratchNormal$3);if(x[c]&&Cartesian3.negate(t,t),s.st){const e=Cartesian2.negate(t,scratchNormalST);O[H++]=Math.atan2(e.y,e.x)/CesiumMath.TWO_PI+.5,O[H++]=Math.asin(t.z)/Math.PI+.5}if(s.normal&&(M[W++]=t.x,M[W++]=t.y,M[W++]=t.z),s.tangent||s.bitangent){const e=scratchTangent$2;let n,i=0;if(b[c]&&(i=X),n=!T&&c>=i&&c<i+2*g?Cartesian3.UNIT_X:Cartesian3.UNIT_Z,Cartesian3.cross(n,t,e),Cartesian3.normalize(e,e),s.tangent&&(I[q++]=e.x,I[q++]=e.y,I[q++]=e.z),s.bitangent){const n=Cartesian3.cross(t,e,scratchBitangent$2);Cartesian3.normalize(n,n),R[j++]=n.x,R[j++]=n.y,R[j++]=n.z}}}s.st&&(z.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:O})),s.normal&&(z.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:M})),s.tangent&&(z.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:I})),s.bitangent&&(z.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:R}))}if(defined(e._offsetAttribute)){const t=E.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),z.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:z,indices:w,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromEllipsoid(K),offsetAttribute:e._offsetAttribute})},EllipsoidGeometry.getUnitEllipsoid=function(){return defined(unitEllipsoidGeometry)||(unitEllipsoidGeometry=EllipsoidGeometry.createGeometry(new EllipsoidGeometry({radii:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitEllipsoidGeometry};const defaultRadii=new Cartesian3(1,1,1),cos$1=Math.cos,sin$1=Math.sin;function EllipsoidOutlineGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.radii,defaultRadii),n=defaultValue(e.innerRadii,t),i=defaultValue(e.minimumClock,0),r=defaultValue(e.maximumClock,CesiumMath.TWO_PI),o=defaultValue(e.minimumCone,0),a=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,10)),c=Math.round(defaultValue(e.slicePartitions,8)),l=Math.round(defaultValue(e.subdivisions,128));this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(n),this._minimumClock=i,this._maximumClock=r,this._minimumCone=o,this._maximumCone=a,this._stackPartitions=s,this._slicePartitions=c,this._subdivisions=l,this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}EllipsoidOutlineGeometry.packedLength=2*Cartesian3.packedLength+8,EllipsoidOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Cartesian3.pack(e._radii,t,n),n+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,n),n+=Cartesian3.packedLength,t[n++]=e._minimumClock,t[n++]=e._maximumClock,t[n++]=e._minimumCone,t[n++]=e._maximumCone,t[n++]=e._stackPartitions,t[n++]=e._slicePartitions,t[n++]=e._subdivisions,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchRadii$1=new Cartesian3,scratchInnerRadii=new Cartesian3,scratchOptions$a={radii:scratchRadii$1,innerRadii:scratchInnerRadii,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};function EllipsoidTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event,this._readyPromise=when.resolve(!0)}function EventHelper(){this._removalFunctions=[]}EllipsoidOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Cartesian3.unpack(e,t,scratchRadii$1);t+=Cartesian3.packedLength;const r=Cartesian3.unpack(e,t,scratchInnerRadii);t+=Cartesian3.packedLength;const o=e[t++],a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(n)?(n._radii=Cartesian3.clone(i,n._radii),n._innerRadii=Cartesian3.clone(r,n._innerRadii),n._minimumClock=o,n._maximumClock=a,n._minimumCone=s,n._maximumCone=c,n._stackPartitions=l,n._slicePartitions=u,n._subdivisions=d,n._offsetAttribute=-1===h?void 0:h,n):(scratchOptions$a.minimumClock=o,scratchOptions$a.maximumClock=a,scratchOptions$a.minimumCone=s,scratchOptions$a.maximumCone=c,scratchOptions$a.stackPartitions=l,scratchOptions$a.slicePartitions=u,scratchOptions$a.subdivisions=d,scratchOptions$a.offsetAttribute=-1===h?void 0:h,new EllipsoidOutlineGeometry(scratchOptions$a))},EllipsoidOutlineGeometry.createGeometry=function(e){const t=e._radii;if(t.x<=0||t.y<=0||t.z<=0)return;const n=e._innerRadii;if(n.x<=0||n.y<=0||n.z<=0)return;const i=e._minimumClock,r=e._maximumClock,o=e._minimumCone,a=e._maximumCone,s=e._subdivisions,c=Ellipsoid.fromCartesian3(t);let l=e._slicePartitions+1,u=e._stackPartitions+1;l=Math.round(l*Math.abs(r-i)/CesiumMath.TWO_PI),u=Math.round(u*Math.abs(a-o)/CesiumMath.PI),l<2&&(l=2),u<2&&(u=2);let d=0,h=1;const p=n.x!==t.x||n.y!==t.y||n.z!==t.z;let f=!1,m=!1;p&&(h=2,o>0&&(f=!0,d+=l),a<Math.PI&&(m=!0,d+=l));const g=s*h*(u+l),_=new Float64Array(3*g),y=2*(g+d-(l+u)*h),C=IndexDatatype$1.createTypedArray(g,y);let T,S,A,v,E=0;const b=new Array(u),x=new Array(u);for(T=0;T<u;T++)v=o+T*(a-o)/(u-1),b[T]=sin$1(v),x[T]=cos$1(v);const P=new Array(s),D=new Array(s);for(T=0;T<s;T++)A=i+T*(r-i)/(s-1),P[T]=sin$1(A),D[T]=cos$1(A);for(T=0;T<u;T++)for(S=0;S<s;S++)_[E++]=t.x*b[T]*D[S],_[E++]=t.y*b[T]*P[S],_[E++]=t.z*x[T];if(p)for(T=0;T<u;T++)for(S=0;S<s;S++)_[E++]=n.x*b[T]*D[S],_[E++]=n.y*b[T]*P[S],_[E++]=n.z*x[T];for(b.length=s,x.length=s,T=0;T<s;T++)v=o+T*(a-o)/(s-1),b[T]=sin$1(v),x[T]=cos$1(v);for(P.length=l,D.length=l,T=0;T<l;T++)A=i+T*(r-i)/(l-1),P[T]=sin$1(A),D[T]=cos$1(A);for(T=0;T<s;T++)for(S=0;S<l;S++)_[E++]=t.x*b[T]*D[S],_[E++]=t.y*b[T]*P[S],_[E++]=t.z*x[T];if(p)for(T=0;T<s;T++)for(S=0;S<l;S++)_[E++]=n.x*b[T]*D[S],_[E++]=n.y*b[T]*P[S],_[E++]=n.z*x[T];for(E=0,T=0;T<u*h;T++){const e=T*s;for(S=0;S<s-1;S++)C[E++]=e+S,C[E++]=e+S+1}let w=u*s*h;for(T=0;T<l;T++)for(S=0;S<s-1;S++)C[E++]=w+T+S*l,C[E++]=w+T+(S+1)*l;if(p)for(w=u*s*h+l*s,T=0;T<l;T++)for(S=0;S<s-1;S++)C[E++]=w+T+S*l,C[E++]=w+T+(S+1)*l;if(p){let e=u*s*h,t=e+s*l;if(f)for(T=0;T<l;T++)C[E++]=e+T,C[E++]=t+T;if(m)for(e+=s*l-l,t+=s*l-l,T=0;T<l;T++)C[E++]=e+T,C[E++]=t+T}const M=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:_})});if(defined(e._offsetAttribute)){const t=_.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),M.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new Geometry({attributes:M,indices:C,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromEllipsoid(c),offsetAttribute:e._offsetAttribute})},Object.defineProperties(EllipsoidTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),EllipsoidTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}))},EllipsoidTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},EllipsoidTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){},EllipsoidTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){},EventHelper.prototype.add=function(e,t,n){const i=e.addEventListener(t,n);this._removalFunctions.push(i);const r=this;return function(){i();const e=r._removalFunctions;e.splice(e.indexOf(i),1)}},EventHelper.prototype.removeAll=function(){const e=this._removalFunctions;for(let t=0,n=e.length;t<n;++t)e[t]();e.length=0};const ExperimentalFeatures={enableModelExperimental:!1},ExtrapolationType={NONE:0,HOLD:1,EXTRAPOLATE:2};var ExtrapolationType$1=Object.freeze(ExtrapolationType);function OrthographicOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._orthographicMatrix=new Matrix4}function update$5(e){e.top===e._top&&e.bottom===e._bottom&&e.left===e._left&&e.right===e._right&&e.near===e._near&&e.far===e._far||(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Matrix4.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}Object.defineProperties(OrthographicOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$5(this),this._orthographicMatrix}}});const getPlanesRight$1=new Cartesian3,getPlanesNearCenter$1=new Cartesian3,getPlanesPoint=new Cartesian3,negateScratch=new Cartesian3;function OrthographicFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new OrthographicOffCenterFrustum,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far}function update$4(e){const t=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;const n=1/e.aspectRatio;t.right=.5*e.width,t.left=-t.right,t.top=n*t.right,t.bottom=-t.top,t.near=e.near,t.far=e.far}}function PerspectiveOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._perspectiveMatrix=new Matrix4,this._infinitePerspective=new Matrix4}function update$3(e){const t=e.top,n=e.bottom,i=e.right,r=e.left,o=e.near,a=e.far;t===e._top&&n===e._bottom&&r===e._left&&i===e._right&&o===e._near&&a===e._far||(e._left=r,e._right=i,e._top=t,e._bottom=n,e._near=o,e._far=a,e._perspectiveMatrix=Matrix4.computePerspectiveOffCenter(r,i,n,t,o,a,e._perspectiveMatrix),e._infinitePerspective=Matrix4.computeInfinitePerspectiveOffCenter(r,i,n,t,o,e._infinitePerspective))}OrthographicOffCenterFrustum.prototype.computeCullingVolume=function(e,t,n){const i=this._cullingVolume.planes,r=this.top,o=this.bottom,a=this.right,s=this.left,c=this.near,l=this.far,u=Cartesian3.cross(t,n,getPlanesRight$1);Cartesian3.normalize(u,u);const d=getPlanesNearCenter$1;Cartesian3.multiplyByScalar(t,c,d),Cartesian3.add(e,d,d);const h=getPlanesPoint;Cartesian3.multiplyByScalar(u,s,h),Cartesian3.add(d,h,h);let p=i[0];return defined(p)||(p=i[0]=new Cartesian4),p.x=u.x,p.y=u.y,p.z=u.z,p.w=-Cartesian3.dot(u,h),Cartesian3.multiplyByScalar(u,a,h),Cartesian3.add(d,h,h),p=i[1],defined(p)||(p=i[1]=new Cartesian4),p.x=-u.x,p.y=-u.y,p.z=-u.z,p.w=-Cartesian3.dot(Cartesian3.negate(u,negateScratch),h),Cartesian3.multiplyByScalar(n,o,h),Cartesian3.add(d,h,h),p=i[2],defined(p)||(p=i[2]=new Cartesian4),p.x=n.x,p.y=n.y,p.z=n.z,p.w=-Cartesian3.dot(n,h),Cartesian3.multiplyByScalar(n,r,h),Cartesian3.add(d,h,h),p=i[3],defined(p)||(p=i[3]=new Cartesian4),p.x=-n.x,p.y=-n.y,p.z=-n.z,p.w=-Cartesian3.dot(Cartesian3.negate(n,negateScratch),h),p=i[4],defined(p)||(p=i[4]=new Cartesian4),p.x=t.x,p.y=t.y,p.z=t.z,p.w=-Cartesian3.dot(t,d),Cartesian3.multiplyByScalar(t,l,h),Cartesian3.add(e,h,h),p=i[5],defined(p)||(p=i[5]=new Cartesian4),p.x=-t.x,p.y=-t.y,p.z=-t.z,p.w=-Cartesian3.dot(Cartesian3.negate(t,negateScratch),h),this._cullingVolume},OrthographicOffCenterFrustum.prototype.getPixelDimensions=function(e,t,n,i,r){update$5(this);const o=i*(this.right-this.left)/e,a=i*(this.top-this.bottom)/t;return r.x=o,r.y=a,r},OrthographicOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicOffCenterFrustum),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},OrthographicOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof OrthographicOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},OrthographicOffCenterFrustum.prototype.equalsEpsilon=function(e,t,n){return e===this||defined(e)&&e instanceof OrthographicOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,n)&&CesiumMath.equalsEpsilon(this.left,e.left,t,n)&&CesiumMath.equalsEpsilon(this.top,e.top,t,n)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,n)&&CesiumMath.equalsEpsilon(this.near,e.near,t,n)&&CesiumMath.equalsEpsilon(this.far,e.far,t,n)},OrthographicFrustum.packedLength=4,OrthographicFrustum.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.width,t[n++]=e.aspectRatio,t[n++]=e.near,t[n]=e.far,t},OrthographicFrustum.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new OrthographicFrustum),n.width=e[t++],n.aspectRatio=e[t++],n.near=e[t++],n.far=e[t],n},Object.defineProperties(OrthographicFrustum.prototype,{projectionMatrix:{get:function(){return update$4(this),this._offCenterFrustum.projectionMatrix}}}),OrthographicFrustum.prototype.computeCullingVolume=function(e,t,n){return update$4(this),this._offCenterFrustum.computeCullingVolume(e,t,n)},OrthographicFrustum.prototype.getPixelDimensions=function(e,t,n,i,r){return update$4(this),this._offCenterFrustum.getPixelDimensions(e,t,n,i,r)},OrthographicFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicFrustum),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},OrthographicFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},OrthographicFrustum.prototype.equalsEpsilon=function(e,t,n){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),CesiumMath.equalsEpsilon(this.width,e.width,t,n)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,n))},Object.defineProperties(PerspectiveOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$3(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return update$3(this),this._infinitePerspective}}});const getPlanesRight=new Cartesian3,getPlanesNearCenter=new Cartesian3,getPlanesFarCenter=new Cartesian3,getPlanesNormal=new Cartesian3;function PerspectiveFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new PerspectiveOffCenterFrustum,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this.xOffset=defaultValue(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=defaultValue(e.yOffset,0),this._yOffset=this.yOffset}function update$2(e){const t=e._offCenterFrustum;e.fov===e._fov&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far&&e.xOffset===e._xOffset&&e.yOffset===e._yOffset||(e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset)}PerspectiveOffCenterFrustum.prototype.computeCullingVolume=function(e,t,n){const i=this._cullingVolume.planes,r=this.top,o=this.bottom,a=this.right,s=this.left,c=this.near,l=this.far,u=Cartesian3.cross(t,n,getPlanesRight),d=getPlanesNearCenter;Cartesian3.multiplyByScalar(t,c,d),Cartesian3.add(e,d,d);const h=getPlanesFarCenter;Cartesian3.multiplyByScalar(t,l,h),Cartesian3.add(e,h,h);const p=getPlanesNormal;Cartesian3.multiplyByScalar(u,s,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.normalize(p,p),Cartesian3.cross(p,n,p),Cartesian3.normalize(p,p);let f=i[0];return defined(f)||(f=i[0]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(u,a,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(n,p,p),Cartesian3.normalize(p,p),f=i[1],defined(f)||(f=i[1]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(n,o,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(u,p,p),Cartesian3.normalize(p,p),f=i[2],defined(f)||(f=i[2]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(n,r,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(p,u,p),Cartesian3.normalize(p,p),f=i[3],defined(f)||(f=i[3]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),f=i[4],defined(f)||(f=i[4]=new Cartesian4),f.x=t.x,f.y=t.y,f.z=t.z,f.w=-Cartesian3.dot(t,d),Cartesian3.negate(t,p),f=i[5],defined(f)||(f=i[5]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,h),this._cullingVolume},PerspectiveOffCenterFrustum.prototype.getPixelDimensions=function(e,t,n,i,r){update$3(this);const o=1/this.near;let a=this.top*o;const s=2*i*n*a/t;a=this.right*o;const c=2*i*n*a/e;return r.x=c,r.y=s,r},PerspectiveOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveOffCenterFrustum),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},PerspectiveOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof PerspectiveOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},PerspectiveOffCenterFrustum.prototype.equalsEpsilon=function(e,t,n){return e===this||defined(e)&&e instanceof PerspectiveOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,n)&&CesiumMath.equalsEpsilon(this.left,e.left,t,n)&&CesiumMath.equalsEpsilon(this.top,e.top,t,n)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,n)&&CesiumMath.equalsEpsilon(this.near,e.near,t,n)&&CesiumMath.equalsEpsilon(this.far,e.far,t,n)},PerspectiveFrustum.packedLength=6,PerspectiveFrustum.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.fov,t[n++]=e.aspectRatio,t[n++]=e.near,t[n++]=e.far,t[n++]=e.xOffset,t[n]=e.yOffset,t},PerspectiveFrustum.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new PerspectiveFrustum),n.fov=e[t++],n.aspectRatio=e[t++],n.near=e[t++],n.far=e[t++],n.xOffset=e[t++],n.yOffset=e[t],n},Object.defineProperties(PerspectiveFrustum.prototype,{projectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return update$2(this),this._fovy}},sseDenominator:{get:function(){return update$2(this),this._sseDenominator}}}),PerspectiveFrustum.prototype.computeCullingVolume=function(e,t,n){return update$2(this),this._offCenterFrustum.computeCullingVolume(e,t,n)},PerspectiveFrustum.prototype.getPixelDimensions=function(e,t,n,i,r){return update$2(this),this._offCenterFrustum.getPixelDimensions(e,t,n,i,r)},PerspectiveFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveFrustum),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},PerspectiveFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},PerspectiveFrustum.prototype.equalsEpsilon=function(e,t,n){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),CesiumMath.equalsEpsilon(this.fov,e.fov,t,n)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,n))};const PERSPECTIVE$1=0,ORTHOGRAPHIC$1=1;function FrustumGeometry(e){const t=e.frustum,n=e.orientation,i=e.origin,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),o=defaultValue(e._drawNearPlane,!0);let a,s;t instanceof PerspectiveFrustum?(a=PERSPECTIVE$1,s=PerspectiveFrustum.packedLength):t instanceof OrthographicFrustum&&(a=ORTHOGRAPHIC$1,s=OrthographicFrustum.packedLength),this._frustumType=a,this._frustum=t.clone(),this._origin=Cartesian3.clone(i),this._orientation=Quaternion.clone(n),this._drawNearPlane=o,this._vertexFormat=r,this._workerName="createFrustumGeometry",this.packedLength=2+s+Cartesian3.packedLength+Quaternion.packedLength+VertexFormat.packedLength}FrustumGeometry.pack=function(e,t,n){n=defaultValue(n,0);const i=e._frustumType,r=e._frustum;return t[n++]=i,i===PERSPECTIVE$1?(PerspectiveFrustum.pack(r,t,n),n+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(r,t,n),n+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,n),n+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,n),n+=Quaternion.packedLength,VertexFormat.pack(e._vertexFormat,t,n),t[n+=VertexFormat.packedLength]=e._drawNearPlane?1:0,t};const scratchPackPerspective$1=new PerspectiveFrustum,scratchPackOrthographic$1=new OrthographicFrustum,scratchPackQuaternion$1=new Quaternion,scratchPackorigin$1=new Cartesian3,scratchVertexFormat$6=new VertexFormat;function getAttributes(e,t,n,i,r,o,a,s){const c=e/3*2;for(let r=0;r<4;++r)defined(t)&&(t[e]=o.x,t[e+1]=o.y,t[e+2]=o.z),defined(n)&&(n[e]=a.x,n[e+1]=a.y,n[e+2]=a.z),defined(i)&&(i[e]=s.x,i[e+1]=s.y,i[e+2]=s.z),e+=3;r[c]=0,r[c+1]=0,r[c+2]=1,r[c+3]=0,r[c+4]=1,r[c+5]=1,r[c+6]=0,r[c+7]=1}FrustumGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=e[t++];let r;i===PERSPECTIVE$1?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective$1),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic$1),t+=OrthographicFrustum.packedLength);const o=Cartesian3.unpack(e,t,scratchPackorigin$1);t+=Cartesian3.packedLength;const a=Quaternion.unpack(e,t,scratchPackQuaternion$1);t+=Quaternion.packedLength;const s=VertexFormat.unpack(e,t,scratchVertexFormat$6),c=1===e[t+=VertexFormat.packedLength];if(!defined(n))return new FrustumGeometry({frustum:r,origin:o,orientation:a,vertexFormat:s,_drawNearPlane:c});const l=i===n._frustumType?n._frustum:void 0;return n._frustum=r.clone(l),n._frustumType=i,n._origin=Cartesian3.clone(o,n._origin),n._orientation=Quaternion.clone(a,n._orientation),n._vertexFormat=VertexFormat.clone(s,n._vertexFormat),n._drawNearPlane=c,n};const scratchRotationMatrix=new Matrix3,scratchViewMatrix=new Matrix4,scratchInverseMatrix=new Matrix4,scratchXDirection=new Cartesian3,scratchYDirection=new Cartesian3,scratchZDirection=new Cartesian3,scratchNegativeX=new Cartesian3,scratchNegativeY=new Cartesian3,scratchNegativeZ=new Cartesian3,frustumSplits=new Array(3),frustumCornersNDC$1=new Array(4);frustumCornersNDC$1[0]=new Cartesian4(-1,-1,1,1),frustumCornersNDC$1[1]=new Cartesian4(1,-1,1,1),frustumCornersNDC$1[2]=new Cartesian4(1,1,1,1),frustumCornersNDC$1[3]=new Cartesian4(-1,1,1,1);const scratchFrustumCorners$1=new Array(4);for(let e=0;e<4;++e)scratchFrustumCorners$1[e]=new Cartesian4;FrustumGeometry._computeNearFarPlanes=function(e,t,n,i,r,o,a,s){const c=Matrix3.fromQuaternion(t,scratchRotationMatrix);let l=defaultValue(o,scratchXDirection),u=defaultValue(a,scratchYDirection),d=defaultValue(s,scratchZDirection);l=Matrix3.getColumn(c,0,l),u=Matrix3.getColumn(c,1,u),d=Matrix3.getColumn(c,2,d),Cartesian3.normalize(l,l),Cartesian3.normalize(u,u),Cartesian3.normalize(d,d),Cartesian3.negate(l,l);const h=Matrix4.computeView(e,d,u,l,scratchViewMatrix);let p,f;if(n===PERSPECTIVE$1){const e=i.projectionMatrix,t=Matrix4.multiply(e,h,scratchInverseMatrix);f=Matrix4.inverse(t,scratchInverseMatrix)}else p=Matrix4.inverseTransformation(h,scratchInverseMatrix);defined(f)?(frustumSplits[0]=i.near,frustumSplits[1]=i.far):(frustumSplits[0]=0,frustumSplits[1]=i.near,frustumSplits[2]=i.far);for(let t=0;t<2;++t)for(let n=0;n<4;++n){let o=Cartesian4.clone(frustumCornersNDC$1[n],scratchFrustumCorners$1[n]);if(defined(f)){o=Matrix4.multiplyByVector(f,o,o);const n=1/o.w;Cartesian3.multiplyByScalar(o,n,o),Cartesian3.subtract(o,e,o),Cartesian3.normalize(o,o);const i=Cartesian3.dot(d,o);Cartesian3.multiplyByScalar(o,frustumSplits[t]/i,o),Cartesian3.add(o,e,o)}else{defined(i._offCenterFrustum)&&(i=i._offCenterFrustum);const e=frustumSplits[t],n=frustumSplits[t+1];o.x=.5*(o.x*(i.right-i.left)+i.left+i.right),o.y=.5*(o.y*(i.top-i.bottom)+i.bottom+i.top),o.z=.5*(o.z*(e-n)-e-n),o.w=1,Matrix4.multiplyByVector(p,o,o)}r[12*t+3*n]=o.x,r[12*t+3*n+1]=o.y,r[12*t+3*n+2]=o.z}},FrustumGeometry.createGeometry=function(e){const t=e._frustumType,n=e._frustum,i=e._origin,r=e._orientation,o=e._drawNearPlane,a=e._vertexFormat,s=o?6:5;let c=new Float64Array(72);FrustumGeometry._computeNearFarPlanes(i,r,t,n,c);let l=24;c[l]=c[12],c[l+1]=c[13],c[l+2]=c[14],c[l+3]=c[0],c[l+4]=c[1],c[l+5]=c[2],c[l+6]=c[9],c[l+7]=c[10],c[l+8]=c[11],c[l+9]=c[21],c[l+10]=c[22],c[l+11]=c[23],l+=12,c[l]=c[15],c[l+1]=c[16],c[l+2]=c[17],c[l+3]=c[3],c[l+4]=c[4],c[l+5]=c[5],c[l+6]=c[0],c[l+7]=c[1],c[l+8]=c[2],c[l+9]=c[12],c[l+10]=c[13],c[l+11]=c[14],l+=12,c[l]=c[3],c[l+1]=c[4],c[l+2]=c[5],c[l+3]=c[15],c[l+4]=c[16],c[l+5]=c[17],c[l+6]=c[18],c[l+7]=c[19],c[l+8]=c[20],c[l+9]=c[6],c[l+10]=c[7],c[l+11]=c[8],l+=12,c[l]=c[6],c[l+1]=c[7],c[l+2]=c[8],c[l+3]=c[18],c[l+4]=c[19],c[l+5]=c[20],c[l+6]=c[21],c[l+7]=c[22],c[l+8]=c[23],c[l+9]=c[9],c[l+10]=c[10],c[l+11]=c[11],o||(c=c.subarray(12));const u=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})});if(defined(a.normal)||defined(a.tangent)||defined(a.bitangent)||defined(a.st)){const e=defined(a.normal)?new Float32Array(12*s):void 0,t=defined(a.tangent)?new Float32Array(12*s):void 0,n=defined(a.bitangent)?new Float32Array(12*s):void 0,i=defined(a.st)?new Float32Array(8*s):void 0,r=scratchXDirection,c=scratchYDirection,d=scratchZDirection,h=Cartesian3.negate(r,scratchNegativeX),p=Cartesian3.negate(c,scratchNegativeY),f=Cartesian3.negate(d,scratchNegativeZ);l=0,o&&(getAttributes(l,e,t,n,i,f,r,c),l+=12),getAttributes(l,e,t,n,i,d,h,c),l+=12,getAttributes(l,e,t,n,i,h,f,c),l+=12,getAttributes(l,e,t,n,i,p,f,h),l+=12,getAttributes(l,e,t,n,i,r,d,c),l+=12,getAttributes(l,e,t,n,i,c,d,h),defined(e)&&(u.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})),defined(t)&&(u.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t})),defined(n)&&(u.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n})),defined(i)&&(u.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:i}))}const d=new Uint16Array(6*s);for(let e=0;e<s;++e){const t=6*e,n=4*e;d[t]=n,d[t+1]=n+1,d[t+2]=n+2,d[t+3]=n,d[t+4]=n+2,d[t+5]=n+3}return new Geometry({attributes:u,indices:d,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromVertices(c)})};const PERSPECTIVE=0,ORTHOGRAPHIC=1;function FrustumOutlineGeometry(e){const t=e.frustum,n=e.orientation,i=e.origin,r=defaultValue(e._drawNearPlane,!0);let o,a;t instanceof PerspectiveFrustum?(o=PERSPECTIVE,a=PerspectiveFrustum.packedLength):t instanceof OrthographicFrustum&&(o=ORTHOGRAPHIC,a=OrthographicFrustum.packedLength),this._frustumType=o,this._frustum=t.clone(),this._origin=Cartesian3.clone(i),this._orientation=Quaternion.clone(n),this._drawNearPlane=r,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+a+Cartesian3.packedLength+Quaternion.packedLength}FrustumOutlineGeometry.pack=function(e,t,n){n=defaultValue(n,0);const i=e._frustumType,r=e._frustum;return t[n++]=i,i===PERSPECTIVE?(PerspectiveFrustum.pack(r,t,n),n+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(r,t,n),n+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,n),n+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,n),t[n+=Quaternion.packedLength]=e._drawNearPlane?1:0,t};const scratchPackPerspective=new PerspectiveFrustum,scratchPackOrthographic=new OrthographicFrustum,scratchPackQuaternion=new Quaternion,scratchPackorigin=new Cartesian3;FrustumOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=e[t++];let r;i===PERSPECTIVE?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic),t+=OrthographicFrustum.packedLength);const o=Cartesian3.unpack(e,t,scratchPackorigin);t+=Cartesian3.packedLength;const a=Quaternion.unpack(e,t,scratchPackQuaternion),s=1===e[t+=Quaternion.packedLength];if(!defined(n))return new FrustumOutlineGeometry({frustum:r,origin:o,orientation:a,_drawNearPlane:s});const c=i===n._frustumType?n._frustum:void 0;return n._frustum=r.clone(c),n._frustumType=i,n._origin=Cartesian3.clone(o,n._origin),n._orientation=Quaternion.clone(a,n._orientation),n._drawNearPlane=s,n},FrustumOutlineGeometry.createGeometry=function(e){const t=e._frustumType,n=e._frustum,i=e._origin,r=e._orientation,o=e._drawNearPlane,a=new Float64Array(24);FrustumGeometry._computeNearFarPlanes(i,r,t,n,a);const s=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})});let c,l;const u=o?2:1,d=new Uint16Array(8*(u+1));let h=o?0:1;for(;h<2;++h)c=o?8*h:0,l=4*h,d[c]=l,d[c+1]=l+1,d[c+2]=l+1,d[c+3]=l+2,d[c+4]=l+2,d[c+5]=l+3,d[c+6]=l+3,d[c+7]=l;for(h=0;h<2;++h)c=8*(u+h),l=4*h,d[c]=l,d[c+1]=l+4,d[c+2]=l+1,d[c+3]=l+5,d[c+4]=l+2,d[c+5]=l+6,d[c+6]=l+3,d[c+7]=l+7;return new Geometry({attributes:s,indices:d,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromVertices(a)})};const GeocodeType={SEARCH:0,AUTOCOMPLETE:1};var GeocodeType$1=Object.freeze(GeocodeType);function GeocoderService(){}function GeometryFactory(){DeveloperError.throwInstantiationError()}function GeometryInstanceAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.value=e.value}function _mergeNamespaces$1(e,t){return t.forEach((function(t){t&&"string"!=typeof t&&!Array.isArray(t)&&Object.keys(t).forEach((function(n){if("default"!==n&&!(n in e)){var i=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,i.get?i:{enumerable:!0,get:function(){return t[n]}})}}))})),Object.freeze(e)}GeocoderService.prototype.geocode=DeveloperError.throwInstantiationError,GeometryFactory.createGeometry=function(e){DeveloperError.throwInstantiationError()};var protobuf=createCommonjsModule((function(module){
/*!
   * protobuf.js v6.7.0 (c) 2016, Daniel Wirtz
   * Compiled Sun, 02 Apr 2017 11:28:29 UTC
   * Licensed under the BSD-3-Clause License
   * see: https://github.com/dcodeIO/protobuf.js for details
   */
(function(global,undefined$1){!function(e,t,n){var i=global.protobuf=function n(i){var r=t[i];return r||e[i][0].call(r=t[i]={exports:{}},n,r,r.exports),r.exports}(n[0]);"function"==typeof undefined$1&&undefined$1.amd&&undefined$1(["long"],(function(e){return e&&e.isLong&&(i.util.Long=e,i.configure()),i})),module&&module.exports&&(module.exports=i)}({1:[function(e,t,n){t.exports=function(e,t){for(var n=[],i=2;i<arguments.length;)n.push(arguments[i++]);var r=!0;return new Promise((function(i,o){n.push((function(e){if(r)if(r=!1,e)o(e);else{for(var t=[],n=1;n<arguments.length;)t.push(arguments[n++]);i.apply(null,t)}}));try{e.apply(t||this,n)}catch(e){r&&(r=!1,o(e))}}))}},{}],2:[function(e,t,n){var i=n;i.length=function(e){var t=e.length;if(!t)return 0;for(var n=0;--t%4>1&&"="===e.charAt(t);)++n;return Math.ceil(3*e.length)/4-n};for(var r=new Array(64),o=new Array(123),a=0;a<64;)o[r[a]=a<26?a+65:a<52?a+71:a<62?a-4:a-59|43]=a++;i.encode=function(e,t,n){for(var i,o=[],a=0,s=0;t<n;){var c=e[t++];switch(s){case 0:o[a++]=r[c>>2],i=(3&c)<<4,s=1;break;case 1:o[a++]=r[i|c>>4],i=(15&c)<<2,s=2;break;case 2:o[a++]=r[i|c>>6],o[a++]=r[63&c],s=0}}return s&&(o[a++]=r[i],o[a]=61,1===s&&(o[a+1]=61)),String.fromCharCode.apply(String,o)};var s="invalid encoding";i.decode=function(e,t,n){for(var i,r=n,a=0,c=0;c<e.length;){var l=e.charCodeAt(c++);if(61===l&&a>1)break;if((l=o[l])===undefined$1)throw Error(s);switch(a){case 0:i=l,a=1;break;case 1:t[n++]=i<<2|(48&l)>>4,i=l,a=2;break;case 2:t[n++]=(15&i)<<4|(60&l)>>2,i=l,a=3;break;case 3:t[n++]=(3&i)<<6|l,a=0}}if(1===a)throw Error(s);return n-r},i.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,n){function i(){this._listeners={}}t.exports=i,i.prototype.on=function(e,t,n){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:n||this}),this},i.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var n=this._listeners[e],i=0;i<n.length;)n[i].fn===t?n.splice(i,1):++i;return this},i.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var n=[],i=1;i<arguments.length;)n.push(arguments[i++]);for(i=0;i<t.length;)t[i].fn.apply(t[i++].ctx,n)}return this}},{}],4:[function(e,t,n){function i(e){return"undefined"!=typeof Float32Array?function(){var t=new Float32Array([-0]),n=new Uint8Array(t.buffer),i=128===n[3];function r(e,i,r){t[0]=e,i[r]=n[0],i[r+1]=n[1],i[r+2]=n[2],i[r+3]=n[3]}function o(e,i,r){t[0]=e,i[r]=n[3],i[r+1]=n[2],i[r+2]=n[1],i[r+3]=n[0]}function a(e,i){return n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],t[0]}function s(e,i){return n[3]=e[i],n[2]=e[i+1],n[1]=e[i+2],n[0]=e[i+3],t[0]}e.writeFloatLE=i?r:o,e.writeFloatBE=i?o:r,e.readFloatLE=i?a:s,e.readFloatBE=i?s:a}():function(){function t(e,t,n,i){var r=t<0?1:0;if(r&&(t=-t),0===t)e(1/t>0?0:2147483648,n,i);else if(isNaN(t))e(2143289344,n,i);else if(t>34028234663852886e22)e((r<<31|2139095040)>>>0,n,i);else if(t<11754943508222875e-54)e((r<<31|Math.round(t/1401298464324817e-60))>>>0,n,i);else{var o=Math.floor(Math.log(t)/Math.LN2);e((r<<31|o+127<<23|8388607&Math.round(t*Math.pow(2,-o)*8388608))>>>0,n,i)}}function n(e,t,n){var i=e(t,n),r=2*(i>>31)+1,o=i>>>23&255,a=8388607&i;return 255===o?a?NaN:r*(1/0):0===o?1401298464324817e-60*r*a:r*Math.pow(2,o-150)*(a+8388608)}e.writeFloatLE=t.bind(null,r),e.writeFloatBE=t.bind(null,o),e.readFloatLE=n.bind(null,a),e.readFloatBE=n.bind(null,s)}(),"undefined"!=typeof Float64Array?function(){var t=new Float64Array([-0]),n=new Uint8Array(t.buffer),i=128===n[7];function r(e,i,r){t[0]=e,i[r]=n[0],i[r+1]=n[1],i[r+2]=n[2],i[r+3]=n[3],i[r+4]=n[4],i[r+5]=n[5],i[r+6]=n[6],i[r+7]=n[7]}function o(e,i,r){t[0]=e,i[r]=n[7],i[r+1]=n[6],i[r+2]=n[5],i[r+3]=n[4],i[r+4]=n[3],i[r+5]=n[2],i[r+6]=n[1],i[r+7]=n[0]}function a(e,i){return n[0]=e[i],n[1]=e[i+1],n[2]=e[i+2],n[3]=e[i+3],n[4]=e[i+4],n[5]=e[i+5],n[6]=e[i+6],n[7]=e[i+7],t[0]}function s(e,i){return n[7]=e[i],n[6]=e[i+1],n[5]=e[i+2],n[4]=e[i+3],n[3]=e[i+4],n[2]=e[i+5],n[1]=e[i+6],n[0]=e[i+7],t[0]}e.writeDoubleLE=i?r:o,e.writeDoubleBE=i?o:r,e.readDoubleLE=i?a:s,e.readDoubleBE=i?s:a}():function(){function t(e,t,n,i,r,o){var a=i<0?1:0;if(a&&(i=-i),0===i)e(0,r,o+t),e(1/i>0?0:2147483648,r,o+n);else if(isNaN(i))e(0,r,o+t),e(2146959360,r,o+n);else if(i>17976931348623157e292)e(0,r,o+t),e((a<<31|2146435072)>>>0,r,o+n);else{var s;if(i<22250738585072014e-324)e((s=i/5e-324)>>>0,r,o+t),e((a<<31|s/4294967296)>>>0,r,o+n);else{var c=Math.floor(Math.log(i)/Math.LN2);1024===c&&(c=1023),e(4503599627370496*(s=i*Math.pow(2,-c))>>>0,r,o+t),e((a<<31|c+1023<<20|1048576*s&1048575)>>>0,r,o+n)}}}function n(e,t,n,i,r){var o=e(i,r+t),a=e(i,r+n),s=2*(a>>31)+1,c=a>>>20&2047,l=4294967296*(1048575&a)+o;return 2047===c?l?NaN:s*(1/0):0===c?5e-324*s*l:s*Math.pow(2,c-1075)*(l+4503599627370496)}e.writeDoubleLE=t.bind(null,r,0,4),e.writeDoubleBE=t.bind(null,o,4,0),e.readDoubleLE=n.bind(null,a,0,4),e.readDoubleBE=n.bind(null,s,4,0)}(),e}function r(e,t,n){t[n]=255&e,t[n+1]=e>>>8&255,t[n+2]=e>>>16&255,t[n+3]=e>>>24}function o(e,t,n){t[n]=e>>>24,t[n+1]=e>>>16&255,t[n+2]=e>>>8&255,t[n+3]=255&e}function a(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24)>>>0}function s(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0}t.exports=i(i)},{}],5:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],6:[function(e,t,n){t.exports=function(e,t,n){var i=n||8192,r=i>>>1,o=null,a=i;return function(n){if(n<1||n>r)return e(n);a+n>i&&(o=e(i),a=0);var s=t.call(o,a,a+=n);return 7&a&&(a=1+(7|a)),s}}},{}],7:[function(e,t,n){var i=n;i.length=function(e){for(var t=0,n=0,i=0;i<e.length;++i)(n=e.charCodeAt(i))<128?t+=1:n<2048?t+=2:55296==(64512&n)&&56320==(64512&e.charCodeAt(i+1))?(++i,t+=4):t+=3;return t},i.read=function(e,t,n){if(n-t<1)return"";for(var i,r=null,o=[],a=0;t<n;)(i=e[t++])<128?o[a++]=i:i>191&&i<224?o[a++]=(31&i)<<6|63&e[t++]:i>239&&i<365?(i=((7&i)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,o[a++]=55296+(i>>10),o[a++]=56320+(1023&i)):o[a++]=(15&i)<<12|(63&e[t++])<<6|63&e[t++],a>8191&&((r||(r=[])).push(String.fromCharCode.apply(String,o)),a=0);return r?(a&&r.push(String.fromCharCode.apply(String,o.slice(0,a))),r.join("")):String.fromCharCode.apply(String,o.slice(0,a))},i.write=function(e,t,n){for(var i,r,o=n,a=0;a<e.length;++a)(i=e.charCodeAt(a))<128?t[n++]=i:i<2048?(t[n++]=i>>6|192,t[n++]=63&i|128):55296==(64512&i)&&56320==(64512&(r=e.charCodeAt(a+1)))?(i=65536+((1023&i)<<10)+(1023&r),++a,t[n++]=i>>18|240,t[n++]=i>>12&63|128,t[n++]=i>>6&63|128,t[n++]=63&i|128):(t[n++]=i>>12|224,t[n++]=i>>6&63|128,t[n++]=63&i|128);return n-o}},{}],8:[function(e,t,n){var i=n;function r(){i.Reader._configure(i.BufferReader),i.util._configure()}i.build="minimal",i.roots={},i.Writer=e(15),i.BufferWriter=e(16),i.Reader=e(9),i.BufferReader=e(10),i.util=e(14),i.rpc=e(11),i.configure=r,i.Writer._configure(i.BufferWriter),r()},{10:10,11:11,14:14,15:15,16:16,9:9}],9:[function(e,t,n){t.exports=c;var i,r=e(14),o=r.LongBits,a=r.utf8;function s(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function c(e){this.buf=e,this.pos=0,this.len=e.length}var l,u="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new c(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new c(e);throw Error("illegal buffer")};function d(){var e=new o(0,0),t=0;if(!(this.len-this.pos>4)){for(;t<3;++t){if(this.pos>=this.len)throw s(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,this.len-this.pos>4){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw s(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function h(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function p(){if(this.pos+8>this.len)throw s(this,8);return new o(h(this.buf,this.pos+=4),h(this.buf,this.pos+=4))}c.create=r.Buffer?function(e){return(c.create=function(e){return r.Buffer.isBuffer(e)?new i(e):u(e)})(e)}:u,c.prototype._slice=r.Array.prototype.subarray||r.Array.prototype.slice,c.prototype.uint32=(l=4294967295,function(){if(l=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return l;if(l=(l|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return l;if(l=(l|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return l;if(l=(l|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return l;if(l=(l|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return l;if((this.pos+=5)>this.len)throw this.pos=this.len,s(this,10);return l}),c.prototype.int32=function(){return 0|this.uint32()},c.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},c.prototype.bool=function(){return 0!==this.uint32()},c.prototype.fixed32=function(){if(this.pos+4>this.len)throw s(this,4);return h(this.buf,this.pos+=4)},c.prototype.sfixed32=function(){if(this.pos+4>this.len)throw s(this,4);return 0|h(this.buf,this.pos+=4)},c.prototype.float=function(){if(this.pos+4>this.len)throw s(this,4);var e=r.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e},c.prototype.double=function(){if(this.pos+8>this.len)throw s(this,4);var e=r.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e},c.prototype.bytes=function(){var e=this.uint32(),t=this.pos,n=this.pos+e;if(n>this.len)throw s(this,e);return this.pos+=e,t===n?new this.buf.constructor(0):this._slice.call(this.buf,t,n)},c.prototype.string=function(){var e=this.bytes();return a.read(e,0,e.length)},c.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw s(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw s(this)}while(128&this.buf[this.pos++]);return this},c.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;;){if(4==(e=7&this.uint32()))break;this.skipType(e)}break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},c._configure=function(e){i=e;var t=r.Long?"toLong":"toNumber";r.merge(c.prototype,{int64:function(){return d.call(this)[t](!1)},uint64:function(){return d.call(this)[t](!0)},sint64:function(){return d.call(this).zzDecode()[t](!1)},fixed64:function(){return p.call(this)[t](!0)},sfixed64:function(){return p.call(this)[t](!1)}})}},{14:14}],10:[function(e,t,n){t.exports=o;var i=e(9);(o.prototype=Object.create(i.prototype)).constructor=o;var r=e(14);function o(e){i.call(this,e)}r.Buffer&&(o.prototype._slice=r.Buffer.prototype.slice),o.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len))}},{14:14,9:9}],11:[function(e,t,n){n.Service=e(12)},{12:12}],12:[function(e,t,n){t.exports=r;var i=e(14);function r(e,t,n){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");i.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(n)}(r.prototype=Object.create(i.EventEmitter.prototype)).constructor=r,r.prototype.rpcCall=function e(t,n,r,o,a){if(!o)throw TypeError("request must be specified");var s=this;if(!a)return i.asPromise(e,s,t,n,r,o);if(!s.rpcImpl)return setTimeout((function(){a(Error("already ended"))}),0),undefined$1;try{return s.rpcImpl(t,n[s.requestDelimited?"encodeDelimited":"encode"](o).finish(),(function(e,n){if(e)return s.emit("error",e,t),a(e);if(null===n)return s.end(!0),undefined$1;if(!(n instanceof r))try{n=r[s.responseDelimited?"decodeDelimited":"decode"](n)}catch(e){return s.emit("error",e,t),a(e)}return s.emit("data",n,t),a(null,n)}))}catch(e){return s.emit("error",e,t),setTimeout((function(){a(e)}),0),undefined$1}},r.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{14:14}],13:[function(e,t,n){t.exports=r;var i=e(14);function r(e,t){this.lo=e>>>0,this.hi=t>>>0}var o=r.zero=new r(0,0);o.toNumber=function(){return 0},o.zzEncode=o.zzDecode=function(){return this},o.length=function(){return 1};var a=r.zeroHash="\0\0\0\0\0\0\0\0";r.fromNumber=function(e){if(0===e)return o;var t=e<0;t&&(e=-e);var n=e>>>0,i=(e-n)/4294967296>>>0;return t&&(i=~i>>>0,n=~n>>>0,++n>4294967295&&(n=0,++i>4294967295&&(i=0))),new r(n,i)},r.from=function(e){if("number"==typeof e)return r.fromNumber(e);if(i.isString(e)){if(!i.Long)return r.fromNumber(parseInt(e,10));e=i.Long.fromString(e)}return e.low||e.high?new r(e.low>>>0,e.high>>>0):o},r.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,n=~this.hi>>>0;return t||(n=n+1>>>0),-(t+4294967296*n)}return this.lo+4294967296*this.hi},r.prototype.toLong=function(e){return i.Long?new i.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var s=String.prototype.charCodeAt;r.fromHash=function(e){return e===a?o:new r((s.call(e,0)|s.call(e,1)<<8|s.call(e,2)<<16|s.call(e,3)<<24)>>>0,(s.call(e,4)|s.call(e,5)<<8|s.call(e,6)<<16|s.call(e,7)<<24)>>>0)},r.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},r.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},r.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},r.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,n=this.hi>>>24;return 0===n?0===t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:n<128?9:10}},{14:14}],14:[function(e,t,n){var i=n;function r(e,t,n){for(var i=Object.keys(t),r=0;r<i.length;++r)e[i[r]]!==undefined$1&&n||(e[i[r]]=t[i[r]]);return e}function o(e){function t(e,n){if(!(this instanceof t))return new t(e,n);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,t):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),n&&r(this,n)}return(t.prototype=Object.create(Error.prototype)).constructor=t,Object.defineProperty(t.prototype,"name",{get:function(){return e}}),t.prototype.toString=function(){return this.name+": "+this.message},t}i.asPromise=e(1),i.base64=e(2),i.EventEmitter=e(3),i.float=e(4),i.inquire=e(5),i.utf8=e(7),i.pool=e(6),i.LongBits=e(13),i.emptyArray=Object.freeze?Object.freeze([]):[],i.emptyObject=Object.freeze?Object.freeze({}):{},i.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node),i.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},i.isString=function(e){return"string"==typeof e||e instanceof String},i.isObject=function(e){return e&&"object"==typeof e},i.isset=i.isSet=function(e,t){var n=e[t];return!(null==n||!e.hasOwnProperty(t))&&("object"!=typeof n||(Array.isArray(n)?n.length:Object.keys(n).length)>0)},i.Buffer=function(){try{var e=i.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),i._Buffer_from=null,i._Buffer_allocUnsafe=null,i.newBuffer=function(e){return"number"==typeof e?i.Buffer?i._Buffer_allocUnsafe(e):new i.Array(e):i.Buffer?i._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},i.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,i.Long=global.dcodeIO&&global.dcodeIO.Long||i.inquire("long"),i.key2Re=/^true|false|0|1$/,i.key32Re=/^-?(?:0|[1-9][0-9]*)$/,i.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,i.longToHash=function(e){return e?i.LongBits.from(e).toHash():i.LongBits.zeroHash},i.longFromHash=function(e,t){var n=i.LongBits.fromHash(e);return i.Long?i.Long.fromBits(n.lo,n.hi,t):n.toNumber(Boolean(t))},i.merge=r,i.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},i.newError=o,i.ProtocolError=o("ProtocolError"),i.oneOfGetter=function(e){for(var t={},n=0;n<e.length;++n)t[e[n]]=1;return function(){for(var e=Object.keys(this),n=e.length-1;n>-1;--n)if(1===t[e[n]]&&this[e[n]]!==undefined$1&&null!==this[e[n]])return e[n]}},i.oneOfSetter=function(e){return function(t){for(var n=0;n<e.length;++n)e[n]!==t&&delete this[e[n]]}},i.lazyResolve=function(e,t){for(var n=0;n<t.length;++n)for(var i=Object.keys(t[n]),r=0;r<i.length;++r){for(var o=t[n][i[r]].split("."),a=e;o.length;)a=a[o.shift()];t[n][i[r]]=a}},i.toJSONOptions={longs:String,enums:String,bytes:String},i._configure=function(){var e=i.Buffer;e?(i._Buffer_from=e.from!==Uint8Array.from&&e.from||function(t,n){return new e(t,n)},i._Buffer_allocUnsafe=e.allocUnsafe||function(t){return new e(t)}):i._Buffer_from=i._Buffer_allocUnsafe=null}},{1:1,13:13,2:2,3:3,4:4,5:5,6:6,7:7}],15:[function(e,t,n){t.exports=d;var i,r=e(14),o=r.LongBits,a=r.base64,s=r.utf8;function c(e,t,n){this.fn=e,this.len=t,this.next=undefined$1,this.val=n}function l(){}function u(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function d(){this.len=0,this.head=new c(l,0,0),this.tail=this.head,this.states=null}function h(e,t,n){t[n]=255&e}function p(e,t){this.len=e,this.next=undefined$1,this.val=t}function f(e,t,n){for(;e.hi;)t[n++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;e.lo>127;)t[n++]=127&e.lo|128,e.lo=e.lo>>>7;t[n++]=e.lo}function m(e,t,n){t[n]=255&e,t[n+1]=e>>>8&255,t[n+2]=e>>>16&255,t[n+3]=e>>>24}d.create=r.Buffer?function(){return(d.create=function(){return new i})()}:function(){return new d},d.alloc=function(e){return new r.Array(e)},r.Array!==Array&&(d.alloc=r.pool(d.alloc,r.Array.prototype.subarray)),d.prototype.push=function(e,t,n){return this.tail=this.tail.next=new c(e,t,n),this.len+=t,this},p.prototype=Object.create(c.prototype),p.prototype.fn=function(e,t,n){for(;e>127;)t[n++]=127&e|128,e>>>=7;t[n]=e},d.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new p((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},d.prototype.int32=function(e){return e<0?this.push(f,10,o.fromNumber(e)):this.uint32(e)},d.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},d.prototype.uint64=function(e){var t=o.from(e);return this.push(f,t.length(),t)},d.prototype.int64=d.prototype.uint64,d.prototype.sint64=function(e){var t=o.from(e).zzEncode();return this.push(f,t.length(),t)},d.prototype.bool=function(e){return this.push(h,1,e?1:0)},d.prototype.fixed32=function(e){return this.push(m,4,e>>>0)},d.prototype.sfixed32=d.prototype.fixed32,d.prototype.fixed64=function(e){var t=o.from(e);return this.push(m,4,t.lo).push(m,4,t.hi)},d.prototype.sfixed64=d.prototype.fixed64,d.prototype.float=function(e){return this.push(r.float.writeFloatLE,4,e)},d.prototype.double=function(e){return this.push(r.float.writeDoubleLE,8,e)};var g=r.Array.prototype.set?function(e,t,n){t.set(e,n)}:function(e,t,n){for(var i=0;i<e.length;++i)t[n+i]=e[i]};d.prototype.bytes=function(e){var t=e.length>>>0;if(!t)return this.push(h,1,0);if(r.isString(e)){var n=d.alloc(t=a.length(e));a.decode(e,n,0),e=n}return this.uint32(t).push(g,t,e)},d.prototype.string=function(e){var t=s.length(e);return t?this.uint32(t).push(s.write,t,e):this.push(h,1,0)},d.prototype.fork=function(){return this.states=new u(this),this.head=this.tail=new c(l,0,0),this.len=0,this},d.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new c(l,0,0),this.len=0),this},d.prototype.ldelim=function(){var e=this.head,t=this.tail,n=this.len;return this.reset().uint32(n),n&&(this.tail.next=e.next,this.tail=t,this.len+=n),this},d.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),n=0;e;)e.fn(e.val,t,n),n+=e.len,e=e.next;return t},d._configure=function(e){i=e}},{14:14}],16:[function(e,t,n){t.exports=a;var i=e(15);(a.prototype=Object.create(i.prototype)).constructor=a;var r=e(14),o=r.Buffer;function a(){i.call(this)}a.alloc=function(e){return(a.alloc=r._Buffer_allocUnsafe)(e)};var s=o&&o.prototype instanceof Uint8Array&&"set"===o.prototype.set.name?function(e,t,n){t.set(e,n)}:function(e,t,n){if(e.copy)e.copy(t,n,0,e.length);else for(var i=0;i<e.length;)t[n++]=e[i++]};function c(e,t,n){e.length<40?r.utf8.write(e,t,n):t.utf8Write(e,n)}a.prototype.bytes=function(e){r.isString(e)&&(e=r._Buffer_from(e,"base64"));var t=e.length>>>0;return this.uint32(t),t&&this.push(s,t,e),this},a.prototype.string=function(e){var t=o.byteLength(e);return this.uint32(t),t&&this.push(c,t,e),this}},{14:14,15:15}]},{},[8])})("object"==typeof window&&window||"object"==typeof self&&self||commonjsGlobal)})),protobuf$1=Object.freeze(_mergeNamespaces$1({__proto__:null,default:protobuf},[protobuf]));function isBitSet(e,t){return 0!=(e&t)}const childrenBitmasks=[1,2,4,8],anyChildBitmask=15,cacheFlagBitmask=16,imageBitmask=64,terrainBitmask=128;function GoogleEarthEnterpriseTileInformation(e,t,n,i,r,o){this._bits=e,this.cnodeVersion=t,this.imageryVersion=n,this.terrainVersion=i,this.imageryProvider=r,this.terrainProvider=o,this.ancestorHasTerrain=!1,this.terrainState=void 0}function stringToBuffer(e){const t=e.length,n=new ArrayBuffer(t),i=new Uint8Array(n);for(let n=0;n<t;++n)i[n]=e.charCodeAt(n);return n}GoogleEarthEnterpriseTileInformation.clone=function(e,t){return defined(t)?(t._bits=e._bits,t.cnodeVersion=e.cnodeVersion,t.imageryVersion=e.imageryVersion,t.terrainVersion=e.terrainVersion,t.imageryProvider=e.imageryProvider,t.terrainProvider=e.terrainProvider):t=new GoogleEarthEnterpriseTileInformation(e._bits,e.cnodeVersion,e.imageryVersion,e.terrainVersion,e.imageryProvider,e.terrainProvider),t.ancestorHasTerrain=e.ancestorHasTerrain,t.terrainState=e.terrainState,t},GoogleEarthEnterpriseTileInformation.prototype.setParent=function(e){this.ancestorHasTerrain=e.ancestorHasTerrain||this.hasTerrain()},GoogleEarthEnterpriseTileInformation.prototype.hasSubtree=function(){return isBitSet(this._bits,cacheFlagBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasImagery=function(){return isBitSet(this._bits,imageBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasTerrain=function(){return isBitSet(this._bits,terrainBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChildren=function(){return isBitSet(this._bits,anyChildBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChild=function(e){return isBitSet(this._bits,childrenBitmasks[e])},GoogleEarthEnterpriseTileInformation.prototype.getChildBitmask=function(){return this._bits&anyChildBitmask};const defaultKey=stringToBuffer('Eô½\vyâjE",ÍqøIFgQ\0B%Æèa,f)\bÆ4Üjb%y\nwmiÖðk¡½NuàA[ß@V\fÙ»r|3SîOlÔq°{ÀEVZ­wUe\v3*¬l5Å0sø3>mF8J´Ýð.ÝuÚDt"úa"\f3"So¯9D\v9Ù9L¹¿«\\P_"uxéqh;ÁÄð<VqH\'UfYNeu£aF}a?A\0×´4MÎF°Õ¸\'{Ü+»Mg0ÈÑö\\Pú[/Fn5/\'C.ë\n\f^¥se4ål.jC\'c#U©?q{gC}:¯ÍâTUýKÆâ/(íË\\Æ-f§;/*"N°k.Ý\r}}GºC²²+>Mª>}æÎIÆæx\fa1-¤O¥~q ì\r1èN\v\0nPh}=\b\r¦n£h$[kó#ó¶s³\r\v@ÀØQ]ú".jßI\0¹ wUÆïj¿{GLîÜÜF©­S+S4ÿYä8è1N¹XFkË-#p\x005"Ï1²&/çÃu-6,rt°#G·ÓÑ&7râ\0DÏÚ3-Þ`i#i*|ÍKQ\rT9w.)ê¦P¢joP\\>TûïP[\vEm(w7ÛJfJo åpâ¹q~\fmI-zþrÇòY0»]såÉ êxì ðB|G`°½&·q¶ÇÑ3=Ó«îcÈ+S D\\qÆÌD2O<ÊÀ)=RÓaX©}e´ÜÏ\rô=ñ\b©BÚ#\tØ¿^PIøMÀËGLO÷{+ØÅ1;µoÜl\rÑÛ?âéÚ_ÔâFaZÞUÏ¤\0¾ýÎgñJiæ HØ]~®q N®ÀV©<rçvì)IÖ]-ãÛ6©;fjÕ¶=P^R¹KÇsWxÉô.YoÐKW>\'\'Ç`Û;íSD>?mw¢\në?R¨ÆU^1I7ôÅ&-©¿\'TÚÃj å*x°Öprªh½÷_H±~ÀXL?fù>áeÀp§Ï8i¯ðVldI\'­xtOÂÞV9\0Úw\vË-û5Oõ\bQ`Á\nZGM&30xÚÀFGâ[y`In7gS\n>éìF9²ñ4\rÆSuná\fYÙÞ){II¥wy¾IV.6ç\v:»Ob{ÒM1/½8{¨O!áìFpv})"x\nÝ\\ÚÞQÏðüYRe|3ßóHÚ»*uÛ`²Ôüíì5¨ÿ(1-ÈÜF|["');function GoogleEarthEnterpriseMetadata(e){let t=e;"string"==typeof t||t instanceof Resource||(t=e.url);const n=Resource.createIfNeeded(t);n.appendForwardSlash(),this._resource=n,this.imageryPresent=!0,this.protoImagery=void 0,this.terrainPresent=!0,this.negativeAltitudeExponentBias=32,this.negativeAltitudeThreshold=CesiumMath.EPSILON12,this.providers={},this.key=void 0,this._quadPacketVersion=1,this._tileInfo={},this._subtreePromises={};const i=this;this._readyPromise=requestDbRoot(this).then((function(){return i.getQuadTreePacket("",i._quadPacketVersion)})).then((function(){return!0})).otherwise((function(e){const t=`An error occurred while accessing ${getMetadataResource(i,"",1).url}.`;return when.reject(new RuntimeError(t))}))}Object.defineProperties(GoogleEarthEnterpriseMetadata.prototype,{url:{get:function(){return this._resource.url}},proxy:{get:function(){return this._resource.proxy}},resource:{get:function(){return this._resource}},readyPromise:{get:function(){return this._readyPromise}}}),GoogleEarthEnterpriseMetadata.tileXYToQuadKey=function(e,t,n){let i="";for(let r=n;r>=0;--r){const n=1<<r;let o=0;isBitSet(t,n)?isBitSet(e,n)&&(o|=1):(o|=2,isBitSet(e,n)||(o|=1)),i+=o}return i},GoogleEarthEnterpriseMetadata.quadKeyToTileXY=function(e){let t=0,n=0;const i=e.length-1;for(let r=i;r>=0;--r){const o=1<<r,a=+e[i-r];isBitSet(a,2)?isBitSet(a,1)||(t|=o):(n|=o,isBitSet(a,1)&&(t|=o))}return{x:t,y:n,level:i}},GoogleEarthEnterpriseMetadata.prototype.isValid=function(e){let t=this.getTileInformationFromQuadKey(e);if(defined(t))return null!==t;let n,i=!0,r=e;for(;r.length>1;){if(n=r.substring(r.length-1),r=r.substring(0,r.length-1),t=this.getTileInformationFromQuadKey(r),defined(t)){t.hasSubtree()||t.hasChild(parseInt(n))||(i=!1);break}if(null===t){i=!1;break}}return i};const taskProcessor$1=new TaskProcessor("decodeGoogleEarthEnterprisePacket");function populateSubtree(e,t,n){const i=e._tileInfo;let r,o=t,a=i[o];if(defined(a)&&(!a.hasSubtree()||a.hasChildren()))return a;for(;void 0===a&&o.length>1;)o=o.substring(0,o.length-1),a=i[o];const s=e._subtreePromises;let c=s[o];return defined(c)?c.then((function(){return r=new Request({throttle:n.throttle,throttleByServer:n.throttleByServer,type:n.type,priorityFunction:n.priorityFunction}),populateSubtree(e,t,r)})):defined(a)&&a.hasSubtree()?(c=e.getQuadTreePacket(o,a.cnodeVersion,n),defined(c)?(s[o]=c,c.then((function(){return r=new Request({throttle:n.throttle,throttleByServer:n.throttleByServer,type:n.type,priorityFunction:n.priorityFunction}),populateSubtree(e,t,r)})).always((function(){delete s[o]}))):void 0):when.reject(new RuntimeError(`Couldn't load metadata for tile ${t}`))}function getMetadataResource(e,t,n,i){return e._resource.getDerivedResource({url:`flatfile?q2-0${t}-q.${n.toString()}`,request:i})}let dbrootParser,dbrootParserPromise;function requestDbRoot(e){const t=e._resource.getDerivedResource({url:"dbRoot.v5",queryParameters:{output:"proto"}});if(!defined(dbrootParserPromise)){const e=buildModuleUrl("ThirdParty/google-earth-dbroot-parser.js"),t=window.cesiumGoogleEarthDbRootParser;dbrootParserPromise=loadAndExecuteScript(e).then((function(){dbrootParser=window.cesiumGoogleEarthDbRootParser(protobuf$1),defined(t)?window.cesiumGoogleEarthDbRootParser=t:delete window.cesiumGoogleEarthDbRootParser}))}return dbrootParserPromise.then((function(){return t.fetchArrayBuffer()})).then((function(t){const n=dbrootParser.EncryptedDbRootProto.decode(new Uint8Array(t));let i=n.encryptionData,r=i.byteOffset,o=r+i.byteLength;const a=e.key=i.buffer.slice(r,o);i=n.dbrootData,r=i.byteOffset,o=r+i.byteLength;const s=i.buffer.slice(r,o);return taskProcessor$1.scheduleTask({buffer:s,type:"DbRoot",key:a},[s])})).then((function(t){const n=dbrootParser.DbRootProto.decode(new Uint8Array(t.buffer));if(e.imageryPresent=defaultValue(n.imageryPresent,e.imageryPresent),e.protoImagery=n.protoImagery,e.terrainPresent=defaultValue(n.terrainPresent,e.terrainPresent),defined(n.endSnippet)&&defined(n.endSnippet.model)){const t=n.endSnippet.model;e.negativeAltitudeExponentBias=defaultValue(t.negativeAltitudeExponentBias,e.negativeAltitudeExponentBias),e.negativeAltitudeThreshold=defaultValue(t.compressedNegativeAltitudeThreshold,e.negativeAltitudeThreshold)}defined(n.databaseVersion)&&(e._quadPacketVersion=defaultValue(n.databaseVersion.quadtreeVersion,e._quadPacketVersion));const i=e.providers,r=defaultValue(n.providerInfo,[]),o=r.length;for(let e=0;e<o;++e){const t=r[e],n=t.copyrightString;defined(n)&&(i[t.providerId]=new Credit(n.value))}})).otherwise((function(){console.log(`Failed to retrieve ${t.url}. Using defaults.`),e.key=defaultKey}))}function GoogleEarthEnterpriseTerrainData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._buffer=e.buffer,this._credits=e.credits,this._negativeAltitudeExponentBias=e.negativeAltitudeExponentBias,this._negativeElevationThreshold=e.negativeElevationThreshold;const t=defaultValue(e.childTileMask,15);let n=3&t;n|=4&t?8:0,n|=8&t?4:0,this._childTileMask=n,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._skirtHeight=void 0,this._bufferType=this._buffer.constructor,this._mesh=void 0,this._minimumHeight=void 0,this._maximumHeight=void 0}GoogleEarthEnterpriseMetadata.prototype.getQuadTreePacket=function(e,t,n){t=defaultValue(t,1);const i=getMetadataResource(this,e=defaultValue(e,""),t,n).fetchArrayBuffer();if(!defined(i))return;const r=this._tileInfo,o=this.key;return i.then((function(t){return taskProcessor$1.scheduleTask({buffer:t,quadKey:e,type:"Metadata",key:o},[t]).then((function(t){let n,i=-1;if(""!==e){i=e.length+1;const o=t[e];n=r[e],n._bits|=o._bits,delete t[e]}const o=Object.keys(t);o.sort((function(e,t){return e.length-t.length}));const a=o.length;for(let e=0;e<a;++e){const a=o[e];if(null!==t[a]){const e=GoogleEarthEnterpriseTileInformation.clone(t[a]),o=a.length;if(o===i)e.setParent(n);else if(o>1){const t=r[a.substring(0,a.length-1)];e.setParent(t)}r[a]=e}else r[a]=null}}))}))},GoogleEarthEnterpriseMetadata.prototype.populateSubtree=function(e,t,n,i){return populateSubtree(this,GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,n),i)},GoogleEarthEnterpriseMetadata.prototype.getTileInformation=function(e,t,n){const i=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,n);return this._tileInfo[i]},GoogleEarthEnterpriseMetadata.prototype.getTileInformationFromQuadKey=function(e){return this._tileInfo[e]},Object.defineProperties(GoogleEarthEnterpriseTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){}}});const createMeshTaskName="createVerticesFromGoogleEarthEnterpriseBuffer",createMeshTaskProcessorNoThrottle=new TaskProcessor(createMeshTaskName),createMeshTaskProcessorThrottle=new TaskProcessor(createMeshTaskName,TerrainData.maximumAsynchronousTasks),nativeRectangleScratch=new Rectangle,rectangleScratch$5=new Rectangle;GoogleEarthEnterpriseTerrainData.prototype.createMesh=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,n=e.x,i=e.y,r=e.level,o=defaultValue(e.exaggeration,1),a=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),c=t.ellipsoid;t.tileXYToNativeRectangle(n,i,r,nativeRectangleScratch),t.tileXYToRectangle(n,i,r,rectangleScratch$5);const l=c.cartographicToCartesian(Rectangle.center(rectangleScratch$5)),u=40075.16/(1<<r);this._skirtHeight=Math.min(8*u,1e3);const d=(s?createMeshTaskProcessorThrottle:createMeshTaskProcessorNoThrottle).scheduleTask({buffer:this._buffer,nativeRectangle:nativeRectangleScratch,rectangle:rectangleScratch$5,relativeToCenter:l,ellipsoid:c,skirtHeight:this._skirtHeight,exaggeration:o,exaggerationRelativeHeight:a,includeWebMercatorT:!0,negativeAltitudeExponentBias:this._negativeAltitudeExponentBias,negativeElevationThreshold:this._negativeElevationThreshold});if(!defined(d))return;const h=this;return d.then((function(e){return h._mesh=new TerrainMesh(l,new Float32Array(e.vertices),new Uint16Array(e.indices),e.indexCountWithoutSkirts,e.vertexCountWithoutSkirts,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),h._minimumHeight=e.minimumHeight,h._maximumHeight=e.maximumHeight,h._buffer=void 0,h._mesh}))},GoogleEarthEnterpriseTerrainData.prototype.interpolateHeight=function(e,t,n){const i=CesiumMath.clamp((t-e.west)/e.width,0,1),r=CesiumMath.clamp((n-e.south)/e.height,0,1);return defined(this._mesh)?interpolateMeshHeight(this,i,r):interpolateHeight(this,i,r,e)};const upsampleTaskProcessor=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);GoogleEarthEnterpriseTerrainData.prototype.upsample=function(e,t,n,i,r,o,a){const s=this._mesh;if(!defined(this._mesh))return;const c=2*t!==r,l=2*n===o,u=e.ellipsoid,d=e.tileXYToRectangle(r,o,a),h=upsampleTaskProcessor.scheduleTask({vertices:s.vertices,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:c,isNorthChild:l,childRectangle:d,ellipsoid:u});if(!defined(h))return;const p=this;return h.then((function(e){const t=new Uint16Array(e.vertices),n=IndexDatatype$1.createTypedArray(t.length/3,e.indices),i=p._skirtHeight;return new QuantizedMeshTerrainData({quantizedVertices:t,indices:n,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:i,southSkirtHeight:i,eastSkirtHeight:i,northSkirtHeight:i,childTileMask:0,createdByUpsampling:!0,credits:p._credits})}))},GoogleEarthEnterpriseTerrainData.prototype.isChildAvailable=function(e,t,n,i){let r=2;return n!==2*e&&++r,i!==2*t&&(r-=2),0!=(this._childTileMask&1<<r)},GoogleEarthEnterpriseTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};const texCoordScratch0=new Cartesian2,texCoordScratch1=new Cartesian2,texCoordScratch2=new Cartesian2,barycentricCoordinateScratch=new Cartesian3;function interpolateMeshHeight(e,t,n){const i=e._mesh,r=i.vertices,o=i.encoding,a=i.indices;for(let e=0,i=a.length;e<i;e+=3){const i=a[e],s=a[e+1],c=a[e+2],l=o.decodeTextureCoordinates(r,i,texCoordScratch0),u=o.decodeTextureCoordinates(r,s,texCoordScratch1),d=o.decodeTextureCoordinates(r,c,texCoordScratch2),h=Intersections2D.computeBarycentricCoordinates(t,n,l.x,l.y,u.x,u.y,d.x,d.y,barycentricCoordinateScratch);if(h.x>=-1e-15&&h.y>=-1e-15&&h.z>=-1e-15){const e=o.decodeHeight(r,i),t=o.decodeHeight(r,s),n=o.decodeHeight(r,c);return h.x*e+h.y*t+h.z*n}}}const sizeOfUint16=Uint16Array.BYTES_PER_ELEMENT,sizeOfUint32$7=Uint32Array.BYTES_PER_ELEMENT,sizeOfInt32=Int32Array.BYTES_PER_ELEMENT,sizeOfFloat=Float32Array.BYTES_PER_ELEMENT,sizeOfDouble=Float64Array.BYTES_PER_ELEMENT;function interpolateHeight(e,t,n,i){const r=e._buffer;let o=0,a=0,s=0;n>.5?(t>.5?(o=2,a=.5):o=3,s=.5):t>.5&&(o=1,a=.5);const c=new DataView(r);let l=0;for(let e=0;e<o;++e)l+=c.getUint32(l,!0),l+=sizeOfUint32$7;l+=sizeOfUint32$7,l+=2*sizeOfDouble;const u=CesiumMath.toRadians(180*c.getFloat64(l,!0));l+=sizeOfDouble;const d=CesiumMath.toRadians(180*c.getFloat64(l,!0));l+=sizeOfDouble;const h=i.width/u/2,p=i.height/d/2,f=c.getInt32(l,!0);l+=sizeOfInt32;const m=3*c.getInt32(l,!0);l+=sizeOfInt32,l+=sizeOfInt32;const g=new Array(f),_=new Array(f),y=new Array(f);let C;for(C=0;C<f;++C)g[C]=a+c.getUint8(l++)*h,_[C]=s+c.getUint8(l++)*p,y[C]=6371010*c.getFloat32(l,!0),l+=sizeOfFloat;const T=new Array(m);for(C=0;C<m;++C)T[C]=c.getUint16(l,!0),l+=sizeOfUint16;for(C=0;C<m;C+=3){const e=T[C],i=T[C+1],r=T[C+2],o=g[e],a=g[i],s=g[r],c=_[e],l=_[i],u=_[r],d=Intersections2D.computeBarycentricCoordinates(t,n,o,c,a,l,s,u,barycentricCoordinateScratch);if(d.x>=-1e-15&&d.y>=-1e-15&&d.z>=-1e-15)return d.x*y[e]+d.y*y[i]+d.z*y[r]}}const TerrainState$2={UNKNOWN:0,NONE:1,SELF:2,PARENT:3},julianDateScratch=new JulianDate;function TerrainCache(){this._terrainCache={},this._lastTidy=JulianDate.now()}function GoogleEarthEnterpriseTerrainProvider(e){let t;if(defined((e=defaultValue(e,defaultValue.EMPTY_OBJECT)).metadata))t=e.metadata;else{const n=Resource.createIfNeeded(e.url);t=new GoogleEarthEnterpriseMetadata(n)}this._metadata=t,this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,rectangle:new Rectangle(-CesiumMath.PI,-CesiumMath.PI,CesiumMath.PI,CesiumMath.PI),ellipsoid:e.ellipsoid});let n=e.credit;"string"==typeof n&&(n=new Credit(n)),this._credit=n,this._levelZeroMaximumGeometricError=40075.16,this._terrainCache=new TerrainCache,this._terrainPromises={},this._terrainRequests={},this._errorEvent=new Event,this._ready=!1;const i=this;let r;this._readyPromise=t.readyPromise.then((function(e){if(!t.terrainPresent){const e=new RuntimeError(`The server ${t.url} doesn't have terrain`);return r=TileProviderError.handleError(r,i,i._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)}return TileProviderError.handleSuccess(r),i._ready=e,e})).otherwise((function(e){return r=TileProviderError.handleError(r,i,i._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)}))}TerrainCache.prototype.add=function(e,t){this._terrainCache[e]={buffer:t,timestamp:JulianDate.now()}},TerrainCache.prototype.get=function(e){const t=this._terrainCache[e];if(defined(t))return delete this._terrainCache[e],t.buffer},TerrainCache.prototype.tidy=function(){if(JulianDate.now(julianDateScratch),JulianDate.secondsDifference(julianDateScratch,this._lastTidy)>10){const e=this._terrainCache,t=Object.keys(e),n=t.length;for(let i=0;i<n;++i){const n=t[i],r=e[n];JulianDate.secondsDifference(julianDateScratch,r.timestamp)>10&&delete e[n]}JulianDate.clone(julianDateScratch,this._lastTidy)}},Object.defineProperties(GoogleEarthEnterpriseTerrainProvider.prototype,{url:{get:function(){return this._metadata.url}},proxy:{get:function(){return this._metadata.proxy}},tilingScheme:{get:function(){return this._tilingScheme}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},credit:{get:function(){return this._credit}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}});const taskProcessor=new TaskProcessor("decodeGoogleEarthEnterprisePacket");function computeChildMask(e,t,n){let i=t.getChildBitmask();if(t.terrainState===TerrainState$2.PARENT){i=0;for(let t=0;t<4;++t){const r=n.getTileInformationFromQuadKey(e+t.toString());defined(r)&&r.hasTerrain()&&(i|=1<<t)}}return i}function buildTerrainResource(e,t,n,i){return n=defined(n)&&n>0?n:1,e._metadata.resource.getDerivedResource({url:`flatfile?f1c-0${t}-t.${n.toString()}`,request:i})}GoogleEarthEnterpriseTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){const r=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,n),o=this._terrainCache,a=this._metadata,s=a.getTileInformationFromQuadKey(r);if(!defined(s))return when.reject(new RuntimeError("Terrain tile doesn't exist"));let c=s.terrainState;defined(c)||(c=s.terrainState=TerrainState$2.UNKNOWN);const l=o.get(r);if(defined(l)){const e=a.providers[s.terrainProvider];return when.resolve(new GoogleEarthEnterpriseTerrainData({buffer:l,childTileMask:computeChildMask(r,s,a),credits:defined(e)?[e]:void 0,negativeAltitudeExponentBias:a.negativeAltitudeExponentBias,negativeElevationThreshold:a.negativeAltitudeThreshold}))}if(o.tidy(),!s.ancestorHasTerrain)return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}));if(c===TerrainState$2.NONE)return when.reject(new RuntimeError("Terrain tile doesn't exist"));let u,d=r,h=-1;switch(c){case TerrainState$2.SELF:h=s.terrainVersion;break;case TerrainState$2.PARENT:d=d.substring(0,d.length-1),u=a.getTileInformationFromQuadKey(d),h=u.terrainVersion;break;case TerrainState$2.UNKNOWN:s.hasTerrain()?h=s.terrainVersion:(d=d.substring(0,d.length-1),u=a.getTileInformationFromQuadKey(d),defined(u)&&u.hasTerrain()&&(h=u.terrainVersion))}if(h<0)return when.reject(new RuntimeError("Terrain tile doesn't exist"));const p=this._terrainPromises,f=this._terrainRequests;let m,g;if(defined(p[d]))m=p[d],g=f[d];else{g=i;const e=buildTerrainResource(this,d,h,g).fetchArrayBuffer();if(!defined(e))return;m=e.then((function(e){return defined(e)?taskProcessor.scheduleTask({buffer:e,type:"Terrain",key:a.key},[e]).then((function(e){const t=a.getTileInformationFromQuadKey(d);t.terrainState=TerrainState$2.SELF,o.add(d,e[0]);const n=t.terrainProvider,i=e.length-1;for(let t=0;t<i;++t){const i=d+t.toString(),r=a.getTileInformationFromQuadKey(i);defined(r)&&(o.add(i,e[t+1]),r.terrainState=TerrainState$2.PARENT,0===r.terrainProvider&&(r.terrainProvider=n))}})):when.reject(new RuntimeError("Failed to load terrain."))})),p[d]=m,f[d]=g,m=m.always((function(){delete p[d],delete f[d]}))}return m.then((function(){const e=o.get(r);if(defined(e)){const t=a.providers[s.terrainProvider];return new GoogleEarthEnterpriseTerrainData({buffer:e,childTileMask:computeChildMask(r,s,a),credits:defined(t)?[t]:void 0,negativeAltitudeExponentBias:a.negativeAltitudeExponentBias,negativeElevationThreshold:a.negativeAltitudeThreshold})}return when.reject(new RuntimeError("Failed to load terrain."))})).otherwise((function(e){return g.state===RequestState$1.CANCELLED?(i.state=g.state,when.reject(e)):(s.terrainState=TerrainState$2.NONE,when.reject(e))}))},GoogleEarthEnterpriseTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},GoogleEarthEnterpriseTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){const i=this._metadata;let r=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,n);const o=i.getTileInformation(e,t,n);if(null===o)return!1;if(defined(o)){if(!o.ancestorHasTerrain)return!0;const e=o.terrainState;if(e===TerrainState$2.NONE)return!1;if(!(defined(e)&&e!==TerrainState$2.UNKNOWN||(o.terrainState=TerrainState$2.UNKNOWN,o.hasTerrain()))){r=r.substring(0,r.length-1);const e=i.getTileInformationFromQuadKey(r);if(!defined(e)||!e.hasTerrain())return!1}return!0}if(i.isValid(r)){const r=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN});i.populateSubtree(e,t,n,r)}return!1},GoogleEarthEnterpriseTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){};const PROJECTIONS=[GeographicProjection,WebMercatorProjection],PROJECTION_COUNT=PROJECTIONS.length,MITER_BREAK_SMALL=Math.cos(CesiumMath.toRadians(30)),MITER_BREAK_LARGE=Math.cos(CesiumMath.toRadians(150)),WALL_INITIAL_MIN_HEIGHT=0,WALL_INITIAL_MAX_HEIGHT=1e3;function GroundPolylineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;this.width=defaultValue(e.width,1),this._positions=t,this.granularity=defaultValue(e.granularity,9999),this.loop=defaultValue(e.loop,!1),this.arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._ellipsoid=Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(GroundPolylineGeometry.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+Ellipsoid.packedLength+1+1}}}),GroundPolylineGeometry.setProjectionAndEllipsoid=function(e,t){let n=0;for(let e=0;e<PROJECTION_COUNT;e++)if(t instanceof PROJECTIONS[e]){n=e;break}e._projectionIndex=n,e._ellipsoid=t.ellipsoid};const cart3Scratch1=new Cartesian3,cart3Scratch2=new Cartesian3,cart3Scratch3=new Cartesian3;function computeRightNormal(e,t,n,i,r){const o=getPosition$2(i,e,0,cart3Scratch1),a=getPosition$2(i,e,n,cart3Scratch2),s=getPosition$2(i,t,0,cart3Scratch3),c=direction(a,o,cart3Scratch2),l=direction(s,o,cart3Scratch3);return Cartesian3.cross(l,c,r),Cartesian3.normalize(r,r)}const interpolatedCartographicScratch$1=new Cartographic,interpolatedBottomScratch=new Cartesian3,interpolatedTopScratch=new Cartesian3,interpolatedNormalScratch=new Cartesian3;function interpolateSegment(e,t,n,i,r,o,a,s,c,l,u){if(0===r)return;let d;o===ArcType$1.GEODESIC?d=new EllipsoidGeodesic(e,t,a):o===ArcType$1.RHUMB&&(d=new EllipsoidRhumbLine(e,t,a));const h=d.surfaceDistance;if(h<r)return;const p=computeRightNormal(e,t,i,a,interpolatedNormalScratch),f=Math.ceil(h/r),m=h/f;let g=m;const _=f-1;let y=s.length;for(let e=0;e<_;e++){const e=d.interpolateUsingSurfaceDistance(g,interpolatedCartographicScratch$1),t=getPosition$2(a,e,n,interpolatedBottomScratch),r=getPosition$2(a,e,i,interpolatedTopScratch);Cartesian3.pack(p,s,y),Cartesian3.pack(t,c,y),Cartesian3.pack(r,l,y),u.push(e.latitude),u.push(e.longitude),y+=3,g+=m}}const heightlessCartographicScratch=new Cartographic;function getPosition$2(e,t,n,i){return Cartographic.clone(t,heightlessCartographicScratch),heightlessCartographicScratch.height=n,Cartographic.toCartesian(heightlessCartographicScratch,e,i)}function direction(e,t,n){return Cartesian3.subtract(e,t,n),Cartesian3.normalize(n,n),n}function tangentDirection(e,t,n,i){return i=direction(e,t,i),i=Cartesian3.cross(i,n,i),i=Cartesian3.normalize(i,i),i=Cartesian3.cross(n,i,i)}GroundPolylineGeometry.pack=function(e,t,n){let i=defaultValue(n,0);const r=e._positions,o=r.length;t[i++]=o;for(let e=0;e<o;++e){const n=r[e];Cartesian3.pack(n,t,i),i+=3}return t[i++]=e.granularity,t[i++]=e.loop?1:0,t[i++]=e.arcType,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._projectionIndex,t[i++]=e._scene3DOnly?1:0,t},GroundPolylineGeometry.unpack=function(e,t,n){let i=defaultValue(t,0);const r=e[i++],o=new Array(r);for(let t=0;t<r;t++)o[t]=Cartesian3.unpack(e,i),i+=3;const a=e[i++],s=1===e[i++],c=e[i++],l=Ellipsoid.unpack(e,i);i+=Ellipsoid.packedLength;const u=e[i++],d=1===e[i++];return defined(n)||(n=new GroundPolylineGeometry({positions:o})),n._positions=o,n.granularity=a,n.loop=s,n.arcType=c,n._ellipsoid=l,n._projectionIndex=u,n._scene3DOnly=d,n};const toPreviousScratch=new Cartesian3,toNextScratch=new Cartesian3,forwardScratch=new Cartesian3,vertexUpScratch=new Cartesian3,cosine90=0,cosine180=-1;function computeVertexMiterNormal(e,t,n,i,r){const o=direction(n,t,vertexUpScratch),a=tangentDirection(e,t,o,toPreviousScratch),s=tangentDirection(i,t,o,toNextScratch);if(CesiumMath.equalsEpsilon(Cartesian3.dot(a,s),cosine180,CesiumMath.EPSILON5))return r=Cartesian3.cross(o,a,r),r=Cartesian3.normalize(r,r);r=Cartesian3.add(s,a,r),r=Cartesian3.normalize(r,r);const c=Cartesian3.cross(o,r,forwardScratch);return Cartesian3.dot(s,c)<cosine90&&(r=Cartesian3.negate(r,r)),r}const XZ_PLANE=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),previousBottomScratch=new Cartesian3,vertexBottomScratch=new Cartesian3,vertexTopScratch=new Cartesian3,nextBottomScratch=new Cartesian3,vertexNormalScratch=new Cartesian3,intersectionScratch$1=new Cartesian3,cartographicScratch0=new Cartographic,cartographicScratch1=new Cartographic,cartographicIntersectionScratch=new Cartographic;GroundPolylineGeometry.createGeometry=function(e){const t=!e._scene3DOnly;let n=e.loop;const i=e._ellipsoid,r=e.granularity,o=e.arcType,a=new PROJECTIONS[e._projectionIndex](i),s=WALL_INITIAL_MIN_HEIGHT,c=WALL_INITIAL_MAX_HEIGHT;let l,u;const d=e._positions,h=d.length;let p,f,m,g;2===h&&(n=!1);const _=new EllipsoidRhumbLine(void 0,void 0,i);let y,C,T;const S=[d[0]];for(u=0;u<h-1;u++)p=d[u],f=d[u+1],y=IntersectionTests.lineSegmentPlane(p,f,XZ_PLANE,intersectionScratch$1),!defined(y)||Cartesian3.equalsEpsilon(y,p,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(y,f,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?S.push(Cartesian3.clone(y)):e.arcType===ArcType$1.RHUMB&&(T=i.cartesianToCartographic(y,cartographicScratch0).longitude,m=i.cartesianToCartographic(p,cartographicScratch0),g=i.cartesianToCartographic(f,cartographicScratch1),_.setEndPoints(m,g),C=_.findIntersectionWithLongitude(T,cartographicIntersectionScratch),y=i.cartographicToCartesian(C,intersectionScratch$1),!defined(y)||Cartesian3.equalsEpsilon(y,p,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(y,f,CesiumMath.EPSILON7)||S.push(Cartesian3.clone(y)))),S.push(f);n&&(p=d[h-1],f=d[0],y=IntersectionTests.lineSegmentPlane(p,f,XZ_PLANE,intersectionScratch$1),!defined(y)||Cartesian3.equalsEpsilon(y,p,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(y,f,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?S.push(Cartesian3.clone(y)):e.arcType===ArcType$1.RHUMB&&(T=i.cartesianToCartographic(y,cartographicScratch0).longitude,m=i.cartesianToCartographic(p,cartographicScratch0),g=i.cartesianToCartographic(f,cartographicScratch1),_.setEndPoints(m,g),C=_.findIntersectionWithLongitude(T,cartographicIntersectionScratch),y=i.cartographicToCartesian(C,intersectionScratch$1),!defined(y)||Cartesian3.equalsEpsilon(y,p,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(y,f,CesiumMath.EPSILON7)||S.push(Cartesian3.clone(y)))));let A=S.length,v=new Array(A);for(u=0;u<A;u++){const e=Cartographic.fromCartesian(S[u],i);e.height=0,v[u]=e}if(v=arrayRemoveDuplicates(v,Cartographic.equalsEpsilon),A=v.length,A<2)return;const E=[],b=[],x=[],P=[];let D=previousBottomScratch,w=vertexBottomScratch,M=vertexTopScratch,I=nextBottomScratch,R=vertexNormalScratch;const O=v[0],B=v[1];for(D=getPosition$2(i,v[A-1],s,D),I=getPosition$2(i,B,s,I),w=getPosition$2(i,O,s,w),M=getPosition$2(i,O,c,M),R=n?computeVertexMiterNormal(D,w,M,I,R):computeRightNormal(O,B,c,i,R),Cartesian3.pack(R,b,0),Cartesian3.pack(w,x,0),Cartesian3.pack(M,P,0),E.push(O.latitude),E.push(O.longitude),interpolateSegment(O,B,s,c,r,o,i,b,x,P,E),u=1;u<A-1;++u){D=Cartesian3.clone(w,D),w=Cartesian3.clone(I,w);const e=v[u];getPosition$2(i,e,c,M),getPosition$2(i,v[u+1],s,I),computeVertexMiterNormal(D,w,M,I,R),l=b.length,Cartesian3.pack(R,b,l),Cartesian3.pack(w,x,l),Cartesian3.pack(M,P,l),E.push(e.latitude),E.push(e.longitude),interpolateSegment(v[u],v[u+1],s,c,r,o,i,b,x,P,E)}const L=v[A-1],F=v[A-2];if(w=getPosition$2(i,L,s,w),M=getPosition$2(i,L,c,M),n){const e=v[0];D=getPosition$2(i,F,s,D),I=getPosition$2(i,e,s,I),R=computeVertexMiterNormal(D,w,M,I,R)}else R=computeRightNormal(F,L,c,i,R);if(l=b.length,Cartesian3.pack(R,b,l),Cartesian3.pack(w,x,l),Cartesian3.pack(M,P,l),E.push(L.latitude),E.push(L.longitude),n){for(interpolateSegment(L,O,s,c,r,o,i,b,x,P,E),l=b.length,u=0;u<3;++u)b[l+u]=b[u],x[l+u]=x[u],P[l+u]=P[u];E.push(O.latitude),E.push(O.longitude)}return generateGeometryAttributes(n,a,x,P,b,E,t)};const lineDirectionScratch=new Cartesian3,matrix3Scratch$1=new Matrix3,quaternionScratch$1=new Quaternion;function breakMiter(e,t,n,i){const r=direction(n,t,lineDirectionScratch),o=Cartesian3.dot(r,e);if(o>MITER_BREAK_SMALL||o<MITER_BREAK_LARGE){const t=direction(i,n,vertexUpScratch),r=o<MITER_BREAK_LARGE?CesiumMath.PI_OVER_TWO:-CesiumMath.PI_OVER_TWO,a=Quaternion.fromAxisAngle(t,r,quaternionScratch$1),s=Matrix3.fromQuaternion(a,matrix3Scratch$1);return Matrix3.multiplyByVector(s,e,e),!0}return!1}const endPosCartographicScratch=new Cartographic,normalStartpointScratch=new Cartesian3,normalEndpointScratch=new Cartesian3;function projectNormal(e,t,n,i,r){const o=Cartographic.toCartesian(t,e._ellipsoid,normalStartpointScratch);let a=Cartesian3.add(o,n,normalEndpointScratch),s=!1;const c=e._ellipsoid;let l=c.cartesianToCartographic(a,endPosCartographicScratch);Math.abs(t.longitude-l.longitude)>CesiumMath.PI_OVER_TWO&&(s=!0,a=Cartesian3.subtract(o,n,normalEndpointScratch),l=c.cartesianToCartographic(a,endPosCartographicScratch)),l.height=0;const u=e.project(l,r);return(r=Cartesian3.subtract(u,i,r)).z=0,r=Cartesian3.normalize(r,r),s&&Cartesian3.negate(r,r),r}const adjustHeightNormalScratch=new Cartesian3,adjustHeightOffsetScratch=new Cartesian3;function adjustHeights(e,t,n,i,r,o){const a=Cartesian3.subtract(t,e,adjustHeightNormalScratch);Cartesian3.normalize(a,a);const s=n-WALL_INITIAL_MIN_HEIGHT;let c=Cartesian3.multiplyByScalar(a,s,adjustHeightOffsetScratch);Cartesian3.add(e,c,r);const l=i-WALL_INITIAL_MAX_HEIGHT;c=Cartesian3.multiplyByScalar(a,l,adjustHeightOffsetScratch),Cartesian3.add(t,c,o)}const nudgeDirectionScratch=new Cartesian3;function nudgeXZ(e,t){const n=Plane.getPointDistance(XZ_PLANE,e),i=Plane.getPointDistance(XZ_PLANE,t);let r=nudgeDirectionScratch;CesiumMath.equalsEpsilon(n,0,CesiumMath.EPSILON2)?(r=direction(t,e,r),Cartesian3.multiplyByScalar(r,CesiumMath.EPSILON2,r),Cartesian3.add(e,r,e)):CesiumMath.equalsEpsilon(i,0,CesiumMath.EPSILON2)&&(r=direction(e,t,r),Cartesian3.multiplyByScalar(r,CesiumMath.EPSILON2,r),Cartesian3.add(t,r,t))}function nudgeCartographic(e,t){const n=Math.abs(e.longitude),i=Math.abs(t.longitude);if(CesiumMath.equalsEpsilon(n,CesiumMath.PI,CesiumMath.EPSILON11)){const i=CesiumMath.sign(t.longitude);return e.longitude=i*(n-CesiumMath.EPSILON11),1}if(CesiumMath.equalsEpsilon(i,CesiumMath.PI,CesiumMath.EPSILON11)){const n=CesiumMath.sign(e.longitude);return t.longitude=n*(i-CesiumMath.EPSILON11),2}return 0}const startCartographicScratch$1=new Cartographic,endCartographicScratch$1=new Cartographic,segmentStartTopScratch=new Cartesian3,segmentEndTopScratch=new Cartesian3,segmentStartBottomScratch=new Cartesian3,segmentEndBottomScratch=new Cartesian3,segmentStartNormalScratch=new Cartesian3,segmentEndNormalScratch=new Cartesian3,getHeightCartographics=[startCartographicScratch$1,endCartographicScratch$1],getHeightRectangleScratch=new Rectangle,adjustHeightStartTopScratch=new Cartesian3,adjustHeightEndTopScratch=new Cartesian3,adjustHeightStartBottomScratch=new Cartesian3,adjustHeightEndBottomScratch=new Cartesian3,segmentStart2DScratch=new Cartesian3,segmentEnd2DScratch=new Cartesian3,segmentStartNormal2DScratch=new Cartesian3,segmentEndNormal2DScratch=new Cartesian3,offsetScratch$b=new Cartesian3,startUpScratch=new Cartesian3,endUpScratch=new Cartesian3,rightScratch=new Cartesian3,startPlaneNormalScratch=new Cartesian3,endPlaneNormalScratch=new Cartesian3,encodeScratch$1=new EncodedCartesian3,encodeScratch2D=new EncodedCartesian3,forwardOffset2DScratch=new Cartesian3,right2DScratch=new Cartesian3,normalNudgeScratch=new Cartesian3,scratchBoundingSpheres=[new BoundingSphere,new BoundingSphere],REFERENCE_INDICES=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],REFERENCE_INDICES_LENGTH=REFERENCE_INDICES.length;function generateGeometryAttributes(e,t,n,i,r,o,a){let s,c;const l=t._ellipsoid,u=n.length/3-1,d=8*u,h=4*d,p=36*u,f=d>65535?new Uint32Array(p):new Uint16Array(p),m=new Float64Array(3*d),g=new Float32Array(h),_=new Float32Array(h),y=new Float32Array(h),C=new Float32Array(h),T=new Float32Array(h);let S,A,v,E;a&&(S=new Float32Array(h),A=new Float32Array(h),v=new Float32Array(h),E=new Float32Array(2*d));const b=o.length/2;let x=0;const P=startCartographicScratch$1;P.height=0;const D=endCartographicScratch$1;D.height=0;let w=segmentStartTopScratch,M=segmentEndTopScratch;if(a)for(c=0,s=1;s<b;s++)P.latitude=o[c],P.longitude=o[c+1],D.latitude=o[c+2],D.longitude=o[c+3],w=t.project(P,w),M=t.project(D,M),x+=Cartesian3.distance(w,M),c+=2;const I=i.length/3;M=Cartesian3.unpack(i,0,M);let R,O=0;for(c=3,s=1;s<I;s++)w=Cartesian3.clone(M,w),M=Cartesian3.unpack(i,c,M),O+=Cartesian3.distance(w,M),c+=3;c=3;let B=0,L=0,F=0,N=0,V=!1,$=Cartesian3.unpack(n,0,segmentEndBottomScratch),k=Cartesian3.unpack(i,0,segmentEndTopScratch),U=Cartesian3.unpack(r,0,segmentEndNormalScratch);if(e){breakMiter(U,Cartesian3.unpack(n,n.length-6,segmentStartBottomScratch),$,k)&&(U=Cartesian3.negate(U,U))}let G=0,z=0,H=0;for(s=0;s<u;s++){const e=Cartesian3.clone($,segmentStartBottomScratch),s=Cartesian3.clone(k,segmentStartTopScratch);let u,d,h,p,f=Cartesian3.clone(U,segmentStartNormalScratch);if(V&&(f=Cartesian3.negate(f,f)),$=Cartesian3.unpack(n,c,segmentEndBottomScratch),k=Cartesian3.unpack(i,c,segmentEndTopScratch),U=Cartesian3.unpack(r,c,segmentEndNormalScratch),V=breakMiter(U,e,$,k),P.latitude=o[B],P.longitude=o[B+1],D.latitude=o[B+2],D.longitude=o[B+3],a){const e=nudgeCartographic(P,D);u=t.project(P,segmentStart2DScratch),d=t.project(D,segmentEnd2DScratch);const n=direction(d,u,forwardOffset2DScratch);n.y=Math.abs(n.y),h=segmentStartNormal2DScratch,p=segmentEndNormal2DScratch,0===e||Cartesian3.dot(n,Cartesian3.UNIT_Y)>MITER_BREAK_SMALL?(h=projectNormal(t,P,f,u,segmentStartNormal2DScratch),p=projectNormal(t,D,U,d,segmentEndNormal2DScratch)):1===e?(p=projectNormal(t,D,U,d,segmentEndNormal2DScratch),h.x=0,h.y=CesiumMath.sign(P.longitude-Math.abs(D.longitude)),h.z=0):(h=projectNormal(t,P,f,u,segmentStartNormal2DScratch),p.x=0,p.y=CesiumMath.sign(P.longitude-D.longitude),p.z=0)}const b=Cartesian3.distance(s,k),w=EncodedCartesian3.fromCartesian(e,encodeScratch$1),M=Cartesian3.subtract($,e,offsetScratch$b),I=Cartesian3.normalize(M,rightScratch);let W=Cartesian3.subtract(s,e,startUpScratch);W=Cartesian3.normalize(W,W);let q=Cartesian3.cross(I,W,rightScratch);q=Cartesian3.normalize(q,q);let j=Cartesian3.cross(W,f,startPlaneNormalScratch);j=Cartesian3.normalize(j,j);let X=Cartesian3.subtract(k,$,endUpScratch);X=Cartesian3.normalize(X,X);let Y=Cartesian3.cross(U,X,endPlaneNormalScratch);Y=Cartesian3.normalize(Y,Y);const K=b/O,J=G/O;let Q,Z,ee,te=0,ne=0,ie=0;if(a){te=Cartesian3.distance(u,d),Q=EncodedCartesian3.fromCartesian(u,encodeScratch2D),Z=Cartesian3.subtract(d,u,forwardOffset2DScratch),ee=Cartesian3.normalize(Z,right2DScratch);const e=ee.x;ee.x=ee.y,ee.y=-e,ne=te/x,ie=z/x}for(R=0;R<8;R++){const e=N+4*R,t=L+2*R,n=e+3,i=R<4?1:-1,r=2===R||3===R||6===R||7===R?1:-1;Cartesian3.pack(w.high,g,e),g[n]=M.x,Cartesian3.pack(w.low,_,e),_[n]=M.y,Cartesian3.pack(j,y,e),y[n]=M.z,Cartesian3.pack(Y,C,e),C[n]=K*i,Cartesian3.pack(q,T,e);let o=J*r;0===o&&r<0&&(o=9),T[n]=o,a&&(S[e]=Q.high.x,S[e+1]=Q.high.y,S[e+2]=Q.low.x,S[e+3]=Q.low.y,v[e]=-h.y,v[e+1]=h.x,v[e+2]=p.y,v[e+3]=-p.x,A[e]=Z.x,A[e+1]=Z.y,A[e+2]=ee.x,A[e+3]=ee.y,E[t]=ne*i,o=ie*r,0===o&&r<0&&(o=9),E[t+1]=o)}const re=adjustHeightStartBottomScratch,oe=adjustHeightEndBottomScratch,ae=adjustHeightStartTopScratch,se=adjustHeightEndTopScratch,ce=Rectangle.fromCartographicArray(getHeightCartographics,getHeightRectangleScratch),le=ApproximateTerrainHeights.getMinimumMaximumHeights(ce,l),ue=le.minimumTerrainHeight,de=le.maximumTerrainHeight;H+=ue,H+=de,adjustHeights(e,s,ue,de,re,ae),adjustHeights($,k,ue,de,oe,se);let he=Cartesian3.multiplyByScalar(q,CesiumMath.EPSILON5,normalNudgeScratch);Cartesian3.add(re,he,re),Cartesian3.add(oe,he,oe),Cartesian3.add(ae,he,ae),Cartesian3.add(se,he,se),nudgeXZ(re,oe),nudgeXZ(ae,se),Cartesian3.pack(re,m,F),Cartesian3.pack(oe,m,F+3),Cartesian3.pack(se,m,F+6),Cartesian3.pack(ae,m,F+9),he=Cartesian3.multiplyByScalar(q,-2*CesiumMath.EPSILON5,normalNudgeScratch),Cartesian3.add(re,he,re),Cartesian3.add(oe,he,oe),Cartesian3.add(ae,he,ae),Cartesian3.add(se,he,se),nudgeXZ(re,oe),nudgeXZ(ae,se),Cartesian3.pack(re,m,F+12),Cartesian3.pack(oe,m,F+15),Cartesian3.pack(se,m,F+18),Cartesian3.pack(ae,m,F+21),B+=2,c+=3,L+=16,F+=24,N+=32,G+=b,z+=te}c=0;let W=0;for(s=0;s<u;s++){for(R=0;R<REFERENCE_INDICES_LENGTH;R++)f[c+R]=REFERENCE_INDICES[R]+W;W+=8,c+=REFERENCE_INDICES_LENGTH}const q=scratchBoundingSpheres;BoundingSphere.fromVertices(n,Cartesian3.ZERO,3,q[0]),BoundingSphere.fromVertices(i,Cartesian3.ZERO,3,q[1]);const j=BoundingSphere.fromBoundingSpheres(q);j.radius+=H/(2*u);const X={position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,normalize:!1,values:m}),startHiAndForwardOffsetX:getVec4GeometryAttribute(g),startLoAndForwardOffsetY:getVec4GeometryAttribute(_),startNormalAndForwardOffsetZ:getVec4GeometryAttribute(y),endNormalAndTextureCoordinateNormalizationX:getVec4GeometryAttribute(C),rightNormalAndTextureCoordinateNormalizationY:getVec4GeometryAttribute(T)};return a&&(X.startHiLo2D=getVec4GeometryAttribute(S),X.offsetAndRight2D=getVec4GeometryAttribute(A),X.startEndNormals2D=getVec4GeometryAttribute(v),X.texcoordNormalization2D=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,normalize:!1,values:E})),new Geometry({attributes:X,indices:f,boundingSphere:j})}function getVec4GeometryAttribute(e){return new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}function HeadingPitchRange(e,t,n){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.range=defaultValue(n,0)}GroundPolylineGeometry._projectNormal=projectNormal,HeadingPitchRange.clone=function(e,t){if(defined(e))return defined(t)||(t=new HeadingPitchRange),t.heading=e.heading,t.pitch=e.pitch,t.range=e.range,t};const factorial=CesiumMath.factorial;function calculateCoefficientTerm(e,t,n,i,r,o){let a,s,c,l=0;if(i>0){for(s=0;s<r;s++){for(a=!1,c=0;c<o.length&&!a;c++)s===o[c]&&(a=!0);a||(o.push(s),l+=calculateCoefficientTerm(e,t,n,i-1,r,o),o.splice(o.length-1,1))}return l}for(l=1,s=0;s<r;s++){for(a=!1,c=0;c<o.length&&!a;c++)s===o[c]&&(a=!0);a||(l*=e-n[t[s]])}return l}const HermitePolynomialApproximation={type:"Hermite",getRequiredDataPoints:function(e,t){return t=defaultValue(t,0),Math.max(Math.floor((e+1)/(t+1)),2)},interpolateOrderZero:function(e,t,n,i,r){let o,a,s,c,l,u;defined(r)||(r=new Array(i));const d=t.length,h=new Array(i);for(o=0;o<i;o++){r[o]=0;const e=new Array(d);for(h[o]=e,a=0;a<d;a++)e[a]=[]}const p=d,f=new Array(p);for(o=0;o<p;o++)f[o]=o;let m=d-1;for(c=0;c<i;c++){for(a=0;a<p;a++)u=f[a]*i+c,h[c][0].push(n[u]);for(o=1;o<p;o++){let e=!1;for(a=0;a<p-o;a++){const r=t[f[a]],s=t[f[a+o]];let l;s-r<=0?(u=f[a]*i+i*o+c,l=n[u],h[c][o].push(l/factorial(o))):(l=h[c][o-1][a+1]-h[c][o-1][a],h[c][o].push(l/(s-r))),e=e||0!==l}e||(m=o-1)}}for(s=0,l=0;s<=0;s++)for(o=s;o<=m;o++){const n=calculateCoefficientTerm(e,f,t,s,o,[]);for(c=0;c<i;c++){const e=h[c][o][0];r[c+s*i]+=e*n}}return r}},arrayScratch=[];function fillCoefficientList(e,t,n,i,r,o){let a,s,c=-1;const l=t.length,u=l*(l+1)/2;for(let d=0;d<r;d++){const h=Math.floor(d*u);for(a=0;a<l;a++)s=t[a]*r*(o+1)+d,e[h+a]=i[s];for(let u=1;u<l;u++){let p=0;const f=Math.floor(u*(1-u)/2)+l*u;let m=!1;for(a=0;a<l-u;a++){const c=n[t[a]],g=n[t[a+u]];let _,y;if(g-c<=0)s=t[a]*r*(o+1)+r*u+d,_=i[s],y=_/CesiumMath.factorial(u),e[h+f+p]=y,p++;else{const t=Math.floor((u-1)*(2-u)/2)+l*(u-1);_=e[h+t+a+1]-e[h+t+a],y=_/(g-c),e[h+f+p]=y,p++}m=m||0!==_}m&&(c=Math.max(c,u))}}return c}HermitePolynomialApproximation.interpolate=function(e,t,n,i,r,o,a){const s=i*(o+1);defined(a)||(a=new Array(s));for(let e=0;e<s;e++)a[e]=0;const c=t.length,l=new Array(c*(r+1));let u;for(u=0;u<c;u++)for(let e=0;e<r+1;e++)l[u*(r+1)+e]=u;const d=l.length,h=arrayScratch,p=fillCoefficientList(h,l,t,n,i,r),f=[],m=d*(d+1)/2,g=Math.min(p,o);for(let n=0;n<=g;n++)for(u=n;u<=p;u++){f.length=0;const r=calculateCoefficientTerm(e,l,t,n,u,f),o=Math.floor(u*(1-u)/2)+d*u;for(let e=0;e<i;e++){const t=h[Math.floor(e*m)+o];a[e+n*i]+=t*r}}return a};const HilbertOrder={};function rotate$1(e,t,n,i){if(0!==i)return;1===n&&(t.x=e-1-t.x,t.y=e-1-t.y);const r=t.x;t.x=t.y,t.y=r}function IauOrientationParameters(e,t,n,i){this.rightAscension=e,this.declination=t,this.rotation=n,this.rotationRate=i}HilbertOrder.encode2D=function(e,t,n){const i=Math.pow(2,e),r={x:t,y:n};let o,a,s,c=BigInt(0);for(s=i/2;s>0;s/=2)o=(r.x&s)>0?1:0,a=(r.y&s)>0?1:0,c+=BigInt((3*o^a)*s*s),rotate$1(i,r,o,a);return c},HilbertOrder.decode2D=function(e,t){const n=Math.pow(2,e),i={x:0,y:0};let r,o,a,s;for(a=1,s=t;a<n;a*=2)r=1&Number(s/BigInt(2)),o=1&Number(s^BigInt(r)),rotate$1(a,i,r,o),i.x+=a*r,i.y+=a*o,s/=BigInt(4);return[i.x,i.y]};const Iau2000Orientation={},TdtMinusTai$1=32.184,J2000d$1=2451545,c1=-.0529921,c2=-.1059842,c3=13.0120009,c4=13.3407154,c5=.9856003,c6=26.4057084,c7=13.064993,c8=.3287146,c9=1.7484877,c10=-.1589763,c11=.0036096,c12=.1643573,c13=12.9590088;let dateTT=new JulianDate;function IauOrientationAxes(e){defined(e)&&"function"==typeof e||(e=Iau2000Orientation.ComputeMoon),this._computeFunction=e}Iau2000Orientation.ComputeMoon=function(e,t){defined(e)||(e=JulianDate.now()),dateTT=JulianDate.addSeconds(e,TdtMinusTai$1,dateTT);const n=JulianDate.totalDays(dateTT)-J2000d$1,i=n/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,r=(125.045+c1*n)*CesiumMath.RADIANS_PER_DEGREE,o=(250.089+c2*n)*CesiumMath.RADIANS_PER_DEGREE,a=(260.008+c3*n)*CesiumMath.RADIANS_PER_DEGREE,s=(176.625+c4*n)*CesiumMath.RADIANS_PER_DEGREE,c=(357.529+c5*n)*CesiumMath.RADIANS_PER_DEGREE,l=(311.589+c6*n)*CesiumMath.RADIANS_PER_DEGREE,u=(134.963+c7*n)*CesiumMath.RADIANS_PER_DEGREE,d=(276.617+c8*n)*CesiumMath.RADIANS_PER_DEGREE,h=(34.226+c9*n)*CesiumMath.RADIANS_PER_DEGREE,p=(15.134+c10*n)*CesiumMath.RADIANS_PER_DEGREE,f=(119.743+c11*n)*CesiumMath.RADIANS_PER_DEGREE,m=(239.961+c12*n)*CesiumMath.RADIANS_PER_DEGREE,g=(25.053+c13*n)*CesiumMath.RADIANS_PER_DEGREE,_=Math.sin(r),y=Math.sin(o),C=Math.sin(a),T=Math.sin(s),S=Math.sin(c),A=Math.sin(l),v=Math.sin(u),E=Math.sin(d),b=Math.sin(h),x=Math.sin(p),P=Math.sin(f),D=Math.sin(m),w=Math.sin(g),M=Math.cos(r),I=Math.cos(o),R=Math.cos(a),O=Math.cos(s),B=Math.cos(c),L=Math.cos(l),F=Math.cos(u),N=Math.cos(d),V=Math.cos(h),$=Math.cos(p),k=Math.cos(f),U=Math.cos(m),G=Math.cos(g),z=(269.9949+.0031*i-3.8787*_-.1204*y+.07*C-.0172*T+.0072*A-.0052*x+.0043*w)*CesiumMath.RADIANS_PER_DEGREE,H=(66.5392+.013*i+1.5419*M+.0239*I-.0278*R+.0068*O-.0029*L+9e-4*F+8e-4*$-9e-4*G)*CesiumMath.RADIANS_PER_DEGREE,W=(38.3213+13.17635815*n-14e-13*n*n+3.561*_+.1208*y-.0642*C+.0158*T+.0252*S-.0066*A-.0047*v-.0046*E+.0028*b+.0052*x+.004*P+.0019*D-.0044*w)*CesiumMath.RADIANS_PER_DEGREE,q=(13.17635815-2*n*14e-13+3.561*M*c1+.1208*I*c2-.0642*R*c3+.0158*O*c4+.0252*B*c5-.0066*L*c6-.0047*F*c7-.0046*N*c8+.0028*V*c9+.0052*$*c10+.004*k*c11+.0019*U*c12-.0044*G*c13)/86400*CesiumMath.RADIANS_PER_DEGREE;return defined(t)||(t=new IauOrientationParameters),t.rightAscension=z,t.declination=H,t.rotation=W,t.rotationRate=q,t};const xAxisScratch=new Cartesian3,yAxisScratch=new Cartesian3,zAxisScratch=new Cartesian3;function computeRotationMatrix(e,t,n){const i=xAxisScratch;i.x=Math.cos(e+CesiumMath.PI_OVER_TWO),i.y=Math.sin(e+CesiumMath.PI_OVER_TWO),i.z=0;const r=Math.cos(t),o=zAxisScratch;o.x=r*Math.cos(e),o.y=r*Math.sin(e),o.z=Math.sin(t);const a=Cartesian3.cross(o,i,yAxisScratch);return defined(n)||(n=new Matrix3),n[0]=i.x,n[1]=a.x,n[2]=o.x,n[3]=i.y,n[4]=a.y,n[5]=o.y,n[6]=i.z,n[7]=a.z,n[8]=o.z,n}const rotMtxScratch=new Matrix3,quatScratch=new Quaternion;IauOrientationAxes.prototype.evaluate=function(e,t){defined(e)||(e=JulianDate.now());const n=this._computeFunction(e),i=computeRotationMatrix(n.rightAscension,n.declination,t),r=CesiumMath.zeroToTwoPi(n.rotation),o=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,r,quatScratch),a=Matrix3.fromQuaternion(Quaternion.conjugate(o,o),rotMtxScratch);return Matrix3.multiply(a,i,i)};const InterpolationAlgorithm={};let defaultTokenCredit;InterpolationAlgorithm.type=void 0,InterpolationAlgorithm.getRequiredDataPoints=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolateOrderZero=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolate=DeveloperError.throwInstantiationError;const defaultAccessToken="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIzZGZiNTI0Zi1lNTVmLTQ1ZjktODIzNS0yYjQ5ODg4MDk0NTAiLCJpZCI6MjU5LCJpYXQiOjE2NDYxNDYyMzB9.OZ0mWuymsiF9cR10FR_rZTMD7kA_FE7-uUGW6J7wBU4",Ion={};function PeliasGeocoderService(e){this._url=Resource.createIfNeeded(e),this._url.appendForwardSlash()}function IonGeocoderService(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.accessToken,Ion.defaultAccessToken),n=Resource.createIfNeeded(defaultValue(e.server,Ion.defaultServer));n.appendForwardSlash();const i=Ion.getDefaultTokenCredit(t);defined(i)&&e.scene.frameState.creditDisplay.addDefaultCredit(Credit.clone(i));const r=n.getDerivedResource({url:"v1/geocode"});defined(t)&&r.appendQueryParameters({access_token:t}),this._accessToken=t,this._server=n,this._pelias=new PeliasGeocoderService(r)}function IonResource(e,t){let n;const i=e.externalType,r=defined(i);if(r){if("3DTILES"!==i&&"STK_TERRAIN_SERVER"!==i)throw new RuntimeError("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");n={url:e.options.url}}else n={url:e.url,retryAttempts:1,retryCallback:retryCallback};Resource.call(this,n),this._ionEndpoint=e,this._ionEndpointDomain=r?void 0:new URI(e.url).authority(),this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=r}function retryCallback(e,t){const n=defaultValue(e._ionRoot,e),i=n._ionEndpointResource,r="undefined"!=typeof Image;return defined(t)&&(401===t.statusCode||r&&t.target instanceof Image)?(defined(n._pendingPromise)||(n._pendingPromise=i.fetchJson().then((function(e){return n._ionEndpoint=e,e})).always((function(e){return n._pendingPromise=void 0,e}))),n._pendingPromise.then((function(t){return e._ionEndpoint=t,!0}))):when.resolve(!1)}function TimeInterval(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.start=defined(e.start)?JulianDate.clone(e.start):new JulianDate,this.stop=defined(e.stop)?JulianDate.clone(e.stop):new JulianDate,this.data=e.data,this.isStartIncluded=defaultValue(e.isStartIncluded,!0),this.isStopIncluded=defaultValue(e.isStopIncluded,!0)}Ion.defaultAccessToken=defaultAccessToken,Ion.defaultServer=new Resource({url:"https://api.cesium.com/"}),Ion.getDefaultTokenCredit=function(e){if(e===defaultAccessToken){if(!defined(defaultTokenCredit)){defaultTokenCredit=new Credit('<b>             This application is using Cesium\'s default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>',!0)}return defaultTokenCredit}},Object.defineProperties(PeliasGeocoderService.prototype,{url:{get:function(){return this._url}}}),PeliasGeocoderService.prototype.geocode=function(e,t){return this._url.getDerivedResource({url:t===GeocodeType$1.AUTOCOMPLETE?"autocomplete":"search",queryParameters:{text:e}}).fetchJson().then((function(e){return e.features.map((function(e){let t;const n=e.bbox;if(defined(n))t=Rectangle.fromDegrees(n[0],n[1],n[2],n[3]);else{const n=e.geometry.coordinates[0],i=e.geometry.coordinates[1];t=Cartesian3.fromDegrees(n,i)}return{displayName:e.properties.label,destination:t}}))}))},IonGeocoderService.prototype.geocode=function(e,t){return this._pelias.geocode(e,t)},defined(Object.create)&&(IonResource.prototype=Object.create(Resource.prototype),IonResource.prototype.constructor=IonResource),IonResource.fromAssetId=function(e,t){const n=IonResource._createEndpointResource(e,t);return n.fetchJson().then((function(e){return new IonResource(e,n)}))},Object.defineProperties(IonResource.prototype,{credits:{get:function(){return defined(this._ionRoot)?this._ionRoot.credits:(defined(this._credits)||(this._credits=IonResource.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource)),this._credits)}}}),IonResource.getCreditsFromEndpoint=function(e,t){const n=e.attributions.map(Credit.getIonCredit),i=Ion.getDefaultTokenCredit(t.queryParameters.access_token);return defined(i)&&n.push(Credit.clone(i)),n},IonResource.prototype.clone=function(e){const t=defaultValue(this._ionRoot,this);return defined(e)||(e=new IonResource(t._ionEndpoint,t._ionEndpointResource)),(e=Resource.prototype.clone.call(this,e))._ionRoot=t,e._isExternal=this._isExternal,e},IonResource.prototype.fetchImage=function(e){if(!this._isExternal){const t=e;e={preferBlob:!0},defined(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)}return Resource.prototype.fetchImage.call(this,e)},IonResource.prototype._makeRequest=function(e){return this._isExternal||new URI(this.url).authority()!==this._ionEndpointDomain||(defined(e.headers)||(e.headers={}),e.headers.Authorization=`Bearer ${this._ionEndpoint.accessToken}`),Resource.prototype._makeRequest.call(this,e)},IonResource._createEndpointResource=function(e,t){t=defaultValue(t,defaultValue.EMPTY_OBJECT);let n=defaultValue(t.server,Ion.defaultServer);const i=defaultValue(t.accessToken,Ion.defaultAccessToken);n=Resource.createIfNeeded(n);const r={url:`v1/assets/${e}/endpoint`};return defined(i)&&(r.queryParameters={access_token:i}),n.getDerivedResource(r)},Object.defineProperties(TimeInterval.prototype,{isEmpty:{get:function(){const e=JulianDate.compare(this.stop,this.start);return e<0||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});const scratchInterval={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};TimeInterval.fromIso8601=function(e,t){const n=e.iso8601.split("/");if(2!==n.length)throw new DeveloperError("options.iso8601 is an invalid ISO 8601 interval.");const i=JulianDate.fromIso8601(n[0]),r=JulianDate.fromIso8601(n[1]),o=defaultValue(e.isStartIncluded,!0),a=defaultValue(e.isStopIncluded,!0),s=e.data;return defined(t)?(t.start=i,t.stop=r,t.isStartIncluded=o,t.isStopIncluded=a,t.data=s,t):(scratchInterval.start=i,scratchInterval.stop=r,scratchInterval.isStartIncluded=o,scratchInterval.isStopIncluded=a,scratchInterval.data=s,new TimeInterval(scratchInterval))},TimeInterval.toIso8601=function(e,t){return`${JulianDate.toIso8601(e.start,t)}/${JulianDate.toIso8601(e.stop,t)}`},TimeInterval.clone=function(e,t){if(defined(e))return defined(t)?(t.start=e.start,t.stop=e.stop,t.isStartIncluded=e.isStartIncluded,t.isStopIncluded=e.isStopIncluded,t.data=e.data,t):new TimeInterval(e)},TimeInterval.equals=function(e,t,n){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equals(e.start,t.start)&&JulianDate.equals(e.stop,t.stop)&&(e.data===t.data||defined(n)&&n(e.data,t.data)))},TimeInterval.equalsEpsilon=function(e,t,n,i){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equalsEpsilon(e.start,t.start,n)&&JulianDate.equalsEpsilon(e.stop,t.stop,n)&&(e.data===t.data||defined(i)&&i(e.data,t.data)))},TimeInterval.intersect=function(e,t,n,i){if(!defined(t))return TimeInterval.clone(TimeInterval.EMPTY,n);const r=e.start,o=e.stop,a=t.start,s=t.stop,c=JulianDate.greaterThanOrEquals(a,r)&&JulianDate.greaterThanOrEquals(o,a),l=!c&&JulianDate.lessThanOrEquals(a,r)&&JulianDate.lessThanOrEquals(r,s);if(!c&&!l)return TimeInterval.clone(TimeInterval.EMPTY,n);const u=e.isStartIncluded,d=e.isStopIncluded,h=t.isStartIncluded,p=t.isStopIncluded,f=JulianDate.lessThan(o,s);return defined(n)||(n=new TimeInterval),n.start=c?a:r,n.isStartIncluded=u&&h||!JulianDate.equals(a,r)&&(c&&h||l&&u),n.stop=f?o:s,n.isStopIncluded=f?d:d&&p||!JulianDate.equals(s,o)&&p,n.data=defined(i)?i(e.data,t.data):e.data,n},TimeInterval.contains=function(e,t){if(e.isEmpty)return!1;const n=JulianDate.compare(e.start,t);if(0===n)return e.isStartIncluded;const i=JulianDate.compare(t,e.stop);return 0===i?e.isStopIncluded:n<0&&i<0},TimeInterval.prototype.clone=function(e){return TimeInterval.clone(this,e)},TimeInterval.prototype.equals=function(e,t){return TimeInterval.equals(this,e,t)},TimeInterval.prototype.equalsEpsilon=function(e,t,n){return TimeInterval.equalsEpsilon(this,e,t,n)},TimeInterval.prototype.toString=function(){return TimeInterval.toIso8601(this)},TimeInterval.EMPTY=Object.freeze(new TimeInterval({start:new JulianDate,stop:new JulianDate,isStartIncluded:!1,isStopIncluded:!1}));const MINIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("0000-01-01T00:00:00Z")),MAXIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("9999-12-31T24:00:00Z")),MAXIMUM_INTERVAL=Object.freeze(new TimeInterval({start:MINIMUM_VALUE,stop:MAXIMUM_VALUE})),Iso8601={MINIMUM_VALUE:MINIMUM_VALUE,MAXIMUM_VALUE:MAXIMUM_VALUE,MAXIMUM_INTERVAL:MAXIMUM_INTERVAL};function KTX2Transcoder(){}function makeReadyPromise(){const e=KTX2Transcoder._transcodeTaskProcessor.initWebAssemblyModule({modulePath:"ThirdParty/Workers/basis_transcoder.js",wasmBinaryFile:"ThirdParty/basis_transcoder.wasm"}).then((function(){return KTX2Transcoder._transcodeTaskProcessor}));KTX2Transcoder._readyPromise=e}KTX2Transcoder._transcodeTaskProcessor=new TaskProcessor("transcodeKTX2",Number.POSITIVE_INFINITY),KTX2Transcoder._readyPromise=void 0,KTX2Transcoder.transcode=function(e,t){return defined(KTX2Transcoder._readyPromise)||makeReadyPromise(),KTX2Transcoder._readyPromise.then((function(n){let i;if(e instanceof ArrayBuffer){const r=new Uint8Array(e);return i={supportedTargetFormats:t,ktx2Buffer:r},n.scheduleTask(i,[e])}return i={supportedTargetFormats:t,ktx2Buffer:e},n.scheduleTask(i,[e.buffer])})).then((function(e){const t=e.length,n=Object.keys(e[0]),i=n.length;let r;for(r=0;r<t;r++){const t=e[r];for(let e=0;e<i;e++){const i=t[n[e]];t[n[e]]=new CompressedTextureBuffer(i.internalFormat,i.datatype,i.width,i.height,i.levelBuffer)}}if(1===i){for(r=0;r<t;++r)e[r]=e[r][n[0]];1===t&&(e=e[0])}return e})).otherwise((function(e){throw e}))};const KeyboardEventModifier={SHIFT:0,CTRL:1,ALT:2};var KeyboardEventModifier$1=Object.freeze(KeyboardEventModifier);const LagrangePolynomialApproximation={type:"Lagrange",getRequiredDataPoints:function(e){return Math.max(e+1,2)},interpolateOrderZero:function(e,t,n,i,r){let o,a;defined(r)||(r=new Array(i));const s=t.length;for(o=0;o<i;o++)r[o]=0;for(o=0;o<s;o++){let c=1;for(a=0;a<s;a++)if(a!==o){const n=t[o]-t[a];c*=(e-t[a])/n}for(a=0;a<i;a++)r[a]+=c*n[o*i+a]}return r}},LinearApproximation={type:"Linear"};function ManagedArray(e){e=defaultValue(e,0),this._array=new Array(e),this._length=e}function MapProjection(){DeveloperError.throwInstantiationError()}LinearApproximation.getRequiredDataPoints=function(e){return 2},LinearApproximation.interpolateOrderZero=function(e,t,n,i,r){let o,a,s;defined(r)||(r=new Array(i));const c=t[0],l=t[1];for(o=0;o<i;o++)a=n[o],s=n[o+i],r[o]=((s-a)*e+l*a-c*s)/(l-c);return r},Object.defineProperties(ManagedArray.prototype,{length:{get:function(){return this._length},set:function(e){const t=this._array,n=this._length;if(e<n)for(let i=e;i<n;++i)t[i]=void 0;else e>t.length&&(t.length=e);this._length=e}},values:{get:function(){return this._array}}}),ManagedArray.prototype.get=function(e){return this._array[e]},ManagedArray.prototype.set=function(e,t){e>=this._length&&(this.length=e+1),this._array[e]=t},ManagedArray.prototype.peek=function(){return this._array[this._length-1]},ManagedArray.prototype.push=function(e){const t=this.length++;this._array[t]=e},ManagedArray.prototype.pop=function(){if(0===this._length)return;const e=this._array[this._length-1];return--this.length,e},ManagedArray.prototype.reserve=function(e){e>this._array.length&&(this._array.length=e)},ManagedArray.prototype.resize=function(e){this.length=e},ManagedArray.prototype.trim=function(e){e=defaultValue(e,this._length),this._array.length=e},Object.defineProperties(MapProjection.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError}}),MapProjection.prototype.project=DeveloperError.throwInstantiationError,MapProjection.prototype.unproject=DeveloperError.throwInstantiationError;const MortonOrder={};function insertOneSpacing(e){return e=1431655765&((e=858993459&((e=252645135&((e=16711935&(e^e<<8))^e<<4))^e<<2))^e<<1)}function insertTwoSpacing(e){return e=153391689&((e=51130563&((e=50393103&((e=50331903&(e^e<<16))^e<<8))^e<<4))^e<<2)}function removeOneSpacing(e){return e=65535&((e=16711935&((e=252645135&((e=858993459&((e&=1431655765)^e>>1))^e>>2))^e>>4))^e>>8)}function removeTwoSpacing(e){return e=1023&((e=4278190335&((e=50393103&((e=51130563&((e&=153391689)^e>>2))^e>>4))^e>>8))^e>>16)}function NearFarScalar(e,t,n,i){this.near=defaultValue(e,0),this.nearValue=defaultValue(t,0),this.far=defaultValue(n,1),this.farValue=defaultValue(i,0)}MortonOrder.encode2D=function(e,t){return(insertOneSpacing(e)|insertOneSpacing(t)<<1)>>>0},MortonOrder.decode2D=function(e,t){return defined(t)||(t=new Array(2)),t[0]=removeOneSpacing(e),t[1]=removeOneSpacing(e>>1),t},MortonOrder.encode3D=function(e,t,n){return insertTwoSpacing(e)|insertTwoSpacing(t)<<1|insertTwoSpacing(n)<<2},MortonOrder.decode3D=function(e,t){return defined(t)||(t=new Array(3)),t[0]=removeTwoSpacing(e),t[1]=removeTwoSpacing(e>>1),t[2]=removeTwoSpacing(e>>2),t},NearFarScalar.clone=function(e,t){if(defined(e))return defined(t)?(t.near=e.near,t.nearValue=e.nearValue,t.far=e.far,t.farValue=e.farValue,t):new NearFarScalar(e.near,e.nearValue,e.far,e.farValue)},NearFarScalar.packedLength=4,NearFarScalar.pack=function(e,t,n){return n=defaultValue(n,0),t[n++]=e.near,t[n++]=e.nearValue,t[n++]=e.far,t[n]=e.farValue,t},NearFarScalar.unpack=function(e,t,n){return t=defaultValue(t,0),defined(n)||(n=new NearFarScalar),n.near=e[t++],n.nearValue=e[t++],n.far=e[t++],n.farValue=e[t],n},NearFarScalar.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.nearValue===t.nearValue&&e.far===t.far&&e.farValue===t.farValue},NearFarScalar.prototype.clone=function(e){return NearFarScalar.clone(this,e)},NearFarScalar.prototype.equals=function(e){return NearFarScalar.equals(this,e)};const Visibility={NONE:-1,PARTIAL:0,FULL:1};var Visibility$1=Object.freeze(Visibility);function Occluder(e,t){this._occluderPosition=Cartesian3.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=t}const scratchCartesian3$6=new Cartesian3;Object.defineProperties(Occluder.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=Cartesian3.clone(e,this._cameraPosition);const t=Cartesian3.subtract(this._occluderPosition,e,scratchCartesian3$6);let n=Cartesian3.magnitudeSquared(t);const i=this._occluderRadius*this._occluderRadius;let r,o,a;if(n>i){r=Math.sqrt(n-i),n=1/Math.sqrt(n),o=Cartesian3.multiplyByScalar(t,n,scratchCartesian3$6);const s=r*r*n;a=Cartesian3.add(e,Cartesian3.multiplyByScalar(o,s,scratchCartesian3$6),scratchCartesian3$6)}else r=Number.MAX_VALUE;this._horizonDistance=r,this._horizonPlaneNormal=o,this._horizonPlanePosition=a,this._cameraPosition=e}}}),Occluder.fromBoundingSphere=function(e,t,n){return defined(n)?(Cartesian3.clone(e.center,n._occluderPosition),n._occluderRadius=e.radius,n.cameraPosition=t,n):new Occluder(e,t)};const tempVecScratch=new Cartesian3;Occluder.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){let t=Cartesian3.subtract(e,this._occluderPosition,tempVecScratch),n=this._occluderRadius;if(n=Cartesian3.magnitudeSquared(t)-n*n,n>0)return n=Math.sqrt(n)+this._horizonDistance,t=Cartesian3.subtract(e,this._cameraPosition,t),n*n>Cartesian3.magnitudeSquared(t)}return!1};const occludeePositionScratch=new Cartesian3;Occluder.prototype.isBoundingSphereVisible=function(e){const t=Cartesian3.clone(e.center,occludeePositionScratch),n=e.radius;if(this._horizonDistance!==Number.MAX_VALUE){let e=Cartesian3.subtract(t,this._occluderPosition,tempVecScratch),i=this._occluderRadius-n;if(i=Cartesian3.magnitudeSquared(e)-i*i,n<this._occluderRadius)return i>0&&(i=Math.sqrt(i)+this._horizonDistance,e=Cartesian3.subtract(t,this._cameraPosition,e),i*i+n*n>Cartesian3.magnitudeSquared(e));if(i>0){e=Cartesian3.subtract(t,this._cameraPosition,e);const r=Cartesian3.magnitudeSquared(e),o=this._occluderRadius*this._occluderRadius,a=n*n;return(this._horizonDistance*this._horizonDistance+o)*a>r*o||(i=Math.sqrt(i)+this._horizonDistance,i*i+a>r)}return!0}return!1};const tempScratch=new Cartesian3;Occluder.prototype.computeVisibility=function(e){const t=Cartesian3.clone(e.center),n=e.radius;if(n>this._occluderRadius)return Visibility$1.FULL;if(this._horizonDistance!==Number.MAX_VALUE){let e=Cartesian3.subtract(t,this._occluderPosition,tempScratch),i=this._occluderRadius-n;const r=Cartesian3.magnitudeSquared(e);if(i=r-i*i,i>0){i=Math.sqrt(i)+this._horizonDistance,e=Cartesian3.subtract(t,this._cameraPosition,e);const o=Cartesian3.magnitudeSquared(e);return i*i+n*n<o?Visibility$1.NONE:(i=this._occluderRadius+n,i=r-i*i,i>0?(i=Math.sqrt(i)+this._horizonDistance,o<i*i+n*n?Visibility$1.FULL:Visibility$1.PARTIAL):(e=Cartesian3.subtract(t,this._horizonPlanePosition,e),Cartesian3.dot(e,this._horizonPlaneNormal)>-n?Visibility$1.PARTIAL:Visibility$1.FULL))}}return Visibility$1.NONE};const occludeePointScratch=new Cartesian3;Occluder.computeOccludeePoint=function(e,t,n){const i=Cartesian3.clone(t),r=Cartesian3.clone(e.center),o=e.radius,a=n.length,s=Cartesian3.normalize(Cartesian3.subtract(i,r,occludeePointScratch),occludeePointScratch),c=-Cartesian3.dot(s,r),l=Occluder._anyRotationVector(r,s,c);let u,d=Occluder._horizonToPlaneNormalDotProduct(e,s,c,l,n[0]);if(!d)return;for(let t=1;t<a;++t){if(u=Occluder._horizonToPlaneNormalDotProduct(e,s,c,l,n[t]),!u)return;u<d&&(d=u)}if(d<.0017453283658983088)return;const h=o/d;return Cartesian3.add(r,Cartesian3.multiplyByScalar(s,h,occludeePointScratch),occludeePointScratch)};const computeOccludeePointFromRectangleScratch=[];Occluder.computeOccludeePointFromRectangle=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);const n=Rectangle.subsample(e,t,0,computeOccludeePointFromRectangleScratch),i=BoundingSphere.fromPoints(n),r=Cartesian3.ZERO;if(!Cartesian3.equals(r,i.center))return Occluder.computeOccludeePoint(new BoundingSphere(r,t.minimumRadius),i.center,n)};const tempVec0Scratch=new Cartesian3;Occluder._anyRotationVector=function(e,t,n){const i=Cartesian3.abs(t,tempVec0Scratch);let r=i.x>i.y?0:1;(0===r&&i.z>i.x||1===r&&i.z>i.y)&&(r=2);const o=new Cartesian3;let a;0===r?(i.x=e.x,i.y=e.y+1,i.z=e.z+1,a=Cartesian3.UNIT_X):1===r?(i.x=e.x+1,i.y=e.y,i.z=e.z+1,a=Cartesian3.UNIT_Y):(i.x=e.x+1,i.y=e.y+1,i.z=e.z,a=Cartesian3.UNIT_Z);const s=(Cartesian3.dot(t,i)+n)/-Cartesian3.dot(t,a);return Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(i,Cartesian3.multiplyByScalar(a,s,o),i),e,i),i)};const posDirectionScratch=new Cartesian3;Occluder._rotationVector=function(e,t,n,i,r){let o=Cartesian3.subtract(i,e,posDirectionScratch);if(o=Cartesian3.normalize(o,o),Cartesian3.dot(t,o)<.9999999847691291){const e=Cartesian3.cross(t,o,o);if(Cartesian3.magnitude(e)>CesiumMath.EPSILON13)return Cartesian3.normalize(e,new Cartesian3)}return r};const posScratch1=new Cartesian3,occluerPosScratch=new Cartesian3,posScratch2=new Cartesian3,horizonPlanePosScratch=new Cartesian3;function OffsetGeometryInstanceAttribute(e,t,n){e=defaultValue(e,0),t=defaultValue(t,0),n=defaultValue(n,0),this.value=new Float32Array([e,t,n])}function OpenCageGeocoderService(e,t,n){(e=Resource.createIfNeeded(e)).appendForwardSlash(),e.setQueryParameters({key:t}),this._url=e,this._params=defaultValue(n,{})}Occluder._horizonToPlaneNormalDotProduct=function(e,t,n,i,r){const o=Cartesian3.clone(r,posScratch1),a=Cartesian3.clone(e.center,occluerPosScratch),s=e.radius;let c=Cartesian3.subtract(a,o,posScratch2);const l=Cartesian3.magnitudeSquared(c),u=s*s;if(l<u)return!1;const d=l-u,h=Math.sqrt(d),p=h*(1/Math.sqrt(l))*h;c=Cartesian3.normalize(c,c);const f=Cartesian3.add(o,Cartesian3.multiplyByScalar(c,p,horizonPlanePosScratch),horizonPlanePosScratch),m=Math.sqrt(d-p*p);let g=this._rotationVector(a,t,n,o,i),_=Cartesian3.fromElements(g.x*g.x*c.x+(g.x*g.y-g.z)*c.y+(g.x*g.z+g.y)*c.z,(g.x*g.y+g.z)*c.x+g.y*g.y*c.y+(g.y*g.z-g.x)*c.z,(g.x*g.z-g.y)*c.x+(g.y*g.z+g.x)*c.y+g.z*g.z*c.z,posScratch1);_=Cartesian3.normalize(_,_);const y=Cartesian3.multiplyByScalar(_,m,posScratch1);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(f,y,posScratch2),a,posScratch2),posScratch2);const C=Cartesian3.dot(t,g);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.subtract(f,y,g),a,g),g);const T=Cartesian3.dot(t,g);return C<T?C:T},Object.defineProperties(OffsetGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),OffsetGeometryInstanceAttribute.fromCartesian3=function(e){return new OffsetGeometryInstanceAttribute(e.x,e.y,e.z)},OffsetGeometryInstanceAttribute.toValue=function(e,t){return defined(t)||(t=new Float32Array([e.x,e.y,e.z])),t[0]=e.x,t[1]=e.y,t[2]=e.z,t},Object.defineProperties(OpenCageGeocoderService.prototype,{url:{get:function(){return this._url}},params:{get:function(){return this._params}}}),OpenCageGeocoderService.prototype.geocode=function(e){return this._url.getDerivedResource({url:"json",queryParameters:combine$2(this._params,{q:e})}).fetchJson().then((function(e){return e.results.map((function(e){let t;const n=e.bounds;if(defined(n))t=Rectangle.fromDegrees(n.southwest.lng,n.southwest.lat,n.northeast.lng,n.northeast.lat);else{const n=e.geometry.lat,i=e.geometry.lng;t=Cartesian3.fromDegrees(n,i)}return{displayName:e.formatted,destination:t}}))}))};const Packable={packedLength:void 0,pack:DeveloperError.throwInstantiationError,unpack:DeveloperError.throwInstantiationError},PackableForInterpolation={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:DeveloperError.throwInstantiationError,unpackInterpolationResult:DeveloperError.throwInstantiationError};function measureText(e,t,n,i,r){const o=e.measureText(t);if(!!/\S/.test(t)){const a=document.defaultView.getComputedStyle(e.canvas).getPropertyValue("font-size").replace("px",""),s=document.createElement("canvas"),c=100,l=o.width+c|0,u=3*a,d=u/2;s.width=l,s.height=u;const h=s.getContext("2d");h.font=n,h.fillStyle="white",h.fillRect(0,0,s.width+1,s.height+1),i&&(h.strokeStyle="black",h.lineWidth=e.lineWidth,h.strokeText(t,c/2,d)),r&&(h.fillStyle="black",h.fillText(t,c/2,d));const p=h.getImageData(0,0,l,u).data,f=p.length,m=4*l;let g,_,y,C;for(g=0;g<f;++g)if(255!==p[g]){y=g/m|0;break}for(g=f-1;g>=0;--g)if(255!==p[g]){C=g/m|0;break}let T=-1;for(g=0;g<l&&-1===T;++g)for(_=0;_<u;++_){const e=4*g+_*m;if(255!==p[e]||255!==p[e+1]||255!==p[e+2]||255!==p[e+3]){T=g;break}}return{width:o.width,height:C-y,ascent:d-y,descent:C-d,minx:T-c/2}}return{width:o.width,height:0,ascent:0,descent:0,minx:0}}let imageSmoothingEnabledName;function writeTextToCanvas(e,t){if(""===e)return;t=defaultValue(t,defaultValue.EMPTY_OBJECT);const n=defaultValue(t.font,"10px sans-serif"),i=defaultValue(t.stroke,!1),r=defaultValue(t.fill,!0),o=defaultValue(t.strokeWidth,1),a=defaultValue(t.backgroundColor,Color.TRANSPARENT),s=defaultValue(t.padding,0),c=2*s,l=document.createElement("canvas");l.width=1,l.height=1,l.style.font=n;const u=l.getContext("2d");defined(imageSmoothingEnabledName)||(defined(u.imageSmoothingEnabled)?imageSmoothingEnabledName="imageSmoothingEnabled":defined(u.mozImageSmoothingEnabled)?imageSmoothingEnabledName="mozImageSmoothingEnabled":defined(u.webkitImageSmoothingEnabled)?imageSmoothingEnabledName="webkitImageSmoothingEnabled":defined(u.msImageSmoothingEnabled)&&(imageSmoothingEnabledName="msImageSmoothingEnabled")),u.font=n,u.lineJoin="round",u.lineWidth=o,u[imageSmoothingEnabledName]=!1,l.style.visibility="hidden",document.body.appendChild(l);const d=measureText(u,e,n,i,r);l.dimensions=d,document.body.removeChild(l),l.style.visibility="";const h=-d.minx,p=Math.ceil(d.width)+h+c,f=d.height+c,m=f-(f-d.ascent+s)+c;if(l.width=p,l.height=f,u.font=n,u.lineJoin="round",u.lineWidth=o,u[imageSmoothingEnabledName]=!1,a!==Color.TRANSPARENT&&(u.fillStyle=a.toCssColorString(),u.fillRect(0,0,l.width,l.height)),i){const n=defaultValue(t.strokeColor,Color.BLACK);u.strokeStyle=n.toCssColorString(),u.strokeText(e,h+s,m)}if(r){const n=defaultValue(t.fillColor,Color.WHITE);u.fillStyle=n.toCssColorString(),u.fillText(e,h+s,m)}return l}function PinBuilder(){this._cache={}}PinBuilder.prototype.fromColor=function(e,t){return createPin(void 0,void 0,e,t,this._cache)},PinBuilder.prototype.fromUrl=function(e,t,n){return createPin(e,void 0,t,n,this._cache)},PinBuilder.prototype.fromMakiIconId=function(e,t,n){return createPin(buildModuleUrl(`Assets/Textures/maki/${encodeURIComponent(e)}.png`),void 0,t,n,this._cache)},PinBuilder.prototype.fromText=function(e,t,n){return createPin(void 0,e,t,n,this._cache)};const colorScratch$7=new Color;function drawPin(e,t,n){e.save(),e.scale(n/24,n/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,colorScratch$7).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function drawIcon(e,t,n){const i=n/2.5;let r=i,o=i;t.width>t.height?o=i*(t.height/t.width):t.width<t.height&&(r=i*(t.width/t.height));const a=Math.round((n-r)/2),s=Math.round(7/24*n-o/2);e.globalCompositeOperation="destination-out",e.drawImage(t,a-1,s,r,o),e.drawImage(t,a,s-1,r,o),e.drawImage(t,a+1,s,r,o),e.drawImage(t,a,s+1,r,o),e.globalCompositeOperation="destination-over",e.fillStyle=Color.BLACK.toCssColorString(),e.fillRect(a-1,s-1,r+2,o+2),e.globalCompositeOperation="destination-out",e.drawImage(t,a,s,r,o),e.globalCompositeOperation="destination-over",e.fillStyle=Color.WHITE.toCssColorString(),e.fillRect(a-1,s-2,r+2,o+2)}const stringifyScratch=new Array(4);function createPin(e,t,n,i,r){stringifyScratch[0]=e,stringifyScratch[1]=t,stringifyScratch[2]=n,stringifyScratch[3]=i;const o=JSON.stringify(stringifyScratch),a=r[o];if(defined(a))return a;const s=document.createElement("canvas");s.width=i,s.height=i;const c=s.getContext("2d");if(drawPin(c,n,i),defined(e)){const t=Resource.createIfNeeded(e).fetchImage().then((function(e){return drawIcon(c,e,i),r[o]=s,s}));return r[o]=t,t}if(defined(t)){const e=writeTextToCanvas(t,{font:`bold ${i}px sans-serif`});drawIcon(c,e,i)}return r[o]=s,s}const PixelDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES,UNSIGNED_INT_24_8:WebGLConstants$1.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:WebGLConstants$1.UNSIGNED_SHORT_5_6_5,toWebGLConstant:function(e,t){switch(e){case PixelDatatype.UNSIGNED_BYTE:return WebGLConstants$1.UNSIGNED_BYTE;case PixelDatatype.UNSIGNED_SHORT:return WebGLConstants$1.UNSIGNED_SHORT;case PixelDatatype.UNSIGNED_INT:return WebGLConstants$1.UNSIGNED_INT;case PixelDatatype.FLOAT:return WebGLConstants$1.FLOAT;case PixelDatatype.HALF_FLOAT:return t.webgl2?WebGLConstants$1.HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES;case PixelDatatype.UNSIGNED_INT_24_8:return WebGLConstants$1.UNSIGNED_INT_24_8;case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:return WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4;case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:return WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1;case PixelDatatype.UNSIGNED_SHORT_5_6_5:return PixelDatatype.UNSIGNED_SHORT_5_6_5}},isPacked:function(e){return e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case PixelDatatype.UNSIGNED_BYTE:return 1;case PixelDatatype.UNSIGNED_SHORT:case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:case PixelDatatype.UNSIGNED_SHORT_5_6_5:case PixelDatatype.HALF_FLOAT:return 2;case PixelDatatype.UNSIGNED_INT:case PixelDatatype.FLOAT:case PixelDatatype.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===PixelDatatype.UNSIGNED_BYTE||e===PixelDatatype.UNSIGNED_SHORT||e===PixelDatatype.UNSIGNED_INT||e===PixelDatatype.FLOAT||e===PixelDatatype.HALF_FLOAT||e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5}};var PixelDatatype$1=Object.freeze(PixelDatatype);const PixelFormat={DEPTH_COMPONENT:WebGLConstants$1.DEPTH_COMPONENT,DEPTH_STENCIL:WebGLConstants$1.DEPTH_STENCIL,ALPHA:WebGLConstants$1.ALPHA,RGB:WebGLConstants$1.RGB,RGBA:WebGLConstants$1.RGBA,LUMINANCE:WebGLConstants$1.LUMINANCE,LUMINANCE_ALPHA:WebGLConstants$1.LUMINANCE_ALPHA,RGB_DXT1:WebGLConstants$1.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGBA_ASTC:WebGLConstants$1.COMPRESSED_RGBA_ASTC_4x4_WEBGL,RGB_ETC1:WebGLConstants$1.COMPRESSED_RGB_ETC1_WEBGL,RGB8_ETC2:WebGLConstants$1.COMPRESSED_RGB8_ETC2,RGBA8_ETC2_EAC:WebGLConstants$1.COMPRESSED_RGBA8_ETC2_EAC,RGBA_BC7:WebGLConstants$1.COMPRESSED_RGBA_BPTC_UNORM,componentsLength:function(e){switch(e){case PixelFormat.RGB:return 3;case PixelFormat.RGBA:return 4;case PixelFormat.LUMINANCE_ALPHA:return 2;case PixelFormat.ALPHA:case PixelFormat.LUMINANCE:default:return 1}},validate:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL||e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA||e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isColorFormat:function(e){return e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL},isCompressedFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isDXTFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5},isPVRTCFormat:function(e){return e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1},isASTCFormat:function(e){return e===PixelFormat.RGBA_ASTC},isETC1Format:function(e){return e===PixelFormat.RGB_ETC1},isETC2Format:function(e){return e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC},isBC7Format:function(e){return e===PixelFormat.RGBA_BC7},compressedTextureSizeInBytes:function(e,t,n){switch(e){case PixelFormat.RGB_DXT1:case PixelFormat.RGBA_DXT1:case PixelFormat.RGB_ETC1:case PixelFormat.RGB8_ETC2:return Math.floor((t+3)/4)*Math.floor((n+3)/4)*8;case PixelFormat.RGBA_DXT3:case PixelFormat.RGBA_DXT5:case PixelFormat.RGBA_ASTC:case PixelFormat.RGBA8_ETC2_EAC:return Math.floor((t+3)/4)*Math.floor((n+3)/4)*16;case PixelFormat.RGB_PVRTC_4BPPV1:case PixelFormat.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(n,8)*4+7)/8);case PixelFormat.RGB_PVRTC_2BPPV1:case PixelFormat.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(n,8)*2+7)/8);case PixelFormat.RGBA_BC7:return Math.ceil(t/4)*Math.ceil(n/4)*16;default:return 0}},textureSizeInBytes:function(e,t,n,i){let r=PixelFormat.componentsLength(e);return PixelDatatype$1.isPacked(t)&&(r=1),r*PixelDatatype$1.sizeInBytes(t)*n*i},alignmentInBytes:function(e,t,n){const i=PixelFormat.textureSizeInBytes(e,t,n,1)%4;return 0===i?4:2===i?2:1},createTypedArray:function(e,t,n,i){let r;const o=PixelDatatype$1.sizeInBytes(t);r=o===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:o===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:o===Float32Array.BYTES_PER_ELEMENT&&t===PixelDatatype$1.FLOAT?Float32Array:Uint32Array;return new r(PixelFormat.componentsLength(e)*n*i)},flipY:function(e,t,n,i,r){if(1===r)return e;const o=PixelFormat.createTypedArray(t,n,i,r),a=PixelFormat.componentsLength(t),s=i*a;for(let t=0;t<r;++t){const n=t*i*a,c=(r-t-1)*i*a;for(let t=0;t<s;++t)o[c+t]=e[n+t]}return o},toInternalFormat:function(e,t,n){if(!n.webgl2)return e;if(e===PixelFormat.DEPTH_STENCIL)return WebGLConstants$1.DEPTH24_STENCIL8;if(e===PixelFormat.DEPTH_COMPONENT){if(t===PixelDatatype$1.UNSIGNED_SHORT)return WebGLConstants$1.DEPTH_COMPONENT16;if(t===PixelDatatype$1.UNSIGNED_INT)return WebGLConstants$1.DEPTH_COMPONENT24}if(t===PixelDatatype$1.FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA32F;case PixelFormat.RGB:return WebGLConstants$1.RGB32F;case PixelFormat.RG:return WebGLConstants$1.RG32F;case PixelFormat.R:return WebGLConstants$1.R32F}if(t===PixelDatatype$1.HALF_FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA16F;case PixelFormat.RGB:return WebGLConstants$1.RGB16F;case PixelFormat.RG:return WebGLConstants$1.RG16F;case PixelFormat.R:return WebGLConstants$1.R16F}return e}};var PixelFormat$1=Object.freeze(PixelFormat);function PlaneGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=t,this._workerName="createPlaneGeometry"}PlaneGeometry.packedLength=VertexFormat.packedLength,PlaneGeometry.pack=function(e,t,n){return n=defaultValue(n,0),VertexFormat.pack(e._vertexFormat,t,n),t};const scratchVertexFormat$5=new VertexFormat,scratchOptions$9={vertexFormat:scratchVertexFormat$5};PlaneGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=VertexFormat.unpack(e,t,scratchVertexFormat$5);return defined(n)?(n._vertexFormat=VertexFormat.clone(i,n._vertexFormat),n):new PlaneGeometry(scratchOptions$9)};const min$1=new Cartesian3(-.5,-.5,0),max$1=new Cartesian3(.5,.5,0);function PlaneOutlineGeometry(){this._workerName="createPlaneOutlineGeometry"}PlaneGeometry.createGeometry=function(e){const t=e._vertexFormat,n=new GeometryAttributes;let i,r;if(t.position){if(r=new Float64Array(12),r[0]=min$1.x,r[1]=min$1.y,r[2]=0,r[3]=max$1.x,r[4]=min$1.y,r[5]=0,r[6]=max$1.x,r[7]=max$1.y,r[8]=0,r[9]=min$1.x,r[10]=max$1.y,r[11]=0,n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:r}),t.normal){const e=new Float32Array(12);e[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=1,e[9]=0,e[10]=0,e[11]=1,n.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}if(t.st){const e=new Float32Array(8);e[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=1,e[5]=1,e[6]=0,e[7]=1,n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:e})}if(t.tangent){const e=new Float32Array(12);e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0,e[6]=1,e[7]=0,e[8]=0,e[9]=1,e[10]=0,e[11]=0,n.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}if(t.bitangent){const e=new Float32Array(12);e[0]=0,e[1]=1,e[2]=0,e[3]=0,e[4]=1,e[5]=0,e[6]=0,e[7]=1,e[8]=0,e[9]=0,e[10]=1,e[11]=0,n.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}i=new Uint16Array(6),i[0]=0,i[1]=1,i[2]=2,i[3]=0,i[4]=2,i[5]=3}return new Geometry({attributes:n,indices:i,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})},PlaneOutlineGeometry.packedLength=0,PlaneOutlineGeometry.pack=function(e,t){return t},PlaneOutlineGeometry.unpack=function(e,t,n){return defined(n)?n:new PlaneOutlineGeometry};const min=new Cartesian3(-.5,-.5,0),max=new Cartesian3(.5,.5,0);PlaneOutlineGeometry.createGeometry=function(){const e=new GeometryAttributes,t=new Uint16Array(8),n=new Float64Array(12);return n[0]=min.x,n[1]=min.y,n[2]=min.z,n[3]=max.x,n[4]=min.y,n[5]=min.z,n[6]=max.x,n[7]=max.y,n[8]=min.z,n[9]=min.x,n[10]=max.y,n[11]=min.z,e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:n}),t[0]=0,t[1]=1,t[2]=1,t[3]=2,t[4]=2,t[5]=3,t[6]=3,t[7]=0,new Geometry({attributes:e,indices:t,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})};const scratchCarto1=new Cartographic,scratchCarto2=new Cartographic;function adjustPosHeightsForNormal(e,t,n,i){const r=i.cartesianToCartographic(e,scratchCarto1).height,o=i.cartesianToCartographic(t,scratchCarto2);o.height=r,i.cartographicToCartesian(o,t);const a=i.cartesianToCartographic(n,scratchCarto2);a.height=r-100,i.cartographicToCartesian(a,n)}const scratchBoundingRectangle=new BoundingRectangle,scratchPosition$a=new Cartesian3,scratchNormal$2=new Cartesian3,scratchTangent$1=new Cartesian3,scratchBitangent$1=new Cartesian3,p1Scratch=new Cartesian3,p2Scratch=new Cartesian3;let scratchPerPosNormal=new Cartesian3,scratchPerPosTangent=new Cartesian3,scratchPerPosBitangent=new Cartesian3;const appendTextureCoordinatesOrigin=new Cartesian2,appendTextureCoordinatesCartesian2=new Cartesian2,appendTextureCoordinatesCartesian3=new Cartesian3,appendTextureCoordinatesQuaternion=new Quaternion,appendTextureCoordinatesMatrix3=new Matrix3,tangentMatrixScratch=new Matrix3;function computeAttributes$2(e){const t=e.vertexFormat,n=e.geometry,i=e.shadowVolume,r=n.attributes.position.values;let o=r.length;const a=e.wall,s=e.top||a,c=e.bottom||a;if(t.st||t.normal||t.tangent||t.bitangent||i){const l=e.boundingRectangle,u=e.tangentPlane,d=e.ellipsoid,h=e.stRotation,p=e.perPositionHeight,f=appendTextureCoordinatesOrigin;f.x=l.x,f.y=l.y;const m=t.st?new Float32Array(o/3*2):void 0;let g;t.normal&&(g=p&&s&&!a?n.attributes.normal.values:new Float32Array(o));const _=t.tangent?new Float32Array(o):void 0,y=t.bitangent?new Float32Array(o):void 0,C=i?new Float32Array(o):void 0;let T=0,S=0,A=scratchNormal$2,v=scratchTangent$1,E=scratchBitangent$1,b=!0,x=appendTextureCoordinatesMatrix3,P=tangentMatrixScratch;if(0!==h){let e=Quaternion.fromAxisAngle(u._plane.normal,h,appendTextureCoordinatesQuaternion);x=Matrix3.fromQuaternion(e,x),e=Quaternion.fromAxisAngle(u._plane.normal,-h,appendTextureCoordinatesQuaternion),P=Matrix3.fromQuaternion(e,P)}else x=Matrix3.clone(Matrix3.IDENTITY,x),P=Matrix3.clone(Matrix3.IDENTITY,P);let D=0,w=0;s&&c&&(D=o/2,w=o/3,o/=2);for(let n=0;n<o;n+=3){const h=Cartesian3.fromArray(r,n,appendTextureCoordinatesCartesian3);if(t.st){let e=Matrix3.multiplyByVector(x,h,scratchPosition$a);e=d.scaleToGeodeticSurface(e,e);const t=u.projectPointOntoPlane(e,appendTextureCoordinatesCartesian2);Cartesian2.subtract(t,f,t);const n=CesiumMath.clamp(t.x/l.width,0,1),i=CesiumMath.clamp(t.y/l.height,0,1);c&&(m[T+w]=n,m[T+1+w]=i),s&&(m[T]=n,m[T+1]=i),T+=2}if(t.normal||t.tangent||t.bitangent||i){const l=S+1,u=S+2;if(a){if(n+3<o){const e=Cartesian3.fromArray(r,n+3,p1Scratch);if(b){const t=Cartesian3.fromArray(r,n+o,p2Scratch);p&&adjustPosHeightsForNormal(h,e,t,d),Cartesian3.subtract(e,h,e),Cartesian3.subtract(t,h,t),A=Cartesian3.normalize(Cartesian3.cross(t,e,A),A),b=!1}Cartesian3.equalsEpsilon(e,h,CesiumMath.EPSILON10)&&(b=!0)}(t.tangent||t.bitangent)&&(E=d.geodeticSurfaceNormal(h,E),t.tangent&&(v=Cartesian3.normalize(Cartesian3.cross(E,A,v),v)))}else A=d.geodeticSurfaceNormal(h,A),(t.tangent||t.bitangent)&&(p&&(scratchPerPosNormal=Cartesian3.fromArray(g,S,scratchPerPosNormal),scratchPerPosTangent=Cartesian3.cross(Cartesian3.UNIT_Z,scratchPerPosNormal,scratchPerPosTangent),scratchPerPosTangent=Cartesian3.normalize(Matrix3.multiplyByVector(P,scratchPerPosTangent,scratchPerPosTangent),scratchPerPosTangent),t.bitangent&&(scratchPerPosBitangent=Cartesian3.normalize(Cartesian3.cross(scratchPerPosNormal,scratchPerPosTangent,scratchPerPosBitangent),scratchPerPosBitangent))),v=Cartesian3.cross(Cartesian3.UNIT_Z,A,v),v=Cartesian3.normalize(Matrix3.multiplyByVector(P,v,v),v),t.bitangent&&(E=Cartesian3.normalize(Cartesian3.cross(A,v,E),E)));t.normal&&(e.wall?(g[S+D]=A.x,g[l+D]=A.y,g[u+D]=A.z):c&&(g[S+D]=-A.x,g[l+D]=-A.y,g[u+D]=-A.z),(s&&!p||a)&&(g[S]=A.x,g[l]=A.y,g[u]=A.z)),i&&(a&&(A=d.geodeticSurfaceNormal(h,A)),C[S+D]=-A.x,C[l+D]=-A.y,C[u+D]=-A.z),t.tangent&&(e.wall?(_[S+D]=v.x,_[l+D]=v.y,_[u+D]=v.z):c&&(_[S+D]=-v.x,_[l+D]=-v.y,_[u+D]=-v.z),s&&(p?(_[S]=scratchPerPosTangent.x,_[l]=scratchPerPosTangent.y,_[u]=scratchPerPosTangent.z):(_[S]=v.x,_[l]=v.y,_[u]=v.z))),t.bitangent&&(c&&(y[S+D]=E.x,y[l+D]=E.y,y[u+D]=E.z),s&&(p?(y[S]=scratchPerPosBitangent.x,y[l]=scratchPerPosBitangent.y,y[u]=scratchPerPosBitangent.z):(y[S]=E.x,y[l]=E.y,y[u]=E.z))),S+=3}}t.st&&(n.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:m})),t.normal&&(n.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),t.tangent&&(n.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.bitangent&&(n.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),i&&(n.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C}))}if(e.extrude&&defined(e.offsetAttribute)){const t=r.length/3;let i=new Uint8Array(t);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)s&&c||a?i=arrayFill(i,1,0,t/2):s&&(i=arrayFill(i,1));else{i=arrayFill(i,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1)}n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}return n}const startCartographicScratch=new Cartographic,endCartographicScratch=new Cartographic,idlCross={westOverIDL:0,eastOverIDL:0};let ellipsoidGeodesic=new EllipsoidGeodesic;function computeRectangle$1(e,t,n,i,r){if(r=defaultValue(r,new Rectangle),!defined(e)||e.length<3)return r.west=0,r.north=0,r.south=0,r.east=0,r;if(n===ArcType$1.RHUMB)return Rectangle.fromCartesianArray(e,t,r);ellipsoidGeodesic.ellipsoid.equals(t)||(ellipsoidGeodesic=new EllipsoidGeodesic(void 0,void 0,t)),r.west=Number.POSITIVE_INFINITY,r.east=Number.NEGATIVE_INFINITY,r.south=Number.POSITIVE_INFINITY,r.north=Number.NEGATIVE_INFINITY,idlCross.westOverIDL=Number.POSITIVE_INFINITY,idlCross.eastOverIDL=Number.NEGATIVE_INFINITY;const o=1/CesiumMath.chordLength(i,t.maximumRadius),a=e.length;let s,c=t.cartesianToCartographic(e[0],endCartographicScratch),l=startCartographicScratch;for(let n=1;n<a;n++)s=l,l=c,c=t.cartesianToCartographic(e[n],s),ellipsoidGeodesic.setEndPoints(l,c),interpolateAndGrowRectangle(ellipsoidGeodesic,o,r,idlCross);return s=l,l=c,c=t.cartesianToCartographic(e[0],s),ellipsoidGeodesic.setEndPoints(l,c),interpolateAndGrowRectangle(ellipsoidGeodesic,o,r,idlCross),r.east-r.west>idlCross.eastOverIDL-idlCross.westOverIDL&&(r.west=idlCross.westOverIDL,r.east=idlCross.eastOverIDL,r.east>CesiumMath.PI&&(r.east=r.east-CesiumMath.TWO_PI),r.west>CesiumMath.PI&&(r.west=r.west-CesiumMath.TWO_PI)),r}const interpolatedCartographicScratch=new Cartographic;function interpolateAndGrowRectangle(e,t,n,i){const r=e.surfaceDistance,o=Math.ceil(r*t),a=o>0?r/(o-1):Number.POSITIVE_INFINITY;let s=0;for(let t=0;t<o;t++){const t=e.interpolateUsingSurfaceDistance(s,interpolatedCartographicScratch);s+=a;const r=t.longitude,o=t.latitude;n.west=Math.min(n.west,r),n.east=Math.max(n.east,r),n.south=Math.min(n.south,o),n.north=Math.max(n.north,o);const c=r>=0?r:r+CesiumMath.TWO_PI;i.westOverIDL=Math.min(i.westOverIDL,c),i.eastOverIDL=Math.max(i.eastOverIDL,c)}}const createGeometryFromPositionsExtrudedPositions=[];function createGeometryFromPositionsExtruded$1(e,t,n,i,r,o,a,s,c){const l={walls:[]};let u;if(o||a){const i=PolygonGeometryLibrary.createGeometryFromPositions(e,t,n,r,s,c),d=i.attributes.position.values,h=i.indices;let p,f;if(o&&a){const e=d.concat(d);p=e.length/3,f=IndexDatatype$1.createTypedArray(p,2*h.length),f.set(h);const t=h.length,n=p/2;for(u=0;u<t;u+=3){const e=f[u]+n,i=f[u+1]+n,r=f[u+2]+n;f[u+t]=r,f[u+1+t]=i,f[u+2+t]=e}if(i.attributes.position.values=e,r&&s.normal){const t=i.attributes.normal.values;i.attributes.normal.values=new Float32Array(e.length),i.attributes.normal.values.set(t)}i.indices=f}else if(a){for(p=d.length/3,f=IndexDatatype$1.createTypedArray(p,h.length),u=0;u<h.length;u+=3)f[u]=h[u+2],f[u+1]=h[u+1],f[u+2]=h[u];i.indices=f}l.topAndBottom=new GeometryInstance({geometry:i})}let d=i.outerRing,h=EllipsoidTangentPlane.fromPoints(d,e),p=h.projectPointsOntoPlane(d,createGeometryFromPositionsExtrudedPositions),f=PolygonPipeline.computeWindingOrder2D(p);f===WindingOrder$1.CLOCKWISE&&(d=d.slice().reverse());let m=PolygonGeometryLibrary.computeWallGeometry(d,e,n,r,c);l.walls.push(new GeometryInstance({geometry:m}));const g=i.holes;for(u=0;u<g.length;u++){let t=g[u];h=EllipsoidTangentPlane.fromPoints(t,e),p=h.projectPointsOntoPlane(t,createGeometryFromPositionsExtrudedPositions),f=PolygonPipeline.computeWindingOrder2D(p),f===WindingOrder$1.COUNTER_CLOCKWISE&&(t=t.slice().reverse()),m=PolygonGeometryLibrary.computeWallGeometry(t,e,n,r,c),l.walls.push(new GeometryInstance({geometry:m}))}return l}function PolygonGeometry(e){const t=e.polygonHierarchy,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.stRotation,0),a=defaultValue(e.perPositionHeight,!1),s=a&&defined(e.extrudedHeight);let c=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,c);if(!s){const e=Math.max(c,l);l=Math.min(c,l),c=e}this._vertexFormat=VertexFormat.clone(n),this._ellipsoid=Ellipsoid.clone(i),this._granularity=r,this._stRotation=o,this._height=c,this._extrudedHeight=l,this._closeTop=defaultValue(e.closeTop,!0),this._closeBottom=defaultValue(e.closeBottom,!0),this._polygonHierarchy=t,this._perPositionHeight=a,this._perPositionHeightExtrude=s,this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+VertexFormat.packedLength+12}PolygonGeometry.fromPositions=function(e){return new PolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute,arcType:e.arcType})},PolygonGeometry.pack=function(e,t,n){return n=defaultValue(n,0),n=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,n),Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._granularity,t[n++]=e._stRotation,t[n++]=e._perPositionHeightExtrude?1:0,t[n++]=e._perPositionHeight?1:0,t[n++]=e._closeTop?1:0,t[n++]=e._closeBottom?1:0,t[n++]=e._shadowVolume?1:0,t[n++]=defaultValue(e._offsetAttribute,-1),t[n++]=e._arcType,t[n]=e.packedLength,t};const scratchEllipsoid$9=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$4=new VertexFormat,dummyOptions$1={polygonHierarchy:{}};function textureCoordinateRotationPoints$1(e){const t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];const n=e._ellipsoid,i=e._polygonHierarchy.positions,r=e.rectangle;return Geometry._textureCoordinateRotationPoints(i,t,n,r)}function PolygonHierarchy(e,t){this.positions=defined(e)?e:[],this.holes=defined(t)?t:[]}PolygonGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$9);t+=Ellipsoid.packedLength;const o=VertexFormat.unpack(e,t,scratchVertexFormat$4);t+=VertexFormat.packedLength;const a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=1===e[t++],d=1===e[t++],h=1===e[t++],p=1===e[t++],f=1===e[t++],m=e[t++],g=e[t++],_=e[t];return defined(n)||(n=new PolygonGeometry(dummyOptions$1)),n._polygonHierarchy=i,n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._height=a,n._extrudedHeight=s,n._granularity=c,n._stRotation=l,n._perPositionHeightExtrude=u,n._perPositionHeight=d,n._closeTop=h,n._closeBottom=p,n._shadowVolume=f,n._offsetAttribute=-1===m?void 0:m,n._arcType=g,n.packedLength=_,n},PolygonGeometry.computeRectangle=function(e,t){const n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),i=defaultValue(e.arcType,ArcType$1.GEODESIC),r=e.polygonHierarchy,o=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$1(r.positions,o,i,n,t)},PolygonGeometry.createGeometry=function(e){const t=e._vertexFormat,n=e._ellipsoid,i=e._granularity,r=e._stRotation,o=e._polygonHierarchy,a=e._perPositionHeight,s=e._closeTop,c=e._closeBottom,l=e._arcType;let u=o.positions;if(u.length<3)return;const d=EllipsoidTangentPlane.fromPoints(u,n),h=PolygonGeometryLibrary.polygonsFromHierarchy(o,d.projectPointsOntoPlane.bind(d),!a,n),p=h.hierarchy,f=h.polygons;if(0===p.length)return;u=p[0].outerRing;const m=PolygonGeometryLibrary.computeBoundingRectangle(d.plane.normal,d.projectPointOntoPlane.bind(d),u,r,scratchBoundingRectangle),g=[],_=e._height,y=e._extrudedHeight,C={perPositionHeight:a,vertexFormat:t,geometry:void 0,tangentPlane:d,boundingRectangle:m,ellipsoid:n,stRotation:r,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:l};let T;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(_,y,0,CesiumMath.EPSILON2))for(C.extrude=!0,C.top=s,C.bottom=c,C.shadowVolume=e._shadowVolume,C.offsetAttribute=e._offsetAttribute,T=0;T<f.length;T++){const e=createGeometryFromPositionsExtruded$1(n,f[T],i,p[T],a,s,c,t,l);let r;s&&c?(r=e.topAndBottom,C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(r.geometry,_,y,n,a)):s?(r=e.topAndBottom,r.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(r.geometry.attributes.position.values,_,n,!a),C.geometry=r.geometry):c&&(r=e.topAndBottom,r.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(r.geometry.attributes.position.values,y,n,!0),C.geometry=r.geometry),(s||c)&&(C.wall=!1,r.geometry=computeAttributes$2(C),g.push(r));const o=e.walls;C.wall=!0;for(let e=0;e<o.length;e++){const t=o[e];C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(t.geometry,_,y,n,a),t.geometry=computeAttributes$2(C),g.push(t)}}else for(T=0;T<f.length;T++){const r=new GeometryInstance({geometry:PolygonGeometryLibrary.createGeometryFromPositions(n,f[T],i,a,t,l)});if(r.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(r.geometry.attributes.position.values,_,n,!a),C.geometry=r.geometry,r.geometry=computeAttributes$2(C),defined(e._offsetAttribute)){const t=r.geometry.attributes.position.values.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}g.push(r)}const S=GeometryPipeline.combineInstances(g)[0];S.attributes.position.values=new Float64Array(S.attributes.position.values),S.indices=IndexDatatype$1.createTypedArray(S.attributes.position.values.length/3,S.indices);const A=S.attributes,v=BoundingSphere.fromVertices(A.position.values);return t.position||delete A.position,new Geometry({attributes:A,indices:S.indices,primitiveType:S.primitiveType,boundingSphere:v,offsetAttribute:e._offsetAttribute})},PolygonGeometry.createShadowVolume=function(e,t,n){const i=e._granularity,r=e._ellipsoid,o=t(i,r),a=n(i,r);return new PolygonGeometry({polygonHierarchy:e._polygonHierarchy,ellipsoid:r,stRotation:e._stRotation,granularity:i,perPositionHeight:!1,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},Object.defineProperties(PolygonGeometry.prototype,{rectangle:{get:function(){if(!defined(this._rectangle)){const e=this._polygonHierarchy.positions;this._rectangle=computeRectangle$1(e,this._ellipsoid,this._arcType,this._granularity)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$1(this)),this._textureCoordinateRotationPoints}}});const createGeometryFromPositionsPositions=[],createGeometryFromPositionsSubdivided=[];function createGeometryFromPositions(e,t,n,i,r){const o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);let a,s;PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());let c=t.length,l=0;if(i)for(a=new Float64Array(2*c*3),s=0;s<c;s++){const e=t[s],n=t[(s+1)%c];a[l++]=e.x,a[l++]=e.y,a[l++]=e.z,a[l++]=n.x,a[l++]=n.y,a[l++]=n.z}else{let i=0;if(r===ArcType$1.GEODESIC)for(s=0;s<c;s++)i+=PolygonGeometryLibrary.subdivideLineCount(t[s],t[(s+1)%c],n);else if(r===ArcType$1.RHUMB)for(s=0;s<c;s++)i+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[s],t[(s+1)%c],n);for(a=new Float64Array(3*i),s=0;s<c;s++){let i;r===ArcType$1.GEODESIC?i=PolygonGeometryLibrary.subdivideLine(t[s],t[(s+1)%c],n,createGeometryFromPositionsSubdivided):r===ArcType$1.RHUMB&&(i=PolygonGeometryLibrary.subdivideRhumbLine(e,t[s],t[(s+1)%c],n,createGeometryFromPositionsSubdivided));const o=i.length;for(let e=0;e<o;++e)a[l++]=i[e]}}c=a.length/3;const u=2*c,d=IndexDatatype$1.createTypedArray(c,u);for(l=0,s=0;s<c-1;s++)d[l++]=s,d[l++]=s+1;return d[l++]=c-1,d[l++]=0,new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:d,primitiveType:PrimitiveType$1.LINES})})}function createGeometryFromPositionsExtruded(e,t,n,i,r){const o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);let a,s;PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());let c=t.length;const l=new Array(c);let u=0;if(i)for(a=new Float64Array(2*c*3*2),s=0;s<c;++s){l[s]=u/3;const e=t[s],n=t[(s+1)%c];a[u++]=e.x,a[u++]=e.y,a[u++]=e.z,a[u++]=n.x,a[u++]=n.y,a[u++]=n.z}else{let i=0;if(r===ArcType$1.GEODESIC)for(s=0;s<c;s++)i+=PolygonGeometryLibrary.subdivideLineCount(t[s],t[(s+1)%c],n);else if(r===ArcType$1.RHUMB)for(s=0;s<c;s++)i+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[s],t[(s+1)%c],n);for(a=new Float64Array(3*i*2),s=0;s<c;++s){let i;l[s]=u/3,r===ArcType$1.GEODESIC?i=PolygonGeometryLibrary.subdivideLine(t[s],t[(s+1)%c],n,createGeometryFromPositionsSubdivided):r===ArcType$1.RHUMB&&(i=PolygonGeometryLibrary.subdivideRhumbLine(e,t[s],t[(s+1)%c],n,createGeometryFromPositionsSubdivided));const o=i.length;for(let e=0;e<o;++e)a[u++]=i[e]}}c=a.length/6;const d=l.length,h=2*(2*c+d),p=IndexDatatype$1.createTypedArray(c+d,h);for(u=0,s=0;s<c;++s)p[u++]=s,p[u++]=(s+1)%c,p[u++]=s+c,p[u++]=(s+1)%c+c;for(s=0;s<d;s++){const e=l[s];p[u++]=e,p[u++]=e+c}return new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:p,primitiveType:PrimitiveType$1.LINES})})}function PolygonOutlineGeometry(e){const t=e.polygonHierarchy,n=defaultValue(e.ellipsoid,Ellipsoid.WGS84),i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.perPositionHeight,!1),o=r&&defined(e.extrudedHeight),a=defaultValue(e.arcType,ArcType$1.GEODESIC);let s=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,s);if(!o){const e=Math.max(s,c);c=Math.min(s,c),s=e}this._ellipsoid=Ellipsoid.clone(n),this._granularity=i,this._height=s,this._extrudedHeight=c,this._arcType=a,this._polygonHierarchy=t,this._perPositionHeight=r,this._perPositionHeightExtrude=o,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+8}PolygonOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),n=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,n),Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._granularity,t[n++]=e._perPositionHeightExtrude?1:0,t[n++]=e._perPositionHeight?1:0,t[n++]=e._arcType,t[n++]=defaultValue(e._offsetAttribute,-1),t[n]=e.packedLength,t};const scratchEllipsoid$8=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),dummyOptions={polygonHierarchy:{}};PolygonOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$8);t+=Ellipsoid.packedLength;const o=e[t++],a=e[t++],s=e[t++],c=1===e[t++],l=1===e[t++],u=e[t++],d=e[t++],h=e[t];return defined(n)||(n=new PolygonOutlineGeometry(dummyOptions)),n._polygonHierarchy=i,n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._height=o,n._extrudedHeight=a,n._granularity=s,n._perPositionHeight=l,n._perPositionHeightExtrude=c,n._arcType=u,n._offsetAttribute=-1===d?void 0:d,n.packedLength=h,n},PolygonOutlineGeometry.fromPositions=function(e){return new PolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},PolygonOutlineGeometry.createGeometry=function(e){const t=e._ellipsoid,n=e._granularity,i=e._polygonHierarchy,r=e._perPositionHeight,o=e._arcType,a=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(i,!r,t);if(0===a.length)return;let s;const c=[],l=CesiumMath.chordLength(n,t.maximumRadius),u=e._height,d=e._extrudedHeight;let h,p;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(u,d,0,CesiumMath.EPSILON2))for(p=0;p<a.length;p++){if(s=createGeometryFromPositionsExtruded(t,a[p],l,r,o),s.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(s.geometry,u,d,t,r),defined(e._offsetAttribute)){const t=s.geometry.attributes.position.values.length/3;let n=new Uint8Array(t);e._offsetAttribute===GeometryOffsetAttribute$1.TOP?n=arrayFill(n,1,0,t/2):(h=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,n=arrayFill(n,h)),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}c.push(s)}else for(p=0;p<a.length;p++){if(s=createGeometryFromPositions(t,a[p],l,r,o),s.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(s.geometry.attributes.position.values,u,t,!r),defined(e._offsetAttribute)){const t=s.geometry.attributes.position.values.length,n=new Uint8Array(t/3);h=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,arrayFill(n,h),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}c.push(s)}const f=GeometryPipeline.combineInstances(c)[0],m=BoundingSphere.fromVertices(f.attributes.position.values);return new Geometry({attributes:f.attributes,indices:f.indices,primitiveType:f.primitiveType,boundingSphere:m,offsetAttribute:e._offsetAttribute})};const scratchInterpolateColorsArray=[];function interpolateColors$1(e,t,n,i,r){const o=scratchInterpolateColorsArray;let a;o.length=r;const s=n.red,c=n.green,l=n.blue,u=n.alpha,d=i.red,h=i.green,p=i.blue,f=i.alpha;if(Color.equals(n,i)){for(a=0;a<r;a++)o[a]=Color.clone(n);return o}const m=(d-s)/r,g=(h-c)/r,_=(p-l)/r,y=(f-u)/r;for(a=0;a<r;a++)o[a]=new Color(s+a*m,c+a*g,l+a*_,u+a*y);return o}function PolylineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.colors,i=defaultValue(e.width,1),r=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=n,this._width=i,this._colorsPerVertex=r,this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";let o=1+t.length*Cartesian3.packedLength;o+=defined(n)?1+n.length*Color.packedLength:1,this.packedLength=o+Ellipsoid.packedLength+VertexFormat.packedLength+4}PolylineGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._colors;for(o=defined(a)?a.length:0,t[n++]=o,i=0;i<o;++i,n+=Color.packedLength)Color.pack(a[i],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._width,t[n++]=e._colorsPerVertex?1:0,t[n++]=e._arcType,t[n]=e._granularity,t};const scratchEllipsoid$7=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$3=new VertexFormat,scratchOptions$8={positions:void 0,colors:void 0,ellipsoid:scratchEllipsoid$7,vertexFormat:scratchVertexFormat$3,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};PolylineGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);r=e[t++];const a=r>0?new Array(r):void 0;for(i=0;i<r;++i,t+=Color.packedLength)a[i]=Color.unpack(e,t);const s=Ellipsoid.unpack(e,t,scratchEllipsoid$7);t+=Ellipsoid.packedLength;const c=VertexFormat.unpack(e,t,scratchVertexFormat$3);t+=VertexFormat.packedLength;const l=e[t++],u=1===e[t++],d=e[t++],h=e[t];return defined(n)?(n._positions=o,n._colors=a,n._ellipsoid=Ellipsoid.clone(s,n._ellipsoid),n._vertexFormat=VertexFormat.clone(c,n._vertexFormat),n._width=l,n._colorsPerVertex=u,n._arcType=d,n._granularity=h,n):(scratchOptions$8.positions=o,scratchOptions$8.colors=a,scratchOptions$8.width=l,scratchOptions$8.colorsPerVertex=u,scratchOptions$8.arcType=d,scratchOptions$8.granularity=h,new PolylineGeometry(scratchOptions$8))};const scratchCartesian3$5=new Cartesian3,scratchPosition$9=new Cartesian3,scratchPrevPosition=new Cartesian3,scratchNextPosition=new Cartesian3;function computeAttributes$1(e,t,n,i){const r=new GeometryAttributes;i.position&&(r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}));const o=t.length,a=e.length/3,s=(a-2*o)/(2*o),c=PolygonPipeline.triangulate(t),l=(s-1)*o*6+2*c.length,u=IndexDatatype$1.createTypedArray(a,l);let d,h,p,f,m,g;const _=2*o;let y=0;for(d=0;d<s-1;d++){for(h=0;h<o-1;h++)p=2*h+d*o*2,g=p+_,f=p+1,m=f+_,u[y++]=f,u[y++]=p,u[y++]=m,u[y++]=m,u[y++]=p,u[y++]=g;p=2*o-2+d*o*2,f=p+1,m=f+_,g=p+_,u[y++]=f,u[y++]=p,u[y++]=m,u[y++]=m,u[y++]=p,u[y++]=g}if(i.st||i.tangent||i.bitangent){const e=new Float32Array(2*a),i=1/(s-1),c=1/n.height,l=n.height/2;let u,p,f=0;for(d=0;d<s;d++){for(u=d*i,p=c*(t[0].y+l),e[f++]=u,e[f++]=p,h=1;h<o;h++)p=c*(t[h].y+l),e[f++]=u,e[f++]=p,e[f++]=u,e[f++]=p;p=c*(t[0].y+l),e[f++]=u,e[f++]=p}for(h=0;h<o;h++)u=0,p=c*(t[h].y+l),e[f++]=u,e[f++]=p;for(h=0;h<o;h++)u=(s-1)*i,p=c*(t[h].y+l),e[f++]=u,e[f++]=p;r.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:new Float32Array(e)})}const C=a-2*o;for(d=0;d<c.length;d+=3){const e=c[d]+C,t=c[d+1]+C,n=c[d+2]+C;u[y++]=e,u[y++]=t,u[y++]=n,u[y++]=n+o,u[y++]=t+o,u[y++]=e+o}let T=new Geometry({attributes:r,indices:u,boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.TRIANGLES});if(i.normal&&(T=GeometryPipeline.computeNormal(T)),i.tangent||i.bitangent){try{T=GeometryPipeline.computeTangentAndBitangent(T)}catch(e){oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}i.tangent||(T.attributes.tangent=void 0),i.bitangent||(T.attributes.bitangent=void 0),i.st||(T.attributes.st=void 0)}return T}function PolylineVolumeGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,n=e.shapePositions;this._positions=t,this._shape=n,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";let i=1+t.length*Cartesian3.packedLength;i+=1+n.length*Cartesian2.packedLength,this.packedLength=i+Ellipsoid.packedLength+VertexFormat.packedLength+2}PolylineGeometry.createGeometry=function(e){const t=e._width,n=e._vertexFormat;let i=e._colors;const r=e._colorsPerVertex,o=e._arcType,a=e._granularity,s=e._ellipsoid;let c,l,u;const d=[];let h=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon,!1,d);if(defined(i)&&d.length>0){let e=0,t=d[0];i=i.filter((function(n,i){let o=!1;return o=r?i===t||0===i&&1===t:i+1===t,!o||(e++,t=d[e],!1)}))}let p=h.length;if(p<2||t<=0)return;if(o===ArcType$1.GEODESIC||o===ArcType$1.RHUMB){let e,t;o===ArcType$1.GEODESIC?(e=CesiumMath.chordLength(a,s.maximumRadius),t=PolylinePipeline.numberOfPoints):(e=a,t=PolylinePipeline.numberOfPointsRhumbLine);const n=PolylinePipeline.extractHeights(h,s);if(defined(i)){let n=1;for(c=0;c<p-1;++c)n+=t(h[c],h[c+1],e);const o=new Array(n);let a=0;for(c=0;c<p-1;++c){const s=h[c],u=h[c+1],d=i[c],p=t(s,u,e);if(r&&c<n){const e=interpolateColors$1(s,u,d,i[c+1],p),t=e.length;for(l=0;l<t;++l)o[a++]=e[l]}else for(l=0;l<p;++l)o[a++]=Color.clone(d)}o[a]=Color.clone(i[i.length-1]),i=o,scratchInterpolateColorsArray.length=0}h=o===ArcType$1.GEODESIC?PolylinePipeline.generateCartesianArc({positions:h,minDistance:e,ellipsoid:s,height:n}):PolylinePipeline.generateCartesianRhumbArc({positions:h,granularity:e,ellipsoid:s,height:n})}p=h.length;const f=4*p-4,m=new Float64Array(3*f),g=new Float64Array(3*f),_=new Float64Array(3*f),y=new Float32Array(2*f),C=n.st?new Float32Array(2*f):void 0,T=defined(i)?new Uint8Array(4*f):void 0;let S,A=0,v=0,E=0,b=0;for(l=0;l<p;++l){let e,o;0===l?(S=scratchCartesian3$5,Cartesian3.subtract(h[0],h[1],S),Cartesian3.add(h[0],S,S)):S=h[l-1],Cartesian3.clone(S,scratchPrevPosition),Cartesian3.clone(h[l],scratchPosition$9),l===p-1?(S=scratchCartesian3$5,Cartesian3.subtract(h[p-1],h[p-2],S),Cartesian3.add(h[p-1],S,S)):S=h[l+1],Cartesian3.clone(S,scratchNextPosition),defined(T)&&(e=0===l||r?i[l]:i[l-1],l!==p-1&&(o=i[l]));const a=l===p-1?2:4;for(u=0===l?2:0;u<a;++u){Cartesian3.pack(scratchPosition$9,m,A),Cartesian3.pack(scratchPrevPosition,g,A),Cartesian3.pack(scratchNextPosition,_,A),A+=3;const i=u-2<0?-1:1;if(y[v++]=u%2*2-1,y[v++]=i*t,n.st&&(C[E++]=l/(p-1),C[E++]=Math.max(y[v-2],0)),defined(T)){const t=u<2?e:o;T[b++]=Color.floatToByte(t.red),T[b++]=Color.floatToByte(t.green),T[b++]=Color.floatToByte(t.blue),T[b++]=Color.floatToByte(t.alpha)}}}const x=new GeometryAttributes;x.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:m}),x.prevPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:g}),x.nextPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:_}),x.expandAndWidth=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:y}),n.st&&(x.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:C})),defined(T)&&(x.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:T,normalize:!0}));const P=IndexDatatype$1.createTypedArray(f,6*p-6);let D=0,w=0;const M=p-1;for(l=0;l<M;++l)P[w++]=D,P[w++]=D+2,P[w++]=D+1,P[w++]=D+1,P[w++]=D+2,P[w++]=D+3,D+=4;return new Geometry({attributes:x,indices:P,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromPoints(h),geometryType:GeometryType$1.POLYLINES})},PolylineVolumeGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._shape;for(o=a.length,t[n++]=o,i=0;i<o;++i,n+=Cartesian2.packedLength)Cartesian2.pack(a[i],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._cornerType,t[n]=e._granularity,t};const scratchEllipsoid$6=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$2=new VertexFormat,scratchOptions$7={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$6,vertexFormat:scratchVertexFormat$2,cornerType:void 0,granularity:void 0};PolylineVolumeGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);r=e[t++];const a=new Array(r);for(i=0;i<r;++i,t+=Cartesian2.packedLength)a[i]=Cartesian2.unpack(e,t);const s=Ellipsoid.unpack(e,t,scratchEllipsoid$6);t+=Ellipsoid.packedLength;const c=VertexFormat.unpack(e,t,scratchVertexFormat$2);t+=VertexFormat.packedLength;const l=e[t++],u=e[t];return defined(n)?(n._positions=o,n._shape=a,n._ellipsoid=Ellipsoid.clone(s,n._ellipsoid),n._vertexFormat=VertexFormat.clone(c,n._vertexFormat),n._cornerType=l,n._granularity=u,n):(scratchOptions$7.polylinePositions=o,scratchOptions$7.shapePositions=a,scratchOptions$7.cornerType=l,scratchOptions$7.granularity=u,new PolylineVolumeGeometry(scratchOptions$7))};const brScratch$1=new BoundingRectangle;function computeAttributes(e,t){const n=new GeometryAttributes;n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e});const i=t.length,r=n.position.values.length/3,o=e.length/3/i,a=IndexDatatype$1.createTypedArray(r,2*i*(o+1));let s,c,l=0;s=0;let u=s*i;for(c=0;c<i-1;c++)a[l++]=c+u,a[l++]=c+u+1;for(a[l++]=i-1+u,a[l++]=u,s=o-1,u=s*i,c=0;c<i-1;c++)a[l++]=c+u,a[l++]=c+u+1;for(a[l++]=i-1+u,a[l++]=u,s=0;s<o-1;s++){const e=i*s,t=e+i;for(c=0;c<i;c++)a[l++]=c+e,a[l++]=c+t}return new Geometry({attributes:n,indices:IndexDatatype$1.createTypedArray(r,a),boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.LINES})}function PolylineVolumeOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,n=e.shapePositions;this._positions=t,this._shape=n,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";let i=1+t.length*Cartesian3.packedLength;i+=1+n.length*Cartesian2.packedLength,this.packedLength=i+Ellipsoid.packedLength+2}PolylineVolumeGeometry.createGeometry=function(e){const t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon);let n=e._shape;if(n=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(n),t.length<2||n.length<3)return;PolygonPipeline.computeWindingOrder2D(n)===WindingOrder$1.CLOCKWISE&&n.reverse();const i=BoundingRectangle.fromPoints(n,brScratch$1);return computeAttributes$1(PolylineVolumeGeometryLibrary.computePositions(t,n,i,e,!0),n,i,e._vertexFormat)},PolylineVolumeOutlineGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._shape;for(o=a.length,t[n++]=o,i=0;i<o;++i,n+=Cartesian2.packedLength)Cartesian2.pack(a[i],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._cornerType,t[n]=e._granularity,t};const scratchEllipsoid$5=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$6={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$5,height:void 0,cornerType:void 0,granularity:void 0};PolylineVolumeOutlineGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);r=e[t++];const a=new Array(r);for(i=0;i<r;++i,t+=Cartesian2.packedLength)a[i]=Cartesian2.unpack(e,t);const s=Ellipsoid.unpack(e,t,scratchEllipsoid$5);t+=Ellipsoid.packedLength;const c=e[t++],l=e[t];return defined(n)?(n._positions=o,n._shape=a,n._ellipsoid=Ellipsoid.clone(s,n._ellipsoid),n._cornerType=c,n._granularity=l,n):(scratchOptions$6.polylinePositions=o,scratchOptions$6.shapePositions=a,scratchOptions$6.cornerType=c,scratchOptions$6.granularity=l,new PolylineVolumeOutlineGeometry(scratchOptions$6))};const brScratch=new BoundingRectangle;function Proxy(){DeveloperError.throwInstantiationError()}function createEvaluateFunction(e){const t=e.points,n=e.times;return function(i,r){defined(r)||(r=new Quaternion);const o=e._lastTimeIndex=e.findTimeInterval(i,e._lastTimeIndex),a=(i-n[o])/(n[o+1]-n[o]),s=t[o],c=t[o+1];return Quaternion.fastSlerp(s,c,a,r)}}function QuaternionSpline(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,n=e.times;this._times=n,this._points=t,this._evaluateFunction=createEvaluateFunction(this),this._lastTimeIndex=0}function quickselect(e,t,n,i,r){quickselectStep(e,t,n||0,i||e.length-1,r||defaultCompare)}function quickselectStep(e,t,n,i,r){for(;i>n;){if(i-n>600){var o=i-n+1,a=t-n+1,s=Math.log(o),c=.5*Math.exp(2*s/3),l=.5*Math.sqrt(s*c*(o-c)/o)*(a-o/2<0?-1:1);quickselectStep(e,t,Math.max(n,Math.floor(t-a*c/o+l)),Math.min(i,Math.floor(t+(o-a)*c/o+l)),r)}var u=e[t],d=n,h=i;for(swap$1(e,n,t),r(e[i],u)>0&&swap$1(e,n,i);d<h;){for(swap$1(e,d,h),d++,h--;r(e[d],u)<0;)d++;for(;r(e[h],u)>0;)h--}0===r(e[n],u)?swap$1(e,n,h):swap$1(e,++h,i),h<=t&&(n=h+1),t<=h&&(i=h-1)}}function swap$1(e,t,n){var i=e[t];e[t]=e[n],e[n]=i}function defaultCompare(e,t){return e<t?-1:e>t?1:0}PolylineVolumeOutlineGeometry.createGeometry=function(e){const t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon);let n=e._shape;if(n=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(n),t.length<2||n.length<3)return;PolygonPipeline.computeWindingOrder2D(n)===WindingOrder$1.CLOCKWISE&&n.reverse();const i=BoundingRectangle.fromPoints(n,brScratch);return computeAttributes(PolylineVolumeGeometryLibrary.computePositions(t,n,i,e,!1),n)},Proxy.prototype.getURL=DeveloperError.throwInstantiationError,Object.defineProperties(QuaternionSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),QuaternionSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,QuaternionSpline.prototype.wrapTime=Spline.prototype.wrapTime,QuaternionSpline.prototype.clampTime=Spline.prototype.clampTime,QuaternionSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)};class RBush{constructor(e=9){this._maxEntries=Math.max(4,e),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()}all(){return this._all(this.data,[])}search(e){let t=this.data;const n=[];if(!intersects(e,t))return n;const i=this.toBBox,r=[];for(;t;){for(let o=0;o<t.children.length;o++){const a=t.children[o],s=t.leaf?i(a):a;intersects(e,s)&&(t.leaf?n.push(a):contains$1(e,s)?this._all(a,n):r.push(a))}t=r.pop()}return n}collides(e){let t=this.data;if(!intersects(e,t))return!1;const n=[];for(;t;){for(let i=0;i<t.children.length;i++){const r=t.children[i],o=t.leaf?this.toBBox(r):r;if(intersects(e,o)){if(t.leaf||contains$1(e,o))return!0;n.push(r)}}t=n.pop()}return!1}load(e){if(!e||!e.length)return this;if(e.length<this._minEntries){for(let t=0;t<e.length;t++)this.insert(e[t]);return this}let t=this._build(e.slice(),0,e.length-1,0);if(this.data.children.length)if(this.data.height===t.height)this._splitRoot(this.data,t);else{if(this.data.height<t.height){const e=this.data;this.data=t,t=e}this._insert(t,this.data.height-t.height-1,!0)}else this.data=t;return this}insert(e){return e&&this._insert(e,this.data.height-1),this}clear(){return this.data=createNode([]),this}remove(e,t){if(!e)return this;let n=this.data;const i=this.toBBox(e),r=[],o=[];let a,s,c;for(;n||r.length;){if(n||(n=r.pop(),s=r[r.length-1],a=o.pop(),c=!0),n.leaf){const i=findItem(e,n.children,t);if(-1!==i)return n.children.splice(i,1),r.push(n),this._condense(r),this}c||n.leaf||!contains$1(n,i)?s?(a++,n=s.children[a],c=!1):n=null:(r.push(n),o.push(a),a=0,s=n,n=n.children[0])}return this}toBBox(e){return e}compareMinX(e,t){return e.minX-t.minX}compareMinY(e,t){return e.minY-t.minY}toJSON(){return this.data}fromJSON(e){return this.data=e,this}_all(e,t){const n=[];for(;e;)e.leaf?t.push(...e.children):n.push(...e.children),e=n.pop();return t}_build(e,t,n,i){const r=n-t+1;let o,a=this._maxEntries;if(r<=a)return o=createNode(e.slice(t,n+1)),calcBBox(o,this.toBBox),o;i||(i=Math.ceil(Math.log(r)/Math.log(a)),a=Math.ceil(r/Math.pow(a,i-1))),o=createNode([]),o.leaf=!1,o.height=i;const s=Math.ceil(r/a),c=s*Math.ceil(Math.sqrt(a));multiSelect(e,t,n,c,this.compareMinX);for(let r=t;r<=n;r+=c){const t=Math.min(r+c-1,n);multiSelect(e,r,t,s,this.compareMinY);for(let n=r;n<=t;n+=s){const r=Math.min(n+s-1,t);o.children.push(this._build(e,n,r,i-1))}}return calcBBox(o,this.toBBox),o}_chooseSubtree(e,t,n,i){for(;i.push(t),!t.leaf&&i.length-1!==n;){let n,i=1/0,r=1/0;for(let o=0;o<t.children.length;o++){const a=t.children[o],s=bboxArea(a),c=enlargedArea(e,a)-s;c<r?(r=c,i=s<i?s:i,n=a):c===r&&s<i&&(i=s,n=a)}t=n||t.children[0]}return t}_insert(e,t,n){const i=n?e:this.toBBox(e),r=[],o=this._chooseSubtree(i,this.data,t,r);for(o.children.push(e),extend(o,i);t>=0&&r[t].children.length>this._maxEntries;)this._split(r,t),t--;this._adjustParentBBoxes(i,r,t)}_split(e,t){const n=e[t],i=n.children.length,r=this._minEntries;this._chooseSplitAxis(n,r,i);const o=this._chooseSplitIndex(n,r,i),a=createNode(n.children.splice(o,n.children.length-o));a.height=n.height,a.leaf=n.leaf,calcBBox(n,this.toBBox),calcBBox(a,this.toBBox),t?e[t-1].children.push(a):this._splitRoot(n,a)}_splitRoot(e,t){this.data=createNode([e,t]),this.data.height=e.height+1,this.data.leaf=!1,calcBBox(this.data,this.toBBox)}_chooseSplitIndex(e,t,n){let i,r=1/0,o=1/0;for(let a=t;a<=n-t;a++){const t=distBBox(e,0,a,this.toBBox),s=distBBox(e,a,n,this.toBBox),c=intersectionArea(t,s),l=bboxArea(t)+bboxArea(s);c<r?(r=c,i=a,o=l<o?l:o):c===r&&l<o&&(o=l,i=a)}return i||n-t}_chooseSplitAxis(e,t,n){const i=e.leaf?this.compareMinX:compareNodeMinX,r=e.leaf?this.compareMinY:compareNodeMinY;this._allDistMargin(e,t,n,i)<this._allDistMargin(e,t,n,r)&&e.children.sort(i)}_allDistMargin(e,t,n,i){e.children.sort(i);const r=this.toBBox,o=distBBox(e,0,t,r),a=distBBox(e,n-t,n,r);let s=bboxMargin(o)+bboxMargin(a);for(let i=t;i<n-t;i++){const t=e.children[i];extend(o,e.leaf?r(t):t),s+=bboxMargin(o)}for(let i=n-t-1;i>=t;i--){const t=e.children[i];extend(a,e.leaf?r(t):t),s+=bboxMargin(a)}return s}_adjustParentBBoxes(e,t,n){for(let i=n;i>=0;i--)extend(t[i],e)}_condense(e){for(let t,n=e.length-1;n>=0;n--)0===e[n].children.length?n>0?(t=e[n-1].children,t.splice(t.indexOf(e[n]),1)):this.clear():calcBBox(e[n],this.toBBox)}}function findItem(e,t,n){if(!n)return t.indexOf(e);for(let i=0;i<t.length;i++)if(n(e,t[i]))return i;return-1}function calcBBox(e,t){distBBox(e,0,e.children.length,t,e)}function distBBox(e,t,n,i,r){r||(r=createNode(null)),r.minX=1/0,r.minY=1/0,r.maxX=-1/0,r.maxY=-1/0;for(let o=t;o<n;o++){const t=e.children[o];extend(r,e.leaf?i(t):t)}return r}function extend(e,t){return e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),e}function compareNodeMinX(e,t){return e.minX-t.minX}function compareNodeMinY(e,t){return e.minY-t.minY}function bboxArea(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function bboxMargin(e){return e.maxX-e.minX+(e.maxY-e.minY)}function enlargedArea(e,t){return(Math.max(t.maxX,e.maxX)-Math.min(t.minX,e.minX))*(Math.max(t.maxY,e.maxY)-Math.min(t.minY,e.minY))}function intersectionArea(e,t){const n=Math.max(e.minX,t.minX),i=Math.max(e.minY,t.minY),r=Math.min(e.maxX,t.maxX),o=Math.min(e.maxY,t.maxY);return Math.max(0,r-n)*Math.max(0,o-i)}function contains$1(e,t){return e.minX<=t.minX&&e.minY<=t.minY&&t.maxX<=e.maxX&&t.maxY<=e.maxY}function intersects(e,t){return t.minX<=e.maxX&&t.minY<=e.maxY&&t.maxX>=e.minX&&t.maxY>=e.minY}function createNode(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function multiSelect(e,t,n,i,r){const o=[t,n];for(;o.length;){if((n=o.pop())-(t=o.pop())<=i)continue;const a=t+Math.ceil((n-t)/i/2)*i;quickselect(e,a,t,n,r),o.push(t,a,a,n)}}function RectangleCollisionChecker(){this._tree=new RBush}function RectangleWithId(){this.minX=0,this.minY=0,this.maxX=0,this.maxY=0,this.id=""}function idCompare(e,t){return e.id===t.id}RectangleWithId.fromRectangleAndId=function(e,t,n){return n.minX=t.west,n.minY=t.south,n.maxX=t.east,n.maxY=t.north,n.id=e,n},RectangleCollisionChecker.prototype.insert=function(e,t){const n=RectangleWithId.fromRectangleAndId(e,t,new RectangleWithId);this._tree.insert(n)};const removalScratch=new RectangleWithId;RectangleCollisionChecker.prototype.remove=function(e,t){const n=RectangleWithId.fromRectangleAndId(e,t,removalScratch);this._tree.remove(n,idCompare)};const collisionScratch=new RectangleWithId;RectangleCollisionChecker.prototype.collides=function(e){const t=RectangleWithId.fromRectangleAndId("",e,collisionScratch);return this._tree.collides(t)};const cos=Math.cos,sin=Math.sin,sqrt=Math.sqrt,RectangleGeometryLibrary={computePosition:function(e,t,n,i,r,o,a){const s=t.radiiSquared,c=e.nwCorner,l=e.boundingRectangle;let u=c.latitude-e.granYCos*i+r*e.granXSin;const d=cos(u),h=sin(u),p=s.z*h;let f=c.longitude+i*e.granYSin+r*e.granXCos;const m=d*cos(f),g=d*sin(f),_=s.x*m,y=s.y*g,C=sqrt(_*m+y*g+p*h);if(o.x=_/C,o.y=y/C,o.z=p/C,n){const t=e.stNwCorner;defined(t)?(u=t.latitude-e.stGranYCos*i+r*e.stGranXSin,f=t.longitude+i*e.stGranYSin+r*e.stGranXCos,a.x=(f-e.stWest)*e.lonScalar,a.y=(u-e.stSouth)*e.latScalar):(a.x=(f-l.west)*e.lonScalar,a.y=(u-l.south)*e.latScalar)}}},rotationMatrixScratch=new Matrix2;let nwCartesian=new Cartesian3;const centerScratch$3=new Cartographic;let centerCartesian=new Cartesian3;const proj=new GeographicProjection;function getRotationOptions(e,t,n,i,r,o,a){const s=Math.cos(t),c=i*s,l=n*s,u=Math.sin(t),d=i*u,h=n*u;nwCartesian=proj.project(e,nwCartesian),nwCartesian=Cartesian3.subtract(nwCartesian,centerCartesian,nwCartesian);const p=Matrix2.fromRotation(t,rotationMatrixScratch);nwCartesian=Matrix2.multiplyByVector(p,nwCartesian,nwCartesian),nwCartesian=Cartesian3.add(nwCartesian,centerCartesian,nwCartesian),o-=1,a-=1;const f=(e=proj.unproject(nwCartesian,e)).latitude,m=f+o*h,g=f-c*a,_=f-c*a+o*h,y=Math.max(f,m,g,_),C=Math.min(f,m,g,_),T=e.longitude,S=T+o*l,A=T+a*d,v=T+a*d+o*l;return{north:y,south:C,east:Math.max(T,S,A,v),west:Math.min(T,S,A,v),granYCos:c,granYSin:d,granXCos:l,granXSin:h,nwCorner:e}}RectangleGeometryLibrary.computeOptions=function(e,t,n,i,r,o,a){let s,c=e.east,l=e.west,u=e.north,d=e.south,h=!1,p=!1;u===CesiumMath.PI_OVER_TWO&&(h=!0),d===-CesiumMath.PI_OVER_TWO&&(p=!0);const f=u-d;s=l>c?CesiumMath.TWO_PI-l+c:c-l;const m=Math.ceil(s/t)+1,g=Math.ceil(f/t)+1,_=s/(m-1),y=f/(g-1),C=Rectangle.northwest(e,o),T=Rectangle.center(e,centerScratch$3);0===n&&0===i||(T.longitude<C.longitude&&(T.longitude+=CesiumMath.TWO_PI),centerCartesian=proj.project(T,centerCartesian));const S=y,A=_,v=Rectangle.clone(e,r),E={granYCos:S,granYSin:0,granXCos:A,granXSin:0,nwCorner:C,boundingRectangle:v,width:m,height:g,northCap:h,southCap:p};if(0!==n){const e=getRotationOptions(C,n,_,y,T,m,g);u=e.north,d=e.south,c=e.east,l=e.west,E.granYCos=e.granYCos,E.granYSin=e.granYSin,E.granXCos=e.granXCos,E.granXSin=e.granXSin,v.north=u,v.south=d,v.east=c,v.west=l}if(0!==i){n-=i;const e=Rectangle.northwest(v,a),t=getRotationOptions(e,n,_,y,T,m,g);E.stGranYCos=t.granYCos,E.stGranXCos=t.granXCos,E.stGranYSin=t.granYSin,E.stGranXSin=t.granXSin,E.stNwCorner=e,E.stWest=t.west,E.stSouth=t.south}return E};const positionScratch$a=new Cartesian3,normalScratch$2=new Cartesian3,tangentScratch=new Cartesian3,bitangentScratch=new Cartesian3,rectangleScratch$4=new Rectangle,stScratch=new Cartesian2,bottomBoundingSphere$1=new BoundingSphere,topBoundingSphere$1=new BoundingSphere;function createAttributes(e,t){const n=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.TRIANGLES});return n.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(n.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(n.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(n.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.bitangents})),n}function calculateAttributes(e,t,n,i){const r=e.length,o=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,s=t.bitangent?new Float32Array(r):void 0;let c=0;const l=bitangentScratch,u=tangentScratch;let d=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(let h=0;h<r;h+=3){const r=Cartesian3.fromArray(e,h,positionScratch$a),p=c+1,f=c+2;d=n.geodeticSurfaceNormal(r,d),(t.tangent||t.bitangent)&&(Cartesian3.cross(Cartesian3.UNIT_Z,d,u),Matrix3.multiplyByVector(i,u,u),Cartesian3.normalize(u,u),t.bitangent&&Cartesian3.normalize(Cartesian3.cross(d,u,l),l)),t.normal&&(o[c]=d.x,o[p]=d.y,o[f]=d.z),t.tangent&&(a[c]=u.x,a[p]=u.y,a[f]=u.z),t.bitangent&&(s[c]=l.x,s[p]=l.y,s[f]=l.z),c+=3}return createAttributes(t,{positions:e,normals:o,tangents:a,bitangents:s})}const v1Scratch=new Cartesian3,v2Scratch=new Cartesian3;function calculateAttributesWall(e,t,n){const i=e.length,r=t.normal?new Float32Array(i):void 0,o=t.tangent?new Float32Array(i):void 0,a=t.bitangent?new Float32Array(i):void 0;let s=0,c=0,l=0,u=!0,d=bitangentScratch,h=tangentScratch,p=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(let f=0;f<i;f+=6){const m=Cartesian3.fromArray(e,f,positionScratch$a),g=Cartesian3.fromArray(e,(f+6)%i,v1Scratch);if(u){const t=Cartesian3.fromArray(e,(f+3)%i,v2Scratch);Cartesian3.subtract(g,m,g),Cartesian3.subtract(t,m,t),p=Cartesian3.normalize(Cartesian3.cross(t,g,p),p),u=!1}Cartesian3.equalsEpsilon(g,m,CesiumMath.EPSILON10)&&(u=!0),(t.tangent||t.bitangent)&&(d=n.geodeticSurfaceNormal(m,d),t.tangent&&(h=Cartesian3.normalize(Cartesian3.cross(d,p,h),h))),t.normal&&(r[s++]=p.x,r[s++]=p.y,r[s++]=p.z,r[s++]=p.x,r[s++]=p.y,r[s++]=p.z),t.tangent&&(o[c++]=h.x,o[c++]=h.y,o[c++]=h.z,o[c++]=h.x,o[c++]=h.y,o[c++]=h.z),t.bitangent&&(a[l++]=d.x,a[l++]=d.y,a[l++]=d.z,a[l++]=d.x,a[l++]=d.y,a[l++]=d.z)}return createAttributes(t,{positions:e,normals:r,tangents:o,bitangents:a})}function constructRectangle$1(e,t){const n=e._vertexFormat,i=e._ellipsoid,r=t.height,o=t.width,a=t.northCap,s=t.southCap;let c=0,l=r,u=r,d=0;a&&(c=1,u-=1,d+=1),s&&(l-=1,u-=1,d+=1),d+=o*u;const h=n.position?new Float64Array(3*d):void 0,p=n.st?new Float32Array(2*d):void 0;let f=0,m=0;const g=positionScratch$a,_=stScratch;let y=Number.MAX_VALUE,C=Number.MAX_VALUE,T=-Number.MAX_VALUE,S=-Number.MAX_VALUE;for(let e=c;e<l;++e)for(let r=0;r<o;++r)RectangleGeometryLibrary.computePosition(t,i,n.st,e,r,g,_),h[f++]=g.x,h[f++]=g.y,h[f++]=g.z,n.st&&(p[m++]=_.x,p[m++]=_.y,y=Math.min(y,_.x),C=Math.min(C,_.y),T=Math.max(T,_.x),S=Math.max(S,_.y));if(a&&(RectangleGeometryLibrary.computePosition(t,i,n.st,0,0,g,_),h[f++]=g.x,h[f++]=g.y,h[f++]=g.z,n.st&&(p[m++]=_.x,p[m++]=_.y,y=_.x,C=_.y,T=_.x,S=_.y)),s&&(RectangleGeometryLibrary.computePosition(t,i,n.st,r-1,0,g,_),h[f++]=g.x,h[f++]=g.y,h[f]=g.z,n.st&&(p[m++]=_.x,p[m]=_.y,y=Math.min(y,_.x),C=Math.min(C,_.y),T=Math.max(T,_.x),S=Math.max(S,_.y))),n.st&&(y<0||C<0||T>1||S>1))for(let e=0;e<p.length;e+=2)p[e]=(p[e]-y)/(T-y),p[e+1]=(p[e+1]-C)/(S-C);const A=calculateAttributes(h,n,i,t.tangentRotationMatrix);let v=6*(o-1)*(u-1);a&&(v+=3*(o-1)),s&&(v+=3*(o-1));const E=IndexDatatype$1.createTypedArray(d,v);let b,x=0,P=0;for(b=0;b<u-1;++b){for(let e=0;e<o-1;++e){const e=x,t=e+o,n=t+1,i=e+1;E[P++]=e,E[P++]=t,E[P++]=i,E[P++]=i,E[P++]=t,E[P++]=n,++x}++x}if(a||s){let e=d-1;const t=d-1;let n,i;if(a&&s&&(e=d-2),x=0,a)for(b=0;b<o-1;b++)n=x,i=n+1,E[P++]=e,E[P++]=n,E[P++]=i,++x;if(s)for(x=(u-1)*o,b=0;b<o-1;b++)n=x,i=n+1,E[P++]=n,E[P++]=t,E[P++]=i,++x}return A.indices=E,n.st&&(A.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:p})),A}function addWallPositions(e,t,n,i,r){return e[t++]=i[n],e[t++]=i[n+1],e[t++]=i[n+2],e[t++]=r[n],e[t++]=r[n+1],e[t]=r[n+2],e}function addWallTextureCoordinates(e,t,n,i){return e[t++]=i[n],e[t++]=i[n+1],e[t++]=i[n],e[t]=i[n+1],e}const scratchVertexFormat$1=new VertexFormat;function constructExtrudedRectangle$1(e,t){const n=e._shadowVolume,i=e._offsetAttribute,r=e._vertexFormat,o=e._extrudedHeight,a=e._surfaceHeight,s=e._ellipsoid,c=t.height,l=t.width;let u;if(n){const t=VertexFormat.clone(r,scratchVertexFormat$1);t.normal=!0,e._vertexFormat=t}const d=constructRectangle$1(e,t);n&&(e._vertexFormat=r);let h=PolygonPipeline.scaleToGeodeticHeight(d.attributes.position.values,a,s,!1);h=new Float64Array(h);let p=h.length;const f=2*p,m=new Float64Array(f);m.set(h);const g=PolygonPipeline.scaleToGeodeticHeight(d.attributes.position.values,o,s);m.set(g,p),d.attributes.position.values=m;const _=r.normal?new Float32Array(f):void 0,y=r.tangent?new Float32Array(f):void 0,C=r.bitangent?new Float32Array(f):void 0,T=r.st?new Float32Array(f/3*2):void 0;let S,A,v;if(r.normal){for(A=d.attributes.normal.values,_.set(A),u=0;u<p;u++)A[u]=-A[u];_.set(A,p),d.attributes.normal.values=_}if(n){A=d.attributes.normal.values,r.normal||(d.attributes.normal=void 0);const e=new Float32Array(f);for(u=0;u<p;u++)A[u]=-A[u];e.set(A,p),d.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})}const E=defined(i);if(E){const e=p/3*2;let t=new Uint8Array(e);i===GeometryOffsetAttribute$1.TOP?t=arrayFill(t,1,0,e/2):(v=i===GeometryOffsetAttribute$1.NONE?0:1,t=arrayFill(t,v)),d.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}if(r.tangent){const e=d.attributes.tangent.values;for(y.set(e),u=0;u<p;u++)e[u]=-e[u];y.set(e,p),d.attributes.tangent.values=y}if(r.bitangent){const e=d.attributes.bitangent.values;C.set(e),C.set(e,p),d.attributes.bitangent.values=C}r.st&&(S=d.attributes.st.values,T.set(S),T.set(S,p/3*2),d.attributes.st.values=T);const b=d.indices,x=b.length,P=p/3,D=IndexDatatype$1.createTypedArray(f/3,2*x);for(D.set(b),u=0;u<x;u+=3)D[u+x]=b[u+2]+P,D[u+1+x]=b[u+1]+P,D[u+2+x]=b[u]+P;d.indices=D;const w=t.northCap,M=t.southCap;let I=c,R=2,O=0,B=4,L=4;w&&(R-=1,I-=1,O+=1,B-=2,L-=1),M&&(R-=1,I-=1,O+=1,B-=2,L-=1),O+=R*l+2*I-B;const F=2*(O+L);let N=new Float64Array(3*F);const V=n?new Float32Array(3*F):void 0;let $=E?new Uint8Array(F):void 0,k=r.st?new Float32Array(2*F):void 0;const U=i===GeometryOffsetAttribute$1.TOP;E&&!U&&(v=i===GeometryOffsetAttribute$1.ALL?1:0,$=arrayFill($,v));let G=0,z=0,H=0,W=0;const q=l*I;let j;for(u=0;u<q;u+=l)j=3*u,N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*u,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1);if(M){const e=w?q+1:q;for(j=3*e,u=0;u<2;u++)N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*e,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1)}else for(u=q-l;u<q;u++)j=3*u,N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*u,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1);for(u=q-1;u>0;u-=l)j=3*u,N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*u,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1);if(w){const e=q;for(j=3*e,u=0;u<2;u++)N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*e,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1)}else for(u=l-1;u>=0;u--)j=3*u,N=addWallPositions(N,G,j,h,g),G+=6,r.st&&(k=addWallTextureCoordinates(k,z,2*u,S),z+=4),n&&(H+=3,V[H++]=A[j],V[H++]=A[j+1],V[H++]=A[j+2]),U&&($[W++]=1,W+=1);let X=calculateAttributesWall(N,r,s);r.st&&(X.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:k})),n&&(X.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:V})),E&&(X.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:$}));const Y=IndexDatatype$1.createTypedArray(F,6*O);let K,J,Q,Z;p=N.length/3;let ee=0;for(u=0;u<p-1;u+=2){K=u,Z=(K+2)%p;const e=Cartesian3.fromArray(N,3*K,v1Scratch),t=Cartesian3.fromArray(N,3*Z,v2Scratch);Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON10)||(J=(K+1)%p,Q=(J+2)%p,Y[ee++]=K,Y[ee++]=J,Y[ee++]=Z,Y[ee++]=Z,Y[ee++]=J,Y[ee++]=Q)}return X.indices=Y,X=GeometryPipeline.combineInstances([new GeometryInstance({geometry:d}),new GeometryInstance({geometry:X})]),X[0]}const scratchRectanglePoints=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],nwScratch$1=new Cartographic,stNwScratch=new Cartographic;function computeRectangle(e,t,n,i,r){if(0===n)return Rectangle.clone(e,r);const o=RectangleGeometryLibrary.computeOptions(e,t,n,0,rectangleScratch$4,nwScratch$1),a=o.height,s=o.width,c=scratchRectanglePoints;return RectangleGeometryLibrary.computePosition(o,i,!1,0,0,c[0]),RectangleGeometryLibrary.computePosition(o,i,!1,0,s-1,c[1]),RectangleGeometryLibrary.computePosition(o,i,!1,a-1,0,c[2]),RectangleGeometryLibrary.computePosition(o,i,!1,a-1,s-1,c[3]),Rectangle.fromCartesianArray(c,i,r)}function RectangleGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,n=defaultValue(e.height,0),i=defaultValue(e.extrudedHeight,n);this._rectangle=Rectangle.clone(t),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._surfaceHeight=Math.max(n,i),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._extrudedHeight=Math.min(n,i),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._offsetAttribute=e.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}RectangleGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7,RectangleGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Rectangle.pack(e._rectangle,t,n),n+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),n+=VertexFormat.packedLength,t[n++]=e._granularity,t[n++]=e._surfaceHeight,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._extrudedHeight,t[n++]=e._shadowVolume?1:0,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchRectangle$8=new Rectangle,scratchEllipsoid$4=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$5={rectangle:scratchRectangle$8,ellipsoid:scratchEllipsoid$4,vertexFormat:scratchVertexFormat$1,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};RectangleGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Rectangle.unpack(e,t,scratchRectangle$8);t+=Rectangle.packedLength;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$4);t+=Ellipsoid.packedLength;const o=VertexFormat.unpack(e,t,scratchVertexFormat$1);t+=VertexFormat.packedLength;const a=e[t++],s=e[t++],c=e[t++],l=e[t++],u=e[t++],d=1===e[t++],h=e[t];return defined(n)?(n._rectangle=Rectangle.clone(i,n._rectangle),n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._vertexFormat=VertexFormat.clone(o,n._vertexFormat),n._granularity=a,n._surfaceHeight=s,n._rotation=c,n._stRotation=l,n._extrudedHeight=u,n._shadowVolume=d,n._offsetAttribute=-1===h?void 0:h,n):(scratchOptions$5.granularity=a,scratchOptions$5.height=s,scratchOptions$5.rotation=c,scratchOptions$5.stRotation=l,scratchOptions$5.extrudedHeight=u,scratchOptions$5.shadowVolume=d,scratchOptions$5.offsetAttribute=-1===h?void 0:h,new RectangleGeometry(scratchOptions$5))},RectangleGeometry.computeRectangle=function(e,t){const n=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle(n,i,defaultValue(e.rotation,0),r,t)};const tangentRotationMatrixScratch=new Matrix3,quaternionScratch=new Quaternion,centerScratch$2=new Cartographic;RectangleGeometry.createGeometry=function(e){if(CesiumMath.equalsEpsilon(e._rectangle.north,e._rectangle.south,CesiumMath.EPSILON10)||CesiumMath.equalsEpsilon(e._rectangle.east,e._rectangle.west,CesiumMath.EPSILON10))return;let t=e._rectangle;const n=e._ellipsoid,i=e._rotation,r=e._stRotation,o=e._vertexFormat,a=RectangleGeometryLibrary.computeOptions(t,e._granularity,i,r,rectangleScratch$4,nwScratch$1,stNwScratch),s=tangentRotationMatrixScratch;if(0!==r||0!==i){const e=Rectangle.center(t,centerScratch$2),i=n.geodeticSurfaceNormalCartographic(e,v1Scratch);Quaternion.fromAxisAngle(i,-r,quaternionScratch),Matrix3.fromQuaternion(quaternionScratch,s)}else Matrix3.clone(Matrix3.IDENTITY,s);const c=e._surfaceHeight,l=e._extrudedHeight,u=!CesiumMath.equalsEpsilon(c,l,0,CesiumMath.EPSILON2);let d,h;if(a.lonScalar=1/e._rectangle.width,a.latScalar=1/e._rectangle.height,a.tangentRotationMatrix=s,t=e._rectangle,u){d=constructExtrudedRectangle$1(e,a);const i=BoundingSphere.fromRectangle3D(t,n,c,topBoundingSphere$1),r=BoundingSphere.fromRectangle3D(t,n,l,bottomBoundingSphere$1);h=BoundingSphere.union(i,r)}else{if(d=constructRectangle$1(e,a),d.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(d.attributes.position.values,c,n,!1),defined(e._offsetAttribute)){const t=d.attributes.position.values.length,n=new Uint8Array(t/3);arrayFill(n,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),d.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}h=BoundingSphere.fromRectangle3D(t,n,c)}return o.position||delete d.attributes.position,new Geometry({attributes:d.attributes,indices:d.indices,primitiveType:d.primitiveType,boundingSphere:h,offsetAttribute:e._offsetAttribute})},RectangleGeometry.createShadowVolume=function(e,t,n){const i=e._granularity,r=e._ellipsoid,o=t(i,r),a=n(i,r);return new RectangleGeometry({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:r,stRotation:e._stRotation,granularity:i,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})};const unrotatedTextureRectangleScratch=new Rectangle,points2DScratch$1=[new Cartesian2,new Cartesian2,new Cartesian2],rotation2DScratch=new Matrix2,rectangleCenterScratch$2=new Cartographic;function textureCoordinateRotationPoints(e){if(0===e._stRotation)return[0,0,0,1,1,0];const t=Rectangle.clone(e._rectangle,unrotatedTextureRectangleScratch),n=e._granularity,i=e._ellipsoid,r=computeRectangle(t,n,e._rotation-e._stRotation,i,unrotatedTextureRectangleScratch),o=points2DScratch$1;o[0].x=r.west,o[0].y=r.south,o[1].x=r.west,o[1].y=r.north,o[2].x=r.east,o[2].y=r.south;const a=e.rectangle,s=Matrix2.fromRotation(e._stRotation,rotation2DScratch),c=Rectangle.center(a,rectangleCenterScratch$2);for(let e=0;e<3;++e){const t=o[e];t.x-=c.longitude,t.y-=c.latitude,Matrix2.multiplyByVector(s,t,t),t.x+=c.longitude,t.y+=c.latitude,t.x=(t.x-a.west)/a.width,t.y=(t.y-a.south)/a.height}const l=o[0],u=o[1],d=o[2],h=new Array(6);return Cartesian2.pack(l,h),Cartesian2.pack(u,h,2),Cartesian2.pack(d,h,4),h}Object.defineProperties(RectangleGeometry.prototype,{rectangle:{get:function(){return defined(this._rotatedRectangle)||(this._rotatedRectangle=computeRectangle(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints(this)),this._textureCoordinateRotationPoints}}});const bottomBoundingSphere=new BoundingSphere,topBoundingSphere=new BoundingSphere,positionScratch$9=new Cartesian3,rectangleScratch$3=new Rectangle;function constructRectangle(e,t){const n=e._ellipsoid,i=t.height,r=t.width,o=t.northCap,a=t.southCap;let s=i,c=2,l=0,u=4;o&&(c-=1,s-=1,l+=1,u-=2),a&&(c-=1,s-=1,l+=1,u-=2),l+=c*r+2*s-u;const d=new Float64Array(3*l);let h,p=0,f=0;const m=positionScratch$9;if(o)RectangleGeometryLibrary.computePosition(t,n,!1,f,0,m),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z;else for(h=0;h<r;h++)RectangleGeometryLibrary.computePosition(t,n,!1,f,h,m),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z;for(h=r-1,f=1;f<i;f++)RectangleGeometryLibrary.computePosition(t,n,!1,f,h,m),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z;if(f=i-1,!a)for(h=r-2;h>=0;h--)RectangleGeometryLibrary.computePosition(t,n,!1,f,h,m),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z;for(h=0,f=i-2;f>0;f--)RectangleGeometryLibrary.computePosition(t,n,!1,f,h,m),d[p++]=m.x,d[p++]=m.y,d[p++]=m.z;const g=d.length/3*2,_=IndexDatatype$1.createTypedArray(d.length/3,g);let y=0;for(let e=0;e<d.length/3-1;e++)_[y++]=e,_[y++]=e+1;_[y++]=d.length/3-1,_[y++]=0;const C=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.LINES});return C.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d}),C.indices=_,C}function constructExtrudedRectangle(e,t){const n=e._surfaceHeight,i=e._extrudedHeight,r=e._ellipsoid,o=i,a=n,s=constructRectangle(e,t),c=t.height,l=t.width,u=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,a,r,!1);let d=u.length;const h=new Float64Array(2*d);h.set(u);const p=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,o,r);h.set(p,d),s.attributes.position.values=h;const f=t.northCap,m=t.southCap;let g=4;f&&(g-=1),m&&(g-=1);const _=2*(h.length/3+g),y=IndexDatatype$1.createTypedArray(h.length/3,_);d=h.length/6;let C,T=0;for(let e=0;e<d-1;e++)y[T++]=e,y[T++]=e+1,y[T++]=e+d,y[T++]=e+d+1;if(y[T++]=d-1,y[T++]=0,y[T++]=d+d-1,y[T++]=d,y[T++]=0,y[T++]=d,f)C=c-1;else{const e=l-1;y[T++]=e,y[T++]=e+d,C=l+c-2}if(y[T++]=C,y[T++]=C+d,!m){const e=l+C-1;y[T++]=e,y[T]=e+d}return s.indices=y,s}function RectangleOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=defaultValue(e.rotation,0),o=defaultValue(e.height,0),a=defaultValue(e.extrudedHeight,o);this._rectangle=Rectangle.clone(t),this._granularity=n,this._ellipsoid=i,this._surfaceHeight=Math.max(o,a),this._rotation=r,this._extrudedHeight=Math.min(o,a),this._offsetAttribute=e.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}RectangleOutlineGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+5,RectangleOutlineGeometry.pack=function(e,t,n){return n=defaultValue(n,0),Rectangle.pack(e._rectangle,t,n),n+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._granularity,t[n++]=e._surfaceHeight,t[n++]=e._rotation,t[n++]=e._extrudedHeight,t[n]=defaultValue(e._offsetAttribute,-1),t};const scratchRectangle$7=new Rectangle,scratchEllipsoid$3=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$4={rectangle:scratchRectangle$7,ellipsoid:scratchEllipsoid$3,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};RectangleOutlineGeometry.unpack=function(e,t,n){t=defaultValue(t,0);const i=Rectangle.unpack(e,t,scratchRectangle$7);t+=Rectangle.packedLength;const r=Ellipsoid.unpack(e,t,scratchEllipsoid$3);t+=Ellipsoid.packedLength;const o=e[t++],a=e[t++],s=e[t++],c=e[t++],l=e[t];return defined(n)?(n._rectangle=Rectangle.clone(i,n._rectangle),n._ellipsoid=Ellipsoid.clone(r,n._ellipsoid),n._surfaceHeight=a,n._rotation=s,n._extrudedHeight=c,n._offsetAttribute=-1===l?void 0:l,n):(scratchOptions$4.granularity=o,scratchOptions$4.height=a,scratchOptions$4.rotation=s,scratchOptions$4.extrudedHeight=c,scratchOptions$4.offsetAttribute=-1===l?void 0:l,new RectangleOutlineGeometry(scratchOptions$4))};const nwScratch=new Cartographic;RectangleOutlineGeometry.createGeometry=function(e){const t=e._rectangle,n=e._ellipsoid,i=RectangleGeometryLibrary.computeOptions(t,e._granularity,e._rotation,0,rectangleScratch$3,nwScratch);let r,o;if(CesiumMath.equalsEpsilon(t.north,t.south,CesiumMath.EPSILON10)||CesiumMath.equalsEpsilon(t.east,t.west,CesiumMath.EPSILON10))return;const a=e._surfaceHeight,s=e._extrudedHeight;let c;if(!CesiumMath.equalsEpsilon(a,s,0,CesiumMath.EPSILON2)){if(r=constructExtrudedRectangle(e,i),defined(e._offsetAttribute)){const t=r.attributes.position.values.length/3;let n=new Uint8Array(t);e._offsetAttribute===GeometryOffsetAttribute$1.TOP?n=arrayFill(n,1,0,t/2):(c=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,n=arrayFill(n,c)),r.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}const l=BoundingSphere.fromRectangle3D(t,n,a,topBoundingSphere),u=BoundingSphere.fromRectangle3D(t,n,s,bottomBoundingSphere);o=BoundingSphere.union(l,u)}else{if(r=constructRectangle(e,i),r.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(r.attributes.position.values,a,n,!1),defined(e._offsetAttribute)){const t=r.attributes.position.values.length,n=new Uint8Array(t/3);c=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,arrayFill(n,c),r.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}o=BoundingSphere.fromRectangle3D(t,n,a)}return new Geometry({attributes:r.attributes,indices:r.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:o,offsetAttribute:e._offsetAttribute})};const ReferenceFrame={FIXED:0,INERTIAL:1};var ReferenceFrame$1=Object.freeze(ReferenceFrame);const S2_MAX_LEVEL=30,S2_LIMIT_IJ=1<<S2_MAX_LEVEL,S2_MAX_SITI=1<<S2_MAX_LEVEL+1>>>0,S2_POSITION_BITS=2*S2_MAX_LEVEL+1,S2_LOOKUP_BITS=4,S2_LOOKUP_POSITIONS=[],S2_LOOKUP_IJ=[],S2_POSITION_TO_IJ=[[0,1,3,2],[0,2,3,1],[3,2,0,1],[3,1,0,2]],S2_SWAP_MASK=1,S2_INVERT_MASK=2,S2_POSITION_TO_ORIENTATION_MASK=[S2_SWAP_MASK,0,0,S2_SWAP_MASK|S2_INVERT_MASK];function S2Cell(e){if(!FeatureDetection.supportsBigInt())throw new RuntimeError("S2 required BigInt support");this._cellId=e,this._level=S2Cell.getLevel(e)}function getS2Center(e,t){const n=convertCellIdToFaceSiTi(e,t);return convertFaceSiTitoXYZ(n[0],n[1],n[2])}function getS2Vertex(e,t,n){const i=convertCellIdToFaceIJ(e),r=convertIJLeveltoBoundUV([i[1],i[2]],t),o=n>>1&1;return convertFaceUVtoXYZ(i[0],r[0][o^1&n],r[1][o])}function convertCellIdToFaceSiTi(e,t){const n=convertCellIdToFaceIJ(e),i=n[0],r=n[1],o=n[2],a=30===t,s=!a&&(BigInt(r)^e>>BigInt(2))&BigInt(1),c=a?1:s?2:0;return[i,(r<<1)+c,(o<<1)+c]}function convertCellIdToFaceIJ(e){0===S2_LOOKUP_POSITIONS.length&&generateLookupTable();const t=Number(e>>BigInt(S2_POSITION_BITS));let n=t&S2_SWAP_MASK;const i=(1<<S2_LOOKUP_BITS)-1;let r=0,o=0;for(let t=7;t>=0;t--){const a=(1<<2*(7===t?S2_MAX_LEVEL-7*S2_LOOKUP_BITS:S2_LOOKUP_BITS))-1;n+=Number(e>>BigInt(2*t*S2_LOOKUP_BITS+1)&BigInt(a))<<2,n=S2_LOOKUP_IJ[n];const s=t*S2_LOOKUP_BITS;r+=n>>S2_LOOKUP_BITS+2<<s,o+=(n>>2&i)<<s,n&=S2_SWAP_MASK|S2_INVERT_MASK}return[t,r,o]}function convertFaceSiTitoXYZ(e,t,n){const i=convertSiTitoST(t),r=convertSiTitoST(n);return convertFaceUVtoXYZ(e,convertSTtoUV(i),convertSTtoUV(r))}function convertFaceUVtoXYZ(e,t,n){switch(e){case 0:return new Cartesian3(1,t,n);case 1:return new Cartesian3(-t,1,n);case 2:return new Cartesian3(-t,-n,1);case 3:return new Cartesian3(-1,-n,-t);case 4:return new Cartesian3(n,-1,-t);default:return new Cartesian3(n,t,-1)}}function convertSTtoUV(e){return e>=.5?1/3*(4*e*e-1):1/3*(1-4*(1-e)*(1-e))}function convertSiTitoST(e){return 1/S2_MAX_SITI*e}function convertIJLeveltoBoundUV(e,t){const n=[[],[]],i=getSizeIJ(t);for(let t=0;t<2;++t){const r=e[t]&-i,o=r+i;n[t][0]=convertSTtoUV(convertIJtoSTMinimum(r)),n[t][1]=convertSTtoUV(convertIJtoSTMinimum(o))}return n}function getSizeIJ(e){return 1<<S2_MAX_LEVEL-e>>>0}function convertIJtoSTMinimum(e){return 1/S2_LIMIT_IJ*e}function generateLookupCell(e,t,n,i,r,o){if(e===S2_LOOKUP_BITS){const e=(t<<S2_LOOKUP_BITS)+n;S2_LOOKUP_POSITIONS[(e<<2)+i]=(r<<2)+o,S2_LOOKUP_IJ[(r<<2)+i]=(e<<2)+o}else{e++,t<<=1,n<<=1,r<<=2;const a=S2_POSITION_TO_IJ[o];generateLookupCell(e,t+(a[0]>>1),n+(1&a[0]),i,r,o^S2_POSITION_TO_ORIENTATION_MASK[0]),generateLookupCell(e,t+(a[1]>>1),n+(1&a[1]),i,r+1,o^S2_POSITION_TO_ORIENTATION_MASK[1]),generateLookupCell(e,t+(a[2]>>1),n+(1&a[2]),i,r+2,o^S2_POSITION_TO_ORIENTATION_MASK[2]),generateLookupCell(e,t+(a[3]>>1),n+(1&a[3]),i,r+3,o^S2_POSITION_TO_ORIENTATION_MASK[3])}}function generateLookupTable(){generateLookupCell(0,0,0,0,0,0),generateLookupCell(0,0,0,S2_SWAP_MASK,0,S2_SWAP_MASK),generateLookupCell(0,0,0,S2_INVERT_MASK,0,S2_INVERT_MASK),generateLookupCell(0,0,0,S2_SWAP_MASK|S2_INVERT_MASK,0,S2_SWAP_MASK|S2_INVERT_MASK)}function lsb(e){return e&~e+BigInt(1)}function lsbForLevel(e){return BigInt(1)<<BigInt(2*(S2_MAX_LEVEL-e))}S2Cell.fromToken=function(e){return new S2Cell(S2Cell.getIdFromToken(e))},S2Cell.isValidId=function(e){if(e<=0)return!1;if(e>>BigInt(S2_POSITION_BITS)>5)return!1;return!!(e&~e+BigInt(1)&BigInt("0x1555555555555555"))},S2Cell.isValidToken=function(e){return!!/^[0-9a-fA-F]{1,16}$/.test(e)&&S2Cell.isValidId(S2Cell.getIdFromToken(e))},S2Cell.getIdFromToken=function(e){return BigInt("0x"+e+"0".repeat(16-e.length))},S2Cell.getTokenFromId=function(e){const t=Math.floor(countTrailingZeroBits(e)/4),n=e.toString(16).replace(/0*$/,"");return Array(17-t-n.length).join("0")+n},S2Cell.getLevel=function(e){let t=0;for(;e!==BigInt(0)&&!(e&BigInt(1));)t++,e>>=BigInt(1);return S2_MAX_LEVEL-(t>>1)},S2Cell.prototype.getChild=function(e){const t=lsb(this._cellId)>>BigInt(2);return new S2Cell(this._cellId+BigInt(2*e+1-4)*t)},S2Cell.prototype.getParent=function(){const e=lsb(this._cellId)<<BigInt(2);return new S2Cell(this._cellId&~e+BigInt(1)|e)},S2Cell.prototype.getParentAtLevel=function(e){const t=lsbForLevel(e);return new S2Cell(this._cellId&-t|t)},S2Cell.prototype.getCenter=function(e){e=defaultValue(e,Ellipsoid.WGS84);let t=getS2Center(this._cellId,this._level);t=Cartesian3.normalize(t,t);const n=new Cartographic.fromCartesian(t,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(n,e,new Cartesian3)},S2Cell.prototype.getVertex=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);let n=getS2Vertex(this._cellId,this._level,e);n=Cartesian3.normalize(n,n);const i=new Cartographic.fromCartesian(n,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(i,t,new Cartesian3)},S2Cell.fromFacePositionLevel=function(e,t,n){const i=(e<4?"0":"")+(e<2?"0":"")+e.toString(2),r=t.toString(2),o=Array(2*n-r.length+1).join("0"),a=Array(S2_POSITION_BITS-2*n).join("0");return new S2Cell(BigInt(`0b${i}${o}${r}1${a}`))};const Mod67BitPosition=[64,0,1,39,2,15,40,23,3,12,16,59,41,19,24,54,4,64,13,10,17,62,60,28,42,30,20,51,25,44,55,47,5,32,65,38,14,22,11,58,18,53,63,9,61,27,29,50,43,46,31,37,21,57,52,8,26,49,45,36,56,7,48,35,6,34,33,0];function countTrailingZeroBits(e){return Mod67BitPosition[(-e&e)%BigInt(67)]}const ScreenSpaceEventType={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19};var ScreenSpaceEventType$1=Object.freeze(ScreenSpaceEventType);function getPosition$1(e,t,n){const i=e._element;if(i===document)return n.x=t.clientX,n.y=t.clientY,n;const r=i.getBoundingClientRect();return n.x=t.clientX-r.left,n.y=t.clientY-r.top,n}function getInputEventKey(e,t){let n=e;return defined(t)&&(n+=`+${t}`),n}function getModifier(e){return e.shiftKey?KeyboardEventModifier$1.SHIFT:e.ctrlKey?KeyboardEventModifier$1.CTRL:e.altKey?KeyboardEventModifier$1.ALT:void 0}const MouseButton={LEFT:0,MIDDLE:1,RIGHT:2};function registerListener(e,t,n,i){function r(t){i(e,t)}FeatureDetection.isInternetExplorer()?n.addEventListener(t,r,!1):n.addEventListener(t,r,{capture:!1,passive:!1}),e._removalFunctions.push((function(){n.removeEventListener(t,r,!1)}))}function registerListeners(e){const t=e._element,n=defined(t.disableRootEvents)?t:document;let i;FeatureDetection.supportsPointerEvents()?(registerListener(e,"pointerdown",t,handlePointerDown),registerListener(e,"pointerup",t,handlePointerUp),registerListener(e,"pointermove",t,handlePointerMove),registerListener(e,"pointercancel",t,handlePointerUp)):(registerListener(e,"mousedown",t,handleMouseDown),registerListener(e,"mouseup",n,handleMouseUp),registerListener(e,"mousemove",n,handleMouseMove),registerListener(e,"touchstart",t,handleTouchStart),registerListener(e,"touchend",n,handleTouchEnd),registerListener(e,"touchmove",n,handleTouchMove),registerListener(e,"touchcancel",n,handleTouchEnd)),registerListener(e,"dblclick",t,handleDblClick),i="onwheel"in t?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",registerListener(e,i,t,handleWheel)}function unregisterListeners(e){const t=e._removalFunctions;for(let e=0;e<t.length;++e)t[e]()}const mouseDownEvent={position:new Cartesian2};function gotTouchEvent(e){e._lastSeenTouchEvent=getTimestamp$1()}function canProcessMouseEvent(e){return getTimestamp$1()-e._lastSeenTouchEvent>ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds}function checkPixelTolerance(e,t,n){const i=e.x-t.x,r=e.y-t.y;return Math.sqrt(i*i+r*r)<n}function handleMouseDown(e,t){if(!canProcessMouseEvent(e))return;const n=t.button;let i;if(e._buttonDown[n]=!0,n===MouseButton.LEFT)i=ScreenSpaceEventType$1.LEFT_DOWN;else if(n===MouseButton.MIDDLE)i=ScreenSpaceEventType$1.MIDDLE_DOWN;else{if(n!==MouseButton.RIGHT)return;i=ScreenSpaceEventType$1.RIGHT_DOWN}const r=getPosition$1(e,t,e._primaryPosition);Cartesian2.clone(r,e._primaryStartPosition),Cartesian2.clone(r,e._primaryPreviousPosition);const o=getModifier(t),a=e.getInputAction(i,o);defined(a)&&(Cartesian2.clone(r,mouseDownEvent.position),a(mouseDownEvent),t.preventDefault())}const mouseUpEvent={position:new Cartesian2},mouseClickEvent={position:new Cartesian2};function cancelMouseEvent(e,t,n,i){const r=getModifier(i),o=e.getInputAction(t,r),a=e.getInputAction(n,r);if(defined(o)||defined(a)){const t=getPosition$1(e,i,e._primaryPosition);if(defined(o)&&(Cartesian2.clone(t,mouseUpEvent.position),o(mouseUpEvent)),defined(a)){checkPixelTolerance(e._primaryStartPosition,t,e._clickPixelTolerance)&&(Cartesian2.clone(t,mouseClickEvent.position),a(mouseClickEvent))}}}function handleMouseUp(e,t){if(!canProcessMouseEvent(e))return;const n=t.button;n!==MouseButton.LEFT&&n!==MouseButton.MIDDLE&&n!==MouseButton.RIGHT||(e._buttonDown[MouseButton.LEFT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.LEFT_UP,ScreenSpaceEventType$1.LEFT_CLICK,t),e._buttonDown[MouseButton.LEFT]=!1),e._buttonDown[MouseButton.MIDDLE]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.MIDDLE_UP,ScreenSpaceEventType$1.MIDDLE_CLICK,t),e._buttonDown[MouseButton.MIDDLE]=!1),e._buttonDown[MouseButton.RIGHT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.RIGHT_UP,ScreenSpaceEventType$1.RIGHT_CLICK,t),e._buttonDown[MouseButton.RIGHT]=!1))}const mouseMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2};function handleMouseMove(e,t){if(!canProcessMouseEvent(e))return;const n=getModifier(t),i=getPosition$1(e,t,e._primaryPosition),r=e._primaryPreviousPosition,o=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,n);defined(o)&&(Cartesian2.clone(r,mouseMoveEvent.startPosition),Cartesian2.clone(i,mouseMoveEvent.endPosition),o(mouseMoveEvent)),Cartesian2.clone(i,r),(e._buttonDown[MouseButton.LEFT]||e._buttonDown[MouseButton.MIDDLE]||e._buttonDown[MouseButton.RIGHT])&&t.preventDefault()}const mouseDblClickEvent={position:new Cartesian2};function handleDblClick(e,t){let n;if(t.button!==MouseButton.LEFT)return;n=ScreenSpaceEventType$1.LEFT_DOUBLE_CLICK;const i=getModifier(t),r=e.getInputAction(n,i);defined(r)&&(getPosition$1(e,t,mouseDblClickEvent.position),r(mouseDblClickEvent))}function handleWheel(e,t){let n;if(defined(t.deltaY)){const e=t.deltaMode;n=e===t.DOM_DELTA_PIXEL?-t.deltaY:e===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY}else n=t.detail>0?-120*t.detail:t.wheelDelta;if(!defined(n))return;const i=getModifier(t),r=e.getInputAction(ScreenSpaceEventType$1.WHEEL,i);defined(r)&&(r(n),t.preventDefault())}function handleTouchStart(e,t){gotTouchEvent(e);const n=t.changedTouches;let i;const r=n.length;let o,a;const s=e._positions;for(i=0;i<r;++i)o=n[i],a=o.identifier,s.set(a,getPosition$1(e,o,new Cartesian2));fireTouchEvents(e,t);const c=e._previousPositions;for(i=0;i<r;++i)o=n[i],a=o.identifier,c.set(a,Cartesian2.clone(s.get(a)))}function handleTouchEnd(e,t){gotTouchEvent(e);const n=t.changedTouches;let i;const r=n.length;let o,a;const s=e._positions;for(i=0;i<r;++i)o=n[i],a=o.identifier,s.remove(a);fireTouchEvents(e,t);const c=e._previousPositions;for(i=0;i<r;++i)o=n[i],a=o.identifier,c.remove(a)}const touchStartEvent={position:new Cartesian2},touch2StartEvent={position1:new Cartesian2,position2:new Cartesian2},touchEndEvent={position:new Cartesian2},touchClickEvent={position:new Cartesian2},touchHoldEvent={position:new Cartesian2};function fireTouchEvents(e,t){const n=getModifier(t),i=e._positions,r=i.length;let o,a;const s=e._isPinching;if(1!==r&&e._buttonDown[MouseButton.LEFT]){if(e._buttonDown[MouseButton.LEFT]=!1,defined(e._touchHoldTimer)&&(clearTimeout(e._touchHoldTimer),e._touchHoldTimer=void 0),o=e.getInputAction(ScreenSpaceEventType$1.LEFT_UP,n),defined(o)&&(Cartesian2.clone(e._primaryPosition,touchEndEvent.position),o(touchEndEvent)),0===r&&!e._isTouchHolding&&(a=e.getInputAction(ScreenSpaceEventType$1.LEFT_CLICK,n),defined(a))){checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._clickPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchClickEvent.position),a(touchClickEvent))}e._isTouchHolding=!1}if(0===r&&s&&(e._isPinching=!1,o=e.getInputAction(ScreenSpaceEventType$1.PINCH_END,n),defined(o)&&o()),1===r&&!s){const r=i.values[0];Cartesian2.clone(r,e._primaryPosition),Cartesian2.clone(r,e._primaryStartPosition),Cartesian2.clone(r,e._primaryPreviousPosition),e._buttonDown[MouseButton.LEFT]=!0,o=e.getInputAction(ScreenSpaceEventType$1.LEFT_DOWN,n),defined(o)&&(Cartesian2.clone(r,touchStartEvent.position),o(touchStartEvent)),e._touchHoldTimer=setTimeout((function(){if(!e.isDestroyed()&&(e._touchHoldTimer=void 0,e._isTouchHolding=!0,a=e.getInputAction(ScreenSpaceEventType$1.RIGHT_CLICK,n),defined(a))){checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._holdPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchHoldEvent.position),a(touchHoldEvent))}}),ScreenSpaceEventHandler.touchHoldDelayMilliseconds),t.preventDefault()}2!==r||s||(e._isPinching=!0,o=e.getInputAction(ScreenSpaceEventType$1.PINCH_START,n),defined(o)&&(Cartesian2.clone(i.values[0],touch2StartEvent.position1),Cartesian2.clone(i.values[1],touch2StartEvent.position2),o(touch2StartEvent),t.preventDefault()))}function handleTouchMove(e,t){gotTouchEvent(e);const n=t.changedTouches;let i;const r=n.length;let o,a;const s=e._positions;for(i=0;i<r;++i){o=n[i],a=o.identifier;const t=s.get(a);defined(t)&&getPosition$1(e,o,t)}fireTouchMoveEvents(e,t);const c=e._previousPositions;for(i=0;i<r;++i)o=n[i],a=o.identifier,Cartesian2.clone(s.get(a),c.get(a))}const touchMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2},touchPinchMovementEvent={distance:{startPosition:new Cartesian2,endPosition:new Cartesian2},angleAndHeight:{startPosition:new Cartesian2,endPosition:new Cartesian2}};function fireTouchMoveEvents(e,t){const n=getModifier(t),i=e._positions,r=e._previousPositions,o=i.length;let a;if(1===o&&e._buttonDown[MouseButton.LEFT]){const r=i.values[0];Cartesian2.clone(r,e._primaryPosition);const o=e._primaryPreviousPosition;a=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,n),defined(a)&&(Cartesian2.clone(o,touchMoveEvent.startPosition),Cartesian2.clone(r,touchMoveEvent.endPosition),a(touchMoveEvent)),Cartesian2.clone(r,o),t.preventDefault()}else if(2===o&&e._isPinching&&(a=e.getInputAction(ScreenSpaceEventType$1.PINCH_MOVE,n),defined(a))){const e=i.values[0],t=i.values[1],n=r.values[0],o=r.values[1],s=t.x-e.x,c=t.y-e.y,l=.25*Math.sqrt(s*s+c*c),u=o.x-n.x,d=o.y-n.y,h=.25*Math.sqrt(u*u+d*d),p=.125*(t.y+e.y),f=.125*(o.y+n.y),m=Math.atan2(c,s),g=Math.atan2(d,u);Cartesian2.fromElements(0,h,touchPinchMovementEvent.distance.startPosition),Cartesian2.fromElements(0,l,touchPinchMovementEvent.distance.endPosition),Cartesian2.fromElements(g,f,touchPinchMovementEvent.angleAndHeight.startPosition),Cartesian2.fromElements(m,p,touchPinchMovementEvent.angleAndHeight.endPosition),a(touchPinchMovementEvent)}}function handlePointerDown(e,t){if(t.target.setPointerCapture(t.pointerId),"touch"===t.pointerType){const n=e._positions,i=t.pointerId;n.set(i,getPosition$1(e,t,new Cartesian2)),fireTouchEvents(e,t);e._previousPositions.set(i,Cartesian2.clone(n.get(i)))}else handleMouseDown(e,t)}function handlePointerUp(e,t){if("touch"===t.pointerType){const n=e._positions,i=t.pointerId;n.remove(i),fireTouchEvents(e,t);e._previousPositions.remove(i)}else handleMouseUp(e,t)}function handlePointerMove(e,t){if("touch"===t.pointerType){const n=e._positions,i=t.pointerId,r=n.get(i);if(!defined(r))return;getPosition$1(e,t,r),fireTouchMoveEvents(e,t);const o=e._previousPositions;Cartesian2.clone(n.get(i),o.get(i))}else handleMouseMove(e,t)}function ScreenSpaceEventHandler(e){this._inputEvents={},this._buttonDown={LEFT:!1,MIDDLE:!1,RIGHT:!1},this._isPinching=!1,this._isTouchHolding=!1,this._lastSeenTouchEvent=-ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds,this._primaryStartPosition=new Cartesian2,this._primaryPosition=new Cartesian2,this._primaryPreviousPosition=new Cartesian2,this._positions=new AssociativeArray,this._previousPositions=new AssociativeArray,this._removalFunctions=[],this._touchHoldTimer=void 0,this._clickPixelTolerance=5,this._holdPixelTolerance=25,this._element=defaultValue(e,document),registerListeners(this)}function ShowGeometryInstanceAttribute(e){e=defaultValue(e,!0),this.value=ShowGeometryInstanceAttribute.toValue(e)}ScreenSpaceEventHandler.prototype.setInputAction=function(e,t,n){const i=getInputEventKey(t,n);this._inputEvents[i]=e},ScreenSpaceEventHandler.prototype.getInputAction=function(e,t){const n=getInputEventKey(e,t);return this._inputEvents[n]},ScreenSpaceEventHandler.prototype.removeInputAction=function(e,t){const n=getInputEventKey(e,t);delete this._inputEvents[n]},ScreenSpaceEventHandler.prototype.isDestroyed=function(){return!1},ScreenSpaceEventHandler.prototype.destroy=function(){return unregisterListeners(this),destroyObject(this)},ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds=800,ScreenSpaceEventHandler.touchHoldDelayMilliseconds=1500,Object.defineProperties(ShowGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),ShowGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e,t):new Uint8Array([e])};const Simon1994PlanetaryPositions={};function computeTdbMinusTtSpice(e){const t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}const TdtMinusTai=32.184,J2000d=2451545;function taiToTdb(e,t){t=JulianDate.addSeconds(e,TdtMinusTai,t);const n=JulianDate.totalDays(t)-J2000d;return t=JulianDate.addSeconds(t,computeTdbMinusTtSpice(n),t)}const epoch=new JulianDate(2451545,0,TimeStandard$1.TAI),MetersPerKilometer=1e3,RadiansPerDegree=CesiumMath.RADIANS_PER_DEGREE,RadiansPerArcSecond=CesiumMath.RADIANS_PER_ARCSECOND,MetersPerAstronomicalUnit=14959787e4,perifocalToEquatorial=new Matrix3;function elementsToCartesian(e,t,n,i,r,o,a){n<0&&(n=-n,r+=CesiumMath.PI);const s=e*(1-t),c=i-r,l=r,u=meanAnomalyToTrueAnomaly(o-i,t);perifocalToCartesianMatrix(c,n,l,perifocalToEquatorial);const d=s*(1+t),h=Math.cos(u),p=Math.sin(u),f=d/(1+t*h);return defined(a)?(a.x=f*h,a.y=f*p,a.z=0):a=new Cartesian3(f*h,f*p,0),Matrix3.multiplyByVector(perifocalToEquatorial,a,a)}function meanAnomalyToTrueAnomaly(e,t){return eccentricAnomalyToTrueAnomaly(meanAnomalyToEccentricAnomaly(e,t),t)}const maxIterationCount=50,keplerEqConvergence=CesiumMath.EPSILON8;function meanAnomalyToEccentricAnomaly(e,t){const n=Math.floor(e/CesiumMath.TWO_PI);let i,r=(e-=n*CesiumMath.TWO_PI)+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),o=Number.MAX_VALUE;for(i=0;i<maxIterationCount&&Math.abs(o-r)>keplerEqConvergence;++i){o=r;r=o-(o-t*Math.sin(o)-e)/(1-t*Math.cos(o))}return o=r+n*CesiumMath.TWO_PI,o}function eccentricAnomalyToTrueAnomaly(e,t){const n=Math.floor(e/CesiumMath.TWO_PI);e-=n*CesiumMath.TWO_PI;const i=Math.cos(e)-t,r=Math.sin(e)*Math.sqrt(1-t*t);let o=Math.atan2(r,i);return o=CesiumMath.zeroToTwoPi(o),e<0&&(o-=CesiumMath.TWO_PI),o+=n*CesiumMath.TWO_PI,o}function perifocalToCartesianMatrix(e,t,n,i){const r=Math.cos(e),o=Math.sin(e),a=Math.cos(t),s=Math.sin(t),c=Math.cos(n),l=Math.sin(n);return defined(i)?(i[0]=c*r-l*o*a,i[1]=l*r+c*o*a,i[2]=o*s,i[3]=-c*o-l*r*a,i[4]=-l*o+c*r*a,i[5]=r*s,i[6]=l*s,i[7]=-c*s,i[8]=a):i=new Matrix3(c*r-l*o*a,-c*o-l*r*a,l*s,l*r+c*o*a,-l*o+c*r*a,-c*s,o*s,r*s,a),i}const semiMajorAxis0=1.0000010178*MetersPerAstronomicalUnit,meanLongitude0=100.46645683*RadiansPerDegree,meanLongitude1=1295977422.83429*RadiansPerArcSecond,p1u=16002,p2u=21863,p3u=32004,p4u=10931,p5u=14529,p6u=16368,p7u=15318,p8u=32794,Ca1=64*1e-7*MetersPerAstronomicalUnit,Ca2=1e-7*-152*MetersPerAstronomicalUnit,Ca3=62*1e-7*MetersPerAstronomicalUnit,Ca4=-8e-7*MetersPerAstronomicalUnit,Ca5=32*1e-7*MetersPerAstronomicalUnit,Ca6=1e-7*-41*MetersPerAstronomicalUnit,Ca7=19*1e-7*MetersPerAstronomicalUnit,Ca8=1e-7*-11*MetersPerAstronomicalUnit,Sa1=1e-7*-150*MetersPerAstronomicalUnit,Sa2=1e-7*-46*MetersPerAstronomicalUnit,Sa3=68*1e-7*MetersPerAstronomicalUnit,Sa4=54*1e-7*MetersPerAstronomicalUnit,Sa5=14*1e-7*MetersPerAstronomicalUnit,Sa6=24*1e-7*MetersPerAstronomicalUnit,Sa7=1e-7*-28*MetersPerAstronomicalUnit,Sa8=22*1e-7*MetersPerAstronomicalUnit,q1u=10,q2u=16002,q3u=21863,q4u=10931,q5u=1473,q6u=32004,q7u=4387,q8u=73,Cl1=1e-7*-325,Cl2=1e-7*-322,Cl3=1e-7*-79,Cl4=232*1e-7,Cl5=1e-7*-52,Cl6=97*1e-7,Cl7=55*1e-7,Cl8=1e-7*-41,Sl1=1e-7*-105,Sl2=1e-7*-137,Sl3=258*1e-7,Sl4=35*1e-7,Sl5=1e-7*-116,Sl6=1e-7*-88,Sl7=1e-7*-112,Sl8=1e-7*-80,scratchDate$1=new JulianDate(0,0,TimeStandard$1.TAI);function computeSimonEarthMoonBarycenter(e,t){taiToTdb(e,scratchDate$1);const n=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/(10*TimeConstants$1.DAYS_PER_JULIAN_CENTURY),i=.3595362*n,r=semiMajorAxis0+Ca1*Math.cos(p1u*i)+Sa1*Math.sin(p1u*i)+Ca2*Math.cos(p2u*i)+Sa2*Math.sin(p2u*i)+Ca3*Math.cos(p3u*i)+Sa3*Math.sin(p3u*i)+Ca4*Math.cos(p4u*i)+Sa4*Math.sin(p4u*i)+Ca5*Math.cos(p5u*i)+Sa5*Math.sin(p5u*i)+Ca6*Math.cos(p6u*i)+Sa6*Math.sin(p6u*i)+Ca7*Math.cos(p7u*i)+Sa7*Math.sin(p7u*i)+Ca8*Math.cos(p8u*i)+Sa8*Math.sin(p8u*i),o=meanLongitude0+meanLongitude1*n+Cl1*Math.cos(q1u*i)+Sl1*Math.sin(q1u*i)+Cl2*Math.cos(q2u*i)+Sl2*Math.sin(q2u*i)+Cl3*Math.cos(q3u*i)+Sl3*Math.sin(q3u*i)+Cl4*Math.cos(q4u*i)+Sl4*Math.sin(q4u*i)+Cl5*Math.cos(q5u*i)+Sl5*Math.sin(q5u*i)+Cl6*Math.cos(q6u*i)+Sl6*Math.sin(q6u*i)+Cl7*Math.cos(q7u*i)+Sl7*Math.sin(q7u*i)+Cl8*Math.cos(q8u*i)+Sl8*Math.sin(q8u*i);return elementsToCartesian(r,.0167086342-.0004203654*n,469.97289*RadiansPerArcSecond*n,102.93734808*RadiansPerDegree+11612.3529*RadiansPerArcSecond*n,174.87317577*RadiansPerDegree-8679.27034*RadiansPerArcSecond*n,o,t)}function computeSimonMoon(e,t){taiToTdb(e,scratchDate$1);const n=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,i=n*n,r=i*n,o=r*n;let a=383397.7725+.004*n,s=.055545526-16e-9*n;const c=5.15668983*RadiansPerDegree;let l=-8e-5*n+.02966*i-42e-6*r-13e-8*o;const u=83.35324312*RadiansPerDegree;let d=14643420.2669*n-38.2702*i-.045047*r+21301e-8*o;const h=125.04455501*RadiansPerDegree;let p=-6967919.3631*n+6.3602*i+.007625*r-3586e-8*o;const f=218.31664563*RadiansPerDegree;let m=1732559343.4847*n-6.391*i+.006588*r-3169e-8*o;const g=297.85019547*RadiansPerDegree+RadiansPerArcSecond*(1602961601.209*n-6.3706*i+.006593*r-3169e-8*o),_=134.96340251*RadiansPerDegree+RadiansPerArcSecond*(1717915923.2178*n+31.8792*i+.051635*r-2447e-7*o),y=357.52910918*RadiansPerDegree+RadiansPerArcSecond*(129596581.0481*n-.5532*i+136e-6*r-1149e-8*o),C=310.17137918*RadiansPerDegree-RadiansPerArcSecond*(6967051.436*n+6.2068*i+.007618*r-3219e-8*o),T=2*g,S=4*g,A=6*g,v=2*_,E=3*_,b=4*_,x=2*(93.27209062*RadiansPerDegree+RadiansPerArcSecond*(1739527262.8478*n-12.7512*i-.001037*r+417e-8*o));a+=3400.4*Math.cos(T)-635.6*Math.cos(T-_)-235.6*Math.cos(_)+218.1*Math.cos(T-y)+181*Math.cos(T+_),s+=.014216*Math.cos(T-_)+.008551*Math.cos(T-v)-.001383*Math.cos(_)+.001356*Math.cos(T+_)-.001147*Math.cos(S-E)-914e-6*Math.cos(S-v)+869e-6*Math.cos(T-y-_)-627e-6*Math.cos(T)-394e-6*Math.cos(S-b)+282e-6*Math.cos(T-y-v)-279e-6*Math.cos(g-_)-236e-6*Math.cos(v)+231e-6*Math.cos(S)+229e-6*Math.cos(A-b)-201e-6*Math.cos(v-x),l+=486.26*Math.cos(T-x)-40.13*Math.cos(T)+37.51*Math.cos(x)+25.73*Math.cos(v-x)+19.97*Math.cos(T-y-x),d+=-55609*Math.sin(T-_)-34711*Math.sin(T-v)-9792*Math.sin(_)+9385*Math.sin(S-E)+7505*Math.sin(S-v)+5318*Math.sin(T+_)+3484*Math.sin(S-b)-3417*Math.sin(T-y-_)-2530*Math.sin(A-b)-2376*Math.sin(T)-2075*Math.sin(T-E)-1883*Math.sin(v)-1736*Math.sin(A-5*_)+1626*Math.sin(y)-1370*Math.sin(A-E),p+=-5392*Math.sin(T-x)-540*Math.sin(y)-441*Math.sin(T)+423*Math.sin(x)-288*Math.sin(v-x),m+=-3332.9*Math.sin(T)+1197.4*Math.sin(T-_)-662.5*Math.sin(y)+396.3*Math.sin(_)-218*Math.sin(T-y);const P=2*C,D=3*C;l+=46.997*Math.cos(C)*n-.614*Math.cos(T-x+C)*n+.614*Math.cos(T-x-C)*n-.0297*Math.cos(P)*i-.0335*Math.cos(C)*i+.0012*Math.cos(T-x+P)*i-16e-5*Math.cos(C)*r+4e-5*Math.cos(D)*r+4e-5*Math.cos(P)*r;const w=2.116*Math.sin(C)*n-.111*Math.sin(T-x-C)*n-.0015*Math.sin(C)*i;d+=w,m+=w,p+=-520.77*Math.sin(C)*n+13.66*Math.sin(T-x+C)*n+1.12*Math.sin(T-C)*n-1.06*Math.sin(x-C)*n+.66*Math.sin(P)*i+.371*Math.sin(C)*i-.035*Math.sin(T-x+P)*i-.015*Math.sin(T-x+C)*i+.0014*Math.sin(C)*r-.0011*Math.sin(D)*r-9e-4*Math.sin(P)*r,a*=MetersPerKilometer;return elementsToCartesian(a,s,c+l*RadiansPerArcSecond,u+d*RadiansPerArcSecond,h+p*RadiansPerArcSecond,f+m*RadiansPerArcSecond,t)}const moonEarthMassRatio=.012300034,factor=moonEarthMassRatio/(moonEarthMassRatio+1)*-1;function computeSimonEarth(e,t){return t=computeSimonMoon(e,t),Cartesian3.multiplyByScalar(t,factor,t)}const axesTransformation=new Matrix3(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819);let translation=new Cartesian3;function interpolateColors(e,t,n,i,r,o,a){const s=PolylinePipeline.numberOfPoints(e,t,r);let c;const l=n.red,u=n.green,d=n.blue,h=n.alpha,p=i.red,f=i.green,m=i.blue,g=i.alpha;if(Color.equals(n,i)){for(c=0;c<s;c++)o[a++]=Color.floatToByte(l),o[a++]=Color.floatToByte(u),o[a++]=Color.floatToByte(d),o[a++]=Color.floatToByte(h);return a}const _=(p-l)/s,y=(f-u)/s,C=(m-d)/s,T=(g-h)/s;let S=a;for(c=0;c<s;c++)o[S++]=Color.floatToByte(l+c*_),o[S++]=Color.floatToByte(u+c*y),o[S++]=Color.floatToByte(d+c*C),o[S++]=Color.floatToByte(h+c*T);return S}function SimplePolylineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.colors,i=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=n,this._colorsPerVertex=i,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._workerName="createSimplePolylineGeometry";let r=1+t.length*Cartesian3.packedLength;r+=defined(n)?1+n.length*Color.packedLength:1,this.packedLength=r+Ellipsoid.packedLength+3}Simon1994PlanetaryPositions.computeSunPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),defined(t)||(t=new Cartesian3),translation=computeSimonEarthMoonBarycenter(e,translation),t=Cartesian3.negate(translation,t),computeSimonEarth(e,translation),Cartesian3.subtract(t,translation,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),t=computeSimonMoon(e,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},SimplePolylineGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._colors;for(o=defined(a)?a.length:0,t[n++]=o,i=0;i<o;++i,n+=Color.packedLength)Color.pack(a[i],t,n);return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,t[n++]=e._colorsPerVertex?1:0,t[n++]=e._arcType,t[n]=e._granularity,t},SimplePolylineGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);r=e[t++];const a=r>0?new Array(r):void 0;for(i=0;i<r;++i,t+=Color.packedLength)a[i]=Color.unpack(e,t);const s=Ellipsoid.unpack(e,t);t+=Ellipsoid.packedLength;const c=1===e[t++],l=e[t++],u=e[t];return defined(n)?(n._positions=o,n._colors=a,n._ellipsoid=s,n._colorsPerVertex=c,n._arcType=l,n._granularity=u,n):new SimplePolylineGeometry({positions:o,colors:a,ellipsoid:s,colorsPerVertex:c,arcType:l,granularity:u})};const scratchArray1=new Array(2),scratchArray2=new Array(2),generateArcOptionsScratch$1={positions:scratchArray1,height:scratchArray2,ellipsoid:void 0,minDistance:void 0,granularity:void 0};function SphereGeometry(e){const t=defaultValue(e.radius,1),n={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,vertexFormat:e.vertexFormat};this._ellipsoidGeometry=new EllipsoidGeometry(n),this._workerName="createSphereGeometry"}SimplePolylineGeometry.createGeometry=function(e){const t=e._positions,n=e._colors,i=e._colorsPerVertex,r=e._arcType,o=e._granularity,a=e._ellipsoid,s=CesiumMath.chordLength(o,a.maximumRadius),c=defined(n)&&!i;let l;const u=t.length;let d,h,p,f,m=0;if(r===ArcType$1.GEODESIC||r===ArcType$1.RHUMB){let e,i,h;r===ArcType$1.GEODESIC?(e=CesiumMath.chordLength(o,a.maximumRadius),i=PolylinePipeline.numberOfPoints,h=PolylinePipeline.generateArc):(e=o,i=PolylinePipeline.numberOfPointsRhumbLine,h=PolylinePipeline.generateRhumbArc);const g=PolylinePipeline.extractHeights(t,a),_=generateArcOptionsScratch$1;if(r===ArcType$1.GEODESIC?_.minDistance=s:_.granularity=o,_.ellipsoid=a,c){let r=0;for(l=0;l<u-1;l++)r+=i(t[l],t[l+1],e)+1;d=new Float64Array(3*r),p=new Uint8Array(4*r),_.positions=scratchArray1,_.height=scratchArray2;let o=0;for(l=0;l<u-1;++l){scratchArray1[0]=t[l],scratchArray1[1]=t[l+1],scratchArray2[0]=g[l],scratchArray2[1]=g[l+1];const e=h(_);if(defined(n)){const t=e.length/3;f=n[l];for(let e=0;e<t;++e)p[o++]=Color.floatToByte(f.red),p[o++]=Color.floatToByte(f.green),p[o++]=Color.floatToByte(f.blue),p[o++]=Color.floatToByte(f.alpha)}d.set(e,m),m+=e.length}}else if(_.positions=t,_.height=g,d=new Float64Array(h(_)),defined(n)){for(p=new Uint8Array(d.length/3*4),l=0;l<u-1;++l){m=interpolateColors(t[l],t[l+1],n[l],n[l+1],s,p,m)}const e=n[u-1];p[m++]=Color.floatToByte(e.red),p[m++]=Color.floatToByte(e.green),p[m++]=Color.floatToByte(e.blue),p[m++]=Color.floatToByte(e.alpha)}}else{h=c?2*u-2:u,d=new Float64Array(3*h),p=defined(n)?new Uint8Array(4*h):void 0;let e=0,i=0;for(l=0;l<u;++l){const r=t[l];if(c&&l>0&&(Cartesian3.pack(r,d,e),e+=3,f=n[l-1],p[i++]=Color.floatToByte(f.red),p[i++]=Color.floatToByte(f.green),p[i++]=Color.floatToByte(f.blue),p[i++]=Color.floatToByte(f.alpha)),c&&l===u-1)break;Cartesian3.pack(r,d,e),e+=3,defined(n)&&(f=n[l],p[i++]=Color.floatToByte(f.red),p[i++]=Color.floatToByte(f.green),p[i++]=Color.floatToByte(f.blue),p[i++]=Color.floatToByte(f.alpha))}}const g=new GeometryAttributes;g.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d}),defined(n)&&(g.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:p,normalize:!0})),h=d.length/3;const _=2*(h-1),y=IndexDatatype$1.createTypedArray(h,_);let C=0;for(l=0;l<h-1;++l)y[C++]=l,y[C++]=l+1;return new Geometry({attributes:g,indices:y,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromPoints(t)})},SphereGeometry.packedLength=EllipsoidGeometry.packedLength,SphereGeometry.pack=function(e,t,n){return EllipsoidGeometry.pack(e._ellipsoidGeometry,t,n)};const scratchEllipsoidGeometry$1=new EllipsoidGeometry,scratchOptions$3={radius:void 0,radii:new Cartesian3,vertexFormat:new VertexFormat,stackPartitions:void 0,slicePartitions:void 0};function SphereOutlineGeometry(e){const t=defaultValue(e.radius,1),n={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,subdivisions:e.subdivisions};this._ellipsoidGeometry=new EllipsoidOutlineGeometry(n),this._workerName="createSphereOutlineGeometry"}SphereGeometry.unpack=function(e,t,n){const i=EllipsoidGeometry.unpack(e,t,scratchEllipsoidGeometry$1);return scratchOptions$3.vertexFormat=VertexFormat.clone(i._vertexFormat,scratchOptions$3.vertexFormat),scratchOptions$3.stackPartitions=i._stackPartitions,scratchOptions$3.slicePartitions=i._slicePartitions,defined(n)?(Cartesian3.clone(i._radii,scratchOptions$3.radii),n._ellipsoidGeometry=new EllipsoidGeometry(scratchOptions$3),n):(scratchOptions$3.radius=i._radii.x,new SphereGeometry(scratchOptions$3))},SphereGeometry.createGeometry=function(e){return EllipsoidGeometry.createGeometry(e._ellipsoidGeometry)},SphereOutlineGeometry.packedLength=EllipsoidOutlineGeometry.packedLength,SphereOutlineGeometry.pack=function(e,t,n){return EllipsoidOutlineGeometry.pack(e._ellipsoidGeometry,t,n)};const scratchEllipsoidGeometry=new EllipsoidOutlineGeometry,scratchOptions$2={radius:void 0,radii:new Cartesian3,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};function Spherical(e,t,n){this.clock=defaultValue(e,0),this.cone=defaultValue(t,0),this.magnitude=defaultValue(n,1)}SphereOutlineGeometry.unpack=function(e,t,n){const i=EllipsoidOutlineGeometry.unpack(e,t,scratchEllipsoidGeometry);return scratchOptions$2.stackPartitions=i._stackPartitions,scratchOptions$2.slicePartitions=i._slicePartitions,scratchOptions$2.subdivisions=i._subdivisions,defined(n)?(Cartesian3.clone(i._radii,scratchOptions$2.radii),n._ellipsoidGeometry=new EllipsoidOutlineGeometry(scratchOptions$2),n):(scratchOptions$2.radius=i._radii.x,new SphereOutlineGeometry(scratchOptions$2))},SphereOutlineGeometry.createGeometry=function(e){return EllipsoidOutlineGeometry.createGeometry(e._ellipsoidGeometry)},Spherical.fromCartesian3=function(e,t){const n=e.x,i=e.y,r=e.z,o=n*n+i*i;return defined(t)||(t=new Spherical),t.clock=Math.atan2(i,n),t.cone=Math.atan2(Math.sqrt(o),r),t.magnitude=Math.sqrt(o+r*r),t},Spherical.clone=function(e,t){if(defined(e))return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new Spherical(e.clock,e.cone,e.magnitude)},Spherical.normalize=function(e,t){return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=1,t):new Spherical(e.clock,e.cone,1)},Spherical.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},Spherical.equalsEpsilon=function(e,t,n){return n=defaultValue(n,0),e===t||defined(e)&&defined(t)&&Math.abs(e.clock-t.clock)<=n&&Math.abs(e.cone-t.cone)<=n&&Math.abs(e.magnitude-t.magnitude)<=n},Spherical.prototype.equals=function(e){return Spherical.equals(this,e)},Spherical.prototype.clone=function(e){return Spherical.clone(this,e)},Spherical.prototype.equalsEpsilon=function(e,t){return Spherical.equalsEpsilon(this,e,t)},Spherical.prototype.toString=function(){return`(${this.clock}, ${this.cone}, ${this.magnitude})`};const TileEdge={WEST:0,NORTH:1,EAST:2,SOUTH:3,NORTHWEST:4,NORTHEAST:5,SOUTHWEST:6,SOUTHEAST:7};function TilingScheme(e){}function compareIntervalStartTimes(e,t){return JulianDate.compare(e.start,t.start)}function TimeIntervalCollection(e){if(this._intervals=[],this._changedEvent=new Event,defined(e)){const t=e.length;for(let n=0;n<t;n++)this.addInterval(e[n])}}Object.defineProperties(TilingScheme.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError},rectangle:{get:DeveloperError.throwInstantiationError},projection:{get:DeveloperError.throwInstantiationError}}),TilingScheme.prototype.getNumberOfXTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.getNumberOfYTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.rectangleToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.positionToTileXY=DeveloperError.throwInstantiationError,Object.defineProperties(TimeIntervalCollection.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){const e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){const e=this._intervals;return 0!==e.length&&e[0].isStartIncluded}},stop:{get:function(){const e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){const e=this._intervals,t=e.length;return 0!==t&&e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),TimeIntervalCollection.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof TimeIntervalCollection))return!1;const n=this._intervals,i=e._intervals,r=n.length;if(r!==i.length)return!1;for(let e=0;e<r;e++)if(!TimeInterval.equals(n[e],i[e],t))return!1;return!0},TimeIntervalCollection.prototype.get=function(e){return this._intervals[e]},TimeIntervalCollection.prototype.removeAll=function(){this._intervals.length>0&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},TimeIntervalCollection.prototype.findIntervalContainingDate=function(e){const t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},TimeIntervalCollection.prototype.findDataForIntervalContainingDate=function(e){const t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},TimeIntervalCollection.prototype.contains=function(e){return this.indexOf(e)>=0};const indexOfScratch=new TimeInterval;TimeIntervalCollection.prototype.indexOf=function(e){const t=this._intervals;indexOfScratch.start=e,indexOfScratch.stop=e;let n=binarySearch(t,indexOfScratch,compareIntervalStartTimes);return n>=0?t[n].isStartIncluded?n:n>0&&t[n-1].stop.equals(e)&&t[n-1].isStopIncluded?n-1:~n:(n=~n,n>0&&n-1<t.length&&TimeInterval.contains(t[n-1],e)?n-1:~n)},TimeIntervalCollection.prototype.findInterval=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).start,n=e.stop,i=e.isStartIncluded,r=e.isStopIncluded,o=this._intervals;for(let e=0,a=o.length;e<a;e++){const a=o[e];if((!defined(t)||a.start.equals(t))&&(!defined(n)||a.stop.equals(n))&&(!defined(i)||a.isStartIncluded===i)&&(!defined(r)||a.isStopIncluded===r))return o[e]}},TimeIntervalCollection.prototype.addInterval=function(e,t){if(e.isEmpty)return;const n=this._intervals;if(0===n.length||JulianDate.greaterThan(e.start,n[n.length-1].stop))return n.push(e),void this._changedEvent.raiseEvent(this);let i,r=binarySearch(n,e,compareIntervalStartTimes);for(r<0?r=~r:r>0&&e.isStartIncluded&&n[r-1].isStartIncluded&&n[r-1].start.equals(e.start)?--r:r<n.length&&!e.isStartIncluded&&n[r].isStartIncluded&&n[r].start.equals(e.start)&&++r,r>0&&(i=JulianDate.compare(n[r-1].stop,e.start),(i>0||0===i&&(n[r-1].isStopIncluded||e.isStartIncluded))&&((defined(t)?t(n[r-1].data,e.data):n[r-1].data===e.data)?(e=JulianDate.greaterThan(e.stop,n[r-1].stop)?new TimeInterval({start:n[r-1].start,stop:e.stop,isStartIncluded:n[r-1].isStartIncluded,isStopIncluded:e.isStopIncluded,data:e.data}):new TimeInterval({start:n[r-1].start,stop:n[r-1].stop,isStartIncluded:n[r-1].isStartIncluded,isStopIncluded:n[r-1].isStopIncluded||e.stop.equals(n[r-1].stop)&&e.isStopIncluded,data:e.data}),n.splice(r-1,1),--r):(i=JulianDate.compare(n[r-1].stop,e.stop),(i>0||0===i&&n[r-1].isStopIncluded&&!e.isStopIncluded)&&n.splice(r,0,new TimeInterval({start:e.stop,stop:n[r-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:n[r-1].isStopIncluded,data:n[r-1].data})),n[r-1]=new TimeInterval({start:n[r-1].start,stop:e.start,isStartIncluded:n[r-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:n[r-1].data}))));r<n.length&&(i=JulianDate.compare(e.stop,n[r].start),i>0||0===i&&(e.isStopIncluded||n[r].isStartIncluded));)if(defined(t)?t(n[r].data,e.data):n[r].data===e.data)e=new TimeInterval({start:e.start,stop:JulianDate.greaterThan(n[r].stop,e.stop)?n[r].stop:e.stop,isStartIncluded:e.isStartIncluded,isStopIncluded:JulianDate.greaterThan(n[r].stop,e.stop)?n[r].isStopIncluded:e.isStopIncluded,data:e.data}),n.splice(r,1);else{if(n[r]=new TimeInterval({start:e.stop,stop:n[r].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:n[r].isStopIncluded,data:n[r].data}),!n[r].isEmpty)break;n.splice(r,1)}n.splice(r,0,e),this._changedEvent.raiseEvent(this)},TimeIntervalCollection.prototype.removeInterval=function(e){if(e.isEmpty)return!1;const t=this._intervals;let n=binarySearch(t,e,compareIntervalStartTimes);n<0&&(n=~n);let i=!1;for(n>0&&(JulianDate.greaterThan(t[n-1].stop,e.start)||t[n-1].stop.equals(e.start)&&t[n-1].isStopIncluded&&e.isStartIncluded)&&(i=!0,(JulianDate.greaterThan(t[n-1].stop,e.stop)||t[n-1].isStopIncluded&&!e.isStopIncluded&&t[n-1].stop.equals(e.stop))&&t.splice(n,0,new TimeInterval({start:e.stop,stop:t[n-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[n-1].isStopIncluded,data:t[n-1].data})),t[n-1]=new TimeInterval({start:t[n-1].start,stop:e.start,isStartIncluded:t[n-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:t[n-1].data})),n<t.length&&!e.isStartIncluded&&t[n].isStartIncluded&&e.start.equals(t[n].start)&&(i=!0,t.splice(n,0,new TimeInterval({start:t[n].start,stop:t[n].start,isStartIncluded:!0,isStopIncluded:!0,data:t[n].data})),++n);n<t.length&&JulianDate.greaterThan(e.stop,t[n].stop);)i=!0,t.splice(n,1);return n<t.length&&e.stop.equals(t[n].stop)&&(i=!0,!e.isStopIncluded&&t[n].isStopIncluded?n+1<t.length&&t[n+1].start.equals(e.stop)&&t[n].data===t[n+1].data?(t.splice(n,1),t[n]=new TimeInterval({start:t[n].start,stop:t[n].stop,isStartIncluded:!0,isStopIncluded:t[n].isStopIncluded,data:t[n].data})):t[n]=new TimeInterval({start:e.stop,stop:e.stop,isStartIncluded:!0,isStopIncluded:!0,data:t[n].data}):t.splice(n,1)),n<t.length&&(JulianDate.greaterThan(e.stop,t[n].start)||e.stop.equals(t[n].start)&&e.isStopIncluded&&t[n].isStartIncluded)&&(i=!0,t[n]=new TimeInterval({start:e.stop,stop:t[n].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[n].isStopIncluded,data:t[n].data})),i&&this._changedEvent.raiseEvent(this),i},TimeIntervalCollection.prototype.intersect=function(e,t,n){const i=new TimeIntervalCollection;let r=0,o=0;const a=this._intervals,s=e._intervals;for(;r<a.length&&o<s.length;){const e=a[r],c=s[o];if(JulianDate.lessThan(e.stop,c.start))++r;else if(JulianDate.lessThan(c.stop,e.start))++o;else{if(defined(n)||defined(t)&&t(e.data,c.data)||!defined(t)&&c.data===e.data){const r=TimeInterval.intersect(e,c,new TimeInterval,n);r.isEmpty||i.addInterval(r,t)}JulianDate.lessThan(e.stop,c.stop)||e.stop.equals(c.stop)&&!e.isStopIncluded&&c.isStopIncluded?++r:++o}}return i},TimeIntervalCollection.fromJulianDateArray=function(e,t){defined(t)||(t=new TimeIntervalCollection);const n=e.julianDates,i=n.length,r=e.dataCallback,o=defaultValue(e.isStartIncluded,!0),a=defaultValue(e.isStopIncluded,!0),s=defaultValue(e.leadingInterval,!1),c=defaultValue(e.trailingInterval,!1);let l,u=0;s&&(++u,l=new TimeInterval({start:Iso8601.MINIMUM_VALUE,stop:n[0],isStartIncluded:!0,isStopIncluded:!o}),l.data=defined(r)?r(l,t.length):t.length,t.addInterval(l));for(let e=0;e<i-1;++e){let s=n[e];const c=n[e+1];l=new TimeInterval({start:s,stop:c,isStartIncluded:t.length!==u||o,isStopIncluded:e===i-2&&a}),l.data=defined(r)?r(l,t.length):t.length,t.addInterval(l),s=c}return c&&(l=new TimeInterval({start:n[i-1],stop:Iso8601.MAXIMUM_VALUE,isStartIncluded:!a,isStopIncluded:!0}),l.data=defined(r)?r(l,t.length):t.length,t.addInterval(l)),t};const scratchGregorianDate=new GregorianDate,monthLengths=[0,31,28,31,30,31,30,31,31,30,31,30,31];function addToDate(e,t,n){defined(n)||(n=new JulianDate),JulianDate.toGregorianDate(e,scratchGregorianDate);let i=scratchGregorianDate.millisecond+t.millisecond,r=scratchGregorianDate.second+t.second,o=scratchGregorianDate.minute+t.minute,a=scratchGregorianDate.hour+t.hour,s=scratchGregorianDate.day+t.day,c=scratchGregorianDate.month+t.month,l=scratchGregorianDate.year+t.year;for(i>=1e3&&(r+=Math.floor(i/1e3),i%=1e3),r>=60&&(o+=Math.floor(r/60),r%=60),o>=60&&(a+=Math.floor(o/60),o%=60),a>=24&&(s+=Math.floor(a/24),a%=24),monthLengths[2]=isLeapYear(l)?29:28;s>monthLengths[c]||c>=13;)s>monthLengths[c]&&(s-=monthLengths[c],++c),c>=13&&(--c,l+=Math.floor(c/12),c%=12,++c),monthLengths[2]=isLeapYear(l)?29:28;return scratchGregorianDate.millisecond=i,scratchGregorianDate.second=r,scratchGregorianDate.minute=o,scratchGregorianDate.hour=a,scratchGregorianDate.day=s,scratchGregorianDate.month=c,scratchGregorianDate.year=l,JulianDate.fromGregorianDate(scratchGregorianDate,n)}const scratchJulianDate$2=new JulianDate,durationRegex=/P(?:([\d.,]+)Y)?(?:([\d.,]+)M)?(?:([\d.,]+)W)?(?:([\d.,]+)D)?(?:T(?:([\d.,]+)H)?(?:([\d.,]+)M)?(?:([\d.,]+)S)?)?/;function parseDuration(e,t){if(!defined(e)||0===e.length)return!1;if(t.year=0,t.month=0,t.day=0,t.hour=0,t.minute=0,t.second=0,t.millisecond=0,"P"===e[0]){const n=e.match(durationRegex);if(!defined(n))return!1;if(defined(n[1])&&(t.year=Number(n[1].replace(",","."))),defined(n[2])&&(t.month=Number(n[2].replace(",","."))),defined(n[3])&&(t.day=7*Number(n[3].replace(",","."))),defined(n[4])&&(t.day+=Number(n[4].replace(",","."))),defined(n[5])&&(t.hour=Number(n[5].replace(",","."))),defined(n[6])&&(t.minute=Number(n[6].replace(",","."))),defined(n[7])){const e=Number(n[7].replace(",","."));t.second=Math.floor(e),t.millisecond=e%1*1e3}}else"Z"!==e[e.length-1]&&(e+="Z"),JulianDate.toGregorianDate(JulianDate.fromIso8601(e,scratchJulianDate$2),t);return t.year||t.month||t.day||t.hour||t.minute||t.second||t.millisecond}const scratchDuration=new GregorianDate;TimeIntervalCollection.fromIso8601=function(e,t){const n=e.iso8601.split("/"),i=JulianDate.fromIso8601(n[0]),r=JulianDate.fromIso8601(n[1]),o=[];if(parseDuration(n[2],scratchDuration)){let e=JulianDate.clone(i);for(o.push(e);JulianDate.compare(e,r)<0;){e=addToDate(e,scratchDuration);JulianDate.compare(r,e)<=0&&JulianDate.clone(r,e),o.push(e)}}else o.push(i,r);return TimeIntervalCollection.fromJulianDateArray({julianDates:o,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DateArray=function(e,t){return TimeIntervalCollection.fromJulianDateArray({julianDates:e.iso8601Dates.map((function(e){return JulianDate.fromIso8601(e)})),isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DurationArray=function(e,t){const n=e.epoch,i=e.iso8601Durations,r=defaultValue(e.relativeToPrevious,!1),o=[];let a,s;const c=i.length;for(let e=0;e<c;++e)(parseDuration(i[e],scratchDuration)||0===e)&&(a=r&&defined(s)?addToDate(s,scratchDuration):addToDate(n,scratchDuration),o.push(a),s=a);return TimeIntervalCollection.fromJulianDateArray({julianDates:o,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)};const defaultScale$4=new Cartesian3(1,1,1),defaultTranslation=Cartesian3.ZERO,defaultRotation$1=Quaternion.IDENTITY;function TranslationRotationScale(e,t,n){this.translation=Cartesian3.clone(defaultValue(e,defaultTranslation)),this.rotation=Quaternion.clone(defaultValue(t,defaultRotation$1)),this.scale=Cartesian3.clone(defaultValue(n,defaultScale$4))}function DataRectangle(e,t){this.rectangle=e,this.maxLevel=t}function VRTheWorldTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=Resource.createIfNeeded(e.url);this._resource=t,this._errorEvent=new Event,this._ready=!1,this._readyPromise=when.defer(),this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0,lowestEncodedHeight:0,highestEncodedHeight:16777215};let n=e.credit;"string"==typeof n&&(n=new Credit(n)),this._credit=n,this._tilingScheme=void 0,this._rectangles=[];const i=this;let r;const o=defaultValue(e.ellipsoid,Ellipsoid.WGS84);function a(e){const t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"!==t)return void s(`SRS ${t} is not supported.`);i._tilingScheme=new GeographicTilingScheme({ellipsoid:o});const n=e.getElementsByTagName("TileFormat")[0];i._heightmapWidth=parseInt(n.getAttribute("width"),10),i._heightmapHeight=parseInt(n.getAttribute("height"),10),i._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(o,Math.min(i._heightmapWidth,i._heightmapHeight),i._tilingScheme.getNumberOfXTilesAtLevel(0));const r=e.getElementsByTagName("DataExtent");for(let e=0;e<r.length;++e){const t=r[e],n=CesiumMath.toRadians(parseFloat(t.getAttribute("minx"))),o=CesiumMath.toRadians(parseFloat(t.getAttribute("miny"))),a=CesiumMath.toRadians(parseFloat(t.getAttribute("maxx"))),s=CesiumMath.toRadians(parseFloat(t.getAttribute("maxy"))),c=parseInt(t.getAttribute("maxlevel"),10);i._rectangles.push(new DataRectangle(new Rectangle(n,o,a,s),c))}i._ready=!0,i._readyPromise.resolve(!0)}function s(e){const t=defaultValue(e,`An error occurred while accessing ${i._resource.url}.`);r=TileProviderError.handleError(r,i,i._errorEvent,t,void 0,void 0,void 0,c)}function c(){when(i._resource.fetchXML(),a,s)}c()}TranslationRotationScale.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this.translation,e.translation)&&Quaternion.equals(this.rotation,e.rotation)&&Cartesian3.equals(this.scale,e.scale)},Object.defineProperties(VRTheWorldTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),VRTheWorldTerrainProvider.prototype.requestTileGeometry=function(e,t,n,i){const r=this._tilingScheme.getNumberOfYTilesAtLevel(n),o=this._resource.getDerivedResource({url:`${n}/${e}/${r-t-1}.tif`,queryParameters:{cesium:!0},request:i}).fetchImage({preferImageBitmap:!0});if(!defined(o))return;const a=this;return when(o).then((function(i){return new HeightmapTerrainData({buffer:getImagePixels(i),width:a._heightmapWidth,height:a._heightmapHeight,childTileMask:getChildMask(a,e,t,n),structure:a._terrainDataStructure})}))},VRTheWorldTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};const rectangleScratch$2=new Rectangle;function getChildMask(e,t,n,i){const r=e._tilingScheme,o=e._rectangles,a=r.tileXYToRectangle(t,n,i);let s=0;for(let e=0;e<o.length&&15!==s;++e){const c=o[e];if(c.maxLevel<=i)continue;const l=c.rectangle;defined(Rectangle.intersection(l,a,rectangleScratch$2))&&(isTileInRectangle(r,l,2*t,2*n,i+1)&&(s|=4),isTileInRectangle(r,l,2*t+1,2*n,i+1)&&(s|=8),isTileInRectangle(r,l,2*t,2*n+1,i+1)&&(s|=1),isTileInRectangle(r,l,2*t+1,2*n+1,i+1)&&(s|=2))}return s}function isTileInRectangle(e,t,n,i,r){const o=e.tileXYToRectangle(n,i,r);return defined(Rectangle.intersection(o,t,rectangleScratch$2))}function VideoSynchronizer(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this._lastPlaybackRate=void 0,this.clock=e.clock,this.element=e.element,this.epoch=defaultValue(e.epoch,Iso8601.MINIMUM_VALUE),this.tolerance=defaultValue(e.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function createSeekFunction(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}VRTheWorldTerrainProvider.prototype.getTileDataAvailable=function(e,t,n){},VRTheWorldTerrainProvider.prototype.loadTileDataAvailability=function(e,t,n){},Object.defineProperties(VideoSynchronizer.prototype,{clock:{get:function(){return this._clock},set:function(e){const t=this._clock;t!==e&&(defined(t)&&(this._clockSubscription(),this._clockSubscription=void 0),defined(e)&&(this._clockSubscription=e.onTick.addEventListener(VideoSynchronizer.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){const t=this._element;t!==e&&(defined(t)&&t.removeEventListener("seeked",this._seekFunction,!1),defined(e)&&(this._seeking=!1,this._seekFunction=createSeekFunction(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),VideoSynchronizer.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,destroyObject(this)},VideoSynchronizer.prototype.isDestroyed=function(){return!1},VideoSynchronizer.prototype._trySetPlaybackRate=function(e){if(this._lastPlaybackRate===e.multiplier)return;const t=this._element;try{t.playbackRate=e.multiplier}catch(e){t.playbackRate=0}this._lastPlaybackRate=e.multiplier},VideoSynchronizer.prototype._onTick=function(e){const t=this._element;if(!defined(t)||t.readyState<2)return;const n=t.paused,i=e.shouldAnimate;if(i===n&&(i?t.play():t.pause()),this._seeking||this._firstTickAfterSeek)return void(this._firstTickAfterSeek=!1);this._trySetPlaybackRate(e);const r=e.currentTime,o=defaultValue(this.epoch,Iso8601.MINIMUM_VALUE);let a=JulianDate.secondsDifference(r,o);const s=t.duration;let c;const l=t.currentTime;t.loop?(a%=s,a<0&&(a=s-a),c=a):c=a>s?s:a<0?0:a;const u=i?defaultValue(this.tolerance,1):.001;Math.abs(c-l)>u&&(this._seeking=!0,t.currentTime=c)};const VulkanConstants={VK_FORMAT_UNDEFINED:0,VK_FORMAT_R4G4_UNORM_PACK8:1,VK_FORMAT_R4G4B4A4_UNORM_PACK16:2,VK_FORMAT_B4G4R4A4_UNORM_PACK16:3,VK_FORMAT_R5G6B5_UNORM_PACK16:4,VK_FORMAT_B5G6R5_UNORM_PACK16:5,VK_FORMAT_R5G5B5A1_UNORM_PACK16:6,VK_FORMAT_B5G5R5A1_UNORM_PACK16:7,VK_FORMAT_A1R5G5B5_UNORM_PACK16:8,VK_FORMAT_R8_UNORM:9,VK_FORMAT_R8_SNORM:10,VK_FORMAT_R8_USCALED:11,VK_FORMAT_R8_SSCALED:12,VK_FORMAT_R8_UINT:13,VK_FORMAT_R8_SINT:14,VK_FORMAT_R8_SRGB:15,VK_FORMAT_R8G8_UNORM:16,VK_FORMAT_R8G8_SNORM:17,VK_FORMAT_R8G8_USCALED:18,VK_FORMAT_R8G8_SSCALED:19,VK_FORMAT_R8G8_UINT:20,VK_FORMAT_R8G8_SINT:21,VK_FORMAT_R8G8_SRGB:22,VK_FORMAT_R8G8B8_UNORM:23,VK_FORMAT_R8G8B8_SNORM:24,VK_FORMAT_R8G8B8_USCALED:25,VK_FORMAT_R8G8B8_SSCALED:26,VK_FORMAT_R8G8B8_UINT:27,VK_FORMAT_R8G8B8_SINT:28,VK_FORMAT_R8G8B8_SRGB:29,VK_FORMAT_B8G8R8_UNORM:30,VK_FORMAT_B8G8R8_SNORM:31,VK_FORMAT_B8G8R8_USCALED:32,VK_FORMAT_B8G8R8_SSCALED:33,VK_FORMAT_B8G8R8_UINT:34,VK_FORMAT_B8G8R8_SINT:35,VK_FORMAT_B8G8R8_SRGB:36,VK_FORMAT_R8G8B8A8_UNORM:37,VK_FORMAT_R8G8B8A8_SNORM:38,VK_FORMAT_R8G8B8A8_USCALED:39,VK_FORMAT_R8G8B8A8_SSCALED:40,VK_FORMAT_R8G8B8A8_UINT:41,VK_FORMAT_R8G8B8A8_SINT:42,VK_FORMAT_R8G8B8A8_SRGB:43,VK_FORMAT_B8G8R8A8_UNORM:44,VK_FORMAT_B8G8R8A8_SNORM:45,VK_FORMAT_B8G8R8A8_USCALED:46,VK_FORMAT_B8G8R8A8_SSCALED:47,VK_FORMAT_B8G8R8A8_UINT:48,VK_FORMAT_B8G8R8A8_SINT:49,VK_FORMAT_B8G8R8A8_SRGB:50,VK_FORMAT_A8B8G8R8_UNORM_PACK32:51,VK_FORMAT_A8B8G8R8_SNORM_PACK32:52,VK_FORMAT_A8B8G8R8_USCALED_PACK32:53,VK_FORMAT_A8B8G8R8_SSCALED_PACK32:54,VK_FORMAT_A8B8G8R8_UINT_PACK32:55,VK_FORMAT_A8B8G8R8_SINT_PACK32:56,VK_FORMAT_A8B8G8R8_SRGB_PACK32:57,VK_FORMAT_A2R10G10B10_UNORM_PACK32:58,VK_FORMAT_A2R10G10B10_SNORM_PACK32:59,VK_FORMAT_A2R10G10B10_USCALED_PACK32:60,VK_FORMAT_A2R10G10B10_SSCALED_PACK32:61,VK_FORMAT_A2R10G10B10_UINT_PACK32:62,VK_FORMAT_A2R10G10B10_SINT_PACK32:63,VK_FORMAT_A2B10G10R10_UNORM_PACK32:64,VK_FORMAT_A2B10G10R10_SNORM_PACK32:65,VK_FORMAT_A2B10G10R10_USCALED_PACK32:66,VK_FORMAT_A2B10G10R10_SSCALED_PACK32:67,VK_FORMAT_A2B10G10R10_UINT_PACK32:68,VK_FORMAT_A2B10G10R10_SINT_PACK32:69,VK_FORMAT_R16_UNORM:70,VK_FORMAT_R16_SNORM:71,VK_FORMAT_R16_USCALED:72,VK_FORMAT_R16_SSCALED:73,VK_FORMAT_R16_UINT:74,VK_FORMAT_R16_SINT:75,VK_FORMAT_R16_SFLOAT:76,VK_FORMAT_R16G16_UNORM:77,VK_FORMAT_R16G16_SNORM:78,VK_FORMAT_R16G16_USCALED:79,VK_FORMAT_R16G16_SSCALED:80,VK_FORMAT_R16G16_UINT:81,VK_FORMAT_R16G16_SINT:82,VK_FORMAT_R16G16_SFLOAT:83,VK_FORMAT_R16G16B16_UNORM:84,VK_FORMAT_R16G16B16_SNORM:85,VK_FORMAT_R16G16B16_USCALED:86,VK_FORMAT_R16G16B16_SSCALED:87,VK_FORMAT_R16G16B16_UINT:88,VK_FORMAT_R16G16B16_SINT:89,VK_FORMAT_R16G16B16_SFLOAT:90,VK_FORMAT_R16G16B16A16_UNORM:91,VK_FORMAT_R16G16B16A16_SNORM:92,VK_FORMAT_R16G16B16A16_USCALED:93,VK_FORMAT_R16G16B16A16_SSCALED:94,VK_FORMAT_R16G16B16A16_UINT:95,VK_FORMAT_R16G16B16A16_SINT:96,VK_FORMAT_R16G16B16A16_SFLOAT:97,VK_FORMAT_R32_UINT:98,VK_FORMAT_R32_SINT:99,VK_FORMAT_R32_SFLOAT:100,VK_FORMAT_R32G32_UINT:101,VK_FORMAT_R32G32_SINT:102,VK_FORMAT_R32G32_SFLOAT:103,VK_FORMAT_R32G32B32_UINT:104,VK_FORMAT_R32G32B32_SINT:105,VK_FORMAT_R32G32B32_SFLOAT:106,VK_FORMAT_R32G32B32A32_UINT:107,VK_FORMAT_R32G32B32A32_SINT:108,VK_FORMAT_R32G32B32A32_SFLOAT:109,VK_FORMAT_R64_UINT:110,VK_FORMAT_R64_SINT:111,VK_FORMAT_R64_SFLOAT:112,VK_FORMAT_R64G64_UINT:113,VK_FORMAT_R64G64_SINT:114,VK_FORMAT_R64G64_SFLOAT:115,VK_FORMAT_R64G64B64_UINT:116,VK_FORMAT_R64G64B64_SINT:117,VK_FORMAT_R64G64B64_SFLOAT:118,VK_FORMAT_R64G64B64A64_UINT:119,VK_FORMAT_R64G64B64A64_SINT:120,VK_FORMAT_R64G64B64A64_SFLOAT:121,VK_FORMAT_B10G11R11_UFLOAT_PACK32:122,VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:123,VK_FORMAT_D16_UNORM:124,VK_FORMAT_X8_D24_UNORM_PACK32:125,VK_FORMAT_D32_SFLOAT:126,VK_FORMAT_S8_UINT:127,VK_FORMAT_D16_UNORM_S8_UINT:128,VK_FORMAT_D24_UNORM_S8_UINT:129,VK_FORMAT_D32_SFLOAT_S8_UINT:130,VK_FORMAT_BC1_RGB_UNORM_BLOCK:131,VK_FORMAT_BC1_RGB_SRGB_BLOCK:132,VK_FORMAT_BC1_RGBA_UNORM_BLOCK:133,VK_FORMAT_BC1_RGBA_SRGB_BLOCK:134,VK_FORMAT_BC2_UNORM_BLOCK:135,VK_FORMAT_BC2_SRGB_BLOCK:136,VK_FORMAT_BC3_UNORM_BLOCK:137,VK_FORMAT_BC3_SRGB_BLOCK:138,VK_FORMAT_BC4_UNORM_BLOCK:139,VK_FORMAT_BC4_SNORM_BLOCK:140,VK_FORMAT_BC5_UNORM_BLOCK:141,VK_FORMAT_BC5_SNORM_BLOCK:142,VK_FORMAT_BC6H_UFLOAT_BLOCK:143,VK_FORMAT_BC6H_SFLOAT_BLOCK:144,VK_FORMAT_BC7_UNORM_BLOCK:145,VK_FORMAT_BC7_SRGB_BLOCK:146,VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:147,VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:148,VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:149,VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:150,VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:151,VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:152,VK_FORMAT_EAC_R11_UNORM_BLOCK:153,VK_FORMAT_EAC_R11_SNORM_BLOCK:154,VK_FORMAT_EAC_R11G11_UNORM_BLOCK:155,VK_FORMAT_EAC_R11G11_SNORM_BLOCK:156,VK_FORMAT_ASTC_4x4_UNORM_BLOCK:157,VK_FORMAT_ASTC_4x4_SRGB_BLOCK:158,VK_FORMAT_ASTC_5x4_UNORM_BLOCK:159,VK_FORMAT_ASTC_5x4_SRGB_BLOCK:160,VK_FORMAT_ASTC_5x5_UNORM_BLOCK:161,VK_FORMAT_ASTC_5x5_SRGB_BLOCK:162,VK_FORMAT_ASTC_6x5_UNORM_BLOCK:163,VK_FORMAT_ASTC_6x5_SRGB_BLOCK:164,VK_FORMAT_ASTC_6x6_UNORM_BLOCK:165,VK_FORMAT_ASTC_6x6_SRGB_BLOCK:166,VK_FORMAT_ASTC_8x5_UNORM_BLOCK:167,VK_FORMAT_ASTC_8x5_SRGB_BLOCK:168,VK_FORMAT_ASTC_8x6_UNORM_BLOCK:169,VK_FORMAT_ASTC_8x6_SRGB_BLOCK:170,VK_FORMAT_ASTC_8x8_UNORM_BLOCK:171,VK_FORMAT_ASTC_8x8_SRGB_BLOCK:172,VK_FORMAT_ASTC_10x5_UNORM_BLOCK:173,VK_FORMAT_ASTC_10x5_SRGB_BLOCK:174,VK_FORMAT_ASTC_10x6_UNORM_BLOCK:175,VK_FORMAT_ASTC_10x6_SRGB_BLOCK:176,VK_FORMAT_ASTC_10x8_UNORM_BLOCK:177,VK_FORMAT_ASTC_10x8_SRGB_BLOCK:178,VK_FORMAT_ASTC_10x10_UNORM_BLOCK:179,VK_FORMAT_ASTC_10x10_SRGB_BLOCK:180,VK_FORMAT_ASTC_12x10_UNORM_BLOCK:181,VK_FORMAT_ASTC_12x10_SRGB_BLOCK:182,VK_FORMAT_ASTC_12x12_UNORM_BLOCK:183,VK_FORMAT_ASTC_12x12_SRGB_BLOCK:184,VK_FORMAT_G8B8G8R8_422_UNORM:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:1000156006,VK_FORMAT_R10X6_UNORM_PACK16:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:1000156016,VK_FORMAT_R12X4_UNORM_PACK16:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:1000156033,VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:1000054e3,VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:1000054001,VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:1000054002,VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:1000054003,VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:1000054004,VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:1000054005,VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:1000054006,VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:1000054007,VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT:1000066e3,VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT:1000066001,VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT:1000066002,VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT:1000066003,VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT:1000066004,VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT:1000066005,VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT:1000066006,VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT:1000066007,VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT:1000066008,VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT:1000066009,VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT:1000066010,VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT:1000066011,VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT:1000066012,VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT:1000066013,VK_FORMAT_G8B8G8R8_422_UNORM_KHR:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM_KHR:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR:1000156006,VK_FORMAT_R10X6_UNORM_PACK16_KHR:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR:1000156016,VK_FORMAT_R12X4_UNORM_PACK16_KHR:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM_KHR:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM_KHR:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR:1000156033};var VulkanConstants$1=Object.freeze(VulkanConstants);const WallGeometryLibrary={};function latLonEquals(e,t){return CesiumMath.equalsEpsilon(e.latitude,t.latitude,CesiumMath.EPSILON10)&&CesiumMath.equalsEpsilon(e.longitude,t.longitude,CesiumMath.EPSILON10)}const scratchCartographic1=new Cartographic,scratchCartographic2=new Cartographic;function removeDuplicates$1(e,t,n,i){const r=(t=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon)).length;if(r<2)return;const o=defined(i),a=defined(n),s=new Array(r),c=new Array(r),l=new Array(r),u=t[0];s[0]=u;const d=e.cartesianToCartographic(u,scratchCartographic1);a&&(d.height=n[0]),c[0]=d.height,l[0]=o?i[0]:0;let h=c[0]===l[0],p=1;for(let u=1;u<r;++u){const r=t[u],f=e.cartesianToCartographic(r,scratchCartographic2);a&&(f.height=n[u]),h=h&&0===f.height,latLonEquals(d,f)?d.height<f.height&&(c[p-1]=f.height):(s[p]=r,c[p]=f.height,l[p]=o?i[u]:0,h=h&&c[p]===l[p],Cartographic.clone(f,d),++p)}return h||p<2?void 0:(s.length=p,c.length=p,l.length=p,{positions:s,topHeights:c,bottomHeights:l})}const positionsArrayScratch=new Array(2),heightsArrayScratch=new Array(2),generateArcOptionsScratch={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};WallGeometryLibrary.computePositions=function(e,t,n,i,r,o){const a=removeDuplicates$1(e,t,n,i);if(!defined(a))return;t=a.positions,n=a.topHeights,i=a.bottomHeights;const s=t.length,c=s-2;let l,u;const d=CesiumMath.chordLength(r,e.maximumRadius),h=generateArcOptionsScratch;if(h.minDistance=d,h.ellipsoid=e,o){let e,r=0;for(e=0;e<s-1;e++)r+=PolylinePipeline.numberOfPoints(t[e],t[e+1],d)+1;l=new Float64Array(3*r),u=new Float64Array(3*r);const o=positionsArrayScratch,a=heightsArrayScratch;h.positions=o,h.height=a;let c=0;for(e=0;e<s-1;e++){o[0]=t[e],o[1]=t[e+1],a[0]=n[e],a[1]=n[e+1];const r=PolylinePipeline.generateArc(h);l.set(r,c),a[0]=i[e],a[1]=i[e+1],u.set(PolylinePipeline.generateArc(h),c),c+=r.length}}else h.positions=t,h.height=n,l=new Float64Array(PolylinePipeline.generateArc(h)),h.height=i,u=new Float64Array(PolylinePipeline.generateArc(h));return{bottomPositions:u,topPositions:l,numCorners:c}};const scratchCartesian3Position1$1=new Cartesian3,scratchCartesian3Position2$1=new Cartesian3,scratchCartesian3Position4=new Cartesian3,scratchCartesian3Position5=new Cartesian3,scratchBitangent=new Cartesian3,scratchTangent=new Cartesian3,scratchNormal$1=new Cartesian3;function WallGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.maximumHeights,i=e.minimumHeights,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=i,this._maximumHeights=n,this._vertexFormat=VertexFormat.clone(r),this._granularity=o,this._ellipsoid=Ellipsoid.clone(a),this._workerName="createWallGeometry";let s=1+t.length*Cartesian3.packedLength+2;defined(i)&&(s+=i.length),defined(n)&&(s+=n.length),this.packedLength=s+Ellipsoid.packedLength+VertexFormat.packedLength+1}WallGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._minimumHeights;if(o=defined(a)?a.length:0,t[n++]=o,defined(a))for(i=0;i<o;++i)t[n++]=a[i];const s=e._maximumHeights;if(o=defined(s)?s.length:0,t[n++]=o,defined(s))for(i=0;i<o;++i)t[n++]=s[i];return Ellipsoid.pack(e._ellipsoid,t,n),n+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,n),t[n+=VertexFormat.packedLength]=e._granularity,t};const scratchEllipsoid$2=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat=new VertexFormat,scratchOptions$1={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$2,vertexFormat:scratchVertexFormat,granularity:void 0};WallGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);let a,s;if(r=e[t++],r>0)for(a=new Array(r),i=0;i<r;++i)a[i]=e[t++];if(r=e[t++],r>0)for(s=new Array(r),i=0;i<r;++i)s[i]=e[t++];const c=Ellipsoid.unpack(e,t,scratchEllipsoid$2);t+=Ellipsoid.packedLength;const l=VertexFormat.unpack(e,t,scratchVertexFormat),u=e[t+=VertexFormat.packedLength];return defined(n)?(n._positions=o,n._minimumHeights=a,n._maximumHeights=s,n._ellipsoid=Ellipsoid.clone(c,n._ellipsoid),n._vertexFormat=VertexFormat.clone(l,n._vertexFormat),n._granularity=u,n):(scratchOptions$1.positions=o,scratchOptions$1.minimumHeights=a,scratchOptions$1.maximumHeights=s,scratchOptions$1.granularity=u,new WallGeometry(scratchOptions$1))},WallGeometry.fromConstantHeights=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;let n,i;const r=e.minimumHeight,o=e.maximumHeight,a=defined(r),s=defined(o);if(a||s){const e=t.length;n=a?new Array(e):void 0,i=s?new Array(e):void 0;for(let t=0;t<e;++t)a&&(n[t]=r),s&&(i[t]=o)}return new WallGeometry({positions:t,maximumHeights:i,minimumHeights:n,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat})},WallGeometry.createGeometry=function(e){const t=e._positions,n=e._minimumHeights,i=e._maximumHeights,r=e._vertexFormat,o=e._granularity,a=e._ellipsoid,s=WallGeometryLibrary.computePositions(a,t,i,n,o,!0);if(!defined(s))return;const c=s.bottomPositions,l=s.topPositions,u=s.numCorners;let d=l.length,h=2*d;const p=r.position?new Float64Array(h):void 0,f=r.normal?new Float32Array(h):void 0,m=r.tangent?new Float32Array(h):void 0,g=r.bitangent?new Float32Array(h):void 0,_=r.st?new Float32Array(h/3*2):void 0;let y,C=0,T=0,S=0,A=0,v=0,E=scratchNormal$1,b=scratchTangent,x=scratchBitangent,P=!0;d/=3;let D=0;const w=1/(d-u-1);for(y=0;y<d;++y){const e=3*y,t=Cartesian3.fromArray(l,e,scratchCartesian3Position1$1),n=Cartesian3.fromArray(c,e,scratchCartesian3Position2$1);if(r.position&&(p[C++]=n.x,p[C++]=n.y,p[C++]=n.z,p[C++]=t.x,p[C++]=t.y,p[C++]=t.z),r.st&&(_[v++]=D,_[v++]=0,_[v++]=D,_[v++]=1),r.normal||r.tangent||r.bitangent){let n=Cartesian3.clone(Cartesian3.ZERO,scratchCartesian3Position5);const i=Cartesian3.subtract(t,a.geodeticSurfaceNormal(t,scratchCartesian3Position2$1),scratchCartesian3Position2$1);if(y+1<d&&(n=Cartesian3.fromArray(l,e+3,scratchCartesian3Position5)),P){const e=Cartesian3.subtract(n,t,scratchCartesian3Position4),r=Cartesian3.subtract(i,t,scratchCartesian3Position1$1);E=Cartesian3.normalize(Cartesian3.cross(r,e,E),E),P=!1}Cartesian3.equalsEpsilon(t,n,CesiumMath.EPSILON10)?P=!0:(D+=w,r.tangent&&(b=Cartesian3.normalize(Cartesian3.subtract(n,t,b),b)),r.bitangent&&(x=Cartesian3.normalize(Cartesian3.cross(E,b,x),x))),r.normal&&(f[T++]=E.x,f[T++]=E.y,f[T++]=E.z,f[T++]=E.x,f[T++]=E.y,f[T++]=E.z),r.tangent&&(m[A++]=b.x,m[A++]=b.y,m[A++]=b.z,m[A++]=b.x,m[A++]=b.y,m[A++]=b.z),r.bitangent&&(g[S++]=x.x,g[S++]=x.y,g[S++]=x.z,g[S++]=x.x,g[S++]=x.y,g[S++]=x.z)}}const M=new GeometryAttributes;r.position&&(M.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:p})),r.normal&&(M.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),r.tangent&&(M.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),r.bitangent&&(M.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),r.st&&(M.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:_}));const I=h/3;h-=6*(u+1);const R=IndexDatatype$1.createTypedArray(I,h);let O=0;for(y=0;y<I-2;y+=2){const e=y,t=y+2,n=Cartesian3.fromArray(p,3*e,scratchCartesian3Position1$1),i=Cartesian3.fromArray(p,3*t,scratchCartesian3Position2$1);if(Cartesian3.equalsEpsilon(n,i,CesiumMath.EPSILON10))continue;const r=y+1,o=y+3;R[O++]=r,R[O++]=e,R[O++]=o,R[O++]=o,R[O++]=e,R[O++]=t}return new Geometry({attributes:M,indices:R,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere.fromVertices(p)})};const scratchCartesian3Position1=new Cartesian3,scratchCartesian3Position2=new Cartesian3;function WallOutlineGeometry(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.maximumHeights,i=e.minimumHeights,r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=i,this._maximumHeights=n,this._granularity=r,this._ellipsoid=Ellipsoid.clone(o),this._workerName="createWallOutlineGeometry";let a=1+t.length*Cartesian3.packedLength+2;defined(i)&&(a+=i.length),defined(n)&&(a+=n.length),this.packedLength=a+Ellipsoid.packedLength+1}WallOutlineGeometry.pack=function(e,t,n){let i;n=defaultValue(n,0);const r=e._positions;let o=r.length;for(t[n++]=o,i=0;i<o;++i,n+=Cartesian3.packedLength)Cartesian3.pack(r[i],t,n);const a=e._minimumHeights;if(o=defined(a)?a.length:0,t[n++]=o,defined(a))for(i=0;i<o;++i)t[n++]=a[i];const s=e._maximumHeights;if(o=defined(s)?s.length:0,t[n++]=o,defined(s))for(i=0;i<o;++i)t[n++]=s[i];return Ellipsoid.pack(e._ellipsoid,t,n),t[n+=Ellipsoid.packedLength]=e._granularity,t};const scratchEllipsoid$1=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$1,granularity:void 0};function WeightSpline(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).weights,n=e.times;this._times=n,this._weights=t,this._count=t.length/n.length,this._lastTimeIndex=0}function arraySlice(e,t,n){if("function"==typeof e.slice)return e.slice(t,n);let i=Array.prototype.slice.call(e,t,n);const r=FeatureDetection.typedArrayTypes,o=r.length;for(let t=0;t<o;++t)if(e instanceof r[t]){i=new r[t](i);break}return i}let implementation$1;function cancelAnimationFramePolyfill(e){implementation$1(e)}function createGuid(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){const t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)}))}function createWorldTerrain(e){return e=defaultValue(e,defaultValue.EMPTY_OBJECT),new CesiumTerrainProvider({url:IonResource.fromAssetId(1),requestVertexNormals:defaultValue(e.requestVertexNormals,!1),requestWaterMask:defaultValue(e.requestWaterMask,!1)})}WallOutlineGeometry.unpack=function(e,t,n){let i;t=defaultValue(t,0);let r=e[t++];const o=new Array(r);for(i=0;i<r;++i,t+=Cartesian3.packedLength)o[i]=Cartesian3.unpack(e,t);let a,s;if(r=e[t++],r>0)for(a=new Array(r),i=0;i<r;++i)a[i]=e[t++];if(r=e[t++],r>0)for(s=new Array(r),i=0;i<r;++i)s[i]=e[t++];const c=Ellipsoid.unpack(e,t,scratchEllipsoid$1),l=e[t+=Ellipsoid.packedLength];return defined(n)?(n._positions=o,n._minimumHeights=a,n._maximumHeights=s,n._ellipsoid=Ellipsoid.clone(c,n._ellipsoid),n._granularity=l,n):(scratchOptions.positions=o,scratchOptions.minimumHeights=a,scratchOptions.maximumHeights=s,scratchOptions.granularity=l,new WallOutlineGeometry(scratchOptions))},WallOutlineGeometry.fromConstantHeights=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;let n,i;const r=e.minimumHeight,o=e.maximumHeight,a=defined(r),s=defined(o);if(a||s){const e=t.length;n=a?new Array(e):void 0,i=s?new Array(e):void 0;for(let t=0;t<e;++t)a&&(n[t]=r),s&&(i[t]=o)}return new WallOutlineGeometry({positions:t,maximumHeights:i,minimumHeights:n,ellipsoid:e.ellipsoid})},WallOutlineGeometry.createGeometry=function(e){const t=e._positions,n=e._minimumHeights,i=e._maximumHeights,r=e._granularity,o=e._ellipsoid,a=WallGeometryLibrary.computePositions(o,t,i,n,r,!1);if(!defined(a))return;const s=a.bottomPositions,c=a.topPositions;let l=c.length,u=2*l;const d=new Float64Array(u);let h,p=0;for(l/=3,h=0;h<l;++h){const e=3*h,t=Cartesian3.fromArray(c,e,scratchCartesian3Position1),n=Cartesian3.fromArray(s,e,scratchCartesian3Position2);d[p++]=n.x,d[p++]=n.y,d[p++]=n.z,d[p++]=t.x,d[p++]=t.y,d[p++]=t.z}const f=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})}),m=u/3;u=2*m-4+m;const g=IndexDatatype$1.createTypedArray(m,u);let _=0;for(h=0;h<m-2;h+=2){const e=h,t=h+2,n=Cartesian3.fromArray(d,3*e,scratchCartesian3Position1),i=Cartesian3.fromArray(d,3*t,scratchCartesian3Position2);if(Cartesian3.equalsEpsilon(n,i,CesiumMath.EPSILON10))continue;const r=h+1,o=h+3;g[_++]=r,g[_++]=e,g[_++]=r,g[_++]=o,g[_++]=e,g[_++]=t}return g[_++]=m-2,g[_++]=m-1,new Geometry({attributes:f,indices:g,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere.fromVertices(d)})},Object.defineProperties(WeightSpline.prototype,{times:{get:function(){return this._times}},weights:{get:function(){return this._weights}}}),WeightSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,WeightSpline.prototype.wrapTime=Spline.prototype.wrapTime,WeightSpline.prototype.clampTime=Spline.prototype.clampTime,WeightSpline.prototype.evaluate=function(e,t){const n=this.weights,i=this.times,r=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),o=(e-i[r])/(i[r+1]-i[r]);defined(t)||(t=new Array(this._count));for(let e=0;e<this._count;e++){const i=r*this._count+e;t[e]=n[i]*(1-o)+n[i+this._count]*o}return t},"undefined"!=typeof cancelAnimationFrame&&(implementation$1=cancelAnimationFrame),function(){if(!defined(implementation$1)&&"undefined"!=typeof window){const e=["webkit","moz","ms","o"];let t=0;const n=e.length;for(;t<n&&!defined(implementation$1);)implementation$1=window[`${e[t]}CancelAnimationFrame`],defined(implementation$1)||(implementation$1=window[`${e[t]}CancelRequestAnimationFrame`]),++t}defined(implementation$1)||(implementation$1=clearTimeout)}();const compressedMagic=1953029805,compressedMagicSwap=2917034100;function decodeGoogleEarthEnterpriseData(e,t){if(decodeGoogleEarthEnterpriseData.passThroughDataForTesting)return t;const n=e.byteLength;if(0===n||n%4!=0)throw new RuntimeError("The length of key must be greater than 0 and a multiple of 4.");const i=new DataView(t),r=i.getUint32(0,!0);if(r===compressedMagic||r===compressedMagicSwap)return t;const o=new DataView(e);let a=0;const s=t.byteLength,c=s-s%8,l=n;let u,d=8;for(;a<c;)for(d=(d+8)%24,u=d;a<c&&u<l;)i.setUint32(a,i.getUint32(a,!0)^o.getUint32(u,!0),!0),i.setUint32(a+4,i.getUint32(a+4,!0)^o.getUint32(u+4,!0),!0),a+=8,u+=24;if(a<s)for(u>=l&&(d=(d+8)%24,u=d);a<s;)i.setUint8(a,i.getUint8(a)^o.getUint8(u)),a++,u++}decodeGoogleEarthEnterpriseData.passThroughDataForTesting=!1;const maxShort=32767,scratchBVCartographic$1=new Cartographic,scratchEncodedPosition=new Cartesian3;function decodeVectorPolylinePositions(e,t,n,i,r){const o=e.length/3,a=e.subarray(0,o),s=e.subarray(o,2*o),c=e.subarray(2*o,3*o);AttributeCompression.zigZagDeltaDecode(a,s,c);const l=new Float64Array(e.length);for(let e=0;e<o;++e){const o=a[e],u=s[e],d=c[e],h=CesiumMath.lerp(t.west,t.east,o/maxShort),p=CesiumMath.lerp(t.south,t.north,u/maxShort),f=CesiumMath.lerp(n,i,d/maxShort),m=Cartographic.fromRadians(h,p,f,scratchBVCartographic$1),g=r.cartographicToCartesian(m,scratchEncodedPosition);Cartesian3.pack(g,l,3*e)}return l}function deprecationWarning(e,t){oneTimeWarning(e,t)}function getFilenameFromUri(e){const t=new URI(e);t.normalize();let n=t.path();const i=n.lastIndexOf("/");return-1!==i&&(n=n.substr(i+1)),n}function getMagic(e,t){return getStringFromTypedArray(e,t=defaultValue(t,0),Math.min(4,e.length))}function loadImageFromTypedArray(e){const t=e.uint8Array,n=e.format,i=e.request,r=defaultValue(e.flipY,!1),o=defaultValue(e.skipColorSpaceConversion,!1),a=new Blob([t],{type:n});let s;return Resource.supportsImageBitmapOptions().then((function(e){if(e)return when(Resource.createImageBitmapFromBlob(a,{flipY:r,premultiplyAlpha:!1,skipColorSpaceConversion:o}));s=window.URL.createObjectURL(a);return new Resource({url:s,request:i}).fetchImage({flipY:r,skipColorSpaceConversion:o})})).then((function(e){return defined(s)&&window.URL.revokeObjectURL(s),e})).otherwise((function(e){return defined(s)&&window.URL.revokeObjectURL(s),when.reject(e)}))}let supportedTranscoderFormats;function loadKTX2(e){let t;if(e instanceof ArrayBuffer||ArrayBuffer.isView(e))t=when.resolve(e);else{t=Resource.createIfNeeded(e).fetchArrayBuffer()}return t.then((function(e){return KTX2Transcoder.transcode(e,supportedTranscoderFormats)}))}loadKTX2.setKTX2SupportedFormats=function(e,t,n,i,r,o){supportedTranscoderFormats={s3tc:e,pvrtc:t,astc:n,etc:i,etc1:r,bc7:o}};const leftScratchArray=[],rightScratchArray=[];function merge$1(e,t,n,i,r,o){const a=r-i+1,s=o-r,c=leftScratchArray,l=rightScratchArray;let u,d;for(u=0;u<a;++u)c[u]=e[i+u];for(d=0;d<s;++d)l[d]=e[r+d+1];u=0,d=0;for(let r=i;r<=o;++r){const i=c[u],o=l[d];u<a&&(d>=s||t(i,o,n)<=0)?(e[r]=i,++u):d<s&&(e[r]=o,++d)}}function sort(e,t,n,i,r){if(i>=r)return;const o=Math.floor(.5*(i+r));sort(e,t,n,i,o),sort(e,t,n,o+1,r),merge$1(e,t,n,i,o,r)}function mergeSort(e,t,n){const i=e.length,r=Math.ceil(.5*i);leftScratchArray.length=r,rightScratchArray.length=r,sort(e,t,n,0,i-1),leftScratchArray.length=0,rightScratchArray.length=0}const scratchBarycentricCoords=new Cartesian3;function pointInsideTriangle(e,t,n,i){const r=barycentricCoordinates(e,t,n,i,scratchBarycentricCoords);return!!defined(r)&&(r.x>0&&r.y>0&&r.z>0)}let implementation;function requestAnimationFramePolyFill(e){return implementation(e)}function sampleTerrain(e,t,n){return e.readyPromise.then((function(){return doSampling(e,t,n)}))}function doSampling(e,t,n){const i=e.tilingScheme;let r;const o=[],a={};for(r=0;r<n.length;++r){const s=i.positionToTileXY(n[r],t),c=s.toString();if(!a.hasOwnProperty(c)){const n={x:s.x,y:s.y,level:t,tilingScheme:i,terrainProvider:e,positions:[]};a[c]=n,o.push(n)}a[c].positions.push(n[r])}const s=[];for(r=0;r<o.length;++r){const e=o[r],t=e.terrainProvider.requestTileGeometry(e.x,e.y,e.level).then(createInterpolateFunction(e)).otherwise(createMarkFailedFunction(e));s.push(t)}return when.all(s,(function(){return n}))}function interpolateAndAssignHeight(e,t,n){const i=t.interpolateHeight(n,e.longitude,e.latitude);return void 0!==i&&(e.height=i,!0)}function createInterpolateFunction(e){const t=e.positions,n=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(i){let r=!1;for(let e=0;e<t.length;++e){if(!interpolateAndAssignHeight(t[e],i,n)){r=!0;break}}return r?i.createMesh({tilingScheme:e.tilingScheme,x:e.x,y:e.y,level:e.level,throttle:!1}).then((function(){for(let e=0;e<t.length;++e){interpolateAndAssignHeight(t[e],i,n)}})):when.resolve()}}function createMarkFailedFunction(e){const t=e.positions;return function(){for(let e=0;e<t.length;++e){t[e].height=void 0}}}"undefined"!=typeof requestAnimationFrame&&(implementation=requestAnimationFrame),function(){if(!defined(implementation)&&"undefined"!=typeof window){const e=["webkit","moz","ms","o"];let t=0;const n=e.length;for(;t<n&&!defined(implementation);)implementation=window[`${e[t]}RequestAnimationFrame`],++t}if(!defined(implementation)){const e=1e3/60;let t=0;implementation=function(n){const i=getTimestamp$1(),r=Math.max(e-(i-t),0);return t=i+r,setTimeout((function(){n(t)}),r)}}}();const scratchCartesian2$4=new Cartesian2;function sampleTerrainMostDetailed(e,t){return e.readyPromise.then((function(){const n=[],i=[],r=e.availability,o=[];for(let a=0;a<t.length;++a){const s=t[a],c=r.computeMaximumLevelAtPosition(s);if(i[a]=c,0===c){e.tilingScheme.positionToTileXY(s,1,scratchCartesian2$4);const t=e.loadTileDataAvailability(scratchCartesian2$4.x,scratchCartesian2$4.y,1);defined(t)&&o.push(t)}let l=n[c];defined(l)||(n[c]=l=[]),l.push(s)}return when.all(o).then((function(){return when.all(n.map((function(t,n){if(defined(t))return sampleTerrain(e,n,t)})))})).then((function(){const n=[];for(let e=0;e<t.length;++e){const o=t[e];r.computeMaximumLevelAtPosition(o)!==i[e]&&n.push(o)}if(n.length>0)return sampleTerrainMostDetailed(e,n)})).then((function(){return t}))}))}function subdivideArray(e,t){const n=[],i=e.length;let r=0;for(;r<i;){const o=Math.ceil((i-r)/t--);n.push(e.slice(r,r+o)),r+=o}return n}function webGLConstantToGlslType(e){switch(e){case WebGLConstants$1.FLOAT:return"float";case WebGLConstants$1.FLOAT_VEC2:return"vec2";case WebGLConstants$1.FLOAT_VEC3:return"vec3";case WebGLConstants$1.FLOAT_VEC4:return"vec4";case WebGLConstants$1.FLOAT_MAT2:return"mat2";case WebGLConstants$1.FLOAT_MAT3:return"mat3";case WebGLConstants$1.FLOAT_MAT4:return"mat4";case WebGLConstants$1.SAMPLER_2D:return"sampler2D";case WebGLConstants$1.BOOL:return"bool"}}function wrapFunction(e,t,n){return function(){n.apply(e,arguments),t.apply(e,arguments)}}function ConstantProperty(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new Event,this.setValue(e)}function createProperty(e,t,n,i,r){return{configurable:i,get:function(){return this[t]},set:function(i){const o=this[t],a=this[n];defined(a)&&(a(),this[n]=void 0);!(void 0!==i)||defined(i)&&defined(i.getValue)||!defined(r)||(i=r(i)),o!==i&&(this[t]=i,this._definitionChanged.raiseEvent(this,e,i,o)),defined(i)&&defined(i.definitionChanged)&&(this[n]=i.definitionChanged.addEventListener((function(){this._definitionChanged.raiseEvent(this,e,i,i)}),this))}}}function createConstantProperty$1(e){return new ConstantProperty(e)}function createPropertyDescriptor(e,t,n){return createProperty(e,`_${e.toString()}`,`_${e.toString()}Subscription`,defaultValue(t,!1),defaultValue(n,createConstantProperty$1))}function BillboardGraphics(e){this._definitionChanged=new Event,this._show=void 0,this._showSubscription=void 0,this._image=void 0,this._imageSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._disableDepthTestDistance=void 0,this._disableDepthTestDistanceSubscription=void 0,this.merge(defaultValue(e,defaultValue.EMPTY_OBJECT))}Object.defineProperties(ConstantProperty.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),ConstantProperty.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},ConstantProperty.prototype.setValue=function(e){const t=this._value;if(t!==e){const n=defined(e),i=n&&"function"==typeof e.clone,r=n&&"function"==typeof e.equals;(!r||!e.equals(t))&&(this._hasClone=i,this._hasEquals=r,this._value=i?e.clone(this._value):e,this._definitionChanged.raiseEvent(this))}},ConstantProperty.prototype.equals=function(e){return this===e||e instanceof ConstantProperty&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},ConstantProperty.prototype.valueOf=function(){return this._value},ConstantProperty.prototype.toString=function(){return String(this._value)},Object.defineProperties(BillboardGraphics.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:createPropertyDescriptor("show"),image:createPropertyDescriptor("image"),scale:createPropertyDescriptor("scale"),pixelOffset:createPropertyDescriptor("pixelOffset"),eyeOffset:createPropertyDescriptor("eyeOffset"),horizontalOrigin:createPropertyDescriptor("horizontalOrigin"),verticalOrigin:createPropertyDescriptor("verticalOrigin"),heightReference:createPropertyDescriptor("heightReference"),color:createPropertyDescriptor("color"),rotation:createPropertyDescriptor("rotation"),alignedAxis:createPropertyDescriptor("alignedAxis"),sizeInMeters:createPropertyDescriptor("sizeInMeters"),width:createPropertyDescriptor("width"),height:createPropertyDescriptor("height"),scaleByDistance:createPropertyDescriptor("scaleByDistance"),translucencyByDistance:createPropertyDescriptor("translucencyByDistance"),pixelOffsetScaleByDistance:createPropertyDescriptor("pixelOffsetScaleByDistance"),imageSubRegion:createPropertyDescriptor("imageSubRegion"),distanceDisplayCondition:createPropertyDescriptor("distanceDisplayCondition"),disableDepthTestDistance:createPropertyDescriptor("disableDepthTestDistance")}),BillboardGraphics.prototype.clone=function(e){return defined(e)?(e.show=this._show,e.image=this._image,e.scale=this._scale,e.pixelOffset=this._pixelOffset,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.verticalOrigin=this._verticalOrigin,e.heightReference=this._heightReference,e.color=this._color,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.sizeInMeters=this._sizeInMeters,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.imageSubRegion=this._imageSubRegion,e.distanceDisplayCondition=this._distanceDisplayCondition,e.disableDepthTestDistance=this._disableDepthTestDistance,e):new BillboardGraphics(this)},BillboardGraphics.prototype.merge=function(e){this.show=defaultValue(this._show,e.show),this.image=defaultValue(this._image,e.image),this.scale=defaultValue(this._scale,e.scale),this.pixelOffset=defaultValue(this._pixelOffset,e.pixelOffset),this.eyeOffset=defaultValue(this._eyeOffset,e.eyeOffset),this.horizontalOrigin=defaultValue(this._horizontalOrigin,e.horizontalOrigin),this.verticalOrigin=defaultValue(this._verticalOrigin,e.verticalOrigin),this.heightReference=defaultValue(this._heightReference,e.heightReference),this.color=defaultValue(this._color,e.color),this.rotation=defaultValue(this._rotation,e.rotation),this.alignedAxis=defaultValue(this._alignedAxis,e.alignedAxis),this.sizeInMeters=defaultValue(this._sizeInMeters,e.sizeInMeters),this.width=defaultValue(this._width,e.width),this.height=defaultValue(this._height,e.height),this.scaleByDistance=defaultValue(this._scaleByDistance,e.scaleByDistance),this.translucencyByDistance=defaultValue(this._translucencyByDistance,e.translucencyByDistance),this.pixelOffsetScaleByDistance=defaultValue(this._pixelOffsetScaleByDistance,e.pixelOffsetScaleByDistance),this.imageSubRegion=defaultValue(this._imageSubRegion,e.imageSubRegion),this.distanceDisplayCondition=defaultValue(this._distanceDisplayCondition,e.distanceDisplayCondition),this.disableDepthTestDistance=defaultValue(this._disableDepthTestDistance,e.disableDepthTestDistance)};const HeightReference={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2};var HeightReference$1=Object.freeze(HeightReference);const HorizontalOrigin={CENTER:0,LEFT:1,RIGHT:-1};var HorizontalOrigin$1=Object.freeze(HorizontalOrigin);const VerticalOrigin={CENTER:0,BOTTOM:1,BASELINE:2,TOP:-1};var VerticalOrigin$1=Object.freeze(VerticalOrigin);const BoundingSphereState={DONE:0,PENDING:1,FAILED:2};var BoundingSphereState$1=Object.freeze(BoundingSphereState);function Property(){DeveloperError.throwInstantiationError()}Object.defineProperties(Property.prototype,{isConstant:{get:DeveloperError.throwInstantiationError},definitionChanged:{get:DeveloperError.throwInstantiationError}}),Property.prototype.getValue=DeveloperError.throwInstantiationError,Property.prototype.equals=DeveloperError.throwInstantiationError,Property.equals=function(e,t){return e===t||defined(e)&&e.equals(t)},Property.arrayEquals=function(e,t){if(e===t)return!0;if(!defined(e)||!defined(t)||e.length!==t.length)return!1;const n=e.length;for(let i=0;i<n;i++)if(!Property.equals(e[i],t[i]))return!1;return!0},Property.isConstant=function(e){return!defined(e)||e.isConstant},Property.getValueOrUndefined=function(e,t,n){return defined(e)?e.getValue(t,n):void 0},Property.getValueOrDefault=function(e,t,n,i){return defined(e)?defaultValue(e.getValue(t,i),n):n},Property.getValueOrClonedDefault=function(e,t,n,i){let r;return defined(e)&&(r=e.getValue(t,i)),defined(r)||(r=n.clone(r)),r};const defaultColor$8=Color.WHITE,defaultEyeOffset$1=Cartesian3.ZERO,defaultHeightReference$2=HeightReference$1.NONE,defaultPixelOffset$1=Cartesian2.ZERO,defaultScale$3=1,defaultRotation=0,defaultAlignedAxis=Cartesian3.ZERO,defaultHorizontalOrigin$1=HorizontalOrigin$1.CENTER,defaultVerticalOrigin$1=VerticalOrigin$1.CENTER,defaultSizeInMeters=!1,positionScratch$8=new Cartesian3,colorScratch$6=new Color,eyeOffsetScratch$1=new Cartesian3,pixelOffsetScratch$1=new Cartesian2,scaleByDistanceScratch$2=new NearFarScalar,translucencyByDistanceScratch$2=new NearFarScalar,pixelOffsetScaleByDistanceScratch$1=new NearFarScalar,boundingRectangleScratch=new BoundingRectangle,distanceDisplayConditionScratch$8=new DistanceDisplayCondition;function EntityData$3(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function BillboardVisualizer(e,t){t.collectionChanged.addEventListener(BillboardVisualizer.prototype._onCollectionChanged,this),this._cluster=e,this._entityCollection=t,this._items=new AssociativeArray,this._onCollectionChanged(t,t.values,[],[])}function returnPrimitive$2(e,t,n){defined(e)&&(e.billboard=void 0,n.removeBillboard(t))}BillboardVisualizer.prototype.update=function(e){const t=this._items.values,n=this._cluster;for(let i=0,r=t.length;i<r;i++){const r=t[i],o=r.entity,a=o._billboard;let s,c,l=r.billboard,u=o.isShowing&&o.isAvailable(e)&&Property.getValueOrDefault(a._show,e,!0);if(u&&(c=Property.getValueOrUndefined(o._position,e,positionScratch$8),s=Property.getValueOrUndefined(a._image,e),u=defined(c)&&defined(s)),!u){returnPrimitive$2(r,o,n);continue}Property.isConstant(o._position)||(n._clusterDirty=!0),defined(l)||(l=n.getBillboard(o),l.id=o,l.image=void 0,r.billboard=l),l.show=u,defined(l.image)&&r.textureValue===s||(l.image=s,r.textureValue=s),l.position=c,l.color=Property.getValueOrDefault(a._color,e,defaultColor$8,colorScratch$6),l.eyeOffset=Property.getValueOrDefault(a._eyeOffset,e,defaultEyeOffset$1,eyeOffsetScratch$1),l.heightReference=Property.getValueOrDefault(a._heightReference,e,defaultHeightReference$2),l.pixelOffset=Property.getValueOrDefault(a._pixelOffset,e,defaultPixelOffset$1,pixelOffsetScratch$1),l.scale=Property.getValueOrDefault(a._scale,e,defaultScale$3),l.rotation=Property.getValueOrDefault(a._rotation,e,defaultRotation),l.alignedAxis=Property.getValueOrDefault(a._alignedAxis,e,defaultAlignedAxis),l.horizontalOrigin=Property.getValueOrDefault(a._horizontalOrigin,e,defaultHorizontalOrigin$1),l.verticalOrigin=Property.getValueOrDefault(a._verticalOrigin,e,defaultVerticalOrigin$1),l.width=Property.getValueOrUndefined(a._width,e),l.height=Property.getValueOrUndefined(a._height,e),l.scaleByDistance=Property.getValueOrUndefined(a._scaleByDistance,e,scaleByDistanceScratch$2),l.translucencyByDistance=Property.getValueOrUndefined(a._translucencyByDistance,e,translucencyByDistanceScratch$2),l.pixelOffsetScaleByDistance=Property.getValueOrUndefined(a._pixelOffsetScaleByDistance,e,pixelOffsetScaleByDistanceScratch$1),l.sizeInMeters=Property.getValueOrDefault(a._sizeInMeters,e,defaultSizeInMeters),l.distanceDisplayCondition=Property.getValueOrUndefined(a._distanceDisplayCondition,e,distanceDisplayConditionScratch$8),l.disableDepthTestDistance=Property.getValueOrUndefined(a._disableDepthTestDistance,e);const d=Property.getValueOrUndefined(a._imageSubRegion,e,boundingRectangleScratch);defined(d)&&l.setImageSubRegion(l._imageId,d)}return!0},BillboardVisualizer.prototype.getBoundingSphere=function(e,t){const n=this._items.get(e.id);if(!defined(n)||!defined(n.billboard))return BoundingSphereState$1.FAILED;const i=n.billboard;if(i.heightReference===HeightReference$1.NONE)t.center=Cartesian3.clone(i.position,t.center);else{if(!defined(i._clampedPosition))return BoundingSphereState$1.PENDING;t.center=Cartesian3.clone(i._clampedPosition,t.center)}return t.radius=0,BoundingSphereState$1.DONE},BillboardVisualizer.prototype.isDestroyed=function(){return!1},BillboardVisualizer.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(BillboardVisualizer.prototype._onCollectionChanged,this);const e=this._entityCollection.values;for(let t=0;t<e.length;t++)this._cluster.removeBillboard(e[t]);return destroyObject(this)},BillboardVisualizer.prototype._onCollectionChanged=function(e,t,n,i){let r,o;const a=this._items,s=this._cluster;for(r=t.length-1;r>-1;r--)o=t[r],defined(o._billboard)&&defined(o._position)&&a.set(o.id,new EntityData$3(o));for(r=i.length-1;r>-1;r--)o=i[r],defined(o._billboard)&&defined(o._position)?a.contains(o.id)||a.set(o.id,new EntityData$3(o)):(returnPrimitive$2(a.get(o.id),o,s),a.remove(o.id));for(r=n.length-1;r>-1;r--)o=n[r],returnPrimitive$2(a.get(o.id),o,s),a.remove(o.id)};var AllMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_bitangentEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",AllMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 bitangent;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_bitangentEC = czm_normal * bitangent;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BasicMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",BasicMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",TexturedMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",TexturedMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";const BlendEquation={ADD:WebGLConstants$1.FUNC_ADD,SUBTRACT:WebGLConstants$1.FUNC_SUBTRACT,REVERSE_SUBTRACT:WebGLConstants$1.FUNC_REVERSE_SUBTRACT,MIN:WebGLConstants$1.MIN,MAX:WebGLConstants$1.MAX};var BlendEquation$1=Object.freeze(BlendEquation);const BlendFunction={ZERO:WebGLConstants$1.ZERO,ONE:WebGLConstants$1.ONE,SOURCE_COLOR:WebGLConstants$1.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:WebGLConstants$1.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:WebGLConstants$1.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:WebGLConstants$1.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:WebGLConstants$1.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:WebGLConstants$1.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:WebGLConstants$1.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:WebGLConstants$1.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:WebGLConstants$1.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:WebGLConstants$1.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:WebGLConstants$1.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:WebGLConstants$1.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:WebGLConstants$1.SRC_ALPHA_SATURATE};var BlendFunction$1=Object.freeze(BlendFunction);const BlendingState={DISABLED:Object.freeze({enabled:!1}),ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.ONE,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE,functionDestinationAlpha:BlendFunction$1.ONE})};var BlendingState$1=Object.freeze(BlendingState);const CullFace={FRONT:WebGLConstants$1.FRONT,BACK:WebGLConstants$1.BACK,FRONT_AND_BACK:WebGLConstants$1.FRONT_AND_BACK};var CullFace$1=Object.freeze(CullFace);function Appearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.material=e.material,this.translucent=defaultValue(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=defaultValue(e.closed,!1)}Object.defineProperties(Appearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),Appearance.prototype.getFragmentShaderSource=function(){const e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),defined(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},Appearance.prototype.isTranslucent=function(){return defined(this.material)&&this.material.isTranslucent()||!defined(this.material)&&this.translucent},Appearance.prototype.getRenderState=function(){const e=this.isTranslucent(),t=clone$1(this.renderState,!1);return e?(t.depthMask=!1,t.blending=BlendingState$1.ALPHA_BLEND):t.depthMask=!0,t},Appearance.getDefaultRenderState=function(e,t,n){let i={depthTest:{enabled:!0}};return e&&(i.depthMask=!1,i.blending=BlendingState$1.ALPHA_BLEND),t&&(i.cull={enabled:!0,face:CullFace$1.BACK}),defined(n)&&(i=combine$2(n,i,!0)),i};const ContextLimits={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_maximumSamples:0,_highpFloatSupported:!1,_highpIntSupported:!1};function CubeMapFace(e,t,n,i,r,o,a,s,c,l,u){this._context=e,this._texture=t,this._textureTarget=n,this._targetFace=i,this._pixelDatatype=a,this._internalFormat=r,this._pixelFormat=o,this._size=s,this._preMultiplyAlpha=c,this._flipY=l,this._initialized=u}Object.defineProperties(ContextLimits,{maximumCombinedTextureImageUnits:{get:function(){return ContextLimits._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return ContextLimits._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return ContextLimits._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return ContextLimits._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return ContextLimits._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return ContextLimits._maximumTextureSize}},maximumVaryingVectors:{get:function(){return ContextLimits._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return ContextLimits._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return ContextLimits._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return ContextLimits._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return ContextLimits._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return ContextLimits._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return ContextLimits._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return ContextLimits._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return ContextLimits._maximumViewportWidth}},maximumViewportHeight:{get:function(){return ContextLimits._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return ContextLimits._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return ContextLimits._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return ContextLimits._maximumColorAttachments}},maximumSamples:{get:function(){return ContextLimits._maximumSamples}},highpFloatSupported:{get:function(){return ContextLimits._highpFloatSupported}},highpIntSupported:{get:function(){return ContextLimits._highpIntSupported}}}),Object.defineProperties(CubeMapFace.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),CubeMapFace.prototype.copyFrom=function(e){const t=defaultValue(e.xOffset,0),n=defaultValue(e.yOffset,0),i=e.source,r=this._context._gl,o=this._textureTarget,a=this._targetFace;r.activeTexture(r.TEXTURE0),r.bindTexture(o,this._texture);const s=i.width,c=i.height;let l=i.arrayBufferView;const u=this._size,d=this._pixelFormat,h=this._internalFormat,p=this._pixelDatatype,f=this._preMultiplyAlpha,m=this._flipY,g=defaultValue(e.skipColorSpaceConversion,!1);let _=4;defined(l)&&(_=PixelFormat$1.alignmentInBytes(d,p,s)),r.pixelStorei(r.UNPACK_ALIGNMENT,_),g?r.pixelStorei(r.UNPACK_COLORSPACE_CONVERSION_WEBGL,r.NONE):r.pixelStorei(r.UNPACK_COLORSPACE_CONVERSION_WEBGL,r.BROWSER_DEFAULT_WEBGL);let y=!1;if(!this._initialized){if(0===t&&0===n&&s===u&&c===u)defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),m&&(l=PixelFormat$1.flipY(l,d,p,u,u)),r.texImage2D(a,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,m),r.texImage2D(a,0,h,d,PixelDatatype$1.toWebGLConstant(p,this._context),i)),y=!0;else{r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1);const e=PixelFormat$1.createTypedArray(d,p,u,u);r.texImage2D(a,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),e)}this._initialized=!0}y||(defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),m&&(l=PixelFormat$1.flipY(l,d,p,s,c)),r.texSubImage2D(a,0,t,n,s,c,d,PixelDatatype$1.toWebGLConstant(p,this._context),l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,m),r.texSubImage2D(a,0,t,n,d,PixelDatatype$1.toWebGLConstant(p,this._context),i))),r.bindTexture(o,null)},CubeMapFace.prototype.copyFromFramebuffer=function(e,t,n,i,r,o){e=defaultValue(e,0),t=defaultValue(t,0),n=defaultValue(n,0),i=defaultValue(i,0),r=defaultValue(r,this._size),o=defaultValue(o,this._size);const a=this._context._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture),a.copyTexSubImage2D(this._targetFace,0,e,t,n,i,r,o),a.bindTexture(s,null),this._initialized=!0};const MipmapHint={DONT_CARE:WebGLConstants$1.DONT_CARE,FASTEST:WebGLConstants$1.FASTEST,NICEST:WebGLConstants$1.NICEST,validate:function(e){return e===MipmapHint.DONT_CARE||e===MipmapHint.FASTEST||e===MipmapHint.NICEST}};var MipmapHint$1=Object.freeze(MipmapHint);const TextureMagnificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,validate:function(e){return e===TextureMagnificationFilter.NEAREST||e===TextureMagnificationFilter.LINEAR}};var TextureMagnificationFilter$1=Object.freeze(TextureMagnificationFilter);const TextureMinificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,NEAREST_MIPMAP_NEAREST:WebGLConstants$1.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:WebGLConstants$1.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:WebGLConstants$1.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:WebGLConstants$1.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===TextureMinificationFilter.NEAREST||e===TextureMinificationFilter.LINEAR||e===TextureMinificationFilter.NEAREST_MIPMAP_NEAREST||e===TextureMinificationFilter.LINEAR_MIPMAP_NEAREST||e===TextureMinificationFilter.NEAREST_MIPMAP_LINEAR||e===TextureMinificationFilter.LINEAR_MIPMAP_LINEAR}};var TextureMinificationFilter$1=Object.freeze(TextureMinificationFilter);const TextureWrap={CLAMP_TO_EDGE:WebGLConstants$1.CLAMP_TO_EDGE,REPEAT:WebGLConstants$1.REPEAT,MIRRORED_REPEAT:WebGLConstants$1.MIRRORED_REPEAT,validate:function(e){return e===TextureWrap.CLAMP_TO_EDGE||e===TextureWrap.REPEAT||e===TextureWrap.MIRRORED_REPEAT}};var TextureWrap$1=Object.freeze(TextureWrap);function Sampler(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.wrapS,TextureWrap$1.CLAMP_TO_EDGE),n=defaultValue(e.wrapT,TextureWrap$1.CLAMP_TO_EDGE),i=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),r=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),o=defined(e.maximumAnisotropy)?e.maximumAnisotropy:1;this._wrapS=t,this._wrapT=n,this._minificationFilter=i,this._magnificationFilter=r,this._maximumAnisotropy=o}function CubeMap(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,n=e.source;let i;if(defined(n)){const e=[n.positiveX,n.negativeX,n.positiveY,n.negativeY,n.positiveZ,n.negativeZ];i=e[0].width}else i=e.width;const r=i,o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),a=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),s=PixelFormat$1.toInternalFormat(a,o,t),c=6*PixelFormat$1.textureSizeInBytes(a,o,r,r),l=e.preMultiplyAlpha||a===PixelFormat$1.RGB||a===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=defaultValue(e.skipColorSpaceConversion,!1),h=t._gl,p=h.TEXTURE_CUBE_MAP,f=h.createTexture();function m(e,n,c,l,u){let d=n.arrayBufferView;defined(d)||(d=n.bufferView);let p=4;defined(d)&&(p=PixelFormat$1.alignmentInBytes(a,o,i)),h.pixelStorei(h.UNPACK_ALIGNMENT,p),u?h.pixelStorei(h.UNPACK_COLORSPACE_CONVERSION_WEBGL,h.NONE):h.pixelStorei(h.UNPACK_COLORSPACE_CONVERSION_WEBGL,h.BROWSER_DEFAULT_WEBGL),defined(d)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1),l&&(d=PixelFormat$1.flipY(d,a,o,r,r)),h.texImage2D(e,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),d)):(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,l),h.texImage2D(e,0,s,a,PixelDatatype$1.toWebGLConstant(o,t),n))}h.activeTexture(h.TEXTURE0),h.bindTexture(p,f),defined(n)?(m(h.TEXTURE_CUBE_MAP_POSITIVE_X,n.positiveX,l,u,d),m(h.TEXTURE_CUBE_MAP_NEGATIVE_X,n.negativeX,l,u,d),m(h.TEXTURE_CUBE_MAP_POSITIVE_Y,n.positiveY,l,u,d),m(h.TEXTURE_CUBE_MAP_NEGATIVE_Y,n.negativeY,l,u,d),m(h.TEXTURE_CUBE_MAP_POSITIVE_Z,n.positiveZ,l,u,d),m(h.TEXTURE_CUBE_MAP_NEGATIVE_Z,n.negativeZ,l,u,d)):(h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_X,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_X,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_Y,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_Z,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,s,r,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null)),h.bindTexture(p,null),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=p,this._texture=f,this._pixelFormat=a,this._pixelDatatype=o,this._size=r,this._hasMipmap=!1,this._sizeInBytes=c,this._preMultiplyAlpha=l,this._flipY=u,this._sampler=void 0;const g=defined(n);this._positiveX=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_POSITIVE_X,s,a,o,r,l,u,g),this._negativeX=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_NEGATIVE_X,s,a,o,r,l,u,g),this._positiveY=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_POSITIVE_Y,s,a,o,r,l,u,g),this._negativeY=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_NEGATIVE_Y,s,a,o,r,l,u,g),this._positiveZ=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_POSITIVE_Z,s,a,o,r,l,u,g),this._negativeZ=new CubeMapFace(t,f,p,h.TEXTURE_CUBE_MAP_NEGATIVE_Z,s,a,o,r,l,u,g),this.sampler=defined(e.sampler)?e.sampler:new Sampler}function Texture(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context;let n=e.width,i=e.height;const r=e.source;defined(r)&&(defined(n)||(n=defaultValue(r.videoWidth,r.width)),defined(i)||(i=defaultValue(r.videoHeight,r.height)));const o=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),a=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=PixelFormat$1.toInternalFormat(o,a,t),c=PixelFormat$1.isCompressedFormat(s),l=e.preMultiplyAlpha||o===PixelFormat$1.RGB||o===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=defaultValue(e.skipColorSpaceConversion,!1);let h=!0;const p=t._gl,f=p.TEXTURE_2D,m=p.createTexture();p.activeTexture(p.TEXTURE0),p.bindTexture(f,m);let g,_=4;if(defined(r)&&defined(r.arrayBufferView)&&!c&&(_=PixelFormat$1.alignmentInBytes(o,a,n)),p.pixelStorei(p.UNPACK_ALIGNMENT,_),d?p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.NONE):p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.BROWSER_DEFAULT_WEBGL),defined(r))if(defined(r.arrayBufferView)){p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1);let e,l,d,h=r.arrayBufferView;if(c){if(p.compressedTexImage2D(f,0,s,n,i,0,h),defined(r.mipLevels))for(l=n,d=i,e=0;e<r.mipLevels.length;++e)l=0|Math.floor(l/2),l<1&&(l=1),d=0|Math.floor(d/2),d<1&&(d=1),p.compressedTexImage2D(f,e+1,s,l,d,0,r.mipLevels[e])}else if(u&&(h=PixelFormat$1.flipY(h,o,a,n,i)),p.texImage2D(f,0,s,n,i,0,o,PixelDatatype$1.toWebGLConstant(a,t),h),defined(r.mipLevels))for(l=n,d=i,e=0;e<r.mipLevels.length;++e)l=0|Math.floor(l/2),l<1&&(l=1),d=0|Math.floor(d/2),d<1&&(d=1),p.texImage2D(f,e+1,s,l,d,0,o,PixelDatatype$1.toWebGLConstant(a,t),r.mipLevels[e])}else defined(r.framebuffer)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1),r.framebuffer!==t.defaultFramebuffer&&r.framebuffer._bind(),p.copyTexImage2D(f,0,s,r.xOffset,r.yOffset,n,i,0),r.framebuffer!==t.defaultFramebuffer&&r.framebuffer._unBind()):(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,l),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,u),p.texImage2D(f,0,s,o,PixelDatatype$1.toWebGLConstant(a,t),r));else p.texImage2D(f,0,s,n,i,0,o,PixelDatatype$1.toWebGLConstant(a,t),null),h=!1;p.bindTexture(f,null),g=c?PixelFormat$1.compressedTextureSizeInBytes(o,n,i):PixelFormat$1.textureSizeInBytes(o,a,n,i),this._id=createGuid(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=f,this._texture=m,this._internalFormat=s,this._pixelFormat=o,this._pixelDatatype=a,this._width=n,this._height=i,this._dimensions=new Cartesian2(n,i),this._hasMipmap=!1,this._sizeInBytes=g,this._preMultiplyAlpha=l,this._flipY=u,this._initialized=h,this._sampler=void 0,this.sampler=defined(e.sampler)?e.sampler:new Sampler}Object.defineProperties(Sampler.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),Sampler.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy},Sampler.NEAREST=Object.freeze(new Sampler({wrapS:TextureWrap$1.CLAMP_TO_EDGE,wrapT:TextureWrap$1.CLAMP_TO_EDGE,minificationFilter:TextureMinificationFilter$1.NEAREST,magnificationFilter:TextureMagnificationFilter$1.NEAREST})),Object.defineProperties(CubeMap.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){let t=e.minificationFilter,n=e.magnificationFilter;const i=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,r=this._context,o=this._pixelDatatype;(o===PixelDatatype$1.FLOAT&&!r.textureFloatLinear||o===PixelDatatype$1.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(t=i?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,n=TextureMagnificationFilter$1.NEAREST);const a=r._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture),a.texParameteri(s,a.TEXTURE_MIN_FILTER,t),a.texParameteri(s,a.TEXTURE_MAG_FILTER,n),a.texParameteri(s,a.TEXTURE_WRAP_S,e.wrapS),a.texParameteri(s,a.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&a.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),a.bindTexture(s,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),CubeMap.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;const t=this._context._gl,n=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(n,this._texture),t.generateMipmap(n),t.bindTexture(n,null)},CubeMap.prototype.isDestroyed=function(){return!1},CubeMap.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=destroyObject(this._positiveX),this._negativeX=destroyObject(this._negativeX),this._positiveY=destroyObject(this._positiveY),this._negativeY=destroyObject(this._negativeY),this._positiveZ=destroyObject(this._positiveZ),this._negativeZ=destroyObject(this._negativeZ),destroyObject(this)},Texture.create=function(e){return new Texture(e)},Texture.fromFramebuffer=function(e){const t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,n=t._gl,i=defaultValue(e.pixelFormat,PixelFormat$1.RGB),r=defaultValue(e.framebufferXOffset,0),o=defaultValue(e.framebufferYOffset,0),a=defaultValue(e.width,n.drawingBufferWidth),s=defaultValue(e.height,n.drawingBufferHeight),c=e.framebuffer;return new Texture({context:t,width:a,height:s,pixelFormat:i,source:{framebuffer:defined(c)?c:t.defaultFramebuffer,xOffset:r,yOffset:o,width:a,height:s}})},Object.defineProperties(Texture.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){let t=e.minificationFilter,n=e.magnificationFilter;const i=this._context,r=this._pixelFormat,o=this._pixelDatatype,a=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR;(o===PixelDatatype$1.FLOAT&&!i.textureFloatLinear||o===PixelDatatype$1.HALF_FLOAT&&!i.textureHalfFloatLinear)&&(t=a?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,n=TextureMagnificationFilter$1.NEAREST),i.webgl2&&PixelFormat$1.isDepthFormat(r)&&(t=TextureMinificationFilter$1.NEAREST,n=TextureMagnificationFilter$1.NEAREST);const s=i._gl,c=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(c,this._texture),s.texParameteri(c,s.TEXTURE_MIN_FILTER,t),s.texParameteri(c,s.TEXTURE_MAG_FILTER,n),s.texParameteri(c,s.TEXTURE_WRAP_S,e.wrapS),s.texParameteri(c,s.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&s.texParameteri(c,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),s.bindTexture(c,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}}),Texture.prototype.copyFrom=function(e){const t=defaultValue(e.xOffset,0),n=defaultValue(e.yOffset,0),i=e.source,r=this._context,o=r._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture);const s=i.width,c=i.height;let l=i.arrayBufferView;const u=this._width,d=this._height,h=this._internalFormat,p=this._pixelFormat,f=this._pixelDatatype,m=this._preMultiplyAlpha,g=this._flipY,_=defaultValue(e.skipColorSpaceConversion,!1);let y=4;defined(l)&&(y=PixelFormat$1.alignmentInBytes(p,f,s)),o.pixelStorei(o.UNPACK_ALIGNMENT,y),_?o.pixelStorei(o.UNPACK_COLORSPACE_CONVERSION_WEBGL,o.NONE):o.pixelStorei(o.UNPACK_COLORSPACE_CONVERSION_WEBGL,o.BROWSER_DEFAULT_WEBGL);let C=!1;if(!this._initialized){if(0===t&&0===n&&s===u&&c===d)defined(l)?(o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,!1),g&&(l=PixelFormat$1.flipY(l,p,f,u,d)),o.texImage2D(a,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,r),l)):(o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,g),o.texImage2D(a,0,h,p,PixelDatatype$1.toWebGLConstant(f,r),i)),C=!0;else{o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,!1);const e=PixelFormat$1.createTypedArray(p,f,u,d);o.texImage2D(a,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,r),e)}this._initialized=!0}C||(defined(l)?(o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,!1),g&&(l=PixelFormat$1.flipY(l,p,f,s,c)),o.texSubImage2D(a,0,t,n,s,c,p,PixelDatatype$1.toWebGLConstant(f,r),l)):(o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,g),o.texSubImage2D(a,0,t,n,p,PixelDatatype$1.toWebGLConstant(f,r),i))),o.bindTexture(a,null)},Texture.prototype.copyFromFramebuffer=function(e,t,n,i,r,o){e=defaultValue(e,0),t=defaultValue(t,0),n=defaultValue(n,0),i=defaultValue(i,0),r=defaultValue(r,this._width),o=defaultValue(o,this._height);const a=this._context._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture),a.copyTexSubImage2D(s,0,e,t,n,i,r,o),a.bindTexture(s,null),this._initialized=!0},Texture.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;const t=this._context._gl,n=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(n,this._texture),t.generateMipmap(n),t.bindTexture(n,null)},Texture.prototype.isDestroyed=function(){return!1},Texture.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),destroyObject(this)};var AspectRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",BumpMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n",CheckerboardMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",DotMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationBandMaterial="uniform sampler2D heights;\nuniform sampler2D colors;\nfloat getHeight(int idx, float invTexSize)\n{\nvec2 uv = vec2((float(idx) + 0.5) * invTexSize, 0.5);\n#ifdef OES_texture_float\nreturn texture2D(heights, uv).x;\n#else\nreturn czm_unpackFloat(texture2D(heights, uv));\n#endif\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat height = materialInput.height;\nfloat invTexSize = 1.0 / float(heightsDimensions.x);\nfloat minHeight = getHeight(0, invTexSize);\nfloat maxHeight = getHeight(heightsDimensions.x - 1, invTexSize);\nif (height < minHeight || height > maxHeight) {\nmaterial.diffuse = vec3(0.0);\nmaterial.alpha = 0.0;\nreturn material;\n}\nint idxBelow = 0;\nint idxAbove = heightsDimensions.x;\nfloat heightBelow = minHeight;\nfloat heightAbove = maxHeight;\nconst int maxIterations = 16;\nfor (int i = 0; i < maxIterations; i++) {\nif (idxBelow >= idxAbove - 1) {\nbreak;\n}\nint idxMid = (idxBelow + idxAbove) / 2;\nfloat heightTex = getHeight(idxMid, invTexSize);\nif (height > heightTex) {\nidxBelow = idxMid;\nheightBelow = heightTex;\n} else {\nidxAbove = idxMid;\nheightAbove = heightTex;\n}\n}\nfloat lerper = heightBelow == heightAbove ? 1.0 : (height - heightBelow) / (heightAbove - heightBelow);\nvec2 colorUv = vec2(invTexSize * (float(idxBelow) + 0.5 + lerper), 0.5);\nvec4 color = texture2D(colors, colorUv);\nif (color.a > 0.0)\n{\ncolor.rgb /= color.a;\n}\ncolor.rgb = czm_gammaCorrect(color.rgb);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationContourMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float spacing;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat distanceToContour = mod(materialInput.height, spacing);\n#ifdef GL_OES_standard_derivatives\nfloat dxc = abs(dFdx(materialInput.height));\nfloat dyc = abs(dFdy(materialInput.height));\nfloat dF = max(dxc, dyc) * czm_pixelRatio * width;\nfloat alpha = (distanceToContour < dF) ? 1.0 : 0.0;\n#else\nfloat alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;\n#endif\nvec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha * color.a));\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",ElevationRampMaterial="uniform sampler2D image;\nuniform float minimumHeight;\nuniform float maximumHeight;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);\nvec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",FadeMaterial="uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\ncolor = czm_gammaCorrect(color);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",GridMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec4 halfColor;\nhalfColor.rgb = color.rgb * 0.5;\nhalfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nhalfColor = czm_gammaCorrect(halfColor);\nmaterial.diffuse = halfColor.rgb;\nmaterial.emission = halfColor.rgb;\nmaterial.alpha = halfColor.a;\nreturn material;\n}\n",NormalMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n",PolylineArrowMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\n#ifdef GL_OES_standard_derivatives\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;\n#else\nfloat base = 0.975;\n#endif\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",PolylineDashMaterial="uniform vec4 color;\nuniform vec4 gapColor;\nuniform float dashLength;\nuniform float dashPattern;\nvarying float v_polylineAngle;\nconst float maskLength = 16.0;\nmat2 rotate(float rad) {\nfloat c = cos(rad);\nfloat s = sin(rad);\nreturn mat2(\nc, s,\n-s, c\n);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;\nfloat dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));\nfloat maskIndex = floor(dashPosition * maskLength);\nfloat maskTest = floor(dashPattern / pow(2.0, maskIndex));\nvec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;\nif (fragColor.a < 0.005) {\ndiscard;\n}\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineGlowMaterial="uniform vec4 color;\nuniform float glowPower;\nuniform float taperPower;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nif (taperPower <= 0.99999) {\nglow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));\n}\nvec4 fragColor;\nfragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nfragColor.a = clamp(0.0, 1.0, glow) * color.a;\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineOutlineMaterial="uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",RimLightingMaterial="uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nvec4 outColor = czm_gammaCorrect(color);\nvec4 outRimColor = czm_gammaCorrect(rimColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.emission = outRimColor.rgb * s;\nmaterial.alpha = mix(outColor.a, outRimColor.a, s);\nreturn material;\n}\n",SlopeRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",StripeMaterial="uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",WaterMaterial="uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = mix(blendColor.a, baseWaterColor.a, specularMapValue) * specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.diffuse = material.diffuse;\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n";function Material$4(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._minificationFilter=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),this._magnificationFilter=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,initializeMaterial(e,this),Object.defineProperties(this,{type:{value:this.type,writable:!1}}),defined(Material$4._uniformList[this.type])||(Material$4._uniformList[this.type]=Object.keys(this._uniforms))}function initializeMaterial(e,t){let n;e=defaultValue(e,defaultValue.EMPTY_OBJECT),t._strict=defaultValue(e.strict,!1),t._count=defaultValue(e.count,0),t._template=clone$1(defaultValue(e.fabric,defaultValue.EMPTY_OBJECT)),t._template.uniforms=clone$1(defaultValue(t._template.uniforms,defaultValue.EMPTY_OBJECT)),t._template.materials=clone$1(defaultValue(t._template.materials,defaultValue.EMPTY_OBJECT)),t.type=defined(t._template.type)?t._template.type:createGuid(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];const i=Material$4._materialCache.getMaterial(t.type);if(defined(i)){const e=clone$1(i.fabric,!0);t._template=combine$2(t._template,e,!0),n=i.translucent}checkForTemplateErrors(t),defined(i)||Material$4._materialCache.addMaterial(t.type,t),createMethodDefinition(t),createUniforms(t),createSubMaterials(t);const r=0===t._translucentFunctions.length||void 0;if(n=defaultValue(n,r),n=defaultValue(e.translucent,n),defined(n))if("function"==typeof n){const e=function(){return n(t)};t._translucentFunctions.push(e)}else t._translucentFunctions.push(n)}function checkForValidProperties(e,t,n,i){if(defined(e))for(const r in e)if(e.hasOwnProperty(r)){const e=-1!==t.indexOf(r);(i&&!e||!i&&e)&&n(r,t)}}function invalidNameError(e,t){}function duplicateNameError(e,t){}Material$4._uniformList={},Material$4.fromType=function(e,t){const n=new Material$4({fabric:{type:e}});if(defined(t))for(const e in t)t.hasOwnProperty(e)&&(n.uniforms[e]=t[e]);return n},Material$4.prototype.isTranslucent=function(){if(defined(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;let e=!0;const t=this._translucentFunctions,n=t.length;for(let i=0;i<n;++i){const n=t[i];if(e="function"==typeof n?e&&n():e&&n,!e)break}return e},Material$4.prototype.update=function(e){let t,n;this._defaultTexture=e.defaultTexture;const i=this._loadedImages;let r=i.length;for(t=0;t<r;++t){const r=i[t];n=r.id;let o,a=r.image;Array.isArray(a)&&(o=a.slice(1,a.length).map((function(e){return e.bufferView})),a=a[0]);const s=new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter});let c;c=defined(a.internalFormat)?new Texture({context:e,pixelFormat:a.internalFormat,width:a.width,height:a.height,source:{arrayBufferView:a.bufferView,mipLevels:o},sampler:s}):new Texture({context:e,source:a,sampler:s});const l=this._textures[n];defined(l)&&l!==this._defaultTexture&&l.destroy(),this._textures[n]=c;const u=`${n}Dimensions`;if(this.uniforms.hasOwnProperty(u)){const e=this.uniforms[u];e.x=c._width,e.y=c._height}}i.length=0;const o=this._loadedCubeMaps;for(r=o.length,t=0;t<r;++t){const i=o[t];n=i.id;const r=i.images,a=new CubeMap({context:e,source:{positiveX:r[0],negativeX:r[1],positiveY:r[2],negativeY:r[3],positiveZ:r[4],negativeZ:r[5]},sampler:new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter})});this._textures[n]=a}o.length=0;const a=this._updateFunctions;for(r=a.length,t=0;t<r;++t)a[t](this,e);const s=this.materials;for(const t in s)s.hasOwnProperty(t)&&s[t].update(e)},Material$4.prototype.isDestroyed=function(){return!1},Material$4.prototype.destroy=function(){const e=this._textures;for(const t in e)if(e.hasOwnProperty(t)){const n=e[t];n!==this._defaultTexture&&n.destroy()}const t=this.materials;for(const e in t)t.hasOwnProperty(e)&&t[e].destroy();return destroyObject(this)};const templateProperties=["type","materials","uniforms","components","source"],componentProperties=["diffuse","specular","shininess","normal","emission","alpha"];function checkForTemplateErrors(e){const t=e._template,n=t.uniforms,i=t.materials,r=t.components;checkForValidProperties(t,templateProperties,invalidNameError,!0),checkForValidProperties(r,componentProperties,invalidNameError,!0);const o=[];for(const e in i)i.hasOwnProperty(e)&&o.push(e);checkForValidProperties(n,o,duplicateNameError,!1)}function isMaterialFused(e,t){const n=t._template.materials;for(const t in n)if(n.hasOwnProperty(t)&&e.indexOf(t)>-1)return!0;return!1}function createMethodDefinition(e){const t=e._template.components,n=e._template.source;if(defined(n))e.shaderSource+=`${n}\n`;else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",defined(t)){const n=Object.keys(e._template.materials).length>0;for(const i in t)if(t.hasOwnProperty(i))if("diffuse"===i||"emission"===i){const r=n&&isMaterialFused(t[i],e)?t[i]:`czm_gammaCorrect(${t[i]})`;e.shaderSource+=`material.${i} = ${r}; \n`}else e.shaderSource+="alpha"===i?`material.alpha = ${t.alpha}; \n`:`material.${i} = ${t[i]};\n`}e.shaderSource+="return material;\n}\n"}}const matrixMap={mat2:Matrix2,mat3:Matrix3,mat4:Matrix4},ktx2Regex$3=/\.ktx2$/i;function createTexture2DUpdateFunction(e){let t;return function(n,i){const r=n.uniforms,o=r[e],a=t!==o,s=!defined(o)||o===Material$4.DefaultImageId;t=o;let c,l,u=n._textures[e];if(o instanceof HTMLVideoElement){if(o.readyState>=2){if(a&&defined(u)&&(u!==i.defaultTexture&&u.destroy(),u=void 0),!defined(u)||u===i.defaultTexture){const t=new Sampler({minificationFilter:n._minificationFilter,magnificationFilter:n._magnificationFilter});return u=new Texture({context:i,source:o,sampler:t}),void(n._textures[e]=u)}u.copyFrom({source:o})}else defined(u)||(n._textures[e]=i.defaultTexture);return}if(o instanceof Texture&&o!==u){n._texturePaths[e]=void 0;const t=n._textures[e];return defined(t)&&t!==n._defaultTexture&&t.destroy(),n._textures[e]=o,c=`${e}Dimensions`,void(r.hasOwnProperty(c)&&(l=r[c],l.x=o._width,l.y=o._height))}if(a&&defined(u)&&s&&(u!==n._defaultTexture&&u.destroy(),u=void 0),defined(u)||(n._texturePaths[e]=void 0,u=n._textures[e]=n._defaultTexture,c=`${e}Dimensions`,r.hasOwnProperty(c)&&(l=r[c],l.x=u._width,l.y=u._height)),s)return;const d=o instanceof Resource;if(!defined(n._texturePaths[e])||d&&o.url!==n._texturePaths[e].url||!d&&o!==n._texturePaths[e]){if("string"==typeof o||d){const t=d?o:Resource.createIfNeeded(o);let i;i=ktx2Regex$3.test(t.url)?loadKTX2(t.url):t.fetchImage(),i.then((function(t){n._loadedImages.push({id:e,image:t})})).otherwise((function(){defined(u)&&u!==n._defaultTexture&&u.destroy(),n._textures[e]=n._defaultTexture}))}else(o instanceof HTMLCanvasElement||o instanceof HTMLImageElement)&&n._loadedImages.push({id:e,image:o});n._texturePaths[e]=o}}}function createCubeMapUpdateFunction(e){return function(t,n){const i=t.uniforms[e];if(i instanceof CubeMap){const n=t._textures[e];return n!==t._defaultTexture&&n.destroy(),t._texturePaths[e]=void 0,void(t._textures[e]=i)}if(defined(t._textures[e])||(t._texturePaths[e]=void 0,t._textures[e]=n.defaultCubeMap),i===Material$4.DefaultCubeMapId)return;const r=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ;if(r!==t._texturePaths[e]){const n=[Resource.createIfNeeded(i.positiveX).fetchImage(),Resource.createIfNeeded(i.negativeX).fetchImage(),Resource.createIfNeeded(i.positiveY).fetchImage(),Resource.createIfNeeded(i.negativeY).fetchImage(),Resource.createIfNeeded(i.positiveZ).fetchImage(),Resource.createIfNeeded(i.negativeZ).fetchImage()];when.all(n).then((function(n){t._loadedCubeMaps.push({id:e,images:n})})),t._texturePaths[e]=r}}}function createUniforms(e){const t=e._template.uniforms;for(const n in t)t.hasOwnProperty(n)&&createUniform$1(e,n)}function createUniform$1(e,t){e._strict;const n=e._template.uniforms,i=n[t],r=getUniformType(i);if("channels"===r)replaceToken(e,t,i,!1);else{if("sampler2D"===r){const i=`${t}Dimensions`;getNumberOfTokens(e,i)>0&&(n[i]={type:"ivec3",x:1,y:1},createUniform$1(e,i))}if(!new RegExp(`uniform\\s+${r}\\s+${t}\\s*;`).test(e.shaderSource)){const n=`uniform ${r} ${t};`;e.shaderSource=n+e.shaderSource}const o=`${t}_${e._count++}`;if(replaceToken(e,t,o),e.uniforms[t]=i,"sampler2D"===r)e._uniforms[o]=function(){return e._textures[t]},e._updateFunctions.push(createTexture2DUpdateFunction(t));else if("samplerCube"===r)e._uniforms[o]=function(){return e._textures[t]},e._updateFunctions.push(createCubeMapUpdateFunction(t));else if(-1!==r.indexOf("mat")){const n=new matrixMap[r];e._uniforms[o]=function(){return matrixMap[r].fromColumnMajorArray(e.uniforms[t],n)}}else e._uniforms[o]=function(){return e.uniforms[t]}}}function getUniformType(e){let t=e.type;if(!defined(t)){const n=typeof e;if("number"===n)t="float";else if("boolean"===n)t="bool";else if("string"===n||e instanceof Resource||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===Material$4.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===n)if(Array.isArray(e))4!==e.length&&9!==e.length&&16!==e.length||(t=`mat${Math.sqrt(e.length)}`);else{let n=0;for(const t in e)e.hasOwnProperty(t)&&(n+=1);n>=2&&n<=4?t=`vec${n}`:6===n&&(t="samplerCube")}}return t}function createSubMaterials(e){const t=e._strict,n=e._template.materials;for(const i in n)if(n.hasOwnProperty(i)){const r=new Material$4({strict:t,fabric:n[i],count:e._count});e._count=r._count,e._uniforms=combine$2(e._uniforms,r._uniforms,!0),e.materials[i]=r,e._translucentFunctions=e._translucentFunctions.concat(r._translucentFunctions);const o="czm_getMaterial",a=`${o}_${e._count++}`;replaceToken(r,o,a),e.shaderSource=r.shaderSource+e.shaderSource;replaceToken(e,i,`${a}(materialInput)`)}}function replaceToken(e,t,n,i){i=defaultValue(i,!0);let r=0;const o=new RegExp(`([\\w${i?".":""}])?`+t+"([\\w])?","g");return e.shaderSource=e.shaderSource.replace(o,(function(e,t,i){return t||i?e:(r+=1,n)})),r}function getNumberOfTokens(e,t,n){return replaceToken(e,t,t,n)}function MaterialAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.translucent,!0),n=defaultValue(e.closed,!1),i=defaultValue(e.materialSupport,MaterialAppearance.MaterialSupport.TEXTURED);this.material=defined(e.material)?e.material:Material$4.fromType(Material$4.ColorType),this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,i.vertexShaderSource),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,i.fragmentShaderSource),this._renderState=Appearance.getDefaultRenderState(t,n,e.renderState),this._closed=n,this._materialSupport=i,this._vertexFormat=i.vertexFormat,this._flat=defaultValue(e.flat,!1),this._faceForward=defaultValue(e.faceForward,!n)}Material$4._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},Material$4.DefaultImageId="czm_defaultImage",Material$4.DefaultCubeMapId="czm_defaultCubeMap",Material$4.ColorType="Color",Material$4._materialCache.addMaterial(Material$4.ColorType,{fabric:{type:Material$4.ColorType,uniforms:{color:new Color(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$4.ImageType="Image",Material$4._materialCache.addMaterial(Material$4.ImageType,{fabric:{type:Material$4.ImageType,uniforms:{image:Material$4.DefaultImageId,repeat:new Cartesian2(1,1),color:new Color(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$4.DiffuseMapType="DiffuseMap",Material$4._materialCache.addMaterial(Material$4.DiffuseMapType,{fabric:{type:Material$4.DiffuseMapType,uniforms:{image:Material$4.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$4.AlphaMapType="AlphaMap",Material$4._materialCache.addMaterial(Material$4.AlphaMapType,{fabric:{type:Material$4.AlphaMapType,uniforms:{image:Material$4.DefaultImageId,channel:"a",repeat:new Cartesian2(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),Material$4.SpecularMapType="SpecularMap",Material$4._materialCache.addMaterial(Material$4.SpecularMapType,{fabric:{type:Material$4.SpecularMapType,uniforms:{image:Material$4.DefaultImageId,channel:"r",repeat:new Cartesian2(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),Material$4.EmissionMapType="EmissionMap",Material$4._materialCache.addMaterial(Material$4.EmissionMapType,{fabric:{type:Material$4.EmissionMapType,uniforms:{image:Material$4.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$4.BumpMapType="BumpMap",Material$4._materialCache.addMaterial(Material$4.BumpMapType,{fabric:{type:Material$4.BumpMapType,uniforms:{image:Material$4.DefaultImageId,channel:"r",strength:.8,repeat:new Cartesian2(1,1)},source:BumpMapMaterial},translucent:!1}),Material$4.NormalMapType="NormalMap",Material$4._materialCache.addMaterial(Material$4.NormalMapType,{fabric:{type:Material$4.NormalMapType,uniforms:{image:Material$4.DefaultImageId,channels:"rgb",strength:.8,repeat:new Cartesian2(1,1)},source:NormalMapMaterial},translucent:!1}),Material$4.GridType="Grid",Material$4._materialCache.addMaterial(Material$4.GridType,{fabric:{type:Material$4.GridType,uniforms:{color:new Color(0,1,0,1),cellAlpha:.1,lineCount:new Cartesian2(8,8),lineThickness:new Cartesian2(1,1),lineOffset:new Cartesian2(0,0)},source:GridMaterial},translucent:function(e){const t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),Material$4.StripeType="Stripe",Material$4._materialCache.addMaterial(Material$4.StripeType,{fabric:{type:Material$4.StripeType,uniforms:{horizontal:!0,evenColor:new Color(1,1,1,.5),oddColor:new Color(0,0,1,.5),offset:0,repeat:5},source:StripeMaterial},translucent:function(e){const t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<1}}),Material$4.CheckerboardType="Checkerboard",Material$4._materialCache.addMaterial(Material$4.CheckerboardType,{fabric:{type:Material$4.CheckerboardType,uniforms:{lightColor:new Color(1,1,1,.5),darkColor:new Color(0,0,0,.5),repeat:new Cartesian2(5,5)},source:CheckerboardMaterial},translucent:function(e){const t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material$4.DotType="Dot",Material$4._materialCache.addMaterial(Material$4.DotType,{fabric:{type:Material$4.DotType,uniforms:{lightColor:new Color(1,1,0,.75),darkColor:new Color(0,1,1,.75),repeat:new Cartesian2(5,5)},source:DotMaterial},translucent:function(e){const t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material$4.WaterType="Water",Material$4._materialCache.addMaterial(Material$4.WaterType,{fabric:{type:Material$4.WaterType,uniforms:{baseWaterColor:new Color(.2,.3,.6,1),blendColor:new Color(0,1,.699,1),specularMap:Material$4.DefaultImageId,normalMap:Material$4.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:WaterMaterial},translucent:function(e){const t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<1}}),Material$4.RimLightingType="RimLighting",Material$4._materialCache.addMaterial(Material$4.RimLightingType,{fabric:{type:Material$4.RimLightingType,uniforms:{color:new Color(1,0,0,.7),rimColor:new Color(1,1,1,.4),width:.3},source:RimLightingMaterial},translucent:function(e){const t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<1}}),Material$4.FadeType="Fade",Material$4._materialCache.addMaterial(Material$4.FadeType,{fabric:{type:Material$4.FadeType,uniforms:{fadeInColor:new Color(1,0,0,1),fadeOutColor:new Color(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new Cartesian2(.5,.5)},source:FadeMaterial},translucent:function(e){const t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<1}}),Material$4.PolylineArrowType="PolylineArrow",Material$4._materialCache.addMaterial(Material$4.PolylineArrowType,{fabric:{type:Material$4.PolylineArrowType,uniforms:{color:new Color(1,1,1,1)},source:PolylineArrowMaterial},translucent:!0}),Material$4.PolylineDashType="PolylineDash",Material$4._materialCache.addMaterial(Material$4.PolylineDashType,{fabric:{type:Material$4.PolylineDashType,uniforms:{color:new Color(1,0,1,1),gapColor:new Color(0,0,0,0),dashLength:16,dashPattern:255},source:PolylineDashMaterial},translucent:!0}),Material$4.PolylineGlowType="PolylineGlow",Material$4._materialCache.addMaterial(Material$4.PolylineGlowType,{fabric:{type:Material$4.PolylineGlowType,uniforms:{color:new Color(0,.5,1,1),glowPower:.25,taperPower:1},source:PolylineGlowMaterial},translucent:!0}),Material$4.PolylineOutlineType="PolylineOutline",Material$4._materialCache.addMaterial(Material$4.PolylineOutlineType,{fabric:{type:Material$4.PolylineOutlineType,uniforms:{color:new Color(1,1,1,1),outlineColor:new Color(1,0,0,1),outlineWidth:1},source:PolylineOutlineMaterial},translucent:function(e){const t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),Material$4.ElevationContourType="ElevationContour",Material$4._materialCache.addMaterial(Material$4.ElevationContourType,{fabric:{type:Material$4.ElevationContourType,uniforms:{spacing:100,color:new Color(1,0,0,1),width:1},source:ElevationContourMaterial},translucent:!1}),Material$4.ElevationRampType="ElevationRamp",Material$4._materialCache.addMaterial(Material$4.ElevationRampType,{fabric:{type:Material$4.ElevationRampType,uniforms:{image:Material$4.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:ElevationRampMaterial},translucent:!1}),Material$4.SlopeRampMaterialType="SlopeRamp",Material$4._materialCache.addMaterial(Material$4.SlopeRampMaterialType,{fabric:{type:Material$4.SlopeRampMaterialType,uniforms:{image:Material$4.DefaultImageId},source:SlopeRampMaterial},translucent:!1}),Material$4.AspectRampMaterialType="AspectRamp",Material$4._materialCache.addMaterial(Material$4.AspectRampMaterialType,{fabric:{type:Material$4.AspectRampMaterialType,uniforms:{image:Material$4.DefaultImageId},source:AspectRampMaterial},translucent:!1}),Material$4.ElevationBandType="ElevationBand",Material$4._materialCache.addMaterial(Material$4.ElevationBandType,{fabric:{type:Material$4.ElevationBandType,uniforms:{heights:Material$4.DefaultImageId,colors:Material$4.DefaultImageId},source:ElevationBandMaterial},translucent:!0}),Object.defineProperties(MaterialAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),MaterialAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,MaterialAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,MaterialAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,MaterialAppearance.MaterialSupport={BASIC:Object.freeze({vertexFormat:VertexFormat.POSITION_AND_NORMAL,vertexShaderSource:BasicMaterialAppearanceVS,fragmentShaderSource:BasicMaterialAppearanceFS}),TEXTURED:Object.freeze({vertexFormat:VertexFormat.POSITION_NORMAL_AND_ST,vertexShaderSource:TexturedMaterialAppearanceVS,fragmentShaderSource:TexturedMaterialAppearanceFS}),ALL:Object.freeze({vertexFormat:VertexFormat.ALL,vertexShaderSource:AllMaterialAppearanceVS,fragmentShaderSource:AllMaterialAppearanceFS})};var PerInstanceColorAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nvec4 color = czm_gammaCorrect(v_color);\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n}\n",PerInstanceColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",PerInstanceFlatColorAppearanceFS="varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = czm_gammaCorrect(v_color);\n}\n",PerInstanceFlatColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nattribute float batchId;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";function PerInstanceColorAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);const t=defaultValue(e.translucent,!0),n=defaultValue(e.closed,!1),i=defaultValue(e.flat,!1),r=i?PerInstanceFlatColorAppearanceVS:PerInstanceColorAppearanceVS,o=i?PerInstanceFlatColorAppearanceFS:PerInstanceColorAppearanceFS,a=i?PerInstanceColorAppearance.FLAT_VERTEX_FORMAT:PerInstanceColorAppearance.VERTEX_FORMAT;this.material=void 0,this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,r),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,o),this._renderState=Appearance.getDefaultRenderState(t,n,e.renderState),this._closed=n,this._vertexFormat=a,this._flat=i,this._faceForward=defaultValue(e.faceForward,!n)}function ColorMaterialProperty(e){this._definitionChanged=new Event,this._color=void 0,this._colorSubscription=void 0,this.color=e}Object.defineProperties(PerInstanceColorAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),PerInstanceColorAppearance.VERTEX_FORMAT=VertexFormat.POSITION_AND_NORMAL,PerInstanceColorAppearance.FLAT_VERTEX_FORMAT=VertexFormat.POSITION_ONLY,PerInstanceColorAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,PerInstanceColorAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,PerInstanceColorAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,Object.defineProperties(ColorMaterialProperty.prototype,{isConstant:{get:function(){return Property.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:createPropertyDescriptor("color")}),ColorMaterialProperty.prototype.getType=function(e){return"Color"},ColorMaterialProperty.prototype.getValue=function(e,t){return defined(t)||(t={}),t.color=Property.getValueOrClonedDefault(this._color,e,Color.WHITE,t.color),t},ColorMaterialProperty.prototype.equals=function(e){return this===e||e instanceof ColorMaterialProperty&&Property.equals(this._color,e._color)};const Flags={CULL:1,OCCLUDE:2,EXECUTE_IN_CLOSEST_FRUSTUM:4,DEBUG_SHOW_BOUNDING_VOLUME:8,CAST_SHADOWS:16,RECEIVE_SHADOWS:32,PICK_ONLY:64,DEPTH_FOR_TRANSLUCENT_CLASSIFICATION:128};function DrawCommand(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._modelMatrix=e.modelMatrix,this._primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=defaultValue(e.offset,0),this._instanceCount=defaultValue(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._owner=e.owner,this._debugOverlappingFrustums=0,this._pickId=e.pickId,this._flags=0,this.cull=defaultValue(e.cull,!0),this.occlude=defaultValue(e.occlude,!0),this.executeInClosestFrustum=defaultValue(e.executeInClosestFrustum,!1),this.debugShowBoundingVolume=defaultValue(e.debugShowBoundingVolume,!1),this.castShadows=defaultValue(e.castShadows,!1),this.receiveShadows=defaultValue(e.receiveShadows,!1),this.pickOnly=defaultValue(e.pickOnly,!1),this.depthForTranslucentClassification=defaultValue(e.depthForTranslucentClassification,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}function hasFlag(e,t){return(e._flags&t)===t}function setFlag(e,t,n){n?e._flags|=t:e._flags&=~t}Object.defineProperties(DrawCommand.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return hasFlag(this,Flags.CULL)},set:function(e){hasFlag(this,Flags.CULL)!==e&&(setFlag(this,Flags.CULL,e),this.dirty=!0)}},occlude:{get:function(){return hasFlag(this,Flags.OCCLUDE)},set:function(e){hasFlag(this,Flags.OCCLUDE)!==e&&(setFlag(this,Flags.OCCLUDE,e),this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return hasFlag(this,Flags.CAST_SHADOWS)},set:function(e){hasFlag(this,Flags.CAST_SHADOWS)!==e&&(setFlag(this,Flags.CAST_SHADOWS,e),this.dirty=!0)}},receiveShadows:{get:function(){return hasFlag(this,Flags.RECEIVE_SHADOWS)},set:function(e){hasFlag(this,Flags.RECEIVE_SHADOWS)!==e&&(setFlag(this,Flags.RECEIVE_SHADOWS,e),this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return hasFlag(this,Flags.EXECUTE_IN_CLOSEST_FRUSTUM)},set:function(e){hasFlag(this,Flags.EXECUTE_IN_CLOSEST_FRUSTUM)!==e&&(setFlag(this,Flags.EXECUTE_IN_CLOSEST_FRUSTUM,e),this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return hasFlag(this,Flags.DEBUG_SHOW_BOUNDING_VOLUME)},set:function(e){hasFlag(this,Flags.DEBUG_SHOW_BOUNDING_VOLUME)!==e&&(setFlag(this,Flags.DEBUG_SHOW_BOUNDING_VOLUME,e),this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return hasFlag(this,F