package com.sd.geelyhmiweb.viewmodels

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.sd.geelyhmiweb.utils.DateUtils
import com.sd.geelyhmiweb.utils.FileIoUtils
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class MainVM @Inject constructor(
//    private var loginRepo: LoginRepo,
    @ApplicationContext var context: Context
) : ViewModel() {


    fun writeLog(str: String){
        viewModelScope.launch {
            var time = DateUtils.getCurrentTime(DateUtils.FORMAT_DATE_TIME_SECOND_MIll)
            FileIoUtils.writeToFile("$time ${str}", "web_log.txt")
        }
    }

}