package com.sd.geelyhmiweb.viewmodels

import android.app.ActivityManager
import android.content.Context
import android.util.Log
import androidx.lifecycle.ViewModel
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject


@HiltViewModel
class LookInfoVM @Inject constructor(
//    private var loginRepo: LoginRepo,
    @ApplicationContext var context: Context
) : ViewModel() {


    private val activityManager = context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
    /**
     * 获取当前应用的内存使用信息
     */
    fun printMemoryInfo(context: Context) {
        val memoryInfo = ActivityManager.MemoryInfo()
        activityManager.getMemoryInfo(memoryInfo)

        // 总内存
        val totalMemory = memoryInfo.totalMem
        // 可用内存
        val availableMemory = memoryInfo.availMem
        // 内存使用率
        val memoryUsage = (1 - availableMemory.toDouble() / totalMemory) * 100
        // 是否低内存运行
        val lowMemory = memoryInfo.lowMemory
        // 低内存阈值
        val threshold = memoryInfo.threshold

        Log.d("MemoryInfo", "总内存: " + formatSize(totalMemory))
        Log.d("MemoryInfo", "可用内存: " + formatSize(availableMemory))
        Log.d("MemoryInfo", "内存使用率: " + String.format("%.2f", memoryUsage) + "%")
//        Log.d("MemoryInfo", "低内存状态: " + lowMemory)
//        Log.d("MemoryInfo", "低内存阈值: " + formatSize(threshold))
    }

    private fun formatSize(size: Long): String {
        if (size < 1024) {
            return size.toString() + " B"
        } else if (size < 1024 * 1024) {
            return String.format("%.2f KB", size / 1024.0)
        } else if (size < 1024 * 1024 * 1024) {
            return String.format("%.2f MB", size / (1024.0 * 1024.0))
        } else {
            return String.format("%.2f GB", size / (1024.0 * 1024.0 * 1024.0))
        }
    }

}