package com.sd.geelyhmiweb.utils

import android.annotation.SuppressLint
import android.content.Context
import android.location.Location
import android.location.LocationListener
import android.location.LocationManager
import android.util.Log


class LocationUtils {
    companion object {
        private var instance: LocationUtils? = null

        fun setLocManager(mContext: Context) {
            if (instance == null) {
                instance = LocationUtils(mContext)
            }
        }

        fun getInstan(): LocationUtils {
            return instance!!
        }
    }



    private lateinit var locationManager: LocationManager
    private var locationProvider: String = ""
    private var location: Location? = null

    //    private lateinit var locationUtils: LocationUtils
//    mContext: Context
    private constructor()
    constructor(mContext: Context) {
        locationManager = mContext.getSystemService(Context.LOCATION_SERVICE) as LocationManager
    }


    @SuppressLint("MissingPermission")
    fun getLocation() {
        //1.获取位置管理器
//        locationManager = mContext.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        //2.获取位置提供器，GPS或是NetWork
        if (getProvider().isNullOrEmpty()) {
            return
        }
        if (location != null) {
            setLocation(location!!)
        }
        // 监视地理位置变化，第二个和第三个参数分别为更新的最短时间minTime和最短距离minDistace
        locationManager.requestLocationUpdates(locationProvider, 1, 0f, locationListener)

    }

    @SuppressLint("MissingPermission")
    fun getLastLocation(): String {
        //1.获取位置管理器
//        locationManager = mContext.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        //2.获取位置提供器，GPS或是NetWork
        if (getProvider().isNullOrEmpty()) {
            return ""
        }
        var locate = locationManager?.getLastKnownLocation(locationProvider)
        if (locate != null) {
            setLocation(locate)
        }
        return locate?.latitude.toString() + " " + locate?.longitude.toString()
    }

    private fun getProvider(): String {
        val providers: List<String> = locationManager.getProviders(true)
        if (providers.contains(LocationManager.NETWORK_PROVIDER)) {
            //如果是网络定位
//            Log.d("TAG", "如果是网络定位")
            locationProvider = LocationManager.NETWORK_PROVIDER
        } else if (providers.contains(LocationManager.GPS_PROVIDER)) {
            //如果是GPS定位
//            Log.d("TAG", "如果是GPS定位")
            locationProvider = LocationManager.GPS_PROVIDER
        } else {
            Log.d("TAG", "没有可用的位置提供器")
            return ""
        }
        return locationProvider
    }

    //获取经纬度
    fun showLocation(mContext: Context): Location? {
        return location
    }

    private fun setLocation(location: Location) {
        this.location = location
        //经度，维度，航向角,高度(此位置在WGS84参考椭球上方的高度，以米为单位)
        val loc = "${location.longitude} ${location.latitude} ${location.bearing} ${location.altitude}"
        onJsLoc?.onJsLoc(loc)
    }

    //定位监听
    private var locationListener = object : LocationListener {
        override fun onLocationChanged(location: Location) {
//            location.getAccuracy()//精确度
//            Log.d("------", "定位改变: $location")
            setLocation(location)
        }
    }

    //JS 定位回调
    var onJsLoc: OnJsLoc? = null

    interface OnJsLoc {
        fun onJsLoc(str: String)
    }


    /***停止定位**/
    fun stopLoc() {
        if (locationManager != null) {
            locationManager.removeUpdates(locationListener)
        }
    }
}