package com.sd.geelyhmiweb.ui

import android.Manifest
import android.content.Intent
import android.os.Build
import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import com.permissionx.guolindev.PermissionX
import com.sd.geelyhmiweb.MainActivity
import com.sd.geelyhmiweb.databinding.ActivityLoginBinding
import com.sd.geelyhmiweb.utils.ToastHelper
import com.sd.geelyhmiweb.viewmodels.LoginVM
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class LoginActivity : AppCompatActivity() {
    private lateinit var binding: ActivityLoginBinding

    private val loginVM: LoginVM by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)
        setLisener()
    }

    private fun login() {
        val userName = binding.etName.text.toString()
        val passWord = binding.etPassword.text.toString()
        loginVM.login(userName, passWord).observe(this) {
            if (it) {
                val intent = Intent(this, MainActivity::class.java)
                intent.putExtra("name", userName)
                startActivity(intent)
            }
        }
    }

    private fun setLisener() {
        binding.btnLogin.setOnClickListener {
            login()
        }
    }





}