package com.sd.geelyhmiweb.ui

import android.Manifest
import android.content.Intent
import android.os.Build
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.amap.api.location.AMapLocationClient
import com.permissionx.guolindev.PermissionX
import com.sd.geelyhmiweb.MainActivity
import com.sd.geelyhmiweb.databinding.ActivityBootBinding

class BootActivity : AppCompatActivity() {

    private lateinit var binding: ActivityBootBinding

    //是否AVP项目- 没有登录页
    private var isAvp = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityBootBinding.inflate(layoutInflater)
//        enableEdgeToEdge()
        setContentView(binding.root)
        AMapLocationClient.updatePrivacyShow(this, true, true)
        AMapLocationClient.updatePrivacyAgree(this, true)
        requestPers()
    }

    private fun jumpMain() {
        if (isAvp) {
            startActivity(Intent(this, MainActivity::class.java))
        } else {
            startActivity(Intent(this, LoginActivity::class.java))
        }
    }

    private fun requestPers() {
        val pers = mutableListOf(
            Manifest.permission.ACCESS_FINE_LOCATION,
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_PHONE_STATE
        )
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            pers.add(Manifest.permission.READ_EXTERNAL_STORAGE)
            pers.add(Manifest.permission.MANAGE_EXTERNAL_STORAGE)
        } else {
            pers.add(Manifest.permission.READ_EXTERNAL_STORAGE)
        }
        PermissionX.init(this)
            .permissions(pers)
//            .onExplainRequestReason { scope, deniedList ->
//                scope.showRequestReasonDialog(
//                    deniedList,
//                    "需要同意以下授权才能正常使用",
//                    "好的",
//                    "取消"
//                )
//            }
//            .onForwardToSettings { scope, deniedList ->
//                scope.showForwardToSettingsDialog(deniedList, "您需要手动在‘设置’中允许必要的权限", "OK", "Cancel")
//            }
            .request { allGranted, grantedList, deniedList ->
//                if (allGranted) {
//                    ToastHelper.showShort(this, "All permissions are granted")
                jumpMain()
//                } else {
////                    ToastHelper.showShort(this, "权限被拒")
////                    binding.root.postDelayed({
////                        finish()
////                    }, 150)
//                }
            }

    }

}

/*
 *MD5: 85:D7:46:90:81:07:55:A5:5E:6B:0C:0D:82:E8:F7:69
SHA1: 4F:71:B6:3B:0B:E6:37:33:9E:55:BF:EA:EA:62:70:8B:CD:77:6F:B2
 *
 */
