package com.sd.geelyhmiweb.net

/**
 * A generic class that holds a value with its loading status.
 * @param <T>
</T> */
data class MyBaseResource<out T>(val data: T, var code: Int, var msg: String)


sealed class MyResult<out T> {

    data class Success<out T>(val data: T) : MyResult<T>()
    data class Error(var eCode: Int, var msg: String) : MyResult<Nothing>()

}
