package com.sd.geelyhmiweb

import android.webkit.JavascriptInterface
import androidx.lifecycle.MutableLiveData
import com.sd.geelyhmiweb.dsbridge.CompletionHandler
import com.sd.geelyhmiweb.utils.LocationUtils
import com.sd.geelyhmiweb.viewmodels.AMapLoc
import com.sd.geelyhmiweb.viewmodels.MainVM
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch


class JsApi {

    var mainVM: MainVM? = null
    var aMapLoc: AMapLoc? = null


    //JS点击开始定位
    var jsStartLoc = MutableSharedFlow<String>()

    /***开始定位 js 调用 Android 获取位置**/
    @JavascriptInterface
    fun synLoc(arg: Any, handler: CompletionHandler<String>) {
//        println("--------开始定位 js 调用 Android 获取位置")
//        LocationUtils.getInstan().getLocation()
        CoroutineScope(Dispatchers.Main).launch {
            jsStartLoc.emit("1")
        }
    }

    @JavascriptInterface
    fun stopLoc(arg: Any?) {
//        LocationUtils.getInstan().stopLoc()
    }

    @JavascriptInterface
    fun writeLog(msg: Object) {
//        println("------------writeLog ${msg}")
        mainVM?.writeLog(msg.toString())
//        FileIoUtils.writeToFile(gson.toJson(perceptionBean), "PerTarget_15_move.txt")
    }


    /*  //同步API
      @JavascriptInterface
      fun testSyn(msg: Object): String {
          return msg.toString() + "［syn call］"
      }

      //异步API
      @JavascriptInterface
      fun testAsyn(msg: Object, handler: CompletionHandler<String?>) {
          handler.complete(msg.toString() + " [ asyn call]")
      }*/


}