package com.cusc.adas.v2x.vo;

import com.cusc.adas.v2x.utils.Order;

import java.util.List;

/**
 * 滤波信息
 * @author huangml
 *
 */
public class FilterInfo {
	@Order(1)
	private int dimension; // 状态量协方差矩阵的维度
	@Order(2)
    private List<Integer> varNIndex; // 状态量所在序号列表
	@Order(3)
    private List<Cov> covs; // 卡尔曼滤波的更新步骤得到的状态量协方差矩阵
	@Order(4)
    private List<Cov> covsPred; // 卡尔曼滤波预测步骤得到的状态量协方差矩阵
	@Order(5)
    private List<Cov> varsPred; // 卡尔曼滤波预测步骤得到的状态量
	public int getDimension() {
		return dimension;
	}
	public void setDimension(int dimension) {
		this.dimension = dimension;
	}
	public List<Integer> getVarNIndex() {
		return varNIndex;
	}
	public void setVarNIndex(List<Integer> varNIndex) {
		this.varNIndex = varNIndex;
	}
	public List<Cov> getCovs() {
		return covs;
	}
	public void setCovs(List<Cov> covs) {
		this.covs = covs;
	}
	public List<Cov> getCovsPred() {
		return covsPred;
	}
	public void setCovsPred(List<Cov> covsPred) {
		this.covsPred = covsPred;
	}
	public List<Cov> getVarsPred() {
		return varsPred;
	}
	public void setVarsPred(List<Cov> varsPred) {
		this.varsPred = varsPred;
	}
    
    
}
