package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;

import java.util.List;

/**
 * 紧急车辆预警
 *
 * @author huangml
 */
public class EmergencyVehicle {
    //事件唯一标识
    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 36)
    private String uuid;
    //事件生成时间 戳
    @Order(2)
    @FieldDef(type = "TIMESTAMP", isArray = false, length = 8)
    private long timestamp;
    //告警类型固定值为 6511，用于匹配 RSI
    @Order(3)
    private int alertType = 6511;
    //告警半径
    @Order(4)
    @OffsetDef(value = 0.1)
    private int alertRadius;
    //路径点数量
    @Order(5)
    private short pointNum;
    //告警路径
    @Order(6)
    @RefNumFlag(value = "pointNum")
    private List<Position> alertPath;
    //车辆类型 0：失效；1：救护车；2：警车；3：消防车；4-10： 预留
    @Order(7)
    private short type;
    //车速
    @Order(8)
    @OffsetDef(value = 0.03636)
    private int velocity;
    //航向角
    @Order(9)
    @OffsetDef(value = 0.0001)
    private long heading;
}
