package com.cusc.adas.v2x.assist.vo;

import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.vo.FilterInfo;
import com.cusc.adas.v2x.vo.TrajectoryInfo;

import java.util.List;

/****感知目标物**/
public class Perceptual {
    //唯一编号
    @Order(1)
    private short[] uuid;
    //目标编号
    @Order(2)
    private int objId;
    //目标类型
    @Order(3)

    private short type;

    //目标状态
    @Order(4)
    private short status;

    //目标长度 单位：cm
    @Order(5)
    @OffsetDef(value = 0.01)
    private int len;

    //目标宽度 单位：cm
    @Order(6)
    @OffsetDef(value = 0.01)
    private int width;

    //目标高度 单位：cm
    @Order(7)
    @OffsetDef(value = 0.01)
    private int height;
    //经度
    @Order(8)
    @OffsetDef(value=0.0000001,minValidLength=10)
    private long longitude;
    //纬度
    @Order(9)
    @OffsetDef(value=0.00000001,minValidLength=10)
    private long latitude;

    //东西向距离 单位：cm
    @Order(10)
    @OffsetDef(value = 0.01)
    private long locEast;
    //南北向距离  单位：cm
    @Order(11)
    @OffsetDef(value = 0.01)
    private long locNorth;
    //位置精度等级
    @Order(12)
    private short posConfidence;
    //高程 单位：dm
    @Order(13)
    @OffsetDef(value = 0.1)
    private long elevation;
    //高程精度
    @Order(14)
    private short elevConfidence;
    //速度 ，单位：0.01 m/s
    @Order(15)
    @OffsetDef(value = 0.036)
    private int speed;
    //速度精度等级
    @Order(16)
    private short speedConfidence;
    //东西向速度 cm/s
    @Order(17)
    @OffsetDef(value = 0.0036)
    private int speedEast;
    //东西向速度精 度等级
    @Order(18)
    private short speedEastConfidence;
    //南北向速度 cm/s，
    @Order(19)
    @OffsetDef(value = 0.0036)
    private int speedNorth;
    //南北向速度精 度等级
    @Order(20)
    private short speedNorthConfidence;

    //航向角
    @Order(21)
    @OffsetDef(value=0.0001,minValidLength=7)
    private long heading;

    //航向精度等级
    @Order(22)
    private short headConfidence;

    //目标纵向加速 度 单位：0.01m/
    @Order(23)
    @OffsetDef(value = 0.036)
    private int accelVert;
    //目标纵向加速 度置精度等级
    @Order(24)
    private short accelVertConfidence;
    //目标跟踪时长 单位：毫秒
    @Order(25)
    private long trackedTimes;
    //目标历史轨迹 数量
    @Order(26)
    private int histLocNum;
    //目标历史轨迹 列表
    @Order(27)
    private List<TrajectoryInfo> histLocs;
    //目标预测轨迹 数量
    @Order(28)
    private int predLocNum;
    //目标预测轨迹 列表
    @Order(29)
    private List<TrajectoryInfo> predLocs;

    //目标所在车道编号
    @Order(30)
    private short laneId;
    //滤波信息的类型
    @Order(31)
    private short filterInfoType;
    //卡尔曼滤波信息
    @Order(32)
    private List<FilterInfo> filterInfo;
    //车牌号字节数
    @Order(33)
    private short plateNoLen;
    //车牌号
    @Order(34)
    private byte[] plateNo;

    //车牌类型
    @Order(35)
    private short plateType;

    //车牌颜色
    @Order(36)
    private short plateColor;

    //车身颜色
    @Order(37)
    private short vehicleColor;

}
