package com.cusc.adas.v2x.vo;

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.NumFlag;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

/**
 * 车辆基础信息
 *
 * @author huangml
 */
public class VehicleInfo {
    //车辆编号
    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 8)
    private String vehicleId;
    //消息编号
    @Order(2)
    @FieldDef(type = "BYTE", isArray = true, length = 8)
    private long messageId;
    //GNSS 时间戳
    @Order(3)
    @FieldDef(type = "TIMESTAMP", isArray = false, length = 8)
    private long timestampGNSS;
    //GNSS 速度 单位：0.01 m/s
    @Order(4)
    @OffsetDef(value = 0.036, type = 2)
    private int velocityGNSS;
    //位置
    @Order(5)
    private Position position;

    //航向角
    /****[0..3600000]，正北方向顺时针旋转至与车辆当前运动方向重合所转 过的角度，单位为 1e-4 ° , 不可缺省，0xFFFFFFFF 表示异常**/
    @Order(6)
    @OffsetDef(value=0.0001,minValidLength=7)
    private long heading;

    /**
     * 档位 枚举类型：[0..50]，0：数据失效；1-20：表示手动档车辆前进档对 应档位，1 表示 1 档，2 表示 2 档，以此类推；21-30：表示手动挡车 辆倒档对应档位，
     * 21 表示 R1 档，22 表示 R2 档，以此类推；31：D 档 （前进档）；32：R 档（倒档）；33：P 档（驻车档）；34：N 档（空 档）；
     * 35：S 档（运动模式）；36：L 档（低速档）；37：H 档；38； HL 档；39-50：预留，不可缺省，0xFF 表示异常
     */
    @Order(7)
    private short tapPos;
    //方向盘转角 单位为 1e-4 °
    @Order(8)
    @OffsetDef(value = 0.0001)
    private long steeringAngle;
    /**[0..20000]，CAN 总线数据中的行驶速度，单位：0.01m/s，0xFFFF 表 示缺省***/
    @Order(9)
    @OffsetDef(value = 0.036, type = 2)
    private int velocity;
    //纵向加速度 单位：0.01m/s
    @Order(10)
    @OffsetDef(value = 0.036, type = 2)
    private int accelerationLon;

    //横向加速度 单位：0.01m/s
    @Order(11)
    @OffsetDef(value = 0.036, type = 2)
    private int accelerationLat;

    //垂向加速度 单位：0.01m/s
    @Order(12)
    @OffsetDef(value = 0.036, type = 2)
    private int accelerationVer;
    //横摆角速度 单位：0.01m/s
    @Order(13)
    @OffsetDef(value = 0.036, type = 2)
    private int yawRate;

    //油门开度 单位：0.1%
    @Order(14)
    private int accelPos;

    //发动机输出转速 单位：r/min
    @Order(15)
    private int engineSpeed;

    //发动机扭矩 单位：0.01Nm
    @Order(16)
    private long engineTorque;

    //制动踏板开关
    @Order(17)
    private short brakeFlag;

    //制动踏板开度 单位：0.1%
    @Order(18)
    private int brakePos;

    //制动主缸压力 单位 0.01MPa
    @Order(19)
    private int brakePressure;

    //油耗  单位 0.01L/100km
    @Order(20)
    private int fuelConsumption;

    //车辆驾驶模式
    @Order(21)
    private short driveMode;

    //车辆当前驾驶任务的终点位置
    @Order(22)
    private Position2D destLocation;

    //途经点数量
    @Order(23)
    @NumFlag
    private short passPointsNum;
    //途经点
    @Order(24)
    @RefNumFlag(value = "passPointsNum")
    private List<Position2D> passPoints;


}
