package com.cusc.adas.v2x.vo;

import com.cusc.adas.v2x.assist.dto.PerceptualInfoDto;
import com.cusc.adas.v2x.assist.dto.TrafficLightDto;
import com.cusc.adas.v2x.assist.vo.PerceptualInfo;
import com.cusc.adas.v2x.assist.vo.TrafficLight;
import com.cusc.adas.v2x.clouddecision.dto.AbnormalVehicleDto;
import com.cusc.adas.v2x.clouddecision.dto.AutoSpeedLimitDto;
import com.cusc.adas.v2x.clouddecision.dto.EmergencyVehicleDto;
import com.cusc.adas.v2x.clouddecision.dto.FawWarnningDto;
import com.cusc.adas.v2x.clouddecision.dto.RSIWarnningDto;
import com.cusc.adas.v2x.clouddecision.dto.RoutePlanDto;
import com.cusc.adas.v2x.clouddecision.dto.TrafficLightInfoDto;
import com.cusc.adas.v2x.clouddecision.vo.AbnormalVehicle;
import com.cusc.adas.v2x.clouddecision.vo.AutoSpeedLimit;
import com.cusc.adas.v2x.clouddecision.vo.EmergencyVehicle;
import com.cusc.adas.v2x.clouddecision.vo.FawWarnning;
import com.cusc.adas.v2x.clouddecision.vo.RSIWarnning;
import com.cusc.adas.v2x.clouddecision.vo.RoutePlan;
import com.cusc.adas.v2x.clouddecision.vo.TrafficLightInfo;

import java.util.HashMap;
import java.util.Map;

public class DynamicsClassMap {
    private static Map<String, Map<Short, Class>> map = new HashMap<>();
    private static Map<String, Map<Short, Class>> mapDto = new HashMap<>();

    static {
        Map<Short, Class> cloundDecisionsubMap = new HashMap<>();

        // 参考 adviceType 列表定义  8.5   云端决策建议信息及返回
        cloundDecisionsubMap.put((short) 1, TrafficLightInfo.class);//信号灯路口车速引导功能指令
        cloundDecisionsubMap.put((short) 5, AutoSpeedLimit.class);//动态车道级限速指令
        cloundDecisionsubMap.put((short) 9, FawWarnning.class);//前向碰撞预警
        cloundDecisionsubMap.put((short) 11, AbnormalVehicle.class);//异常车辆预警
        cloundDecisionsubMap.put((short) 13, EmergencyVehicle.class);//紧急车辆预警
        cloundDecisionsubMap.put((short) 17, RSIWarnning.class);//通用 RSI 预警
        cloundDecisionsubMap.put((short) 19, RoutePlan.class);//路线规划指令,用于局部路径一半红，一半蓝
        map.put("CloudDecision", cloundDecisionsubMap);

        // 8.8   云端辅助功能信息及返回
        Map<Short, Class> assistSubMap = new HashMap<>();
        assistSubMap.put((short) 7, TrafficLight.class);//云端下发信号灯信息数据
        assistSubMap.put((short) 11, PerceptualInfo.class);//云端下发实时感知信息（CLOUD2VEH_ASTFUNC_RSM）
        map.put("assist", assistSubMap);

        //Android Dto   参考 adviceType 列表定义
        Map<Short, Class> cloundDecisionsubMapDto = new HashMap<>();
        cloundDecisionsubMapDto.put((short) 1, TrafficLightInfoDto.class);//信号灯路口车速引导功能指令
        cloundDecisionsubMapDto.put((short) 5, AutoSpeedLimitDto.class);//动态车道级限速指令
        cloundDecisionsubMapDto.put((short) 9, FawWarnningDto.class);//前向碰撞预警
        cloundDecisionsubMapDto.put((short) 11, AbnormalVehicleDto.class);//异常车辆预警
        cloundDecisionsubMapDto.put((short) 13, EmergencyVehicleDto.class);//紧急车辆预警
        cloundDecisionsubMapDto.put((short) 17, RSIWarnningDto.class);//通用 RSI 预警
        cloundDecisionsubMapDto.put((short) 19, RoutePlanDto.class);//路线规划指令,用于局部路径一半红，一半蓝

        mapDto.put("CloudDecision", cloundDecisionsubMapDto);
        Map<Short, Class> assistSubMapDto = new HashMap<>();
        assistSubMapDto.put((short) 7, TrafficLightDto.class);//云端下发信号灯信息数据
        assistSubMapDto.put((short) 11, PerceptualInfoDto.class);//云端下发实时感知信息（CLOUD2VEH_ASTFUNC_RSM）
        mapDto.put("assist", assistSubMapDto);

    }


    public static Class get(String classtype, Short classkey) {
        Map<Short, Class> subMap = map.get(classtype);
        return subMap.get(classkey);
    }

    public static Class getDto(String classtype, Short classkey) {
        Map<Short, Class> subMap = mapDto.get(classtype);
        return subMap.get(classkey);
    }

}
