package com.cusc.adas.v2x.vo;

import java.util.List;

import com.cusc.adas.v2x.utils.Order;

/**
 * 感知物信息
 * @author huangml
 *
 */
public class DetectionInfo {
	//唯一编号
	@Order(1)
	private  short[] uuid;
	//目标编号
	@Order(2)
	private  int objId;
	//目标类型
	@Order(3)
	
	private  short  type;
	
	//目标状态
	@Order(4)
	private  short status;
	
	//目标长度
	@Order(5)
	private  int len;
	
	//目标宽度
	@Order(6)
	private  int width;
	
	//目标高度
	@Order(7)
	private  int height;
	//经度
	@Order(8)
	private  long  longitude;
	//纬度
	@Order(9)
	private  long  latitude;
	
	//东西向距离
	@Order(10)
	private  long locEast;
	//南北向距离
	@Order(11)
	private  long locNorth;
	//位置精度等级
	@Order(12)
	private  short posConfidence;
	//高程
	@Order(13)
	private  long elevation;
	//高程精度
	@Order(14)
	private  short elevConfidence;
	//速度
	@Order(15)
	private  int  speed;
	//速度精度等级
	@Order(16)
	private  short  speedConfidence;
	//东西向速度
	@Order(17)
	private  int speedEast;
	//东西向速度精 度等级
	@Order(18)
	private  short  speedEastConfidence;
	//南北向速度
	@Order(19)
	private  int  speedNorth;
	//南北向速度精 度等级
	@Order(20)
	private  short  speedNorthConfidence;
	
	//航向角
	@Order(21)
	private long heading;
	
	//航向精度等级
	@Order(22)
	private  short headConfidence;
	
	//目标纵向加速 度
	@Order(23)
	private int accelVert ;
	//目标纵向加速 度置精度等级
	@Order(24)
	private  short  accelVertConfidence;
	//目标跟踪时长
	@Order(25)
	private long trackedTimes;
	//目标历史轨迹 数量
	@Order(26)
	private int histLocNum;
	//目标历史轨迹 列表
	@Order(27)
	private List<TrajectoryInfo>  histLocs;
	//目标预测轨迹 数量
	@Order(28)
	private int predLocNum;
	//目标预测轨迹 列表
	@Order(29)
	private List<TrajectoryInfo> predLocs;
	
	//目标所在车道编号
	@Order(30)
	private short laneId;
	//滤波信息的类型
	@Order(31)
	private short filterInfoType;
	//卡尔曼滤波信息
	@Order(32)
	private List<FilterInfo> filterInfo;
	//车牌号字节数
	@Order(33)
	private short plateNoLen;
	//车牌号
	@Order(34)
	private byte[] plateNo;
	
	
	
	
	
	
	
}
