package com.cusc.adas.v2x.utils;

import java.net.URISyntaxException;
import java.util.UUID;

import org.fusesource.hawtbuf.Buffer;
import org.fusesource.mqtt.client.Future;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

import com.alibaba.fastjson.JSONObject;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class MQTTFutureClient {
	
	private final static String CONNECTION_STRING = "tcp://172.29.128.39:32024";// MQTT服务器主机地址

	private final static boolean CLEAN_START = true;

	private final static short KEEP_ALIVE = 30;// 低耗网络，但是又需要及时获取数据，心跳30s

	public final static long RECONNECTION_ATTEMPT_MAX = 6;

	public final static long RECONNECTION_DELAY = 2000;

	public final static int SEND_BUFFER_SIZE = 2 * 1024 * 1024;// 发送最大缓冲为2M

	public String MQTTFutureClientPublic(JSONObject jsBodyParameter) {

		// 定义变量
	
		String jsonStr = "";
	
		// 创建MQTT对象
	
		MQTT mqtt = new MQTT();
	
		try {
	
		String CLIENT_ID = UUID.randomUUID().toString().replace("-", "");// 自动生成的MQTT Client Id
	
		// 设置mqtt broker的ip和端口
	
		mqtt.setHost(CONNECTION_STRING);
	
		// 连接前清空会话信息
	
		mqtt.setCleanSession(CLEAN_START);
	
		// 设置重新连接的次数
	
		mqtt.setReconnectAttemptsMax(RECONNECTION_ATTEMPT_MAX);
	
		// 设置重连的间隔时间
	
		mqtt.setReconnectDelay(RECONNECTION_DELAY);
	
		// 设置心跳时间
	
		mqtt.setKeepAlive(KEEP_ALIVE);
	
		// 设置缓冲的大小
	
		mqtt.setSendBufferSize(SEND_BUFFER_SIZE);
	
		// 设置客户端id、用户名和密码
	
		mqtt.setClientId(CLIENT_ID);
	
		mqtt.setUserName("admin");
	
		mqtt.setPassword("password");
	
		// 获取mqtt的连接对象BlockingConnection
	
		final FutureConnection connection = mqtt.futureConnection();
	
		connection.connect();
	
		Topic[] subscribeTopics = { new Topic("mqtt/face/1376464/Ack", QoS.AT_LEAST_ONCE) };// 订阅主题
	
		connection.subscribe(subscribeTopics);
	
		String publishTopic = "mqtt/face/1376464";// 发布主题
	
		connection.publish(publishTopic, jsBodyParameter.toString().getBytes("UTF-8"), QoS.AT_LEAST_ONCE, false);
	
		Future<Message> futrueMessage = connection.receive();
	
		Message message = futrueMessage.await();
	
		byte[]  bs = message.getPayload();
		Buffer  buffer = message.getPayloadBuffer();
		
		ByteBuf wrappedBuf = Unpooled.wrappedBuffer(bs);
		
		System.out.println(message.getPayloadBuffer());// 打印订阅的消息
	
		String msg = String.valueOf(message.getPayloadBuffer());
	
		jsonStr = msg;
	
		} catch (URISyntaxException e) {
	
		e.printStackTrace();
	
		} catch (Exception e) {
	
		e.printStackTrace();
	
		} finally {
	
		}
	
		return jsonStr;
	
	}
	
	/*

	* service层调用函数，jsBodyParameter为传入的需要发布的参数

	*/

	public static String writeToMqttMessageFuture(JSONObject jsBodyParameter) throws Exception {

		MQTTFutureClient mqttFutureClient = new MQTTFutureClient();
	
		String messageJosn = mqttFutureClient.MQTTFutureClientPublic(jsBodyParameter);
	
		return messageJosn;

	}
	
	public static void main(String[] args) throws Exception {

		JSONObject jsBodyParameter = new JSONObject();// 定义发布参数变量

		jsBodyParameter.put("keyId", "你好！");// 设置参数值

		String response = writeToMqttMessageFuture(jsBodyParameter);

		System.out.println(response);// 打印订阅的消息

	}
	
}
