package com.cusc.adas.v2x.server;

import java.net.InetSocketAddress;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;

public class UdpServer {
	 	private final int port;
	 
	    public UdpServer(int port) {
	        this.port = port;
	    }
	    
	    
//	    public void start() throws Exception {
//	        EventLoopGroup group = new NioEventLoopGroup();
//
//	        try {
//	            Bootstrap b = new Bootstrap();
//	            b.group(group)
//	                    .channel(NioDatagramChannel.class)
//	                    .handler(new ChannelInitializer<DatagramChannel>() {
//	                        @Override
//	                        protected void initChannel(DatagramChannel ch) throws Exception {
//	                            ch.pipeline().addLast(null);
//	                        }
//	                    });
//
//	            ChannelFuture f = b.bind(port).sync();
//	            System.out.println("Server started on port " + port);
//	            f.channel().closeFuture().sync();
//	        } finally {
//	            group.shutdownGracefully();
//	        }
//	    }
	
	    
	    public void run() throws Exception {
	        EventLoopGroup group = new NioEventLoopGroup();
	        try {
	            Bootstrap b = new Bootstrap();
	            b.group(group)
	             .channel(NioDatagramChannel.class)
	             .option(ChannelOption.SO_BROADCAST, true)
	            
	             .localAddress(new InetSocketAddress(port))
	             .handler(new ChannelInitializer<DatagramChannel>() {
//	                 @Override
//	                 protected void initChannel(DatagramChannel ch) {
//	                     ch.pipeline().addLast(new SimpleChannelInboundHandler<DatagramPacket>() {
//	                         @Override
//	                         protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
//	                             byte[] data = new byte[msg.readableBytes()];
//	                             msg.readBytes(data);
//	                             String received = new String(data).trim();
//	                             System.out.println("Server received: " + received);
//	                             ByteBuf response = Unpooled.copiedBuffer("Echo: " + received, CharsetUtil.UTF_8);
//	                             ctx.writeAndFlush(response); // Echo the received message back to the client
//	                         }
//	                     });
//	                 }
	            	 @Override
	                 protected void initChannel(DatagramChannel ch) {
	                     ch.pipeline().addLast(new UdpServerHandler());
	                 }
	            	 
	            	 
	             });
	 
	            ChannelFuture f = b .bind().sync(); // Bind and start to accept incoming connections.
	            System.out.println("UDP server started on port " + port);
	            f.channel().closeFuture().await(); // Wait until the server socket is closed.
	        } finally {
	            group.shutdownGracefully(); // Shut down all event loops to terminate all threads and release all resources.
	        }
	    }
	    public static void main(String[] args) throws Exception {
	        new UdpServer(8082).run(); // Start the server on port 8080
	    }
}
