package com.cusc.adas.v2x.dto;

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.NumFlag;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
/**
 * 车辆基础信息
 * @author huangml
 *
 */
public class VehicleInfoDto {
	//车辆编号
	@Order(1)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private String vehicleId;
	//消息编号
	@Order(2)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private long messageId;
	//GNSS 时间戳
	@Order(3)
	@FieldDef(type="TIMESTAMP",isArray=false,length=8)
	private long timestampGNSS;
	//GNSS 速度
	@Order(4)
	private float  velocityGNSS;
	//位置
	@Order(5)
	private PositionDto  position;
	//航向角
	@Order(6)
	private double heading;

	//档位
	@Order(7)
	private short tapPos ;
	//方向盘转角
	@Order(8)
	private double  steeringAngle;
	//当前车速
	@Order(9)
	private float  velocity;
	//纵向加速度
	@Order(10)
	private float  accelerationLon;

	//横向加速度
	@Order(11)
	private float accelerationLat;

	//垂向加速度
	@Order(12)
	private float accelerationVer;
	//横摆角速度
	@Order(13)
	private float yawRate;

	//油门开度
	@Order(14)
	private float accelPos;

	//发动机输出转速
	@Order(15)
	private float  engineSpeed;

	//发动机扭矩
	@Order(16)
	private double  engineTorque;

	//制动踏板开关
	@Order(17)
	private short brakeFlag;

	//制动踏板开度
	@Order(18)
	private float brakePos;

	//制动主缸压力
	@Order(19)
	private float brakePressure;
	
	//油耗
	@Order(20)
	private float fuelConsumption;
	
	//车辆驾驶模式
	@Order(21)
	private short driveMode;
	
	//目的地位置
	@Order(22)
	private Position2DDto destLocation;
	
	//途经点数量
	@Order(23)
	@NumFlag
	private short passPointsNum;
	//途经点
	@Order(24)
	@RefNumFlag(value="passPointsNum")
	private List<Position2DDto> passPoints;

	public String getVehicleId() {
		return vehicleId;
	}

	public short getTapPos() {
		return tapPos;
	}

	public float getVelocity() {
		return velocity;
	}

	public short getDriveMode() {
		return driveMode;
	}

	public double getHeading() {
		return heading;
	}

	public PositionDto getPosition() {
		return position;
	}
}
