package com.cusc.adas.v2x.clouddecision.dto;

import java.util.List;

/**
 * 前向碰撞预警
 */
public class FawWarnningDto {
    //事件唯一标识
    private String uuid;
    //事件生成时间 戳
    private long timestamp;

    //告警类型 固定值为 6518
    private int alertType = 6518;
    //告警半径
    private float alertRadius;

    //路径点数量
    private short pointNum;

    //告警路径
    private List<PositionDto> alertPath;

    //碰撞预警目标 类型 0：行人；1：非机动车；2：机动车；3：其他； 0xFF 表示缺省，缺省则告警功能失效
    private short objType;

    //碰撞告警类型
    private short fcwLevel;

    //碰撞距离 转成米
    private float fcwDistance;

    //碰撞预警目标 所在车道
    private short fcwLaneId;

}
