package com.cusc.adas.v2x.assist.vo;

import com.cusc.adas.v2x.utils.DependencyDef;
import com.cusc.adas.v2x.utils.DynamicsClassDef;
import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.Order;

/****8.8   云端辅助功能信息及返回**/
public class AssistMessageBody<T> {
	//车辆编号
	@Order(1)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private String vehicleId;
	
	//消息标识
	@Order(2)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private long seq;
	
	//辅助功能类别
	@Order(3)
	private short astFuncType;
	
	//命令长度
	@Order(4)
	private int dataLen;
	
	//长度为 N 个字节，其中N 为命令长度，数据结构根据功能不同应分别 符合 8.8.6～8.8.11 的要求
	@Order(5)
	@DynamicsClassDef(classtype="assist")
	@DependencyDef(value="astFuncType")
	private T infoData;
	
}
