package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position2D;

import java.util.List;

/****
 * 局部路径点
 * **/
public class PathPath {

    //关联 GNSS 点 数量
    @Order(1)
    private int pointsNum;
    //关联 GNSS 点 位置  具体颜色的集合
    @Order(2)
    @RefNumFlag(value = "pointsNum")
    private List<Position2D> pointsPos;

    //0：常规路段（全局路径）；1：路口内连接路段，0xFF 表示缺 省 2=路面状况颜色(路径里的红色、施工区域红色、人行道红色) 3=绿色（绿波） 4=感知车前的红色 5=拥堵红色
    @Order(3)
    private short pathType;

}
