package com.cusc.adas.v2x.assist.vo;

import java.util.List;

import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

/**
 * 云端下发CLOUD2VEH_ASTFUNC_TLM = 7信号灯数据
 * @author huangml
 *
 */
public class TrafficLight {
	//红绿灯控制方式 1：固定周期；2：手动控制；3：黄闪控制，4-254： 预留
	@Order(1)
	private  short controlMode;
	//区域 ID 信号灯作用位置所在区域唯一编号,与路口 ID 一起确定 唯一路口
	@Order(2)
	private  int regionId;
	
	//路口 ID 信号灯作用位置在该区域内唯一编号,与区域 ID 一起确 定唯一路口
	@Order(3)
	private  int nodeId;
	
	//车辆所在车道 对应信号灯相 位数量
	@Order(4)
	private  short numOfLanePhase;
//	//车辆所在车道 对应信号灯相 位 ID 列表
//	@Order(5)
//	@RefNumFlag(value="numOfLanePhase")
//	private List<Short> lanePhaseIds;
	
	//车辆到前方停 止线距离
	@Order(5)
	@OffsetDef(value = 0.01)
	private  int d2StopLine;
	
	//相位数量
	@Order(6)
	private  short  phaseNumber;
	
	//信号灯相位状 态
	@Order(7)
	@RefNumFlag(value="phaseNumber")
	private List<TrafficLightStatus> phaseState;
	
	
	
}
