package com.cusc.adas.v2x.utils;

import com.cusc.adas.v2x.vo.DynamicsClassMap;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class Parse {

//   private List<Field> fList = new ArrayList<>();

    public static <T> T parse(ByteBuf data, T t) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {

        Field[] fields = t.getClass().getDeclaredFields();
        List<Field> fList = new ArrayList<>();
//        SortedMap<Integer, Field> rstMap = new TreeMap<>();

        for (Field field : fields) {

            if (field.isAnnotationPresent(Order.class)) {

                fList.add(field);
            }
        }
        Collections.sort(fList, new Comparator<Field>() {
            @Override
            public int compare(Field f1, Field f2) {
                return f1.getAnnotation(Order.class).value() - f2.getAnnotation(Order.class).value();
            }
        });

        for (Field field : fList) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Order.class)) {

                String fieldName = field.getName();
                Order order = field.getAnnotation(Order.class);
//                System.out.println("---------fieldName " + fieldName);

                int num = order.value();
                //基础数据类型 且 不是数组
                if (field.getType().isPrimitive() && !field.getType().isArray()) {
                    // data.re
                    // field.set(fList, rstMap);
                    readBuf(t, field, data);
                } else if (field.getType().isArray()) {
                    // 基础数据类型 且 是数组
                    readBuf(t, field, data);
                } else if (List.class.isAssignableFrom(field.getType())) {
                    // 集合类型
                    //读取属性的注解是否引用其他字段的长度
                    if (field.isAnnotationPresent(RefNumFlag.class) && !field.isAnnotationPresent(DynamicsClassDef.class)) {

                        RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                        String refField = refNumFlag.value();
                        Class<?> clazz1 = t.getClass();
                        Field nameField = clazz1.getDeclaredField(refField);
                        Type genericType = field.getGenericType();
                        nameField.setAccessible(true);

                        if (genericType instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType) genericType;
                            Type[] actualTypes = pt.getActualTypeArguments();
                            if (actualTypes != null && actualTypes.length > 0) {
                                actualTypes[0].getClass();
                                long len = 0l;
                                if (nameField.getType() == short.class) {
                                    short val = (short) nameField.get(t);
                                    len = (long) val;
                                } else if (nameField.getType() == int.class) {
                                    int val = (int) nameField.get(t);
                                    len = (long) val;
                                } else if (nameField.getType() == long.class) {
                                    len = (long) nameField.get(t);
                                }
                                //short len= (short) nameField.get(t);
                                if (len > 0) {
                                    List list = new ArrayList<>();
                                    for (int i = 0; i < len; i++) {
                                        String classname = actualTypes[0].getTypeName();
                                        Object obj = null;
                                        if (classname.contains("Short")) {
                                            obj = data.readUnsignedByte();
                                        } else if (classname.contains("Integer")) {
                                            obj = data.readUnsignedShort();
                                        } else if (classname.contains("Long")) {
                                            obj = data.readUnsignedInt();
                                        } else {
                                            Class<?> cls = Class.forName(actualTypes[0].getTypeName());
                                            ;
                                            obj = cls.newInstance();
                                            parse(data, obj);
                                        }


                                        list.add(obj);
                                    }
                                    System.out.println("actualTypes::" + actualTypes[0].getTypeName());
                                    field.set(t, list);
                                }

                            }
                        }
                    } else if (field.isAnnotationPresent(RefNumFlag.class) && field.isAnnotationPresent(DynamicsClassDef.class)) {

                        DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                        String classtype = dynamicsClassDef.classtype();
                        DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                        String fieldname = dependencyDef.value();
                        Field tField2 = t.getClass().getDeclaredField(fieldname);
                        tField2.setAccessible(true);
                        Short value = (Short) tField2.get(t);

                        RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                        String refFieldName = refNumFlag.value();
                        Field tField = t.getClass().getDeclaredField(fieldname);
                        tField.setAccessible(true);
                        Field tField1 = t.getClass().getDeclaredField(refFieldName);
                        tField1.setAccessible(true);
                        Integer len = (Integer) tField1.get(t);
                        if (len > 0) {
                            Class clazz1 = DynamicsClassMap.get(classtype, value);
                            Class<?> cls = Class.forName(clazz1.getName());
                            List<Object> list = new ArrayList<>();
                            for (int i = 0; i < len; i++) {
                                Object obj = cls.newInstance();
                                System.out.println("clazz1 name::" + clazz1.getName());
                                parse(data, obj);
                                list.add(obj);
                            }
                            field.set(t, list);
                        }


                    }

                } else if (field.getType() == String.class) {
                    //类型为字符串
                    readBuf(t, field, data);
                } else {
                    //其他对象类型

                    if (data.readerIndex() == data.maxCapacity()) {
                        return t;
                    }
                    if (field.isAnnotationPresent(DynamicsClassDef.class)) {
                        DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                        String classtype = dynamicsClassDef.classtype();
                        DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                        String fieldname = dependencyDef.value();
                        Field tField2 = t.getClass().getDeclaredField(fieldname);
                        tField2.setAccessible(true);


                        Short key = (Short) tField2.get(t);
                        Class clazz1 = DynamicsClassMap.get(classtype, key);
                        Class<?> cls = Class.forName(clazz1.getName());
                        Object obj = cls.newInstance();
                        parse(data, obj);
                        field.set(t, obj);


                    } else {
                        Class<?> cls = Class.forName(field.getType().getName());
                        Object obj = cls.newInstance();

                        parse(data, obj);
                        field.set(t, obj);
                    }


                }
//                rstMap.put(num, field);
            }
        }
        return t;
    }


    /**
     * @param t     = 要解析的目标对象
     * @param fList 按Order 从小到大排序好的属性
     */
    public static <T> T parse(ByteBuf data, T t, List<Field> fList) {
        if (t == null)
            return null;
        try {
            for (Field field : fList) {
                field.setAccessible(true);
                if (field.isAnnotationPresent(Order.class)) {

                    String fieldName = field.getName();
                    Order order = field.getAnnotation(Order.class);
//                    System.out.println("---------fieldName " + fieldName);

                    int num = order.value();
                    //基础数据类型 且 不是数组
                    if (field.getType().isPrimitive() && !field.getType().isArray()) {
                        // data.re
                        // field.set(fList, rstMap);
                        readBuf(t, field, data);
                    } else if (field.getType().isArray()) {
                        // 基础数据类型 且 是数组
                        readBuf(t, field, data);
                    } else if (List.class.isAssignableFrom(field.getType())) {
                        // 集合类型
                        //读取属性的注解是否引用其他字段的长度
                        if (field.isAnnotationPresent(RefNumFlag.class) && !field.isAnnotationPresent(DynamicsClassDef.class)) {

                            RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                            String refField = refNumFlag.value();
                            Class<?> clazz1 = t.getClass();
                            Field nameField = clazz1.getDeclaredField(refField);
                            Type genericType = field.getGenericType();
                            nameField.setAccessible(true);

                            if (genericType instanceof ParameterizedType) {
                                ParameterizedType pt = (ParameterizedType) genericType;
                                Type[] actualTypes = pt.getActualTypeArguments();
                                if (actualTypes != null && actualTypes.length > 0) {
                                    actualTypes[0].getClass();
                                    long len = 0l;
                                    if (nameField.getType() == short.class) {
                                        short val = (short) nameField.get(t);
                                        len = (long) val;
                                    } else if (nameField.getType() == int.class) {
                                        int val = (int) nameField.get(t);
                                        len = (long) val;
                                    } else if (nameField.getType() == long.class) {
                                        len = (long) nameField.get(t);
                                    }
                                    //short len= (short) nameField.get(t);
                                    if (len > 0) {
                                        List list = new ArrayList<>();
                                        for (int i = 0; i < len; i++) {
                                            String classname = actualTypes[0].getTypeName();
                                            Object obj = null;
                                            if (classname.contains("Short")) {
                                                obj = data.readUnsignedByte();
                                            } else if (classname.contains("Integer")) {
                                                obj = data.readUnsignedShort();
                                            } else if (classname.contains("Long")) {
                                                obj = data.readUnsignedInt();
                                            } else {
                                                Class<?> cls = Class.forName(actualTypes[0].getTypeName());
                                                ;
                                                obj = cls.newInstance();
                                                parse(data, obj);
                                            }


                                            list.add(obj);
                                        }
                                        System.out.println("actualTypes::" + actualTypes[0].getTypeName());
                                        field.set(t, list);
                                    }

                                }
                            }
                        } else if (field.isAnnotationPresent(RefNumFlag.class) && field.isAnnotationPresent(DynamicsClassDef.class)) {

                            DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                            String classtype = dynamicsClassDef.classtype();
                            DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                            String fieldname = dependencyDef.value();
                            Field tField2 = t.getClass().getDeclaredField(fieldname);
                            tField2.setAccessible(true);
                            Short value = (Short) tField2.get(t);

                            RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                            String refFieldName = refNumFlag.value();
                            Field tField = t.getClass().getDeclaredField(fieldname);
                            tField.setAccessible(true);
                            Field tField1 = t.getClass().getDeclaredField(refFieldName);
                            tField1.setAccessible(true);
                            Integer len = (Integer) tField1.get(t);
                            if (len > 0) {
                                Class clazz1 = DynamicsClassMap.get(classtype, value);
                                Class<?> cls = Class.forName(clazz1.getName());
                                List<Object> list = new ArrayList<>();
                                for (int i = 0; i < len; i++) {
                                    Object obj = cls.newInstance();
                                    System.out.println("clazz1 name::" + clazz1.getName());
                                    parse(data, obj);
                                    list.add(obj);
                                }
                                field.set(t, list);
                            }


                        }

                    } else if (field.getType() == String.class) {
                        //类型为字符串
                        readBuf(t, field, data);
                    } else {
                        //其他对象类型

                        if (data.readerIndex() == data.maxCapacity()) {
                            return t;
                        }
                        if (field.isAnnotationPresent(DynamicsClassDef.class)) {
                            DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                            String classtype = dynamicsClassDef.classtype();
                            DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                            String fieldname = dependencyDef.value();
                            Field tField2 = t.getClass().getDeclaredField(fieldname);
                            tField2.setAccessible(true);


                            Short key = (Short) tField2.get(t);
                            Class clazz1 = DynamicsClassMap.get(classtype, key);
                            Class<?> cls = Class.forName(clazz1.getName());
                            Object obj = cls.newInstance();
                            parse(data, obj);
                            field.set(t, obj);


                        } else {
                            Class<?> cls = Class.forName(field.getType().getName());
                            Object obj = cls.newInstance();

                            parse(data, obj);
                            field.set(t, obj);
                        }


                    }
//                rstMap.put(num, field);
                }
            }
            return t;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 读取字节流
     *
     * @param t
     * @param field
     * @param data
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @throws SecurityException
     * @throws NoSuchFieldException
     */
    public static void readBuf(Object t, Field field, ByteBuf data) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (data.readerIndex() == data.maxCapacity())
            return;
        FieldDef fieldDef = null;
        if (field.isAnnotationPresent(FieldDef.class)) {
            fieldDef = field.getAnnotation(FieldDef.class);
        }
        RefNumFlag refNumFlag = null;
        if (field.isAnnotationPresent(RefNumFlag.class)) {
            refNumFlag = field.getAnnotation(RefNumFlag.class);
        }

        Class<?> type = field.getType();

        if (type == String.class && fieldDef != null && fieldDef.type().equals("BYTE")) {
            byte[] by = new byte[fieldDef.length()];
            data.readBytes(by);
            String str = new String(by, StandardCharsets.UTF_8);
            field.set(t, str);
        } else if (type == String.class && refNumFlag != null) {
            Field tField = t.getClass().getDeclaredField(refNumFlag.value());
            tField.setAccessible(true);
            int size = (int) tField.get(t);
            byte[] by = new byte[size];
            data.readBytes(by);
            String str = new String(by, StandardCharsets.UTF_8);
            field.set(t, str);
        } else if (type == short.class) {
            field.set(t, data.readUnsignedByte());
            int a = 0;
        } else if (type == int.class) {
            field.set(t, data.readUnsignedShort());
        } else if (type == long.class && fieldDef == null) {
            field.set(t, data.readUnsignedInt());
        } else if (type == long.class && fieldDef != null && fieldDef.type().equals("TIMESTAMP") && fieldDef.length() == 8) {
            field.set(t, data.readLong());
        } else if (type == long.class && fieldDef != null && fieldDef.type().equals("BYTE")) {
            field.set(t, data.readLong());
        } else if (field.getType().isArray() && refNumFlag != null) {
            Field tField = t.getClass().getDeclaredField(refNumFlag.value());
            tField.setAccessible(true);

            Class<?> type1 = tField.getType();
            byte[] by = null;
            if (type1 == byte.class) {
                Byte obj = (Byte) tField.get(t);
                by = new byte[obj.byteValue()];

            } else if (type1 == short.class) {
                Short obj = (Short) tField.get(t);
                by = new byte[obj.shortValue()];

            } else if (type1 == int.class) {
                Integer obj = (Integer) tField.get(t);
                by = new byte[obj.intValue()];
            }
            data.readBytes(by);
            field.set(t, by);
        }
    }

    public static byte[] longToBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN); // 指定小端模式
        buffer.putLong(value); // 将long值存入buffer
        return buffer.array(); // 获取byte数组
    }

    public static byte[] longToBytes1(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN); // 指定小端模式
        buffer.putLong(value); // 将long值存入buffer
        return buffer.array(); // 获取byte数组
    }

    public static byte[] intToBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN); // 指定小端模式
        buffer.putLong(value); // 将long值存入buffer
        return buffer.array(); // 获取byte数组
    }


    public static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();

        //return null;
//	    ByteBuffer buffer = ByteBuffer.allocate(8);
//	    buffer.order(ByteOrder.LITTLE_ENDIAN); // 指定小端模式
//	    buffer.putLong(value); // 将long值存入buffer
//	    return buffer.array(); // 获取byte数组
    }

    public static String long2Hex(long num, int len) {
        String hex = Long.toHexString(num);
        int padLength = len * 2;
        if (hex.length() >= padLength) {
            return hex.substring(hex.length() - padLength); // 超长时截断
        }
        return String.format("%0" + padLength + "d", 0).replace("0", "0") + hex; // 或直接格式化
    }


    public static void main(String[] args) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {


        String hexString = "F20000000015018cb864640000000000";
        byte[] bytes = HexStringToByteArray.hexStringToByteArray(hexString);
        ByteBuf byteBuf = Unpooled.buffer(16);
        long l = 500000;
        //3600000000
        // 1164916946
        // byte []  bs  = Long.toHexString(l);
        String s = long2Hex(l, 4);
        //longToBytes1(l);
        long i = 250000;
        String hex = Long.toHexString(i);

        int i1 = 1500;
        hex = Integer.toHexString(i1);

        String uuid = UUID.randomUUID().toString();
        byte[] by2 = uuid.getBytes();
        s = byteToHexString(by2);

        String vid = "JL110001";
        byte[] by1 = vid.getBytes();
        s = byteToHexString(by1);

        System.out.println(s);

//		 
//		 
//		List<Byte> byteList = new ArrayList<Byte>();
//		
//		Byte[] bytes = byteList.toArray(new Byte[byteList.size()]);
        //byte[] bs = convoter(bytes);
        //byteBuf.writeBytes(bytes);
        //VehicleMessage  vehicleMessage = parse(byteBuf,new VehicleMessage());
        //System.out.print(vehicleMessage);

    }


    //	public static void convoterBean( Object source , Object target) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, InstantiationException, NoSuchFieldException, SecurityException {
    public static void convoterBean(Object source, Object target) {
        if (source == null)
            return;
        Field tField = null;
        try {
            Field[] fields = source.getClass().getDeclaredFields();
//        List<Field> fList = new ArrayList<>();
            List<Field> fList = Arrays.asList(fields);
//        for (Field field : fields) {
//            if (field.isAnnotationPresent(Order.class)) {
//                fList.add(field);
//            }
//        }
            Collections.sort(fList, new Comparator<Field>() {
                @Override
                public int compare(Field f1, Field f2) {
                    return f1.getAnnotation(Order.class).value() - f2.getAnnotation(Order.class).value();
                }
            });

//            Field[] fields = source.getClass().getDeclaredFields();
            //获取目标对象指定的属性
            //List<Field> fList = new ArrayList<>();
            //SortedMap<Integer,Field> rstMap = new TreeMap<>();
            for (Field field : fList) {
                field.setAccessible(true);
                Object o = field.get(source);
                if (o == null) {
                    continue;
                }
//                System.out.println("---------convoterBean old fieldName " + field.getName());

                OffsetDef offsetDef = null;
                if (field.isAnnotationPresent(OffsetDef.class)) {
                    offsetDef = field.getAnnotation(OffsetDef.class);
                }
                //获取目标对象指定的属性
                tField = target.getClass().getDeclaredField(field.getName());
                tField.setAccessible(true);
                if (field.isAnnotationPresent(Order.class)) {
                    if (field.getType().isPrimitive() && !field.getType().isArray()) {
                        //如果属性添加了自定义注解 offset

                        Class<?> type = field.getType();
                        if (offsetDef != null) {
                            double offset = offsetDef.value();
                            int type1 = offsetDef.type();
                            int minValidLength = offsetDef.minValidLength();

                            //startindex

                            if (type == byte.class) {
                                tField.set(target, o);
                            } else if (type == short.class) {

                                if (minValidLength > 0) {
                                    int len = String.valueOf((Short) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Short) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (float) f);
                                    } else {
                                        double f = (Short) o * offset;
                                        tField.set(target, (float) f);
                                    }
                                } else {
                                    double f = (Short) o * offset;
                                    tField.set(target, (float) f);
                                }


                            } else if (type == int.class) {
                                if (minValidLength > 0) {
                                    int len = String.valueOf((Integer) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Integer) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (float) f);
                                    } else {
                                        double f = (Integer) o * offset;
                                        tField.set(target, (float) f);
                                    }
                                } else {
                                    double f = (Integer) o * offset;
                                    tField.set(target, (float) f);
                                }
                            } else if (type == long.class) {
                                if (minValidLength > 0) {
                                    int len = String.valueOf((Long) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Long) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (double) f);
                                    } else {
                                        double f = (Long) o * offset;
                                        tField.set(target, (double) f);
                                    }
                                } else {
                                    double d = (Long) o * offset;

                                    tField.set(target, d);
                                }
                            }


                        } else {
                            tField.set(target, o);
                        }

                    } else if (field.getClass().isPrimitive() && field.getType().isArray()) {
                        // 基础数据类型 且 是数组
                    } else if (List.class.isAssignableFrom(field.getType())) {
                        // 集合类型
                        //读取属性的注解是否引用其他字段的长度
                        if (field.isAnnotationPresent(RefNumFlag.class) && !field.isAnnotationPresent(DynamicsClassDef.class)) {
                            List<?> temp = (List<?>) o;
                            RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                            String refField = refNumFlag.value();
                            Class<?> clazz1 = target.getClass();
                            Field nameField = clazz1.getDeclaredField(refField);
                            Type genericType = field.getGenericType();
                            Type targetType = tField.getGenericType();
                            nameField.setAccessible(true);
                            if (genericType instanceof ParameterizedType) {
                                List<Object> dsts = new ArrayList<>();
                                ParameterizedType pt = (ParameterizedType) genericType;
                                Type[] actualTypes = pt.getActualTypeArguments();
                                ParameterizedType dspt = (ParameterizedType) targetType;
                                Type[] dstTypes = dspt.getActualTypeArguments();
                                if (actualTypes.length > 0 && actualTypes != null) {
                                    for (int i = 0; i < temp.size(); i++) {
                                        Object src = temp.get(i);
                                        Object dst = null;
                                        if (src instanceof Short) {
                                            dst = (Short) src;
                                        } else if (src instanceof Integer) {
                                            dst = (int) src;
                                        } else {
                                            Class<?> cls = Class.forName(dstTypes[0].getTypeName());
                                            dst = cls.newInstance();
                                            convoterBean(src, dst);
                                        }
                                        dsts.add(dst);
                                    }
                                    tField.set(target, dsts);
                                }
                            }
                        }

                    } else if (field.getType() == String.class) {
                        //类型为字符串
//					 try {
//						String s = (String)o;
//						String s1 =  new String(s.getBytes());
                        tField.set(target, o);
//					 }catch(Exception e) {
//						 e.printStackTrace();
//					 }
                    } else {
                        //其他对象类型
                        if (field.isAnnotationPresent(DynamicsClassDef.class)) {
                            DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                            String classtype = dynamicsClassDef.classtype();
                            DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                            String fieldname = dependencyDef.value();
                            Field tField2 = target.getClass().getDeclaredField(fieldname);
                            tField2.setAccessible(true);

                            Short key = (Short) tField2.get(target);
                            Class<?> cls = DynamicsClassMap.getDto(classtype, key);
                            Object obj = cls.newInstance();
                            convoterBean(o, obj);
                            tField.set(target, obj);
                        } else {
                            Class<?> cls = Class.forName(tField.getType().getName());
                            Object obj = cls.newInstance();

                            convoterBean(o, obj);
                            tField.set(target, obj);
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.out.println("----convoterBean Exception " + e + "  tField " + tField + " object " + source.getClass().getName());
        }
    }

    /**
     * 将source对象转成 target(Android对象)
     *
     * @param fList 对source 属性排序的属性列表
     ****/
    public static void convoterBean(Object source, List<Field> fList, Object target) {
        Field tField = null;
        try {
            for (Field field : fList) {
                field.setAccessible(true);
                Object o = field.get(source);
                if (o == null) {
                    continue;
                }
//                System.out.println("---------convoterBean fieldName " + field.getName());
                OffsetDef offsetDef = null;
                if (field.isAnnotationPresent(OffsetDef.class)) {
                    offsetDef = field.getAnnotation(OffsetDef.class);
                }
                //获取目标对象指定的属性
                tField = target.getClass().getDeclaredField(field.getName());
                tField.setAccessible(true);
                if (field.isAnnotationPresent(Order.class)) {
                    if (field.getType().isPrimitive() && !field.getType().isArray()) {
                        //如果属性添加了自定义注解 offset

                        Class<?> type = field.getType();
                        if (offsetDef != null) {
                            double offset = offsetDef.value();
                            int type1 = offsetDef.type();
                            int minValidLength = offsetDef.minValidLength();
                            //startindex
                            if (type == byte.class) {
                                tField.set(target, o);
                            } else if (type == short.class) {

                                if (minValidLength > 0) {
                                    int len = String.valueOf((Short) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Short) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (float) f);
                                    } else {
                                        double f = (Short) o * offset;
                                        tField.set(target, (float) f);
                                    }
                                } else {
                                    double f = (Short) o * offset;
                                    tField.set(target, (float) f);
                                }
                            } else if (type == int.class) {
                                if (minValidLength > 0) {
                                    int len = String.valueOf((Integer) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Integer) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (float) f);
                                    } else {
                                        double f = (Integer) o * offset;
                                        tField.set(target, (float) f);
                                    }
                                } else {
                                    double f = (Integer) o * offset;
                                    tField.set(target, (float) f);
                                }
                            } else if (type == long.class) {
                                if (minValidLength > 0) {
                                    int len = String.valueOf((Long) o).length();
                                    if (len < minValidLength) {
                                        int subtract = minValidLength - len;
                                        double f = (Long) o * Math.pow(10, subtract) * offset;
                                        tField.set(target, (double) f);
                                    } else {
                                        double f = (Long) o * offset;
                                        tField.set(target, (double) f);
                                    }
                                } else {
                                    double d = (Long) o * offset;

                                    tField.set(target, d);
                                }
                            }
                        } else {
                            tField.set(target, o);
                        }

                    } else if (field.getClass().isPrimitive() && field.getType().isArray()) {
                        // 基础数据类型 且 是数组
                    } else if (List.class.isAssignableFrom(field.getType())) {
                        // 集合类型
                        //读取属性的注解是否引用其他字段的长度
                        if (field.isAnnotationPresent(RefNumFlag.class) && !field.isAnnotationPresent(DynamicsClassDef.class)) {
                            List<?> temp = (List<?>) o;
                            RefNumFlag refNumFlag = field.getAnnotation(RefNumFlag.class);
                            String refField = refNumFlag.value();
                            Class<?> clazz1 = target.getClass();
                            Field nameField = clazz1.getDeclaredField(refField);
                            Type genericType = field.getGenericType();
                            Type targetType = tField.getGenericType();
                            nameField.setAccessible(true);
                            if (genericType instanceof ParameterizedType) {
                                List<Object> dsts = new ArrayList<>();
                                ParameterizedType pt = (ParameterizedType) genericType;
                                Type[] actualTypes = pt.getActualTypeArguments();
                                ParameterizedType dspt = (ParameterizedType) targetType;
                                Type[] dstTypes = dspt.getActualTypeArguments();
                                if (actualTypes.length > 0 && actualTypes != null) {
                                    for (int i = 0; i < temp.size(); i++) {
                                        Object src = temp.get(i);
                                        Object dst = null;
                                        if (src instanceof Short) {
                                            dst = (Short) src;
                                        } else if (src instanceof Integer) {
                                            dst = (int) src;
                                        } else {
                                            Class<?> cls = Class.forName(dstTypes[0].getTypeName());
                                            dst = cls.newInstance();
                                            convoterBean(src, dst);
                                        }
                                        dsts.add(dst);
                                    }
                                    tField.set(target, dsts);
                                }
                            }
                        }
                    } else if (field.getType() == String.class) {
                        //类型为字符串
//					 try {
//						String s = (String)o;
//						String s1 =  new String(s.getBytes());
                        tField.set(target, o);
//					 }catch(Exception e) {
//						 e.printStackTrace();
//					 }
                    } else {
                        //其他对象类型
                        if (field.isAnnotationPresent(DynamicsClassDef.class)) {
                            DynamicsClassDef dynamicsClassDef = field.getAnnotation(DynamicsClassDef.class);
                            String classtype = dynamicsClassDef.classtype();
                            DependencyDef dependencyDef = field.getAnnotation(DependencyDef.class);
                            String fieldname = dependencyDef.value();
                            Field tField2 = target.getClass().getDeclaredField(fieldname);
                            tField2.setAccessible(true);

                            Short key = (Short) tField2.get(target);
                            Class<?> cls = DynamicsClassMap.getDto(classtype, key);
                            Object obj = cls.newInstance();
                            convoterBean(o, obj);
                            tField.set(target, obj);
                        } else {
                            Class<?> cls = Class.forName(tField.getType().getName());
                            Object obj = cls.newInstance();

                            convoterBean(o, obj);
                            tField.set(target, obj);
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.out.println("----convoterBean Exception " + e + "  tField " + tField);
        }
    }


    public static byte[] convoter(Byte[] bytes) {
        byte[] bs = new byte[bytes.length];
        int i = 0;
        for (Byte b : bytes) {
            bs[i++] = b;
        }
        return bs;
    }

    /**
     * 16进制转2进制
     *
     * @param hex
     * @return
     */
    public static String convertHexToBinary(String hex) {
        // 将16进制数转换为10进制Integer
        int decimal = Integer.parseInt(hex, 16);
        // 将10进制数转换为2进制字符串
        return Integer.toBinaryString(decimal);
    }
}
