package com.cusc.adas.v2x.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericTypeUtil {
	public static Class<?> getListGenericType(Class<?> clazz, String fieldName) 
            throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        Type genericType = field.getGenericType();
        
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType) genericType;
            Type[] actualTypes = pt.getActualTypeArguments();
            if (actualTypes.length > 0) {
                return (Class<?>) actualTypes[0];
            }
        }
        return Object.class;
    }
}
