package com.cusc.adas.v2x.selfdefine.vo;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.vo.Position;

/**
 * @author huangml
 */
public class SelfDefineDetail {

    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 36)
    private String rvVehicleId;

    //预警类型
    @Order(2)
    private short type;

    //GNSS时间戳
    @Order(3)
    @FieldDef(type = "TIMESTAMP", isArray = false, length = 8)
    private long timestampGNSS;

    //主车经纬度
    @Order(4)
    private Position location;

    //主车速度 0.01 m/s
    @Order(5)
    @OffsetDef(value = 0.036)
    private int speed;

    //主车航向角
    @Order(6)
    @OffsetDef(value=0.0001,minValidLength=7)
    private long heading;

    //RV远车经纬度
    @Order(7)
    private Position rvLocation;

    //RV远车速度 单位：0.01 m/s
    @Order(8)
    @OffsetDef(value = 0.036)
    private int rvSpeed;

    //RV方向
    @Order(9)
    @OffsetDef(value=0.0001,minValidLength=7)
    private long rvHeading;

    //预警级别
    @Order(10)
    private short level;

    //预警距离 ，自车与远车的距离，单位：cm
    @Order(11)
    @OffsetDef(value=0.01)
    private int distance;
}
