package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.DependencyDef;
import com.cusc.adas.v2x.utils.DynamicsClassDef;
import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.NumFlag;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position2D;

import java.util.List;

/**
 * 8.5 CLOUD2VEH_ADVICE_GUIDANCE = 19
 * 路线规划指令
 ***/
public class RoutePlan {

    //    事件唯一标识
    @Order(1)
    @FieldDef(type="BYTE",isArray=true,length=36)
    private String uuid;
    //事件生成时间戳
    @Order(2)
    @FieldDef(type="TIMESTAMP",isArray=false,length=8)
    private long timestamp;
    //告警类型 固定值为 6601，用于匹配 RSI
    @Order(3)
    private int alertType;
    //路线长度
    @Order(4)
    private long totalLen;

    //目的地位置
    @Order(5)
    private Position2D destLocation;
    //目的地停车航向角
    @Order(6)
    @OffsetDef(value=0.0001)
    private long destHeading;
    //    路线分段个数
    @Order(7)
    private int pathNum;

    //路线规划数据 长度
    @Order(8)
    @NumFlag
    private int dataLen;
    //长度为 N 个字节，其中 N 为路线规划数据长度，路线规划数据结构内 包含多种颜色的集合
    @Order(9)
    @RefNumFlag(value="dataLen")
    private List<PathPath> pathList;

}
