package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;

/**
 * 通用 RSI 预警中交通事件和交通标志信息
 */
public class RSISDetail {
		
	//事件唯一标识
	@Order(1)
	@FieldDef(type="BYTE",isArray=true,length=36)
	private String  uuid;
	//事件生成时间 戳
	@Order(2)
	@FieldDef(type="TIMESTAMP",isArray=false,length=8)
	private long  timestamp;
	//交通事件位置 点  用来给地图画
	@Order(3)
	private Position eventPosition;
	
	//道路交通事件 信息类型
	@Order(4)
	private int eventType;
	
	//事件来源
	@Order(5)
	private short eventSource;
	
	//事件（影响） 半径
	@Order(6)
	@OffsetDef(value = 0.1)
	private  int eventRadius;
	
	//关联路段数量
	@Order(7)
	private int referenceLinksNum;
	
	//关联路段数量   没数据
//	@Order(8)
//	private RelSetp referenceLinks;
	
	//优先级
	@Order(8)
	private short priority;
	
	//交通事件/标  志作用中心线 坐标点
	@Order(9)
	private Position alertPath;
	//交通标志/事  件作用中心线 范围半径
	@Order(10)
	@OffsetDef(value = 0.1)
	private int pathRadius;
	//事件状态
	@Order(11)
	private short status;
	
	//自定义内容长度
	@Order(12)
	private int userdefinedDataLength;
	//这里用来拿到人的感知物id
	@Order(13)
	//自定义内容  此处代表人的ptcid
	@RefNumFlag(value="userdefinedDataLength")
	private String userdefinedData;


	public int getEventType() {
		return eventType;
	}
}
