package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;

/**
 * 车道方向建议车速
 * @author huangml
 *
 */
public class LaneAdviceSpeed {
	
	//车速上限 单位：0.01 m/s
	@Order(1)
	@OffsetDef(value=0.036,type=2)
	private int spdMax;
	//车速下限 单位：0.01 m/s
	@Order(2)
	@OffsetDef(value=0.036,type=2)
	private int spdMin;
	//建议车速 单位：0.01 m/s
	@Order(3)
	@OffsetDef(value=0.036,type=2)
	private int spdExp;
	//通行行为 单位：0.01 m/s
	@Order(4)
	@OffsetDef(value=0.036,type=2)
	private short maneuver;
	//绿灯通过前方 路口数量  车辆绿灯通过前方路口数量，其中 0 表示无法绿灯通过前 方路口
	@Order(5)
	private short numIntersection;
	
}
