package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;

import java.util.List;

/**
 * 前向碰撞预警
 *
 * @author huangml
 */
public class FawWarnning {
    //事件唯一标识
    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 36)
    private String uuid;
    //事件生成时间 戳
    @Order(2)
    @FieldDef(type = "TIMESTAMP", isArray = false, length = 8)
    private long timestamp;

    //告警类型 固定值为 6518
    @Order(3)
    private int alertType = 6518;
    //告警半径 单位：dm
    @Order(4)
    @OffsetDef(value = 0.1)
    private int alertRadius;

    //路径点数量
    @Order(5)
    private short pointNum;

    //告警路径
    @Order(6)
    @RefNumFlag(value = "pointNum")
    private List<Position> alertPath;

    //碰撞预警目标 类型 0：行人；1：非机动车；2：机动车；3：其他； 0xFF 表示缺省，缺省则告警功能失效
    @Order(7)
    private short objType;

    //碰撞告警类型
    @Order(8)
    private short fcwLevel;

    //碰撞距离 单位：cm
    @Order(9)
    @OffsetDef(value = 0.01)
    private int fcwDistance;

    //碰撞预警目标 所在车道
    @Order(10)
    private short fcwLaneId;

}
