package com.cusc.adas.v2x.clouddecision.vo;

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;

/**
 * 异常车辆预警
 * @author huangml
 *
 */
public class AbnormalVehicle {
	//事件唯一标识
	@FieldDef(type="BYTE",isArray=true,length=36)
	@Order(1)
	private String  uuid;
	//事件生成时间 戳
	@Order(2)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private long  timestamp;
	//告警类型 用于匹配 RSI，取值为 6503，6505，6506，6507，6508
	@Order(3)
	private int alertType;
	//告警半径
	@Order(4)
	@OffsetDef(value=0.1)
	private int alertRadius;
	//路径点数量
	@Order(5)
	private short pointNum;
	//告警路径
	@Order(6)
	@RefNumFlag(value="pointNum")
	private List<Position> alertPath;
	//车速
	@Order(7)
	@OffsetDef(value=0.036,type=2)
	private int  velocity;
	//航向角
	@Order(8)
	@OffsetDef(value=0.0001)
	private long  heading;
}
