package com.cusc.adas.v2x.clouddecision.dto;

import com.cusc.adas.v2x.dto.PositionDto;
import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;

/**
 * 通用 RSI 预警中交通事件和交通标志信息
 *
 * @author huangml
 */
public class RSISDetailDto {

    //事件唯一标识
    private String uuid;
    //事件生成时间 戳
    private long timestamp;
    //交通事件位置 点
    private PositionDto eventPosition;

    //道路交通事件 信息类型
    private int eventType;

    //事件来源
    private short eventSource;

    //事件（影响） 半径
    private float eventRadius;

    //关联路段数量
    private int referenceLinksNum;

    //关联路段数量
//	@Order(8)
    private RelSetpDto referenceLinks;

    //优先级
    private short priority;

    //交通事件/标  志作用中心线 坐标点
    private PositionDto alertPath;
    //交通标志/事  件作用中心线 范围半径
    private float pathRadius;
    //事件状态
    private short status;

    //自定义内容长度
    private int userdefinedDataLength;
	//这里用来拿到人的感知物id
    private String userdefinedData;


    public String getUserdefinedData() {
        return userdefinedData;
    }

    public PositionDto getEventPosition() {
        return eventPosition;
    }

    public int getEventType() {
        return eventType;
    }
}
