package com.cusc.adas.v2x.client;

import java.net.InetSocketAddress;

import com.cusc.adas.v2x.utils.HexStringToByteArray;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.CharsetUtil;

public class UDPClient {
	private final String host;
    private final int port;

    public UDPClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() throws Exception {
        EventLoopGroup group = new NioEventLoopGroup();

        try {
            Bootstrap b = new Bootstrap();
            b.group(group)
                    .channel(NioDatagramChannel.class)
                    .handler(new ChannelInitializer<DatagramChannel>() {
                        @Override
                        protected void initChannel(DatagramChannel ch) throws Exception {
                            ch.pipeline().addLast(new UDPClientHandler());
                        }
                    });

            ChannelFuture f = b.bind(0).sync();
            System.out.println("Client started");

            // 发送消息给服务端
            String message = "F20000000015018cb864640000000000";
            byte[] bytes = HexStringToByteArray.hexStringToByteArray(message);
            DatagramPacket packet = new DatagramPacket(Unpooled.copiedBuffer(bytes),
                    new InetSocketAddress(host, port));
            f.channel().writeAndFlush(packet).sync();

            f.channel().closeFuture().sync();
        } finally {
            group.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        String host = "127.0.0.1";
        int port = 8082;
        UDPClient client = new UDPClient(host, port);
        client.start();
    }

}
