plugins {
    alias(libs.plugins.android.library)
    alias(libs.plugins.kotlin.android)
    id("maven-publish")
    id("signing")
}



android {
    namespace = "com.cusc.adas.v2x"
    compileSdk = 35

    defaultConfig {
        minSdk = 29

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    packaging {
        jniLibs {
            excludes.add("META-INF/*******")
        }
        resources {
            excludes.addAll(
                listOf(
                    "META-INF/*******",
                    "META-INF/INDEX.LIST",
                    "META-INF/io.netty.versions.properties"
                )
            )
        }
    }
}


publishing {
    publications {
        register<MavenPublication>("earlywarning") {
            groupId = "io.github.killcow"
            artifactId = "earlywarning"
            version = "1.0"

//            afterEvaluate {
//                from(components["java"])
//            }
            // 如果是Android库模块
            artifact(layout.buildDirectory.dir("outputs/aar/earlywarning-release.aar"))
            // 如果是Java库模块
            // artifact("$buildDir/libs/your-library.jar")
             //发布到本地仓库
            repositories {
                maven {
                    name = "MyRepo"
                    url = uri(layout.buildDirectory.dir("repo"))
                }
            }
        }
    }
}

// 配置签名（可选但推荐）
//signing {
//    sign(publishing.publications["earlywarning"])
//}

dependencies {
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    api("io.netty:netty-all:4.1.92.Final")
    //事件分发
    api("org.greenrobot:eventbus:3.3.1")

    implementation("com.alibaba:fastjson:2.0.56")
    implementation("org.fusesource.mqtt-client:mqtt-client:1.12")
    implementation("org.eclipse.paho:org.eclipse.paho.client.mqttv3:1.2.5")
    implementation("org.bouncycastle:bcprov-jdk15on:1.70")

}