package com.cusc.adas.v2x.vo;

import com.cusc.adas.v2x.utils.DependencyDef;
import com.cusc.adas.v2x.utils.DynamicsClassDef;
import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

//8.5 云端决策建议信息数据结构
public class VehAdviceInfo<T>  {
    //车辆编号
    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 8)
    private String vehicleId;

    //消息标识
    @Order(2)
    @FieldDef(type = "BYTE", isArray = true, length = 8)
    private long seq;

    //建议类型
    @Order(3)
    private short adviceType;
    //    事件分类
    @Order(4)
    private short eventType;
    //    车速建议
    @Order(5)
    @OffsetDef(value = 0.01)
    private int spdExp;

    //    加速度建议
    @Order(6)
    private int accExp;

    //    控车变道建 议转向状态
    @Order(7)
    private short instructDirection;

    //    命令长度
    @Order(8)
    private int dataLen;
    //各项功能对应的 adviceType
    @Order(9)
    @DynamicsClassDef(classtype="CloudDecision")
    @DependencyDef(value="adviceType")
    private T adviceData;

}
