package com.cusc.adas.v2x.vo;

import java.util.List;

import com.cusc.adas.v2x.utils.NumFlag;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

/**
 * 车辆自动驾驶信息
 * @author huangml
 *
 */
public class AutomaticDriveInfo {
	//执行云端控制命令编号
	@Order(1)
	private  long  cloudMessageId;
	//自动驾驶需求加速度
	@Order(2)
	private  int accelCmd;
	//自动驾驶需求扭矩
	@Order(3)
	private  long torqueCmd;
	//自动驾驶需求速度
	@Order(4)
	private  int velocityCmd;
	//规划-位置点轨 迹数量
	@Order(5)
	@NumFlag
	private  int planningLocNum;
	//规划-位置点轨 迹列表
	@Order(6)
	@RefNumFlag(value="planningLocNum")
	private List<TracePoint> planningLocs;
	//决策-换道
	@Order(7)
	private short decisionLaneChange;
	//加减速
	@Order(8)
	private short decisionAccel;
	//决策-转向
	@Order(9)
	private short decisionTurnSignal;
	
	//决策-车辆状态
	@Order(10)
	private short  decisionVehicleStatus;
	
	//感知目标个数
	@Order(11)
	@NumFlag
	private short   detectionLen;
	
	//感知目标数据
	@RefNumFlag(value="detectionLen")
	@Order(12)
	private List<TrajectoryInfo> detectionData;
	//自动驾驶系统故障
	@Order(13)
	private int autoDrivingSysFault;
	
	//电子手刹状态
	@Order(14)
	private short epbFlag;
	//自定义字段长度
	@Order(15)
	private short userdefinedDataLength;
	//自定义字段内容
	@Order(16)
	private byte[] userdefinedData;
	
}
