package com.cusc.adas.v2x.utils;

import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttSubscriber {
	private static final String BROKER = "tcp://172.29.128.39:31883";
    private static final String CLIENT_ID = "JavaSubscriber";
    private static final String TOPIC = "vehicle/{vehicleId}/status";

    public static void main(String[] args) {
        try {
            MqttClient client = new MqttClient(BROKER, CLIENT_ID);
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(true);
            client.connect(options);
            System.out.println("Connected to broker: " + BROKER);

            client.subscribe(TOPIC, (topic, message) -> {
                System.out.println("Received message: " + new String(message.getPayload()) + " from topic: " + topic);
            });

        } catch (MqttException e) {
            e.printStackTrace();
        }
    }

}
