package com.cusc.adas.v2x.server;





import com.cusc.adas.v2x.assist.vo.AssistMessage;
import com.cusc.adas.v2x.clouddecision.vo.CloudDecisionMessage;
import com.cusc.adas.v2x.dto.VehicleBodyDto;
import com.cusc.adas.v2x.selfdefine.vo.SelfDefineMessage;
import com.cusc.adas.v2x.utils.Parse;
import com.cusc.adas.v2x.vehiclesubscribe.vo.VehicleSubscribeMessage;
import com.cusc.adas.v2x.vo.VehicleMessage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.CharsetUtil;

public class UdpServerHandler extends SimpleChannelInboundHandler<DatagramPacket> {
	//public static final Logger log = Logger.getLogger(UdpServerHandler.class);
	 @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        //log.info("UDP通道已经连接");
        System.out.println("UDP通道已经连接");
        super.channelActive(ctx);
    }
	
	
	@Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        // 处理接收到的数据包，例如打印消息内容或回复客户端等。
		
		// ByteBuf buf = (ByteBuf) msg;
		
		 
//        String message = packet.content().toString();
//        byte[] req = new byte[buf.readableBytes()];
		ByteBuf buf = (ByteBuf) packet.copy().content();
		byte[] req = new byte[buf.readableBytes()];
        buf.readBytes(req);
        String body = new String(req, CharsetUtil.UTF_8);
        String hexString = Parse.byteToHexString(req);
       // byte[] bytes = HexStringToByteArray.hexStringToByteArray(body);
        //车辆运行状态
        if(hexString.substring(10,12).equals("15")) {
	        ByteBuf byteBuf = Unpooled.wrappedBuffer(req);
	        VehicleMessage  vehicleMessage = Parse.parse(byteBuf,new VehicleMessage()); 
	        System.out.println("Received message: " + vehicleMessage);
	        VehicleBodyDto vehicleBodyDto =  new VehicleBodyDto();
	        Parse.convoterBean(vehicleMessage.getVehicleMessageBody(), vehicleBodyDto);
	        
	        System.out.println("Received message: " + vehicleBodyDto);
	        
        }else if(hexString.substring(10,12).equals("36")) {
        	//车辆功能订阅信息
       	 ByteBuf byteBuf = Unpooled.wrappedBuffer(req);
       	 VehicleSubscribeMessage  vehicleSubscribeMessage = Parse.parse(byteBuf,new VehicleSubscribeMessage()); 
	     System.out.println("Received message: " + vehicleSubscribeMessage);

       }else if(hexString.substring(10,12).toUpperCase().equals("3C")) {
    	   //实时决策建议
        	 ByteBuf byteBuf = Unpooled.wrappedBuffer(req);
        	 CloudDecisionMessage  cloudDecisionMessage = Parse.parse(byteBuf,new CloudDecisionMessage()); 
 	        System.out.println("Received message: " + cloudDecisionMessage);
// 	        VehicleBodyDto vehicleBodyDto =  new VehicleBodyDto();
// 	        Parse.convoterBean(vehicleMessage.getVehicleMessageBody(), vehicleBodyDto);       
// 	        System.out.println("Received message: " + vehicleBodyDto);
        }else if(hexString.substring(10,12).toUpperCase().equals("3E")) {
        	//辅助功能
        	 ByteBuf byteBuf = Unpooled.wrappedBuffer(req);
        	 AssistMessage  assistMessage = Parse.parse(byteBuf,new AssistMessage()); 
 	        System.out.println("Received message: " + assistMessage);
        }else if(hexString.substring(10,12).toUpperCase().equals("5E")) {
        	//下行自定义功能
       	 ByteBuf byteBuf = Unpooled.wrappedBuffer(req);
       	SelfDefineMessage  selfDefineMessage = Parse.parse(byteBuf,new SelfDefineMessage()); 
	        System.out.println("Received message: " + selfDefineMessage);
       }
        
       
        
        // 回复客户端消息（可选）
        // ctx.writeAndFlush(new DatagramPacket(Unpooled.copiedBuffer("Response", io.netty.util.CharsetUtil.UTF_8), packet.sender()));
    }
}
