package com.cusc.adas.v2x.selfdefine.dto;

import com.cusc.adas.v2x.dto.PositionDto;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;

/**
 * 下行自定义功能信息（CLOUD2VEH_TEST）数据结构应符合表 71 的要求。
 */
public class SelfDefineDetailDto {

    //RV远车id 用于让地图变红
    private String rvVehicleId;

    //预警类型
    private short type;

    //GNSS时间戳
    private long timestampGNSS;

    //主车经纬度
    private PositionDto location;

    //主车速度
    private double speed;

    //主车航向角
    private double heading;

    //RV远车经纬度
    private PositionDto rvLocation;

    //RV远车速度
    private double rvSpeed;

    //RV方向
    private double rvHeading;

    //预警级别
    private short level;

    //预警距离
    private float distance;

    public PositionDto getLocation() {
        return location;
    }

    public String getRvVehicleId() {
        return rvVehicleId;
    }

    public void setRvVehicleId(String rvVehicleId) {
        this.rvVehicleId = rvVehicleId;
    }

    public double getRvSpeed() {
        return rvSpeed;
    }

    public double getRvHeading() {
        return rvHeading;
    }

    public short getType() {
        return type;
    }
}
