package com.cusc.adas.v2x.dto;

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.NumFlag;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

/**
 * 车辆辅助驾驶信息及状态信息
 * @author huangml
 *
 */
public class VehicleStatusInfoDto {
	@Order(1)
	//ABS 状态
	private short absFlag;
	//TCS 状态
	@Order(2)
	private short tcsFlag;
	//ESP 状态
	@Order(3)
	private short espFlag;
	//LKA 状态
	@Order(4)
	private short lkaFlag;
	//ACC 工作模式
	@Order(5)
	private short accMode;
	//FCW 状态
	@Order(6)
	private short fcwFlag;
	//LDW 状态
	@Order(7)
	private short ldwFlag;
	//AEB 状态
	@Order(8)
	private short aebFlag;
	//LCA 状态
	@Order(9)
	private short lcaFlag;
	//DMS 状态
	@Order(10)
	private short dmsFlag;
	//里程
	@Order(11)
	private double mileage;
	//sweeping状态
	@Order(12)
	private short sweepingFlag;
	//watering状态
	@Order(13)
	private short wateringFlag;
	// 车辆运行状态数据 2-车辆辅助驾驶系统信息及其他状态信息数据结构（续)
	//油量 对应车辆油量表读数，单位：0.1 L，
	@Order(14)

	private float fuelGauge;
	//电池剩余电量 0.01%，
	@Order(15)

	private float soc;
	//电池温度 [0..200]，单位：摄氏度（℃），
	//数据偏移量 100，表示-100℃～100℃ ，0xFF 表示缺省
	@Order(16)
	private short temperature;

	//预计续航里程 单位：千米（km），
	@Order(17)
	private double endurance;

	//车辆故障状态
	@Order(18)
	private int vehFault;

	//电机转速
	@Order(19)
	private int motorspeed;
	//电机转矩
	@Order(20)
	private double motortorque;
	//运行模式 车辆运行模式，1：纯电驱动模式；2：混合驱动 模式；3：行车充电模式；4：能量回收模式；5：停车充电模式；6： 能量混合回充模式；
	@Order(21)
	private short vehMode;
	
	//充电状态 1：未充电；2：充电准备；3：正在充电；4：充电故障；5：充电结束； 0xFF 表示缺省
	@Order(22)
	private short chargeState;
	//动力电池实时电压
	@Order(23)
	private int battVol;
	//动力电池实时电流
	@Order(24)
	private int battCur;
	
	//喇叭状态
	@Order(25)
	private short hornState;
	//车轮数
	@Order(26)
	@NumFlag
	private short  wheelNum;
	//轮速 表示车轮线速度，单位：0.01 m/s，
	//数据偏移量 200，表示-200.00 m/s～200.00 m/s，
	@Order(27)

	private List<Integer>  wheelVelocity;
	//胎压
	@Order(28)

	private List<Integer>  tirePressure;
	//车灯状态 BIT2 = 左转灯 BIT3 = 右转灯
	@Order(30)
	private int lights;
	//车门状态
	@Order(31)
	private int doors;
	//自定义字段长度
	@Order(32)
	@NumFlag
	private short userdefinedDataLength;
	//自定义字段内容
	@Order(33)
	private String userdefinedData;

	public float getSoc() {
		return soc;
	}

	public int getLights() {
		return lights;
	}
}
