package com.cusc.adas.v2x.clouddecision.vo;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;

import java.util.List;

/**
 * 信号灯路口车速引导
 *
 * @author huangml
 */
public class TrafficLightInfo {
    //事件唯一标识
    @Order(1)
    @FieldDef(type = "BYTE", isArray = true, length = 36)
    private String uuid;
    //事件生成时间 戳
    @Order(2)
    @FieldDef(type = "TIMESTAMP", isArray = false, length = 8)
    private long timestamp;
    //告警类型 固定值为 6523
    @Order(3)
    private int alertType = 6523;
    //有效标识 0：失效；1：有效
    @Order(4)
    private short valid;
    //命令标识 0：失效；1：引导；2：停车指令；3：启动指令
    @Order(5)
    private short type;
    //车辆所在位置 到停止线距离 单位：0.01m
    @Order(6)
    @OffsetDef(value = 0.01)
    private int d2StopLine;
    //车道方向建议 速度组数 0 表示无效，不发送车道方向建议车速数据
    @Order(7)
    private short spdExpNum;
    //N 组车道方向建议车速信息，
    @Order(8)
    @RefNumFlag(value = "spdExpNum")
    private List<LaneAdviceSpeed> spdExps;
    //车速上限
    @Order(9)
    private int spdMax;
    //车速下限
    @Order(10)
    private int spdMin;
    //建议车速
    @Order(11)
    private int spdExp;
    //通行行为
    private short maneuver;
    //绿灯通过前方路口数量
    private short numIntersection;
}
