package com.cusc.adas.v2x.clouddecision.vo;
/**
 * 动态车道级限速
 * @author huangml
 *
 */

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.OffsetDef;
import com.cusc.adas.v2x.utils.Order;
import com.cusc.adas.v2x.utils.RefNumFlag;
import com.cusc.adas.v2x.vo.Position;
import com.cusc.adas.v2x.vo.SpeedLimit;


public class AutoSpeedLimit {
	//事件唯一标识
	@Order(1)
	@FieldDef(type="BYTE",isArray=true,length=36)
	private String  uuid;
	//事件生成时间 戳
	@Order(2)
	@FieldDef(type="TIMESTAMP",isArray=false,length=8)
	private long  timestamp;
	//告警类型 固定值为 6517
	@Order(3)
	private int alertType;
	//告警半径 单位：dm
	@Order(4)
	@OffsetDef(value=0.1)
	private int alertRadius;
	//路径点数量 告警路径中路径点数量，取值为 0 时，不发送告警路径
	@Order(5)
	private short pointNum;
	//告警路径
	@Order(6)
	@RefNumFlag(value="pointNum")
	private List<Position> alertPath;
	//车道数量
	@Order(7)
	private short laneNum;
	//限速数据
	@Order(8)
	@RefNumFlag(value="laneNum")
	private List<SpeedLimit> speedLmt;
	
	
	
}
